
/*
 *   ALSA sequencer Ports
 *   Copyright (c) by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "driver.h"
#include "seq_ports.h"

/*

   registration of client ports

 */


/* return pointer to port structure */
client_port_t *snd_seq_get_port_ptr(client_port_t ** ports, int num)
{
	client_port_t *p = *ports;

	if (p != NULL) {
		if (p->port == num)
			return p;
		while (p->next) {
			p = p->next;
			if (p->port == num)
				return p;
		}
	}
	return NULL;		/* not found */
}

/* create a port, port number is returned (-1 on failure) */
int snd_seq_create_port(client_port_t ** ports)
{
	client_port_t *p = *ports;
	client_port_t *new_port;
	int num = -1;

	/* create a new port */
	new_port = snd_malloc(sizeof(client_port_t));
	if (new_port) {
		new_port->port = -1;
		strcpy(new_port->name, "");
		new_port->next = NULL;
	} else {
		snd_printk("malloc failed for registering client port\n");
		return -1;	/* failure, out of memory */
	}

	/* add the port to the list of registed ports for this client */
	if (*ports == NULL) {
		/* first port in the list */
		snd_printk("1st port\n");
		*ports = new_port;
		num = 0;
	} else {
		snd_printk("2nd+ port\n");
		/* add to end of list */
		p = *ports;
		num = p->port;
		while (p->next) {
			p = p->next;
			if (p->port > num)
				num = p->port;
		}
		p->next = new_port;
		num++;
	}

	/* store the port number in the port */
	new_port->port = num;
	sprintf(new_port->name, "port-%d", num);

	return num;
}

/* set port info fields */
int snd_seq_set_port_info(client_port_t * port, snd_seq_port_info_t * info)
{
	if ((port == NULL) || (info == NULL))
		return -1;

	/* set port name */
	strncpy(port->name, info->name, SND_SEQ_MAX_PORT_NAME);
	
	/* set capabilities */
	port->capability = info->capability;
	
	/* set port type */
	port->port_type = info->port_type;
	
	return 0;
}

/* get port info fields */
int snd_seq_get_port_info(client_port_t * port, snd_seq_port_info_t * info)
{
	if ((port == NULL) || (info == NULL))
		return -1;

	/* get port name */
	strncpy(info->name, port->name, SND_SEQ_MAX_PORT_NAME);
	
	/* get capabilities */
	info->capability = info->capability;
	
	/* get port type */
	info->port_type = port->port_type;

	return 0;
}
