/*
 *  ALSA sequencer Memory Manager
 *  Copyright (c) by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SND_SEQ_MEMORYMGR_H
#define __SND_SEQ_MEMORYMGR_H

#include "seq.h"


/* container for sequencer event (internal use)*/
typedef struct snd_seq_event_cell_t {
	struct snd_seq_event_cell_t *ptr_l;	/* pointer to left leaf */
	struct snd_seq_event_cell_t *ptr_r;	/* pointer to right leaf */
	snd_seq_event_t event;
} snd_seq_event_cell_t;
	


/* release this cell */
extern void snd_seq_cell_free(snd_seq_event_cell_t* cell);

/* return pointer to cell, NULL on failure */
extern snd_seq_event_cell_t *snd_seq_cell_alloc(void);

/* duplicate event, NULL on failure */
extern snd_seq_event_cell_t *snd_seq_event_dup(snd_seq_event_t *event);
extern snd_seq_event_cell_t *snd_seq_event_dup_from_user(snd_seq_event_t *event);

/* duplicate event cell, NULL on failure */
extern snd_seq_event_cell_t *snd_seq_cell_dup(snd_seq_event_cell_t *event);

/* return number of unused (free) cells */
extern int snd_seq_unused_cells(void);

/* return total number of allocated cells */
extern int snd_seq_total_cells(void);




/* init memory, allocate room specified number of events */
extern void snd_sequencer_memory_init(int events);
            
/* release event memory */
extern void snd_sequencer_memory_done(void);

#endif