/*
 *   Test for ALSA sequencer
 *   Copyright (c) by Frank van de Pol <F.K.W.van.de.Pol@inter.nl.net>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define SND_MAIN_OBJECT_FILE
#include "driver.h"
#include "minors.h"
#include "mixer.h"
#include "info.h"
#include "control.h"

#include "seq.h"

snd_mutex_define_static(register);

static snd_info_entry_t *snd_seq_info_entry;
static int client;

#ifdef 0
/*
 *  /proc interface
 */

static void snd_sequencer_info_read(snd_info_buffer_t * buffer, void *private_data)
{
	snd_iprintf(buffer, "Sequencer info.\n");
}

int snd_sequencer_info_init(void)
{
	snd_info_entry_t *entry;

	entry = snd_info_create_entry(NULL, "seqinfo");
	if (!entry)
		return -ENOMEM;
	entry->t.text.read_size = 256;
	entry->t.text.read = snd_sequencer_info_read;
	if (snd_info_register(entry) < 0) {
		snd_info_free_entry(entry);
		return -ENOMEM;
	}
	snd_seq_info_entry = entry;
	return 0;
}

int snd_sequencer_info_done(void)
{
	if (snd_seq_info_entry)
		snd_info_unregister(snd_seq_info_entry);
	return 0;
}

#endif



/*
 *  REGISTRATION PART
 */



/* call-back function for event input */
static int event_input(snd_seq_event_t * ev, void *private_data)
{
	snd_printk("Call...\n");
	snd_printk(".......Event %d\n", ev->type);
//      snd_printk(".......Event %d,%d,%d to %d,%d,%d\n",
	//                      ev->event,ev->note,ev->velocity,
	//                      ev->queue,ev->client,ev->port);

	/* for testing, bounce the event to the next client */
	ev->dest.client += 1;
	/*... after 2 seconds */
	ev->flags = SND_SEQ_TIME_STAMP_REAL | SND_SEQ_TIME_MODE_REL;
	ev->time.real.sec = 2;
	ev->time.real.nsec = 0;

	snd_seq_kernel_client_enqueue(client, ev);

	snd_printk(".......Back!\n");
	return 1; /* success */
}



/*
 *  INIT PART
 */




#ifndef LINUX_2_1
extern struct symbol_table snd_symbol_table_seqexport;

#endif

int init_module(void)
{

	snd_seq_client_callback_t callbacks;

	callbacks.input = event_input;

#ifndef LINUX_2_1
	if (register_symtab(&snd_symbol_table_seqexport) < 0)
		return -ENOMEM;
#endif


	client = snd_seq_register_kernel_client(&callbacks, NULL);

	/* set our name */
	snd_seq_kernel_client_ctl(client, SND_SEQ_IOCTL_SET_CLIENT_NAME, "Kernel test");



	/* register proc interface */
	/*snd_sequencer_info_init(); */
	return 0;
}


void cleanup_module(void)
{
	snd_seq_unregister_kernel_client(client);

	/* unregister proc interface */
	/*snd_sequencer_info_done(); */
}
