/*
 * OSS compatible sequencer driver
 *
 * synth device information
 *
 * Copyright (C) 1998,99 Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SEQ_OSS_SYNTH_H
#define __SEQ_OSS_SYNTH_H

#include "seq_oss_device.h"
#include "seq_oss_legacy.h"

typedef struct seq_oss_synth_t seq_oss_synth_t;
typedef struct seq_oss_synth_sysex_t seq_oss_synth_sysex_t;

void snd_seq_oss_synth_setup(seq_oss_devinfo_t *dp);
void snd_seq_oss_synth_cleanup(seq_oss_devinfo_t *dp);

void snd_seq_oss_synth_reset(seq_oss_devinfo_t *dp, int dev);
int snd_seq_oss_synth_load_patch(seq_oss_devinfo_t *dp, int dev, int fmt, const char *buf, int p, int c);
int snd_seq_oss_synth_is_valid(seq_oss_devinfo_t *dp, int dev);
int snd_seq_oss_synth_send_sysex(seq_oss_devinfo_t *dp, int dev, unsigned char *buf, int atomic);
void snd_seq_oss_synth_addr(seq_oss_devinfo_t *dp, int dev, snd_seq_event_t *ev);
int snd_seq_oss_synth_ioctl(seq_oss_devinfo_t *dp, int dev, unsigned int cmd, unsigned long addr);
int snd_seq_oss_synth_send_raw_event(seq_oss_devinfo_t *dp, int dev, unsigned char *data, int atomic);

int snd_seq_oss_synth_make_info(seq_oss_devinfo_t *dp, int dev, oss_synth_info_t *inf);

#endif
