/*
 * OSS compatible sequencer driver
 * read fifo queue
 *
 * Copyright (C) 1998,99 Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SEQ_OSS_READQ_H
#define __SEQ_OSS_READQ_H

#include "seq_oss_device.h"


/*
 * definition of read queue
 */
struct seq_oss_readq_t {
	evrec_t *q;
	int qlen;
	int maxlen;
	int head, tail;
	unsigned long pre_event_timeout;
	unsigned long input_time;
	snd_sleep_define(midi);
	snd_spin_define(sleep_lock);
	snd_spin_define(lock);
};

seq_oss_readq_t *snd_seq_oss_readq_new(seq_oss_devinfo_t *dp, int maxlen);
void snd_seq_oss_readq_delete(seq_oss_readq_t *q);
void snd_seq_oss_readq_clear(seq_oss_readq_t *readq);
void snd_seq_oss_readq_sleep(seq_oss_readq_t *readq);
void snd_seq_oss_readq_wakeup(seq_oss_readq_t *readq);
#ifdef SND_POLL
unsigned int snd_seq_oss_readq_poll(seq_oss_readq_t *readq, struct file *file, poll_table *wait);
#else
int snd_seq_oss_readq_select(seq_oss_readq_t *readq, select_table *wait);
#endif
int snd_seq_oss_readq_putc(seq_oss_readq_t *readq, int dev, int c);
int snd_seq_oss_readq_put_event(seq_oss_readq_t *readq, evrec_t *ev);
int snd_seq_oss_readq_put_timestamp(seq_oss_readq_t *readq, unsigned long curt, int seq_mode);
void snd_seq_oss_readq_free(seq_oss_readq_t *q, evrec_t *ev);

/* macros */
#define snd_seq_oss_readq_is_empty(readq)	((readq)->qlen <= 0)
#define snd_seq_oss_readq_pick(readq)	((readq)->q + (readq)->head)

#endif
