/*
 * MIDI byte <-> sequencer event coder
 *
 * Copyright (C) 1998,99 Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __MIDI_CODER_H
#define __MIDI_CODER_H

#include "asequencer.h"

#define MAX_MIDI_CODER_BUF	128

typedef struct snd_midi_coder_t snd_midi_coder_t;

/* decode sequencer event to midi bytes */
typedef int (*snd_midi_output_coder_t)(snd_seq_event_t *ev, void *private, void *option);

/* encode midi byte to sequencer event */
typedef int (*snd_midi_input_coder_t)(unsigned char *buf, int len, void *private, void *option);

/* midi status */
struct snd_midi_coder_t {
	int qlen;	/* queue length */
	int read;	/* chars read */
	int status;	/* running status */
	int type;	/* current event type */
	unsigned char lastcmd;
	snd_midi_output_coder_t output;
	snd_midi_input_coder_t input;
	void *private;	/* private data */
	void (*private_free)(void *private);
	unsigned char buf[MAX_MIDI_CODER_BUF];
};

snd_midi_coder_t *snd_midi_coder_new(void);
void snd_midi_coder_delete(snd_midi_coder_t *dev);
void snd_midi_coder_init(snd_midi_coder_t *dev);
int snd_midi_coder_encode(snd_midi_coder_t *st, unsigned char c, void *option);
int snd_midi_coder_decode(snd_midi_coder_t *dev, snd_seq_event_t *ev, void *option);

#endif
