/*
 * A structure to keep track of each hardware voice on the emu8000
 *
 *  Copyright (C) 1999 Steve Ratcliffe
 *  Copyright (c) 1999 by Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __EMU8000_VOICE_H
#define __EMU8000_VOICE_H

#include "emu8000.h"
#include "sfnt_info.h"

/*
 * register table
 */
typedef soundfont_voice_info_t emu8000_register_t;


/*
 * A structure to keep track of each hardware voice on the emu8000
 */

typedef struct emu8000_voice {
	int  ch;		/* Hardware channel number */

	int  state;
#define EMU8000_ST_OFF		0x00	/* Not playing, and inactive */
#define EMU8000_ST_ON		0x01	/* Note on */
#define EMU8000_ST_RELEASED 	(0x02|EMU8000_ST_ON)	/* Note released */
#define EMU8000_ST_SUSTAINED	(0x04|EMU8000_ST_ON)	/* Note sustained */
#define EMU8000_ST_STANDBY	(0x08|EMU8000_ST_ON)	/* Waiting to be triggered */
#define EMU8000_ST_DRAM		0x10	/* Being used for read/write */
#define EMU8000_ST_FM		0x20	/* Being used for FM */

	unsigned int  time;	/* An allocation time */
	unsigned char note;	/* Note currently assigned to this voice */
	unsigned char key;
	unsigned char velocity;	/* Velocity of current note */

	int    avol;
	int    acutoff;
	int    apitch;
	int    aaux;
	int    apan;
	int    ptarget;

	snd_sf_zone_t *zone;	/* Zone assigned to this note */
	struct snd_midi_channel *chan;	/* Midi channel for this note */
	struct emu8000_port_t *port;
	
	/* Emu8000 registers */
	emu8000_register_t reg;

} emu8000_voice_t;


#endif
