/*
 *  Copyright (c) 1999 by Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 *  Definitions of chorus and reverb mode tables for Emu8000
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __EMU8000_EQUALIZER_H
#define __EMU8000_EQUALIZER_H

#include "sfnt_info.h"

/*
 * additional patch keys
 */

#define SND_EMU8000_LOAD_CHORUS_FX	0x10	/* optarg=mode */
#define SND_EMU8000_LOAD_REVERB_FX	0x11	/* optarg=mode */

/*
 * reverb mode parameters
 */
#define	SND_EMU8000_REVERB_ROOM1	0
#define SND_EMU8000_REVERB_ROOM2	1
#define	SND_EMU8000_REVERB_ROOM3	2
#define	SND_EMU8000_REVERB_HALL1	3
#define	SND_EMU8000_REVERB_HALL2	4
#define	SND_EMU8000_REVERB_PLATE	5
#define	SND_EMU8000_REVERB_DELAY	6
#define	SND_EMU8000_REVERB_PANNINGDELAY 7
#define SND_EMU8000_REVERB_PREDEFINED	8
/* user can define reverb modes up to 32 */
#define SND_EMU8000_REVERB_NUMBERS	32

typedef struct soundfont_reverb_fx_t {
	unsigned short parms[28];
} soundfont_reverb_fx_t;


/*
 * chorus mode parameters
 */
#define SND_EMU8000_CHORUS_1		0
#define	SND_EMU8000_CHORUS_2		1
#define	SND_EMU8000_CHORUS_3		2
#define	SND_EMU8000_CHORUS_4		3
#define	SND_EMU8000_CHORUS_FEEDBACK	4
#define	SND_EMU8000_CHORUS_FLANGER	5
#define	SND_EMU8000_CHORUS_SHORTDELAY	6
#define	SND_EMU8000_CHORUS_SHORTDELAY2	7
#define SND_EMU8000_CHORUS_PREDEFINED	8
/* user can define chorus modes up to 32 */
#define SND_EMU8000_CHORUS_NUMBERS	32

typedef struct soundfont_chorus_fx_t {
	unsigned short feedback;	/* feedback level (0xE600-0xE6FF) */
	unsigned short delay_offset;	/* delay (0-0x0DA3) [1/44100 sec] */
	unsigned short lfo_depth;	/* LFO depth (0xBC00-0xBCFF) */
	unsigned int delay;	/* right delay (0-0xFFFFFFFF) [1/256/44100 sec] */
	unsigned int lfo_freq;		/* LFO freq LFO freq (0-0xFFFFFFFF) */
} soundfont_chorus_fx_t;

void snd_emu8000_update_chorus_mode(emu8000_t *emu);
void snd_emu8000_update_reverb_mode(emu8000_t *emu);
void snd_emu8000_update_equalizer(emu8000_t *emu);
int snd_emu8000_load_chorus_fx(void *private, int mode, const void *buf, long len);
int snd_emu8000_load_reverb_fx(void *private, int mode, const void *buf, long len);
void snd_emu8000_set_chorus_mode(emu8000_t *emu, int mode);
void snd_emu8000_set_reverb_mode(emu8000_t *emu, int mode);
void snd_emu8000_equalizer(emu8000_t *emu, int bass, int treble);

#endif
