
#define TX_BUFF_SIZE 32		/* Must be 2^n */
#define TX_BUFF_MASK  (TX_BUFF_SIZE - 1)

struct snd_seq_uart16550_client;
typedef struct snd_seq_uart16550_client snd_seq_uart16550_client_t;

typedef struct snd_stru_uart16550 {
	snd_card_t *card;
	snd_rawmidi_t *rmidi;
	snd_seq_uart16550_client_t *seq_client;

	int filemode;		//open status of file

	int polled;
	 snd_spin_define(open);
	//snd_spin_define (input);
	//snd_spin_define (output);

	unsigned short irq_number;
	snd_irq_t *irq;

	unsigned short base;
	//snd_port_t* port;
	//unsigned short size;

	unsigned char divisor;

	unsigned char old_divisor_lsb;
	unsigned char old_divisor_msb;
	unsigned char old_line_ctrl_reg;

	//parameter for using of write loop
	short int fifo_limit;	//used in uart16550

	short int fifo_count;	//used in uart16550

	//write buffer and its writing/reading position
	char tx_buff[TX_BUFF_SIZE];
	short int buff_in;
	short int buff_out;
} snd_uart16550_t;
