/*
 *   ALSA sequencer FIFO
 *   Copyright (c) 1998 by Frank van de Pol <frank@vande-pol.demon.nl>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SND_SEQ_FIFO_H
#define __SND_SEQ_FIFO_H

#include "seq_memory.h"


/* === FIFO === */

typedef struct {
	pool_t *pool;			/* FIFO pool */
	snd_seq_event_cell_t* head;    	/* pointer to head of fifo */
	snd_seq_event_cell_t* tail;    	/* pointer to tail of fifo */
	int cells;
	snd_spin_define(lock);
	
	/* FIXME: this does not belong here, use generic callback with registered function */
	unsigned int flags;		
	snd_sleep_define(input);	/* readers block on empty queue */
} fifo_t;

/* create new fifo (constructor) */
extern fifo_t *snd_seq_fifo_new(void);

/* delete fifo (destructor) */
extern void snd_seq_fifo_delete(fifo_t **f);


/* enqueue cell to fifo */
extern void snd_seq_fifo_cell_in(fifo_t *f, snd_seq_event_cell_t *cell);

/* dequeue cell from fifo */ 
extern snd_seq_event_cell_t *snd_seq_fifo_cell_out(fifo_t *f);

/* return number of events available in fifo */
extern int snd_seq_fifo_avail(fifo_t *f);

/* peek at cell at the head of the fifo */
extern snd_seq_event_cell_t *snd_seq_fifo_cell_peek(fifo_t *f);
        

#endif
