/*
 *   ALSA sequencer Client Manager
 *   Copyright (c) 1998 by Frank van de Pol <frank@vande-pol.demon.nl>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SND_SEQ_CLIENTMGR_H
#define __SND_SEQ_CLIENTMGR_H

#include "seq_kernel.h"
#include "seq_fifo.h"
#include "seq_ports.h"


/* client manager */

struct snd_seq_stru_user_client {
	struct file *file;	/* file struct of client */
	/* ... */
	
	/* locks */
	snd_spin_define(input_sleep);
};

struct snd_seq_stru_kernel_client {
	snd_card_t *card;
	/* pointer to client functions */
	void *private_data;			/* private data for client */
	/* ... */
};


struct snd_seq_stru_client {
	snd_seq_client_type_t type;
	int accept_input: 1,
	    accept_output: 1;
	char name[64];		/* client name */
	int number;		/* client number */
	unsigned int filter;	/* filter flags */
	unsigned char multicast_filter[8];
	unsigned char event_filter[32];
	fifo_t *outqueue;	/* queue for outgoing (to client) data */
	unsigned int use;	/* port use counter */
	snd_spin_define(use);
	snd_sleep_define(use);
	/* watermarks */
	int low[SND_SEQ_MAX_QUEUES];
	int high[SND_SEQ_MAX_QUEUES];
	/* ports */
	client_port_t *ports;	/* exported ports */
	unsigned int ports_use;	/* counter for exported ports use */
	snd_spin_define(ports);	/* lock for exported ports */
	snd_sleep_define(ports); /* sleeper for exported ports */
	/* masks */
	/* filters */
	union {
		user_client_t user;
		kernel_client_t kernel;
	} data;
};

/* usage statistics */
typedef struct {
	int cur;
	int peak;
} usage_t;


extern void client_init_data(void);
extern int snd_sequencer_device_init(void);
extern void snd_sequencer_device_done(void);

/* get locked pointer to client */
extern client_t *snd_seq_client_use_ptr(int clientid);

/* unlock pointer to client */
extern void snd_seq_client_unlock(client_t *client);

/* dispatch event to client(s) */
extern void snd_seq_dispatch_event(snd_seq_event_cell_t *cell, int atomic);

/* exported to other modules */
extern int snd_seq_register_kernel_client(snd_seq_client_callback_t *callback, void *private_data);
extern int snd_seq_unregister_kernel_client(int client);
extern int snd_seq_kernel_client_enqueue(int client, snd_seq_event_t *ev, int atomic);

#endif
