/*
 * OSS compatible sequencer driver
 *
 * midi device information
 *
 * Copyright (C) 1998,99 Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SEQ_OSS_MIDI_H
#define __SEQ_OSS_MIDI_H

#include "seq_oss_device.h"
#include "seq_oss_legacy.h"

typedef struct seq_oss_midi_t seq_oss_midi_t;

int snd_seq_oss_midi_lookup_ports(int client);
int snd_seq_oss_midi_check_new_port(snd_seq_port_info_t *pinfo);
int snd_seq_oss_midi_check_exit_port(int client, int port);

void snd_seq_oss_midi_setup(seq_oss_devinfo_t *dp);
void snd_seq_oss_midi_cleanup(seq_oss_devinfo_t *dp);

int snd_seq_oss_midi_open(seq_oss_devinfo_t *dp, int dev, int file_mode);
int snd_seq_oss_midi_close(seq_oss_devinfo_t *dp, int dev);
void snd_seq_oss_midi_reset(seq_oss_devinfo_t *dp, int dev);
int snd_seq_oss_midi_putc(seq_oss_devinfo_t *dp, int dev, unsigned char c, int atomic);
int snd_seq_oss_midi_input(snd_seq_event_t *ev, int direct, void *private);
int snd_seq_oss_midi_filemode(seq_oss_devinfo_t *dp, int dev);
int snd_seq_oss_midi_make_info(seq_oss_devinfo_t *dp, int dev, oss_midi_info_t *inf);

#endif
