/*
 *  Misc things
 *  Copyright (c) by Jaroslav Kysela <perex@suse.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "driver.h"
#include <asm/pgtable.h>

int snd_task_name(struct task_struct *task, char *name, int size)
{
	int idx;

	if (task == NULL || name == NULL || size < 2)
		return -EINVAL;
	for (idx = 0; idx < 15 && idx + 1 < size; idx++)
		name[idx] = *name++;
	name[idx] = '\0';
	return 0;
}
