/*
 *  Routines for Gravis UltraSound soundcards - Synthesizer
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "driver.h"
#include "gus.h"

/*

 */

int snd_gus_attach_synthesizer(snd_gus_card_t * gus)
{
	snd_synth_t *synth;

	synth = snd_synth_new_device(gus->card, "GUS");
	if (!synth)
		return -ENOMEM;
	gus->gf1.synth = synth;
	strcpy(synth->name, gus->interwave ? "AMD InterWave" : "GF1");
	synth->private_data = gus;
	return snd_synth_register(synth);
}

int snd_gus_detach_synthesizer(snd_gus_card_t * gus)
{
	int res;

	if (!gus->gf1.synth)
		return -EINVAL;
	res = snd_synth_unregister(gus->gf1.synth);
	gus->gf1.synth = NULL;
	return res;
}
