/*
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 *  Routines for MuLaw conversion
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *~
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "driver.h"
#include "ulaw.h"

/*
 *  tables
 */

unsigned char snd_ulaw_dsp[256] =
{
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 2,
	5, 9, 13, 17, 21, 25, 29, 33,
	37, 41, 45, 49, 53, 57, 61, 65,
	68, 70, 72, 74, 76, 78, 80, 82,
	84, 86, 88, 90, 92, 94, 96, 98,
	100, 101, 102, 103, 104, 105, 106, 107,
	108, 109, 110, 111, 112, 113, 114, 115,
	115, 116, 116, 117, 117, 118, 118, 119,
	119, 120, 120, 121, 121, 122, 122, 123,
	123, 123, 124, 124, 124, 124, 125, 125,
	125, 125, 126, 126, 126, 126, 127, 127,
	127, 127, 127, 127, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255,
	252, 248, 244, 240, 236, 232, 228, 224,
	220, 216, 212, 208, 204, 200, 196, 192,
	189, 187, 185, 183, 181, 179, 177, 175,
	173, 171, 169, 167, 165, 163, 161, 159,
	157, 156, 155, 154, 153, 152, 151, 150,
	149, 148, 147, 146, 145, 144, 143, 142,
	142, 141, 141, 140, 140, 139, 139, 138,
	138, 137, 137, 136, 136, 135, 135, 134,
	134, 134, 133, 133, 133, 133, 132, 132,
	132, 132, 131, 131, 131, 131, 130, 130,
	130, 130, 130, 130, 129, 129, 129, 129,
	129, 129, 129, 129, 128, 128, 128, 128,
};

unsigned char snd_ulaw_dsp_loud[256] =
{
	0, 5, 9, 13, 17, 21, 25, 29,
	33, 37, 41, 45, 49, 53, 57, 61,
	65, 67, 69, 71, 73, 75, 77, 79,
	81, 83, 85, 87, 89, 91, 93, 95,
	97, 98, 99, 100, 101, 102, 103, 104,
	105, 106, 107, 108, 109, 110, 111, 112,
	113, 114, 114, 115, 115, 116, 116, 117,
	117, 118, 118, 119, 119, 120, 120, 121,
	121, 121, 122, 122, 122, 122, 123, 123,
	123, 123, 124, 124, 124, 124, 125, 125,
	125, 125, 125, 125, 126, 126, 126, 126,
	126, 126, 126, 126, 127, 127, 127, 127,
	127, 127, 127, 127, 127, 127, 127, 127,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	255, 251, 247, 243, 239, 235, 231, 227,
	223, 219, 215, 211, 207, 203, 199, 195,
	191, 189, 187, 185, 183, 181, 179, 177,
	175, 173, 171, 169, 167, 165, 163, 161,
	159, 158, 157, 156, 155, 154, 153, 152,
	151, 150, 149, 148, 147, 146, 145, 144,
	143, 142, 142, 141, 141, 140, 140, 139,
	139, 138, 138, 137, 137, 136, 136, 135,
	135, 135, 134, 134, 134, 134, 133, 133,
	133, 133, 132, 132, 132, 132, 131, 131,
	131, 131, 131, 131, 130, 130, 130, 130,
	130, 130, 130, 130, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128
};

unsigned char snd_dsp_ulaw[256] =
{
	31, 31, 31, 32, 32, 32, 32, 33,
	33, 33, 33, 34, 34, 34, 34, 35,
	35, 35, 35, 36, 36, 36, 36, 37,
	37, 37, 37, 38, 38, 38, 38, 39,
	39, 39, 39, 40, 40, 40, 40, 41,
	41, 41, 41, 42, 42, 42, 42, 43,
	43, 43, 43, 44, 44, 44, 44, 45,
	45, 45, 45, 46, 46, 46, 46, 47,
	47, 47, 47, 48, 48, 49, 49, 50,
	50, 51, 51, 52, 52, 53, 53, 54,
	54, 55, 55, 56, 56, 57, 57, 58,
	58, 59, 59, 60, 60, 61, 61, 62,
	62, 63, 63, 64, 65, 66, 67, 68,
	69, 70, 71, 72, 73, 74, 75, 76,
	77, 78, 79, 81, 83, 85, 87, 89,
	91, 93, 95, 99, 103, 107, 111, 119,
	255, 247, 239, 235, 231, 227, 223, 221,
	219, 217, 215, 213, 211, 209, 207, 206,
	205, 204, 203, 202, 201, 200, 199, 198,
	197, 196, 195, 194, 193, 192, 191, 191,
	190, 190, 189, 189, 188, 188, 187, 187,
	186, 186, 185, 185, 184, 184, 183, 183,
	182, 182, 181, 181, 180, 180, 179, 179,
	178, 178, 177, 177, 176, 176, 175, 175,
	175, 175, 174, 174, 174, 174, 173, 173,
	173, 173, 172, 172, 172, 172, 171, 171,
	171, 171, 170, 170, 170, 170, 169, 169,
	169, 169, 168, 168, 168, 168, 167, 167,
	167, 167, 166, 166, 166, 166, 165, 165,
	165, 165, 164, 164, 164, 164, 163, 163,
	163, 163, 162, 162, 162, 162, 161, 161,
	161, 161, 160, 160, 160, 160, 159, 159,
};

unsigned char snd_dsp_ulaw_loud[256] =
{
	0, 0, 0, 0, 0, 1, 1, 1,
	1, 2, 2, 2, 2, 3, 3, 3,
	3, 4, 4, 4, 4, 5, 5, 5,
	5, 6, 6, 6, 6, 7, 7, 7,
	7, 8, 8, 8, 8, 9, 9, 9,
	9, 10, 10, 10, 10, 11, 11, 11,
	11, 12, 12, 12, 12, 13, 13, 13,
	13, 14, 14, 14, 14, 15, 15, 15,
	15, 16, 16, 17, 17, 18, 18, 19,
	19, 20, 20, 21, 21, 22, 22, 23,
	23, 24, 24, 25, 25, 26, 26, 27,
	27, 28, 28, 29, 29, 30, 30, 31,
	31, 32, 33, 34, 35, 36, 37, 38,
	39, 40, 41, 42, 43, 44, 45, 46,
	47, 48, 50, 52, 54, 56, 58, 60,
	62, 65, 69, 73, 77, 83, 91, 255,
	231, 219, 211, 205, 201, 197, 193, 190,
	188, 186, 184, 182, 180, 178, 176, 175,
	174, 173, 172, 171, 170, 169, 168, 167,
	166, 165, 164, 163, 162, 161, 160, 159,
	159, 158, 158, 157, 157, 156, 156, 155,
	155, 154, 154, 153, 153, 152, 152, 151,
	151, 150, 150, 149, 149, 148, 148, 147,
	147, 146, 146, 145, 145, 144, 144, 143,
	143, 143, 143, 142, 142, 142, 142, 141,
	141, 141, 141, 140, 140, 140, 140, 139,
	139, 139, 139, 138, 138, 138, 138, 137,
	137, 137, 137, 136, 136, 136, 136, 135,
	135, 135, 135, 134, 134, 134, 134, 133,
	133, 133, 133, 132, 132, 132, 132, 131,
	131, 131, 131, 130, 130, 130, 130, 129,
	129, 129, 129, 128, 128, 128, 128, 128
};

void snd_translate_to_user(unsigned char *table,
			   unsigned char *dest,
			   unsigned char *src,
			   unsigned int count)
{
	register unsigned char *pbuffer;
	register unsigned int size1;
	unsigned char buffer[512];
	unsigned int size;

	while (count > 0) {
		size = size1 = sizeof(buffer) < count ? sizeof(buffer) : count;
		pbuffer = buffer;
		while (size1-- > 0)
			*pbuffer++ = table[*src++];
		copy_to_user(dest, buffer, size);
		count -= size;
		dest += size;
	}
}

void snd_translate_from_user(unsigned char *table,
			     unsigned char *dest,
			     unsigned char *src,
			     unsigned int count)
{
	register unsigned char *pbuffer;
	register unsigned int size1;
	unsigned char buffer[512];
	unsigned int size;

	while (count > 0) {
		size = size1 = sizeof(buffer) < count ? sizeof(buffer) : count;
		copy_from_user(buffer, src, size);
		pbuffer = buffer;
		while (size1-- > 0)
			*dest++ = table[*pbuffer++];
		count -= size;
		src += size;
	}
}
