#ifndef __EMU10K1_SYNTH_LOCAL_H
#define __EMU10K1_SYNTH_LOCAL_H
/*
 *  Local defininitons for Emu10k1 wavetable
 *
 *  Copyright (C) 2000 Takashi Iwai <iwai@ww.uni-erlangen.de>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../../include/driver.h"
#include "../../include/mixer.h"
#include "../../include/emu10k1_synth.h"

/* emu10k1_patch.c */
int snd_emu10k1_sample_new(void *private_data, snd_sf_sample_t *sp, snd_emux_memhdr_t *hdr, const void *_data, long count);
int snd_emu10k1_sample_free(void *private_data, snd_sf_sample_t *sp, snd_emux_memhdr_t *hdr);
int snd_emu10k1_memhdr_init(snd_emux_t *emu);

/* emu10k1_callback.c */
void snd_emu10k1_ops_setup(snd_emux_t *emu);


#endif	/* __EMU10K1_SYNTH_LOCAL_H */
