#include <stdio.h>
#include <lightning.h>

#  if __WORDSIZE == 64 && _WIN32
#    define ONE				1LL
#  else
#    define ONE				1L
#  endif
/* Avoid clang running out of memory on OpenBSD mips64 */
#define SKIP_64_BITS	(__mips__ && __clang__)

#define GENMASK1()		GENMASK(1)
#define GENMASK2()		GENMASK(2)
#define GENMASK3()		GENMASK(3)
#define GENMASK4()		GENMASK(4)
#define GENMASK5()		GENMASK(5)
#define GENMASK6()		GENMASK(6)
#define GENMASK7()		GENMASK(7)
#define GENMASK8()		GENMASK(8)
#define GENMASK9()		GENMASK(9)
#define GENMASK10()		GENMASK(10)
#define GENMASK11()		GENMASK(11)
#define GENMASK12()		GENMASK(12)
#define GENMASK13()		GENMASK(13)
#define GENMASK14()		GENMASK(14)
#define GENMASK15()		GENMASK(15)
#define GENMASK16()		GENMASK(16)
#define GENMASK17()		GENMASK(17)
#define GENMASK18()		GENMASK(18)
#define GENMASK19()		GENMASK(19)
#define GENMASK20()		GENMASK(20)
#define GENMASK21()		GENMASK(21)
#define GENMASK22()		GENMASK(22)
#define GENMASK23()		GENMASK(23)
#define GENMASK24()		GENMASK(24)
#define GENMASK25()		GENMASK(25)
#define GENMASK26()		GENMASK(26)
#define GENMASK27()		GENMASK(27)
#define GENMASK28()		GENMASK(28)
#define GENMASK29()		GENMASK(29)
#define GENMASK30()		GENMASK(30)
#define GENMASK31()		GENMASK(31)
#if __WORDSIZE == 32
#  define MININT		0x80000000L
#  define GENMASK32()						\
    do {							\
	m = -1;							\
	t = 0;							\
    } while (0)
#else
#  define GENMASK32()		GENMASK(32)
#  define GENMASK33()		GENMASK(33)
#  define GENMASK34()		GENMASK(34)
#  define GENMASK35()		GENMASK(35)
#  define GENMASK36()		GENMASK(36)
#  define GENMASK37()		GENMASK(37)
#  define GENMASK38()		GENMASK(38)
#  define GENMASK39()		GENMASK(39)
#  define GENMASK40()		GENMASK(40)
#  define GENMASK41()		GENMASK(41)
#  define GENMASK42()		GENMASK(42)
#  define GENMASK43()		GENMASK(43)
#  define GENMASK44()		GENMASK(44)
#  define GENMASK45()		GENMASK(45)
#  define GENMASK46()		GENMASK(46)
#  define GENMASK47()		GENMASK(47)
#  define GENMASK48()		GENMASK(48)
#  define GENMASK49()		GENMASK(49)
#  define GENMASK50()		GENMASK(50)
#  define GENMASK51()		GENMASK(51)
#  define GENMASK52()		GENMASK(52)
#  define GENMASK53()		GENMASK(53)
#  define GENMASK54()		GENMASK(54)
#  define GENMASK55()		GENMASK(55)
#  define GENMASK56()		GENMASK(56)
#  define GENMASK57()		GENMASK(57)
#  define GENMASK58()		GENMASK(58)
#  define GENMASK59()		GENMASK(59)
#  define GENMASK60()		GENMASK(60)
#  define GENMASK61()		GENMASK(61)
#  define GENMASK62()		GENMASK(62)
#  define GENMASK63()		GENMASK(63)
#  if _WIN32
#    define MININT		0x8000000000000000LL
#  else
#    define MININT		0x8000000000000000L
#  endif
#  define GENMASK64()						\
    do {							\
	m = -1;							\
	t = 0;							\
    } while (0)
#endif
#if __BYTE_ORDER == __LITTLE_ENDIAN
#  define GENMASK(L)						\
    do {							\
	m = (ONE << L) - 1;					\
	t = m ^ 1;						\
    } while (0)
#  define SHIFTMASK(B)		m = ~(m << (B))
#else
#  define GENMASK(L)						\
    do {							\
	m = (ONE << L) - 1;					\
	t = m ^ 1;						\
	m = ((jit_word_t)MININT >> (L - 1));			\
    } while (0)
#  define SHIFTMASK(B)		m = ~(m >> ((B) - 1))
#endif

#define	S			jit_word_t
#define	U			jit_uword_t

#define deftypeSL(L)						\
typedef union {							\
    struct {							\
	S	f: L;						\
    } b;							\
    S		s;						\
} S##L;								\
static void							\
CS##L(S##L *u, S (*JS##L)(S##L*)) {				\
    S t, j, m;							\
    GENMASK##L();						\
    m = ~m;							\
    t = ((t << (__WORDSIZE - L)) >> (__WORDSIZE - L));		\
    u->s = 0;							\
    j = (*JS##L)(u);						\
    if (u->b.f != t || t != j || (u->s & m))			\
	abort();						\
}

#define deftypeSBL(B, L)					\
typedef union {							\
    struct {							\
	S	_: B;						\
	S	f: L;						\
    } b;							\
    S		s;						\
} S##B##_##L;							\
static void							\
CS##B##_##L(S##B##_##L *u, S (*JS##B##_##L)(S##B##_##L*)) {	\
    S t, j, m;							\
    GENMASK##L();						\
    SHIFTMASK(B);						\
    t = ((t << (__WORDSIZE - L)) >> (__WORDSIZE - L));		\
    u->s = 0;							\
    j = (*JS##B##_##L)(u);					\
    if (u->b.f != t || t != j || (u->s & m))			\
	abort();						\
}

#define deftypeUL(L)						\
typedef union {							\
    struct {							\
	U	f: L;						\
    } b;							\
    U		u;						\
} U##L;								\
static void							\
CU##L(U##L *u, U (*JU##L)(U##L*)) {				\
    U t, j, m;							\
    GENMASK##L();						\
    m = ~m;							\
    t = ((t << (__WORDSIZE - L)) >> (__WORDSIZE - L));		\
    u->u = 0;							\
    j = (*JU##L)(u);						\
    if (u->b.f != t || t != j || (u->u & m))			\
	abort();						\
}

#define deftypeUBL(B, L)					\
typedef union {							\
    struct {							\
	U	_: B;						\
	U	f: L;						\
    } b;							\
    U		u;						\
} U##B##_##L;							\
static void							\
CU##B##_##L(U##B##_##L *u, U (*JU##B##_##L)(U##B##_##L*)) {	\
    U t, j, m;							\
    GENMASK##L();						\
    SHIFTMASK(B);						\
    t = ((t << (__WORDSIZE - L)) >> (__WORDSIZE - L));		\
    u->u = 0;							\
    j = (*JU##B##_##L)(u);					\
    if (u->b.f != t || t != j || (u->u & m))			\
	abort();						\
}

/* Define signed bitfields at offset 0 */
deftypeSL(1)
deftypeSL(2)
deftypeSL(3)
deftypeSL(4)
deftypeSL(5)
deftypeSL(6)
deftypeSL(7)
deftypeSL(8)
deftypeSL(9)
deftypeSL(10)
deftypeSL(11)
deftypeSL(12)
deftypeSL(13)
deftypeSL(14)
deftypeSL(15)
deftypeSL(16)
deftypeSL(17)
deftypeSL(18)
deftypeSL(19)
deftypeSL(20)
deftypeSL(21)
deftypeSL(22)
deftypeSL(23)
deftypeSL(24)
deftypeSL(25)
deftypeSL(26)
deftypeSL(27)
deftypeSL(28)
deftypeSL(29)
deftypeSL(30)
deftypeSL(31)
deftypeSL(32)
#if __WORDSIZE == 64 && !SKIP_64_BITS
deftypeSL(33)
deftypeSL(34)
deftypeSL(35)
deftypeSL(36)
deftypeSL(37)
deftypeSL(38)
deftypeSL(39)
deftypeSL(40)
deftypeSL(41)
deftypeSL(42)
deftypeSL(43)
deftypeSL(44)
deftypeSL(45)
deftypeSL(46)
deftypeSL(47)
deftypeSL(48)
deftypeSL(49)
deftypeSL(50)
deftypeSL(51)
deftypeSL(52)
deftypeSL(53)
deftypeSL(54)
deftypeSL(55)
deftypeSL(56)
deftypeSL(57)
deftypeSL(58)
deftypeSL(59)
deftypeSL(60)
deftypeSL(61)
deftypeSL(62)
deftypeSL(63)
deftypeSL(64)
#endif
/* Define unsigned bitfields at offset 0 */
deftypeUL(1)
deftypeUL(2)
deftypeUL(3)
deftypeUL(4)
deftypeUL(5)
deftypeUL(6)
deftypeUL(7)
deftypeUL(8)
deftypeUL(9)
deftypeUL(10)
deftypeUL(11)
deftypeUL(12)
deftypeUL(13)
deftypeUL(14)
deftypeUL(15)
deftypeUL(16)
deftypeUL(17)
deftypeUL(18)
deftypeUL(19)
deftypeUL(20)
deftypeUL(21)
deftypeUL(22)
deftypeUL(23)
deftypeUL(24)
deftypeUL(25)
deftypeUL(26)
deftypeUL(27)
deftypeUL(28)
deftypeUL(29)
deftypeUL(30)
deftypeUL(31)
deftypeUL(32)
#if __WORDSIZE == 64 && !SKIP_64_BITS
deftypeUL(33)
deftypeUL(34)
deftypeUL(35)
deftypeUL(36)
deftypeUL(37)
deftypeUL(38)
deftypeUL(39)
deftypeUL(40)
deftypeUL(41)
deftypeUL(42)
deftypeUL(43)
deftypeUL(44)
deftypeUL(45)
deftypeUL(46)
deftypeUL(47)
deftypeUL(48)
deftypeUL(49)
deftypeUL(50)
deftypeUL(51)
deftypeUL(52)
deftypeUL(53)
deftypeUL(54)
deftypeUL(55)
deftypeUL(56)
deftypeUL(57)
deftypeUL(58)
deftypeUL(59)
deftypeUL(60)
deftypeUL(61)
deftypeUL(62)
deftypeUL(63)
deftypeUL(64)
#endif
/* Define signed bitfields at offset 1 */
deftypeSBL(1, 1)
deftypeSBL(1, 2)
deftypeSBL(1, 3)
deftypeSBL(1, 4)
deftypeSBL(1, 5)
deftypeSBL(1, 6)
deftypeSBL(1, 7)
deftypeSBL(1, 8)
deftypeSBL(1, 9)
deftypeSBL(1, 10)
deftypeSBL(1, 11)
deftypeSBL(1, 12)
deftypeSBL(1, 13)
deftypeSBL(1, 14)
deftypeSBL(1, 15)
deftypeSBL(1, 16)
deftypeSBL(1, 17)
deftypeSBL(1, 18)
deftypeSBL(1, 19)
deftypeSBL(1, 20)
deftypeSBL(1, 21)
deftypeSBL(1, 22)
deftypeSBL(1, 23)
deftypeSBL(1, 24)
deftypeSBL(1, 25)
deftypeSBL(1, 26)
deftypeSBL(1, 27)
deftypeSBL(1, 28)
deftypeSBL(1, 29)
deftypeSBL(1, 30)
deftypeSBL(1, 31)
/* Define signed bitfields at offset 2 */
deftypeSBL(2, 1)
deftypeSBL(2, 2)
deftypeSBL(2, 3)
deftypeSBL(2, 4)
deftypeSBL(2, 5)
deftypeSBL(2, 6)
deftypeSBL(2, 7)
deftypeSBL(2, 8)
deftypeSBL(2, 9)
deftypeSBL(2, 10)
deftypeSBL(2, 11)
deftypeSBL(2, 12)
deftypeSBL(2, 13)
deftypeSBL(2, 14)
deftypeSBL(2, 15)
deftypeSBL(2, 16)
deftypeSBL(2, 17)
deftypeSBL(2, 18)
deftypeSBL(2, 19)
deftypeSBL(2, 20)
deftypeSBL(2, 21)
deftypeSBL(2, 22)
deftypeSBL(2, 23)
deftypeSBL(2, 24)
deftypeSBL(2, 25)
deftypeSBL(2, 26)
deftypeSBL(2, 27)
deftypeSBL(2, 28)
deftypeSBL(2, 29)
deftypeSBL(2, 30)
/* Define signed bitfields at offset 3 */
deftypeSBL(3, 1)
deftypeSBL(3, 2)
deftypeSBL(3, 3)
deftypeSBL(3, 4)
deftypeSBL(3, 5)
deftypeSBL(3, 6)
deftypeSBL(3, 7)
deftypeSBL(3, 8)
deftypeSBL(3, 9)
deftypeSBL(3, 10)
deftypeSBL(3, 11)
deftypeSBL(3, 12)
deftypeSBL(3, 13)
deftypeSBL(3, 14)
deftypeSBL(3, 15)
deftypeSBL(3, 16)
deftypeSBL(3, 17)
deftypeSBL(3, 18)
deftypeSBL(3, 19)
deftypeSBL(3, 20)
deftypeSBL(3, 21)
deftypeSBL(3, 22)
deftypeSBL(3, 23)
deftypeSBL(3, 24)
deftypeSBL(3, 25)
deftypeSBL(3, 26)
deftypeSBL(3, 27)
deftypeSBL(3, 28)
deftypeSBL(3, 29)
/* Define signed bitfields at offset 4 */
deftypeSBL(4, 1)
deftypeSBL(4, 2)
deftypeSBL(4, 3)
deftypeSBL(4, 4)
deftypeSBL(4, 5)
deftypeSBL(4, 6)
deftypeSBL(4, 7)
deftypeSBL(4, 8)
deftypeSBL(4, 9)
deftypeSBL(4, 10)
deftypeSBL(4, 11)
deftypeSBL(4, 12)
deftypeSBL(4, 13)
deftypeSBL(4, 14)
deftypeSBL(4, 15)
deftypeSBL(4, 16)
deftypeSBL(4, 17)
deftypeSBL(4, 18)
deftypeSBL(4, 19)
deftypeSBL(4, 20)
deftypeSBL(4, 21)
deftypeSBL(4, 22)
deftypeSBL(4, 23)
deftypeSBL(4, 24)
deftypeSBL(4, 25)
deftypeSBL(4, 26)
deftypeSBL(4, 27)
deftypeSBL(4, 28)
/* Define signed bitfields at offset 5 */
deftypeSBL(5, 1)
deftypeSBL(5, 2)
deftypeSBL(5, 3)
deftypeSBL(5, 4)
deftypeSBL(5, 5)
deftypeSBL(5, 6)
deftypeSBL(5, 7)
deftypeSBL(5, 8)
deftypeSBL(5, 9)
deftypeSBL(5, 10)
deftypeSBL(5, 11)
deftypeSBL(5, 12)
deftypeSBL(5, 13)
deftypeSBL(5, 14)
deftypeSBL(5, 15)
deftypeSBL(5, 16)
deftypeSBL(5, 17)
deftypeSBL(5, 18)
deftypeSBL(5, 19)
deftypeSBL(5, 20)
deftypeSBL(5, 21)
deftypeSBL(5, 22)
deftypeSBL(5, 23)
deftypeSBL(5, 24)
deftypeSBL(5, 25)
deftypeSBL(5, 26)
deftypeSBL(5, 27)
/* Define signed bitfields at offset 6 */
deftypeSBL(6, 1)
deftypeSBL(6, 2)
deftypeSBL(6, 3)
deftypeSBL(6, 4)
deftypeSBL(6, 5)
deftypeSBL(6, 6)
deftypeSBL(6, 7)
deftypeSBL(6, 8)
deftypeSBL(6, 9)
deftypeSBL(6, 10)
deftypeSBL(6, 11)
deftypeSBL(6, 12)
deftypeSBL(6, 13)
deftypeSBL(6, 14)
deftypeSBL(6, 15)
deftypeSBL(6, 16)
deftypeSBL(6, 17)
deftypeSBL(6, 18)
deftypeSBL(6, 19)
deftypeSBL(6, 20)
deftypeSBL(6, 21)
deftypeSBL(6, 22)
deftypeSBL(6, 23)
deftypeSBL(6, 24)
deftypeSBL(6, 25)
deftypeSBL(6, 26)
/* Define signed bitfields at offset 7 */
deftypeSBL(7, 1)
deftypeSBL(7, 2)
deftypeSBL(7, 3)
deftypeSBL(7, 4)
deftypeSBL(7, 5)
deftypeSBL(7, 6)
deftypeSBL(7, 7)
deftypeSBL(7, 8)
deftypeSBL(7, 9)
deftypeSBL(7, 10)
deftypeSBL(7, 11)
deftypeSBL(7, 12)
deftypeSBL(7, 13)
deftypeSBL(7, 14)
deftypeSBL(7, 15)
deftypeSBL(7, 16)
deftypeSBL(7, 17)
deftypeSBL(7, 18)
deftypeSBL(7, 19)
deftypeSBL(7, 20)
deftypeSBL(7, 21)
deftypeSBL(7, 22)
deftypeSBL(7, 23)
deftypeSBL(7, 24)
deftypeSBL(7, 25)
/* Define signed bitfields at offset 8 */
deftypeSBL(8, 1)
deftypeSBL(8, 2)
deftypeSBL(8, 3)
deftypeSBL(8, 4)
deftypeSBL(8, 5)
deftypeSBL(8, 6)
deftypeSBL(8, 7)
deftypeSBL(8, 8)
deftypeSBL(8, 9)
deftypeSBL(8, 10)
deftypeSBL(8, 11)
deftypeSBL(8, 12)
deftypeSBL(8, 13)
deftypeSBL(8, 14)
deftypeSBL(8, 15)
deftypeSBL(8, 16)
deftypeSBL(8, 17)
deftypeSBL(8, 18)
deftypeSBL(8, 19)
deftypeSBL(8, 20)
deftypeSBL(8, 21)
deftypeSBL(8, 22)
deftypeSBL(8, 23)
deftypeSBL(8, 24)
/* Define signed bitfields at offset 9 */
deftypeSBL(9, 1)
deftypeSBL(9, 2)
deftypeSBL(9, 3)
deftypeSBL(9, 4)
deftypeSBL(9, 5)
deftypeSBL(9, 6)
deftypeSBL(9, 7)
deftypeSBL(9, 8)
deftypeSBL(9, 9)
deftypeSBL(9, 10)
deftypeSBL(9, 11)
deftypeSBL(9, 12)
deftypeSBL(9, 13)
deftypeSBL(9, 14)
deftypeSBL(9, 15)
deftypeSBL(9, 16)
deftypeSBL(9, 17)
deftypeSBL(9, 18)
deftypeSBL(9, 19)
deftypeSBL(9, 20)
deftypeSBL(9, 21)
deftypeSBL(9, 22)
deftypeSBL(9, 23)
/* Define signed bitfields at offset 10 */
deftypeSBL(10, 1)
deftypeSBL(10, 2)
deftypeSBL(10, 3)
deftypeSBL(10, 4)
deftypeSBL(10, 5)
deftypeSBL(10, 6)
deftypeSBL(10, 7)
deftypeSBL(10, 8)
deftypeSBL(10, 9)
deftypeSBL(10, 10)
deftypeSBL(10, 11)
deftypeSBL(10, 12)
deftypeSBL(10, 13)
deftypeSBL(10, 14)
deftypeSBL(10, 15)
deftypeSBL(10, 16)
deftypeSBL(10, 17)
deftypeSBL(10, 18)
deftypeSBL(10, 19)
deftypeSBL(10, 20)
deftypeSBL(10, 21)
deftypeSBL(10, 22)
/* Define signed bitfields at offset 11 */
deftypeSBL(11, 1)
deftypeSBL(11, 2)
deftypeSBL(11, 3)
deftypeSBL(11, 4)
deftypeSBL(11, 5)
deftypeSBL(11, 6)
deftypeSBL(11, 7)
deftypeSBL(11, 8)
deftypeSBL(11, 9)
deftypeSBL(11, 10)
deftypeSBL(11, 11)
deftypeSBL(11, 12)
deftypeSBL(11, 13)
deftypeSBL(11, 14)
deftypeSBL(11, 15)
deftypeSBL(11, 16)
deftypeSBL(11, 17)
deftypeSBL(11, 18)
deftypeSBL(11, 19)
deftypeSBL(11, 20)
deftypeSBL(11, 21)
/* Define signed bitfields at offset 12 */
deftypeSBL(12, 1)
deftypeSBL(12, 2)
deftypeSBL(12, 3)
deftypeSBL(12, 4)
deftypeSBL(12, 5)
deftypeSBL(12, 6)
deftypeSBL(12, 7)
deftypeSBL(12, 8)
deftypeSBL(12, 9)
deftypeSBL(12, 10)
deftypeSBL(12, 11)
deftypeSBL(12, 12)
deftypeSBL(12, 13)
deftypeSBL(12, 14)
deftypeSBL(12, 15)
deftypeSBL(12, 16)
deftypeSBL(12, 17)
deftypeSBL(12, 18)
deftypeSBL(12, 19)
deftypeSBL(12, 20)
/* Define signed bitfields at offset 13 */
deftypeSBL(13, 1)
deftypeSBL(13, 2)
deftypeSBL(13, 3)
deftypeSBL(13, 4)
deftypeSBL(13, 5)
deftypeSBL(13, 6)
deftypeSBL(13, 7)
deftypeSBL(13, 8)
deftypeSBL(13, 9)
deftypeSBL(13, 10)
deftypeSBL(13, 11)
deftypeSBL(13, 12)
deftypeSBL(13, 13)
deftypeSBL(13, 14)
deftypeSBL(13, 15)
deftypeSBL(13, 16)
deftypeSBL(13, 17)
deftypeSBL(13, 18)
deftypeSBL(13, 19)
/* Define signed bitfields at offset 14 */
deftypeSBL(14, 1)
deftypeSBL(14, 2)
deftypeSBL(14, 3)
deftypeSBL(14, 4)
deftypeSBL(14, 5)
deftypeSBL(14, 6)
deftypeSBL(14, 7)
deftypeSBL(14, 8)
deftypeSBL(14, 9)
deftypeSBL(14, 10)
deftypeSBL(14, 11)
deftypeSBL(14, 12)
deftypeSBL(14, 13)
deftypeSBL(14, 14)
deftypeSBL(14, 15)
deftypeSBL(14, 16)
deftypeSBL(14, 17)
deftypeSBL(14, 18)
/* Define signed bitfields at offset 15 */
deftypeSBL(15, 1)
deftypeSBL(15, 2)
deftypeSBL(15, 3)
deftypeSBL(15, 4)
deftypeSBL(15, 5)
deftypeSBL(15, 6)
deftypeSBL(15, 7)
deftypeSBL(15, 8)
deftypeSBL(15, 9)
deftypeSBL(15, 10)
deftypeSBL(15, 11)
deftypeSBL(15, 12)
deftypeSBL(15, 13)
deftypeSBL(15, 14)
deftypeSBL(15, 15)
deftypeSBL(15, 16)
deftypeSBL(15, 17)
/* Define signed bitfields at offset 16 */
deftypeSBL(16, 1)
deftypeSBL(16, 2)
deftypeSBL(16, 3)
deftypeSBL(16, 4)
deftypeSBL(16, 5)
deftypeSBL(16, 6)
deftypeSBL(16, 7)
deftypeSBL(16, 8)
deftypeSBL(16, 9)
deftypeSBL(16, 10)
deftypeSBL(16, 11)
deftypeSBL(16, 12)
deftypeSBL(16, 13)
deftypeSBL(16, 14)
deftypeSBL(16, 15)
deftypeSBL(16, 16)
/* Define signed bitfields at offset 17 */
deftypeSBL(17, 1)
deftypeSBL(17, 2)
deftypeSBL(17, 3)
deftypeSBL(17, 4)
deftypeSBL(17, 5)
deftypeSBL(17, 6)
deftypeSBL(17, 7)
deftypeSBL(17, 8)
deftypeSBL(17, 9)
deftypeSBL(17, 10)
deftypeSBL(17, 11)
deftypeSBL(17, 12)
deftypeSBL(17, 13)
deftypeSBL(17, 14)
deftypeSBL(17, 15)
/* Define signed bitfields at offset 18 */
deftypeSBL(18, 1)
deftypeSBL(18, 2)
deftypeSBL(18, 3)
deftypeSBL(18, 4)
deftypeSBL(18, 5)
deftypeSBL(18, 6)
deftypeSBL(18, 7)
deftypeSBL(18, 8)
deftypeSBL(18, 9)
deftypeSBL(18, 10)
deftypeSBL(18, 11)
deftypeSBL(18, 12)
deftypeSBL(18, 13)
deftypeSBL(18, 14)
/* Define signed bitfields at offset 19 */
deftypeSBL(19, 1)
deftypeSBL(19, 2)
deftypeSBL(19, 3)
deftypeSBL(19, 4)
deftypeSBL(19, 5)
deftypeSBL(19, 6)
deftypeSBL(19, 7)
deftypeSBL(19, 8)
deftypeSBL(19, 9)
deftypeSBL(19, 10)
deftypeSBL(19, 11)
deftypeSBL(19, 12)
deftypeSBL(19, 13)
/* Define signed bitfields at offset 20 */
deftypeSBL(20, 1)
deftypeSBL(20, 2)
deftypeSBL(20, 3)
deftypeSBL(20, 4)
deftypeSBL(20, 5)
deftypeSBL(20, 6)
deftypeSBL(20, 7)
deftypeSBL(20, 8)
deftypeSBL(20, 9)
deftypeSBL(20, 10)
deftypeSBL(20, 11)
deftypeSBL(20, 12)
/* Define signed bitfields at offset 21 */
deftypeSBL(21, 1)
deftypeSBL(21, 2)
deftypeSBL(21, 3)
deftypeSBL(21, 4)
deftypeSBL(21, 5)
deftypeSBL(21, 6)
deftypeSBL(21, 7)
deftypeSBL(21, 8)
deftypeSBL(21, 9)
deftypeSBL(21, 10)
deftypeSBL(21, 11)
/* Define signed bitfields at offset 22 */
deftypeSBL(22, 1)
deftypeSBL(22, 2)
deftypeSBL(22, 3)
deftypeSBL(22, 4)
deftypeSBL(22, 5)
deftypeSBL(22, 6)
deftypeSBL(22, 7)
deftypeSBL(22, 8)
deftypeSBL(22, 9)
deftypeSBL(22, 10)
/* Define signed bitfields at offset 23 */
deftypeSBL(23, 1)
deftypeSBL(23, 2)
deftypeSBL(23, 3)
deftypeSBL(23, 4)
deftypeSBL(23, 5)
deftypeSBL(23, 6)
deftypeSBL(23, 7)
deftypeSBL(23, 8)
deftypeSBL(23, 9)
/* Define signed bitfields at offset 24 */
deftypeSBL(24, 1)
deftypeSBL(24, 2)
deftypeSBL(24, 3)
deftypeSBL(24, 4)
deftypeSBL(24, 5)
deftypeSBL(24, 6)
deftypeSBL(24, 7)
deftypeSBL(24, 8)
/* Define signed bitfields at offset 25 */
deftypeSBL(25, 1)
deftypeSBL(25, 2)
deftypeSBL(25, 3)
deftypeSBL(25, 4)
deftypeSBL(25, 5)
deftypeSBL(25, 6)
deftypeSBL(25, 7)
/* Define signed bitfields at offset 26 */
deftypeSBL(26, 1)
deftypeSBL(26, 2)
deftypeSBL(26, 3)
deftypeSBL(26, 4)
deftypeSBL(26, 5)
deftypeSBL(26, 6)
/* Define signed bitfields at offset 27 */
deftypeSBL(27, 1)
deftypeSBL(27, 2)
deftypeSBL(27, 3)
deftypeSBL(27, 4)
deftypeSBL(27, 5)
/* Define signed bitfields at offset 28 */
deftypeSBL(28, 1)
deftypeSBL(28, 2)
deftypeSBL(28, 3)
deftypeSBL(28, 4)
/* Define signed bitfields at offset 29 */
deftypeSBL(29, 1)
deftypeSBL(29, 2)
deftypeSBL(29, 3)
/* Define signed bitfields at offset 30 */
deftypeSBL(30, 1)
deftypeSBL(30, 2)
/* Define signed bitfields at offset 31 */
deftypeSBL(31, 1)
#if __WORDSIZE == 64 && !SKIP_64_BITS
/* Define signed bitfields at offset 1 */
deftypeSBL(1, 32)
deftypeSBL(1, 33)
deftypeSBL(1, 34)
deftypeSBL(1, 35)
deftypeSBL(1, 36)
deftypeSBL(1, 37)
deftypeSBL(1, 38)
deftypeSBL(1, 39)
deftypeSBL(1, 40)
deftypeSBL(1, 41)
deftypeSBL(1, 42)
deftypeSBL(1, 43)
deftypeSBL(1, 44)
deftypeSBL(1, 45)
deftypeSBL(1, 46)
deftypeSBL(1, 47)
deftypeSBL(1, 48)
deftypeSBL(1, 49)
deftypeSBL(1, 50)
deftypeSBL(1, 51)
deftypeSBL(1, 52)
deftypeSBL(1, 53)
deftypeSBL(1, 54)
deftypeSBL(1, 55)
deftypeSBL(1, 56)
deftypeSBL(1, 57)
deftypeSBL(1, 58)
deftypeSBL(1, 59)
deftypeSBL(1, 60)
deftypeSBL(1, 61)
deftypeSBL(1, 62)
deftypeSBL(1, 63)
/* Define signed bitfields at offset 2 */
deftypeSBL(2, 31)
deftypeSBL(2, 32)
deftypeSBL(2, 33)
deftypeSBL(2, 34)
deftypeSBL(2, 35)
deftypeSBL(2, 36)
deftypeSBL(2, 37)
deftypeSBL(2, 38)
deftypeSBL(2, 39)
deftypeSBL(2, 40)
deftypeSBL(2, 41)
deftypeSBL(2, 42)
deftypeSBL(2, 43)
deftypeSBL(2, 44)
deftypeSBL(2, 45)
deftypeSBL(2, 46)
deftypeSBL(2, 47)
deftypeSBL(2, 48)
deftypeSBL(2, 49)
deftypeSBL(2, 50)
deftypeSBL(2, 51)
deftypeSBL(2, 52)
deftypeSBL(2, 53)
deftypeSBL(2, 54)
deftypeSBL(2, 55)
deftypeSBL(2, 56)
deftypeSBL(2, 57)
deftypeSBL(2, 58)
deftypeSBL(2, 59)
deftypeSBL(2, 60)
deftypeSBL(2, 61)
deftypeSBL(2, 62)
/* Define signed bitfields at offset 3 */
deftypeSBL(3, 30)
deftypeSBL(3, 31)
deftypeSBL(3, 32)
deftypeSBL(3, 33)
deftypeSBL(3, 34)
deftypeSBL(3, 35)
deftypeSBL(3, 36)
deftypeSBL(3, 37)
deftypeSBL(3, 38)
deftypeSBL(3, 39)
deftypeSBL(3, 40)
deftypeSBL(3, 41)
deftypeSBL(3, 42)
deftypeSBL(3, 43)
deftypeSBL(3, 44)
deftypeSBL(3, 45)
deftypeSBL(3, 46)
deftypeSBL(3, 47)
deftypeSBL(3, 48)
deftypeSBL(3, 49)
deftypeSBL(3, 50)
deftypeSBL(3, 51)
deftypeSBL(3, 52)
deftypeSBL(3, 53)
deftypeSBL(3, 54)
deftypeSBL(3, 55)
deftypeSBL(3, 56)
deftypeSBL(3, 57)
deftypeSBL(3, 58)
deftypeSBL(3, 59)
deftypeSBL(3, 60)
deftypeSBL(3, 61)
/* Define signed bitfields at offset 4 */
deftypeSBL(4, 29)
deftypeSBL(4, 30)
deftypeSBL(4, 31)
deftypeSBL(4, 32)
deftypeSBL(4, 33)
deftypeSBL(4, 34)
deftypeSBL(4, 35)
deftypeSBL(4, 36)
deftypeSBL(4, 37)
deftypeSBL(4, 38)
deftypeSBL(4, 39)
deftypeSBL(4, 40)
deftypeSBL(4, 41)
deftypeSBL(4, 42)
deftypeSBL(4, 43)
deftypeSBL(4, 44)
deftypeSBL(4, 45)
deftypeSBL(4, 46)
deftypeSBL(4, 47)
deftypeSBL(4, 48)
deftypeSBL(4, 49)
deftypeSBL(4, 50)
deftypeSBL(4, 51)
deftypeSBL(4, 52)
deftypeSBL(4, 53)
deftypeSBL(4, 54)
deftypeSBL(4, 55)
deftypeSBL(4, 56)
deftypeSBL(4, 57)
deftypeSBL(4, 58)
deftypeSBL(4, 59)
deftypeSBL(4, 60)
/* Define signed bitfields at offset 5 */
deftypeSBL(5, 28)
deftypeSBL(5, 29)
deftypeSBL(5, 30)
deftypeSBL(5, 31)
deftypeSBL(5, 32)
deftypeSBL(5, 33)
deftypeSBL(5, 34)
deftypeSBL(5, 35)
deftypeSBL(5, 36)
deftypeSBL(5, 37)
deftypeSBL(5, 38)
deftypeSBL(5, 39)
deftypeSBL(5, 40)
deftypeSBL(5, 41)
deftypeSBL(5, 42)
deftypeSBL(5, 43)
deftypeSBL(5, 44)
deftypeSBL(5, 45)
deftypeSBL(5, 46)
deftypeSBL(5, 47)
deftypeSBL(5, 48)
deftypeSBL(5, 49)
deftypeSBL(5, 50)
deftypeSBL(5, 51)
deftypeSBL(5, 52)
deftypeSBL(5, 53)
deftypeSBL(5, 54)
deftypeSBL(5, 55)
deftypeSBL(5, 56)
deftypeSBL(5, 57)
deftypeSBL(5, 58)
deftypeSBL(5, 59)
/* Define signed bitfields at offset 6 */
deftypeSBL(6, 27)
deftypeSBL(6, 28)
deftypeSBL(6, 29)
deftypeSBL(6, 30)
deftypeSBL(6, 31)
deftypeSBL(6, 32)
deftypeSBL(6, 33)
deftypeSBL(6, 34)
deftypeSBL(6, 35)
deftypeSBL(6, 36)
deftypeSBL(6, 37)
deftypeSBL(6, 38)
deftypeSBL(6, 39)
deftypeSBL(6, 40)
deftypeSBL(6, 41)
deftypeSBL(6, 42)
deftypeSBL(6, 43)
deftypeSBL(6, 44)
deftypeSBL(6, 45)
deftypeSBL(6, 46)
deftypeSBL(6, 47)
deftypeSBL(6, 48)
deftypeSBL(6, 49)
deftypeSBL(6, 50)
deftypeSBL(6, 51)
deftypeSBL(6, 52)
deftypeSBL(6, 53)
deftypeSBL(6, 54)
deftypeSBL(6, 55)
deftypeSBL(6, 56)
deftypeSBL(6, 57)
deftypeSBL(6, 58)
/* Define signed bitfields at offset 7 */
deftypeSBL(7, 26)
deftypeSBL(7, 27)
deftypeSBL(7, 28)
deftypeSBL(7, 29)
deftypeSBL(7, 30)
deftypeSBL(7, 31)
deftypeSBL(7, 32)
deftypeSBL(7, 33)
deftypeSBL(7, 34)
deftypeSBL(7, 35)
deftypeSBL(7, 36)
deftypeSBL(7, 37)
deftypeSBL(7, 38)
deftypeSBL(7, 39)
deftypeSBL(7, 40)
deftypeSBL(7, 41)
deftypeSBL(7, 42)
deftypeSBL(7, 43)
deftypeSBL(7, 44)
deftypeSBL(7, 45)
deftypeSBL(7, 46)
deftypeSBL(7, 47)
deftypeSBL(7, 48)
deftypeSBL(7, 49)
deftypeSBL(7, 50)
deftypeSBL(7, 51)
deftypeSBL(7, 52)
deftypeSBL(7, 53)
deftypeSBL(7, 54)
deftypeSBL(7, 55)
deftypeSBL(7, 56)
deftypeSBL(7, 57)
/* Define signed bitfields at offset 8 */
deftypeSBL(8, 25)
deftypeSBL(8, 26)
deftypeSBL(8, 27)
deftypeSBL(8, 28)
deftypeSBL(8, 29)
deftypeSBL(8, 30)
deftypeSBL(8, 31)
deftypeSBL(8, 32)
deftypeSBL(8, 33)
deftypeSBL(8, 34)
deftypeSBL(8, 35)
deftypeSBL(8, 36)
deftypeSBL(8, 37)
deftypeSBL(8, 38)
deftypeSBL(8, 39)
deftypeSBL(8, 40)
deftypeSBL(8, 41)
deftypeSBL(8, 42)
deftypeSBL(8, 43)
deftypeSBL(8, 44)
deftypeSBL(8, 45)
deftypeSBL(8, 46)
deftypeSBL(8, 47)
deftypeSBL(8, 48)
deftypeSBL(8, 49)
deftypeSBL(8, 50)
deftypeSBL(8, 51)
deftypeSBL(8, 52)
deftypeSBL(8, 53)
deftypeSBL(8, 54)
deftypeSBL(8, 55)
deftypeSBL(8, 56)
/* Define signed bitfields at offset 9 */
deftypeSBL(9, 24)
deftypeSBL(9, 25)
deftypeSBL(9, 26)
deftypeSBL(9, 27)
deftypeSBL(9, 28)
deftypeSBL(9, 29)
deftypeSBL(9, 30)
deftypeSBL(9, 31)
deftypeSBL(9, 32)
deftypeSBL(9, 33)
deftypeSBL(9, 34)
deftypeSBL(9, 35)
deftypeSBL(9, 36)
deftypeSBL(9, 37)
deftypeSBL(9, 38)
deftypeSBL(9, 39)
deftypeSBL(9, 40)
deftypeSBL(9, 41)
deftypeSBL(9, 42)
deftypeSBL(9, 43)
deftypeSBL(9, 44)
deftypeSBL(9, 45)
deftypeSBL(9, 46)
deftypeSBL(9, 47)
deftypeSBL(9, 48)
deftypeSBL(9, 49)
deftypeSBL(9, 50)
deftypeSBL(9, 51)
deftypeSBL(9, 52)
deftypeSBL(9, 53)
deftypeSBL(9, 54)
deftypeSBL(9, 55)
/* Define signed bitfields at offset 10 */
deftypeSBL(10, 23)
deftypeSBL(10, 24)
deftypeSBL(10, 25)
deftypeSBL(10, 26)
deftypeSBL(10, 27)
deftypeSBL(10, 28)
deftypeSBL(10, 29)
deftypeSBL(10, 30)
deftypeSBL(10, 31)
deftypeSBL(10, 32)
deftypeSBL(10, 33)
deftypeSBL(10, 34)
deftypeSBL(10, 35)
deftypeSBL(10, 36)
deftypeSBL(10, 37)
deftypeSBL(10, 38)
deftypeSBL(10, 39)
deftypeSBL(10, 40)
deftypeSBL(10, 41)
deftypeSBL(10, 42)
deftypeSBL(10, 43)
deftypeSBL(10, 44)
deftypeSBL(10, 45)
deftypeSBL(10, 46)
deftypeSBL(10, 47)
deftypeSBL(10, 48)
deftypeSBL(10, 49)
deftypeSBL(10, 50)
deftypeSBL(10, 51)
deftypeSBL(10, 52)
deftypeSBL(10, 53)
deftypeSBL(10, 54)
/* Define signed bitfields at offset 11 */
deftypeSBL(11, 22)
deftypeSBL(11, 23)
deftypeSBL(11, 24)
deftypeSBL(11, 25)
deftypeSBL(11, 26)
deftypeSBL(11, 27)
deftypeSBL(11, 28)
deftypeSBL(11, 29)
deftypeSBL(11, 30)
deftypeSBL(11, 31)
deftypeSBL(11, 32)
deftypeSBL(11, 33)
deftypeSBL(11, 34)
deftypeSBL(11, 35)
deftypeSBL(11, 36)
deftypeSBL(11, 37)
deftypeSBL(11, 38)
deftypeSBL(11, 39)
deftypeSBL(11, 40)
deftypeSBL(11, 41)
deftypeSBL(11, 42)
deftypeSBL(11, 43)
deftypeSBL(11, 44)
deftypeSBL(11, 45)
deftypeSBL(11, 46)
deftypeSBL(11, 47)
deftypeSBL(11, 48)
deftypeSBL(11, 49)
deftypeSBL(11, 50)
deftypeSBL(11, 51)
deftypeSBL(11, 52)
deftypeSBL(11, 53)
/* Define signed bitfields at offset 12 */
deftypeSBL(12, 21)
deftypeSBL(12, 22)
deftypeSBL(12, 23)
deftypeSBL(12, 24)
deftypeSBL(12, 25)
deftypeSBL(12, 26)
deftypeSBL(12, 27)
deftypeSBL(12, 28)
deftypeSBL(12, 29)
deftypeSBL(12, 30)
deftypeSBL(12, 31)
deftypeSBL(12, 32)
deftypeSBL(12, 33)
deftypeSBL(12, 34)
deftypeSBL(12, 35)
deftypeSBL(12, 36)
deftypeSBL(12, 37)
deftypeSBL(12, 38)
deftypeSBL(12, 39)
deftypeSBL(12, 40)
deftypeSBL(12, 41)
deftypeSBL(12, 42)
deftypeSBL(12, 43)
deftypeSBL(12, 44)
deftypeSBL(12, 45)
deftypeSBL(12, 46)
deftypeSBL(12, 47)
deftypeSBL(12, 48)
deftypeSBL(12, 49)
deftypeSBL(12, 50)
deftypeSBL(12, 51)
deftypeSBL(12, 52)
/* Define signed bitfields at offset 13 */
deftypeSBL(13, 20)
deftypeSBL(13, 21)
deftypeSBL(13, 22)
deftypeSBL(13, 23)
deftypeSBL(13, 24)
deftypeSBL(13, 25)
deftypeSBL(13, 26)
deftypeSBL(13, 27)
deftypeSBL(13, 28)
deftypeSBL(13, 29)
deftypeSBL(13, 30)
deftypeSBL(13, 31)
deftypeSBL(13, 32)
deftypeSBL(13, 33)
deftypeSBL(13, 34)
deftypeSBL(13, 35)
deftypeSBL(13, 36)
deftypeSBL(13, 37)
deftypeSBL(13, 38)
deftypeSBL(13, 39)
deftypeSBL(13, 40)
deftypeSBL(13, 41)
deftypeSBL(13, 42)
deftypeSBL(13, 43)
deftypeSBL(13, 44)
deftypeSBL(13, 45)
deftypeSBL(13, 46)
deftypeSBL(13, 47)
deftypeSBL(13, 48)
deftypeSBL(13, 49)
deftypeSBL(13, 50)
deftypeSBL(13, 51)
/* Define signed bitfields at offset 14 */
deftypeSBL(14, 19)
deftypeSBL(14, 20)
deftypeSBL(14, 21)
deftypeSBL(14, 22)
deftypeSBL(14, 23)
deftypeSBL(14, 24)
deftypeSBL(14, 25)
deftypeSBL(14, 26)
deftypeSBL(14, 27)
deftypeSBL(14, 28)
deftypeSBL(14, 29)
deftypeSBL(14, 30)
deftypeSBL(14, 31)
deftypeSBL(14, 32)
deftypeSBL(14, 33)
deftypeSBL(14, 34)
deftypeSBL(14, 35)
deftypeSBL(14, 36)
deftypeSBL(14, 37)
deftypeSBL(14, 38)
deftypeSBL(14, 39)
deftypeSBL(14, 40)
deftypeSBL(14, 41)
deftypeSBL(14, 42)
deftypeSBL(14, 43)
deftypeSBL(14, 44)
deftypeSBL(14, 45)
deftypeSBL(14, 46)
deftypeSBL(14, 47)
deftypeSBL(14, 48)
deftypeSBL(14, 49)
deftypeSBL(14, 50)
/* Define signed bitfields at offset 15 */
deftypeSBL(15, 18)
deftypeSBL(15, 19)
deftypeSBL(15, 20)
deftypeSBL(15, 21)
deftypeSBL(15, 22)
deftypeSBL(15, 23)
deftypeSBL(15, 24)
deftypeSBL(15, 25)
deftypeSBL(15, 26)
deftypeSBL(15, 27)
deftypeSBL(15, 28)
deftypeSBL(15, 29)
deftypeSBL(15, 30)
deftypeSBL(15, 31)
deftypeSBL(15, 32)
deftypeSBL(15, 33)
deftypeSBL(15, 34)
deftypeSBL(15, 35)
deftypeSBL(15, 36)
deftypeSBL(15, 37)
deftypeSBL(15, 38)
deftypeSBL(15, 39)
deftypeSBL(15, 40)
deftypeSBL(15, 41)
deftypeSBL(15, 42)
deftypeSBL(15, 43)
deftypeSBL(15, 44)
deftypeSBL(15, 45)
deftypeSBL(15, 46)
deftypeSBL(15, 47)
deftypeSBL(15, 48)
deftypeSBL(15, 49)
/* Define signed bitfields at offset 16 */
deftypeSBL(16, 17)
deftypeSBL(16, 18)
deftypeSBL(16, 19)
deftypeSBL(16, 20)
deftypeSBL(16, 21)
deftypeSBL(16, 22)
deftypeSBL(16, 23)
deftypeSBL(16, 24)
deftypeSBL(16, 25)
deftypeSBL(16, 26)
deftypeSBL(16, 27)
deftypeSBL(16, 28)
deftypeSBL(16, 29)
deftypeSBL(16, 30)
deftypeSBL(16, 31)
deftypeSBL(16, 32)
deftypeSBL(16, 33)
deftypeSBL(16, 34)
deftypeSBL(16, 35)
deftypeSBL(16, 36)
deftypeSBL(16, 37)
deftypeSBL(16, 38)
deftypeSBL(16, 39)
deftypeSBL(16, 40)
deftypeSBL(16, 41)
deftypeSBL(16, 42)
deftypeSBL(16, 43)
deftypeSBL(16, 44)
deftypeSBL(16, 45)
deftypeSBL(16, 46)
deftypeSBL(16, 47)
deftypeSBL(16, 48)
/* Define signed bitfields at offset 17 */
deftypeSBL(17, 16)
deftypeSBL(17, 17)
deftypeSBL(17, 18)
deftypeSBL(17, 19)
deftypeSBL(17, 20)
deftypeSBL(17, 21)
deftypeSBL(17, 22)
deftypeSBL(17, 23)
deftypeSBL(17, 24)
deftypeSBL(17, 25)
deftypeSBL(17, 26)
deftypeSBL(17, 27)
deftypeSBL(17, 28)
deftypeSBL(17, 29)
deftypeSBL(17, 30)
deftypeSBL(17, 31)
deftypeSBL(17, 32)
deftypeSBL(17, 33)
deftypeSBL(17, 34)
deftypeSBL(17, 35)
deftypeSBL(17, 36)
deftypeSBL(17, 37)
deftypeSBL(17, 38)
deftypeSBL(17, 39)
deftypeSBL(17, 40)
deftypeSBL(17, 41)
deftypeSBL(17, 42)
deftypeSBL(17, 43)
deftypeSBL(17, 44)
deftypeSBL(17, 45)
deftypeSBL(17, 46)
deftypeSBL(17, 47)
/* Define signed bitfields at offset 18 */
deftypeSBL(18, 15)
deftypeSBL(18, 16)
deftypeSBL(18, 17)
deftypeSBL(18, 18)
deftypeSBL(18, 19)
deftypeSBL(18, 20)
deftypeSBL(18, 21)
deftypeSBL(18, 22)
deftypeSBL(18, 23)
deftypeSBL(18, 24)
deftypeSBL(18, 25)
deftypeSBL(18, 26)
deftypeSBL(18, 27)
deftypeSBL(18, 28)
deftypeSBL(18, 29)
deftypeSBL(18, 30)
deftypeSBL(18, 31)
deftypeSBL(18, 32)
deftypeSBL(18, 33)
deftypeSBL(18, 34)
deftypeSBL(18, 35)
deftypeSBL(18, 36)
deftypeSBL(18, 37)
deftypeSBL(18, 38)
deftypeSBL(18, 39)
deftypeSBL(18, 40)
deftypeSBL(18, 41)
deftypeSBL(18, 42)
deftypeSBL(18, 43)
deftypeSBL(18, 44)
deftypeSBL(18, 45)
deftypeSBL(18, 46)
/* Define signed bitfields at offset 19 */
deftypeSBL(19, 14)
deftypeSBL(19, 15)
deftypeSBL(19, 16)
deftypeSBL(19, 17)
deftypeSBL(19, 18)
deftypeSBL(19, 19)
deftypeSBL(19, 20)
deftypeSBL(19, 21)
deftypeSBL(19, 22)
deftypeSBL(19, 23)
deftypeSBL(19, 24)
deftypeSBL(19, 25)
deftypeSBL(19, 26)
deftypeSBL(19, 27)
deftypeSBL(19, 28)
deftypeSBL(19, 29)
deftypeSBL(19, 30)
deftypeSBL(19, 31)
deftypeSBL(19, 32)
deftypeSBL(19, 33)
deftypeSBL(19, 34)
deftypeSBL(19, 35)
deftypeSBL(19, 36)
deftypeSBL(19, 37)
deftypeSBL(19, 38)
deftypeSBL(19, 39)
deftypeSBL(19, 40)
deftypeSBL(19, 41)
deftypeSBL(19, 42)
deftypeSBL(19, 43)
deftypeSBL(19, 44)
deftypeSBL(19, 45)
/* Define signed bitfields at offset 20 */
deftypeSBL(20, 13)
deftypeSBL(20, 14)
deftypeSBL(20, 15)
deftypeSBL(20, 16)
deftypeSBL(20, 17)
deftypeSBL(20, 18)
deftypeSBL(20, 19)
deftypeSBL(20, 20)
deftypeSBL(20, 21)
deftypeSBL(20, 22)
deftypeSBL(20, 23)
deftypeSBL(20, 24)
deftypeSBL(20, 25)
deftypeSBL(20, 26)
deftypeSBL(20, 27)
deftypeSBL(20, 28)
deftypeSBL(20, 29)
deftypeSBL(20, 30)
deftypeSBL(20, 31)
deftypeSBL(20, 32)
deftypeSBL(20, 33)
deftypeSBL(20, 34)
deftypeSBL(20, 35)
deftypeSBL(20, 36)
deftypeSBL(20, 37)
deftypeSBL(20, 38)
deftypeSBL(20, 39)
deftypeSBL(20, 40)
deftypeSBL(20, 41)
deftypeSBL(20, 42)
deftypeSBL(20, 43)
deftypeSBL(20, 44)
/* Define signed bitfields at offset 21 */
deftypeSBL(21, 12)
deftypeSBL(21, 13)
deftypeSBL(21, 14)
deftypeSBL(21, 15)
deftypeSBL(21, 16)
deftypeSBL(21, 17)
deftypeSBL(21, 18)
deftypeSBL(21, 19)
deftypeSBL(21, 20)
deftypeSBL(21, 21)
deftypeSBL(21, 22)
deftypeSBL(21, 23)
deftypeSBL(21, 24)
deftypeSBL(21, 25)
deftypeSBL(21, 26)
deftypeSBL(21, 27)
deftypeSBL(21, 28)
deftypeSBL(21, 29)
deftypeSBL(21, 30)
deftypeSBL(21, 31)
deftypeSBL(21, 32)
deftypeSBL(21, 33)
deftypeSBL(21, 34)
deftypeSBL(21, 35)
deftypeSBL(21, 36)
deftypeSBL(21, 37)
deftypeSBL(21, 38)
deftypeSBL(21, 39)
deftypeSBL(21, 40)
deftypeSBL(21, 41)
deftypeSBL(21, 42)
deftypeSBL(21, 43)
/* Define signed bitfields at offset 22 */
deftypeSBL(22, 11)
deftypeSBL(22, 12)
deftypeSBL(22, 13)
deftypeSBL(22, 14)
deftypeSBL(22, 15)
deftypeSBL(22, 16)
deftypeSBL(22, 17)
deftypeSBL(22, 18)
deftypeSBL(22, 19)
deftypeSBL(22, 20)
deftypeSBL(22, 21)
deftypeSBL(22, 22)
deftypeSBL(22, 23)
deftypeSBL(22, 24)
deftypeSBL(22, 25)
deftypeSBL(22, 26)
deftypeSBL(22, 27)
deftypeSBL(22, 28)
deftypeSBL(22, 29)
deftypeSBL(22, 30)
deftypeSBL(22, 31)
deftypeSBL(22, 32)
deftypeSBL(22, 33)
deftypeSBL(22, 34)
deftypeSBL(22, 35)
deftypeSBL(22, 36)
deftypeSBL(22, 37)
deftypeSBL(22, 38)
deftypeSBL(22, 39)
deftypeSBL(22, 40)
deftypeSBL(22, 41)
deftypeSBL(22, 42)
/* Define signed bitfields at offset 23 */
deftypeSBL(23, 10)
deftypeSBL(23, 11)
deftypeSBL(23, 12)
deftypeSBL(23, 13)
deftypeSBL(23, 14)
deftypeSBL(23, 15)
deftypeSBL(23, 16)
deftypeSBL(23, 17)
deftypeSBL(23, 18)
deftypeSBL(23, 19)
deftypeSBL(23, 20)
deftypeSBL(23, 21)
deftypeSBL(23, 22)
deftypeSBL(23, 23)
deftypeSBL(23, 24)
deftypeSBL(23, 25)
deftypeSBL(23, 26)
deftypeSBL(23, 27)
deftypeSBL(23, 28)
deftypeSBL(23, 29)
deftypeSBL(23, 30)
deftypeSBL(23, 31)
deftypeSBL(23, 32)
deftypeSBL(23, 33)
deftypeSBL(23, 34)
deftypeSBL(23, 35)
deftypeSBL(23, 36)
deftypeSBL(23, 37)
deftypeSBL(23, 38)
deftypeSBL(23, 39)
deftypeSBL(23, 40)
deftypeSBL(23, 41)
/* Define signed bitfields at offset 24 */
deftypeSBL(24, 9)
deftypeSBL(24, 10)
deftypeSBL(24, 11)
deftypeSBL(24, 12)
deftypeSBL(24, 13)
deftypeSBL(24, 14)
deftypeSBL(24, 15)
deftypeSBL(24, 16)
deftypeSBL(24, 17)
deftypeSBL(24, 18)
deftypeSBL(24, 19)
deftypeSBL(24, 20)
deftypeSBL(24, 21)
deftypeSBL(24, 22)
deftypeSBL(24, 23)
deftypeSBL(24, 24)
deftypeSBL(24, 25)
deftypeSBL(24, 26)
deftypeSBL(24, 27)
deftypeSBL(24, 28)
deftypeSBL(24, 29)
deftypeSBL(24, 30)
deftypeSBL(24, 31)
deftypeSBL(24, 32)
deftypeSBL(24, 33)
deftypeSBL(24, 34)
deftypeSBL(24, 35)
deftypeSBL(24, 36)
deftypeSBL(24, 37)
deftypeSBL(24, 38)
deftypeSBL(24, 39)
deftypeSBL(24, 40)
/* Define signed bitfields at offset 25 */
deftypeSBL(25, 8)
deftypeSBL(25, 9)
deftypeSBL(25, 10)
deftypeSBL(25, 11)
deftypeSBL(25, 12)
deftypeSBL(25, 13)
deftypeSBL(25, 14)
deftypeSBL(25, 15)
deftypeSBL(25, 16)
deftypeSBL(25, 17)
deftypeSBL(25, 18)
deftypeSBL(25, 19)
deftypeSBL(25, 20)
deftypeSBL(25, 21)
deftypeSBL(25, 22)
deftypeSBL(25, 23)
deftypeSBL(25, 24)
deftypeSBL(25, 25)
deftypeSBL(25, 26)
deftypeSBL(25, 27)
deftypeSBL(25, 28)
deftypeSBL(25, 29)
deftypeSBL(25, 30)
deftypeSBL(25, 31)
deftypeSBL(25, 32)
deftypeSBL(25, 33)
deftypeSBL(25, 34)
deftypeSBL(25, 35)
deftypeSBL(25, 36)
deftypeSBL(25, 37)
deftypeSBL(25, 38)
deftypeSBL(25, 39)
/* Define signed bitfields at offset 26 */
deftypeSBL(26, 7)
deftypeSBL(26, 8)
deftypeSBL(26, 9)
deftypeSBL(26, 10)
deftypeSBL(26, 11)
deftypeSBL(26, 12)
deftypeSBL(26, 13)
deftypeSBL(26, 14)
deftypeSBL(26, 15)
deftypeSBL(26, 16)
deftypeSBL(26, 17)
deftypeSBL(26, 18)
deftypeSBL(26, 19)
deftypeSBL(26, 20)
deftypeSBL(26, 21)
deftypeSBL(26, 22)
deftypeSBL(26, 23)
deftypeSBL(26, 24)
deftypeSBL(26, 25)
deftypeSBL(26, 26)
deftypeSBL(26, 27)
deftypeSBL(26, 28)
deftypeSBL(26, 29)
deftypeSBL(26, 30)
deftypeSBL(26, 31)
deftypeSBL(26, 32)
deftypeSBL(26, 33)
deftypeSBL(26, 34)
deftypeSBL(26, 35)
deftypeSBL(26, 36)
deftypeSBL(26, 37)
deftypeSBL(26, 38)
/* Define signed bitfields at offset 27 */
deftypeSBL(27, 6)
deftypeSBL(27, 7)
deftypeSBL(27, 8)
deftypeSBL(27, 9)
deftypeSBL(27, 10)
deftypeSBL(27, 11)
deftypeSBL(27, 12)
deftypeSBL(27, 13)
deftypeSBL(27, 14)
deftypeSBL(27, 15)
deftypeSBL(27, 16)
deftypeSBL(27, 17)
deftypeSBL(27, 18)
deftypeSBL(27, 19)
deftypeSBL(27, 20)
deftypeSBL(27, 21)
deftypeSBL(27, 22)
deftypeSBL(27, 23)
deftypeSBL(27, 24)
deftypeSBL(27, 25)
deftypeSBL(27, 26)
deftypeSBL(27, 27)
deftypeSBL(27, 28)
deftypeSBL(27, 29)
deftypeSBL(27, 30)
deftypeSBL(27, 31)
deftypeSBL(27, 32)
deftypeSBL(27, 33)
deftypeSBL(27, 34)
deftypeSBL(27, 35)
deftypeSBL(27, 36)
deftypeSBL(27, 37)
/* Define signed bitfields at offset 28 */
deftypeSBL(28, 5)
deftypeSBL(28, 6)
deftypeSBL(28, 7)
deftypeSBL(28, 8)
deftypeSBL(28, 9)
deftypeSBL(28, 10)
deftypeSBL(28, 11)
deftypeSBL(28, 12)
deftypeSBL(28, 13)
deftypeSBL(28, 14)
deftypeSBL(28, 15)
deftypeSBL(28, 16)
deftypeSBL(28, 17)
deftypeSBL(28, 18)
deftypeSBL(28, 19)
deftypeSBL(28, 20)
deftypeSBL(28, 21)
deftypeSBL(28, 22)
deftypeSBL(28, 23)
deftypeSBL(28, 24)
deftypeSBL(28, 25)
deftypeSBL(28, 26)
deftypeSBL(28, 27)
deftypeSBL(28, 28)
deftypeSBL(28, 29)
deftypeSBL(28, 30)
deftypeSBL(28, 31)
deftypeSBL(28, 32)
deftypeSBL(28, 33)
deftypeSBL(28, 34)
deftypeSBL(28, 35)
deftypeSBL(28, 36)
/* Define signed bitfields at offset 29 */
deftypeSBL(29, 4)
deftypeSBL(29, 5)
deftypeSBL(29, 6)
deftypeSBL(29, 7)
deftypeSBL(29, 8)
deftypeSBL(29, 9)
deftypeSBL(29, 10)
deftypeSBL(29, 11)
deftypeSBL(29, 12)
deftypeSBL(29, 13)
deftypeSBL(29, 14)
deftypeSBL(29, 15)
deftypeSBL(29, 16)
deftypeSBL(29, 17)
deftypeSBL(29, 18)
deftypeSBL(29, 19)
deftypeSBL(29, 20)
deftypeSBL(29, 21)
deftypeSBL(29, 22)
deftypeSBL(29, 23)
deftypeSBL(29, 24)
deftypeSBL(29, 25)
deftypeSBL(29, 26)
deftypeSBL(29, 27)
deftypeSBL(29, 28)
deftypeSBL(29, 29)
deftypeSBL(29, 30)
deftypeSBL(29, 31)
deftypeSBL(29, 32)
deftypeSBL(29, 33)
deftypeSBL(29, 34)
deftypeSBL(29, 35)
/* Define signed bitfields at offset 30 */
deftypeSBL(30, 3)
deftypeSBL(30, 4)
deftypeSBL(30, 5)
deftypeSBL(30, 6)
deftypeSBL(30, 7)
deftypeSBL(30, 8)
deftypeSBL(30, 9)
deftypeSBL(30, 10)
deftypeSBL(30, 11)
deftypeSBL(30, 12)
deftypeSBL(30, 13)
deftypeSBL(30, 14)
deftypeSBL(30, 15)
deftypeSBL(30, 16)
deftypeSBL(30, 17)
deftypeSBL(30, 18)
deftypeSBL(30, 19)
deftypeSBL(30, 20)
deftypeSBL(30, 21)
deftypeSBL(30, 22)
deftypeSBL(30, 23)
deftypeSBL(30, 24)
deftypeSBL(30, 25)
deftypeSBL(30, 26)
deftypeSBL(30, 27)
deftypeSBL(30, 28)
deftypeSBL(30, 29)
deftypeSBL(30, 30)
deftypeSBL(30, 31)
deftypeSBL(30, 32)
deftypeSBL(30, 33)
deftypeSBL(30, 34)
/* Define signed bitfields at offset 31 */
deftypeSBL(31, 2)
deftypeSBL(31, 3)
deftypeSBL(31, 4)
deftypeSBL(31, 5)
deftypeSBL(31, 6)
deftypeSBL(31, 7)
deftypeSBL(31, 8)
deftypeSBL(31, 9)
deftypeSBL(31, 10)
deftypeSBL(31, 11)
deftypeSBL(31, 12)
deftypeSBL(31, 13)
deftypeSBL(31, 14)
deftypeSBL(31, 15)
deftypeSBL(31, 16)
deftypeSBL(31, 17)
deftypeSBL(31, 18)
deftypeSBL(31, 19)
deftypeSBL(31, 20)
deftypeSBL(31, 21)
deftypeSBL(31, 22)
deftypeSBL(31, 23)
deftypeSBL(31, 24)
deftypeSBL(31, 25)
deftypeSBL(31, 26)
deftypeSBL(31, 27)
deftypeSBL(31, 28)
deftypeSBL(31, 29)
deftypeSBL(31, 30)
deftypeSBL(31, 31)
deftypeSBL(31, 32)
deftypeSBL(31, 33)
/* Define signed bitfields at offset 32 */
deftypeSBL(32, 1)
deftypeSBL(32, 2)
deftypeSBL(32, 3)
deftypeSBL(32, 4)
deftypeSBL(32, 5)
deftypeSBL(32, 6)
deftypeSBL(32, 7)
deftypeSBL(32, 8)
deftypeSBL(32, 9)
deftypeSBL(32, 10)
deftypeSBL(32, 11)
deftypeSBL(32, 12)
deftypeSBL(32, 13)
deftypeSBL(32, 14)
deftypeSBL(32, 15)
deftypeSBL(32, 16)
deftypeSBL(32, 17)
deftypeSBL(32, 18)
deftypeSBL(32, 19)
deftypeSBL(32, 20)
deftypeSBL(32, 21)
deftypeSBL(32, 22)
deftypeSBL(32, 23)
deftypeSBL(32, 24)
deftypeSBL(32, 25)
deftypeSBL(32, 26)
deftypeSBL(32, 27)
deftypeSBL(32, 28)
deftypeSBL(32, 29)
deftypeSBL(32, 30)
deftypeSBL(32, 31)
deftypeSBL(32, 32)
/* Define signed bitfields at offset 33 */
deftypeSBL(33, 1)
deftypeSBL(33, 2)
deftypeSBL(33, 3)
deftypeSBL(33, 4)
deftypeSBL(33, 5)
deftypeSBL(33, 6)
deftypeSBL(33, 7)
deftypeSBL(33, 8)
deftypeSBL(33, 9)
deftypeSBL(33, 10)
deftypeSBL(33, 11)
deftypeSBL(33, 12)
deftypeSBL(33, 13)
deftypeSBL(33, 14)
deftypeSBL(33, 15)
deftypeSBL(33, 16)
deftypeSBL(33, 17)
deftypeSBL(33, 18)
deftypeSBL(33, 19)
deftypeSBL(33, 20)
deftypeSBL(33, 21)
deftypeSBL(33, 22)
deftypeSBL(33, 23)
deftypeSBL(33, 24)
deftypeSBL(33, 25)
deftypeSBL(33, 26)
deftypeSBL(33, 27)
deftypeSBL(33, 28)
deftypeSBL(33, 29)
deftypeSBL(33, 30)
deftypeSBL(33, 31)
/* Define signed bitfields at offset 34 */
deftypeSBL(34, 1)
deftypeSBL(34, 2)
deftypeSBL(34, 3)
deftypeSBL(34, 4)
deftypeSBL(34, 5)
deftypeSBL(34, 6)
deftypeSBL(34, 7)
deftypeSBL(34, 8)
deftypeSBL(34, 9)
deftypeSBL(34, 10)
deftypeSBL(34, 11)
deftypeSBL(34, 12)
deftypeSBL(34, 13)
deftypeSBL(34, 14)
deftypeSBL(34, 15)
deftypeSBL(34, 16)
deftypeSBL(34, 17)
deftypeSBL(34, 18)
deftypeSBL(34, 19)
deftypeSBL(34, 20)
deftypeSBL(34, 21)
deftypeSBL(34, 22)
deftypeSBL(34, 23)
deftypeSBL(34, 24)
deftypeSBL(34, 25)
deftypeSBL(34, 26)
deftypeSBL(34, 27)
deftypeSBL(34, 28)
deftypeSBL(34, 29)
deftypeSBL(34, 30)
/* Define signed bitfields at offset 35 */
deftypeSBL(35, 1)
deftypeSBL(35, 2)
deftypeSBL(35, 3)
deftypeSBL(35, 4)
deftypeSBL(35, 5)
deftypeSBL(35, 6)
deftypeSBL(35, 7)
deftypeSBL(35, 8)
deftypeSBL(35, 9)
deftypeSBL(35, 10)
deftypeSBL(35, 11)
deftypeSBL(35, 12)
deftypeSBL(35, 13)
deftypeSBL(35, 14)
deftypeSBL(35, 15)
deftypeSBL(35, 16)
deftypeSBL(35, 17)
deftypeSBL(35, 18)
deftypeSBL(35, 19)
deftypeSBL(35, 20)
deftypeSBL(35, 21)
deftypeSBL(35, 22)
deftypeSBL(35, 23)
deftypeSBL(35, 24)
deftypeSBL(35, 25)
deftypeSBL(35, 26)
deftypeSBL(35, 27)
deftypeSBL(35, 28)
deftypeSBL(35, 29)
/* Define signed bitfields at offset 36 */
deftypeSBL(36, 1)
deftypeSBL(36, 2)
deftypeSBL(36, 3)
deftypeSBL(36, 4)
deftypeSBL(36, 5)
deftypeSBL(36, 6)
deftypeSBL(36, 7)
deftypeSBL(36, 8)
deftypeSBL(36, 9)
deftypeSBL(36, 10)
deftypeSBL(36, 11)
deftypeSBL(36, 12)
deftypeSBL(36, 13)
deftypeSBL(36, 14)
deftypeSBL(36, 15)
deftypeSBL(36, 16)
deftypeSBL(36, 17)
deftypeSBL(36, 18)
deftypeSBL(36, 19)
deftypeSBL(36, 20)
deftypeSBL(36, 21)
deftypeSBL(36, 22)
deftypeSBL(36, 23)
deftypeSBL(36, 24)
deftypeSBL(36, 25)
deftypeSBL(36, 26)
deftypeSBL(36, 27)
deftypeSBL(36, 28)
/* Define signed bitfields at offset 37 */
deftypeSBL(37, 1)
deftypeSBL(37, 2)
deftypeSBL(37, 3)
deftypeSBL(37, 4)
deftypeSBL(37, 5)
deftypeSBL(37, 6)
deftypeSBL(37, 7)
deftypeSBL(37, 8)
deftypeSBL(37, 9)
deftypeSBL(37, 10)
deftypeSBL(37, 11)
deftypeSBL(37, 12)
deftypeSBL(37, 13)
deftypeSBL(37, 14)
deftypeSBL(37, 15)
deftypeSBL(37, 16)
deftypeSBL(37, 17)
deftypeSBL(37, 18)
deftypeSBL(37, 19)
deftypeSBL(37, 20)
deftypeSBL(37, 21)
deftypeSBL(37, 22)
deftypeSBL(37, 23)
deftypeSBL(37, 24)
deftypeSBL(37, 25)
deftypeSBL(37, 26)
deftypeSBL(37, 27)
/* Define signed bitfields at offset 38 */
deftypeSBL(38, 1)
deftypeSBL(38, 2)
deftypeSBL(38, 3)
deftypeSBL(38, 4)
deftypeSBL(38, 5)
deftypeSBL(38, 6)
deftypeSBL(38, 7)
deftypeSBL(38, 8)
deftypeSBL(38, 9)
deftypeSBL(38, 10)
deftypeSBL(38, 11)
deftypeSBL(38, 12)
deftypeSBL(38, 13)
deftypeSBL(38, 14)
deftypeSBL(38, 15)
deftypeSBL(38, 16)
deftypeSBL(38, 17)
deftypeSBL(38, 18)
deftypeSBL(38, 19)
deftypeSBL(38, 20)
deftypeSBL(38, 21)
deftypeSBL(38, 22)
deftypeSBL(38, 23)
deftypeSBL(38, 24)
deftypeSBL(38, 25)
deftypeSBL(38, 26)
/* Define signed bitfields at offset 39 */
deftypeSBL(39, 1)
deftypeSBL(39, 2)
deftypeSBL(39, 3)
deftypeSBL(39, 4)
deftypeSBL(39, 5)
deftypeSBL(39, 6)
deftypeSBL(39, 7)
deftypeSBL(39, 8)
deftypeSBL(39, 9)
deftypeSBL(39, 10)
deftypeSBL(39, 11)
deftypeSBL(39, 12)
deftypeSBL(39, 13)
deftypeSBL(39, 14)
deftypeSBL(39, 15)
deftypeSBL(39, 16)
deftypeSBL(39, 17)
deftypeSBL(39, 18)
deftypeSBL(39, 19)
deftypeSBL(39, 20)
deftypeSBL(39, 21)
deftypeSBL(39, 22)
deftypeSBL(39, 23)
deftypeSBL(39, 24)
deftypeSBL(39, 25)
/* Define signed bitfields at offset 40 */
deftypeSBL(40, 1)
deftypeSBL(40, 2)
deftypeSBL(40, 3)
deftypeSBL(40, 4)
deftypeSBL(40, 5)
deftypeSBL(40, 6)
deftypeSBL(40, 7)
deftypeSBL(40, 8)
deftypeSBL(40, 9)
deftypeSBL(40, 10)
deftypeSBL(40, 11)
deftypeSBL(40, 12)
deftypeSBL(40, 13)
deftypeSBL(40, 14)
deftypeSBL(40, 15)
deftypeSBL(40, 16)
deftypeSBL(40, 17)
deftypeSBL(40, 18)
deftypeSBL(40, 19)
deftypeSBL(40, 20)
deftypeSBL(40, 21)
deftypeSBL(40, 22)
deftypeSBL(40, 23)
deftypeSBL(40, 24)
/* Define signed bitfields at offset 41 */
deftypeSBL(41, 1)
deftypeSBL(41, 2)
deftypeSBL(41, 3)
deftypeSBL(41, 4)
deftypeSBL(41, 5)
deftypeSBL(41, 6)
deftypeSBL(41, 7)
deftypeSBL(41, 8)
deftypeSBL(41, 9)
deftypeSBL(41, 10)
deftypeSBL(41, 11)
deftypeSBL(41, 12)
deftypeSBL(41, 13)
deftypeSBL(41, 14)
deftypeSBL(41, 15)
deftypeSBL(41, 16)
deftypeSBL(41, 17)
deftypeSBL(41, 18)
deftypeSBL(41, 19)
deftypeSBL(41, 20)
deftypeSBL(41, 21)
deftypeSBL(41, 22)
deftypeSBL(41, 23)
/* Define signed bitfields at offset 42 */
deftypeSBL(42, 1)
deftypeSBL(42, 2)
deftypeSBL(42, 3)
deftypeSBL(42, 4)
deftypeSBL(42, 5)
deftypeSBL(42, 6)
deftypeSBL(42, 7)
deftypeSBL(42, 8)
deftypeSBL(42, 9)
deftypeSBL(42, 10)
deftypeSBL(42, 11)
deftypeSBL(42, 12)
deftypeSBL(42, 13)
deftypeSBL(42, 14)
deftypeSBL(42, 15)
deftypeSBL(42, 16)
deftypeSBL(42, 17)
deftypeSBL(42, 18)
deftypeSBL(42, 19)
deftypeSBL(42, 20)
deftypeSBL(42, 21)
deftypeSBL(42, 22)
/* Define signed bitfields at offset 43 */
deftypeSBL(43, 1)
deftypeSBL(43, 2)
deftypeSBL(43, 3)
deftypeSBL(43, 4)
deftypeSBL(43, 5)
deftypeSBL(43, 6)
deftypeSBL(43, 7)
deftypeSBL(43, 8)
deftypeSBL(43, 9)
deftypeSBL(43, 10)
deftypeSBL(43, 11)
deftypeSBL(43, 12)
deftypeSBL(43, 13)
deftypeSBL(43, 14)
deftypeSBL(43, 15)
deftypeSBL(43, 16)
deftypeSBL(43, 17)
deftypeSBL(43, 18)
deftypeSBL(43, 19)
deftypeSBL(43, 20)
deftypeSBL(43, 21)
/* Define signed bitfields at offset 44 */
deftypeSBL(44, 1)
deftypeSBL(44, 2)
deftypeSBL(44, 3)
deftypeSBL(44, 4)
deftypeSBL(44, 5)
deftypeSBL(44, 6)
deftypeSBL(44, 7)
deftypeSBL(44, 8)
deftypeSBL(44, 9)
deftypeSBL(44, 10)
deftypeSBL(44, 11)
deftypeSBL(44, 12)
deftypeSBL(44, 13)
deftypeSBL(44, 14)
deftypeSBL(44, 15)
deftypeSBL(44, 16)
deftypeSBL(44, 17)
deftypeSBL(44, 18)
deftypeSBL(44, 19)
deftypeSBL(44, 20)
/* Define signed bitfields at offset 45 */
deftypeSBL(45, 1)
deftypeSBL(45, 2)
deftypeSBL(45, 3)
deftypeSBL(45, 4)
deftypeSBL(45, 5)
deftypeSBL(45, 6)
deftypeSBL(45, 7)
deftypeSBL(45, 8)
deftypeSBL(45, 9)
deftypeSBL(45, 10)
deftypeSBL(45, 11)
deftypeSBL(45, 12)
deftypeSBL(45, 13)
deftypeSBL(45, 14)
deftypeSBL(45, 15)
deftypeSBL(45, 16)
deftypeSBL(45, 17)
deftypeSBL(45, 18)
deftypeSBL(45, 19)
/* Define signed bitfields at offset 46 */
deftypeSBL(46, 1)
deftypeSBL(46, 2)
deftypeSBL(46, 3)
deftypeSBL(46, 4)
deftypeSBL(46, 5)
deftypeSBL(46, 6)
deftypeSBL(46, 7)
deftypeSBL(46, 8)
deftypeSBL(46, 9)
deftypeSBL(46, 10)
deftypeSBL(46, 11)
deftypeSBL(46, 12)
deftypeSBL(46, 13)
deftypeSBL(46, 14)
deftypeSBL(46, 15)
deftypeSBL(46, 16)
deftypeSBL(46, 17)
deftypeSBL(46, 18)
/* Define signed bitfields at offset 47 */
deftypeSBL(47, 1)
deftypeSBL(47, 2)
deftypeSBL(47, 3)
deftypeSBL(47, 4)
deftypeSBL(47, 5)
deftypeSBL(47, 6)
deftypeSBL(47, 7)
deftypeSBL(47, 8)
deftypeSBL(47, 9)
deftypeSBL(47, 10)
deftypeSBL(47, 11)
deftypeSBL(47, 12)
deftypeSBL(47, 13)
deftypeSBL(47, 14)
deftypeSBL(47, 15)
deftypeSBL(47, 16)
deftypeSBL(47, 17)
/* Define signed bitfields at offset 48 */
deftypeSBL(48, 1)
deftypeSBL(48, 2)
deftypeSBL(48, 3)
deftypeSBL(48, 4)
deftypeSBL(48, 5)
deftypeSBL(48, 6)
deftypeSBL(48, 7)
deftypeSBL(48, 8)
deftypeSBL(48, 9)
deftypeSBL(48, 10)
deftypeSBL(48, 11)
deftypeSBL(48, 12)
deftypeSBL(48, 13)
deftypeSBL(48, 14)
deftypeSBL(48, 15)
deftypeSBL(48, 16)
/* Define signed bitfields at offset 49 */
deftypeSBL(49, 1)
deftypeSBL(49, 2)
deftypeSBL(49, 3)
deftypeSBL(49, 4)
deftypeSBL(49, 5)
deftypeSBL(49, 6)
deftypeSBL(49, 7)
deftypeSBL(49, 8)
deftypeSBL(49, 9)
deftypeSBL(49, 10)
deftypeSBL(49, 11)
deftypeSBL(49, 12)
deftypeSBL(49, 13)
deftypeSBL(49, 14)
deftypeSBL(49, 15)
/* Define signed bitfields at offset 50 */
deftypeSBL(50, 1)
deftypeSBL(50, 2)
deftypeSBL(50, 3)
deftypeSBL(50, 4)
deftypeSBL(50, 5)
deftypeSBL(50, 6)
deftypeSBL(50, 7)
deftypeSBL(50, 8)
deftypeSBL(50, 9)
deftypeSBL(50, 10)
deftypeSBL(50, 11)
deftypeSBL(50, 12)
deftypeSBL(50, 13)
deftypeSBL(50, 14)
/* Define signed bitfields at offset 51 */
deftypeSBL(51, 1)
deftypeSBL(51, 2)
deftypeSBL(51, 3)
deftypeSBL(51, 4)
deftypeSBL(51, 5)
deftypeSBL(51, 6)
deftypeSBL(51, 7)
deftypeSBL(51, 8)
deftypeSBL(51, 9)
deftypeSBL(51, 10)
deftypeSBL(51, 11)
deftypeSBL(51, 12)
deftypeSBL(51, 13)
/* Define signed bitfields at offset 52 */
deftypeSBL(52, 1)
deftypeSBL(52, 2)
deftypeSBL(52, 3)
deftypeSBL(52, 4)
deftypeSBL(52, 5)
deftypeSBL(52, 6)
deftypeSBL(52, 7)
deftypeSBL(52, 8)
deftypeSBL(52, 9)
deftypeSBL(52, 10)
deftypeSBL(52, 11)
deftypeSBL(52, 12)
/* Define signed bitfields at offset 53 */
deftypeSBL(53, 1)
deftypeSBL(53, 2)
deftypeSBL(53, 3)
deftypeSBL(53, 4)
deftypeSBL(53, 5)
deftypeSBL(53, 6)
deftypeSBL(53, 7)
deftypeSBL(53, 8)
deftypeSBL(53, 9)
deftypeSBL(53, 10)
deftypeSBL(53, 11)
/* Define signed bitfields at offset 54 */
deftypeSBL(54, 1)
deftypeSBL(54, 2)
deftypeSBL(54, 3)
deftypeSBL(54, 4)
deftypeSBL(54, 5)
deftypeSBL(54, 6)
deftypeSBL(54, 7)
deftypeSBL(54, 8)
deftypeSBL(54, 9)
deftypeSBL(54, 10)
/* Define signed bitfields at offset 55 */
deftypeSBL(55, 1)
deftypeSBL(55, 2)
deftypeSBL(55, 3)
deftypeSBL(55, 4)
deftypeSBL(55, 5)
deftypeSBL(55, 6)
deftypeSBL(55, 7)
deftypeSBL(55, 8)
deftypeSBL(55, 9)
/* Define signed bitfields at offset 56 */
deftypeSBL(56, 1)
deftypeSBL(56, 2)
deftypeSBL(56, 3)
deftypeSBL(56, 4)
deftypeSBL(56, 5)
deftypeSBL(56, 6)
deftypeSBL(56, 7)
deftypeSBL(56, 8)
/* Define signed bitfields at offset 57 */
deftypeSBL(57, 1)
deftypeSBL(57, 2)
deftypeSBL(57, 3)
deftypeSBL(57, 4)
deftypeSBL(57, 5)
deftypeSBL(57, 6)
deftypeSBL(57, 7)
/* Define signed bitfields at offset 58 */
deftypeSBL(58, 1)
deftypeSBL(58, 2)
deftypeSBL(58, 3)
deftypeSBL(58, 4)
deftypeSBL(58, 5)
deftypeSBL(58, 6)
/* Define signed bitfields at offset 59 */
deftypeSBL(59, 1)
deftypeSBL(59, 2)
deftypeSBL(59, 3)
deftypeSBL(59, 4)
deftypeSBL(59, 5)
/* Define signed bitfields at offset 60 */
deftypeSBL(60, 1)
deftypeSBL(60, 2)
deftypeSBL(60, 3)
deftypeSBL(60, 4)
/* Define signed bitfields at offset 61 */
deftypeSBL(61, 1)
deftypeSBL(61, 2)
deftypeSBL(61, 3)
/* Define signed bitfields at offset 62 */
deftypeSBL(62, 1)
deftypeSBL(62, 2)
/* Define signed bitfields at offset 63 */
deftypeSBL(63, 1)
#endif
/* Define unsigned bitfields at offset 1 */
deftypeUBL(1, 1)
deftypeUBL(1, 2)
deftypeUBL(1, 3)
deftypeUBL(1, 4)
deftypeUBL(1, 5)
deftypeUBL(1, 6)
deftypeUBL(1, 7)
deftypeUBL(1, 8)
deftypeUBL(1, 9)
deftypeUBL(1, 10)
deftypeUBL(1, 11)
deftypeUBL(1, 12)
deftypeUBL(1, 13)
deftypeUBL(1, 14)
deftypeUBL(1, 15)
deftypeUBL(1, 16)
deftypeUBL(1, 17)
deftypeUBL(1, 18)
deftypeUBL(1, 19)
deftypeUBL(1, 20)
deftypeUBL(1, 21)
deftypeUBL(1, 22)
deftypeUBL(1, 23)
deftypeUBL(1, 24)
deftypeUBL(1, 25)
deftypeUBL(1, 26)
deftypeUBL(1, 27)
deftypeUBL(1, 28)
deftypeUBL(1, 29)
deftypeUBL(1, 30)
deftypeUBL(1, 31)
/* Define unsigned bitfields at offset 2 */
deftypeUBL(2, 1)
deftypeUBL(2, 2)
deftypeUBL(2, 3)
deftypeUBL(2, 4)
deftypeUBL(2, 5)
deftypeUBL(2, 6)
deftypeUBL(2, 7)
deftypeUBL(2, 8)
deftypeUBL(2, 9)
deftypeUBL(2, 10)
deftypeUBL(2, 11)
deftypeUBL(2, 12)
deftypeUBL(2, 13)
deftypeUBL(2, 14)
deftypeUBL(2, 15)
deftypeUBL(2, 16)
deftypeUBL(2, 17)
deftypeUBL(2, 18)
deftypeUBL(2, 19)
deftypeUBL(2, 20)
deftypeUBL(2, 21)
deftypeUBL(2, 22)
deftypeUBL(2, 23)
deftypeUBL(2, 24)
deftypeUBL(2, 25)
deftypeUBL(2, 26)
deftypeUBL(2, 27)
deftypeUBL(2, 28)
deftypeUBL(2, 29)
deftypeUBL(2, 30)
/* Define unsigned bitfields at offset 3 */
deftypeUBL(3, 1)
deftypeUBL(3, 2)
deftypeUBL(3, 3)
deftypeUBL(3, 4)
deftypeUBL(3, 5)
deftypeUBL(3, 6)
deftypeUBL(3, 7)
deftypeUBL(3, 8)
deftypeUBL(3, 9)
deftypeUBL(3, 10)
deftypeUBL(3, 11)
deftypeUBL(3, 12)
deftypeUBL(3, 13)
deftypeUBL(3, 14)
deftypeUBL(3, 15)
deftypeUBL(3, 16)
deftypeUBL(3, 17)
deftypeUBL(3, 18)
deftypeUBL(3, 19)
deftypeUBL(3, 20)
deftypeUBL(3, 21)
deftypeUBL(3, 22)
deftypeUBL(3, 23)
deftypeUBL(3, 24)
deftypeUBL(3, 25)
deftypeUBL(3, 26)
deftypeUBL(3, 27)
deftypeUBL(3, 28)
deftypeUBL(3, 29)
/* Define unsigned bitfields at offset 4 */
deftypeUBL(4, 1)
deftypeUBL(4, 2)
deftypeUBL(4, 3)
deftypeUBL(4, 4)
deftypeUBL(4, 5)
deftypeUBL(4, 6)
deftypeUBL(4, 7)
deftypeUBL(4, 8)
deftypeUBL(4, 9)
deftypeUBL(4, 10)
deftypeUBL(4, 11)
deftypeUBL(4, 12)
deftypeUBL(4, 13)
deftypeUBL(4, 14)
deftypeUBL(4, 15)
deftypeUBL(4, 16)
deftypeUBL(4, 17)
deftypeUBL(4, 18)
deftypeUBL(4, 19)
deftypeUBL(4, 20)
deftypeUBL(4, 21)
deftypeUBL(4, 22)
deftypeUBL(4, 23)
deftypeUBL(4, 24)
deftypeUBL(4, 25)
deftypeUBL(4, 26)
deftypeUBL(4, 27)
deftypeUBL(4, 28)
/* Define unsigned bitfields at offset 5 */
deftypeUBL(5, 1)
deftypeUBL(5, 2)
deftypeUBL(5, 3)
deftypeUBL(5, 4)
deftypeUBL(5, 5)
deftypeUBL(5, 6)
deftypeUBL(5, 7)
deftypeUBL(5, 8)
deftypeUBL(5, 9)
deftypeUBL(5, 10)
deftypeUBL(5, 11)
deftypeUBL(5, 12)
deftypeUBL(5, 13)
deftypeUBL(5, 14)
deftypeUBL(5, 15)
deftypeUBL(5, 16)
deftypeUBL(5, 17)
deftypeUBL(5, 18)
deftypeUBL(5, 19)
deftypeUBL(5, 20)
deftypeUBL(5, 21)
deftypeUBL(5, 22)
deftypeUBL(5, 23)
deftypeUBL(5, 24)
deftypeUBL(5, 25)
deftypeUBL(5, 26)
deftypeUBL(5, 27)
/* Define unsigned bitfields at offset 6 */
deftypeUBL(6, 1)
deftypeUBL(6, 2)
deftypeUBL(6, 3)
deftypeUBL(6, 4)
deftypeUBL(6, 5)
deftypeUBL(6, 6)
deftypeUBL(6, 7)
deftypeUBL(6, 8)
deftypeUBL(6, 9)
deftypeUBL(6, 10)
deftypeUBL(6, 11)
deftypeUBL(6, 12)
deftypeUBL(6, 13)
deftypeUBL(6, 14)
deftypeUBL(6, 15)
deftypeUBL(6, 16)
deftypeUBL(6, 17)
deftypeUBL(6, 18)
deftypeUBL(6, 19)
deftypeUBL(6, 20)
deftypeUBL(6, 21)
deftypeUBL(6, 22)
deftypeUBL(6, 23)
deftypeUBL(6, 24)
deftypeUBL(6, 25)
deftypeUBL(6, 26)
/* Define unsigned bitfields at offset 7 */
deftypeUBL(7, 1)
deftypeUBL(7, 2)
deftypeUBL(7, 3)
deftypeUBL(7, 4)
deftypeUBL(7, 5)
deftypeUBL(7, 6)
deftypeUBL(7, 7)
deftypeUBL(7, 8)
deftypeUBL(7, 9)
deftypeUBL(7, 10)
deftypeUBL(7, 11)
deftypeUBL(7, 12)
deftypeUBL(7, 13)
deftypeUBL(7, 14)
deftypeUBL(7, 15)
deftypeUBL(7, 16)
deftypeUBL(7, 17)
deftypeUBL(7, 18)
deftypeUBL(7, 19)
deftypeUBL(7, 20)
deftypeUBL(7, 21)
deftypeUBL(7, 22)
deftypeUBL(7, 23)
deftypeUBL(7, 24)
deftypeUBL(7, 25)
/* Define unsigned bitfields at offset 8 */
deftypeUBL(8, 1)
deftypeUBL(8, 2)
deftypeUBL(8, 3)
deftypeUBL(8, 4)
deftypeUBL(8, 5)
deftypeUBL(8, 6)
deftypeUBL(8, 7)
deftypeUBL(8, 8)
deftypeUBL(8, 9)
deftypeUBL(8, 10)
deftypeUBL(8, 11)
deftypeUBL(8, 12)
deftypeUBL(8, 13)
deftypeUBL(8, 14)
deftypeUBL(8, 15)
deftypeUBL(8, 16)
deftypeUBL(8, 17)
deftypeUBL(8, 18)
deftypeUBL(8, 19)
deftypeUBL(8, 20)
deftypeUBL(8, 21)
deftypeUBL(8, 22)
deftypeUBL(8, 23)
deftypeUBL(8, 24)
/* Define unsigned bitfields at offset 9 */
deftypeUBL(9, 1)
deftypeUBL(9, 2)
deftypeUBL(9, 3)
deftypeUBL(9, 4)
deftypeUBL(9, 5)
deftypeUBL(9, 6)
deftypeUBL(9, 7)
deftypeUBL(9, 8)
deftypeUBL(9, 9)
deftypeUBL(9, 10)
deftypeUBL(9, 11)
deftypeUBL(9, 12)
deftypeUBL(9, 13)
deftypeUBL(9, 14)
deftypeUBL(9, 15)
deftypeUBL(9, 16)
deftypeUBL(9, 17)
deftypeUBL(9, 18)
deftypeUBL(9, 19)
deftypeUBL(9, 20)
deftypeUBL(9, 21)
deftypeUBL(9, 22)
deftypeUBL(9, 23)
/* Define unsigned bitfields at offset 10 */
deftypeUBL(10, 1)
deftypeUBL(10, 2)
deftypeUBL(10, 3)
deftypeUBL(10, 4)
deftypeUBL(10, 5)
deftypeUBL(10, 6)
deftypeUBL(10, 7)
deftypeUBL(10, 8)
deftypeUBL(10, 9)
deftypeUBL(10, 10)
deftypeUBL(10, 11)
deftypeUBL(10, 12)
deftypeUBL(10, 13)
deftypeUBL(10, 14)
deftypeUBL(10, 15)
deftypeUBL(10, 16)
deftypeUBL(10, 17)
deftypeUBL(10, 18)
deftypeUBL(10, 19)
deftypeUBL(10, 20)
deftypeUBL(10, 21)
deftypeUBL(10, 22)
/* Define unsigned bitfields at offset 11 */
deftypeUBL(11, 1)
deftypeUBL(11, 2)
deftypeUBL(11, 3)
deftypeUBL(11, 4)
deftypeUBL(11, 5)
deftypeUBL(11, 6)
deftypeUBL(11, 7)
deftypeUBL(11, 8)
deftypeUBL(11, 9)
deftypeUBL(11, 10)
deftypeUBL(11, 11)
deftypeUBL(11, 12)
deftypeUBL(11, 13)
deftypeUBL(11, 14)
deftypeUBL(11, 15)
deftypeUBL(11, 16)
deftypeUBL(11, 17)
deftypeUBL(11, 18)
deftypeUBL(11, 19)
deftypeUBL(11, 20)
deftypeUBL(11, 21)
/* Define unsigned bitfields at offset 12 */
deftypeUBL(12, 1)
deftypeUBL(12, 2)
deftypeUBL(12, 3)
deftypeUBL(12, 4)
deftypeUBL(12, 5)
deftypeUBL(12, 6)
deftypeUBL(12, 7)
deftypeUBL(12, 8)
deftypeUBL(12, 9)
deftypeUBL(12, 10)
deftypeUBL(12, 11)
deftypeUBL(12, 12)
deftypeUBL(12, 13)
deftypeUBL(12, 14)
deftypeUBL(12, 15)
deftypeUBL(12, 16)
deftypeUBL(12, 17)
deftypeUBL(12, 18)
deftypeUBL(12, 19)
deftypeUBL(12, 20)
/* Define unsigned bitfields at offset 13 */
deftypeUBL(13, 1)
deftypeUBL(13, 2)
deftypeUBL(13, 3)
deftypeUBL(13, 4)
deftypeUBL(13, 5)
deftypeUBL(13, 6)
deftypeUBL(13, 7)
deftypeUBL(13, 8)
deftypeUBL(13, 9)
deftypeUBL(13, 10)
deftypeUBL(13, 11)
deftypeUBL(13, 12)
deftypeUBL(13, 13)
deftypeUBL(13, 14)
deftypeUBL(13, 15)
deftypeUBL(13, 16)
deftypeUBL(13, 17)
deftypeUBL(13, 18)
deftypeUBL(13, 19)
/* Define unsigned bitfields at offset 14 */
deftypeUBL(14, 1)
deftypeUBL(14, 2)
deftypeUBL(14, 3)
deftypeUBL(14, 4)
deftypeUBL(14, 5)
deftypeUBL(14, 6)
deftypeUBL(14, 7)
deftypeUBL(14, 8)
deftypeUBL(14, 9)
deftypeUBL(14, 10)
deftypeUBL(14, 11)
deftypeUBL(14, 12)
deftypeUBL(14, 13)
deftypeUBL(14, 14)
deftypeUBL(14, 15)
deftypeUBL(14, 16)
deftypeUBL(14, 17)
deftypeUBL(14, 18)
/* Define unsigned bitfields at offset 15 */
deftypeUBL(15, 1)
deftypeUBL(15, 2)
deftypeUBL(15, 3)
deftypeUBL(15, 4)
deftypeUBL(15, 5)
deftypeUBL(15, 6)
deftypeUBL(15, 7)
deftypeUBL(15, 8)
deftypeUBL(15, 9)
deftypeUBL(15, 10)
deftypeUBL(15, 11)
deftypeUBL(15, 12)
deftypeUBL(15, 13)
deftypeUBL(15, 14)
deftypeUBL(15, 15)
deftypeUBL(15, 16)
deftypeUBL(15, 17)
/* Define unsigned bitfields at offset 16 */
deftypeUBL(16, 1)
deftypeUBL(16, 2)
deftypeUBL(16, 3)
deftypeUBL(16, 4)
deftypeUBL(16, 5)
deftypeUBL(16, 6)
deftypeUBL(16, 7)
deftypeUBL(16, 8)
deftypeUBL(16, 9)
deftypeUBL(16, 10)
deftypeUBL(16, 11)
deftypeUBL(16, 12)
deftypeUBL(16, 13)
deftypeUBL(16, 14)
deftypeUBL(16, 15)
deftypeUBL(16, 16)
/* Define unsigned bitfields at offset 17 */
deftypeUBL(17, 1)
deftypeUBL(17, 2)
deftypeUBL(17, 3)
deftypeUBL(17, 4)
deftypeUBL(17, 5)
deftypeUBL(17, 6)
deftypeUBL(17, 7)
deftypeUBL(17, 8)
deftypeUBL(17, 9)
deftypeUBL(17, 10)
deftypeUBL(17, 11)
deftypeUBL(17, 12)
deftypeUBL(17, 13)
deftypeUBL(17, 14)
deftypeUBL(17, 15)
/* Define unsigned bitfields at offset 18 */
deftypeUBL(18, 1)
deftypeUBL(18, 2)
deftypeUBL(18, 3)
deftypeUBL(18, 4)
deftypeUBL(18, 5)
deftypeUBL(18, 6)
deftypeUBL(18, 7)
deftypeUBL(18, 8)
deftypeUBL(18, 9)
deftypeUBL(18, 10)
deftypeUBL(18, 11)
deftypeUBL(18, 12)
deftypeUBL(18, 13)
deftypeUBL(18, 14)
/* Define unsigned bitfields at offset 19 */
deftypeUBL(19, 1)
deftypeUBL(19, 2)
deftypeUBL(19, 3)
deftypeUBL(19, 4)
deftypeUBL(19, 5)
deftypeUBL(19, 6)
deftypeUBL(19, 7)
deftypeUBL(19, 8)
deftypeUBL(19, 9)
deftypeUBL(19, 10)
deftypeUBL(19, 11)
deftypeUBL(19, 12)
deftypeUBL(19, 13)
/* Define unsigned bitfields at offset 20 */
deftypeUBL(20, 1)
deftypeUBL(20, 2)
deftypeUBL(20, 3)
deftypeUBL(20, 4)
deftypeUBL(20, 5)
deftypeUBL(20, 6)
deftypeUBL(20, 7)
deftypeUBL(20, 8)
deftypeUBL(20, 9)
deftypeUBL(20, 10)
deftypeUBL(20, 11)
deftypeUBL(20, 12)
/* Define unsigned bitfields at offset 21 */
deftypeUBL(21, 1)
deftypeUBL(21, 2)
deftypeUBL(21, 3)
deftypeUBL(21, 4)
deftypeUBL(21, 5)
deftypeUBL(21, 6)
deftypeUBL(21, 7)
deftypeUBL(21, 8)
deftypeUBL(21, 9)
deftypeUBL(21, 10)
deftypeUBL(21, 11)
/* Define unsigned bitfields at offset 22 */
deftypeUBL(22, 1)
deftypeUBL(22, 2)
deftypeUBL(22, 3)
deftypeUBL(22, 4)
deftypeUBL(22, 5)
deftypeUBL(22, 6)
deftypeUBL(22, 7)
deftypeUBL(22, 8)
deftypeUBL(22, 9)
deftypeUBL(22, 10)
/* Define unsigned bitfields at offset 23 */
deftypeUBL(23, 1)
deftypeUBL(23, 2)
deftypeUBL(23, 3)
deftypeUBL(23, 4)
deftypeUBL(23, 5)
deftypeUBL(23, 6)
deftypeUBL(23, 7)
deftypeUBL(23, 8)
deftypeUBL(23, 9)
/* Define unsigned bitfields at offset 24 */
deftypeUBL(24, 1)
deftypeUBL(24, 2)
deftypeUBL(24, 3)
deftypeUBL(24, 4)
deftypeUBL(24, 5)
deftypeUBL(24, 6)
deftypeUBL(24, 7)
deftypeUBL(24, 8)
/* Define unsigned bitfields at offset 25 */
deftypeUBL(25, 1)
deftypeUBL(25, 2)
deftypeUBL(25, 3)
deftypeUBL(25, 4)
deftypeUBL(25, 5)
deftypeUBL(25, 6)
deftypeUBL(25, 7)
/* Define unsigned bitfields at offset 26 */
deftypeUBL(26, 1)
deftypeUBL(26, 2)
deftypeUBL(26, 3)
deftypeUBL(26, 4)
deftypeUBL(26, 5)
deftypeUBL(26, 6)
/* Define unsigned bitfields at offset 27 */
deftypeUBL(27, 1)
deftypeUBL(27, 2)
deftypeUBL(27, 3)
deftypeUBL(27, 4)
deftypeUBL(27, 5)
/* Define unsigned bitfields at offset 28 */
deftypeUBL(28, 1)
deftypeUBL(28, 2)
deftypeUBL(28, 3)
deftypeUBL(28, 4)
/* Define unsigned bitfields at offset 29 */
deftypeUBL(29, 1)
deftypeUBL(29, 2)
deftypeUBL(29, 3)
/* Define unsigned bitfields at offset 30 */
deftypeUBL(30, 1)
deftypeUBL(30, 2)
/* Define unsigned bitfields at offset 31 */
deftypeUBL(31, 1)
#if __WORDSIZE == 64 && !SKIP_64_BITS
/* Define unsigned bitfields at offset 1 */
deftypeUBL(1, 32)
deftypeUBL(1, 33)
deftypeUBL(1, 34)
deftypeUBL(1, 35)
deftypeUBL(1, 36)
deftypeUBL(1, 37)
deftypeUBL(1, 38)
deftypeUBL(1, 39)
deftypeUBL(1, 40)
deftypeUBL(1, 41)
deftypeUBL(1, 42)
deftypeUBL(1, 43)
deftypeUBL(1, 44)
deftypeUBL(1, 45)
deftypeUBL(1, 46)
deftypeUBL(1, 47)
deftypeUBL(1, 48)
deftypeUBL(1, 49)
deftypeUBL(1, 50)
deftypeUBL(1, 51)
deftypeUBL(1, 52)
deftypeUBL(1, 53)
deftypeUBL(1, 54)
deftypeUBL(1, 55)
deftypeUBL(1, 56)
deftypeUBL(1, 57)
deftypeUBL(1, 58)
deftypeUBL(1, 59)
deftypeUBL(1, 60)
deftypeUBL(1, 61)
deftypeUBL(1, 62)
deftypeUBL(1, 63)
/* Define unsigned bitfields at offset 2 */
deftypeUBL(2, 31)
deftypeUBL(2, 32)
deftypeUBL(2, 33)
deftypeUBL(2, 34)
deftypeUBL(2, 35)
deftypeUBL(2, 36)
deftypeUBL(2, 37)
deftypeUBL(2, 38)
deftypeUBL(2, 39)
deftypeUBL(2, 40)
deftypeUBL(2, 41)
deftypeUBL(2, 42)
deftypeUBL(2, 43)
deftypeUBL(2, 44)
deftypeUBL(2, 45)
deftypeUBL(2, 46)
deftypeUBL(2, 47)
deftypeUBL(2, 48)
deftypeUBL(2, 49)
deftypeUBL(2, 50)
deftypeUBL(2, 51)
deftypeUBL(2, 52)
deftypeUBL(2, 53)
deftypeUBL(2, 54)
deftypeUBL(2, 55)
deftypeUBL(2, 56)
deftypeUBL(2, 57)
deftypeUBL(2, 58)
deftypeUBL(2, 59)
deftypeUBL(2, 60)
deftypeUBL(2, 61)
deftypeUBL(2, 62)
/* Define unsigned bitfields at offset 3 */
deftypeUBL(3, 30)
deftypeUBL(3, 31)
deftypeUBL(3, 32)
deftypeUBL(3, 33)
deftypeUBL(3, 34)
deftypeUBL(3, 35)
deftypeUBL(3, 36)
deftypeUBL(3, 37)
deftypeUBL(3, 38)
deftypeUBL(3, 39)
deftypeUBL(3, 40)
deftypeUBL(3, 41)
deftypeUBL(3, 42)
deftypeUBL(3, 43)
deftypeUBL(3, 44)
deftypeUBL(3, 45)
deftypeUBL(3, 46)
deftypeUBL(3, 47)
deftypeUBL(3, 48)
deftypeUBL(3, 49)
deftypeUBL(3, 50)
deftypeUBL(3, 51)
deftypeUBL(3, 52)
deftypeUBL(3, 53)
deftypeUBL(3, 54)
deftypeUBL(3, 55)
deftypeUBL(3, 56)
deftypeUBL(3, 57)
deftypeUBL(3, 58)
deftypeUBL(3, 59)
deftypeUBL(3, 60)
deftypeUBL(3, 61)
/* Define unsigned bitfields at offset 4 */
deftypeUBL(4, 29)
deftypeUBL(4, 30)
deftypeUBL(4, 31)
deftypeUBL(4, 32)
deftypeUBL(4, 33)
deftypeUBL(4, 34)
deftypeUBL(4, 35)
deftypeUBL(4, 36)
deftypeUBL(4, 37)
deftypeUBL(4, 38)
deftypeUBL(4, 39)
deftypeUBL(4, 40)
deftypeUBL(4, 41)
deftypeUBL(4, 42)
deftypeUBL(4, 43)
deftypeUBL(4, 44)
deftypeUBL(4, 45)
deftypeUBL(4, 46)
deftypeUBL(4, 47)
deftypeUBL(4, 48)
deftypeUBL(4, 49)
deftypeUBL(4, 50)
deftypeUBL(4, 51)
deftypeUBL(4, 52)
deftypeUBL(4, 53)
deftypeUBL(4, 54)
deftypeUBL(4, 55)
deftypeUBL(4, 56)
deftypeUBL(4, 57)
deftypeUBL(4, 58)
deftypeUBL(4, 59)
deftypeUBL(4, 60)
/* Define unsigned bitfields at offset 5 */
deftypeUBL(5, 28)
deftypeUBL(5, 29)
deftypeUBL(5, 30)
deftypeUBL(5, 31)
deftypeUBL(5, 32)
deftypeUBL(5, 33)
deftypeUBL(5, 34)
deftypeUBL(5, 35)
deftypeUBL(5, 36)
deftypeUBL(5, 37)
deftypeUBL(5, 38)
deftypeUBL(5, 39)
deftypeUBL(5, 40)
deftypeUBL(5, 41)
deftypeUBL(5, 42)
deftypeUBL(5, 43)
deftypeUBL(5, 44)
deftypeUBL(5, 45)
deftypeUBL(5, 46)
deftypeUBL(5, 47)
deftypeUBL(5, 48)
deftypeUBL(5, 49)
deftypeUBL(5, 50)
deftypeUBL(5, 51)
deftypeUBL(5, 52)
deftypeUBL(5, 53)
deftypeUBL(5, 54)
deftypeUBL(5, 55)
deftypeUBL(5, 56)
deftypeUBL(5, 57)
deftypeUBL(5, 58)
deftypeUBL(5, 59)
/* Define unsigned bitfields at offset 6 */
deftypeUBL(6, 27)
deftypeUBL(6, 28)
deftypeUBL(6, 29)
deftypeUBL(6, 30)
deftypeUBL(6, 31)
deftypeUBL(6, 32)
deftypeUBL(6, 33)
deftypeUBL(6, 34)
deftypeUBL(6, 35)
deftypeUBL(6, 36)
deftypeUBL(6, 37)
deftypeUBL(6, 38)
deftypeUBL(6, 39)
deftypeUBL(6, 40)
deftypeUBL(6, 41)
deftypeUBL(6, 42)
deftypeUBL(6, 43)
deftypeUBL(6, 44)
deftypeUBL(6, 45)
deftypeUBL(6, 46)
deftypeUBL(6, 47)
deftypeUBL(6, 48)
deftypeUBL(6, 49)
deftypeUBL(6, 50)
deftypeUBL(6, 51)
deftypeUBL(6, 52)
deftypeUBL(6, 53)
deftypeUBL(6, 54)
deftypeUBL(6, 55)
deftypeUBL(6, 56)
deftypeUBL(6, 57)
deftypeUBL(6, 58)
/* Define unsigned bitfields at offset 7 */
deftypeUBL(7, 26)
deftypeUBL(7, 27)
deftypeUBL(7, 28)
deftypeUBL(7, 29)
deftypeUBL(7, 30)
deftypeUBL(7, 31)
deftypeUBL(7, 32)
deftypeUBL(7, 33)
deftypeUBL(7, 34)
deftypeUBL(7, 35)
deftypeUBL(7, 36)
deftypeUBL(7, 37)
deftypeUBL(7, 38)
deftypeUBL(7, 39)
deftypeUBL(7, 40)
deftypeUBL(7, 41)
deftypeUBL(7, 42)
deftypeUBL(7, 43)
deftypeUBL(7, 44)
deftypeUBL(7, 45)
deftypeUBL(7, 46)
deftypeUBL(7, 47)
deftypeUBL(7, 48)
deftypeUBL(7, 49)
deftypeUBL(7, 50)
deftypeUBL(7, 51)
deftypeUBL(7, 52)
deftypeUBL(7, 53)
deftypeUBL(7, 54)
deftypeUBL(7, 55)
deftypeUBL(7, 56)
deftypeUBL(7, 57)
/* Define unsigned bitfields at offset 8 */
deftypeUBL(8, 25)
deftypeUBL(8, 26)
deftypeUBL(8, 27)
deftypeUBL(8, 28)
deftypeUBL(8, 29)
deftypeUBL(8, 30)
deftypeUBL(8, 31)
deftypeUBL(8, 32)
deftypeUBL(8, 33)
deftypeUBL(8, 34)
deftypeUBL(8, 35)
deftypeUBL(8, 36)
deftypeUBL(8, 37)
deftypeUBL(8, 38)
deftypeUBL(8, 39)
deftypeUBL(8, 40)
deftypeUBL(8, 41)
deftypeUBL(8, 42)
deftypeUBL(8, 43)
deftypeUBL(8, 44)
deftypeUBL(8, 45)
deftypeUBL(8, 46)
deftypeUBL(8, 47)
deftypeUBL(8, 48)
deftypeUBL(8, 49)
deftypeUBL(8, 50)
deftypeUBL(8, 51)
deftypeUBL(8, 52)
deftypeUBL(8, 53)
deftypeUBL(8, 54)
deftypeUBL(8, 55)
deftypeUBL(8, 56)
/* Define unsigned bitfields at offset 9 */
deftypeUBL(9, 24)
deftypeUBL(9, 25)
deftypeUBL(9, 26)
deftypeUBL(9, 27)
deftypeUBL(9, 28)
deftypeUBL(9, 29)
deftypeUBL(9, 30)
deftypeUBL(9, 31)
deftypeUBL(9, 32)
deftypeUBL(9, 33)
deftypeUBL(9, 34)
deftypeUBL(9, 35)
deftypeUBL(9, 36)
deftypeUBL(9, 37)
deftypeUBL(9, 38)
deftypeUBL(9, 39)
deftypeUBL(9, 40)
deftypeUBL(9, 41)
deftypeUBL(9, 42)
deftypeUBL(9, 43)
deftypeUBL(9, 44)
deftypeUBL(9, 45)
deftypeUBL(9, 46)
deftypeUBL(9, 47)
deftypeUBL(9, 48)
deftypeUBL(9, 49)
deftypeUBL(9, 50)
deftypeUBL(9, 51)
deftypeUBL(9, 52)
deftypeUBL(9, 53)
deftypeUBL(9, 54)
deftypeUBL(9, 55)
/* Define unsigned bitfields at offset 10 */
deftypeUBL(10, 23)
deftypeUBL(10, 24)
deftypeUBL(10, 25)
deftypeUBL(10, 26)
deftypeUBL(10, 27)
deftypeUBL(10, 28)
deftypeUBL(10, 29)
deftypeUBL(10, 30)
deftypeUBL(10, 31)
deftypeUBL(10, 32)
deftypeUBL(10, 33)
deftypeUBL(10, 34)
deftypeUBL(10, 35)
deftypeUBL(10, 36)
deftypeUBL(10, 37)
deftypeUBL(10, 38)
deftypeUBL(10, 39)
deftypeUBL(10, 40)
deftypeUBL(10, 41)
deftypeUBL(10, 42)
deftypeUBL(10, 43)
deftypeUBL(10, 44)
deftypeUBL(10, 45)
deftypeUBL(10, 46)
deftypeUBL(10, 47)
deftypeUBL(10, 48)
deftypeUBL(10, 49)
deftypeUBL(10, 50)
deftypeUBL(10, 51)
deftypeUBL(10, 52)
deftypeUBL(10, 53)
deftypeUBL(10, 54)
/* Define unsigned bitfields at offset 11 */
deftypeUBL(11, 22)
deftypeUBL(11, 23)
deftypeUBL(11, 24)
deftypeUBL(11, 25)
deftypeUBL(11, 26)
deftypeUBL(11, 27)
deftypeUBL(11, 28)
deftypeUBL(11, 29)
deftypeUBL(11, 30)
deftypeUBL(11, 31)
deftypeUBL(11, 32)
deftypeUBL(11, 33)
deftypeUBL(11, 34)
deftypeUBL(11, 35)
deftypeUBL(11, 36)
deftypeUBL(11, 37)
deftypeUBL(11, 38)
deftypeUBL(11, 39)
deftypeUBL(11, 40)
deftypeUBL(11, 41)
deftypeUBL(11, 42)
deftypeUBL(11, 43)
deftypeUBL(11, 44)
deftypeUBL(11, 45)
deftypeUBL(11, 46)
deftypeUBL(11, 47)
deftypeUBL(11, 48)
deftypeUBL(11, 49)
deftypeUBL(11, 50)
deftypeUBL(11, 51)
deftypeUBL(11, 52)
deftypeUBL(11, 53)
/* Define unsigned bitfields at offset 12 */
deftypeUBL(12, 21)
deftypeUBL(12, 22)
deftypeUBL(12, 23)
deftypeUBL(12, 24)
deftypeUBL(12, 25)
deftypeUBL(12, 26)
deftypeUBL(12, 27)
deftypeUBL(12, 28)
deftypeUBL(12, 29)
deftypeUBL(12, 30)
deftypeUBL(12, 31)
deftypeUBL(12, 32)
deftypeUBL(12, 33)
deftypeUBL(12, 34)
deftypeUBL(12, 35)
deftypeUBL(12, 36)
deftypeUBL(12, 37)
deftypeUBL(12, 38)
deftypeUBL(12, 39)
deftypeUBL(12, 40)
deftypeUBL(12, 41)
deftypeUBL(12, 42)
deftypeUBL(12, 43)
deftypeUBL(12, 44)
deftypeUBL(12, 45)
deftypeUBL(12, 46)
deftypeUBL(12, 47)
deftypeUBL(12, 48)
deftypeUBL(12, 49)
deftypeUBL(12, 50)
deftypeUBL(12, 51)
deftypeUBL(12, 52)
/* Define unsigned bitfields at offset 13 */
deftypeUBL(13, 20)
deftypeUBL(13, 21)
deftypeUBL(13, 22)
deftypeUBL(13, 23)
deftypeUBL(13, 24)
deftypeUBL(13, 25)
deftypeUBL(13, 26)
deftypeUBL(13, 27)
deftypeUBL(13, 28)
deftypeUBL(13, 29)
deftypeUBL(13, 30)
deftypeUBL(13, 31)
deftypeUBL(13, 32)
deftypeUBL(13, 33)
deftypeUBL(13, 34)
deftypeUBL(13, 35)
deftypeUBL(13, 36)
deftypeUBL(13, 37)
deftypeUBL(13, 38)
deftypeUBL(13, 39)
deftypeUBL(13, 40)
deftypeUBL(13, 41)
deftypeUBL(13, 42)
deftypeUBL(13, 43)
deftypeUBL(13, 44)
deftypeUBL(13, 45)
deftypeUBL(13, 46)
deftypeUBL(13, 47)
deftypeUBL(13, 48)
deftypeUBL(13, 49)
deftypeUBL(13, 50)
deftypeUBL(13, 51)
/* Define unsigned bitfields at offset 14 */
deftypeUBL(14, 19)
deftypeUBL(14, 20)
deftypeUBL(14, 21)
deftypeUBL(14, 22)
deftypeUBL(14, 23)
deftypeUBL(14, 24)
deftypeUBL(14, 25)
deftypeUBL(14, 26)
deftypeUBL(14, 27)
deftypeUBL(14, 28)
deftypeUBL(14, 29)
deftypeUBL(14, 30)
deftypeUBL(14, 31)
deftypeUBL(14, 32)
deftypeUBL(14, 33)
deftypeUBL(14, 34)
deftypeUBL(14, 35)
deftypeUBL(14, 36)
deftypeUBL(14, 37)
deftypeUBL(14, 38)
deftypeUBL(14, 39)
deftypeUBL(14, 40)
deftypeUBL(14, 41)
deftypeUBL(14, 42)
deftypeUBL(14, 43)
deftypeUBL(14, 44)
deftypeUBL(14, 45)
deftypeUBL(14, 46)
deftypeUBL(14, 47)
deftypeUBL(14, 48)
deftypeUBL(14, 49)
deftypeUBL(14, 50)
/* Define unsigned bitfields at offset 15 */
deftypeUBL(15, 18)
deftypeUBL(15, 19)
deftypeUBL(15, 20)
deftypeUBL(15, 21)
deftypeUBL(15, 22)
deftypeUBL(15, 23)
deftypeUBL(15, 24)
deftypeUBL(15, 25)
deftypeUBL(15, 26)
deftypeUBL(15, 27)
deftypeUBL(15, 28)
deftypeUBL(15, 29)
deftypeUBL(15, 30)
deftypeUBL(15, 31)
deftypeUBL(15, 32)
deftypeUBL(15, 33)
deftypeUBL(15, 34)
deftypeUBL(15, 35)
deftypeUBL(15, 36)
deftypeUBL(15, 37)
deftypeUBL(15, 38)
deftypeUBL(15, 39)
deftypeUBL(15, 40)
deftypeUBL(15, 41)
deftypeUBL(15, 42)
deftypeUBL(15, 43)
deftypeUBL(15, 44)
deftypeUBL(15, 45)
deftypeUBL(15, 46)
deftypeUBL(15, 47)
deftypeUBL(15, 48)
deftypeUBL(15, 49)
/* Define unsigned bitfields at offset 16 */
deftypeUBL(16, 17)
deftypeUBL(16, 18)
deftypeUBL(16, 19)
deftypeUBL(16, 20)
deftypeUBL(16, 21)
deftypeUBL(16, 22)
deftypeUBL(16, 23)
deftypeUBL(16, 24)
deftypeUBL(16, 25)
deftypeUBL(16, 26)
deftypeUBL(16, 27)
deftypeUBL(16, 28)
deftypeUBL(16, 29)
deftypeUBL(16, 30)
deftypeUBL(16, 31)
deftypeUBL(16, 32)
deftypeUBL(16, 33)
deftypeUBL(16, 34)
deftypeUBL(16, 35)
deftypeUBL(16, 36)
deftypeUBL(16, 37)
deftypeUBL(16, 38)
deftypeUBL(16, 39)
deftypeUBL(16, 40)
deftypeUBL(16, 41)
deftypeUBL(16, 42)
deftypeUBL(16, 43)
deftypeUBL(16, 44)
deftypeUBL(16, 45)
deftypeUBL(16, 46)
deftypeUBL(16, 47)
deftypeUBL(16, 48)
/* Define unsigned bitfields at offset 17 */
deftypeUBL(17, 16)
deftypeUBL(17, 17)
deftypeUBL(17, 18)
deftypeUBL(17, 19)
deftypeUBL(17, 20)
deftypeUBL(17, 21)
deftypeUBL(17, 22)
deftypeUBL(17, 23)
deftypeUBL(17, 24)
deftypeUBL(17, 25)
deftypeUBL(17, 26)
deftypeUBL(17, 27)
deftypeUBL(17, 28)
deftypeUBL(17, 29)
deftypeUBL(17, 30)
deftypeUBL(17, 31)
deftypeUBL(17, 32)
deftypeUBL(17, 33)
deftypeUBL(17, 34)
deftypeUBL(17, 35)
deftypeUBL(17, 36)
deftypeUBL(17, 37)
deftypeUBL(17, 38)
deftypeUBL(17, 39)
deftypeUBL(17, 40)
deftypeUBL(17, 41)
deftypeUBL(17, 42)
deftypeUBL(17, 43)
deftypeUBL(17, 44)
deftypeUBL(17, 45)
deftypeUBL(17, 46)
deftypeUBL(17, 47)
/* Define unsigned bitfields at offset 18 */
deftypeUBL(18, 15)
deftypeUBL(18, 16)
deftypeUBL(18, 17)
deftypeUBL(18, 18)
deftypeUBL(18, 19)
deftypeUBL(18, 20)
deftypeUBL(18, 21)
deftypeUBL(18, 22)
deftypeUBL(18, 23)
deftypeUBL(18, 24)
deftypeUBL(18, 25)
deftypeUBL(18, 26)
deftypeUBL(18, 27)
deftypeUBL(18, 28)
deftypeUBL(18, 29)
deftypeUBL(18, 30)
deftypeUBL(18, 31)
deftypeUBL(18, 32)
deftypeUBL(18, 33)
deftypeUBL(18, 34)
deftypeUBL(18, 35)
deftypeUBL(18, 36)
deftypeUBL(18, 37)
deftypeUBL(18, 38)
deftypeUBL(18, 39)
deftypeUBL(18, 40)
deftypeUBL(18, 41)
deftypeUBL(18, 42)
deftypeUBL(18, 43)
deftypeUBL(18, 44)
deftypeUBL(18, 45)
deftypeUBL(18, 46)
/* Define unsigned bitfields at offset 19 */
deftypeUBL(19, 14)
deftypeUBL(19, 15)
deftypeUBL(19, 16)
deftypeUBL(19, 17)
deftypeUBL(19, 18)
deftypeUBL(19, 19)
deftypeUBL(19, 20)
deftypeUBL(19, 21)
deftypeUBL(19, 22)
deftypeUBL(19, 23)
deftypeUBL(19, 24)
deftypeUBL(19, 25)
deftypeUBL(19, 26)
deftypeUBL(19, 27)
deftypeUBL(19, 28)
deftypeUBL(19, 29)
deftypeUBL(19, 30)
deftypeUBL(19, 31)
deftypeUBL(19, 32)
deftypeUBL(19, 33)
deftypeUBL(19, 34)
deftypeUBL(19, 35)
deftypeUBL(19, 36)
deftypeUBL(19, 37)
deftypeUBL(19, 38)
deftypeUBL(19, 39)
deftypeUBL(19, 40)
deftypeUBL(19, 41)
deftypeUBL(19, 42)
deftypeUBL(19, 43)
deftypeUBL(19, 44)
deftypeUBL(19, 45)
/* Define unsigned bitfields at offset 20 */
deftypeUBL(20, 13)
deftypeUBL(20, 14)
deftypeUBL(20, 15)
deftypeUBL(20, 16)
deftypeUBL(20, 17)
deftypeUBL(20, 18)
deftypeUBL(20, 19)
deftypeUBL(20, 20)
deftypeUBL(20, 21)
deftypeUBL(20, 22)
deftypeUBL(20, 23)
deftypeUBL(20, 24)
deftypeUBL(20, 25)
deftypeUBL(20, 26)
deftypeUBL(20, 27)
deftypeUBL(20, 28)
deftypeUBL(20, 29)
deftypeUBL(20, 30)
deftypeUBL(20, 31)
deftypeUBL(20, 32)
deftypeUBL(20, 33)
deftypeUBL(20, 34)
deftypeUBL(20, 35)
deftypeUBL(20, 36)
deftypeUBL(20, 37)
deftypeUBL(20, 38)
deftypeUBL(20, 39)
deftypeUBL(20, 40)
deftypeUBL(20, 41)
deftypeUBL(20, 42)
deftypeUBL(20, 43)
deftypeUBL(20, 44)
/* Define unsigned bitfields at offset 21 */
deftypeUBL(21, 12)
deftypeUBL(21, 13)
deftypeUBL(21, 14)
deftypeUBL(21, 15)
deftypeUBL(21, 16)
deftypeUBL(21, 17)
deftypeUBL(21, 18)
deftypeUBL(21, 19)
deftypeUBL(21, 20)
deftypeUBL(21, 21)
deftypeUBL(21, 22)
deftypeUBL(21, 23)
deftypeUBL(21, 24)
deftypeUBL(21, 25)
deftypeUBL(21, 26)
deftypeUBL(21, 27)
deftypeUBL(21, 28)
deftypeUBL(21, 29)
deftypeUBL(21, 30)
deftypeUBL(21, 31)
deftypeUBL(21, 32)
deftypeUBL(21, 33)
deftypeUBL(21, 34)
deftypeUBL(21, 35)
deftypeUBL(21, 36)
deftypeUBL(21, 37)
deftypeUBL(21, 38)
deftypeUBL(21, 39)
deftypeUBL(21, 40)
deftypeUBL(21, 41)
deftypeUBL(21, 42)
deftypeUBL(21, 43)
/* Define unsigned bitfields at offset 22 */
deftypeUBL(22, 11)
deftypeUBL(22, 12)
deftypeUBL(22, 13)
deftypeUBL(22, 14)
deftypeUBL(22, 15)
deftypeUBL(22, 16)
deftypeUBL(22, 17)
deftypeUBL(22, 18)
deftypeUBL(22, 19)
deftypeUBL(22, 20)
deftypeUBL(22, 21)
deftypeUBL(22, 22)
deftypeUBL(22, 23)
deftypeUBL(22, 24)
deftypeUBL(22, 25)
deftypeUBL(22, 26)
deftypeUBL(22, 27)
deftypeUBL(22, 28)
deftypeUBL(22, 29)
deftypeUBL(22, 30)
deftypeUBL(22, 31)
deftypeUBL(22, 32)
deftypeUBL(22, 33)
deftypeUBL(22, 34)
deftypeUBL(22, 35)
deftypeUBL(22, 36)
deftypeUBL(22, 37)
deftypeUBL(22, 38)
deftypeUBL(22, 39)
deftypeUBL(22, 40)
deftypeUBL(22, 41)
deftypeUBL(22, 42)
/* Define unsigned bitfields at offset 23 */
deftypeUBL(23, 10)
deftypeUBL(23, 11)
deftypeUBL(23, 12)
deftypeUBL(23, 13)
deftypeUBL(23, 14)
deftypeUBL(23, 15)
deftypeUBL(23, 16)
deftypeUBL(23, 17)
deftypeUBL(23, 18)
deftypeUBL(23, 19)
deftypeUBL(23, 20)
deftypeUBL(23, 21)
deftypeUBL(23, 22)
deftypeUBL(23, 23)
deftypeUBL(23, 24)
deftypeUBL(23, 25)
deftypeUBL(23, 26)
deftypeUBL(23, 27)
deftypeUBL(23, 28)
deftypeUBL(23, 29)
deftypeUBL(23, 30)
deftypeUBL(23, 31)
deftypeUBL(23, 32)
deftypeUBL(23, 33)
deftypeUBL(23, 34)
deftypeUBL(23, 35)
deftypeUBL(23, 36)
deftypeUBL(23, 37)
deftypeUBL(23, 38)
deftypeUBL(23, 39)
deftypeUBL(23, 40)
deftypeUBL(23, 41)
/* Define unsigned bitfields at offset 24 */
deftypeUBL(24, 9)
deftypeUBL(24, 10)
deftypeUBL(24, 11)
deftypeUBL(24, 12)
deftypeUBL(24, 13)
deftypeUBL(24, 14)
deftypeUBL(24, 15)
deftypeUBL(24, 16)
deftypeUBL(24, 17)
deftypeUBL(24, 18)
deftypeUBL(24, 19)
deftypeUBL(24, 20)
deftypeUBL(24, 21)
deftypeUBL(24, 22)
deftypeUBL(24, 23)
deftypeUBL(24, 24)
deftypeUBL(24, 25)
deftypeUBL(24, 26)
deftypeUBL(24, 27)
deftypeUBL(24, 28)
deftypeUBL(24, 29)
deftypeUBL(24, 30)
deftypeUBL(24, 31)
deftypeUBL(24, 32)
deftypeUBL(24, 33)
deftypeUBL(24, 34)
deftypeUBL(24, 35)
deftypeUBL(24, 36)
deftypeUBL(24, 37)
deftypeUBL(24, 38)
deftypeUBL(24, 39)
deftypeUBL(24, 40)
/* Define unsigned bitfields at offset 25 */
deftypeUBL(25, 8)
deftypeUBL(25, 9)
deftypeUBL(25, 10)
deftypeUBL(25, 11)
deftypeUBL(25, 12)
deftypeUBL(25, 13)
deftypeUBL(25, 14)
deftypeUBL(25, 15)
deftypeUBL(25, 16)
deftypeUBL(25, 17)
deftypeUBL(25, 18)
deftypeUBL(25, 19)
deftypeUBL(25, 20)
deftypeUBL(25, 21)
deftypeUBL(25, 22)
deftypeUBL(25, 23)
deftypeUBL(25, 24)
deftypeUBL(25, 25)
deftypeUBL(25, 26)
deftypeUBL(25, 27)
deftypeUBL(25, 28)
deftypeUBL(25, 29)
deftypeUBL(25, 30)
deftypeUBL(25, 31)
deftypeUBL(25, 32)
deftypeUBL(25, 33)
deftypeUBL(25, 34)
deftypeUBL(25, 35)
deftypeUBL(25, 36)
deftypeUBL(25, 37)
deftypeUBL(25, 38)
deftypeUBL(25, 39)
/* Define unsigned bitfields at offset 26 */
deftypeUBL(26, 7)
deftypeUBL(26, 8)
deftypeUBL(26, 9)
deftypeUBL(26, 10)
deftypeUBL(26, 11)
deftypeUBL(26, 12)
deftypeUBL(26, 13)
deftypeUBL(26, 14)
deftypeUBL(26, 15)
deftypeUBL(26, 16)
deftypeUBL(26, 17)
deftypeUBL(26, 18)
deftypeUBL(26, 19)
deftypeUBL(26, 20)
deftypeUBL(26, 21)
deftypeUBL(26, 22)
deftypeUBL(26, 23)
deftypeUBL(26, 24)
deftypeUBL(26, 25)
deftypeUBL(26, 26)
deftypeUBL(26, 27)
deftypeUBL(26, 28)
deftypeUBL(26, 29)
deftypeUBL(26, 30)
deftypeUBL(26, 31)
deftypeUBL(26, 32)
deftypeUBL(26, 33)
deftypeUBL(26, 34)
deftypeUBL(26, 35)
deftypeUBL(26, 36)
deftypeUBL(26, 37)
deftypeUBL(26, 38)
/* Define unsigned bitfields at offset 27 */
deftypeUBL(27, 6)
deftypeUBL(27, 7)
deftypeUBL(27, 8)
deftypeUBL(27, 9)
deftypeUBL(27, 10)
deftypeUBL(27, 11)
deftypeUBL(27, 12)
deftypeUBL(27, 13)
deftypeUBL(27, 14)
deftypeUBL(27, 15)
deftypeUBL(27, 16)
deftypeUBL(27, 17)
deftypeUBL(27, 18)
deftypeUBL(27, 19)
deftypeUBL(27, 20)
deftypeUBL(27, 21)
deftypeUBL(27, 22)
deftypeUBL(27, 23)
deftypeUBL(27, 24)
deftypeUBL(27, 25)
deftypeUBL(27, 26)
deftypeUBL(27, 27)
deftypeUBL(27, 28)
deftypeUBL(27, 29)
deftypeUBL(27, 30)
deftypeUBL(27, 31)
deftypeUBL(27, 32)
deftypeUBL(27, 33)
deftypeUBL(27, 34)
deftypeUBL(27, 35)
deftypeUBL(27, 36)
deftypeUBL(27, 37)
/* Define unsigned bitfields at offset 28 */
deftypeUBL(28, 5)
deftypeUBL(28, 6)
deftypeUBL(28, 7)
deftypeUBL(28, 8)
deftypeUBL(28, 9)
deftypeUBL(28, 10)
deftypeUBL(28, 11)
deftypeUBL(28, 12)
deftypeUBL(28, 13)
deftypeUBL(28, 14)
deftypeUBL(28, 15)
deftypeUBL(28, 16)
deftypeUBL(28, 17)
deftypeUBL(28, 18)
deftypeUBL(28, 19)
deftypeUBL(28, 20)
deftypeUBL(28, 21)
deftypeUBL(28, 22)
deftypeUBL(28, 23)
deftypeUBL(28, 24)
deftypeUBL(28, 25)
deftypeUBL(28, 26)
deftypeUBL(28, 27)
deftypeUBL(28, 28)
deftypeUBL(28, 29)
deftypeUBL(28, 30)
deftypeUBL(28, 31)
deftypeUBL(28, 32)
deftypeUBL(28, 33)
deftypeUBL(28, 34)
deftypeUBL(28, 35)
deftypeUBL(28, 36)
/* Define unsigned bitfields at offset 29 */
deftypeUBL(29, 4)
deftypeUBL(29, 5)
deftypeUBL(29, 6)
deftypeUBL(29, 7)
deftypeUBL(29, 8)
deftypeUBL(29, 9)
deftypeUBL(29, 10)
deftypeUBL(29, 11)
deftypeUBL(29, 12)
deftypeUBL(29, 13)
deftypeUBL(29, 14)
deftypeUBL(29, 15)
deftypeUBL(29, 16)
deftypeUBL(29, 17)
deftypeUBL(29, 18)
deftypeUBL(29, 19)
deftypeUBL(29, 20)
deftypeUBL(29, 21)
deftypeUBL(29, 22)
deftypeUBL(29, 23)
deftypeUBL(29, 24)
deftypeUBL(29, 25)
deftypeUBL(29, 26)
deftypeUBL(29, 27)
deftypeUBL(29, 28)
deftypeUBL(29, 29)
deftypeUBL(29, 30)
deftypeUBL(29, 31)
deftypeUBL(29, 32)
deftypeUBL(29, 33)
deftypeUBL(29, 34)
deftypeUBL(29, 35)
/* Define unsigned bitfields at offset 30 */
deftypeUBL(30, 3)
deftypeUBL(30, 4)
deftypeUBL(30, 5)
deftypeUBL(30, 6)
deftypeUBL(30, 7)
deftypeUBL(30, 8)
deftypeUBL(30, 9)
deftypeUBL(30, 10)
deftypeUBL(30, 11)
deftypeUBL(30, 12)
deftypeUBL(30, 13)
deftypeUBL(30, 14)
deftypeUBL(30, 15)
deftypeUBL(30, 16)
deftypeUBL(30, 17)
deftypeUBL(30, 18)
deftypeUBL(30, 19)
deftypeUBL(30, 20)
deftypeUBL(30, 21)
deftypeUBL(30, 22)
deftypeUBL(30, 23)
deftypeUBL(30, 24)
deftypeUBL(30, 25)
deftypeUBL(30, 26)
deftypeUBL(30, 27)
deftypeUBL(30, 28)
deftypeUBL(30, 29)
deftypeUBL(30, 30)
deftypeUBL(30, 31)
deftypeUBL(30, 32)
deftypeUBL(30, 33)
deftypeUBL(30, 34)
/* Define unsigned bitfields at offset 31 */
deftypeUBL(31, 2)
deftypeUBL(31, 3)
deftypeUBL(31, 4)
deftypeUBL(31, 5)
deftypeUBL(31, 6)
deftypeUBL(31, 7)
deftypeUBL(31, 8)
deftypeUBL(31, 9)
deftypeUBL(31, 10)
deftypeUBL(31, 11)
deftypeUBL(31, 12)
deftypeUBL(31, 13)
deftypeUBL(31, 14)
deftypeUBL(31, 15)
deftypeUBL(31, 16)
deftypeUBL(31, 17)
deftypeUBL(31, 18)
deftypeUBL(31, 19)
deftypeUBL(31, 20)
deftypeUBL(31, 21)
deftypeUBL(31, 22)
deftypeUBL(31, 23)
deftypeUBL(31, 24)
deftypeUBL(31, 25)
deftypeUBL(31, 26)
deftypeUBL(31, 27)
deftypeUBL(31, 28)
deftypeUBL(31, 29)
deftypeUBL(31, 30)
deftypeUBL(31, 31)
deftypeUBL(31, 32)
deftypeUBL(31, 33)
/* Define unsigned bitfields at offset 32 */
deftypeUBL(32, 1)
deftypeUBL(32, 2)
deftypeUBL(32, 3)
deftypeUBL(32, 4)
deftypeUBL(32, 5)
deftypeUBL(32, 6)
deftypeUBL(32, 7)
deftypeUBL(32, 8)
deftypeUBL(32, 9)
deftypeUBL(32, 10)
deftypeUBL(32, 11)
deftypeUBL(32, 12)
deftypeUBL(32, 13)
deftypeUBL(32, 14)
deftypeUBL(32, 15)
deftypeUBL(32, 16)
deftypeUBL(32, 17)
deftypeUBL(32, 18)
deftypeUBL(32, 19)
deftypeUBL(32, 20)
deftypeUBL(32, 21)
deftypeUBL(32, 22)
deftypeUBL(32, 23)
deftypeUBL(32, 24)
deftypeUBL(32, 25)
deftypeUBL(32, 26)
deftypeUBL(32, 27)
deftypeUBL(32, 28)
deftypeUBL(32, 29)
deftypeUBL(32, 30)
deftypeUBL(32, 31)
deftypeUBL(32, 32)
/* Define unsigned bitfields at offset 33 */
deftypeUBL(33, 1)
deftypeUBL(33, 2)
deftypeUBL(33, 3)
deftypeUBL(33, 4)
deftypeUBL(33, 5)
deftypeUBL(33, 6)
deftypeUBL(33, 7)
deftypeUBL(33, 8)
deftypeUBL(33, 9)
deftypeUBL(33, 10)
deftypeUBL(33, 11)
deftypeUBL(33, 12)
deftypeUBL(33, 13)
deftypeUBL(33, 14)
deftypeUBL(33, 15)
deftypeUBL(33, 16)
deftypeUBL(33, 17)
deftypeUBL(33, 18)
deftypeUBL(33, 19)
deftypeUBL(33, 20)
deftypeUBL(33, 21)
deftypeUBL(33, 22)
deftypeUBL(33, 23)
deftypeUBL(33, 24)
deftypeUBL(33, 25)
deftypeUBL(33, 26)
deftypeUBL(33, 27)
deftypeUBL(33, 28)
deftypeUBL(33, 29)
deftypeUBL(33, 30)
deftypeUBL(33, 31)
/* Define unsigned bitfields at offset 34 */
deftypeUBL(34, 1)
deftypeUBL(34, 2)
deftypeUBL(34, 3)
deftypeUBL(34, 4)
deftypeUBL(34, 5)
deftypeUBL(34, 6)
deftypeUBL(34, 7)
deftypeUBL(34, 8)
deftypeUBL(34, 9)
deftypeUBL(34, 10)
deftypeUBL(34, 11)
deftypeUBL(34, 12)
deftypeUBL(34, 13)
deftypeUBL(34, 14)
deftypeUBL(34, 15)
deftypeUBL(34, 16)
deftypeUBL(34, 17)
deftypeUBL(34, 18)
deftypeUBL(34, 19)
deftypeUBL(34, 20)
deftypeUBL(34, 21)
deftypeUBL(34, 22)
deftypeUBL(34, 23)
deftypeUBL(34, 24)
deftypeUBL(34, 25)
deftypeUBL(34, 26)
deftypeUBL(34, 27)
deftypeUBL(34, 28)
deftypeUBL(34, 29)
deftypeUBL(34, 30)
/* Define unsigned bitfields at offset 35 */
deftypeUBL(35, 1)
deftypeUBL(35, 2)
deftypeUBL(35, 3)
deftypeUBL(35, 4)
deftypeUBL(35, 5)
deftypeUBL(35, 6)
deftypeUBL(35, 7)
deftypeUBL(35, 8)
deftypeUBL(35, 9)
deftypeUBL(35, 10)
deftypeUBL(35, 11)
deftypeUBL(35, 12)
deftypeUBL(35, 13)
deftypeUBL(35, 14)
deftypeUBL(35, 15)
deftypeUBL(35, 16)
deftypeUBL(35, 17)
deftypeUBL(35, 18)
deftypeUBL(35, 19)
deftypeUBL(35, 20)
deftypeUBL(35, 21)
deftypeUBL(35, 22)
deftypeUBL(35, 23)
deftypeUBL(35, 24)
deftypeUBL(35, 25)
deftypeUBL(35, 26)
deftypeUBL(35, 27)
deftypeUBL(35, 28)
deftypeUBL(35, 29)
/* Define unsigned bitfields at offset 36 */
deftypeUBL(36, 1)
deftypeUBL(36, 2)
deftypeUBL(36, 3)
deftypeUBL(36, 4)
deftypeUBL(36, 5)
deftypeUBL(36, 6)
deftypeUBL(36, 7)
deftypeUBL(36, 8)
deftypeUBL(36, 9)
deftypeUBL(36, 10)
deftypeUBL(36, 11)
deftypeUBL(36, 12)
deftypeUBL(36, 13)
deftypeUBL(36, 14)
deftypeUBL(36, 15)
deftypeUBL(36, 16)
deftypeUBL(36, 17)
deftypeUBL(36, 18)
deftypeUBL(36, 19)
deftypeUBL(36, 20)
deftypeUBL(36, 21)
deftypeUBL(36, 22)
deftypeUBL(36, 23)
deftypeUBL(36, 24)
deftypeUBL(36, 25)
deftypeUBL(36, 26)
deftypeUBL(36, 27)
deftypeUBL(36, 28)
/* Define unsigned bitfields at offset 37 */
deftypeUBL(37, 1)
deftypeUBL(37, 2)
deftypeUBL(37, 3)
deftypeUBL(37, 4)
deftypeUBL(37, 5)
deftypeUBL(37, 6)
deftypeUBL(37, 7)
deftypeUBL(37, 8)
deftypeUBL(37, 9)
deftypeUBL(37, 10)
deftypeUBL(37, 11)
deftypeUBL(37, 12)
deftypeUBL(37, 13)
deftypeUBL(37, 14)
deftypeUBL(37, 15)
deftypeUBL(37, 16)
deftypeUBL(37, 17)
deftypeUBL(37, 18)
deftypeUBL(37, 19)
deftypeUBL(37, 20)
deftypeUBL(37, 21)
deftypeUBL(37, 22)
deftypeUBL(37, 23)
deftypeUBL(37, 24)
deftypeUBL(37, 25)
deftypeUBL(37, 26)
deftypeUBL(37, 27)
/* Define unsigned bitfields at offset 38 */
deftypeUBL(38, 1)
deftypeUBL(38, 2)
deftypeUBL(38, 3)
deftypeUBL(38, 4)
deftypeUBL(38, 5)
deftypeUBL(38, 6)
deftypeUBL(38, 7)
deftypeUBL(38, 8)
deftypeUBL(38, 9)
deftypeUBL(38, 10)
deftypeUBL(38, 11)
deftypeUBL(38, 12)
deftypeUBL(38, 13)
deftypeUBL(38, 14)
deftypeUBL(38, 15)
deftypeUBL(38, 16)
deftypeUBL(38, 17)
deftypeUBL(38, 18)
deftypeUBL(38, 19)
deftypeUBL(38, 20)
deftypeUBL(38, 21)
deftypeUBL(38, 22)
deftypeUBL(38, 23)
deftypeUBL(38, 24)
deftypeUBL(38, 25)
deftypeUBL(38, 26)
/* Define unsigned bitfields at offset 39 */
deftypeUBL(39, 1)
deftypeUBL(39, 2)
deftypeUBL(39, 3)
deftypeUBL(39, 4)
deftypeUBL(39, 5)
deftypeUBL(39, 6)
deftypeUBL(39, 7)
deftypeUBL(39, 8)
deftypeUBL(39, 9)
deftypeUBL(39, 10)
deftypeUBL(39, 11)
deftypeUBL(39, 12)
deftypeUBL(39, 13)
deftypeUBL(39, 14)
deftypeUBL(39, 15)
deftypeUBL(39, 16)
deftypeUBL(39, 17)
deftypeUBL(39, 18)
deftypeUBL(39, 19)
deftypeUBL(39, 20)
deftypeUBL(39, 21)
deftypeUBL(39, 22)
deftypeUBL(39, 23)
deftypeUBL(39, 24)
deftypeUBL(39, 25)
/* Define unsigned bitfields at offset 40 */
deftypeUBL(40, 1)
deftypeUBL(40, 2)
deftypeUBL(40, 3)
deftypeUBL(40, 4)
deftypeUBL(40, 5)
deftypeUBL(40, 6)
deftypeUBL(40, 7)
deftypeUBL(40, 8)
deftypeUBL(40, 9)
deftypeUBL(40, 10)
deftypeUBL(40, 11)
deftypeUBL(40, 12)
deftypeUBL(40, 13)
deftypeUBL(40, 14)
deftypeUBL(40, 15)
deftypeUBL(40, 16)
deftypeUBL(40, 17)
deftypeUBL(40, 18)
deftypeUBL(40, 19)
deftypeUBL(40, 20)
deftypeUBL(40, 21)
deftypeUBL(40, 22)
deftypeUBL(40, 23)
deftypeUBL(40, 24)
/* Define unsigned bitfields at offset 41 */
deftypeUBL(41, 1)
deftypeUBL(41, 2)
deftypeUBL(41, 3)
deftypeUBL(41, 4)
deftypeUBL(41, 5)
deftypeUBL(41, 6)
deftypeUBL(41, 7)
deftypeUBL(41, 8)
deftypeUBL(41, 9)
deftypeUBL(41, 10)
deftypeUBL(41, 11)
deftypeUBL(41, 12)
deftypeUBL(41, 13)
deftypeUBL(41, 14)
deftypeUBL(41, 15)
deftypeUBL(41, 16)
deftypeUBL(41, 17)
deftypeUBL(41, 18)
deftypeUBL(41, 19)
deftypeUBL(41, 20)
deftypeUBL(41, 21)
deftypeUBL(41, 22)
deftypeUBL(41, 23)
/* Define unsigned bitfields at offset 42 */
deftypeUBL(42, 1)
deftypeUBL(42, 2)
deftypeUBL(42, 3)
deftypeUBL(42, 4)
deftypeUBL(42, 5)
deftypeUBL(42, 6)
deftypeUBL(42, 7)
deftypeUBL(42, 8)
deftypeUBL(42, 9)
deftypeUBL(42, 10)
deftypeUBL(42, 11)
deftypeUBL(42, 12)
deftypeUBL(42, 13)
deftypeUBL(42, 14)
deftypeUBL(42, 15)
deftypeUBL(42, 16)
deftypeUBL(42, 17)
deftypeUBL(42, 18)
deftypeUBL(42, 19)
deftypeUBL(42, 20)
deftypeUBL(42, 21)
deftypeUBL(42, 22)
/* Define unsigned bitfields at offset 43 */
deftypeUBL(43, 1)
deftypeUBL(43, 2)
deftypeUBL(43, 3)
deftypeUBL(43, 4)
deftypeUBL(43, 5)
deftypeUBL(43, 6)
deftypeUBL(43, 7)
deftypeUBL(43, 8)
deftypeUBL(43, 9)
deftypeUBL(43, 10)
deftypeUBL(43, 11)
deftypeUBL(43, 12)
deftypeUBL(43, 13)
deftypeUBL(43, 14)
deftypeUBL(43, 15)
deftypeUBL(43, 16)
deftypeUBL(43, 17)
deftypeUBL(43, 18)
deftypeUBL(43, 19)
deftypeUBL(43, 20)
deftypeUBL(43, 21)
/* Define unsigned bitfields at offset 44 */
deftypeUBL(44, 1)
deftypeUBL(44, 2)
deftypeUBL(44, 3)
deftypeUBL(44, 4)
deftypeUBL(44, 5)
deftypeUBL(44, 6)
deftypeUBL(44, 7)
deftypeUBL(44, 8)
deftypeUBL(44, 9)
deftypeUBL(44, 10)
deftypeUBL(44, 11)
deftypeUBL(44, 12)
deftypeUBL(44, 13)
deftypeUBL(44, 14)
deftypeUBL(44, 15)
deftypeUBL(44, 16)
deftypeUBL(44, 17)
deftypeUBL(44, 18)
deftypeUBL(44, 19)
deftypeUBL(44, 20)
/* Define unsigned bitfields at offset 45 */
deftypeUBL(45, 1)
deftypeUBL(45, 2)
deftypeUBL(45, 3)
deftypeUBL(45, 4)
deftypeUBL(45, 5)
deftypeUBL(45, 6)
deftypeUBL(45, 7)
deftypeUBL(45, 8)
deftypeUBL(45, 9)
deftypeUBL(45, 10)
deftypeUBL(45, 11)
deftypeUBL(45, 12)
deftypeUBL(45, 13)
deftypeUBL(45, 14)
deftypeUBL(45, 15)
deftypeUBL(45, 16)
deftypeUBL(45, 17)
deftypeUBL(45, 18)
deftypeUBL(45, 19)
/* Define unsigned bitfields at offset 46 */
deftypeUBL(46, 1)
deftypeUBL(46, 2)
deftypeUBL(46, 3)
deftypeUBL(46, 4)
deftypeUBL(46, 5)
deftypeUBL(46, 6)
deftypeUBL(46, 7)
deftypeUBL(46, 8)
deftypeUBL(46, 9)
deftypeUBL(46, 10)
deftypeUBL(46, 11)
deftypeUBL(46, 12)
deftypeUBL(46, 13)
deftypeUBL(46, 14)
deftypeUBL(46, 15)
deftypeUBL(46, 16)
deftypeUBL(46, 17)
deftypeUBL(46, 18)
/* Define unsigned bitfields at offset 47 */
deftypeUBL(47, 1)
deftypeUBL(47, 2)
deftypeUBL(47, 3)
deftypeUBL(47, 4)
deftypeUBL(47, 5)
deftypeUBL(47, 6)
deftypeUBL(47, 7)
deftypeUBL(47, 8)
deftypeUBL(47, 9)
deftypeUBL(47, 10)
deftypeUBL(47, 11)
deftypeUBL(47, 12)
deftypeUBL(47, 13)
deftypeUBL(47, 14)
deftypeUBL(47, 15)
deftypeUBL(47, 16)
deftypeUBL(47, 17)
/* Define unsigned bitfields at offset 48 */
deftypeUBL(48, 1)
deftypeUBL(48, 2)
deftypeUBL(48, 3)
deftypeUBL(48, 4)
deftypeUBL(48, 5)
deftypeUBL(48, 6)
deftypeUBL(48, 7)
deftypeUBL(48, 8)
deftypeUBL(48, 9)
deftypeUBL(48, 10)
deftypeUBL(48, 11)
deftypeUBL(48, 12)
deftypeUBL(48, 13)
deftypeUBL(48, 14)
deftypeUBL(48, 15)
deftypeUBL(48, 16)
/* Define unsigned bitfields at offset 49 */
deftypeUBL(49, 1)
deftypeUBL(49, 2)
deftypeUBL(49, 3)
deftypeUBL(49, 4)
deftypeUBL(49, 5)
deftypeUBL(49, 6)
deftypeUBL(49, 7)
deftypeUBL(49, 8)
deftypeUBL(49, 9)
deftypeUBL(49, 10)
deftypeUBL(49, 11)
deftypeUBL(49, 12)
deftypeUBL(49, 13)
deftypeUBL(49, 14)
deftypeUBL(49, 15)
/* Define unsigned bitfields at offset 50 */
deftypeUBL(50, 1)
deftypeUBL(50, 2)
deftypeUBL(50, 3)
deftypeUBL(50, 4)
deftypeUBL(50, 5)
deftypeUBL(50, 6)
deftypeUBL(50, 7)
deftypeUBL(50, 8)
deftypeUBL(50, 9)
deftypeUBL(50, 10)
deftypeUBL(50, 11)
deftypeUBL(50, 12)
deftypeUBL(50, 13)
deftypeUBL(50, 14)
/* Define unsigned bitfields at offset 51 */
deftypeUBL(51, 1)
deftypeUBL(51, 2)
deftypeUBL(51, 3)
deftypeUBL(51, 4)
deftypeUBL(51, 5)
deftypeUBL(51, 6)
deftypeUBL(51, 7)
deftypeUBL(51, 8)
deftypeUBL(51, 9)
deftypeUBL(51, 10)
deftypeUBL(51, 11)
deftypeUBL(51, 12)
deftypeUBL(51, 13)
/* Define unsigned bitfields at offset 52 */
deftypeUBL(52, 1)
deftypeUBL(52, 2)
deftypeUBL(52, 3)
deftypeUBL(52, 4)
deftypeUBL(52, 5)
deftypeUBL(52, 6)
deftypeUBL(52, 7)
deftypeUBL(52, 8)
deftypeUBL(52, 9)
deftypeUBL(52, 10)
deftypeUBL(52, 11)
deftypeUBL(52, 12)
/* Define unsigned bitfields at offset 53 */
deftypeUBL(53, 1)
deftypeUBL(53, 2)
deftypeUBL(53, 3)
deftypeUBL(53, 4)
deftypeUBL(53, 5)
deftypeUBL(53, 6)
deftypeUBL(53, 7)
deftypeUBL(53, 8)
deftypeUBL(53, 9)
deftypeUBL(53, 10)
deftypeUBL(53, 11)
/* Define unsigned bitfields at offset 54 */
deftypeUBL(54, 1)
deftypeUBL(54, 2)
deftypeUBL(54, 3)
deftypeUBL(54, 4)
deftypeUBL(54, 5)
deftypeUBL(54, 6)
deftypeUBL(54, 7)
deftypeUBL(54, 8)
deftypeUBL(54, 9)
deftypeUBL(54, 10)
/* Define unsigned bitfields at offset 55 */
deftypeUBL(55, 1)
deftypeUBL(55, 2)
deftypeUBL(55, 3)
deftypeUBL(55, 4)
deftypeUBL(55, 5)
deftypeUBL(55, 6)
deftypeUBL(55, 7)
deftypeUBL(55, 8)
deftypeUBL(55, 9)
/* Define unsigned bitfields at offset 56 */
deftypeUBL(56, 1)
deftypeUBL(56, 2)
deftypeUBL(56, 3)
deftypeUBL(56, 4)
deftypeUBL(56, 5)
deftypeUBL(56, 6)
deftypeUBL(56, 7)
deftypeUBL(56, 8)
/* Define unsigned bitfields at offset 57 */
deftypeUBL(57, 1)
deftypeUBL(57, 2)
deftypeUBL(57, 3)
deftypeUBL(57, 4)
deftypeUBL(57, 5)
deftypeUBL(57, 6)
deftypeUBL(57, 7)
/* Define unsigned bitfields at offset 58 */
deftypeUBL(58, 1)
deftypeUBL(58, 2)
deftypeUBL(58, 3)
deftypeUBL(58, 4)
deftypeUBL(58, 5)
deftypeUBL(58, 6)
/* Define unsigned bitfields at offset 59 */
deftypeUBL(59, 1)
deftypeUBL(59, 2)
deftypeUBL(59, 3)
deftypeUBL(59, 4)
deftypeUBL(59, 5)
/* Define unsigned bitfields at offset 60 */
deftypeUBL(60, 1)
deftypeUBL(60, 2)
deftypeUBL(60, 3)
deftypeUBL(60, 4)
/* Define unsigned bitfields at offset 61 */
deftypeUBL(61, 1)
deftypeUBL(61, 2)
deftypeUBL(61, 3)
/* Define unsigned bitfields at offset 62 */
deftypeUBL(62, 1)
deftypeUBL(62, 2)
/* Define unsigned bitfields at offset 63 */
deftypeUBL(63, 1)
#endif

int
main(int argc, char *argv[])
{
    jit_node_t		 *arg;
    jit_node_t		 *jmpi_main;
    jit_state_t		 *_jit;
    void		(*code)(void);
    /* Declare signed bitfields at offset 0 */
    S1			 pS1;
    jit_node_t		*nS1;
    S2			 pS2;
    jit_node_t		*nS2;
    S3			 pS3;
    jit_node_t		*nS3;
    S4			 pS4;
    jit_node_t		*nS4;
    S5			 pS5;
    jit_node_t		*nS5;
    S6			 pS6;
    jit_node_t		*nS6;
    S7			 pS7;
    jit_node_t		*nS7;
    S8			 pS8;
    jit_node_t		*nS8;
    S9			 pS9;
    jit_node_t		*nS9;
    S10			 pS10;
    jit_node_t		*nS10;
    S11			 pS11;
    jit_node_t		*nS11;
    S12			 pS12;
    jit_node_t		*nS12;
    S13			 pS13;
    jit_node_t		*nS13;
    S14			 pS14;
    jit_node_t		*nS14;
    S15			 pS15;
    jit_node_t		*nS15;
    S16			 pS16;
    jit_node_t		*nS16;
    S17			 pS17;
    jit_node_t		*nS17;
    S18			 pS18;
    jit_node_t		*nS18;
    S19			 pS19;
    jit_node_t		*nS19;
    S20			 pS20;
    jit_node_t		*nS20;
    S21			 pS21;
    jit_node_t		*nS21;
    S22			 pS22;
    jit_node_t		*nS22;
    S23			 pS23;
    jit_node_t		*nS23;
    S24			 pS24;
    jit_node_t		*nS24;
    S25			 pS25;
    jit_node_t		*nS25;
    S26			 pS26;
    jit_node_t		*nS26;
    S27			 pS27;
    jit_node_t		*nS27;
    S28			 pS28;
    jit_node_t		*nS28;
    S29			 pS29;
    jit_node_t		*nS29;
    S30			 pS30;
    jit_node_t		*nS30;
    S31			 pS31;
    jit_node_t		*nS31;
    S32			 pS32;
    jit_node_t		*nS32;
#if __WORDSIZE == 64 && !SKIP_64_BITS
    S33			 pS33;
    jit_node_t		*nS33;
    S34			 pS34;
    jit_node_t		*nS34;
    S35			 pS35;
    jit_node_t		*nS35;
    S36			 pS36;
    jit_node_t		*nS36;
    S37			 pS37;
    jit_node_t		*nS37;
    S38			 pS38;
    jit_node_t		*nS38;
    S39			 pS39;
    jit_node_t		*nS39;
    S40			 pS40;
    jit_node_t		*nS40;
    S41			 pS41;
    jit_node_t		*nS41;
    S42			 pS42;
    jit_node_t		*nS42;
    S43			 pS43;
    jit_node_t		*nS43;
    S44			 pS44;
    jit_node_t		*nS44;
    S45			 pS45;
    jit_node_t		*nS45;
    S46			 pS46;
    jit_node_t		*nS46;
    S47			 pS47;
    jit_node_t		*nS47;
    S48			 pS48;
    jit_node_t		*nS48;
    S49			 pS49;
    jit_node_t		*nS49;
    S50			 pS50;
    jit_node_t		*nS50;
    S51			 pS51;
    jit_node_t		*nS51;
    S52			 pS52;
    jit_node_t		*nS52;
    S53			 pS53;
    jit_node_t		*nS53;
    S54			 pS54;
    jit_node_t		*nS54;
    S55			 pS55;
    jit_node_t		*nS55;
    S56			 pS56;
    jit_node_t		*nS56;
    S57			 pS57;
    jit_node_t		*nS57;
    S58			 pS58;
    jit_node_t		*nS58;
    S59			 pS59;
    jit_node_t		*nS59;
    S60			 pS60;
    jit_node_t		*nS60;
    S61			 pS61;
    jit_node_t		*nS61;
    S62			 pS62;
    jit_node_t		*nS62;
    S63			 pS63;
    jit_node_t		*nS63;
    S64			 pS64;
    jit_node_t		*nS64;
#endif
    /* Declare unsigned bitfields at offset 0 */
    U1			 pU1;
    jit_node_t		*nU1;
    U2			 pU2;
    jit_node_t		*nU2;
    U3			 pU3;
    jit_node_t		*nU3;
    U4			 pU4;
    jit_node_t		*nU4;
    U5			 pU5;
    jit_node_t		*nU5;
    U6			 pU6;
    jit_node_t		*nU6;
    U7			 pU7;
    jit_node_t		*nU7;
    U8			 pU8;
    jit_node_t		*nU8;
    U9			 pU9;
    jit_node_t		*nU9;
    U10			 pU10;
    jit_node_t		*nU10;
    U11			 pU11;
    jit_node_t		*nU11;
    U12			 pU12;
    jit_node_t		*nU12;
    U13			 pU13;
    jit_node_t		*nU13;
    U14			 pU14;
    jit_node_t		*nU14;
    U15			 pU15;
    jit_node_t		*nU15;
    U16			 pU16;
    jit_node_t		*nU16;
    U17			 pU17;
    jit_node_t		*nU17;
    U18			 pU18;
    jit_node_t		*nU18;
    U19			 pU19;
    jit_node_t		*nU19;
    U20			 pU20;
    jit_node_t		*nU20;
    U21			 pU21;
    jit_node_t		*nU21;
    U22			 pU22;
    jit_node_t		*nU22;
    U23			 pU23;
    jit_node_t		*nU23;
    U24			 pU24;
    jit_node_t		*nU24;
    U25			 pU25;
    jit_node_t		*nU25;
    U26			 pU26;
    jit_node_t		*nU26;
    U27			 pU27;
    jit_node_t		*nU27;
    U28			 pU28;
    jit_node_t		*nU28;
    U29			 pU29;
    jit_node_t		*nU29;
    U30			 pU30;
    jit_node_t		*nU30;
    U31			 pU31;
    jit_node_t		*nU31;
    U32			 pU32;
    jit_node_t		*nU32;
#if __WORDSIZE == 64 && !SKIP_64_BITS
    U33			 pU33;
    jit_node_t		*nU33;
    U34			 pU34;
    jit_node_t		*nU34;
    U35			 pU35;
    jit_node_t		*nU35;
    U36			 pU36;
    jit_node_t		*nU36;
    U37			 pU37;
    jit_node_t		*nU37;
    U38			 pU38;
    jit_node_t		*nU38;
    U39			 pU39;
    jit_node_t		*nU39;
    U40			 pU40;
    jit_node_t		*nU40;
    U41			 pU41;
    jit_node_t		*nU41;
    U42			 pU42;
    jit_node_t		*nU42;
    U43			 pU43;
    jit_node_t		*nU43;
    U44			 pU44;
    jit_node_t		*nU44;
    U45			 pU45;
    jit_node_t		*nU45;
    U46			 pU46;
    jit_node_t		*nU46;
    U47			 pU47;
    jit_node_t		*nU47;
    U48			 pU48;
    jit_node_t		*nU48;
    U49			 pU49;
    jit_node_t		*nU49;
    U50			 pU50;
    jit_node_t		*nU50;
    U51			 pU51;
    jit_node_t		*nU51;
    U52			 pU52;
    jit_node_t		*nU52;
    U53			 pU53;
    jit_node_t		*nU53;
    U54			 pU54;
    jit_node_t		*nU54;
    U55			 pU55;
    jit_node_t		*nU55;
    U56			 pU56;
    jit_node_t		*nU56;
    U57			 pU57;
    jit_node_t		*nU57;
    U58			 pU58;
    jit_node_t		*nU58;
    U59			 pU59;
    jit_node_t		*nU59;
    U60			 pU60;
    jit_node_t		*nU60;
    U61			 pU61;
    jit_node_t		*nU61;
    U62			 pU62;
    jit_node_t		*nU62;
    U63			 pU63;
    jit_node_t		*nU63;
    U64			 pU64;
    jit_node_t		*nU64;
#endif
    /* Declare signed bitfields at offset 1 */
    S1_1		 pS1_1;
    jit_node_t		*nS1_1;
    S1_2		 pS1_2;
    jit_node_t		*nS1_2;
    S1_3		 pS1_3;
    jit_node_t		*nS1_3;
    S1_4		 pS1_4;
    jit_node_t		*nS1_4;
    S1_5		 pS1_5;
    jit_node_t		*nS1_5;
    S1_6		 pS1_6;
    jit_node_t		*nS1_6;
    S1_7		 pS1_7;
    jit_node_t		*nS1_7;
    S1_8		 pS1_8;
    jit_node_t		*nS1_8;
    S1_9		 pS1_9;
    jit_node_t		*nS1_9;
    S1_10		 pS1_10;
    jit_node_t		*nS1_10;
    S1_11		 pS1_11;
    jit_node_t		*nS1_11;
    S1_12		 pS1_12;
    jit_node_t		*nS1_12;
    S1_13		 pS1_13;
    jit_node_t		*nS1_13;
    S1_14		 pS1_14;
    jit_node_t		*nS1_14;
    S1_15		 pS1_15;
    jit_node_t		*nS1_15;
    S1_16		 pS1_16;
    jit_node_t		*nS1_16;
    S1_17		 pS1_17;
    jit_node_t		*nS1_17;
    S1_18		 pS1_18;
    jit_node_t		*nS1_18;
    S1_19		 pS1_19;
    jit_node_t		*nS1_19;
    S1_20		 pS1_20;
    jit_node_t		*nS1_20;
    S1_21		 pS1_21;
    jit_node_t		*nS1_21;
    S1_22		 pS1_22;
    jit_node_t		*nS1_22;
    S1_23		 pS1_23;
    jit_node_t		*nS1_23;
    S1_24		 pS1_24;
    jit_node_t		*nS1_24;
    S1_25		 pS1_25;
    jit_node_t		*nS1_25;
    S1_26		 pS1_26;
    jit_node_t		*nS1_26;
    S1_27		 pS1_27;
    jit_node_t		*nS1_27;
    S1_28		 pS1_28;
    jit_node_t		*nS1_28;
    S1_29		 pS1_29;
    jit_node_t		*nS1_29;
    S1_30		 pS1_30;
    jit_node_t		*nS1_30;
    S1_31		 pS1_31;
    jit_node_t		*nS1_31;
    /* Declare signed bitfields at offset 2 */
    S2_1		 pS2_1;
    jit_node_t		*nS2_1;
    S2_2		 pS2_2;
    jit_node_t		*nS2_2;
    S2_3		 pS2_3;
    jit_node_t		*nS2_3;
    S2_4		 pS2_4;
    jit_node_t		*nS2_4;
    S2_5		 pS2_5;
    jit_node_t		*nS2_5;
    S2_6		 pS2_6;
    jit_node_t		*nS2_6;
    S2_7		 pS2_7;
    jit_node_t		*nS2_7;
    S2_8		 pS2_8;
    jit_node_t		*nS2_8;
    S2_9		 pS2_9;
    jit_node_t		*nS2_9;
    S2_10		 pS2_10;
    jit_node_t		*nS2_10;
    S2_11		 pS2_11;
    jit_node_t		*nS2_11;
    S2_12		 pS2_12;
    jit_node_t		*nS2_12;
    S2_13		 pS2_13;
    jit_node_t		*nS2_13;
    S2_14		 pS2_14;
    jit_node_t		*nS2_14;
    S2_15		 pS2_15;
    jit_node_t		*nS2_15;
    S2_16		 pS2_16;
    jit_node_t		*nS2_16;
    S2_17		 pS2_17;
    jit_node_t		*nS2_17;
    S2_18		 pS2_18;
    jit_node_t		*nS2_18;
    S2_19		 pS2_19;
    jit_node_t		*nS2_19;
    S2_20		 pS2_20;
    jit_node_t		*nS2_20;
    S2_21		 pS2_21;
    jit_node_t		*nS2_21;
    S2_22		 pS2_22;
    jit_node_t		*nS2_22;
    S2_23		 pS2_23;
    jit_node_t		*nS2_23;
    S2_24		 pS2_24;
    jit_node_t		*nS2_24;
    S2_25		 pS2_25;
    jit_node_t		*nS2_25;
    S2_26		 pS2_26;
    jit_node_t		*nS2_26;
    S2_27		 pS2_27;
    jit_node_t		*nS2_27;
    S2_28		 pS2_28;
    jit_node_t		*nS2_28;
    S2_29		 pS2_29;
    jit_node_t		*nS2_29;
    S2_30		 pS2_30;
    jit_node_t		*nS2_30;
    /* Declare signed bitfields at offset 3 */
    S3_1		 pS3_1;
    jit_node_t		*nS3_1;
    S3_2		 pS3_2;
    jit_node_t		*nS3_2;
    S3_3		 pS3_3;
    jit_node_t		*nS3_3;
    S3_4		 pS3_4;
    jit_node_t		*nS3_4;
    S3_5		 pS3_5;
    jit_node_t		*nS3_5;
    S3_6		 pS3_6;
    jit_node_t		*nS3_6;
    S3_7		 pS3_7;
    jit_node_t		*nS3_7;
    S3_8		 pS3_8;
    jit_node_t		*nS3_8;
    S3_9		 pS3_9;
    jit_node_t		*nS3_9;
    S3_10		 pS3_10;
    jit_node_t		*nS3_10;
    S3_11		 pS3_11;
    jit_node_t		*nS3_11;
    S3_12		 pS3_12;
    jit_node_t		*nS3_12;
    S3_13		 pS3_13;
    jit_node_t		*nS3_13;
    S3_14		 pS3_14;
    jit_node_t		*nS3_14;
    S3_15		 pS3_15;
    jit_node_t		*nS3_15;
    S3_16		 pS3_16;
    jit_node_t		*nS3_16;
    S3_17		 pS3_17;
    jit_node_t		*nS3_17;
    S3_18		 pS3_18;
    jit_node_t		*nS3_18;
    S3_19		 pS3_19;
    jit_node_t		*nS3_19;
    S3_20		 pS3_20;
    jit_node_t		*nS3_20;
    S3_21		 pS3_21;
    jit_node_t		*nS3_21;
    S3_22		 pS3_22;
    jit_node_t		*nS3_22;
    S3_23		 pS3_23;
    jit_node_t		*nS3_23;
    S3_24		 pS3_24;
    jit_node_t		*nS3_24;
    S3_25		 pS3_25;
    jit_node_t		*nS3_25;
    S3_26		 pS3_26;
    jit_node_t		*nS3_26;
    S3_27		 pS3_27;
    jit_node_t		*nS3_27;
    S3_28		 pS3_28;
    jit_node_t		*nS3_28;
    S3_29		 pS3_29;
    jit_node_t		*nS3_29;
    /* Declare signed bitfields at offset 4 */
    S4_1		 pS4_1;
    jit_node_t		*nS4_1;
    S4_2		 pS4_2;
    jit_node_t		*nS4_2;
    S4_3		 pS4_3;
    jit_node_t		*nS4_3;
    S4_4		 pS4_4;
    jit_node_t		*nS4_4;
    S4_5		 pS4_5;
    jit_node_t		*nS4_5;
    S4_6		 pS4_6;
    jit_node_t		*nS4_6;
    S4_7		 pS4_7;
    jit_node_t		*nS4_7;
    S4_8		 pS4_8;
    jit_node_t		*nS4_8;
    S4_9		 pS4_9;
    jit_node_t		*nS4_9;
    S4_10		 pS4_10;
    jit_node_t		*nS4_10;
    S4_11		 pS4_11;
    jit_node_t		*nS4_11;
    S4_12		 pS4_12;
    jit_node_t		*nS4_12;
    S4_13		 pS4_13;
    jit_node_t		*nS4_13;
    S4_14		 pS4_14;
    jit_node_t		*nS4_14;
    S4_15		 pS4_15;
    jit_node_t		*nS4_15;
    S4_16		 pS4_16;
    jit_node_t		*nS4_16;
    S4_17		 pS4_17;
    jit_node_t		*nS4_17;
    S4_18		 pS4_18;
    jit_node_t		*nS4_18;
    S4_19		 pS4_19;
    jit_node_t		*nS4_19;
    S4_20		 pS4_20;
    jit_node_t		*nS4_20;
    S4_21		 pS4_21;
    jit_node_t		*nS4_21;
    S4_22		 pS4_22;
    jit_node_t		*nS4_22;
    S4_23		 pS4_23;
    jit_node_t		*nS4_23;
    S4_24		 pS4_24;
    jit_node_t		*nS4_24;
    S4_25		 pS4_25;
    jit_node_t		*nS4_25;
    S4_26		 pS4_26;
    jit_node_t		*nS4_26;
    S4_27		 pS4_27;
    jit_node_t		*nS4_27;
    S4_28		 pS4_28;
    jit_node_t		*nS4_28;
    /* Declare signed bitfields at offset 5 */
    S5_1		 pS5_1;
    jit_node_t		*nS5_1;
    S5_2		 pS5_2;
    jit_node_t		*nS5_2;
    S5_3		 pS5_3;
    jit_node_t		*nS5_3;
    S5_4		 pS5_4;
    jit_node_t		*nS5_4;
    S5_5		 pS5_5;
    jit_node_t		*nS5_5;
    S5_6		 pS5_6;
    jit_node_t		*nS5_6;
    S5_7		 pS5_7;
    jit_node_t		*nS5_7;
    S5_8		 pS5_8;
    jit_node_t		*nS5_8;
    S5_9		 pS5_9;
    jit_node_t		*nS5_9;
    S5_10		 pS5_10;
    jit_node_t		*nS5_10;
    S5_11		 pS5_11;
    jit_node_t		*nS5_11;
    S5_12		 pS5_12;
    jit_node_t		*nS5_12;
    S5_13		 pS5_13;
    jit_node_t		*nS5_13;
    S5_14		 pS5_14;
    jit_node_t		*nS5_14;
    S5_15		 pS5_15;
    jit_node_t		*nS5_15;
    S5_16		 pS5_16;
    jit_node_t		*nS5_16;
    S5_17		 pS5_17;
    jit_node_t		*nS5_17;
    S5_18		 pS5_18;
    jit_node_t		*nS5_18;
    S5_19		 pS5_19;
    jit_node_t		*nS5_19;
    S5_20		 pS5_20;
    jit_node_t		*nS5_20;
    S5_21		 pS5_21;
    jit_node_t		*nS5_21;
    S5_22		 pS5_22;
    jit_node_t		*nS5_22;
    S5_23		 pS5_23;
    jit_node_t		*nS5_23;
    S5_24		 pS5_24;
    jit_node_t		*nS5_24;
    S5_25		 pS5_25;
    jit_node_t		*nS5_25;
    S5_26		 pS5_26;
    jit_node_t		*nS5_26;
    S5_27		 pS5_27;
    jit_node_t		*nS5_27;
    /* Declare signed bitfields at offset 6 */
    S6_1		 pS6_1;
    jit_node_t		*nS6_1;
    S6_2		 pS6_2;
    jit_node_t		*nS6_2;
    S6_3		 pS6_3;
    jit_node_t		*nS6_3;
    S6_4		 pS6_4;
    jit_node_t		*nS6_4;
    S6_5		 pS6_5;
    jit_node_t		*nS6_5;
    S6_6		 pS6_6;
    jit_node_t		*nS6_6;
    S6_7		 pS6_7;
    jit_node_t		*nS6_7;
    S6_8		 pS6_8;
    jit_node_t		*nS6_8;
    S6_9		 pS6_9;
    jit_node_t		*nS6_9;
    S6_10		 pS6_10;
    jit_node_t		*nS6_10;
    S6_11		 pS6_11;
    jit_node_t		*nS6_11;
    S6_12		 pS6_12;
    jit_node_t		*nS6_12;
    S6_13		 pS6_13;
    jit_node_t		*nS6_13;
    S6_14		 pS6_14;
    jit_node_t		*nS6_14;
    S6_15		 pS6_15;
    jit_node_t		*nS6_15;
    S6_16		 pS6_16;
    jit_node_t		*nS6_16;
    S6_17		 pS6_17;
    jit_node_t		*nS6_17;
    S6_18		 pS6_18;
    jit_node_t		*nS6_18;
    S6_19		 pS6_19;
    jit_node_t		*nS6_19;
    S6_20		 pS6_20;
    jit_node_t		*nS6_20;
    S6_21		 pS6_21;
    jit_node_t		*nS6_21;
    S6_22		 pS6_22;
    jit_node_t		*nS6_22;
    S6_23		 pS6_23;
    jit_node_t		*nS6_23;
    S6_24		 pS6_24;
    jit_node_t		*nS6_24;
    S6_25		 pS6_25;
    jit_node_t		*nS6_25;
    S6_26		 pS6_26;
    jit_node_t		*nS6_26;
    /* Declare signed bitfields at offset 7 */
    S7_1		 pS7_1;
    jit_node_t		*nS7_1;
    S7_2		 pS7_2;
    jit_node_t		*nS7_2;
    S7_3		 pS7_3;
    jit_node_t		*nS7_3;
    S7_4		 pS7_4;
    jit_node_t		*nS7_4;
    S7_5		 pS7_5;
    jit_node_t		*nS7_5;
    S7_6		 pS7_6;
    jit_node_t		*nS7_6;
    S7_7		 pS7_7;
    jit_node_t		*nS7_7;
    S7_8		 pS7_8;
    jit_node_t		*nS7_8;
    S7_9		 pS7_9;
    jit_node_t		*nS7_9;
    S7_10		 pS7_10;
    jit_node_t		*nS7_10;
    S7_11		 pS7_11;
    jit_node_t		*nS7_11;
    S7_12		 pS7_12;
    jit_node_t		*nS7_12;
    S7_13		 pS7_13;
    jit_node_t		*nS7_13;
    S7_14		 pS7_14;
    jit_node_t		*nS7_14;
    S7_15		 pS7_15;
    jit_node_t		*nS7_15;
    S7_16		 pS7_16;
    jit_node_t		*nS7_16;
    S7_17		 pS7_17;
    jit_node_t		*nS7_17;
    S7_18		 pS7_18;
    jit_node_t		*nS7_18;
    S7_19		 pS7_19;
    jit_node_t		*nS7_19;
    S7_20		 pS7_20;
    jit_node_t		*nS7_20;
    S7_21		 pS7_21;
    jit_node_t		*nS7_21;
    S7_22		 pS7_22;
    jit_node_t		*nS7_22;
    S7_23		 pS7_23;
    jit_node_t		*nS7_23;
    S7_24		 pS7_24;
    jit_node_t		*nS7_24;
    S7_25		 pS7_25;
    jit_node_t		*nS7_25;
    /* Declare signed bitfields at offset 8 */
    S8_1		 pS8_1;
    jit_node_t		*nS8_1;
    S8_2		 pS8_2;
    jit_node_t		*nS8_2;
    S8_3		 pS8_3;
    jit_node_t		*nS8_3;
    S8_4		 pS8_4;
    jit_node_t		*nS8_4;
    S8_5		 pS8_5;
    jit_node_t		*nS8_5;
    S8_6		 pS8_6;
    jit_node_t		*nS8_6;
    S8_7		 pS8_7;
    jit_node_t		*nS8_7;
    S8_8		 pS8_8;
    jit_node_t		*nS8_8;
    S8_9		 pS8_9;
    jit_node_t		*nS8_9;
    S8_10		 pS8_10;
    jit_node_t		*nS8_10;
    S8_11		 pS8_11;
    jit_node_t		*nS8_11;
    S8_12		 pS8_12;
    jit_node_t		*nS8_12;
    S8_13		 pS8_13;
    jit_node_t		*nS8_13;
    S8_14		 pS8_14;
    jit_node_t		*nS8_14;
    S8_15		 pS8_15;
    jit_node_t		*nS8_15;
    S8_16		 pS8_16;
    jit_node_t		*nS8_16;
    S8_17		 pS8_17;
    jit_node_t		*nS8_17;
    S8_18		 pS8_18;
    jit_node_t		*nS8_18;
    S8_19		 pS8_19;
    jit_node_t		*nS8_19;
    S8_20		 pS8_20;
    jit_node_t		*nS8_20;
    S8_21		 pS8_21;
    jit_node_t		*nS8_21;
    S8_22		 pS8_22;
    jit_node_t		*nS8_22;
    S8_23		 pS8_23;
    jit_node_t		*nS8_23;
    S8_24		 pS8_24;
    jit_node_t		*nS8_24;
    /* Declare signed bitfields at offset 9 */
    S9_1		 pS9_1;
    jit_node_t		*nS9_1;
    S9_2		 pS9_2;
    jit_node_t		*nS9_2;
    S9_3		 pS9_3;
    jit_node_t		*nS9_3;
    S9_4		 pS9_4;
    jit_node_t		*nS9_4;
    S9_5		 pS9_5;
    jit_node_t		*nS9_5;
    S9_6		 pS9_6;
    jit_node_t		*nS9_6;
    S9_7		 pS9_7;
    jit_node_t		*nS9_7;
    S9_8		 pS9_8;
    jit_node_t		*nS9_8;
    S9_9		 pS9_9;
    jit_node_t		*nS9_9;
    S9_10		 pS9_10;
    jit_node_t		*nS9_10;
    S9_11		 pS9_11;
    jit_node_t		*nS9_11;
    S9_12		 pS9_12;
    jit_node_t		*nS9_12;
    S9_13		 pS9_13;
    jit_node_t		*nS9_13;
    S9_14		 pS9_14;
    jit_node_t		*nS9_14;
    S9_15		 pS9_15;
    jit_node_t		*nS9_15;
    S9_16		 pS9_16;
    jit_node_t		*nS9_16;
    S9_17		 pS9_17;
    jit_node_t		*nS9_17;
    S9_18		 pS9_18;
    jit_node_t		*nS9_18;
    S9_19		 pS9_19;
    jit_node_t		*nS9_19;
    S9_20		 pS9_20;
    jit_node_t		*nS9_20;
    S9_21		 pS9_21;
    jit_node_t		*nS9_21;
    S9_22		 pS9_22;
    jit_node_t		*nS9_22;
    S9_23		 pS9_23;
    jit_node_t		*nS9_23;
    /* Declare signed bitfields at offset 10 */
    S10_1		 pS10_1;
    jit_node_t		*nS10_1;
    S10_2		 pS10_2;
    jit_node_t		*nS10_2;
    S10_3		 pS10_3;
    jit_node_t		*nS10_3;
    S10_4		 pS10_4;
    jit_node_t		*nS10_4;
    S10_5		 pS10_5;
    jit_node_t		*nS10_5;
    S10_6		 pS10_6;
    jit_node_t		*nS10_6;
    S10_7		 pS10_7;
    jit_node_t		*nS10_7;
    S10_8		 pS10_8;
    jit_node_t		*nS10_8;
    S10_9		 pS10_9;
    jit_node_t		*nS10_9;
    S10_10		 pS10_10;
    jit_node_t		*nS10_10;
    S10_11		 pS10_11;
    jit_node_t		*nS10_11;
    S10_12		 pS10_12;
    jit_node_t		*nS10_12;
    S10_13		 pS10_13;
    jit_node_t		*nS10_13;
    S10_14		 pS10_14;
    jit_node_t		*nS10_14;
    S10_15		 pS10_15;
    jit_node_t		*nS10_15;
    S10_16		 pS10_16;
    jit_node_t		*nS10_16;
    S10_17		 pS10_17;
    jit_node_t		*nS10_17;
    S10_18		 pS10_18;
    jit_node_t		*nS10_18;
    S10_19		 pS10_19;
    jit_node_t		*nS10_19;
    S10_20		 pS10_20;
    jit_node_t		*nS10_20;
    S10_21		 pS10_21;
    jit_node_t		*nS10_21;
    S10_22		 pS10_22;
    jit_node_t		*nS10_22;
    /* Declare signed bitfields at offset 11 */
    S11_1		 pS11_1;
    jit_node_t		*nS11_1;
    S11_2		 pS11_2;
    jit_node_t		*nS11_2;
    S11_3		 pS11_3;
    jit_node_t		*nS11_3;
    S11_4		 pS11_4;
    jit_node_t		*nS11_4;
    S11_5		 pS11_5;
    jit_node_t		*nS11_5;
    S11_6		 pS11_6;
    jit_node_t		*nS11_6;
    S11_7		 pS11_7;
    jit_node_t		*nS11_7;
    S11_8		 pS11_8;
    jit_node_t		*nS11_8;
    S11_9		 pS11_9;
    jit_node_t		*nS11_9;
    S11_10		 pS11_10;
    jit_node_t		*nS11_10;
    S11_11		 pS11_11;
    jit_node_t		*nS11_11;
    S11_12		 pS11_12;
    jit_node_t		*nS11_12;
    S11_13		 pS11_13;
    jit_node_t		*nS11_13;
    S11_14		 pS11_14;
    jit_node_t		*nS11_14;
    S11_15		 pS11_15;
    jit_node_t		*nS11_15;
    S11_16		 pS11_16;
    jit_node_t		*nS11_16;
    S11_17		 pS11_17;
    jit_node_t		*nS11_17;
    S11_18		 pS11_18;
    jit_node_t		*nS11_18;
    S11_19		 pS11_19;
    jit_node_t		*nS11_19;
    S11_20		 pS11_20;
    jit_node_t		*nS11_20;
    S11_21		 pS11_21;
    jit_node_t		*nS11_21;
    /* Declare signed bitfields at offset 12 */
    S12_1		 pS12_1;
    jit_node_t		*nS12_1;
    S12_2		 pS12_2;
    jit_node_t		*nS12_2;
    S12_3		 pS12_3;
    jit_node_t		*nS12_3;
    S12_4		 pS12_4;
    jit_node_t		*nS12_4;
    S12_5		 pS12_5;
    jit_node_t		*nS12_5;
    S12_6		 pS12_6;
    jit_node_t		*nS12_6;
    S12_7		 pS12_7;
    jit_node_t		*nS12_7;
    S12_8		 pS12_8;
    jit_node_t		*nS12_8;
    S12_9		 pS12_9;
    jit_node_t		*nS12_9;
    S12_10		 pS12_10;
    jit_node_t		*nS12_10;
    S12_11		 pS12_11;
    jit_node_t		*nS12_11;
    S12_12		 pS12_12;
    jit_node_t		*nS12_12;
    S12_13		 pS12_13;
    jit_node_t		*nS12_13;
    S12_14		 pS12_14;
    jit_node_t		*nS12_14;
    S12_15		 pS12_15;
    jit_node_t		*nS12_15;
    S12_16		 pS12_16;
    jit_node_t		*nS12_16;
    S12_17		 pS12_17;
    jit_node_t		*nS12_17;
    S12_18		 pS12_18;
    jit_node_t		*nS12_18;
    S12_19		 pS12_19;
    jit_node_t		*nS12_19;
    S12_20		 pS12_20;
    jit_node_t		*nS12_20;
    /* Declare signed bitfields at offset 13 */
    S13_1		 pS13_1;
    jit_node_t		*nS13_1;
    S13_2		 pS13_2;
    jit_node_t		*nS13_2;
    S13_3		 pS13_3;
    jit_node_t		*nS13_3;
    S13_4		 pS13_4;
    jit_node_t		*nS13_4;
    S13_5		 pS13_5;
    jit_node_t		*nS13_5;
    S13_6		 pS13_6;
    jit_node_t		*nS13_6;
    S13_7		 pS13_7;
    jit_node_t		*nS13_7;
    S13_8		 pS13_8;
    jit_node_t		*nS13_8;
    S13_9		 pS13_9;
    jit_node_t		*nS13_9;
    S13_10		 pS13_10;
    jit_node_t		*nS13_10;
    S13_11		 pS13_11;
    jit_node_t		*nS13_11;
    S13_12		 pS13_12;
    jit_node_t		*nS13_12;
    S13_13		 pS13_13;
    jit_node_t		*nS13_13;
    S13_14		 pS13_14;
    jit_node_t		*nS13_14;
    S13_15		 pS13_15;
    jit_node_t		*nS13_15;
    S13_16		 pS13_16;
    jit_node_t		*nS13_16;
    S13_17		 pS13_17;
    jit_node_t		*nS13_17;
    S13_18		 pS13_18;
    jit_node_t		*nS13_18;
    S13_19		 pS13_19;
    jit_node_t		*nS13_19;
    /* Declare signed bitfields at offset 14 */
    S14_1		 pS14_1;
    jit_node_t		*nS14_1;
    S14_2		 pS14_2;
    jit_node_t		*nS14_2;
    S14_3		 pS14_3;
    jit_node_t		*nS14_3;
    S14_4		 pS14_4;
    jit_node_t		*nS14_4;
    S14_5		 pS14_5;
    jit_node_t		*nS14_5;
    S14_6		 pS14_6;
    jit_node_t		*nS14_6;
    S14_7		 pS14_7;
    jit_node_t		*nS14_7;
    S14_8		 pS14_8;
    jit_node_t		*nS14_8;
    S14_9		 pS14_9;
    jit_node_t		*nS14_9;
    S14_10		 pS14_10;
    jit_node_t		*nS14_10;
    S14_11		 pS14_11;
    jit_node_t		*nS14_11;
    S14_12		 pS14_12;
    jit_node_t		*nS14_12;
    S14_13		 pS14_13;
    jit_node_t		*nS14_13;
    S14_14		 pS14_14;
    jit_node_t		*nS14_14;
    S14_15		 pS14_15;
    jit_node_t		*nS14_15;
    S14_16		 pS14_16;
    jit_node_t		*nS14_16;
    S14_17		 pS14_17;
    jit_node_t		*nS14_17;
    S14_18		 pS14_18;
    jit_node_t		*nS14_18;
    /* Declare signed bitfields at offset 15 */
    S15_1		 pS15_1;
    jit_node_t		*nS15_1;
    S15_2		 pS15_2;
    jit_node_t		*nS15_2;
    S15_3		 pS15_3;
    jit_node_t		*nS15_3;
    S15_4		 pS15_4;
    jit_node_t		*nS15_4;
    S15_5		 pS15_5;
    jit_node_t		*nS15_5;
    S15_6		 pS15_6;
    jit_node_t		*nS15_6;
    S15_7		 pS15_7;
    jit_node_t		*nS15_7;
    S15_8		 pS15_8;
    jit_node_t		*nS15_8;
    S15_9		 pS15_9;
    jit_node_t		*nS15_9;
    S15_10		 pS15_10;
    jit_node_t		*nS15_10;
    S15_11		 pS15_11;
    jit_node_t		*nS15_11;
    S15_12		 pS15_12;
    jit_node_t		*nS15_12;
    S15_13		 pS15_13;
    jit_node_t		*nS15_13;
    S15_14		 pS15_14;
    jit_node_t		*nS15_14;
    S15_15		 pS15_15;
    jit_node_t		*nS15_15;
    S15_16		 pS15_16;
    jit_node_t		*nS15_16;
    S15_17		 pS15_17;
    jit_node_t		*nS15_17;
    /* Declare signed bitfields at offset 16 */
    S16_1		 pS16_1;
    jit_node_t		*nS16_1;
    S16_2		 pS16_2;
    jit_node_t		*nS16_2;
    S16_3		 pS16_3;
    jit_node_t		*nS16_3;
    S16_4		 pS16_4;
    jit_node_t		*nS16_4;
    S16_5		 pS16_5;
    jit_node_t		*nS16_5;
    S16_6		 pS16_6;
    jit_node_t		*nS16_6;
    S16_7		 pS16_7;
    jit_node_t		*nS16_7;
    S16_8		 pS16_8;
    jit_node_t		*nS16_8;
    S16_9		 pS16_9;
    jit_node_t		*nS16_9;
    S16_10		 pS16_10;
    jit_node_t		*nS16_10;
    S16_11		 pS16_11;
    jit_node_t		*nS16_11;
    S16_12		 pS16_12;
    jit_node_t		*nS16_12;
    S16_13		 pS16_13;
    jit_node_t		*nS16_13;
    S16_14		 pS16_14;
    jit_node_t		*nS16_14;
    S16_15		 pS16_15;
    jit_node_t		*nS16_15;
    S16_16		 pS16_16;
    jit_node_t		*nS16_16;
    /* Declare signed bitfields at offset 17 */
    S17_1		 pS17_1;
    jit_node_t		*nS17_1;
    S17_2		 pS17_2;
    jit_node_t		*nS17_2;
    S17_3		 pS17_3;
    jit_node_t		*nS17_3;
    S17_4		 pS17_4;
    jit_node_t		*nS17_4;
    S17_5		 pS17_5;
    jit_node_t		*nS17_5;
    S17_6		 pS17_6;
    jit_node_t		*nS17_6;
    S17_7		 pS17_7;
    jit_node_t		*nS17_7;
    S17_8		 pS17_8;
    jit_node_t		*nS17_8;
    S17_9		 pS17_9;
    jit_node_t		*nS17_9;
    S17_10		 pS17_10;
    jit_node_t		*nS17_10;
    S17_11		 pS17_11;
    jit_node_t		*nS17_11;
    S17_12		 pS17_12;
    jit_node_t		*nS17_12;
    S17_13		 pS17_13;
    jit_node_t		*nS17_13;
    S17_14		 pS17_14;
    jit_node_t		*nS17_14;
    S17_15		 pS17_15;
    jit_node_t		*nS17_15;
    /* Declare signed bitfields at offset 18 */
    S18_1		 pS18_1;
    jit_node_t		*nS18_1;
    S18_2		 pS18_2;
    jit_node_t		*nS18_2;
    S18_3		 pS18_3;
    jit_node_t		*nS18_3;
    S18_4		 pS18_4;
    jit_node_t		*nS18_4;
    S18_5		 pS18_5;
    jit_node_t		*nS18_5;
    S18_6		 pS18_6;
    jit_node_t		*nS18_6;
    S18_7		 pS18_7;
    jit_node_t		*nS18_7;
    S18_8		 pS18_8;
    jit_node_t		*nS18_8;
    S18_9		 pS18_9;
    jit_node_t		*nS18_9;
    S18_10		 pS18_10;
    jit_node_t		*nS18_10;
    S18_11		 pS18_11;
    jit_node_t		*nS18_11;
    S18_12		 pS18_12;
    jit_node_t		*nS18_12;
    S18_13		 pS18_13;
    jit_node_t		*nS18_13;
    S18_14		 pS18_14;
    jit_node_t		*nS18_14;
    /* Declare signed bitfields at offset 19 */
    S19_1		 pS19_1;
    jit_node_t		*nS19_1;
    S19_2		 pS19_2;
    jit_node_t		*nS19_2;
    S19_3		 pS19_3;
    jit_node_t		*nS19_3;
    S19_4		 pS19_4;
    jit_node_t		*nS19_4;
    S19_5		 pS19_5;
    jit_node_t		*nS19_5;
    S19_6		 pS19_6;
    jit_node_t		*nS19_6;
    S19_7		 pS19_7;
    jit_node_t		*nS19_7;
    S19_8		 pS19_8;
    jit_node_t		*nS19_8;
    S19_9		 pS19_9;
    jit_node_t		*nS19_9;
    S19_10		 pS19_10;
    jit_node_t		*nS19_10;
    S19_11		 pS19_11;
    jit_node_t		*nS19_11;
    S19_12		 pS19_12;
    jit_node_t		*nS19_12;
    S19_13		 pS19_13;
    jit_node_t		*nS19_13;
    /* Declare signed bitfields at offset 20 */
    S20_1		 pS20_1;
    jit_node_t		*nS20_1;
    S20_2		 pS20_2;
    jit_node_t		*nS20_2;
    S20_3		 pS20_3;
    jit_node_t		*nS20_3;
    S20_4		 pS20_4;
    jit_node_t		*nS20_4;
    S20_5		 pS20_5;
    jit_node_t		*nS20_5;
    S20_6		 pS20_6;
    jit_node_t		*nS20_6;
    S20_7		 pS20_7;
    jit_node_t		*nS20_7;
    S20_8		 pS20_8;
    jit_node_t		*nS20_8;
    S20_9		 pS20_9;
    jit_node_t		*nS20_9;
    S20_10		 pS20_10;
    jit_node_t		*nS20_10;
    S20_11		 pS20_11;
    jit_node_t		*nS20_11;
    S20_12		 pS20_12;
    jit_node_t		*nS20_12;
    /* Declare signed bitfields at offset 21 */
    S21_1		 pS21_1;
    jit_node_t		*nS21_1;
    S21_2		 pS21_2;
    jit_node_t		*nS21_2;
    S21_3		 pS21_3;
    jit_node_t		*nS21_3;
    S21_4		 pS21_4;
    jit_node_t		*nS21_4;
    S21_5		 pS21_5;
    jit_node_t		*nS21_5;
    S21_6		 pS21_6;
    jit_node_t		*nS21_6;
    S21_7		 pS21_7;
    jit_node_t		*nS21_7;
    S21_8		 pS21_8;
    jit_node_t		*nS21_8;
    S21_9		 pS21_9;
    jit_node_t		*nS21_9;
    S21_10		 pS21_10;
    jit_node_t		*nS21_10;
    S21_11		 pS21_11;
    jit_node_t		*nS21_11;
    /* Declare signed bitfields at offset 22 */
    S22_1		 pS22_1;
    jit_node_t		*nS22_1;
    S22_2		 pS22_2;
    jit_node_t		*nS22_2;
    S22_3		 pS22_3;
    jit_node_t		*nS22_3;
    S22_4		 pS22_4;
    jit_node_t		*nS22_4;
    S22_5		 pS22_5;
    jit_node_t		*nS22_5;
    S22_6		 pS22_6;
    jit_node_t		*nS22_6;
    S22_7		 pS22_7;
    jit_node_t		*nS22_7;
    S22_8		 pS22_8;
    jit_node_t		*nS22_8;
    S22_9		 pS22_9;
    jit_node_t		*nS22_9;
    S22_10		 pS22_10;
    jit_node_t		*nS22_10;
    /* Declare signed bitfields at offset 23 */
    S23_1		 pS23_1;
    jit_node_t		*nS23_1;
    S23_2		 pS23_2;
    jit_node_t		*nS23_2;
    S23_3		 pS23_3;
    jit_node_t		*nS23_3;
    S23_4		 pS23_4;
    jit_node_t		*nS23_4;
    S23_5		 pS23_5;
    jit_node_t		*nS23_5;
    S23_6		 pS23_6;
    jit_node_t		*nS23_6;
    S23_7		 pS23_7;
    jit_node_t		*nS23_7;
    S23_8		 pS23_8;
    jit_node_t		*nS23_8;
    S23_9		 pS23_9;
    jit_node_t		*nS23_9;
    /* Declare signed bitfields at offset 24 */
    S24_1		 pS24_1;
    jit_node_t		*nS24_1;
    S24_2		 pS24_2;
    jit_node_t		*nS24_2;
    S24_3		 pS24_3;
    jit_node_t		*nS24_3;
    S24_4		 pS24_4;
    jit_node_t		*nS24_4;
    S24_5		 pS24_5;
    jit_node_t		*nS24_5;
    S24_6		 pS24_6;
    jit_node_t		*nS24_6;
    S24_7		 pS24_7;
    jit_node_t		*nS24_7;
    S24_8		 pS24_8;
    jit_node_t		*nS24_8;
    /* Declare signed bitfields at offset 25 */
    S25_1		 pS25_1;
    jit_node_t		*nS25_1;
    S25_2		 pS25_2;
    jit_node_t		*nS25_2;
    S25_3		 pS25_3;
    jit_node_t		*nS25_3;
    S25_4		 pS25_4;
    jit_node_t		*nS25_4;
    S25_5		 pS25_5;
    jit_node_t		*nS25_5;
    S25_6		 pS25_6;
    jit_node_t		*nS25_6;
    S25_7		 pS25_7;
    jit_node_t		*nS25_7;
    /* Declare signed bitfields at offset 26 */
    S26_1		 pS26_1;
    jit_node_t		*nS26_1;
    S26_2		 pS26_2;
    jit_node_t		*nS26_2;
    S26_3		 pS26_3;
    jit_node_t		*nS26_3;
    S26_4		 pS26_4;
    jit_node_t		*nS26_4;
    S26_5		 pS26_5;
    jit_node_t		*nS26_5;
    S26_6		 pS26_6;
    jit_node_t		*nS26_6;
    /* Declare signed bitfields at offset 27 */
    S27_1		 pS27_1;
    jit_node_t		*nS27_1;
    S27_2		 pS27_2;
    jit_node_t		*nS27_2;
    S27_3		 pS27_3;
    jit_node_t		*nS27_3;
    S27_4		 pS27_4;
    jit_node_t		*nS27_4;
    S27_5		 pS27_5;
    jit_node_t		*nS27_5;
    /* Declare signed bitfields at offset 28 */
    S28_1		 pS28_1;
    jit_node_t		*nS28_1;
    S28_2		 pS28_2;
    jit_node_t		*nS28_2;
    S28_3		 pS28_3;
    jit_node_t		*nS28_3;
    S28_4		 pS28_4;
    jit_node_t		*nS28_4;
    /* Declare signed bitfields at offset 29 */
    S29_1		 pS29_1;
    jit_node_t		*nS29_1;
    S29_2		 pS29_2;
    jit_node_t		*nS29_2;
    S29_3		 pS29_3;
    jit_node_t		*nS29_3;
    /* Declare signed bitfields at offset 30 */
    S30_1		 pS30_1;
    jit_node_t		*nS30_1;
    S30_2		 pS30_2;
    jit_node_t		*nS30_2;
    /* Declare signed bitfields at offset 31 */
    S31_1		 pS31_1;
    jit_node_t		*nS31_1;
#if __WORDSIZE == 64 && !SKIP_64_BITS
    /* Declare signed bitfields at offset 1 */
    S1_32		 pS1_32;
    jit_node_t		*nS1_32;
    S1_33		 pS1_33;
    jit_node_t		*nS1_33;
    S1_34		 pS1_34;
    jit_node_t		*nS1_34;
    S1_35		 pS1_35;
    jit_node_t		*nS1_35;
    S1_36		 pS1_36;
    jit_node_t		*nS1_36;
    S1_37		 pS1_37;
    jit_node_t		*nS1_37;
    S1_38		 pS1_38;
    jit_node_t		*nS1_38;
    S1_39		 pS1_39;
    jit_node_t		*nS1_39;
    S1_40		 pS1_40;
    jit_node_t		*nS1_40;
    S1_41		 pS1_41;
    jit_node_t		*nS1_41;
    S1_42		 pS1_42;
    jit_node_t		*nS1_42;
    S1_43		 pS1_43;
    jit_node_t		*nS1_43;
    S1_44		 pS1_44;
    jit_node_t		*nS1_44;
    S1_45		 pS1_45;
    jit_node_t		*nS1_45;
    S1_46		 pS1_46;
    jit_node_t		*nS1_46;
    S1_47		 pS1_47;
    jit_node_t		*nS1_47;
    S1_48		 pS1_48;
    jit_node_t		*nS1_48;
    S1_49		 pS1_49;
    jit_node_t		*nS1_49;
    S1_50		 pS1_50;
    jit_node_t		*nS1_50;
    S1_51		 pS1_51;
    jit_node_t		*nS1_51;
    S1_52		 pS1_52;
    jit_node_t		*nS1_52;
    S1_53		 pS1_53;
    jit_node_t		*nS1_53;
    S1_54		 pS1_54;
    jit_node_t		*nS1_54;
    S1_55		 pS1_55;
    jit_node_t		*nS1_55;
    S1_56		 pS1_56;
    jit_node_t		*nS1_56;
    S1_57		 pS1_57;
    jit_node_t		*nS1_57;
    S1_58		 pS1_58;
    jit_node_t		*nS1_58;
    S1_59		 pS1_59;
    jit_node_t		*nS1_59;
    S1_60		 pS1_60;
    jit_node_t		*nS1_60;
    S1_61		 pS1_61;
    jit_node_t		*nS1_61;
    S1_62		 pS1_62;
    jit_node_t		*nS1_62;
    S1_63		 pS1_63;
    jit_node_t		*nS1_63;
    /* Declare signed bitfields at offset 2 */
    S2_31		 pS2_31;
    jit_node_t		*nS2_31;
    S2_32		 pS2_32;
    jit_node_t		*nS2_32;
    S2_33		 pS2_33;
    jit_node_t		*nS2_33;
    S2_34		 pS2_34;
    jit_node_t		*nS2_34;
    S2_35		 pS2_35;
    jit_node_t		*nS2_35;
    S2_36		 pS2_36;
    jit_node_t		*nS2_36;
    S2_37		 pS2_37;
    jit_node_t		*nS2_37;
    S2_38		 pS2_38;
    jit_node_t		*nS2_38;
    S2_39		 pS2_39;
    jit_node_t		*nS2_39;
    S2_40		 pS2_40;
    jit_node_t		*nS2_40;
    S2_41		 pS2_41;
    jit_node_t		*nS2_41;
    S2_42		 pS2_42;
    jit_node_t		*nS2_42;
    S2_43		 pS2_43;
    jit_node_t		*nS2_43;
    S2_44		 pS2_44;
    jit_node_t		*nS2_44;
    S2_45		 pS2_45;
    jit_node_t		*nS2_45;
    S2_46		 pS2_46;
    jit_node_t		*nS2_46;
    S2_47		 pS2_47;
    jit_node_t		*nS2_47;
    S2_48		 pS2_48;
    jit_node_t		*nS2_48;
    S2_49		 pS2_49;
    jit_node_t		*nS2_49;
    S2_50		 pS2_50;
    jit_node_t		*nS2_50;
    S2_51		 pS2_51;
    jit_node_t		*nS2_51;
    S2_52		 pS2_52;
    jit_node_t		*nS2_52;
    S2_53		 pS2_53;
    jit_node_t		*nS2_53;
    S2_54		 pS2_54;
    jit_node_t		*nS2_54;
    S2_55		 pS2_55;
    jit_node_t		*nS2_55;
    S2_56		 pS2_56;
    jit_node_t		*nS2_56;
    S2_57		 pS2_57;
    jit_node_t		*nS2_57;
    S2_58		 pS2_58;
    jit_node_t		*nS2_58;
    S2_59		 pS2_59;
    jit_node_t		*nS2_59;
    S2_60		 pS2_60;
    jit_node_t		*nS2_60;
    S2_61		 pS2_61;
    jit_node_t		*nS2_61;
    S2_62		 pS2_62;
    jit_node_t		*nS2_62;
    /* Declare signed bitfields at offset 3 */
    S3_30		 pS3_30;
    jit_node_t		*nS3_30;
    S3_31		 pS3_31;
    jit_node_t		*nS3_31;
    S3_32		 pS3_32;
    jit_node_t		*nS3_32;
    S3_33		 pS3_33;
    jit_node_t		*nS3_33;
    S3_34		 pS3_34;
    jit_node_t		*nS3_34;
    S3_35		 pS3_35;
    jit_node_t		*nS3_35;
    S3_36		 pS3_36;
    jit_node_t		*nS3_36;
    S3_37		 pS3_37;
    jit_node_t		*nS3_37;
    S3_38		 pS3_38;
    jit_node_t		*nS3_38;
    S3_39		 pS3_39;
    jit_node_t		*nS3_39;
    S3_40		 pS3_40;
    jit_node_t		*nS3_40;
    S3_41		 pS3_41;
    jit_node_t		*nS3_41;
    S3_42		 pS3_42;
    jit_node_t		*nS3_42;
    S3_43		 pS3_43;
    jit_node_t		*nS3_43;
    S3_44		 pS3_44;
    jit_node_t		*nS3_44;
    S3_45		 pS3_45;
    jit_node_t		*nS3_45;
    S3_46		 pS3_46;
    jit_node_t		*nS3_46;
    S3_47		 pS3_47;
    jit_node_t		*nS3_47;
    S3_48		 pS3_48;
    jit_node_t		*nS3_48;
    S3_49		 pS3_49;
    jit_node_t		*nS3_49;
    S3_50		 pS3_50;
    jit_node_t		*nS3_50;
    S3_51		 pS3_51;
    jit_node_t		*nS3_51;
    S3_52		 pS3_52;
    jit_node_t		*nS3_52;
    S3_53		 pS3_53;
    jit_node_t		*nS3_53;
    S3_54		 pS3_54;
    jit_node_t		*nS3_54;
    S3_55		 pS3_55;
    jit_node_t		*nS3_55;
    S3_56		 pS3_56;
    jit_node_t		*nS3_56;
    S3_57		 pS3_57;
    jit_node_t		*nS3_57;
    S3_58		 pS3_58;
    jit_node_t		*nS3_58;
    S3_59		 pS3_59;
    jit_node_t		*nS3_59;
    S3_60		 pS3_60;
    jit_node_t		*nS3_60;
    S3_61		 pS3_61;
    jit_node_t		*nS3_61;
    /* Declare signed bitfields at offset 4 */
    S4_29		 pS4_29;
    jit_node_t		*nS4_29;
    S4_30		 pS4_30;
    jit_node_t		*nS4_30;
    S4_31		 pS4_31;
    jit_node_t		*nS4_31;
    S4_32		 pS4_32;
    jit_node_t		*nS4_32;
    S4_33		 pS4_33;
    jit_node_t		*nS4_33;
    S4_34		 pS4_34;
    jit_node_t		*nS4_34;
    S4_35		 pS4_35;
    jit_node_t		*nS4_35;
    S4_36		 pS4_36;
    jit_node_t		*nS4_36;
    S4_37		 pS4_37;
    jit_node_t		*nS4_37;
    S4_38		 pS4_38;
    jit_node_t		*nS4_38;
    S4_39		 pS4_39;
    jit_node_t		*nS4_39;
    S4_40		 pS4_40;
    jit_node_t		*nS4_40;
    S4_41		 pS4_41;
    jit_node_t		*nS4_41;
    S4_42		 pS4_42;
    jit_node_t		*nS4_42;
    S4_43		 pS4_43;
    jit_node_t		*nS4_43;
    S4_44		 pS4_44;
    jit_node_t		*nS4_44;
    S4_45		 pS4_45;
    jit_node_t		*nS4_45;
    S4_46		 pS4_46;
    jit_node_t		*nS4_46;
    S4_47		 pS4_47;
    jit_node_t		*nS4_47;
    S4_48		 pS4_48;
    jit_node_t		*nS4_48;
    S4_49		 pS4_49;
    jit_node_t		*nS4_49;
    S4_50		 pS4_50;
    jit_node_t		*nS4_50;
    S4_51		 pS4_51;
    jit_node_t		*nS4_51;
    S4_52		 pS4_52;
    jit_node_t		*nS4_52;
    S4_53		 pS4_53;
    jit_node_t		*nS4_53;
    S4_54		 pS4_54;
    jit_node_t		*nS4_54;
    S4_55		 pS4_55;
    jit_node_t		*nS4_55;
    S4_56		 pS4_56;
    jit_node_t		*nS4_56;
    S4_57		 pS4_57;
    jit_node_t		*nS4_57;
    S4_58		 pS4_58;
    jit_node_t		*nS4_58;
    S4_59		 pS4_59;
    jit_node_t		*nS4_59;
    S4_60		 pS4_60;
    jit_node_t		*nS4_60;
    /* Declare signed bitfields at offset 5 */
    S5_28		 pS5_28;
    jit_node_t		*nS5_28;
    S5_29		 pS5_29;
    jit_node_t		*nS5_29;
    S5_30		 pS5_30;
    jit_node_t		*nS5_30;
    S5_31		 pS5_31;
    jit_node_t		*nS5_31;
    S5_32		 pS5_32;
    jit_node_t		*nS5_32;
    S5_33		 pS5_33;
    jit_node_t		*nS5_33;
    S5_34		 pS5_34;
    jit_node_t		*nS5_34;
    S5_35		 pS5_35;
    jit_node_t		*nS5_35;
    S5_36		 pS5_36;
    jit_node_t		*nS5_36;
    S5_37		 pS5_37;
    jit_node_t		*nS5_37;
    S5_38		 pS5_38;
    jit_node_t		*nS5_38;
    S5_39		 pS5_39;
    jit_node_t		*nS5_39;
    S5_40		 pS5_40;
    jit_node_t		*nS5_40;
    S5_41		 pS5_41;
    jit_node_t		*nS5_41;
    S5_42		 pS5_42;
    jit_node_t		*nS5_42;
    S5_43		 pS5_43;
    jit_node_t		*nS5_43;
    S5_44		 pS5_44;
    jit_node_t		*nS5_44;
    S5_45		 pS5_45;
    jit_node_t		*nS5_45;
    S5_46		 pS5_46;
    jit_node_t		*nS5_46;
    S5_47		 pS5_47;
    jit_node_t		*nS5_47;
    S5_48		 pS5_48;
    jit_node_t		*nS5_48;
    S5_49		 pS5_49;
    jit_node_t		*nS5_49;
    S5_50		 pS5_50;
    jit_node_t		*nS5_50;
    S5_51		 pS5_51;
    jit_node_t		*nS5_51;
    S5_52		 pS5_52;
    jit_node_t		*nS5_52;
    S5_53		 pS5_53;
    jit_node_t		*nS5_53;
    S5_54		 pS5_54;
    jit_node_t		*nS5_54;
    S5_55		 pS5_55;
    jit_node_t		*nS5_55;
    S5_56		 pS5_56;
    jit_node_t		*nS5_56;
    S5_57		 pS5_57;
    jit_node_t		*nS5_57;
    S5_58		 pS5_58;
    jit_node_t		*nS5_58;
    S5_59		 pS5_59;
    jit_node_t		*nS5_59;
    /* Declare signed bitfields at offset 6 */
    S6_27		 pS6_27;
    jit_node_t		*nS6_27;
    S6_28		 pS6_28;
    jit_node_t		*nS6_28;
    S6_29		 pS6_29;
    jit_node_t		*nS6_29;
    S6_30		 pS6_30;
    jit_node_t		*nS6_30;
    S6_31		 pS6_31;
    jit_node_t		*nS6_31;
    S6_32		 pS6_32;
    jit_node_t		*nS6_32;
    S6_33		 pS6_33;
    jit_node_t		*nS6_33;
    S6_34		 pS6_34;
    jit_node_t		*nS6_34;
    S6_35		 pS6_35;
    jit_node_t		*nS6_35;
    S6_36		 pS6_36;
    jit_node_t		*nS6_36;
    S6_37		 pS6_37;
    jit_node_t		*nS6_37;
    S6_38		 pS6_38;
    jit_node_t		*nS6_38;
    S6_39		 pS6_39;
    jit_node_t		*nS6_39;
    S6_40		 pS6_40;
    jit_node_t		*nS6_40;
    S6_41		 pS6_41;
    jit_node_t		*nS6_41;
    S6_42		 pS6_42;
    jit_node_t		*nS6_42;
    S6_43		 pS6_43;
    jit_node_t		*nS6_43;
    S6_44		 pS6_44;
    jit_node_t		*nS6_44;
    S6_45		 pS6_45;
    jit_node_t		*nS6_45;
    S6_46		 pS6_46;
    jit_node_t		*nS6_46;
    S6_47		 pS6_47;
    jit_node_t		*nS6_47;
    S6_48		 pS6_48;
    jit_node_t		*nS6_48;
    S6_49		 pS6_49;
    jit_node_t		*nS6_49;
    S6_50		 pS6_50;
    jit_node_t		*nS6_50;
    S6_51		 pS6_51;
    jit_node_t		*nS6_51;
    S6_52		 pS6_52;
    jit_node_t		*nS6_52;
    S6_53		 pS6_53;
    jit_node_t		*nS6_53;
    S6_54		 pS6_54;
    jit_node_t		*nS6_54;
    S6_55		 pS6_55;
    jit_node_t		*nS6_55;
    S6_56		 pS6_56;
    jit_node_t		*nS6_56;
    S6_57		 pS6_57;
    jit_node_t		*nS6_57;
    S6_58		 pS6_58;
    jit_node_t		*nS6_58;
    /* Declare signed bitfields at offset 7 */
    S7_26		 pS7_26;
    jit_node_t		*nS7_26;
    S7_27		 pS7_27;
    jit_node_t		*nS7_27;
    S7_28		 pS7_28;
    jit_node_t		*nS7_28;
    S7_29		 pS7_29;
    jit_node_t		*nS7_29;
    S7_30		 pS7_30;
    jit_node_t		*nS7_30;
    S7_31		 pS7_31;
    jit_node_t		*nS7_31;
    S7_32		 pS7_32;
    jit_node_t		*nS7_32;
    S7_33		 pS7_33;
    jit_node_t		*nS7_33;
    S7_34		 pS7_34;
    jit_node_t		*nS7_34;
    S7_35		 pS7_35;
    jit_node_t		*nS7_35;
    S7_36		 pS7_36;
    jit_node_t		*nS7_36;
    S7_37		 pS7_37;
    jit_node_t		*nS7_37;
    S7_38		 pS7_38;
    jit_node_t		*nS7_38;
    S7_39		 pS7_39;
    jit_node_t		*nS7_39;
    S7_40		 pS7_40;
    jit_node_t		*nS7_40;
    S7_41		 pS7_41;
    jit_node_t		*nS7_41;
    S7_42		 pS7_42;
    jit_node_t		*nS7_42;
    S7_43		 pS7_43;
    jit_node_t		*nS7_43;
    S7_44		 pS7_44;
    jit_node_t		*nS7_44;
    S7_45		 pS7_45;
    jit_node_t		*nS7_45;
    S7_46		 pS7_46;
    jit_node_t		*nS7_46;
    S7_47		 pS7_47;
    jit_node_t		*nS7_47;
    S7_48		 pS7_48;
    jit_node_t		*nS7_48;
    S7_49		 pS7_49;
    jit_node_t		*nS7_49;
    S7_50		 pS7_50;
    jit_node_t		*nS7_50;
    S7_51		 pS7_51;
    jit_node_t		*nS7_51;
    S7_52		 pS7_52;
    jit_node_t		*nS7_52;
    S7_53		 pS7_53;
    jit_node_t		*nS7_53;
    S7_54		 pS7_54;
    jit_node_t		*nS7_54;
    S7_55		 pS7_55;
    jit_node_t		*nS7_55;
    S7_56		 pS7_56;
    jit_node_t		*nS7_56;
    S7_57		 pS7_57;
    jit_node_t		*nS7_57;
    /* Declare signed bitfields at offset 8 */
    S8_25		 pS8_25;
    jit_node_t		*nS8_25;
    S8_26		 pS8_26;
    jit_node_t		*nS8_26;
    S8_27		 pS8_27;
    jit_node_t		*nS8_27;
    S8_28		 pS8_28;
    jit_node_t		*nS8_28;
    S8_29		 pS8_29;
    jit_node_t		*nS8_29;
    S8_30		 pS8_30;
    jit_node_t		*nS8_30;
    S8_31		 pS8_31;
    jit_node_t		*nS8_31;
    S8_32		 pS8_32;
    jit_node_t		*nS8_32;
    S8_33		 pS8_33;
    jit_node_t		*nS8_33;
    S8_34		 pS8_34;
    jit_node_t		*nS8_34;
    S8_35		 pS8_35;
    jit_node_t		*nS8_35;
    S8_36		 pS8_36;
    jit_node_t		*nS8_36;
    S8_37		 pS8_37;
    jit_node_t		*nS8_37;
    S8_38		 pS8_38;
    jit_node_t		*nS8_38;
    S8_39		 pS8_39;
    jit_node_t		*nS8_39;
    S8_40		 pS8_40;
    jit_node_t		*nS8_40;
    S8_41		 pS8_41;
    jit_node_t		*nS8_41;
    S8_42		 pS8_42;
    jit_node_t		*nS8_42;
    S8_43		 pS8_43;
    jit_node_t		*nS8_43;
    S8_44		 pS8_44;
    jit_node_t		*nS8_44;
    S8_45		 pS8_45;
    jit_node_t		*nS8_45;
    S8_46		 pS8_46;
    jit_node_t		*nS8_46;
    S8_47		 pS8_47;
    jit_node_t		*nS8_47;
    S8_48		 pS8_48;
    jit_node_t		*nS8_48;
    S8_49		 pS8_49;
    jit_node_t		*nS8_49;
    S8_50		 pS8_50;
    jit_node_t		*nS8_50;
    S8_51		 pS8_51;
    jit_node_t		*nS8_51;
    S8_52		 pS8_52;
    jit_node_t		*nS8_52;
    S8_53		 pS8_53;
    jit_node_t		*nS8_53;
    S8_54		 pS8_54;
    jit_node_t		*nS8_54;
    S8_55		 pS8_55;
    jit_node_t		*nS8_55;
    S8_56		 pS8_56;
    jit_node_t		*nS8_56;
    /* Declare signed bitfields at offset 9 */
    S9_24		 pS9_24;
    jit_node_t		*nS9_24;
    S9_25		 pS9_25;
    jit_node_t		*nS9_25;
    S9_26		 pS9_26;
    jit_node_t		*nS9_26;
    S9_27		 pS9_27;
    jit_node_t		*nS9_27;
    S9_28		 pS9_28;
    jit_node_t		*nS9_28;
    S9_29		 pS9_29;
    jit_node_t		*nS9_29;
    S9_30		 pS9_30;
    jit_node_t		*nS9_30;
    S9_31		 pS9_31;
    jit_node_t		*nS9_31;
    S9_32		 pS9_32;
    jit_node_t		*nS9_32;
    S9_33		 pS9_33;
    jit_node_t		*nS9_33;
    S9_34		 pS9_34;
    jit_node_t		*nS9_34;
    S9_35		 pS9_35;
    jit_node_t		*nS9_35;
    S9_36		 pS9_36;
    jit_node_t		*nS9_36;
    S9_37		 pS9_37;
    jit_node_t		*nS9_37;
    S9_38		 pS9_38;
    jit_node_t		*nS9_38;
    S9_39		 pS9_39;
    jit_node_t		*nS9_39;
    S9_40		 pS9_40;
    jit_node_t		*nS9_40;
    S9_41		 pS9_41;
    jit_node_t		*nS9_41;
    S9_42		 pS9_42;
    jit_node_t		*nS9_42;
    S9_43		 pS9_43;
    jit_node_t		*nS9_43;
    S9_44		 pS9_44;
    jit_node_t		*nS9_44;
    S9_45		 pS9_45;
    jit_node_t		*nS9_45;
    S9_46		 pS9_46;
    jit_node_t		*nS9_46;
    S9_47		 pS9_47;
    jit_node_t		*nS9_47;
    S9_48		 pS9_48;
    jit_node_t		*nS9_48;
    S9_49		 pS9_49;
    jit_node_t		*nS9_49;
    S9_50		 pS9_50;
    jit_node_t		*nS9_50;
    S9_51		 pS9_51;
    jit_node_t		*nS9_51;
    S9_52		 pS9_52;
    jit_node_t		*nS9_52;
    S9_53		 pS9_53;
    jit_node_t		*nS9_53;
    S9_54		 pS9_54;
    jit_node_t		*nS9_54;
    S9_55		 pS9_55;
    jit_node_t		*nS9_55;
    /* Declare signed bitfields at offset 10 */
    S10_23		 pS10_23;
    jit_node_t		*nS10_23;
    S10_24		 pS10_24;
    jit_node_t		*nS10_24;
    S10_25		 pS10_25;
    jit_node_t		*nS10_25;
    S10_26		 pS10_26;
    jit_node_t		*nS10_26;
    S10_27		 pS10_27;
    jit_node_t		*nS10_27;
    S10_28		 pS10_28;
    jit_node_t		*nS10_28;
    S10_29		 pS10_29;
    jit_node_t		*nS10_29;
    S10_30		 pS10_30;
    jit_node_t		*nS10_30;
    S10_31		 pS10_31;
    jit_node_t		*nS10_31;
    S10_32		 pS10_32;
    jit_node_t		*nS10_32;
    S10_33		 pS10_33;
    jit_node_t		*nS10_33;
    S10_34		 pS10_34;
    jit_node_t		*nS10_34;
    S10_35		 pS10_35;
    jit_node_t		*nS10_35;
    S10_36		 pS10_36;
    jit_node_t		*nS10_36;
    S10_37		 pS10_37;
    jit_node_t		*nS10_37;
    S10_38		 pS10_38;
    jit_node_t		*nS10_38;
    S10_39		 pS10_39;
    jit_node_t		*nS10_39;
    S10_40		 pS10_40;
    jit_node_t		*nS10_40;
    S10_41		 pS10_41;
    jit_node_t		*nS10_41;
    S10_42		 pS10_42;
    jit_node_t		*nS10_42;
    S10_43		 pS10_43;
    jit_node_t		*nS10_43;
    S10_44		 pS10_44;
    jit_node_t		*nS10_44;
    S10_45		 pS10_45;
    jit_node_t		*nS10_45;
    S10_46		 pS10_46;
    jit_node_t		*nS10_46;
    S10_47		 pS10_47;
    jit_node_t		*nS10_47;
    S10_48		 pS10_48;
    jit_node_t		*nS10_48;
    S10_49		 pS10_49;
    jit_node_t		*nS10_49;
    S10_50		 pS10_50;
    jit_node_t		*nS10_50;
    S10_51		 pS10_51;
    jit_node_t		*nS10_51;
    S10_52		 pS10_52;
    jit_node_t		*nS10_52;
    S10_53		 pS10_53;
    jit_node_t		*nS10_53;
    S10_54		 pS10_54;
    jit_node_t		*nS10_54;
    /* Declare signed bitfields at offset 11 */
    S11_22		 pS11_22;
    jit_node_t		*nS11_22;
    S11_23		 pS11_23;
    jit_node_t		*nS11_23;
    S11_24		 pS11_24;
    jit_node_t		*nS11_24;
    S11_25		 pS11_25;
    jit_node_t		*nS11_25;
    S11_26		 pS11_26;
    jit_node_t		*nS11_26;
    S11_27		 pS11_27;
    jit_node_t		*nS11_27;
    S11_28		 pS11_28;
    jit_node_t		*nS11_28;
    S11_29		 pS11_29;
    jit_node_t		*nS11_29;
    S11_30		 pS11_30;
    jit_node_t		*nS11_30;
    S11_31		 pS11_31;
    jit_node_t		*nS11_31;
    S11_32		 pS11_32;
    jit_node_t		*nS11_32;
    S11_33		 pS11_33;
    jit_node_t		*nS11_33;
    S11_34		 pS11_34;
    jit_node_t		*nS11_34;
    S11_35		 pS11_35;
    jit_node_t		*nS11_35;
    S11_36		 pS11_36;
    jit_node_t		*nS11_36;
    S11_37		 pS11_37;
    jit_node_t		*nS11_37;
    S11_38		 pS11_38;
    jit_node_t		*nS11_38;
    S11_39		 pS11_39;
    jit_node_t		*nS11_39;
    S11_40		 pS11_40;
    jit_node_t		*nS11_40;
    S11_41		 pS11_41;
    jit_node_t		*nS11_41;
    S11_42		 pS11_42;
    jit_node_t		*nS11_42;
    S11_43		 pS11_43;
    jit_node_t		*nS11_43;
    S11_44		 pS11_44;
    jit_node_t		*nS11_44;
    S11_45		 pS11_45;
    jit_node_t		*nS11_45;
    S11_46		 pS11_46;
    jit_node_t		*nS11_46;
    S11_47		 pS11_47;
    jit_node_t		*nS11_47;
    S11_48		 pS11_48;
    jit_node_t		*nS11_48;
    S11_49		 pS11_49;
    jit_node_t		*nS11_49;
    S11_50		 pS11_50;
    jit_node_t		*nS11_50;
    S11_51		 pS11_51;
    jit_node_t		*nS11_51;
    S11_52		 pS11_52;
    jit_node_t		*nS11_52;
    S11_53		 pS11_53;
    jit_node_t		*nS11_53;
    /* Declare signed bitfields at offset 12 */
    S12_21		 pS12_21;
    jit_node_t		*nS12_21;
    S12_22		 pS12_22;
    jit_node_t		*nS12_22;
    S12_23		 pS12_23;
    jit_node_t		*nS12_23;
    S12_24		 pS12_24;
    jit_node_t		*nS12_24;
    S12_25		 pS12_25;
    jit_node_t		*nS12_25;
    S12_26		 pS12_26;
    jit_node_t		*nS12_26;
    S12_27		 pS12_27;
    jit_node_t		*nS12_27;
    S12_28		 pS12_28;
    jit_node_t		*nS12_28;
    S12_29		 pS12_29;
    jit_node_t		*nS12_29;
    S12_30		 pS12_30;
    jit_node_t		*nS12_30;
    S12_31		 pS12_31;
    jit_node_t		*nS12_31;
    S12_32		 pS12_32;
    jit_node_t		*nS12_32;
    S12_33		 pS12_33;
    jit_node_t		*nS12_33;
    S12_34		 pS12_34;
    jit_node_t		*nS12_34;
    S12_35		 pS12_35;
    jit_node_t		*nS12_35;
    S12_36		 pS12_36;
    jit_node_t		*nS12_36;
    S12_37		 pS12_37;
    jit_node_t		*nS12_37;
    S12_38		 pS12_38;
    jit_node_t		*nS12_38;
    S12_39		 pS12_39;
    jit_node_t		*nS12_39;
    S12_40		 pS12_40;
    jit_node_t		*nS12_40;
    S12_41		 pS12_41;
    jit_node_t		*nS12_41;
    S12_42		 pS12_42;
    jit_node_t		*nS12_42;
    S12_43		 pS12_43;
    jit_node_t		*nS12_43;
    S12_44		 pS12_44;
    jit_node_t		*nS12_44;
    S12_45		 pS12_45;
    jit_node_t		*nS12_45;
    S12_46		 pS12_46;
    jit_node_t		*nS12_46;
    S12_47		 pS12_47;
    jit_node_t		*nS12_47;
    S12_48		 pS12_48;
    jit_node_t		*nS12_48;
    S12_49		 pS12_49;
    jit_node_t		*nS12_49;
    S12_50		 pS12_50;
    jit_node_t		*nS12_50;
    S12_51		 pS12_51;
    jit_node_t		*nS12_51;
    S12_52		 pS12_52;
    jit_node_t		*nS12_52;
    /* Declare signed bitfields at offset 13 */
    S13_20		 pS13_20;
    jit_node_t		*nS13_20;
    S13_21		 pS13_21;
    jit_node_t		*nS13_21;
    S13_22		 pS13_22;
    jit_node_t		*nS13_22;
    S13_23		 pS13_23;
    jit_node_t		*nS13_23;
    S13_24		 pS13_24;
    jit_node_t		*nS13_24;
    S13_25		 pS13_25;
    jit_node_t		*nS13_25;
    S13_26		 pS13_26;
    jit_node_t		*nS13_26;
    S13_27		 pS13_27;
    jit_node_t		*nS13_27;
    S13_28		 pS13_28;
    jit_node_t		*nS13_28;
    S13_29		 pS13_29;
    jit_node_t		*nS13_29;
    S13_30		 pS13_30;
    jit_node_t		*nS13_30;
    S13_31		 pS13_31;
    jit_node_t		*nS13_31;
    S13_32		 pS13_32;
    jit_node_t		*nS13_32;
    S13_33		 pS13_33;
    jit_node_t		*nS13_33;
    S13_34		 pS13_34;
    jit_node_t		*nS13_34;
    S13_35		 pS13_35;
    jit_node_t		*nS13_35;
    S13_36		 pS13_36;
    jit_node_t		*nS13_36;
    S13_37		 pS13_37;
    jit_node_t		*nS13_37;
    S13_38		 pS13_38;
    jit_node_t		*nS13_38;
    S13_39		 pS13_39;
    jit_node_t		*nS13_39;
    S13_40		 pS13_40;
    jit_node_t		*nS13_40;
    S13_41		 pS13_41;
    jit_node_t		*nS13_41;
    S13_42		 pS13_42;
    jit_node_t		*nS13_42;
    S13_43		 pS13_43;
    jit_node_t		*nS13_43;
    S13_44		 pS13_44;
    jit_node_t		*nS13_44;
    S13_45		 pS13_45;
    jit_node_t		*nS13_45;
    S13_46		 pS13_46;
    jit_node_t		*nS13_46;
    S13_47		 pS13_47;
    jit_node_t		*nS13_47;
    S13_48		 pS13_48;
    jit_node_t		*nS13_48;
    S13_49		 pS13_49;
    jit_node_t		*nS13_49;
    S13_50		 pS13_50;
    jit_node_t		*nS13_50;
    S13_51		 pS13_51;
    jit_node_t		*nS13_51;
    /* Declare signed bitfields at offset 14 */
    S14_19		 pS14_19;
    jit_node_t		*nS14_19;
    S14_20		 pS14_20;
    jit_node_t		*nS14_20;
    S14_21		 pS14_21;
    jit_node_t		*nS14_21;
    S14_22		 pS14_22;
    jit_node_t		*nS14_22;
    S14_23		 pS14_23;
    jit_node_t		*nS14_23;
    S14_24		 pS14_24;
    jit_node_t		*nS14_24;
    S14_25		 pS14_25;
    jit_node_t		*nS14_25;
    S14_26		 pS14_26;
    jit_node_t		*nS14_26;
    S14_27		 pS14_27;
    jit_node_t		*nS14_27;
    S14_28		 pS14_28;
    jit_node_t		*nS14_28;
    S14_29		 pS14_29;
    jit_node_t		*nS14_29;
    S14_30		 pS14_30;
    jit_node_t		*nS14_30;
    S14_31		 pS14_31;
    jit_node_t		*nS14_31;
    S14_32		 pS14_32;
    jit_node_t		*nS14_32;
    S14_33		 pS14_33;
    jit_node_t		*nS14_33;
    S14_34		 pS14_34;
    jit_node_t		*nS14_34;
    S14_35		 pS14_35;
    jit_node_t		*nS14_35;
    S14_36		 pS14_36;
    jit_node_t		*nS14_36;
    S14_37		 pS14_37;
    jit_node_t		*nS14_37;
    S14_38		 pS14_38;
    jit_node_t		*nS14_38;
    S14_39		 pS14_39;
    jit_node_t		*nS14_39;
    S14_40		 pS14_40;
    jit_node_t		*nS14_40;
    S14_41		 pS14_41;
    jit_node_t		*nS14_41;
    S14_42		 pS14_42;
    jit_node_t		*nS14_42;
    S14_43		 pS14_43;
    jit_node_t		*nS14_43;
    S14_44		 pS14_44;
    jit_node_t		*nS14_44;
    S14_45		 pS14_45;
    jit_node_t		*nS14_45;
    S14_46		 pS14_46;
    jit_node_t		*nS14_46;
    S14_47		 pS14_47;
    jit_node_t		*nS14_47;
    S14_48		 pS14_48;
    jit_node_t		*nS14_48;
    S14_49		 pS14_49;
    jit_node_t		*nS14_49;
    S14_50		 pS14_50;
    jit_node_t		*nS14_50;
    /* Declare signed bitfields at offset 15 */
    S15_18		 pS15_18;
    jit_node_t		*nS15_18;
    S15_19		 pS15_19;
    jit_node_t		*nS15_19;
    S15_20		 pS15_20;
    jit_node_t		*nS15_20;
    S15_21		 pS15_21;
    jit_node_t		*nS15_21;
    S15_22		 pS15_22;
    jit_node_t		*nS15_22;
    S15_23		 pS15_23;
    jit_node_t		*nS15_23;
    S15_24		 pS15_24;
    jit_node_t		*nS15_24;
    S15_25		 pS15_25;
    jit_node_t		*nS15_25;
    S15_26		 pS15_26;
    jit_node_t		*nS15_26;
    S15_27		 pS15_27;
    jit_node_t		*nS15_27;
    S15_28		 pS15_28;
    jit_node_t		*nS15_28;
    S15_29		 pS15_29;
    jit_node_t		*nS15_29;
    S15_30		 pS15_30;
    jit_node_t		*nS15_30;
    S15_31		 pS15_31;
    jit_node_t		*nS15_31;
    S15_32		 pS15_32;
    jit_node_t		*nS15_32;
    S15_33		 pS15_33;
    jit_node_t		*nS15_33;
    S15_34		 pS15_34;
    jit_node_t		*nS15_34;
    S15_35		 pS15_35;
    jit_node_t		*nS15_35;
    S15_36		 pS15_36;
    jit_node_t		*nS15_36;
    S15_37		 pS15_37;
    jit_node_t		*nS15_37;
    S15_38		 pS15_38;
    jit_node_t		*nS15_38;
    S15_39		 pS15_39;
    jit_node_t		*nS15_39;
    S15_40		 pS15_40;
    jit_node_t		*nS15_40;
    S15_41		 pS15_41;
    jit_node_t		*nS15_41;
    S15_42		 pS15_42;
    jit_node_t		*nS15_42;
    S15_43		 pS15_43;
    jit_node_t		*nS15_43;
    S15_44		 pS15_44;
    jit_node_t		*nS15_44;
    S15_45		 pS15_45;
    jit_node_t		*nS15_45;
    S15_46		 pS15_46;
    jit_node_t		*nS15_46;
    S15_47		 pS15_47;
    jit_node_t		*nS15_47;
    S15_48		 pS15_48;
    jit_node_t		*nS15_48;
    S15_49		 pS15_49;
    jit_node_t		*nS15_49;
    /* Declare signed bitfields at offset 16 */
    S16_17		 pS16_17;
    jit_node_t		*nS16_17;
    S16_18		 pS16_18;
    jit_node_t		*nS16_18;
    S16_19		 pS16_19;
    jit_node_t		*nS16_19;
    S16_20		 pS16_20;
    jit_node_t		*nS16_20;
    S16_21		 pS16_21;
    jit_node_t		*nS16_21;
    S16_22		 pS16_22;
    jit_node_t		*nS16_22;
    S16_23		 pS16_23;
    jit_node_t		*nS16_23;
    S16_24		 pS16_24;
    jit_node_t		*nS16_24;
    S16_25		 pS16_25;
    jit_node_t		*nS16_25;
    S16_26		 pS16_26;
    jit_node_t		*nS16_26;
    S16_27		 pS16_27;
    jit_node_t		*nS16_27;
    S16_28		 pS16_28;
    jit_node_t		*nS16_28;
    S16_29		 pS16_29;
    jit_node_t		*nS16_29;
    S16_30		 pS16_30;
    jit_node_t		*nS16_30;
    S16_31		 pS16_31;
    jit_node_t		*nS16_31;
    S16_32		 pS16_32;
    jit_node_t		*nS16_32;
    S16_33		 pS16_33;
    jit_node_t		*nS16_33;
    S16_34		 pS16_34;
    jit_node_t		*nS16_34;
    S16_35		 pS16_35;
    jit_node_t		*nS16_35;
    S16_36		 pS16_36;
    jit_node_t		*nS16_36;
    S16_37		 pS16_37;
    jit_node_t		*nS16_37;
    S16_38		 pS16_38;
    jit_node_t		*nS16_38;
    S16_39		 pS16_39;
    jit_node_t		*nS16_39;
    S16_40		 pS16_40;
    jit_node_t		*nS16_40;
    S16_41		 pS16_41;
    jit_node_t		*nS16_41;
    S16_42		 pS16_42;
    jit_node_t		*nS16_42;
    S16_43		 pS16_43;
    jit_node_t		*nS16_43;
    S16_44		 pS16_44;
    jit_node_t		*nS16_44;
    S16_45		 pS16_45;
    jit_node_t		*nS16_45;
    S16_46		 pS16_46;
    jit_node_t		*nS16_46;
    S16_47		 pS16_47;
    jit_node_t		*nS16_47;
    S16_48		 pS16_48;
    jit_node_t		*nS16_48;
    /* Declare signed bitfields at offset 17 */
    S17_16		 pS17_16;
    jit_node_t		*nS17_16;
    S17_17		 pS17_17;
    jit_node_t		*nS17_17;
    S17_18		 pS17_18;
    jit_node_t		*nS17_18;
    S17_19		 pS17_19;
    jit_node_t		*nS17_19;
    S17_20		 pS17_20;
    jit_node_t		*nS17_20;
    S17_21		 pS17_21;
    jit_node_t		*nS17_21;
    S17_22		 pS17_22;
    jit_node_t		*nS17_22;
    S17_23		 pS17_23;
    jit_node_t		*nS17_23;
    S17_24		 pS17_24;
    jit_node_t		*nS17_24;
    S17_25		 pS17_25;
    jit_node_t		*nS17_25;
    S17_26		 pS17_26;
    jit_node_t		*nS17_26;
    S17_27		 pS17_27;
    jit_node_t		*nS17_27;
    S17_28		 pS17_28;
    jit_node_t		*nS17_28;
    S17_29		 pS17_29;
    jit_node_t		*nS17_29;
    S17_30		 pS17_30;
    jit_node_t		*nS17_30;
    S17_31		 pS17_31;
    jit_node_t		*nS17_31;
    S17_32		 pS17_32;
    jit_node_t		*nS17_32;
    S17_33		 pS17_33;
    jit_node_t		*nS17_33;
    S17_34		 pS17_34;
    jit_node_t		*nS17_34;
    S17_35		 pS17_35;
    jit_node_t		*nS17_35;
    S17_36		 pS17_36;
    jit_node_t		*nS17_36;
    S17_37		 pS17_37;
    jit_node_t		*nS17_37;
    S17_38		 pS17_38;
    jit_node_t		*nS17_38;
    S17_39		 pS17_39;
    jit_node_t		*nS17_39;
    S17_40		 pS17_40;
    jit_node_t		*nS17_40;
    S17_41		 pS17_41;
    jit_node_t		*nS17_41;
    S17_42		 pS17_42;
    jit_node_t		*nS17_42;
    S17_43		 pS17_43;
    jit_node_t		*nS17_43;
    S17_44		 pS17_44;
    jit_node_t		*nS17_44;
    S17_45		 pS17_45;
    jit_node_t		*nS17_45;
    S17_46		 pS17_46;
    jit_node_t		*nS17_46;
    S17_47		 pS17_47;
    jit_node_t		*nS17_47;
    /* Declare signed bitfields at offset 18 */
    S18_15		 pS18_15;
    jit_node_t		*nS18_15;
    S18_16		 pS18_16;
    jit_node_t		*nS18_16;
    S18_17		 pS18_17;
    jit_node_t		*nS18_17;
    S18_18		 pS18_18;
    jit_node_t		*nS18_18;
    S18_19		 pS18_19;
    jit_node_t		*nS18_19;
    S18_20		 pS18_20;
    jit_node_t		*nS18_20;
    S18_21		 pS18_21;
    jit_node_t		*nS18_21;
    S18_22		 pS18_22;
    jit_node_t		*nS18_22;
    S18_23		 pS18_23;
    jit_node_t		*nS18_23;
    S18_24		 pS18_24;
    jit_node_t		*nS18_24;
    S18_25		 pS18_25;
    jit_node_t		*nS18_25;
    S18_26		 pS18_26;
    jit_node_t		*nS18_26;
    S18_27		 pS18_27;
    jit_node_t		*nS18_27;
    S18_28		 pS18_28;
    jit_node_t		*nS18_28;
    S18_29		 pS18_29;
    jit_node_t		*nS18_29;
    S18_30		 pS18_30;
    jit_node_t		*nS18_30;
    S18_31		 pS18_31;
    jit_node_t		*nS18_31;
    S18_32		 pS18_32;
    jit_node_t		*nS18_32;
    S18_33		 pS18_33;
    jit_node_t		*nS18_33;
    S18_34		 pS18_34;
    jit_node_t		*nS18_34;
    S18_35		 pS18_35;
    jit_node_t		*nS18_35;
    S18_36		 pS18_36;
    jit_node_t		*nS18_36;
    S18_37		 pS18_37;
    jit_node_t		*nS18_37;
    S18_38		 pS18_38;
    jit_node_t		*nS18_38;
    S18_39		 pS18_39;
    jit_node_t		*nS18_39;
    S18_40		 pS18_40;
    jit_node_t		*nS18_40;
    S18_41		 pS18_41;
    jit_node_t		*nS18_41;
    S18_42		 pS18_42;
    jit_node_t		*nS18_42;
    S18_43		 pS18_43;
    jit_node_t		*nS18_43;
    S18_44		 pS18_44;
    jit_node_t		*nS18_44;
    S18_45		 pS18_45;
    jit_node_t		*nS18_45;
    S18_46		 pS18_46;
    jit_node_t		*nS18_46;
    /* Declare signed bitfields at offset 19 */
    S19_14		 pS19_14;
    jit_node_t		*nS19_14;
    S19_15		 pS19_15;
    jit_node_t		*nS19_15;
    S19_16		 pS19_16;
    jit_node_t		*nS19_16;
    S19_17		 pS19_17;
    jit_node_t		*nS19_17;
    S19_18		 pS19_18;
    jit_node_t		*nS19_18;
    S19_19		 pS19_19;
    jit_node_t		*nS19_19;
    S19_20		 pS19_20;
    jit_node_t		*nS19_20;
    S19_21		 pS19_21;
    jit_node_t		*nS19_21;
    S19_22		 pS19_22;
    jit_node_t		*nS19_22;
    S19_23		 pS19_23;
    jit_node_t		*nS19_23;
    S19_24		 pS19_24;
    jit_node_t		*nS19_24;
    S19_25		 pS19_25;
    jit_node_t		*nS19_25;
    S19_26		 pS19_26;
    jit_node_t		*nS19_26;
    S19_27		 pS19_27;
    jit_node_t		*nS19_27;
    S19_28		 pS19_28;
    jit_node_t		*nS19_28;
    S19_29		 pS19_29;
    jit_node_t		*nS19_29;
    S19_30		 pS19_30;
    jit_node_t		*nS19_30;
    S19_31		 pS19_31;
    jit_node_t		*nS19_31;
    S19_32		 pS19_32;
    jit_node_t		*nS19_32;
    S19_33		 pS19_33;
    jit_node_t		*nS19_33;
    S19_34		 pS19_34;
    jit_node_t		*nS19_34;
    S19_35		 pS19_35;
    jit_node_t		*nS19_35;
    S19_36		 pS19_36;
    jit_node_t		*nS19_36;
    S19_37		 pS19_37;
    jit_node_t		*nS19_37;
    S19_38		 pS19_38;
    jit_node_t		*nS19_38;
    S19_39		 pS19_39;
    jit_node_t		*nS19_39;
    S19_40		 pS19_40;
    jit_node_t		*nS19_40;
    S19_41		 pS19_41;
    jit_node_t		*nS19_41;
    S19_42		 pS19_42;
    jit_node_t		*nS19_42;
    S19_43		 pS19_43;
    jit_node_t		*nS19_43;
    S19_44		 pS19_44;
    jit_node_t		*nS19_44;
    S19_45		 pS19_45;
    jit_node_t		*nS19_45;
    /* Declare signed bitfields at offset 20 */
    S20_13		 pS20_13;
    jit_node_t		*nS20_13;
    S20_14		 pS20_14;
    jit_node_t		*nS20_14;
    S20_15		 pS20_15;
    jit_node_t		*nS20_15;
    S20_16		 pS20_16;
    jit_node_t		*nS20_16;
    S20_17		 pS20_17;
    jit_node_t		*nS20_17;
    S20_18		 pS20_18;
    jit_node_t		*nS20_18;
    S20_19		 pS20_19;
    jit_node_t		*nS20_19;
    S20_20		 pS20_20;
    jit_node_t		*nS20_20;
    S20_21		 pS20_21;
    jit_node_t		*nS20_21;
    S20_22		 pS20_22;
    jit_node_t		*nS20_22;
    S20_23		 pS20_23;
    jit_node_t		*nS20_23;
    S20_24		 pS20_24;
    jit_node_t		*nS20_24;
    S20_25		 pS20_25;
    jit_node_t		*nS20_25;
    S20_26		 pS20_26;
    jit_node_t		*nS20_26;
    S20_27		 pS20_27;
    jit_node_t		*nS20_27;
    S20_28		 pS20_28;
    jit_node_t		*nS20_28;
    S20_29		 pS20_29;
    jit_node_t		*nS20_29;
    S20_30		 pS20_30;
    jit_node_t		*nS20_30;
    S20_31		 pS20_31;
    jit_node_t		*nS20_31;
    S20_32		 pS20_32;
    jit_node_t		*nS20_32;
    S20_33		 pS20_33;
    jit_node_t		*nS20_33;
    S20_34		 pS20_34;
    jit_node_t		*nS20_34;
    S20_35		 pS20_35;
    jit_node_t		*nS20_35;
    S20_36		 pS20_36;
    jit_node_t		*nS20_36;
    S20_37		 pS20_37;
    jit_node_t		*nS20_37;
    S20_38		 pS20_38;
    jit_node_t		*nS20_38;
    S20_39		 pS20_39;
    jit_node_t		*nS20_39;
    S20_40		 pS20_40;
    jit_node_t		*nS20_40;
    S20_41		 pS20_41;
    jit_node_t		*nS20_41;
    S20_42		 pS20_42;
    jit_node_t		*nS20_42;
    S20_43		 pS20_43;
    jit_node_t		*nS20_43;
    S20_44		 pS20_44;
    jit_node_t		*nS20_44;
    /* Declare signed bitfields at offset 21 */
    S21_12		 pS21_12;
    jit_node_t		*nS21_12;
    S21_13		 pS21_13;
    jit_node_t		*nS21_13;
    S21_14		 pS21_14;
    jit_node_t		*nS21_14;
    S21_15		 pS21_15;
    jit_node_t		*nS21_15;
    S21_16		 pS21_16;
    jit_node_t		*nS21_16;
    S21_17		 pS21_17;
    jit_node_t		*nS21_17;
    S21_18		 pS21_18;
    jit_node_t		*nS21_18;
    S21_19		 pS21_19;
    jit_node_t		*nS21_19;
    S21_20		 pS21_20;
    jit_node_t		*nS21_20;
    S21_21		 pS21_21;
    jit_node_t		*nS21_21;
    S21_22		 pS21_22;
    jit_node_t		*nS21_22;
    S21_23		 pS21_23;
    jit_node_t		*nS21_23;
    S21_24		 pS21_24;
    jit_node_t		*nS21_24;
    S21_25		 pS21_25;
    jit_node_t		*nS21_25;
    S21_26		 pS21_26;
    jit_node_t		*nS21_26;
    S21_27		 pS21_27;
    jit_node_t		*nS21_27;
    S21_28		 pS21_28;
    jit_node_t		*nS21_28;
    S21_29		 pS21_29;
    jit_node_t		*nS21_29;
    S21_30		 pS21_30;
    jit_node_t		*nS21_30;
    S21_31		 pS21_31;
    jit_node_t		*nS21_31;
    S21_32		 pS21_32;
    jit_node_t		*nS21_32;
    S21_33		 pS21_33;
    jit_node_t		*nS21_33;
    S21_34		 pS21_34;
    jit_node_t		*nS21_34;
    S21_35		 pS21_35;
    jit_node_t		*nS21_35;
    S21_36		 pS21_36;
    jit_node_t		*nS21_36;
    S21_37		 pS21_37;
    jit_node_t		*nS21_37;
    S21_38		 pS21_38;
    jit_node_t		*nS21_38;
    S21_39		 pS21_39;
    jit_node_t		*nS21_39;
    S21_40		 pS21_40;
    jit_node_t		*nS21_40;
    S21_41		 pS21_41;
    jit_node_t		*nS21_41;
    S21_42		 pS21_42;
    jit_node_t		*nS21_42;
    S21_43		 pS21_43;
    jit_node_t		*nS21_43;
    /* Declare signed bitfields at offset 22 */
    S22_11		 pS22_11;
    jit_node_t		*nS22_11;
    S22_12		 pS22_12;
    jit_node_t		*nS22_12;
    S22_13		 pS22_13;
    jit_node_t		*nS22_13;
    S22_14		 pS22_14;
    jit_node_t		*nS22_14;
    S22_15		 pS22_15;
    jit_node_t		*nS22_15;
    S22_16		 pS22_16;
    jit_node_t		*nS22_16;
    S22_17		 pS22_17;
    jit_node_t		*nS22_17;
    S22_18		 pS22_18;
    jit_node_t		*nS22_18;
    S22_19		 pS22_19;
    jit_node_t		*nS22_19;
    S22_20		 pS22_20;
    jit_node_t		*nS22_20;
    S22_21		 pS22_21;
    jit_node_t		*nS22_21;
    S22_22		 pS22_22;
    jit_node_t		*nS22_22;
    S22_23		 pS22_23;
    jit_node_t		*nS22_23;
    S22_24		 pS22_24;
    jit_node_t		*nS22_24;
    S22_25		 pS22_25;
    jit_node_t		*nS22_25;
    S22_26		 pS22_26;
    jit_node_t		*nS22_26;
    S22_27		 pS22_27;
    jit_node_t		*nS22_27;
    S22_28		 pS22_28;
    jit_node_t		*nS22_28;
    S22_29		 pS22_29;
    jit_node_t		*nS22_29;
    S22_30		 pS22_30;
    jit_node_t		*nS22_30;
    S22_31		 pS22_31;
    jit_node_t		*nS22_31;
    S22_32		 pS22_32;
    jit_node_t		*nS22_32;
    S22_33		 pS22_33;
    jit_node_t		*nS22_33;
    S22_34		 pS22_34;
    jit_node_t		*nS22_34;
    S22_35		 pS22_35;
    jit_node_t		*nS22_35;
    S22_36		 pS22_36;
    jit_node_t		*nS22_36;
    S22_37		 pS22_37;
    jit_node_t		*nS22_37;
    S22_38		 pS22_38;
    jit_node_t		*nS22_38;
    S22_39		 pS22_39;
    jit_node_t		*nS22_39;
    S22_40		 pS22_40;
    jit_node_t		*nS22_40;
    S22_41		 pS22_41;
    jit_node_t		*nS22_41;
    S22_42		 pS22_42;
    jit_node_t		*nS22_42;
    /* Declare signed bitfields at offset 23 */
    S23_10		 pS23_10;
    jit_node_t		*nS23_10;
    S23_11		 pS23_11;
    jit_node_t		*nS23_11;
    S23_12		 pS23_12;
    jit_node_t		*nS23_12;
    S23_13		 pS23_13;
    jit_node_t		*nS23_13;
    S23_14		 pS23_14;
    jit_node_t		*nS23_14;
    S23_15		 pS23_15;
    jit_node_t		*nS23_15;
    S23_16		 pS23_16;
    jit_node_t		*nS23_16;
    S23_17		 pS23_17;
    jit_node_t		*nS23_17;
    S23_18		 pS23_18;
    jit_node_t		*nS23_18;
    S23_19		 pS23_19;
    jit_node_t		*nS23_19;
    S23_20		 pS23_20;
    jit_node_t		*nS23_20;
    S23_21		 pS23_21;
    jit_node_t		*nS23_21;
    S23_22		 pS23_22;
    jit_node_t		*nS23_22;
    S23_23		 pS23_23;
    jit_node_t		*nS23_23;
    S23_24		 pS23_24;
    jit_node_t		*nS23_24;
    S23_25		 pS23_25;
    jit_node_t		*nS23_25;
    S23_26		 pS23_26;
    jit_node_t		*nS23_26;
    S23_27		 pS23_27;
    jit_node_t		*nS23_27;
    S23_28		 pS23_28;
    jit_node_t		*nS23_28;
    S23_29		 pS23_29;
    jit_node_t		*nS23_29;
    S23_30		 pS23_30;
    jit_node_t		*nS23_30;
    S23_31		 pS23_31;
    jit_node_t		*nS23_31;
    S23_32		 pS23_32;
    jit_node_t		*nS23_32;
    S23_33		 pS23_33;
    jit_node_t		*nS23_33;
    S23_34		 pS23_34;
    jit_node_t		*nS23_34;
    S23_35		 pS23_35;
    jit_node_t		*nS23_35;
    S23_36		 pS23_36;
    jit_node_t		*nS23_36;
    S23_37		 pS23_37;
    jit_node_t		*nS23_37;
    S23_38		 pS23_38;
    jit_node_t		*nS23_38;
    S23_39		 pS23_39;
    jit_node_t		*nS23_39;
    S23_40		 pS23_40;
    jit_node_t		*nS23_40;
    S23_41		 pS23_41;
    jit_node_t		*nS23_41;
    /* Declare signed bitfields at offset 24 */
    S24_9		 pS24_9;
    jit_node_t		*nS24_9;
    S24_10		 pS24_10;
    jit_node_t		*nS24_10;
    S24_11		 pS24_11;
    jit_node_t		*nS24_11;
    S24_12		 pS24_12;
    jit_node_t		*nS24_12;
    S24_13		 pS24_13;
    jit_node_t		*nS24_13;
    S24_14		 pS24_14;
    jit_node_t		*nS24_14;
    S24_15		 pS24_15;
    jit_node_t		*nS24_15;
    S24_16		 pS24_16;
    jit_node_t		*nS24_16;
    S24_17		 pS24_17;
    jit_node_t		*nS24_17;
    S24_18		 pS24_18;
    jit_node_t		*nS24_18;
    S24_19		 pS24_19;
    jit_node_t		*nS24_19;
    S24_20		 pS24_20;
    jit_node_t		*nS24_20;
    S24_21		 pS24_21;
    jit_node_t		*nS24_21;
    S24_22		 pS24_22;
    jit_node_t		*nS24_22;
    S24_23		 pS24_23;
    jit_node_t		*nS24_23;
    S24_24		 pS24_24;
    jit_node_t		*nS24_24;
    S24_25		 pS24_25;
    jit_node_t		*nS24_25;
    S24_26		 pS24_26;
    jit_node_t		*nS24_26;
    S24_27		 pS24_27;
    jit_node_t		*nS24_27;
    S24_28		 pS24_28;
    jit_node_t		*nS24_28;
    S24_29		 pS24_29;
    jit_node_t		*nS24_29;
    S24_30		 pS24_30;
    jit_node_t		*nS24_30;
    S24_31		 pS24_31;
    jit_node_t		*nS24_31;
    S24_32		 pS24_32;
    jit_node_t		*nS24_32;
    S24_33		 pS24_33;
    jit_node_t		*nS24_33;
    S24_34		 pS24_34;
    jit_node_t		*nS24_34;
    S24_35		 pS24_35;
    jit_node_t		*nS24_35;
    S24_36		 pS24_36;
    jit_node_t		*nS24_36;
    S24_37		 pS24_37;
    jit_node_t		*nS24_37;
    S24_38		 pS24_38;
    jit_node_t		*nS24_38;
    S24_39		 pS24_39;
    jit_node_t		*nS24_39;
    S24_40		 pS24_40;
    jit_node_t		*nS24_40;
    /* Declare signed bitfields at offset 25 */
    S25_8		 pS25_8;
    jit_node_t		*nS25_8;
    S25_9		 pS25_9;
    jit_node_t		*nS25_9;
    S25_10		 pS25_10;
    jit_node_t		*nS25_10;
    S25_11		 pS25_11;
    jit_node_t		*nS25_11;
    S25_12		 pS25_12;
    jit_node_t		*nS25_12;
    S25_13		 pS25_13;
    jit_node_t		*nS25_13;
    S25_14		 pS25_14;
    jit_node_t		*nS25_14;
    S25_15		 pS25_15;
    jit_node_t		*nS25_15;
    S25_16		 pS25_16;
    jit_node_t		*nS25_16;
    S25_17		 pS25_17;
    jit_node_t		*nS25_17;
    S25_18		 pS25_18;
    jit_node_t		*nS25_18;
    S25_19		 pS25_19;
    jit_node_t		*nS25_19;
    S25_20		 pS25_20;
    jit_node_t		*nS25_20;
    S25_21		 pS25_21;
    jit_node_t		*nS25_21;
    S25_22		 pS25_22;
    jit_node_t		*nS25_22;
    S25_23		 pS25_23;
    jit_node_t		*nS25_23;
    S25_24		 pS25_24;
    jit_node_t		*nS25_24;
    S25_25		 pS25_25;
    jit_node_t		*nS25_25;
    S25_26		 pS25_26;
    jit_node_t		*nS25_26;
    S25_27		 pS25_27;
    jit_node_t		*nS25_27;
    S25_28		 pS25_28;
    jit_node_t		*nS25_28;
    S25_29		 pS25_29;
    jit_node_t		*nS25_29;
    S25_30		 pS25_30;
    jit_node_t		*nS25_30;
    S25_31		 pS25_31;
    jit_node_t		*nS25_31;
    S25_32		 pS25_32;
    jit_node_t		*nS25_32;
    S25_33		 pS25_33;
    jit_node_t		*nS25_33;
    S25_34		 pS25_34;
    jit_node_t		*nS25_34;
    S25_35		 pS25_35;
    jit_node_t		*nS25_35;
    S25_36		 pS25_36;
    jit_node_t		*nS25_36;
    S25_37		 pS25_37;
    jit_node_t		*nS25_37;
    S25_38		 pS25_38;
    jit_node_t		*nS25_38;
    S25_39		 pS25_39;
    jit_node_t		*nS25_39;
    /* Declare signed bitfields at offset 26 */
    S26_7		 pS26_7;
    jit_node_t		*nS26_7;
    S26_8		 pS26_8;
    jit_node_t		*nS26_8;
    S26_9		 pS26_9;
    jit_node_t		*nS26_9;
    S26_10		 pS26_10;
    jit_node_t		*nS26_10;
    S26_11		 pS26_11;
    jit_node_t		*nS26_11;
    S26_12		 pS26_12;
    jit_node_t		*nS26_12;
    S26_13		 pS26_13;
    jit_node_t		*nS26_13;
    S26_14		 pS26_14;
    jit_node_t		*nS26_14;
    S26_15		 pS26_15;
    jit_node_t		*nS26_15;
    S26_16		 pS26_16;
    jit_node_t		*nS26_16;
    S26_17		 pS26_17;
    jit_node_t		*nS26_17;
    S26_18		 pS26_18;
    jit_node_t		*nS26_18;
    S26_19		 pS26_19;
    jit_node_t		*nS26_19;
    S26_20		 pS26_20;
    jit_node_t		*nS26_20;
    S26_21		 pS26_21;
    jit_node_t		*nS26_21;
    S26_22		 pS26_22;
    jit_node_t		*nS26_22;
    S26_23		 pS26_23;
    jit_node_t		*nS26_23;
    S26_24		 pS26_24;
    jit_node_t		*nS26_24;
    S26_25		 pS26_25;
    jit_node_t		*nS26_25;
    S26_26		 pS26_26;
    jit_node_t		*nS26_26;
    S26_27		 pS26_27;
    jit_node_t		*nS26_27;
    S26_28		 pS26_28;
    jit_node_t		*nS26_28;
    S26_29		 pS26_29;
    jit_node_t		*nS26_29;
    S26_30		 pS26_30;
    jit_node_t		*nS26_30;
    S26_31		 pS26_31;
    jit_node_t		*nS26_31;
    S26_32		 pS26_32;
    jit_node_t		*nS26_32;
    S26_33		 pS26_33;
    jit_node_t		*nS26_33;
    S26_34		 pS26_34;
    jit_node_t		*nS26_34;
    S26_35		 pS26_35;
    jit_node_t		*nS26_35;
    S26_36		 pS26_36;
    jit_node_t		*nS26_36;
    S26_37		 pS26_37;
    jit_node_t		*nS26_37;
    S26_38		 pS26_38;
    jit_node_t		*nS26_38;
    /* Declare signed bitfields at offset 27 */
    S27_6		 pS27_6;
    jit_node_t		*nS27_6;
    S27_7		 pS27_7;
    jit_node_t		*nS27_7;
    S27_8		 pS27_8;
    jit_node_t		*nS27_8;
    S27_9		 pS27_9;
    jit_node_t		*nS27_9;
    S27_10		 pS27_10;
    jit_node_t		*nS27_10;
    S27_11		 pS27_11;
    jit_node_t		*nS27_11;
    S27_12		 pS27_12;
    jit_node_t		*nS27_12;
    S27_13		 pS27_13;
    jit_node_t		*nS27_13;
    S27_14		 pS27_14;
    jit_node_t		*nS27_14;
    S27_15		 pS27_15;
    jit_node_t		*nS27_15;
    S27_16		 pS27_16;
    jit_node_t		*nS27_16;
    S27_17		 pS27_17;
    jit_node_t		*nS27_17;
    S27_18		 pS27_18;
    jit_node_t		*nS27_18;
    S27_19		 pS27_19;
    jit_node_t		*nS27_19;
    S27_20		 pS27_20;
    jit_node_t		*nS27_20;
    S27_21		 pS27_21;
    jit_node_t		*nS27_21;
    S27_22		 pS27_22;
    jit_node_t		*nS27_22;
    S27_23		 pS27_23;
    jit_node_t		*nS27_23;
    S27_24		 pS27_24;
    jit_node_t		*nS27_24;
    S27_25		 pS27_25;
    jit_node_t		*nS27_25;
    S27_26		 pS27_26;
    jit_node_t		*nS27_26;
    S27_27		 pS27_27;
    jit_node_t		*nS27_27;
    S27_28		 pS27_28;
    jit_node_t		*nS27_28;
    S27_29		 pS27_29;
    jit_node_t		*nS27_29;
    S27_30		 pS27_30;
    jit_node_t		*nS27_30;
    S27_31		 pS27_31;
    jit_node_t		*nS27_31;
    S27_32		 pS27_32;
    jit_node_t		*nS27_32;
    S27_33		 pS27_33;
    jit_node_t		*nS27_33;
    S27_34		 pS27_34;
    jit_node_t		*nS27_34;
    S27_35		 pS27_35;
    jit_node_t		*nS27_35;
    S27_36		 pS27_36;
    jit_node_t		*nS27_36;
    S27_37		 pS27_37;
    jit_node_t		*nS27_37;
    /* Declare signed bitfields at offset 28 */
    S28_5		 pS28_5;
    jit_node_t		*nS28_5;
    S28_6		 pS28_6;
    jit_node_t		*nS28_6;
    S28_7		 pS28_7;
    jit_node_t		*nS28_7;
    S28_8		 pS28_8;
    jit_node_t		*nS28_8;
    S28_9		 pS28_9;
    jit_node_t		*nS28_9;
    S28_10		 pS28_10;
    jit_node_t		*nS28_10;
    S28_11		 pS28_11;
    jit_node_t		*nS28_11;
    S28_12		 pS28_12;
    jit_node_t		*nS28_12;
    S28_13		 pS28_13;
    jit_node_t		*nS28_13;
    S28_14		 pS28_14;
    jit_node_t		*nS28_14;
    S28_15		 pS28_15;
    jit_node_t		*nS28_15;
    S28_16		 pS28_16;
    jit_node_t		*nS28_16;
    S28_17		 pS28_17;
    jit_node_t		*nS28_17;
    S28_18		 pS28_18;
    jit_node_t		*nS28_18;
    S28_19		 pS28_19;
    jit_node_t		*nS28_19;
    S28_20		 pS28_20;
    jit_node_t		*nS28_20;
    S28_21		 pS28_21;
    jit_node_t		*nS28_21;
    S28_22		 pS28_22;
    jit_node_t		*nS28_22;
    S28_23		 pS28_23;
    jit_node_t		*nS28_23;
    S28_24		 pS28_24;
    jit_node_t		*nS28_24;
    S28_25		 pS28_25;
    jit_node_t		*nS28_25;
    S28_26		 pS28_26;
    jit_node_t		*nS28_26;
    S28_27		 pS28_27;
    jit_node_t		*nS28_27;
    S28_28		 pS28_28;
    jit_node_t		*nS28_28;
    S28_29		 pS28_29;
    jit_node_t		*nS28_29;
    S28_30		 pS28_30;
    jit_node_t		*nS28_30;
    S28_31		 pS28_31;
    jit_node_t		*nS28_31;
    S28_32		 pS28_32;
    jit_node_t		*nS28_32;
    S28_33		 pS28_33;
    jit_node_t		*nS28_33;
    S28_34		 pS28_34;
    jit_node_t		*nS28_34;
    S28_35		 pS28_35;
    jit_node_t		*nS28_35;
    S28_36		 pS28_36;
    jit_node_t		*nS28_36;
    /* Declare signed bitfields at offset 29 */
    S29_4		 pS29_4;
    jit_node_t		*nS29_4;
    S29_5		 pS29_5;
    jit_node_t		*nS29_5;
    S29_6		 pS29_6;
    jit_node_t		*nS29_6;
    S29_7		 pS29_7;
    jit_node_t		*nS29_7;
    S29_8		 pS29_8;
    jit_node_t		*nS29_8;
    S29_9		 pS29_9;
    jit_node_t		*nS29_9;
    S29_10		 pS29_10;
    jit_node_t		*nS29_10;
    S29_11		 pS29_11;
    jit_node_t		*nS29_11;
    S29_12		 pS29_12;
    jit_node_t		*nS29_12;
    S29_13		 pS29_13;
    jit_node_t		*nS29_13;
    S29_14		 pS29_14;
    jit_node_t		*nS29_14;
    S29_15		 pS29_15;
    jit_node_t		*nS29_15;
    S29_16		 pS29_16;
    jit_node_t		*nS29_16;
    S29_17		 pS29_17;
    jit_node_t		*nS29_17;
    S29_18		 pS29_18;
    jit_node_t		*nS29_18;
    S29_19		 pS29_19;
    jit_node_t		*nS29_19;
    S29_20		 pS29_20;
    jit_node_t		*nS29_20;
    S29_21		 pS29_21;
    jit_node_t		*nS29_21;
    S29_22		 pS29_22;
    jit_node_t		*nS29_22;
    S29_23		 pS29_23;
    jit_node_t		*nS29_23;
    S29_24		 pS29_24;
    jit_node_t		*nS29_24;
    S29_25		 pS29_25;
    jit_node_t		*nS29_25;
    S29_26		 pS29_26;
    jit_node_t		*nS29_26;
    S29_27		 pS29_27;
    jit_node_t		*nS29_27;
    S29_28		 pS29_28;
    jit_node_t		*nS29_28;
    S29_29		 pS29_29;
    jit_node_t		*nS29_29;
    S29_30		 pS29_30;
    jit_node_t		*nS29_30;
    S29_31		 pS29_31;
    jit_node_t		*nS29_31;
    S29_32		 pS29_32;
    jit_node_t		*nS29_32;
    S29_33		 pS29_33;
    jit_node_t		*nS29_33;
    S29_34		 pS29_34;
    jit_node_t		*nS29_34;
    S29_35		 pS29_35;
    jit_node_t		*nS29_35;
    /* Declare signed bitfields at offset 30 */
    S30_3		 pS30_3;
    jit_node_t		*nS30_3;
    S30_4		 pS30_4;
    jit_node_t		*nS30_4;
    S30_5		 pS30_5;
    jit_node_t		*nS30_5;
    S30_6		 pS30_6;
    jit_node_t		*nS30_6;
    S30_7		 pS30_7;
    jit_node_t		*nS30_7;
    S30_8		 pS30_8;
    jit_node_t		*nS30_8;
    S30_9		 pS30_9;
    jit_node_t		*nS30_9;
    S30_10		 pS30_10;
    jit_node_t		*nS30_10;
    S30_11		 pS30_11;
    jit_node_t		*nS30_11;
    S30_12		 pS30_12;
    jit_node_t		*nS30_12;
    S30_13		 pS30_13;
    jit_node_t		*nS30_13;
    S30_14		 pS30_14;
    jit_node_t		*nS30_14;
    S30_15		 pS30_15;
    jit_node_t		*nS30_15;
    S30_16		 pS30_16;
    jit_node_t		*nS30_16;
    S30_17		 pS30_17;
    jit_node_t		*nS30_17;
    S30_18		 pS30_18;
    jit_node_t		*nS30_18;
    S30_19		 pS30_19;
    jit_node_t		*nS30_19;
    S30_20		 pS30_20;
    jit_node_t		*nS30_20;
    S30_21		 pS30_21;
    jit_node_t		*nS30_21;
    S30_22		 pS30_22;
    jit_node_t		*nS30_22;
    S30_23		 pS30_23;
    jit_node_t		*nS30_23;
    S30_24		 pS30_24;
    jit_node_t		*nS30_24;
    S30_25		 pS30_25;
    jit_node_t		*nS30_25;
    S30_26		 pS30_26;
    jit_node_t		*nS30_26;
    S30_27		 pS30_27;
    jit_node_t		*nS30_27;
    S30_28		 pS30_28;
    jit_node_t		*nS30_28;
    S30_29		 pS30_29;
    jit_node_t		*nS30_29;
    S30_30		 pS30_30;
    jit_node_t		*nS30_30;
    S30_31		 pS30_31;
    jit_node_t		*nS30_31;
    S30_32		 pS30_32;
    jit_node_t		*nS30_32;
    S30_33		 pS30_33;
    jit_node_t		*nS30_33;
    S30_34		 pS30_34;
    jit_node_t		*nS30_34;
    /* Declare signed bitfields at offset 31 */
    S31_2		 pS31_2;
    jit_node_t		*nS31_2;
    S31_3		 pS31_3;
    jit_node_t		*nS31_3;
    S31_4		 pS31_4;
    jit_node_t		*nS31_4;
    S31_5		 pS31_5;
    jit_node_t		*nS31_5;
    S31_6		 pS31_6;
    jit_node_t		*nS31_6;
    S31_7		 pS31_7;
    jit_node_t		*nS31_7;
    S31_8		 pS31_8;
    jit_node_t		*nS31_8;
    S31_9		 pS31_9;
    jit_node_t		*nS31_9;
    S31_10		 pS31_10;
    jit_node_t		*nS31_10;
    S31_11		 pS31_11;
    jit_node_t		*nS31_11;
    S31_12		 pS31_12;
    jit_node_t		*nS31_12;
    S31_13		 pS31_13;
    jit_node_t		*nS31_13;
    S31_14		 pS31_14;
    jit_node_t		*nS31_14;
    S31_15		 pS31_15;
    jit_node_t		*nS31_15;
    S31_16		 pS31_16;
    jit_node_t		*nS31_16;
    S31_17		 pS31_17;
    jit_node_t		*nS31_17;
    S31_18		 pS31_18;
    jit_node_t		*nS31_18;
    S31_19		 pS31_19;
    jit_node_t		*nS31_19;
    S31_20		 pS31_20;
    jit_node_t		*nS31_20;
    S31_21		 pS31_21;
    jit_node_t		*nS31_21;
    S31_22		 pS31_22;
    jit_node_t		*nS31_22;
    S31_23		 pS31_23;
    jit_node_t		*nS31_23;
    S31_24		 pS31_24;
    jit_node_t		*nS31_24;
    S31_25		 pS31_25;
    jit_node_t		*nS31_25;
    S31_26		 pS31_26;
    jit_node_t		*nS31_26;
    S31_27		 pS31_27;
    jit_node_t		*nS31_27;
    S31_28		 pS31_28;
    jit_node_t		*nS31_28;
    S31_29		 pS31_29;
    jit_node_t		*nS31_29;
    S31_30		 pS31_30;
    jit_node_t		*nS31_30;
    S31_31		 pS31_31;
    jit_node_t		*nS31_31;
    S31_32		 pS31_32;
    jit_node_t		*nS31_32;
    S31_33		 pS31_33;
    jit_node_t		*nS31_33;
    /* Declare signed bitfields at offset 32 */
    S32_1		 pS32_1;
    jit_node_t		*nS32_1;
    S32_2		 pS32_2;
    jit_node_t		*nS32_2;
    S32_3		 pS32_3;
    jit_node_t		*nS32_3;
    S32_4		 pS32_4;
    jit_node_t		*nS32_4;
    S32_5		 pS32_5;
    jit_node_t		*nS32_5;
    S32_6		 pS32_6;
    jit_node_t		*nS32_6;
    S32_7		 pS32_7;
    jit_node_t		*nS32_7;
    S32_8		 pS32_8;
    jit_node_t		*nS32_8;
    S32_9		 pS32_9;
    jit_node_t		*nS32_9;
    S32_10		 pS32_10;
    jit_node_t		*nS32_10;
    S32_11		 pS32_11;
    jit_node_t		*nS32_11;
    S32_12		 pS32_12;
    jit_node_t		*nS32_12;
    S32_13		 pS32_13;
    jit_node_t		*nS32_13;
    S32_14		 pS32_14;
    jit_node_t		*nS32_14;
    S32_15		 pS32_15;
    jit_node_t		*nS32_15;
    S32_16		 pS32_16;
    jit_node_t		*nS32_16;
    S32_17		 pS32_17;
    jit_node_t		*nS32_17;
    S32_18		 pS32_18;
    jit_node_t		*nS32_18;
    S32_19		 pS32_19;
    jit_node_t		*nS32_19;
    S32_20		 pS32_20;
    jit_node_t		*nS32_20;
    S32_21		 pS32_21;
    jit_node_t		*nS32_21;
    S32_22		 pS32_22;
    jit_node_t		*nS32_22;
    S32_23		 pS32_23;
    jit_node_t		*nS32_23;
    S32_24		 pS32_24;
    jit_node_t		*nS32_24;
    S32_25		 pS32_25;
    jit_node_t		*nS32_25;
    S32_26		 pS32_26;
    jit_node_t		*nS32_26;
    S32_27		 pS32_27;
    jit_node_t		*nS32_27;
    S32_28		 pS32_28;
    jit_node_t		*nS32_28;
    S32_29		 pS32_29;
    jit_node_t		*nS32_29;
    S32_30		 pS32_30;
    jit_node_t		*nS32_30;
    S32_31		 pS32_31;
    jit_node_t		*nS32_31;
    S32_32		 pS32_32;
    jit_node_t		*nS32_32;
    /* Declare signed bitfields at offset 33 */
    S33_1		 pS33_1;
    jit_node_t		*nS33_1;
    S33_2		 pS33_2;
    jit_node_t		*nS33_2;
    S33_3		 pS33_3;
    jit_node_t		*nS33_3;
    S33_4		 pS33_4;
    jit_node_t		*nS33_4;
    S33_5		 pS33_5;
    jit_node_t		*nS33_5;
    S33_6		 pS33_6;
    jit_node_t		*nS33_6;
    S33_7		 pS33_7;
    jit_node_t		*nS33_7;
    S33_8		 pS33_8;
    jit_node_t		*nS33_8;
    S33_9		 pS33_9;
    jit_node_t		*nS33_9;
    S33_10		 pS33_10;
    jit_node_t		*nS33_10;
    S33_11		 pS33_11;
    jit_node_t		*nS33_11;
    S33_12		 pS33_12;
    jit_node_t		*nS33_12;
    S33_13		 pS33_13;
    jit_node_t		*nS33_13;
    S33_14		 pS33_14;
    jit_node_t		*nS33_14;
    S33_15		 pS33_15;
    jit_node_t		*nS33_15;
    S33_16		 pS33_16;
    jit_node_t		*nS33_16;
    S33_17		 pS33_17;
    jit_node_t		*nS33_17;
    S33_18		 pS33_18;
    jit_node_t		*nS33_18;
    S33_19		 pS33_19;
    jit_node_t		*nS33_19;
    S33_20		 pS33_20;
    jit_node_t		*nS33_20;
    S33_21		 pS33_21;
    jit_node_t		*nS33_21;
    S33_22		 pS33_22;
    jit_node_t		*nS33_22;
    S33_23		 pS33_23;
    jit_node_t		*nS33_23;
    S33_24		 pS33_24;
    jit_node_t		*nS33_24;
    S33_25		 pS33_25;
    jit_node_t		*nS33_25;
    S33_26		 pS33_26;
    jit_node_t		*nS33_26;
    S33_27		 pS33_27;
    jit_node_t		*nS33_27;
    S33_28		 pS33_28;
    jit_node_t		*nS33_28;
    S33_29		 pS33_29;
    jit_node_t		*nS33_29;
    S33_30		 pS33_30;
    jit_node_t		*nS33_30;
    S33_31		 pS33_31;
    jit_node_t		*nS33_31;
    /* Declare signed bitfields at offset 34 */
    S34_1		 pS34_1;
    jit_node_t		*nS34_1;
    S34_2		 pS34_2;
    jit_node_t		*nS34_2;
    S34_3		 pS34_3;
    jit_node_t		*nS34_3;
    S34_4		 pS34_4;
    jit_node_t		*nS34_4;
    S34_5		 pS34_5;
    jit_node_t		*nS34_5;
    S34_6		 pS34_6;
    jit_node_t		*nS34_6;
    S34_7		 pS34_7;
    jit_node_t		*nS34_7;
    S34_8		 pS34_8;
    jit_node_t		*nS34_8;
    S34_9		 pS34_9;
    jit_node_t		*nS34_9;
    S34_10		 pS34_10;
    jit_node_t		*nS34_10;
    S34_11		 pS34_11;
    jit_node_t		*nS34_11;
    S34_12		 pS34_12;
    jit_node_t		*nS34_12;
    S34_13		 pS34_13;
    jit_node_t		*nS34_13;
    S34_14		 pS34_14;
    jit_node_t		*nS34_14;
    S34_15		 pS34_15;
    jit_node_t		*nS34_15;
    S34_16		 pS34_16;
    jit_node_t		*nS34_16;
    S34_17		 pS34_17;
    jit_node_t		*nS34_17;
    S34_18		 pS34_18;
    jit_node_t		*nS34_18;
    S34_19		 pS34_19;
    jit_node_t		*nS34_19;
    S34_20		 pS34_20;
    jit_node_t		*nS34_20;
    S34_21		 pS34_21;
    jit_node_t		*nS34_21;
    S34_22		 pS34_22;
    jit_node_t		*nS34_22;
    S34_23		 pS34_23;
    jit_node_t		*nS34_23;
    S34_24		 pS34_24;
    jit_node_t		*nS34_24;
    S34_25		 pS34_25;
    jit_node_t		*nS34_25;
    S34_26		 pS34_26;
    jit_node_t		*nS34_26;
    S34_27		 pS34_27;
    jit_node_t		*nS34_27;
    S34_28		 pS34_28;
    jit_node_t		*nS34_28;
    S34_29		 pS34_29;
    jit_node_t		*nS34_29;
    S34_30		 pS34_30;
    jit_node_t		*nS34_30;
    /* Declare signed bitfields at offset 35 */
    S35_1		 pS35_1;
    jit_node_t		*nS35_1;
    S35_2		 pS35_2;
    jit_node_t		*nS35_2;
    S35_3		 pS35_3;
    jit_node_t		*nS35_3;
    S35_4		 pS35_4;
    jit_node_t		*nS35_4;
    S35_5		 pS35_5;
    jit_node_t		*nS35_5;
    S35_6		 pS35_6;
    jit_node_t		*nS35_6;
    S35_7		 pS35_7;
    jit_node_t		*nS35_7;
    S35_8		 pS35_8;
    jit_node_t		*nS35_8;
    S35_9		 pS35_9;
    jit_node_t		*nS35_9;
    S35_10		 pS35_10;
    jit_node_t		*nS35_10;
    S35_11		 pS35_11;
    jit_node_t		*nS35_11;
    S35_12		 pS35_12;
    jit_node_t		*nS35_12;
    S35_13		 pS35_13;
    jit_node_t		*nS35_13;
    S35_14		 pS35_14;
    jit_node_t		*nS35_14;
    S35_15		 pS35_15;
    jit_node_t		*nS35_15;
    S35_16		 pS35_16;
    jit_node_t		*nS35_16;
    S35_17		 pS35_17;
    jit_node_t		*nS35_17;
    S35_18		 pS35_18;
    jit_node_t		*nS35_18;
    S35_19		 pS35_19;
    jit_node_t		*nS35_19;
    S35_20		 pS35_20;
    jit_node_t		*nS35_20;
    S35_21		 pS35_21;
    jit_node_t		*nS35_21;
    S35_22		 pS35_22;
    jit_node_t		*nS35_22;
    S35_23		 pS35_23;
    jit_node_t		*nS35_23;
    S35_24		 pS35_24;
    jit_node_t		*nS35_24;
    S35_25		 pS35_25;
    jit_node_t		*nS35_25;
    S35_26		 pS35_26;
    jit_node_t		*nS35_26;
    S35_27		 pS35_27;
    jit_node_t		*nS35_27;
    S35_28		 pS35_28;
    jit_node_t		*nS35_28;
    S35_29		 pS35_29;
    jit_node_t		*nS35_29;
    /* Declare signed bitfields at offset 36 */
    S36_1		 pS36_1;
    jit_node_t		*nS36_1;
    S36_2		 pS36_2;
    jit_node_t		*nS36_2;
    S36_3		 pS36_3;
    jit_node_t		*nS36_3;
    S36_4		 pS36_4;
    jit_node_t		*nS36_4;
    S36_5		 pS36_5;
    jit_node_t		*nS36_5;
    S36_6		 pS36_6;
    jit_node_t		*nS36_6;
    S36_7		 pS36_7;
    jit_node_t		*nS36_7;
    S36_8		 pS36_8;
    jit_node_t		*nS36_8;
    S36_9		 pS36_9;
    jit_node_t		*nS36_9;
    S36_10		 pS36_10;
    jit_node_t		*nS36_10;
    S36_11		 pS36_11;
    jit_node_t		*nS36_11;
    S36_12		 pS36_12;
    jit_node_t		*nS36_12;
    S36_13		 pS36_13;
    jit_node_t		*nS36_13;
    S36_14		 pS36_14;
    jit_node_t		*nS36_14;
    S36_15		 pS36_15;
    jit_node_t		*nS36_15;
    S36_16		 pS36_16;
    jit_node_t		*nS36_16;
    S36_17		 pS36_17;
    jit_node_t		*nS36_17;
    S36_18		 pS36_18;
    jit_node_t		*nS36_18;
    S36_19		 pS36_19;
    jit_node_t		*nS36_19;
    S36_20		 pS36_20;
    jit_node_t		*nS36_20;
    S36_21		 pS36_21;
    jit_node_t		*nS36_21;
    S36_22		 pS36_22;
    jit_node_t		*nS36_22;
    S36_23		 pS36_23;
    jit_node_t		*nS36_23;
    S36_24		 pS36_24;
    jit_node_t		*nS36_24;
    S36_25		 pS36_25;
    jit_node_t		*nS36_25;
    S36_26		 pS36_26;
    jit_node_t		*nS36_26;
    S36_27		 pS36_27;
    jit_node_t		*nS36_27;
    S36_28		 pS36_28;
    jit_node_t		*nS36_28;
    /* Declare signed bitfields at offset 37 */
    S37_1		 pS37_1;
    jit_node_t		*nS37_1;
    S37_2		 pS37_2;
    jit_node_t		*nS37_2;
    S37_3		 pS37_3;
    jit_node_t		*nS37_3;
    S37_4		 pS37_4;
    jit_node_t		*nS37_4;
    S37_5		 pS37_5;
    jit_node_t		*nS37_5;
    S37_6		 pS37_6;
    jit_node_t		*nS37_6;
    S37_7		 pS37_7;
    jit_node_t		*nS37_7;
    S37_8		 pS37_8;
    jit_node_t		*nS37_8;
    S37_9		 pS37_9;
    jit_node_t		*nS37_9;
    S37_10		 pS37_10;
    jit_node_t		*nS37_10;
    S37_11		 pS37_11;
    jit_node_t		*nS37_11;
    S37_12		 pS37_12;
    jit_node_t		*nS37_12;
    S37_13		 pS37_13;
    jit_node_t		*nS37_13;
    S37_14		 pS37_14;
    jit_node_t		*nS37_14;
    S37_15		 pS37_15;
    jit_node_t		*nS37_15;
    S37_16		 pS37_16;
    jit_node_t		*nS37_16;
    S37_17		 pS37_17;
    jit_node_t		*nS37_17;
    S37_18		 pS37_18;
    jit_node_t		*nS37_18;
    S37_19		 pS37_19;
    jit_node_t		*nS37_19;
    S37_20		 pS37_20;
    jit_node_t		*nS37_20;
    S37_21		 pS37_21;
    jit_node_t		*nS37_21;
    S37_22		 pS37_22;
    jit_node_t		*nS37_22;
    S37_23		 pS37_23;
    jit_node_t		*nS37_23;
    S37_24		 pS37_24;
    jit_node_t		*nS37_24;
    S37_25		 pS37_25;
    jit_node_t		*nS37_25;
    S37_26		 pS37_26;
    jit_node_t		*nS37_26;
    S37_27		 pS37_27;
    jit_node_t		*nS37_27;
    /* Declare signed bitfields at offset 38 */
    S38_1		 pS38_1;
    jit_node_t		*nS38_1;
    S38_2		 pS38_2;
    jit_node_t		*nS38_2;
    S38_3		 pS38_3;
    jit_node_t		*nS38_3;
    S38_4		 pS38_4;
    jit_node_t		*nS38_4;
    S38_5		 pS38_5;
    jit_node_t		*nS38_5;
    S38_6		 pS38_6;
    jit_node_t		*nS38_6;
    S38_7		 pS38_7;
    jit_node_t		*nS38_7;
    S38_8		 pS38_8;
    jit_node_t		*nS38_8;
    S38_9		 pS38_9;
    jit_node_t		*nS38_9;
    S38_10		 pS38_10;
    jit_node_t		*nS38_10;
    S38_11		 pS38_11;
    jit_node_t		*nS38_11;
    S38_12		 pS38_12;
    jit_node_t		*nS38_12;
    S38_13		 pS38_13;
    jit_node_t		*nS38_13;
    S38_14		 pS38_14;
    jit_node_t		*nS38_14;
    S38_15		 pS38_15;
    jit_node_t		*nS38_15;
    S38_16		 pS38_16;
    jit_node_t		*nS38_16;
    S38_17		 pS38_17;
    jit_node_t		*nS38_17;
    S38_18		 pS38_18;
    jit_node_t		*nS38_18;
    S38_19		 pS38_19;
    jit_node_t		*nS38_19;
    S38_20		 pS38_20;
    jit_node_t		*nS38_20;
    S38_21		 pS38_21;
    jit_node_t		*nS38_21;
    S38_22		 pS38_22;
    jit_node_t		*nS38_22;
    S38_23		 pS38_23;
    jit_node_t		*nS38_23;
    S38_24		 pS38_24;
    jit_node_t		*nS38_24;
    S38_25		 pS38_25;
    jit_node_t		*nS38_25;
    S38_26		 pS38_26;
    jit_node_t		*nS38_26;
    /* Declare signed bitfields at offset 39 */
    S39_1		 pS39_1;
    jit_node_t		*nS39_1;
    S39_2		 pS39_2;
    jit_node_t		*nS39_2;
    S39_3		 pS39_3;
    jit_node_t		*nS39_3;
    S39_4		 pS39_4;
    jit_node_t		*nS39_4;
    S39_5		 pS39_5;
    jit_node_t		*nS39_5;
    S39_6		 pS39_6;
    jit_node_t		*nS39_6;
    S39_7		 pS39_7;
    jit_node_t		*nS39_7;
    S39_8		 pS39_8;
    jit_node_t		*nS39_8;
    S39_9		 pS39_9;
    jit_node_t		*nS39_9;
    S39_10		 pS39_10;
    jit_node_t		*nS39_10;
    S39_11		 pS39_11;
    jit_node_t		*nS39_11;
    S39_12		 pS39_12;
    jit_node_t		*nS39_12;
    S39_13		 pS39_13;
    jit_node_t		*nS39_13;
    S39_14		 pS39_14;
    jit_node_t		*nS39_14;
    S39_15		 pS39_15;
    jit_node_t		*nS39_15;
    S39_16		 pS39_16;
    jit_node_t		*nS39_16;
    S39_17		 pS39_17;
    jit_node_t		*nS39_17;
    S39_18		 pS39_18;
    jit_node_t		*nS39_18;
    S39_19		 pS39_19;
    jit_node_t		*nS39_19;
    S39_20		 pS39_20;
    jit_node_t		*nS39_20;
    S39_21		 pS39_21;
    jit_node_t		*nS39_21;
    S39_22		 pS39_22;
    jit_node_t		*nS39_22;
    S39_23		 pS39_23;
    jit_node_t		*nS39_23;
    S39_24		 pS39_24;
    jit_node_t		*nS39_24;
    S39_25		 pS39_25;
    jit_node_t		*nS39_25;
    /* Declare signed bitfields at offset 40 */
    S40_1		 pS40_1;
    jit_node_t		*nS40_1;
    S40_2		 pS40_2;
    jit_node_t		*nS40_2;
    S40_3		 pS40_3;
    jit_node_t		*nS40_3;
    S40_4		 pS40_4;
    jit_node_t		*nS40_4;
    S40_5		 pS40_5;
    jit_node_t		*nS40_5;
    S40_6		 pS40_6;
    jit_node_t		*nS40_6;
    S40_7		 pS40_7;
    jit_node_t		*nS40_7;
    S40_8		 pS40_8;
    jit_node_t		*nS40_8;
    S40_9		 pS40_9;
    jit_node_t		*nS40_9;
    S40_10		 pS40_10;
    jit_node_t		*nS40_10;
    S40_11		 pS40_11;
    jit_node_t		*nS40_11;
    S40_12		 pS40_12;
    jit_node_t		*nS40_12;
    S40_13		 pS40_13;
    jit_node_t		*nS40_13;
    S40_14		 pS40_14;
    jit_node_t		*nS40_14;
    S40_15		 pS40_15;
    jit_node_t		*nS40_15;
    S40_16		 pS40_16;
    jit_node_t		*nS40_16;
    S40_17		 pS40_17;
    jit_node_t		*nS40_17;
    S40_18		 pS40_18;
    jit_node_t		*nS40_18;
    S40_19		 pS40_19;
    jit_node_t		*nS40_19;
    S40_20		 pS40_20;
    jit_node_t		*nS40_20;
    S40_21		 pS40_21;
    jit_node_t		*nS40_21;
    S40_22		 pS40_22;
    jit_node_t		*nS40_22;
    S40_23		 pS40_23;
    jit_node_t		*nS40_23;
    S40_24		 pS40_24;
    jit_node_t		*nS40_24;
    /* Declare signed bitfields at offset 41 */
    S41_1		 pS41_1;
    jit_node_t		*nS41_1;
    S41_2		 pS41_2;
    jit_node_t		*nS41_2;
    S41_3		 pS41_3;
    jit_node_t		*nS41_3;
    S41_4		 pS41_4;
    jit_node_t		*nS41_4;
    S41_5		 pS41_5;
    jit_node_t		*nS41_5;
    S41_6		 pS41_6;
    jit_node_t		*nS41_6;
    S41_7		 pS41_7;
    jit_node_t		*nS41_7;
    S41_8		 pS41_8;
    jit_node_t		*nS41_8;
    S41_9		 pS41_9;
    jit_node_t		*nS41_9;
    S41_10		 pS41_10;
    jit_node_t		*nS41_10;
    S41_11		 pS41_11;
    jit_node_t		*nS41_11;
    S41_12		 pS41_12;
    jit_node_t		*nS41_12;
    S41_13		 pS41_13;
    jit_node_t		*nS41_13;
    S41_14		 pS41_14;
    jit_node_t		*nS41_14;
    S41_15		 pS41_15;
    jit_node_t		*nS41_15;
    S41_16		 pS41_16;
    jit_node_t		*nS41_16;
    S41_17		 pS41_17;
    jit_node_t		*nS41_17;
    S41_18		 pS41_18;
    jit_node_t		*nS41_18;
    S41_19		 pS41_19;
    jit_node_t		*nS41_19;
    S41_20		 pS41_20;
    jit_node_t		*nS41_20;
    S41_21		 pS41_21;
    jit_node_t		*nS41_21;
    S41_22		 pS41_22;
    jit_node_t		*nS41_22;
    S41_23		 pS41_23;
    jit_node_t		*nS41_23;
    /* Declare signed bitfields at offset 42 */
    S42_1		 pS42_1;
    jit_node_t		*nS42_1;
    S42_2		 pS42_2;
    jit_node_t		*nS42_2;
    S42_3		 pS42_3;
    jit_node_t		*nS42_3;
    S42_4		 pS42_4;
    jit_node_t		*nS42_4;
    S42_5		 pS42_5;
    jit_node_t		*nS42_5;
    S42_6		 pS42_6;
    jit_node_t		*nS42_6;
    S42_7		 pS42_7;
    jit_node_t		*nS42_7;
    S42_8		 pS42_8;
    jit_node_t		*nS42_8;
    S42_9		 pS42_9;
    jit_node_t		*nS42_9;
    S42_10		 pS42_10;
    jit_node_t		*nS42_10;
    S42_11		 pS42_11;
    jit_node_t		*nS42_11;
    S42_12		 pS42_12;
    jit_node_t		*nS42_12;
    S42_13		 pS42_13;
    jit_node_t		*nS42_13;
    S42_14		 pS42_14;
    jit_node_t		*nS42_14;
    S42_15		 pS42_15;
    jit_node_t		*nS42_15;
    S42_16		 pS42_16;
    jit_node_t		*nS42_16;
    S42_17		 pS42_17;
    jit_node_t		*nS42_17;
    S42_18		 pS42_18;
    jit_node_t		*nS42_18;
    S42_19		 pS42_19;
    jit_node_t		*nS42_19;
    S42_20		 pS42_20;
    jit_node_t		*nS42_20;
    S42_21		 pS42_21;
    jit_node_t		*nS42_21;
    S42_22		 pS42_22;
    jit_node_t		*nS42_22;
    /* Declare signed bitfields at offset 43 */
    S43_1		 pS43_1;
    jit_node_t		*nS43_1;
    S43_2		 pS43_2;
    jit_node_t		*nS43_2;
    S43_3		 pS43_3;
    jit_node_t		*nS43_3;
    S43_4		 pS43_4;
    jit_node_t		*nS43_4;
    S43_5		 pS43_5;
    jit_node_t		*nS43_5;
    S43_6		 pS43_6;
    jit_node_t		*nS43_6;
    S43_7		 pS43_7;
    jit_node_t		*nS43_7;
    S43_8		 pS43_8;
    jit_node_t		*nS43_8;
    S43_9		 pS43_9;
    jit_node_t		*nS43_9;
    S43_10		 pS43_10;
    jit_node_t		*nS43_10;
    S43_11		 pS43_11;
    jit_node_t		*nS43_11;
    S43_12		 pS43_12;
    jit_node_t		*nS43_12;
    S43_13		 pS43_13;
    jit_node_t		*nS43_13;
    S43_14		 pS43_14;
    jit_node_t		*nS43_14;
    S43_15		 pS43_15;
    jit_node_t		*nS43_15;
    S43_16		 pS43_16;
    jit_node_t		*nS43_16;
    S43_17		 pS43_17;
    jit_node_t		*nS43_17;
    S43_18		 pS43_18;
    jit_node_t		*nS43_18;
    S43_19		 pS43_19;
    jit_node_t		*nS43_19;
    S43_20		 pS43_20;
    jit_node_t		*nS43_20;
    S43_21		 pS43_21;
    jit_node_t		*nS43_21;
    /* Declare signed bitfields at offset 44 */
    S44_1		 pS44_1;
    jit_node_t		*nS44_1;
    S44_2		 pS44_2;
    jit_node_t		*nS44_2;
    S44_3		 pS44_3;
    jit_node_t		*nS44_3;
    S44_4		 pS44_4;
    jit_node_t		*nS44_4;
    S44_5		 pS44_5;
    jit_node_t		*nS44_5;
    S44_6		 pS44_6;
    jit_node_t		*nS44_6;
    S44_7		 pS44_7;
    jit_node_t		*nS44_7;
    S44_8		 pS44_8;
    jit_node_t		*nS44_8;
    S44_9		 pS44_9;
    jit_node_t		*nS44_9;
    S44_10		 pS44_10;
    jit_node_t		*nS44_10;
    S44_11		 pS44_11;
    jit_node_t		*nS44_11;
    S44_12		 pS44_12;
    jit_node_t		*nS44_12;
    S44_13		 pS44_13;
    jit_node_t		*nS44_13;
    S44_14		 pS44_14;
    jit_node_t		*nS44_14;
    S44_15		 pS44_15;
    jit_node_t		*nS44_15;
    S44_16		 pS44_16;
    jit_node_t		*nS44_16;
    S44_17		 pS44_17;
    jit_node_t		*nS44_17;
    S44_18		 pS44_18;
    jit_node_t		*nS44_18;
    S44_19		 pS44_19;
    jit_node_t		*nS44_19;
    S44_20		 pS44_20;
    jit_node_t		*nS44_20;
    /* Declare signed bitfields at offset 45 */
    S45_1		 pS45_1;
    jit_node_t		*nS45_1;
    S45_2		 pS45_2;
    jit_node_t		*nS45_2;
    S45_3		 pS45_3;
    jit_node_t		*nS45_3;
    S45_4		 pS45_4;
    jit_node_t		*nS45_4;
    S45_5		 pS45_5;
    jit_node_t		*nS45_5;
    S45_6		 pS45_6;
    jit_node_t		*nS45_6;
    S45_7		 pS45_7;
    jit_node_t		*nS45_7;
    S45_8		 pS45_8;
    jit_node_t		*nS45_8;
    S45_9		 pS45_9;
    jit_node_t		*nS45_9;
    S45_10		 pS45_10;
    jit_node_t		*nS45_10;
    S45_11		 pS45_11;
    jit_node_t		*nS45_11;
    S45_12		 pS45_12;
    jit_node_t		*nS45_12;
    S45_13		 pS45_13;
    jit_node_t		*nS45_13;
    S45_14		 pS45_14;
    jit_node_t		*nS45_14;
    S45_15		 pS45_15;
    jit_node_t		*nS45_15;
    S45_16		 pS45_16;
    jit_node_t		*nS45_16;
    S45_17		 pS45_17;
    jit_node_t		*nS45_17;
    S45_18		 pS45_18;
    jit_node_t		*nS45_18;
    S45_19		 pS45_19;
    jit_node_t		*nS45_19;
    /* Declare signed bitfields at offset 46 */
    S46_1		 pS46_1;
    jit_node_t		*nS46_1;
    S46_2		 pS46_2;
    jit_node_t		*nS46_2;
    S46_3		 pS46_3;
    jit_node_t		*nS46_3;
    S46_4		 pS46_4;
    jit_node_t		*nS46_4;
    S46_5		 pS46_5;
    jit_node_t		*nS46_5;
    S46_6		 pS46_6;
    jit_node_t		*nS46_6;
    S46_7		 pS46_7;
    jit_node_t		*nS46_7;
    S46_8		 pS46_8;
    jit_node_t		*nS46_8;
    S46_9		 pS46_9;
    jit_node_t		*nS46_9;
    S46_10		 pS46_10;
    jit_node_t		*nS46_10;
    S46_11		 pS46_11;
    jit_node_t		*nS46_11;
    S46_12		 pS46_12;
    jit_node_t		*nS46_12;
    S46_13		 pS46_13;
    jit_node_t		*nS46_13;
    S46_14		 pS46_14;
    jit_node_t		*nS46_14;
    S46_15		 pS46_15;
    jit_node_t		*nS46_15;
    S46_16		 pS46_16;
    jit_node_t		*nS46_16;
    S46_17		 pS46_17;
    jit_node_t		*nS46_17;
    S46_18		 pS46_18;
    jit_node_t		*nS46_18;
    /* Declare signed bitfields at offset 47 */
    S47_1		 pS47_1;
    jit_node_t		*nS47_1;
    S47_2		 pS47_2;
    jit_node_t		*nS47_2;
    S47_3		 pS47_3;
    jit_node_t		*nS47_3;
    S47_4		 pS47_4;
    jit_node_t		*nS47_4;
    S47_5		 pS47_5;
    jit_node_t		*nS47_5;
    S47_6		 pS47_6;
    jit_node_t		*nS47_6;
    S47_7		 pS47_7;
    jit_node_t		*nS47_7;
    S47_8		 pS47_8;
    jit_node_t		*nS47_8;
    S47_9		 pS47_9;
    jit_node_t		*nS47_9;
    S47_10		 pS47_10;
    jit_node_t		*nS47_10;
    S47_11		 pS47_11;
    jit_node_t		*nS47_11;
    S47_12		 pS47_12;
    jit_node_t		*nS47_12;
    S47_13		 pS47_13;
    jit_node_t		*nS47_13;
    S47_14		 pS47_14;
    jit_node_t		*nS47_14;
    S47_15		 pS47_15;
    jit_node_t		*nS47_15;
    S47_16		 pS47_16;
    jit_node_t		*nS47_16;
    S47_17		 pS47_17;
    jit_node_t		*nS47_17;
    /* Declare signed bitfields at offset 48 */
    S48_1		 pS48_1;
    jit_node_t		*nS48_1;
    S48_2		 pS48_2;
    jit_node_t		*nS48_2;
    S48_3		 pS48_3;
    jit_node_t		*nS48_3;
    S48_4		 pS48_4;
    jit_node_t		*nS48_4;
    S48_5		 pS48_5;
    jit_node_t		*nS48_5;
    S48_6		 pS48_6;
    jit_node_t		*nS48_6;
    S48_7		 pS48_7;
    jit_node_t		*nS48_7;
    S48_8		 pS48_8;
    jit_node_t		*nS48_8;
    S48_9		 pS48_9;
    jit_node_t		*nS48_9;
    S48_10		 pS48_10;
    jit_node_t		*nS48_10;
    S48_11		 pS48_11;
    jit_node_t		*nS48_11;
    S48_12		 pS48_12;
    jit_node_t		*nS48_12;
    S48_13		 pS48_13;
    jit_node_t		*nS48_13;
    S48_14		 pS48_14;
    jit_node_t		*nS48_14;
    S48_15		 pS48_15;
    jit_node_t		*nS48_15;
    S48_16		 pS48_16;
    jit_node_t		*nS48_16;
    /* Declare signed bitfields at offset 49 */
    S49_1		 pS49_1;
    jit_node_t		*nS49_1;
    S49_2		 pS49_2;
    jit_node_t		*nS49_2;
    S49_3		 pS49_3;
    jit_node_t		*nS49_3;
    S49_4		 pS49_4;
    jit_node_t		*nS49_4;
    S49_5		 pS49_5;
    jit_node_t		*nS49_5;
    S49_6		 pS49_6;
    jit_node_t		*nS49_6;
    S49_7		 pS49_7;
    jit_node_t		*nS49_7;
    S49_8		 pS49_8;
    jit_node_t		*nS49_8;
    S49_9		 pS49_9;
    jit_node_t		*nS49_9;
    S49_10		 pS49_10;
    jit_node_t		*nS49_10;
    S49_11		 pS49_11;
    jit_node_t		*nS49_11;
    S49_12		 pS49_12;
    jit_node_t		*nS49_12;
    S49_13		 pS49_13;
    jit_node_t		*nS49_13;
    S49_14		 pS49_14;
    jit_node_t		*nS49_14;
    S49_15		 pS49_15;
    jit_node_t		*nS49_15;
    /* Declare signed bitfields at offset 50 */
    S50_1		 pS50_1;
    jit_node_t		*nS50_1;
    S50_2		 pS50_2;
    jit_node_t		*nS50_2;
    S50_3		 pS50_3;
    jit_node_t		*nS50_3;
    S50_4		 pS50_4;
    jit_node_t		*nS50_4;
    S50_5		 pS50_5;
    jit_node_t		*nS50_5;
    S50_6		 pS50_6;
    jit_node_t		*nS50_6;
    S50_7		 pS50_7;
    jit_node_t		*nS50_7;
    S50_8		 pS50_8;
    jit_node_t		*nS50_8;
    S50_9		 pS50_9;
    jit_node_t		*nS50_9;
    S50_10		 pS50_10;
    jit_node_t		*nS50_10;
    S50_11		 pS50_11;
    jit_node_t		*nS50_11;
    S50_12		 pS50_12;
    jit_node_t		*nS50_12;
    S50_13		 pS50_13;
    jit_node_t		*nS50_13;
    S50_14		 pS50_14;
    jit_node_t		*nS50_14;
    /* Declare signed bitfields at offset 51 */
    S51_1		 pS51_1;
    jit_node_t		*nS51_1;
    S51_2		 pS51_2;
    jit_node_t		*nS51_2;
    S51_3		 pS51_3;
    jit_node_t		*nS51_3;
    S51_4		 pS51_4;
    jit_node_t		*nS51_4;
    S51_5		 pS51_5;
    jit_node_t		*nS51_5;
    S51_6		 pS51_6;
    jit_node_t		*nS51_6;
    S51_7		 pS51_7;
    jit_node_t		*nS51_7;
    S51_8		 pS51_8;
    jit_node_t		*nS51_8;
    S51_9		 pS51_9;
    jit_node_t		*nS51_9;
    S51_10		 pS51_10;
    jit_node_t		*nS51_10;
    S51_11		 pS51_11;
    jit_node_t		*nS51_11;
    S51_12		 pS51_12;
    jit_node_t		*nS51_12;
    S51_13		 pS51_13;
    jit_node_t		*nS51_13;
    /* Declare signed bitfields at offset 52 */
    S52_1		 pS52_1;
    jit_node_t		*nS52_1;
    S52_2		 pS52_2;
    jit_node_t		*nS52_2;
    S52_3		 pS52_3;
    jit_node_t		*nS52_3;
    S52_4		 pS52_4;
    jit_node_t		*nS52_4;
    S52_5		 pS52_5;
    jit_node_t		*nS52_5;
    S52_6		 pS52_6;
    jit_node_t		*nS52_6;
    S52_7		 pS52_7;
    jit_node_t		*nS52_7;
    S52_8		 pS52_8;
    jit_node_t		*nS52_8;
    S52_9		 pS52_9;
    jit_node_t		*nS52_9;
    S52_10		 pS52_10;
    jit_node_t		*nS52_10;
    S52_11		 pS52_11;
    jit_node_t		*nS52_11;
    S52_12		 pS52_12;
    jit_node_t		*nS52_12;
    /* Declare signed bitfields at offset 53 */
    S53_1		 pS53_1;
    jit_node_t		*nS53_1;
    S53_2		 pS53_2;
    jit_node_t		*nS53_2;
    S53_3		 pS53_3;
    jit_node_t		*nS53_3;
    S53_4		 pS53_4;
    jit_node_t		*nS53_4;
    S53_5		 pS53_5;
    jit_node_t		*nS53_5;
    S53_6		 pS53_6;
    jit_node_t		*nS53_6;
    S53_7		 pS53_7;
    jit_node_t		*nS53_7;
    S53_8		 pS53_8;
    jit_node_t		*nS53_8;
    S53_9		 pS53_9;
    jit_node_t		*nS53_9;
    S53_10		 pS53_10;
    jit_node_t		*nS53_10;
    S53_11		 pS53_11;
    jit_node_t		*nS53_11;
    /* Declare signed bitfields at offset 54 */
    S54_1		 pS54_1;
    jit_node_t		*nS54_1;
    S54_2		 pS54_2;
    jit_node_t		*nS54_2;
    S54_3		 pS54_3;
    jit_node_t		*nS54_3;
    S54_4		 pS54_4;
    jit_node_t		*nS54_4;
    S54_5		 pS54_5;
    jit_node_t		*nS54_5;
    S54_6		 pS54_6;
    jit_node_t		*nS54_6;
    S54_7		 pS54_7;
    jit_node_t		*nS54_7;
    S54_8		 pS54_8;
    jit_node_t		*nS54_8;
    S54_9		 pS54_9;
    jit_node_t		*nS54_9;
    S54_10		 pS54_10;
    jit_node_t		*nS54_10;
    /* Declare signed bitfields at offset 55 */
    S55_1		 pS55_1;
    jit_node_t		*nS55_1;
    S55_2		 pS55_2;
    jit_node_t		*nS55_2;
    S55_3		 pS55_3;
    jit_node_t		*nS55_3;
    S55_4		 pS55_4;
    jit_node_t		*nS55_4;
    S55_5		 pS55_5;
    jit_node_t		*nS55_5;
    S55_6		 pS55_6;
    jit_node_t		*nS55_6;
    S55_7		 pS55_7;
    jit_node_t		*nS55_7;
    S55_8		 pS55_8;
    jit_node_t		*nS55_8;
    S55_9		 pS55_9;
    jit_node_t		*nS55_9;
    /* Declare signed bitfields at offset 56 */
    S56_1		 pS56_1;
    jit_node_t		*nS56_1;
    S56_2		 pS56_2;
    jit_node_t		*nS56_2;
    S56_3		 pS56_3;
    jit_node_t		*nS56_3;
    S56_4		 pS56_4;
    jit_node_t		*nS56_4;
    S56_5		 pS56_5;
    jit_node_t		*nS56_5;
    S56_6		 pS56_6;
    jit_node_t		*nS56_6;
    S56_7		 pS56_7;
    jit_node_t		*nS56_7;
    S56_8		 pS56_8;
    jit_node_t		*nS56_8;
    /* Declare signed bitfields at offset 57 */
    S57_1		 pS57_1;
    jit_node_t		*nS57_1;
    S57_2		 pS57_2;
    jit_node_t		*nS57_2;
    S57_3		 pS57_3;
    jit_node_t		*nS57_3;
    S57_4		 pS57_4;
    jit_node_t		*nS57_4;
    S57_5		 pS57_5;
    jit_node_t		*nS57_5;
    S57_6		 pS57_6;
    jit_node_t		*nS57_6;
    S57_7		 pS57_7;
    jit_node_t		*nS57_7;
    /* Declare signed bitfields at offset 58 */
    S58_1		 pS58_1;
    jit_node_t		*nS58_1;
    S58_2		 pS58_2;
    jit_node_t		*nS58_2;
    S58_3		 pS58_3;
    jit_node_t		*nS58_3;
    S58_4		 pS58_4;
    jit_node_t		*nS58_4;
    S58_5		 pS58_5;
    jit_node_t		*nS58_5;
    S58_6		 pS58_6;
    jit_node_t		*nS58_6;
    /* Declare signed bitfields at offset 59 */
    S59_1		 pS59_1;
    jit_node_t		*nS59_1;
    S59_2		 pS59_2;
    jit_node_t		*nS59_2;
    S59_3		 pS59_3;
    jit_node_t		*nS59_3;
    S59_4		 pS59_4;
    jit_node_t		*nS59_4;
    S59_5		 pS59_5;
    jit_node_t		*nS59_5;
    /* Declare signed bitfields at offset 60 */
    S60_1		 pS60_1;
    jit_node_t		*nS60_1;
    S60_2		 pS60_2;
    jit_node_t		*nS60_2;
    S60_3		 pS60_3;
    jit_node_t		*nS60_3;
    S60_4		 pS60_4;
    jit_node_t		*nS60_4;
    /* Declare signed bitfields at offset 61 */
    S61_1		 pS61_1;
    jit_node_t		*nS61_1;
    S61_2		 pS61_2;
    jit_node_t		*nS61_2;
    S61_3		 pS61_3;
    jit_node_t		*nS61_3;
    /* Declare signed bitfields at offset 62 */
    S62_1		 pS62_1;
    jit_node_t		*nS62_1;
    S62_2		 pS62_2;
    jit_node_t		*nS62_2;
    /* Declare signed bitfields at offset 63 */
    S63_1		 pS63_1;
    jit_node_t		*nS63_1;
#endif
    /* Declare unsigned bitfields at offset 1 */
    U1_1		 pU1_1;
    jit_node_t		*nU1_1;
    U1_2		 pU1_2;
    jit_node_t		*nU1_2;
    U1_3		 pU1_3;
    jit_node_t		*nU1_3;
    U1_4		 pU1_4;
    jit_node_t		*nU1_4;
    U1_5		 pU1_5;
    jit_node_t		*nU1_5;
    U1_6		 pU1_6;
    jit_node_t		*nU1_6;
    U1_7		 pU1_7;
    jit_node_t		*nU1_7;
    U1_8		 pU1_8;
    jit_node_t		*nU1_8;
    U1_9		 pU1_9;
    jit_node_t		*nU1_9;
    U1_10		 pU1_10;
    jit_node_t		*nU1_10;
    U1_11		 pU1_11;
    jit_node_t		*nU1_11;
    U1_12		 pU1_12;
    jit_node_t		*nU1_12;
    U1_13		 pU1_13;
    jit_node_t		*nU1_13;
    U1_14		 pU1_14;
    jit_node_t		*nU1_14;
    U1_15		 pU1_15;
    jit_node_t		*nU1_15;
    U1_16		 pU1_16;
    jit_node_t		*nU1_16;
    U1_17		 pU1_17;
    jit_node_t		*nU1_17;
    U1_18		 pU1_18;
    jit_node_t		*nU1_18;
    U1_19		 pU1_19;
    jit_node_t		*nU1_19;
    U1_20		 pU1_20;
    jit_node_t		*nU1_20;
    U1_21		 pU1_21;
    jit_node_t		*nU1_21;
    U1_22		 pU1_22;
    jit_node_t		*nU1_22;
    U1_23		 pU1_23;
    jit_node_t		*nU1_23;
    U1_24		 pU1_24;
    jit_node_t		*nU1_24;
    U1_25		 pU1_25;
    jit_node_t		*nU1_25;
    U1_26		 pU1_26;
    jit_node_t		*nU1_26;
    U1_27		 pU1_27;
    jit_node_t		*nU1_27;
    U1_28		 pU1_28;
    jit_node_t		*nU1_28;
    U1_29		 pU1_29;
    jit_node_t		*nU1_29;
    U1_30		 pU1_30;
    jit_node_t		*nU1_30;
    U1_31		 pU1_31;
    jit_node_t		*nU1_31;
    /* Declare unsigned bitfields at offset 2 */
    U2_1		 pU2_1;
    jit_node_t		*nU2_1;
    U2_2		 pU2_2;
    jit_node_t		*nU2_2;
    U2_3		 pU2_3;
    jit_node_t		*nU2_3;
    U2_4		 pU2_4;
    jit_node_t		*nU2_4;
    U2_5		 pU2_5;
    jit_node_t		*nU2_5;
    U2_6		 pU2_6;
    jit_node_t		*nU2_6;
    U2_7		 pU2_7;
    jit_node_t		*nU2_7;
    U2_8		 pU2_8;
    jit_node_t		*nU2_8;
    U2_9		 pU2_9;
    jit_node_t		*nU2_9;
    U2_10		 pU2_10;
    jit_node_t		*nU2_10;
    U2_11		 pU2_11;
    jit_node_t		*nU2_11;
    U2_12		 pU2_12;
    jit_node_t		*nU2_12;
    U2_13		 pU2_13;
    jit_node_t		*nU2_13;
    U2_14		 pU2_14;
    jit_node_t		*nU2_14;
    U2_15		 pU2_15;
    jit_node_t		*nU2_15;
    U2_16		 pU2_16;
    jit_node_t		*nU2_16;
    U2_17		 pU2_17;
    jit_node_t		*nU2_17;
    U2_18		 pU2_18;
    jit_node_t		*nU2_18;
    U2_19		 pU2_19;
    jit_node_t		*nU2_19;
    U2_20		 pU2_20;
    jit_node_t		*nU2_20;
    U2_21		 pU2_21;
    jit_node_t		*nU2_21;
    U2_22		 pU2_22;
    jit_node_t		*nU2_22;
    U2_23		 pU2_23;
    jit_node_t		*nU2_23;
    U2_24		 pU2_24;
    jit_node_t		*nU2_24;
    U2_25		 pU2_25;
    jit_node_t		*nU2_25;
    U2_26		 pU2_26;
    jit_node_t		*nU2_26;
    U2_27		 pU2_27;
    jit_node_t		*nU2_27;
    U2_28		 pU2_28;
    jit_node_t		*nU2_28;
    U2_29		 pU2_29;
    jit_node_t		*nU2_29;
    U2_30		 pU2_30;
    jit_node_t		*nU2_30;
    /* Declare unsigned bitfields at offset 3 */
    U3_1		 pU3_1;
    jit_node_t		*nU3_1;
    U3_2		 pU3_2;
    jit_node_t		*nU3_2;
    U3_3		 pU3_3;
    jit_node_t		*nU3_3;
    U3_4		 pU3_4;
    jit_node_t		*nU3_4;
    U3_5		 pU3_5;
    jit_node_t		*nU3_5;
    U3_6		 pU3_6;
    jit_node_t		*nU3_6;
    U3_7		 pU3_7;
    jit_node_t		*nU3_7;
    U3_8		 pU3_8;
    jit_node_t		*nU3_8;
    U3_9		 pU3_9;
    jit_node_t		*nU3_9;
    U3_10		 pU3_10;
    jit_node_t		*nU3_10;
    U3_11		 pU3_11;
    jit_node_t		*nU3_11;
    U3_12		 pU3_12;
    jit_node_t		*nU3_12;
    U3_13		 pU3_13;
    jit_node_t		*nU3_13;
    U3_14		 pU3_14;
    jit_node_t		*nU3_14;
    U3_15		 pU3_15;
    jit_node_t		*nU3_15;
    U3_16		 pU3_16;
    jit_node_t		*nU3_16;
    U3_17		 pU3_17;
    jit_node_t		*nU3_17;
    U3_18		 pU3_18;
    jit_node_t		*nU3_18;
    U3_19		 pU3_19;
    jit_node_t		*nU3_19;
    U3_20		 pU3_20;
    jit_node_t		*nU3_20;
    U3_21		 pU3_21;
    jit_node_t		*nU3_21;
    U3_22		 pU3_22;
    jit_node_t		*nU3_22;
    U3_23		 pU3_23;
    jit_node_t		*nU3_23;
    U3_24		 pU3_24;
    jit_node_t		*nU3_24;
    U3_25		 pU3_25;
    jit_node_t		*nU3_25;
    U3_26		 pU3_26;
    jit_node_t		*nU3_26;
    U3_27		 pU3_27;
    jit_node_t		*nU3_27;
    U3_28		 pU3_28;
    jit_node_t		*nU3_28;
    U3_29		 pU3_29;
    jit_node_t		*nU3_29;
    /* Declare unsigned bitfields at offset 4 */
    U4_1		 pU4_1;
    jit_node_t		*nU4_1;
    U4_2		 pU4_2;
    jit_node_t		*nU4_2;
    U4_3		 pU4_3;
    jit_node_t		*nU4_3;
    U4_4		 pU4_4;
    jit_node_t		*nU4_4;
    U4_5		 pU4_5;
    jit_node_t		*nU4_5;
    U4_6		 pU4_6;
    jit_node_t		*nU4_6;
    U4_7		 pU4_7;
    jit_node_t		*nU4_7;
    U4_8		 pU4_8;
    jit_node_t		*nU4_8;
    U4_9		 pU4_9;
    jit_node_t		*nU4_9;
    U4_10		 pU4_10;
    jit_node_t		*nU4_10;
    U4_11		 pU4_11;
    jit_node_t		*nU4_11;
    U4_12		 pU4_12;
    jit_node_t		*nU4_12;
    U4_13		 pU4_13;
    jit_node_t		*nU4_13;
    U4_14		 pU4_14;
    jit_node_t		*nU4_14;
    U4_15		 pU4_15;
    jit_node_t		*nU4_15;
    U4_16		 pU4_16;
    jit_node_t		*nU4_16;
    U4_17		 pU4_17;
    jit_node_t		*nU4_17;
    U4_18		 pU4_18;
    jit_node_t		*nU4_18;
    U4_19		 pU4_19;
    jit_node_t		*nU4_19;
    U4_20		 pU4_20;
    jit_node_t		*nU4_20;
    U4_21		 pU4_21;
    jit_node_t		*nU4_21;
    U4_22		 pU4_22;
    jit_node_t		*nU4_22;
    U4_23		 pU4_23;
    jit_node_t		*nU4_23;
    U4_24		 pU4_24;
    jit_node_t		*nU4_24;
    U4_25		 pU4_25;
    jit_node_t		*nU4_25;
    U4_26		 pU4_26;
    jit_node_t		*nU4_26;
    U4_27		 pU4_27;
    jit_node_t		*nU4_27;
    U4_28		 pU4_28;
    jit_node_t		*nU4_28;
    /* Declare unsigned bitfields at offset 5 */
    U5_1		 pU5_1;
    jit_node_t		*nU5_1;
    U5_2		 pU5_2;
    jit_node_t		*nU5_2;
    U5_3		 pU5_3;
    jit_node_t		*nU5_3;
    U5_4		 pU5_4;
    jit_node_t		*nU5_4;
    U5_5		 pU5_5;
    jit_node_t		*nU5_5;
    U5_6		 pU5_6;
    jit_node_t		*nU5_6;
    U5_7		 pU5_7;
    jit_node_t		*nU5_7;
    U5_8		 pU5_8;
    jit_node_t		*nU5_8;
    U5_9		 pU5_9;
    jit_node_t		*nU5_9;
    U5_10		 pU5_10;
    jit_node_t		*nU5_10;
    U5_11		 pU5_11;
    jit_node_t		*nU5_11;
    U5_12		 pU5_12;
    jit_node_t		*nU5_12;
    U5_13		 pU5_13;
    jit_node_t		*nU5_13;
    U5_14		 pU5_14;
    jit_node_t		*nU5_14;
    U5_15		 pU5_15;
    jit_node_t		*nU5_15;
    U5_16		 pU5_16;
    jit_node_t		*nU5_16;
    U5_17		 pU5_17;
    jit_node_t		*nU5_17;
    U5_18		 pU5_18;
    jit_node_t		*nU5_18;
    U5_19		 pU5_19;
    jit_node_t		*nU5_19;
    U5_20		 pU5_20;
    jit_node_t		*nU5_20;
    U5_21		 pU5_21;
    jit_node_t		*nU5_21;
    U5_22		 pU5_22;
    jit_node_t		*nU5_22;
    U5_23		 pU5_23;
    jit_node_t		*nU5_23;
    U5_24		 pU5_24;
    jit_node_t		*nU5_24;
    U5_25		 pU5_25;
    jit_node_t		*nU5_25;
    U5_26		 pU5_26;
    jit_node_t		*nU5_26;
    U5_27		 pU5_27;
    jit_node_t		*nU5_27;
    /* Declare unsigned bitfields at offset 6 */
    U6_1		 pU6_1;
    jit_node_t		*nU6_1;
    U6_2		 pU6_2;
    jit_node_t		*nU6_2;
    U6_3		 pU6_3;
    jit_node_t		*nU6_3;
    U6_4		 pU6_4;
    jit_node_t		*nU6_4;
    U6_5		 pU6_5;
    jit_node_t		*nU6_5;
    U6_6		 pU6_6;
    jit_node_t		*nU6_6;
    U6_7		 pU6_7;
    jit_node_t		*nU6_7;
    U6_8		 pU6_8;
    jit_node_t		*nU6_8;
    U6_9		 pU6_9;
    jit_node_t		*nU6_9;
    U6_10		 pU6_10;
    jit_node_t		*nU6_10;
    U6_11		 pU6_11;
    jit_node_t		*nU6_11;
    U6_12		 pU6_12;
    jit_node_t		*nU6_12;
    U6_13		 pU6_13;
    jit_node_t		*nU6_13;
    U6_14		 pU6_14;
    jit_node_t		*nU6_14;
    U6_15		 pU6_15;
    jit_node_t		*nU6_15;
    U6_16		 pU6_16;
    jit_node_t		*nU6_16;
    U6_17		 pU6_17;
    jit_node_t		*nU6_17;
    U6_18		 pU6_18;
    jit_node_t		*nU6_18;
    U6_19		 pU6_19;
    jit_node_t		*nU6_19;
    U6_20		 pU6_20;
    jit_node_t		*nU6_20;
    U6_21		 pU6_21;
    jit_node_t		*nU6_21;
    U6_22		 pU6_22;
    jit_node_t		*nU6_22;
    U6_23		 pU6_23;
    jit_node_t		*nU6_23;
    U6_24		 pU6_24;
    jit_node_t		*nU6_24;
    U6_25		 pU6_25;
    jit_node_t		*nU6_25;
    U6_26		 pU6_26;
    jit_node_t		*nU6_26;
    /* Declare unsigned bitfields at offset 7 */
    U7_1		 pU7_1;
    jit_node_t		*nU7_1;
    U7_2		 pU7_2;
    jit_node_t		*nU7_2;
    U7_3		 pU7_3;
    jit_node_t		*nU7_3;
    U7_4		 pU7_4;
    jit_node_t		*nU7_4;
    U7_5		 pU7_5;
    jit_node_t		*nU7_5;
    U7_6		 pU7_6;
    jit_node_t		*nU7_6;
    U7_7		 pU7_7;
    jit_node_t		*nU7_7;
    U7_8		 pU7_8;
    jit_node_t		*nU7_8;
    U7_9		 pU7_9;
    jit_node_t		*nU7_9;
    U7_10		 pU7_10;
    jit_node_t		*nU7_10;
    U7_11		 pU7_11;
    jit_node_t		*nU7_11;
    U7_12		 pU7_12;
    jit_node_t		*nU7_12;
    U7_13		 pU7_13;
    jit_node_t		*nU7_13;
    U7_14		 pU7_14;
    jit_node_t		*nU7_14;
    U7_15		 pU7_15;
    jit_node_t		*nU7_15;
    U7_16		 pU7_16;
    jit_node_t		*nU7_16;
    U7_17		 pU7_17;
    jit_node_t		*nU7_17;
    U7_18		 pU7_18;
    jit_node_t		*nU7_18;
    U7_19		 pU7_19;
    jit_node_t		*nU7_19;
    U7_20		 pU7_20;
    jit_node_t		*nU7_20;
    U7_21		 pU7_21;
    jit_node_t		*nU7_21;
    U7_22		 pU7_22;
    jit_node_t		*nU7_22;
    U7_23		 pU7_23;
    jit_node_t		*nU7_23;
    U7_24		 pU7_24;
    jit_node_t		*nU7_24;
    U7_25		 pU7_25;
    jit_node_t		*nU7_25;
    /* Declare unsigned bitfields at offset 8 */
    U8_1		 pU8_1;
    jit_node_t		*nU8_1;
    U8_2		 pU8_2;
    jit_node_t		*nU8_2;
    U8_3		 pU8_3;
    jit_node_t		*nU8_3;
    U8_4		 pU8_4;
    jit_node_t		*nU8_4;
    U8_5		 pU8_5;
    jit_node_t		*nU8_5;
    U8_6		 pU8_6;
    jit_node_t		*nU8_6;
    U8_7		 pU8_7;
    jit_node_t		*nU8_7;
    U8_8		 pU8_8;
    jit_node_t		*nU8_8;
    U8_9		 pU8_9;
    jit_node_t		*nU8_9;
    U8_10		 pU8_10;
    jit_node_t		*nU8_10;
    U8_11		 pU8_11;
    jit_node_t		*nU8_11;
    U8_12		 pU8_12;
    jit_node_t		*nU8_12;
    U8_13		 pU8_13;
    jit_node_t		*nU8_13;
    U8_14		 pU8_14;
    jit_node_t		*nU8_14;
    U8_15		 pU8_15;
    jit_node_t		*nU8_15;
    U8_16		 pU8_16;
    jit_node_t		*nU8_16;
    U8_17		 pU8_17;
    jit_node_t		*nU8_17;
    U8_18		 pU8_18;
    jit_node_t		*nU8_18;
    U8_19		 pU8_19;
    jit_node_t		*nU8_19;
    U8_20		 pU8_20;
    jit_node_t		*nU8_20;
    U8_21		 pU8_21;
    jit_node_t		*nU8_21;
    U8_22		 pU8_22;
    jit_node_t		*nU8_22;
    U8_23		 pU8_23;
    jit_node_t		*nU8_23;
    U8_24		 pU8_24;
    jit_node_t		*nU8_24;
    /* Declare unsigned bitfields at offset 9 */
    U9_1		 pU9_1;
    jit_node_t		*nU9_1;
    U9_2		 pU9_2;
    jit_node_t		*nU9_2;
    U9_3		 pU9_3;
    jit_node_t		*nU9_3;
    U9_4		 pU9_4;
    jit_node_t		*nU9_4;
    U9_5		 pU9_5;
    jit_node_t		*nU9_5;
    U9_6		 pU9_6;
    jit_node_t		*nU9_6;
    U9_7		 pU9_7;
    jit_node_t		*nU9_7;
    U9_8		 pU9_8;
    jit_node_t		*nU9_8;
    U9_9		 pU9_9;
    jit_node_t		*nU9_9;
    U9_10		 pU9_10;
    jit_node_t		*nU9_10;
    U9_11		 pU9_11;
    jit_node_t		*nU9_11;
    U9_12		 pU9_12;
    jit_node_t		*nU9_12;
    U9_13		 pU9_13;
    jit_node_t		*nU9_13;
    U9_14		 pU9_14;
    jit_node_t		*nU9_14;
    U9_15		 pU9_15;
    jit_node_t		*nU9_15;
    U9_16		 pU9_16;
    jit_node_t		*nU9_16;
    U9_17		 pU9_17;
    jit_node_t		*nU9_17;
    U9_18		 pU9_18;
    jit_node_t		*nU9_18;
    U9_19		 pU9_19;
    jit_node_t		*nU9_19;
    U9_20		 pU9_20;
    jit_node_t		*nU9_20;
    U9_21		 pU9_21;
    jit_node_t		*nU9_21;
    U9_22		 pU9_22;
    jit_node_t		*nU9_22;
    U9_23		 pU9_23;
    jit_node_t		*nU9_23;
    /* Declare unsigned bitfields at offset 10 */
    U10_1		 pU10_1;
    jit_node_t		*nU10_1;
    U10_2		 pU10_2;
    jit_node_t		*nU10_2;
    U10_3		 pU10_3;
    jit_node_t		*nU10_3;
    U10_4		 pU10_4;
    jit_node_t		*nU10_4;
    U10_5		 pU10_5;
    jit_node_t		*nU10_5;
    U10_6		 pU10_6;
    jit_node_t		*nU10_6;
    U10_7		 pU10_7;
    jit_node_t		*nU10_7;
    U10_8		 pU10_8;
    jit_node_t		*nU10_8;
    U10_9		 pU10_9;
    jit_node_t		*nU10_9;
    U10_10		 pU10_10;
    jit_node_t		*nU10_10;
    U10_11		 pU10_11;
    jit_node_t		*nU10_11;
    U10_12		 pU10_12;
    jit_node_t		*nU10_12;
    U10_13		 pU10_13;
    jit_node_t		*nU10_13;
    U10_14		 pU10_14;
    jit_node_t		*nU10_14;
    U10_15		 pU10_15;
    jit_node_t		*nU10_15;
    U10_16		 pU10_16;
    jit_node_t		*nU10_16;
    U10_17		 pU10_17;
    jit_node_t		*nU10_17;
    U10_18		 pU10_18;
    jit_node_t		*nU10_18;
    U10_19		 pU10_19;
    jit_node_t		*nU10_19;
    U10_20		 pU10_20;
    jit_node_t		*nU10_20;
    U10_21		 pU10_21;
    jit_node_t		*nU10_21;
    U10_22		 pU10_22;
    jit_node_t		*nU10_22;
    /* Declare unsigned bitfields at offset 11 */
    U11_1		 pU11_1;
    jit_node_t		*nU11_1;
    U11_2		 pU11_2;
    jit_node_t		*nU11_2;
    U11_3		 pU11_3;
    jit_node_t		*nU11_3;
    U11_4		 pU11_4;
    jit_node_t		*nU11_4;
    U11_5		 pU11_5;
    jit_node_t		*nU11_5;
    U11_6		 pU11_6;
    jit_node_t		*nU11_6;
    U11_7		 pU11_7;
    jit_node_t		*nU11_7;
    U11_8		 pU11_8;
    jit_node_t		*nU11_8;
    U11_9		 pU11_9;
    jit_node_t		*nU11_9;
    U11_10		 pU11_10;
    jit_node_t		*nU11_10;
    U11_11		 pU11_11;
    jit_node_t		*nU11_11;
    U11_12		 pU11_12;
    jit_node_t		*nU11_12;
    U11_13		 pU11_13;
    jit_node_t		*nU11_13;
    U11_14		 pU11_14;
    jit_node_t		*nU11_14;
    U11_15		 pU11_15;
    jit_node_t		*nU11_15;
    U11_16		 pU11_16;
    jit_node_t		*nU11_16;
    U11_17		 pU11_17;
    jit_node_t		*nU11_17;
    U11_18		 pU11_18;
    jit_node_t		*nU11_18;
    U11_19		 pU11_19;
    jit_node_t		*nU11_19;
    U11_20		 pU11_20;
    jit_node_t		*nU11_20;
    U11_21		 pU11_21;
    jit_node_t		*nU11_21;
    /* Declare unsigned bitfields at offset 12 */
    U12_1		 pU12_1;
    jit_node_t		*nU12_1;
    U12_2		 pU12_2;
    jit_node_t		*nU12_2;
    U12_3		 pU12_3;
    jit_node_t		*nU12_3;
    U12_4		 pU12_4;
    jit_node_t		*nU12_4;
    U12_5		 pU12_5;
    jit_node_t		*nU12_5;
    U12_6		 pU12_6;
    jit_node_t		*nU12_6;
    U12_7		 pU12_7;
    jit_node_t		*nU12_7;
    U12_8		 pU12_8;
    jit_node_t		*nU12_8;
    U12_9		 pU12_9;
    jit_node_t		*nU12_9;
    U12_10		 pU12_10;
    jit_node_t		*nU12_10;
    U12_11		 pU12_11;
    jit_node_t		*nU12_11;
    U12_12		 pU12_12;
    jit_node_t		*nU12_12;
    U12_13		 pU12_13;
    jit_node_t		*nU12_13;
    U12_14		 pU12_14;
    jit_node_t		*nU12_14;
    U12_15		 pU12_15;
    jit_node_t		*nU12_15;
    U12_16		 pU12_16;
    jit_node_t		*nU12_16;
    U12_17		 pU12_17;
    jit_node_t		*nU12_17;
    U12_18		 pU12_18;
    jit_node_t		*nU12_18;
    U12_19		 pU12_19;
    jit_node_t		*nU12_19;
    U12_20		 pU12_20;
    jit_node_t		*nU12_20;
    /* Declare unsigned bitfields at offset 13 */
    U13_1		 pU13_1;
    jit_node_t		*nU13_1;
    U13_2		 pU13_2;
    jit_node_t		*nU13_2;
    U13_3		 pU13_3;
    jit_node_t		*nU13_3;
    U13_4		 pU13_4;
    jit_node_t		*nU13_4;
    U13_5		 pU13_5;
    jit_node_t		*nU13_5;
    U13_6		 pU13_6;
    jit_node_t		*nU13_6;
    U13_7		 pU13_7;
    jit_node_t		*nU13_7;
    U13_8		 pU13_8;
    jit_node_t		*nU13_8;
    U13_9		 pU13_9;
    jit_node_t		*nU13_9;
    U13_10		 pU13_10;
    jit_node_t		*nU13_10;
    U13_11		 pU13_11;
    jit_node_t		*nU13_11;
    U13_12		 pU13_12;
    jit_node_t		*nU13_12;
    U13_13		 pU13_13;
    jit_node_t		*nU13_13;
    U13_14		 pU13_14;
    jit_node_t		*nU13_14;
    U13_15		 pU13_15;
    jit_node_t		*nU13_15;
    U13_16		 pU13_16;
    jit_node_t		*nU13_16;
    U13_17		 pU13_17;
    jit_node_t		*nU13_17;
    U13_18		 pU13_18;
    jit_node_t		*nU13_18;
    U13_19		 pU13_19;
    jit_node_t		*nU13_19;
    /* Declare unsigned bitfields at offset 14 */
    U14_1		 pU14_1;
    jit_node_t		*nU14_1;
    U14_2		 pU14_2;
    jit_node_t		*nU14_2;
    U14_3		 pU14_3;
    jit_node_t		*nU14_3;
    U14_4		 pU14_4;
    jit_node_t		*nU14_4;
    U14_5		 pU14_5;
    jit_node_t		*nU14_5;
    U14_6		 pU14_6;
    jit_node_t		*nU14_6;
    U14_7		 pU14_7;
    jit_node_t		*nU14_7;
    U14_8		 pU14_8;
    jit_node_t		*nU14_8;
    U14_9		 pU14_9;
    jit_node_t		*nU14_9;
    U14_10		 pU14_10;
    jit_node_t		*nU14_10;
    U14_11		 pU14_11;
    jit_node_t		*nU14_11;
    U14_12		 pU14_12;
    jit_node_t		*nU14_12;
    U14_13		 pU14_13;
    jit_node_t		*nU14_13;
    U14_14		 pU14_14;
    jit_node_t		*nU14_14;
    U14_15		 pU14_15;
    jit_node_t		*nU14_15;
    U14_16		 pU14_16;
    jit_node_t		*nU14_16;
    U14_17		 pU14_17;
    jit_node_t		*nU14_17;
    U14_18		 pU14_18;
    jit_node_t		*nU14_18;
    /* Declare unsigned bitfields at offset 15 */
    U15_1		 pU15_1;
    jit_node_t		*nU15_1;
    U15_2		 pU15_2;
    jit_node_t		*nU15_2;
    U15_3		 pU15_3;
    jit_node_t		*nU15_3;
    U15_4		 pU15_4;
    jit_node_t		*nU15_4;
    U15_5		 pU15_5;
    jit_node_t		*nU15_5;
    U15_6		 pU15_6;
    jit_node_t		*nU15_6;
    U15_7		 pU15_7;
    jit_node_t		*nU15_7;
    U15_8		 pU15_8;
    jit_node_t		*nU15_8;
    U15_9		 pU15_9;
    jit_node_t		*nU15_9;
    U15_10		 pU15_10;
    jit_node_t		*nU15_10;
    U15_11		 pU15_11;
    jit_node_t		*nU15_11;
    U15_12		 pU15_12;
    jit_node_t		*nU15_12;
    U15_13		 pU15_13;
    jit_node_t		*nU15_13;
    U15_14		 pU15_14;
    jit_node_t		*nU15_14;
    U15_15		 pU15_15;
    jit_node_t		*nU15_15;
    U15_16		 pU15_16;
    jit_node_t		*nU15_16;
    U15_17		 pU15_17;
    jit_node_t		*nU15_17;
    /* Declare unsigned bitfields at offset 16 */
    U16_1		 pU16_1;
    jit_node_t		*nU16_1;
    U16_2		 pU16_2;
    jit_node_t		*nU16_2;
    U16_3		 pU16_3;
    jit_node_t		*nU16_3;
    U16_4		 pU16_4;
    jit_node_t		*nU16_4;
    U16_5		 pU16_5;
    jit_node_t		*nU16_5;
    U16_6		 pU16_6;
    jit_node_t		*nU16_6;
    U16_7		 pU16_7;
    jit_node_t		*nU16_7;
    U16_8		 pU16_8;
    jit_node_t		*nU16_8;
    U16_9		 pU16_9;
    jit_node_t		*nU16_9;
    U16_10		 pU16_10;
    jit_node_t		*nU16_10;
    U16_11		 pU16_11;
    jit_node_t		*nU16_11;
    U16_12		 pU16_12;
    jit_node_t		*nU16_12;
    U16_13		 pU16_13;
    jit_node_t		*nU16_13;
    U16_14		 pU16_14;
    jit_node_t		*nU16_14;
    U16_15		 pU16_15;
    jit_node_t		*nU16_15;
    U16_16		 pU16_16;
    jit_node_t		*nU16_16;
    /* Declare unsigned bitfields at offset 17 */
    U17_1		 pU17_1;
    jit_node_t		*nU17_1;
    U17_2		 pU17_2;
    jit_node_t		*nU17_2;
    U17_3		 pU17_3;
    jit_node_t		*nU17_3;
    U17_4		 pU17_4;
    jit_node_t		*nU17_4;
    U17_5		 pU17_5;
    jit_node_t		*nU17_5;
    U17_6		 pU17_6;
    jit_node_t		*nU17_6;
    U17_7		 pU17_7;
    jit_node_t		*nU17_7;
    U17_8		 pU17_8;
    jit_node_t		*nU17_8;
    U17_9		 pU17_9;
    jit_node_t		*nU17_9;
    U17_10		 pU17_10;
    jit_node_t		*nU17_10;
    U17_11		 pU17_11;
    jit_node_t		*nU17_11;
    U17_12		 pU17_12;
    jit_node_t		*nU17_12;
    U17_13		 pU17_13;
    jit_node_t		*nU17_13;
    U17_14		 pU17_14;
    jit_node_t		*nU17_14;
    U17_15		 pU17_15;
    jit_node_t		*nU17_15;
    /* Declare unsigned bitfields at offset 18 */
    U18_1		 pU18_1;
    jit_node_t		*nU18_1;
    U18_2		 pU18_2;
    jit_node_t		*nU18_2;
    U18_3		 pU18_3;
    jit_node_t		*nU18_3;
    U18_4		 pU18_4;
    jit_node_t		*nU18_4;
    U18_5		 pU18_5;
    jit_node_t		*nU18_5;
    U18_6		 pU18_6;
    jit_node_t		*nU18_6;
    U18_7		 pU18_7;
    jit_node_t		*nU18_7;
    U18_8		 pU18_8;
    jit_node_t		*nU18_8;
    U18_9		 pU18_9;
    jit_node_t		*nU18_9;
    U18_10		 pU18_10;
    jit_node_t		*nU18_10;
    U18_11		 pU18_11;
    jit_node_t		*nU18_11;
    U18_12		 pU18_12;
    jit_node_t		*nU18_12;
    U18_13		 pU18_13;
    jit_node_t		*nU18_13;
    U18_14		 pU18_14;
    jit_node_t		*nU18_14;
    /* Declare unsigned bitfields at offset 19 */
    U19_1		 pU19_1;
    jit_node_t		*nU19_1;
    U19_2		 pU19_2;
    jit_node_t		*nU19_2;
    U19_3		 pU19_3;
    jit_node_t		*nU19_3;
    U19_4		 pU19_4;
    jit_node_t		*nU19_4;
    U19_5		 pU19_5;
    jit_node_t		*nU19_5;
    U19_6		 pU19_6;
    jit_node_t		*nU19_6;
    U19_7		 pU19_7;
    jit_node_t		*nU19_7;
    U19_8		 pU19_8;
    jit_node_t		*nU19_8;
    U19_9		 pU19_9;
    jit_node_t		*nU19_9;
    U19_10		 pU19_10;
    jit_node_t		*nU19_10;
    U19_11		 pU19_11;
    jit_node_t		*nU19_11;
    U19_12		 pU19_12;
    jit_node_t		*nU19_12;
    U19_13		 pU19_13;
    jit_node_t		*nU19_13;
    /* Declare unsigned bitfields at offset 20 */
    U20_1		 pU20_1;
    jit_node_t		*nU20_1;
    U20_2		 pU20_2;
    jit_node_t		*nU20_2;
    U20_3		 pU20_3;
    jit_node_t		*nU20_3;
    U20_4		 pU20_4;
    jit_node_t		*nU20_4;
    U20_5		 pU20_5;
    jit_node_t		*nU20_5;
    U20_6		 pU20_6;
    jit_node_t		*nU20_6;
    U20_7		 pU20_7;
    jit_node_t		*nU20_7;
    U20_8		 pU20_8;
    jit_node_t		*nU20_8;
    U20_9		 pU20_9;
    jit_node_t		*nU20_9;
    U20_10		 pU20_10;
    jit_node_t		*nU20_10;
    U20_11		 pU20_11;
    jit_node_t		*nU20_11;
    U20_12		 pU20_12;
    jit_node_t		*nU20_12;
    /* Declare unsigned bitfields at offset 21 */
    U21_1		 pU21_1;
    jit_node_t		*nU21_1;
    U21_2		 pU21_2;
    jit_node_t		*nU21_2;
    U21_3		 pU21_3;
    jit_node_t		*nU21_3;
    U21_4		 pU21_4;
    jit_node_t		*nU21_4;
    U21_5		 pU21_5;
    jit_node_t		*nU21_5;
    U21_6		 pU21_6;
    jit_node_t		*nU21_6;
    U21_7		 pU21_7;
    jit_node_t		*nU21_7;
    U21_8		 pU21_8;
    jit_node_t		*nU21_8;
    U21_9		 pU21_9;
    jit_node_t		*nU21_9;
    U21_10		 pU21_10;
    jit_node_t		*nU21_10;
    U21_11		 pU21_11;
    jit_node_t		*nU21_11;
    /* Declare unsigned bitfields at offset 22 */
    U22_1		 pU22_1;
    jit_node_t		*nU22_1;
    U22_2		 pU22_2;
    jit_node_t		*nU22_2;
    U22_3		 pU22_3;
    jit_node_t		*nU22_3;
    U22_4		 pU22_4;
    jit_node_t		*nU22_4;
    U22_5		 pU22_5;
    jit_node_t		*nU22_5;
    U22_6		 pU22_6;
    jit_node_t		*nU22_6;
    U22_7		 pU22_7;
    jit_node_t		*nU22_7;
    U22_8		 pU22_8;
    jit_node_t		*nU22_8;
    U22_9		 pU22_9;
    jit_node_t		*nU22_9;
    U22_10		 pU22_10;
    jit_node_t		*nU22_10;
    /* Declare unsigned bitfields at offset 23 */
    U23_1		 pU23_1;
    jit_node_t		*nU23_1;
    U23_2		 pU23_2;
    jit_node_t		*nU23_2;
    U23_3		 pU23_3;
    jit_node_t		*nU23_3;
    U23_4		 pU23_4;
    jit_node_t		*nU23_4;
    U23_5		 pU23_5;
    jit_node_t		*nU23_5;
    U23_6		 pU23_6;
    jit_node_t		*nU23_6;
    U23_7		 pU23_7;
    jit_node_t		*nU23_7;
    U23_8		 pU23_8;
    jit_node_t		*nU23_8;
    U23_9		 pU23_9;
    jit_node_t		*nU23_9;
    /* Declare unsigned bitfields at offset 24 */
    U24_1		 pU24_1;
    jit_node_t		*nU24_1;
    U24_2		 pU24_2;
    jit_node_t		*nU24_2;
    U24_3		 pU24_3;
    jit_node_t		*nU24_3;
    U24_4		 pU24_4;
    jit_node_t		*nU24_4;
    U24_5		 pU24_5;
    jit_node_t		*nU24_5;
    U24_6		 pU24_6;
    jit_node_t		*nU24_6;
    U24_7		 pU24_7;
    jit_node_t		*nU24_7;
    U24_8		 pU24_8;
    jit_node_t		*nU24_8;
    /* Declare unsigned bitfields at offset 25 */
    U25_1		 pU25_1;
    jit_node_t		*nU25_1;
    U25_2		 pU25_2;
    jit_node_t		*nU25_2;
    U25_3		 pU25_3;
    jit_node_t		*nU25_3;
    U25_4		 pU25_4;
    jit_node_t		*nU25_4;
    U25_5		 pU25_5;
    jit_node_t		*nU25_5;
    U25_6		 pU25_6;
    jit_node_t		*nU25_6;
    U25_7		 pU25_7;
    jit_node_t		*nU25_7;
    /* Declare unsigned bitfields at offset 26 */
    U26_1		 pU26_1;
    jit_node_t		*nU26_1;
    U26_2		 pU26_2;
    jit_node_t		*nU26_2;
    U26_3		 pU26_3;
    jit_node_t		*nU26_3;
    U26_4		 pU26_4;
    jit_node_t		*nU26_4;
    U26_5		 pU26_5;
    jit_node_t		*nU26_5;
    U26_6		 pU26_6;
    jit_node_t		*nU26_6;
    /* Declare unsigned bitfields at offset 27 */
    U27_1		 pU27_1;
    jit_node_t		*nU27_1;
    U27_2		 pU27_2;
    jit_node_t		*nU27_2;
    U27_3		 pU27_3;
    jit_node_t		*nU27_3;
    U27_4		 pU27_4;
    jit_node_t		*nU27_4;
    U27_5		 pU27_5;
    jit_node_t		*nU27_5;
    /* Declare unsigned bitfields at offset 28 */
    U28_1		 pU28_1;
    jit_node_t		*nU28_1;
    U28_2		 pU28_2;
    jit_node_t		*nU28_2;
    U28_3		 pU28_3;
    jit_node_t		*nU28_3;
    U28_4		 pU28_4;
    jit_node_t		*nU28_4;
    /* Declare unsigned bitfields at offset 29 */
    U29_1		 pU29_1;
    jit_node_t		*nU29_1;
    U29_2		 pU29_2;
    jit_node_t		*nU29_2;
    U29_3		 pU29_3;
    jit_node_t		*nU29_3;
    /* Declare unsigned bitfields at offset 30 */
    U30_1		 pU30_1;
    jit_node_t		*nU30_1;
    U30_2		 pU30_2;
    jit_node_t		*nU30_2;
    /* Declare unsigned bitfields at offset 31 */
    U31_1		 pU31_1;
    jit_node_t		*nU31_1;
#if __WORDSIZE == 64 && !SKIP_64_BITS
    /* Declare unsigned bitfields at offset 1 */
    U1_32		 pU1_32;
    jit_node_t		*nU1_32;
    U1_33		 pU1_33;
    jit_node_t		*nU1_33;
    U1_34		 pU1_34;
    jit_node_t		*nU1_34;
    U1_35		 pU1_35;
    jit_node_t		*nU1_35;
    U1_36		 pU1_36;
    jit_node_t		*nU1_36;
    U1_37		 pU1_37;
    jit_node_t		*nU1_37;
    U1_38		 pU1_38;
    jit_node_t		*nU1_38;
    U1_39		 pU1_39;
    jit_node_t		*nU1_39;
    U1_40		 pU1_40;
    jit_node_t		*nU1_40;
    U1_41		 pU1_41;
    jit_node_t		*nU1_41;
    U1_42		 pU1_42;
    jit_node_t		*nU1_42;
    U1_43		 pU1_43;
    jit_node_t		*nU1_43;
    U1_44		 pU1_44;
    jit_node_t		*nU1_44;
    U1_45		 pU1_45;
    jit_node_t		*nU1_45;
    U1_46		 pU1_46;
    jit_node_t		*nU1_46;
    U1_47		 pU1_47;
    jit_node_t		*nU1_47;
    U1_48		 pU1_48;
    jit_node_t		*nU1_48;
    U1_49		 pU1_49;
    jit_node_t		*nU1_49;
    U1_50		 pU1_50;
    jit_node_t		*nU1_50;
    U1_51		 pU1_51;
    jit_node_t		*nU1_51;
    U1_52		 pU1_52;
    jit_node_t		*nU1_52;
    U1_53		 pU1_53;
    jit_node_t		*nU1_53;
    U1_54		 pU1_54;
    jit_node_t		*nU1_54;
    U1_55		 pU1_55;
    jit_node_t		*nU1_55;
    U1_56		 pU1_56;
    jit_node_t		*nU1_56;
    U1_57		 pU1_57;
    jit_node_t		*nU1_57;
    U1_58		 pU1_58;
    jit_node_t		*nU1_58;
    U1_59		 pU1_59;
    jit_node_t		*nU1_59;
    U1_60		 pU1_60;
    jit_node_t		*nU1_60;
    U1_61		 pU1_61;
    jit_node_t		*nU1_61;
    U1_62		 pU1_62;
    jit_node_t		*nU1_62;
    U1_63		 pU1_63;
    jit_node_t		*nU1_63;
    /* Declare unsigned bitfields at offset 2 */
    U2_31		 pU2_31;
    jit_node_t		*nU2_31;
    U2_32		 pU2_32;
    jit_node_t		*nU2_32;
    U2_33		 pU2_33;
    jit_node_t		*nU2_33;
    U2_34		 pU2_34;
    jit_node_t		*nU2_34;
    U2_35		 pU2_35;
    jit_node_t		*nU2_35;
    U2_36		 pU2_36;
    jit_node_t		*nU2_36;
    U2_37		 pU2_37;
    jit_node_t		*nU2_37;
    U2_38		 pU2_38;
    jit_node_t		*nU2_38;
    U2_39		 pU2_39;
    jit_node_t		*nU2_39;
    U2_40		 pU2_40;
    jit_node_t		*nU2_40;
    U2_41		 pU2_41;
    jit_node_t		*nU2_41;
    U2_42		 pU2_42;
    jit_node_t		*nU2_42;
    U2_43		 pU2_43;
    jit_node_t		*nU2_43;
    U2_44		 pU2_44;
    jit_node_t		*nU2_44;
    U2_45		 pU2_45;
    jit_node_t		*nU2_45;
    U2_46		 pU2_46;
    jit_node_t		*nU2_46;
    U2_47		 pU2_47;
    jit_node_t		*nU2_47;
    U2_48		 pU2_48;
    jit_node_t		*nU2_48;
    U2_49		 pU2_49;
    jit_node_t		*nU2_49;
    U2_50		 pU2_50;
    jit_node_t		*nU2_50;
    U2_51		 pU2_51;
    jit_node_t		*nU2_51;
    U2_52		 pU2_52;
    jit_node_t		*nU2_52;
    U2_53		 pU2_53;
    jit_node_t		*nU2_53;
    U2_54		 pU2_54;
    jit_node_t		*nU2_54;
    U2_55		 pU2_55;
    jit_node_t		*nU2_55;
    U2_56		 pU2_56;
    jit_node_t		*nU2_56;
    U2_57		 pU2_57;
    jit_node_t		*nU2_57;
    U2_58		 pU2_58;
    jit_node_t		*nU2_58;
    U2_59		 pU2_59;
    jit_node_t		*nU2_59;
    U2_60		 pU2_60;
    jit_node_t		*nU2_60;
    U2_61		 pU2_61;
    jit_node_t		*nU2_61;
    U2_62		 pU2_62;
    jit_node_t		*nU2_62;
    /* Declare unsigned bitfields at offset 3 */
    U3_30		 pU3_30;
    jit_node_t		*nU3_30;
    U3_31		 pU3_31;
    jit_node_t		*nU3_31;
    U3_32		 pU3_32;
    jit_node_t		*nU3_32;
    U3_33		 pU3_33;
    jit_node_t		*nU3_33;
    U3_34		 pU3_34;
    jit_node_t		*nU3_34;
    U3_35		 pU3_35;
    jit_node_t		*nU3_35;
    U3_36		 pU3_36;
    jit_node_t		*nU3_36;
    U3_37		 pU3_37;
    jit_node_t		*nU3_37;
    U3_38		 pU3_38;
    jit_node_t		*nU3_38;
    U3_39		 pU3_39;
    jit_node_t		*nU3_39;
    U3_40		 pU3_40;
    jit_node_t		*nU3_40;
    U3_41		 pU3_41;
    jit_node_t		*nU3_41;
    U3_42		 pU3_42;
    jit_node_t		*nU3_42;
    U3_43		 pU3_43;
    jit_node_t		*nU3_43;
    U3_44		 pU3_44;
    jit_node_t		*nU3_44;
    U3_45		 pU3_45;
    jit_node_t		*nU3_45;
    U3_46		 pU3_46;
    jit_node_t		*nU3_46;
    U3_47		 pU3_47;
    jit_node_t		*nU3_47;
    U3_48		 pU3_48;
    jit_node_t		*nU3_48;
    U3_49		 pU3_49;
    jit_node_t		*nU3_49;
    U3_50		 pU3_50;
    jit_node_t		*nU3_50;
    U3_51		 pU3_51;
    jit_node_t		*nU3_51;
    U3_52		 pU3_52;
    jit_node_t		*nU3_52;
    U3_53		 pU3_53;
    jit_node_t		*nU3_53;
    U3_54		 pU3_54;
    jit_node_t		*nU3_54;
    U3_55		 pU3_55;
    jit_node_t		*nU3_55;
    U3_56		 pU3_56;
    jit_node_t		*nU3_56;
    U3_57		 pU3_57;
    jit_node_t		*nU3_57;
    U3_58		 pU3_58;
    jit_node_t		*nU3_58;
    U3_59		 pU3_59;
    jit_node_t		*nU3_59;
    U3_60		 pU3_60;
    jit_node_t		*nU3_60;
    U3_61		 pU3_61;
    jit_node_t		*nU3_61;
    /* Declare unsigned bitfields at offset 4 */
    U4_29		 pU4_29;
    jit_node_t		*nU4_29;
    U4_30		 pU4_30;
    jit_node_t		*nU4_30;
    U4_31		 pU4_31;
    jit_node_t		*nU4_31;
    U4_32		 pU4_32;
    jit_node_t		*nU4_32;
    U4_33		 pU4_33;
    jit_node_t		*nU4_33;
    U4_34		 pU4_34;
    jit_node_t		*nU4_34;
    U4_35		 pU4_35;
    jit_node_t		*nU4_35;
    U4_36		 pU4_36;
    jit_node_t		*nU4_36;
    U4_37		 pU4_37;
    jit_node_t		*nU4_37;
    U4_38		 pU4_38;
    jit_node_t		*nU4_38;
    U4_39		 pU4_39;
    jit_node_t		*nU4_39;
    U4_40		 pU4_40;
    jit_node_t		*nU4_40;
    U4_41		 pU4_41;
    jit_node_t		*nU4_41;
    U4_42		 pU4_42;
    jit_node_t		*nU4_42;
    U4_43		 pU4_43;
    jit_node_t		*nU4_43;
    U4_44		 pU4_44;
    jit_node_t		*nU4_44;
    U4_45		 pU4_45;
    jit_node_t		*nU4_45;
    U4_46		 pU4_46;
    jit_node_t		*nU4_46;
    U4_47		 pU4_47;
    jit_node_t		*nU4_47;
    U4_48		 pU4_48;
    jit_node_t		*nU4_48;
    U4_49		 pU4_49;
    jit_node_t		*nU4_49;
    U4_50		 pU4_50;
    jit_node_t		*nU4_50;
    U4_51		 pU4_51;
    jit_node_t		*nU4_51;
    U4_52		 pU4_52;
    jit_node_t		*nU4_52;
    U4_53		 pU4_53;
    jit_node_t		*nU4_53;
    U4_54		 pU4_54;
    jit_node_t		*nU4_54;
    U4_55		 pU4_55;
    jit_node_t		*nU4_55;
    U4_56		 pU4_56;
    jit_node_t		*nU4_56;
    U4_57		 pU4_57;
    jit_node_t		*nU4_57;
    U4_58		 pU4_58;
    jit_node_t		*nU4_58;
    U4_59		 pU4_59;
    jit_node_t		*nU4_59;
    U4_60		 pU4_60;
    jit_node_t		*nU4_60;
    /* Declare unsigned bitfields at offset 5 */
    U5_28		 pU5_28;
    jit_node_t		*nU5_28;
    U5_29		 pU5_29;
    jit_node_t		*nU5_29;
    U5_30		 pU5_30;
    jit_node_t		*nU5_30;
    U5_31		 pU5_31;
    jit_node_t		*nU5_31;
    U5_32		 pU5_32;
    jit_node_t		*nU5_32;
    U5_33		 pU5_33;
    jit_node_t		*nU5_33;
    U5_34		 pU5_34;
    jit_node_t		*nU5_34;
    U5_35		 pU5_35;
    jit_node_t		*nU5_35;
    U5_36		 pU5_36;
    jit_node_t		*nU5_36;
    U5_37		 pU5_37;
    jit_node_t		*nU5_37;
    U5_38		 pU5_38;
    jit_node_t		*nU5_38;
    U5_39		 pU5_39;
    jit_node_t		*nU5_39;
    U5_40		 pU5_40;
    jit_node_t		*nU5_40;
    U5_41		 pU5_41;
    jit_node_t		*nU5_41;
    U5_42		 pU5_42;
    jit_node_t		*nU5_42;
    U5_43		 pU5_43;
    jit_node_t		*nU5_43;
    U5_44		 pU5_44;
    jit_node_t		*nU5_44;
    U5_45		 pU5_45;
    jit_node_t		*nU5_45;
    U5_46		 pU5_46;
    jit_node_t		*nU5_46;
    U5_47		 pU5_47;
    jit_node_t		*nU5_47;
    U5_48		 pU5_48;
    jit_node_t		*nU5_48;
    U5_49		 pU5_49;
    jit_node_t		*nU5_49;
    U5_50		 pU5_50;
    jit_node_t		*nU5_50;
    U5_51		 pU5_51;
    jit_node_t		*nU5_51;
    U5_52		 pU5_52;
    jit_node_t		*nU5_52;
    U5_53		 pU5_53;
    jit_node_t		*nU5_53;
    U5_54		 pU5_54;
    jit_node_t		*nU5_54;
    U5_55		 pU5_55;
    jit_node_t		*nU5_55;
    U5_56		 pU5_56;
    jit_node_t		*nU5_56;
    U5_57		 pU5_57;
    jit_node_t		*nU5_57;
    U5_58		 pU5_58;
    jit_node_t		*nU5_58;
    U5_59		 pU5_59;
    jit_node_t		*nU5_59;
    /* Declare unsigned bitfields at offset 6 */
    U6_27		 pU6_27;
    jit_node_t		*nU6_27;
    U6_28		 pU6_28;
    jit_node_t		*nU6_28;
    U6_29		 pU6_29;
    jit_node_t		*nU6_29;
    U6_30		 pU6_30;
    jit_node_t		*nU6_30;
    U6_31		 pU6_31;
    jit_node_t		*nU6_31;
    U6_32		 pU6_32;
    jit_node_t		*nU6_32;
    U6_33		 pU6_33;
    jit_node_t		*nU6_33;
    U6_34		 pU6_34;
    jit_node_t		*nU6_34;
    U6_35		 pU6_35;
    jit_node_t		*nU6_35;
    U6_36		 pU6_36;
    jit_node_t		*nU6_36;
    U6_37		 pU6_37;
    jit_node_t		*nU6_37;
    U6_38		 pU6_38;
    jit_node_t		*nU6_38;
    U6_39		 pU6_39;
    jit_node_t		*nU6_39;
    U6_40		 pU6_40;
    jit_node_t		*nU6_40;
    U6_41		 pU6_41;
    jit_node_t		*nU6_41;
    U6_42		 pU6_42;
    jit_node_t		*nU6_42;
    U6_43		 pU6_43;
    jit_node_t		*nU6_43;
    U6_44		 pU6_44;
    jit_node_t		*nU6_44;
    U6_45		 pU6_45;
    jit_node_t		*nU6_45;
    U6_46		 pU6_46;
    jit_node_t		*nU6_46;
    U6_47		 pU6_47;
    jit_node_t		*nU6_47;
    U6_48		 pU6_48;
    jit_node_t		*nU6_48;
    U6_49		 pU6_49;
    jit_node_t		*nU6_49;
    U6_50		 pU6_50;
    jit_node_t		*nU6_50;
    U6_51		 pU6_51;
    jit_node_t		*nU6_51;
    U6_52		 pU6_52;
    jit_node_t		*nU6_52;
    U6_53		 pU6_53;
    jit_node_t		*nU6_53;
    U6_54		 pU6_54;
    jit_node_t		*nU6_54;
    U6_55		 pU6_55;
    jit_node_t		*nU6_55;
    U6_56		 pU6_56;
    jit_node_t		*nU6_56;
    U6_57		 pU6_57;
    jit_node_t		*nU6_57;
    U6_58		 pU6_58;
    jit_node_t		*nU6_58;
    /* Declare unsigned bitfields at offset 7 */
    U7_26		 pU7_26;
    jit_node_t		*nU7_26;
    U7_27		 pU7_27;
    jit_node_t		*nU7_27;
    U7_28		 pU7_28;
    jit_node_t		*nU7_28;
    U7_29		 pU7_29;
    jit_node_t		*nU7_29;
    U7_30		 pU7_30;
    jit_node_t		*nU7_30;
    U7_31		 pU7_31;
    jit_node_t		*nU7_31;
    U7_32		 pU7_32;
    jit_node_t		*nU7_32;
    U7_33		 pU7_33;
    jit_node_t		*nU7_33;
    U7_34		 pU7_34;
    jit_node_t		*nU7_34;
    U7_35		 pU7_35;
    jit_node_t		*nU7_35;
    U7_36		 pU7_36;
    jit_node_t		*nU7_36;
    U7_37		 pU7_37;
    jit_node_t		*nU7_37;
    U7_38		 pU7_38;
    jit_node_t		*nU7_38;
    U7_39		 pU7_39;
    jit_node_t		*nU7_39;
    U7_40		 pU7_40;
    jit_node_t		*nU7_40;
    U7_41		 pU7_41;
    jit_node_t		*nU7_41;
    U7_42		 pU7_42;
    jit_node_t		*nU7_42;
    U7_43		 pU7_43;
    jit_node_t		*nU7_43;
    U7_44		 pU7_44;
    jit_node_t		*nU7_44;
    U7_45		 pU7_45;
    jit_node_t		*nU7_45;
    U7_46		 pU7_46;
    jit_node_t		*nU7_46;
    U7_47		 pU7_47;
    jit_node_t		*nU7_47;
    U7_48		 pU7_48;
    jit_node_t		*nU7_48;
    U7_49		 pU7_49;
    jit_node_t		*nU7_49;
    U7_50		 pU7_50;
    jit_node_t		*nU7_50;
    U7_51		 pU7_51;
    jit_node_t		*nU7_51;
    U7_52		 pU7_52;
    jit_node_t		*nU7_52;
    U7_53		 pU7_53;
    jit_node_t		*nU7_53;
    U7_54		 pU7_54;
    jit_node_t		*nU7_54;
    U7_55		 pU7_55;
    jit_node_t		*nU7_55;
    U7_56		 pU7_56;
    jit_node_t		*nU7_56;
    U7_57		 pU7_57;
    jit_node_t		*nU7_57;
    /* Declare unsigned bitfields at offset 8 */
    U8_25		 pU8_25;
    jit_node_t		*nU8_25;
    U8_26		 pU8_26;
    jit_node_t		*nU8_26;
    U8_27		 pU8_27;
    jit_node_t		*nU8_27;
    U8_28		 pU8_28;
    jit_node_t		*nU8_28;
    U8_29		 pU8_29;
    jit_node_t		*nU8_29;
    U8_30		 pU8_30;
    jit_node_t		*nU8_30;
    U8_31		 pU8_31;
    jit_node_t		*nU8_31;
    U8_32		 pU8_32;
    jit_node_t		*nU8_32;
    U8_33		 pU8_33;
    jit_node_t		*nU8_33;
    U8_34		 pU8_34;
    jit_node_t		*nU8_34;
    U8_35		 pU8_35;
    jit_node_t		*nU8_35;
    U8_36		 pU8_36;
    jit_node_t		*nU8_36;
    U8_37		 pU8_37;
    jit_node_t		*nU8_37;
    U8_38		 pU8_38;
    jit_node_t		*nU8_38;
    U8_39		 pU8_39;
    jit_node_t		*nU8_39;
    U8_40		 pU8_40;
    jit_node_t		*nU8_40;
    U8_41		 pU8_41;
    jit_node_t		*nU8_41;
    U8_42		 pU8_42;
    jit_node_t		*nU8_42;
    U8_43		 pU8_43;
    jit_node_t		*nU8_43;
    U8_44		 pU8_44;
    jit_node_t		*nU8_44;
    U8_45		 pU8_45;
    jit_node_t		*nU8_45;
    U8_46		 pU8_46;
    jit_node_t		*nU8_46;
    U8_47		 pU8_47;
    jit_node_t		*nU8_47;
    U8_48		 pU8_48;
    jit_node_t		*nU8_48;
    U8_49		 pU8_49;
    jit_node_t		*nU8_49;
    U8_50		 pU8_50;
    jit_node_t		*nU8_50;
    U8_51		 pU8_51;
    jit_node_t		*nU8_51;
    U8_52		 pU8_52;
    jit_node_t		*nU8_52;
    U8_53		 pU8_53;
    jit_node_t		*nU8_53;
    U8_54		 pU8_54;
    jit_node_t		*nU8_54;
    U8_55		 pU8_55;
    jit_node_t		*nU8_55;
    U8_56		 pU8_56;
    jit_node_t		*nU8_56;
    /* Declare unsigned bitfields at offset 9 */
    U9_24		 pU9_24;
    jit_node_t		*nU9_24;
    U9_25		 pU9_25;
    jit_node_t		*nU9_25;
    U9_26		 pU9_26;
    jit_node_t		*nU9_26;
    U9_27		 pU9_27;
    jit_node_t		*nU9_27;
    U9_28		 pU9_28;
    jit_node_t		*nU9_28;
    U9_29		 pU9_29;
    jit_node_t		*nU9_29;
    U9_30		 pU9_30;
    jit_node_t		*nU9_30;
    U9_31		 pU9_31;
    jit_node_t		*nU9_31;
    U9_32		 pU9_32;
    jit_node_t		*nU9_32;
    U9_33		 pU9_33;
    jit_node_t		*nU9_33;
    U9_34		 pU9_34;
    jit_node_t		*nU9_34;
    U9_35		 pU9_35;
    jit_node_t		*nU9_35;
    U9_36		 pU9_36;
    jit_node_t		*nU9_36;
    U9_37		 pU9_37;
    jit_node_t		*nU9_37;
    U9_38		 pU9_38;
    jit_node_t		*nU9_38;
    U9_39		 pU9_39;
    jit_node_t		*nU9_39;
    U9_40		 pU9_40;
    jit_node_t		*nU9_40;
    U9_41		 pU9_41;
    jit_node_t		*nU9_41;
    U9_42		 pU9_42;
    jit_node_t		*nU9_42;
    U9_43		 pU9_43;
    jit_node_t		*nU9_43;
    U9_44		 pU9_44;
    jit_node_t		*nU9_44;
    U9_45		 pU9_45;
    jit_node_t		*nU9_45;
    U9_46		 pU9_46;
    jit_node_t		*nU9_46;
    U9_47		 pU9_47;
    jit_node_t		*nU9_47;
    U9_48		 pU9_48;
    jit_node_t		*nU9_48;
    U9_49		 pU9_49;
    jit_node_t		*nU9_49;
    U9_50		 pU9_50;
    jit_node_t		*nU9_50;
    U9_51		 pU9_51;
    jit_node_t		*nU9_51;
    U9_52		 pU9_52;
    jit_node_t		*nU9_52;
    U9_53		 pU9_53;
    jit_node_t		*nU9_53;
    U9_54		 pU9_54;
    jit_node_t		*nU9_54;
    U9_55		 pU9_55;
    jit_node_t		*nU9_55;
    /* Declare unsigned bitfields at offset 10 */
    U10_23		 pU10_23;
    jit_node_t		*nU10_23;
    U10_24		 pU10_24;
    jit_node_t		*nU10_24;
    U10_25		 pU10_25;
    jit_node_t		*nU10_25;
    U10_26		 pU10_26;
    jit_node_t		*nU10_26;
    U10_27		 pU10_27;
    jit_node_t		*nU10_27;
    U10_28		 pU10_28;
    jit_node_t		*nU10_28;
    U10_29		 pU10_29;
    jit_node_t		*nU10_29;
    U10_30		 pU10_30;
    jit_node_t		*nU10_30;
    U10_31		 pU10_31;
    jit_node_t		*nU10_31;
    U10_32		 pU10_32;
    jit_node_t		*nU10_32;
    U10_33		 pU10_33;
    jit_node_t		*nU10_33;
    U10_34		 pU10_34;
    jit_node_t		*nU10_34;
    U10_35		 pU10_35;
    jit_node_t		*nU10_35;
    U10_36		 pU10_36;
    jit_node_t		*nU10_36;
    U10_37		 pU10_37;
    jit_node_t		*nU10_37;
    U10_38		 pU10_38;
    jit_node_t		*nU10_38;
    U10_39		 pU10_39;
    jit_node_t		*nU10_39;
    U10_40		 pU10_40;
    jit_node_t		*nU10_40;
    U10_41		 pU10_41;
    jit_node_t		*nU10_41;
    U10_42		 pU10_42;
    jit_node_t		*nU10_42;
    U10_43		 pU10_43;
    jit_node_t		*nU10_43;
    U10_44		 pU10_44;
    jit_node_t		*nU10_44;
    U10_45		 pU10_45;
    jit_node_t		*nU10_45;
    U10_46		 pU10_46;
    jit_node_t		*nU10_46;
    U10_47		 pU10_47;
    jit_node_t		*nU10_47;
    U10_48		 pU10_48;
    jit_node_t		*nU10_48;
    U10_49		 pU10_49;
    jit_node_t		*nU10_49;
    U10_50		 pU10_50;
    jit_node_t		*nU10_50;
    U10_51		 pU10_51;
    jit_node_t		*nU10_51;
    U10_52		 pU10_52;
    jit_node_t		*nU10_52;
    U10_53		 pU10_53;
    jit_node_t		*nU10_53;
    U10_54		 pU10_54;
    jit_node_t		*nU10_54;
    /* Declare unsigned bitfields at offset 11 */
    U11_22		 pU11_22;
    jit_node_t		*nU11_22;
    U11_23		 pU11_23;
    jit_node_t		*nU11_23;
    U11_24		 pU11_24;
    jit_node_t		*nU11_24;
    U11_25		 pU11_25;
    jit_node_t		*nU11_25;
    U11_26		 pU11_26;
    jit_node_t		*nU11_26;
    U11_27		 pU11_27;
    jit_node_t		*nU11_27;
    U11_28		 pU11_28;
    jit_node_t		*nU11_28;
    U11_29		 pU11_29;
    jit_node_t		*nU11_29;
    U11_30		 pU11_30;
    jit_node_t		*nU11_30;
    U11_31		 pU11_31;
    jit_node_t		*nU11_31;
    U11_32		 pU11_32;
    jit_node_t		*nU11_32;
    U11_33		 pU11_33;
    jit_node_t		*nU11_33;
    U11_34		 pU11_34;
    jit_node_t		*nU11_34;
    U11_35		 pU11_35;
    jit_node_t		*nU11_35;
    U11_36		 pU11_36;
    jit_node_t		*nU11_36;
    U11_37		 pU11_37;
    jit_node_t		*nU11_37;
    U11_38		 pU11_38;
    jit_node_t		*nU11_38;
    U11_39		 pU11_39;
    jit_node_t		*nU11_39;
    U11_40		 pU11_40;
    jit_node_t		*nU11_40;
    U11_41		 pU11_41;
    jit_node_t		*nU11_41;
    U11_42		 pU11_42;
    jit_node_t		*nU11_42;
    U11_43		 pU11_43;
    jit_node_t		*nU11_43;
    U11_44		 pU11_44;
    jit_node_t		*nU11_44;
    U11_45		 pU11_45;
    jit_node_t		*nU11_45;
    U11_46		 pU11_46;
    jit_node_t		*nU11_46;
    U11_47		 pU11_47;
    jit_node_t		*nU11_47;
    U11_48		 pU11_48;
    jit_node_t		*nU11_48;
    U11_49		 pU11_49;
    jit_node_t		*nU11_49;
    U11_50		 pU11_50;
    jit_node_t		*nU11_50;
    U11_51		 pU11_51;
    jit_node_t		*nU11_51;
    U11_52		 pU11_52;
    jit_node_t		*nU11_52;
    U11_53		 pU11_53;
    jit_node_t		*nU11_53;
    /* Declare unsigned bitfields at offset 12 */
    U12_21		 pU12_21;
    jit_node_t		*nU12_21;
    U12_22		 pU12_22;
    jit_node_t		*nU12_22;
    U12_23		 pU12_23;
    jit_node_t		*nU12_23;
    U12_24		 pU12_24;
    jit_node_t		*nU12_24;
    U12_25		 pU12_25;
    jit_node_t		*nU12_25;
    U12_26		 pU12_26;
    jit_node_t		*nU12_26;
    U12_27		 pU12_27;
    jit_node_t		*nU12_27;
    U12_28		 pU12_28;
    jit_node_t		*nU12_28;
    U12_29		 pU12_29;
    jit_node_t		*nU12_29;
    U12_30		 pU12_30;
    jit_node_t		*nU12_30;
    U12_31		 pU12_31;
    jit_node_t		*nU12_31;
    U12_32		 pU12_32;
    jit_node_t		*nU12_32;
    U12_33		 pU12_33;
    jit_node_t		*nU12_33;
    U12_34		 pU12_34;
    jit_node_t		*nU12_34;
    U12_35		 pU12_35;
    jit_node_t		*nU12_35;
    U12_36		 pU12_36;
    jit_node_t		*nU12_36;
    U12_37		 pU12_37;
    jit_node_t		*nU12_37;
    U12_38		 pU12_38;
    jit_node_t		*nU12_38;
    U12_39		 pU12_39;
    jit_node_t		*nU12_39;
    U12_40		 pU12_40;
    jit_node_t		*nU12_40;
    U12_41		 pU12_41;
    jit_node_t		*nU12_41;
    U12_42		 pU12_42;
    jit_node_t		*nU12_42;
    U12_43		 pU12_43;
    jit_node_t		*nU12_43;
    U12_44		 pU12_44;
    jit_node_t		*nU12_44;
    U12_45		 pU12_45;
    jit_node_t		*nU12_45;
    U12_46		 pU12_46;
    jit_node_t		*nU12_46;
    U12_47		 pU12_47;
    jit_node_t		*nU12_47;
    U12_48		 pU12_48;
    jit_node_t		*nU12_48;
    U12_49		 pU12_49;
    jit_node_t		*nU12_49;
    U12_50		 pU12_50;
    jit_node_t		*nU12_50;
    U12_51		 pU12_51;
    jit_node_t		*nU12_51;
    U12_52		 pU12_52;
    jit_node_t		*nU12_52;
    /* Declare unsigned bitfields at offset 13 */
    U13_20		 pU13_20;
    jit_node_t		*nU13_20;
    U13_21		 pU13_21;
    jit_node_t		*nU13_21;
    U13_22		 pU13_22;
    jit_node_t		*nU13_22;
    U13_23		 pU13_23;
    jit_node_t		*nU13_23;
    U13_24		 pU13_24;
    jit_node_t		*nU13_24;
    U13_25		 pU13_25;
    jit_node_t		*nU13_25;
    U13_26		 pU13_26;
    jit_node_t		*nU13_26;
    U13_27		 pU13_27;
    jit_node_t		*nU13_27;
    U13_28		 pU13_28;
    jit_node_t		*nU13_28;
    U13_29		 pU13_29;
    jit_node_t		*nU13_29;
    U13_30		 pU13_30;
    jit_node_t		*nU13_30;
    U13_31		 pU13_31;
    jit_node_t		*nU13_31;
    U13_32		 pU13_32;
    jit_node_t		*nU13_32;
    U13_33		 pU13_33;
    jit_node_t		*nU13_33;
    U13_34		 pU13_34;
    jit_node_t		*nU13_34;
    U13_35		 pU13_35;
    jit_node_t		*nU13_35;
    U13_36		 pU13_36;
    jit_node_t		*nU13_36;
    U13_37		 pU13_37;
    jit_node_t		*nU13_37;
    U13_38		 pU13_38;
    jit_node_t		*nU13_38;
    U13_39		 pU13_39;
    jit_node_t		*nU13_39;
    U13_40		 pU13_40;
    jit_node_t		*nU13_40;
    U13_41		 pU13_41;
    jit_node_t		*nU13_41;
    U13_42		 pU13_42;
    jit_node_t		*nU13_42;
    U13_43		 pU13_43;
    jit_node_t		*nU13_43;
    U13_44		 pU13_44;
    jit_node_t		*nU13_44;
    U13_45		 pU13_45;
    jit_node_t		*nU13_45;
    U13_46		 pU13_46;
    jit_node_t		*nU13_46;
    U13_47		 pU13_47;
    jit_node_t		*nU13_47;
    U13_48		 pU13_48;
    jit_node_t		*nU13_48;
    U13_49		 pU13_49;
    jit_node_t		*nU13_49;
    U13_50		 pU13_50;
    jit_node_t		*nU13_50;
    U13_51		 pU13_51;
    jit_node_t		*nU13_51;
    /* Declare unsigned bitfields at offset 14 */
    U14_19		 pU14_19;
    jit_node_t		*nU14_19;
    U14_20		 pU14_20;
    jit_node_t		*nU14_20;
    U14_21		 pU14_21;
    jit_node_t		*nU14_21;
    U14_22		 pU14_22;
    jit_node_t		*nU14_22;
    U14_23		 pU14_23;
    jit_node_t		*nU14_23;
    U14_24		 pU14_24;
    jit_node_t		*nU14_24;
    U14_25		 pU14_25;
    jit_node_t		*nU14_25;
    U14_26		 pU14_26;
    jit_node_t		*nU14_26;
    U14_27		 pU14_27;
    jit_node_t		*nU14_27;
    U14_28		 pU14_28;
    jit_node_t		*nU14_28;
    U14_29		 pU14_29;
    jit_node_t		*nU14_29;
    U14_30		 pU14_30;
    jit_node_t		*nU14_30;
    U14_31		 pU14_31;
    jit_node_t		*nU14_31;
    U14_32		 pU14_32;
    jit_node_t		*nU14_32;
    U14_33		 pU14_33;
    jit_node_t		*nU14_33;
    U14_34		 pU14_34;
    jit_node_t		*nU14_34;
    U14_35		 pU14_35;
    jit_node_t		*nU14_35;
    U14_36		 pU14_36;
    jit_node_t		*nU14_36;
    U14_37		 pU14_37;
    jit_node_t		*nU14_37;
    U14_38		 pU14_38;
    jit_node_t		*nU14_38;
    U14_39		 pU14_39;
    jit_node_t		*nU14_39;
    U14_40		 pU14_40;
    jit_node_t		*nU14_40;
    U14_41		 pU14_41;
    jit_node_t		*nU14_41;
    U14_42		 pU14_42;
    jit_node_t		*nU14_42;
    U14_43		 pU14_43;
    jit_node_t		*nU14_43;
    U14_44		 pU14_44;
    jit_node_t		*nU14_44;
    U14_45		 pU14_45;
    jit_node_t		*nU14_45;
    U14_46		 pU14_46;
    jit_node_t		*nU14_46;
    U14_47		 pU14_47;
    jit_node_t		*nU14_47;
    U14_48		 pU14_48;
    jit_node_t		*nU14_48;
    U14_49		 pU14_49;
    jit_node_t		*nU14_49;
    U14_50		 pU14_50;
    jit_node_t		*nU14_50;
    /* Declare unsigned bitfields at offset 15 */
    U15_18		 pU15_18;
    jit_node_t		*nU15_18;
    U15_19		 pU15_19;
    jit_node_t		*nU15_19;
    U15_20		 pU15_20;
    jit_node_t		*nU15_20;
    U15_21		 pU15_21;
    jit_node_t		*nU15_21;
    U15_22		 pU15_22;
    jit_node_t		*nU15_22;
    U15_23		 pU15_23;
    jit_node_t		*nU15_23;
    U15_24		 pU15_24;
    jit_node_t		*nU15_24;
    U15_25		 pU15_25;
    jit_node_t		*nU15_25;
    U15_26		 pU15_26;
    jit_node_t		*nU15_26;
    U15_27		 pU15_27;
    jit_node_t		*nU15_27;
    U15_28		 pU15_28;
    jit_node_t		*nU15_28;
    U15_29		 pU15_29;
    jit_node_t		*nU15_29;
    U15_30		 pU15_30;
    jit_node_t		*nU15_30;
    U15_31		 pU15_31;
    jit_node_t		*nU15_31;
    U15_32		 pU15_32;
    jit_node_t		*nU15_32;
    U15_33		 pU15_33;
    jit_node_t		*nU15_33;
    U15_34		 pU15_34;
    jit_node_t		*nU15_34;
    U15_35		 pU15_35;
    jit_node_t		*nU15_35;
    U15_36		 pU15_36;
    jit_node_t		*nU15_36;
    U15_37		 pU15_37;
    jit_node_t		*nU15_37;
    U15_38		 pU15_38;
    jit_node_t		*nU15_38;
    U15_39		 pU15_39;
    jit_node_t		*nU15_39;
    U15_40		 pU15_40;
    jit_node_t		*nU15_40;
    U15_41		 pU15_41;
    jit_node_t		*nU15_41;
    U15_42		 pU15_42;
    jit_node_t		*nU15_42;
    U15_43		 pU15_43;
    jit_node_t		*nU15_43;
    U15_44		 pU15_44;
    jit_node_t		*nU15_44;
    U15_45		 pU15_45;
    jit_node_t		*nU15_45;
    U15_46		 pU15_46;
    jit_node_t		*nU15_46;
    U15_47		 pU15_47;
    jit_node_t		*nU15_47;
    U15_48		 pU15_48;
    jit_node_t		*nU15_48;
    U15_49		 pU15_49;
    jit_node_t		*nU15_49;
    /* Declare unsigned bitfields at offset 16 */
    U16_17		 pU16_17;
    jit_node_t		*nU16_17;
    U16_18		 pU16_18;
    jit_node_t		*nU16_18;
    U16_19		 pU16_19;
    jit_node_t		*nU16_19;
    U16_20		 pU16_20;
    jit_node_t		*nU16_20;
    U16_21		 pU16_21;
    jit_node_t		*nU16_21;
    U16_22		 pU16_22;
    jit_node_t		*nU16_22;
    U16_23		 pU16_23;
    jit_node_t		*nU16_23;
    U16_24		 pU16_24;
    jit_node_t		*nU16_24;
    U16_25		 pU16_25;
    jit_node_t		*nU16_25;
    U16_26		 pU16_26;
    jit_node_t		*nU16_26;
    U16_27		 pU16_27;
    jit_node_t		*nU16_27;
    U16_28		 pU16_28;
    jit_node_t		*nU16_28;
    U16_29		 pU16_29;
    jit_node_t		*nU16_29;
    U16_30		 pU16_30;
    jit_node_t		*nU16_30;
    U16_31		 pU16_31;
    jit_node_t		*nU16_31;
    U16_32		 pU16_32;
    jit_node_t		*nU16_32;
    U16_33		 pU16_33;
    jit_node_t		*nU16_33;
    U16_34		 pU16_34;
    jit_node_t		*nU16_34;
    U16_35		 pU16_35;
    jit_node_t		*nU16_35;
    U16_36		 pU16_36;
    jit_node_t		*nU16_36;
    U16_37		 pU16_37;
    jit_node_t		*nU16_37;
    U16_38		 pU16_38;
    jit_node_t		*nU16_38;
    U16_39		 pU16_39;
    jit_node_t		*nU16_39;
    U16_40		 pU16_40;
    jit_node_t		*nU16_40;
    U16_41		 pU16_41;
    jit_node_t		*nU16_41;
    U16_42		 pU16_42;
    jit_node_t		*nU16_42;
    U16_43		 pU16_43;
    jit_node_t		*nU16_43;
    U16_44		 pU16_44;
    jit_node_t		*nU16_44;
    U16_45		 pU16_45;
    jit_node_t		*nU16_45;
    U16_46		 pU16_46;
    jit_node_t		*nU16_46;
    U16_47		 pU16_47;
    jit_node_t		*nU16_47;
    U16_48		 pU16_48;
    jit_node_t		*nU16_48;
    /* Declare unsigned bitfields at offset 17 */
    U17_16		 pU17_16;
    jit_node_t		*nU17_16;
    U17_17		 pU17_17;
    jit_node_t		*nU17_17;
    U17_18		 pU17_18;
    jit_node_t		*nU17_18;
    U17_19		 pU17_19;
    jit_node_t		*nU17_19;
    U17_20		 pU17_20;
    jit_node_t		*nU17_20;
    U17_21		 pU17_21;
    jit_node_t		*nU17_21;
    U17_22		 pU17_22;
    jit_node_t		*nU17_22;
    U17_23		 pU17_23;
    jit_node_t		*nU17_23;
    U17_24		 pU17_24;
    jit_node_t		*nU17_24;
    U17_25		 pU17_25;
    jit_node_t		*nU17_25;
    U17_26		 pU17_26;
    jit_node_t		*nU17_26;
    U17_27		 pU17_27;
    jit_node_t		*nU17_27;
    U17_28		 pU17_28;
    jit_node_t		*nU17_28;
    U17_29		 pU17_29;
    jit_node_t		*nU17_29;
    U17_30		 pU17_30;
    jit_node_t		*nU17_30;
    U17_31		 pU17_31;
    jit_node_t		*nU17_31;
    U17_32		 pU17_32;
    jit_node_t		*nU17_32;
    U17_33		 pU17_33;
    jit_node_t		*nU17_33;
    U17_34		 pU17_34;
    jit_node_t		*nU17_34;
    U17_35		 pU17_35;
    jit_node_t		*nU17_35;
    U17_36		 pU17_36;
    jit_node_t		*nU17_36;
    U17_37		 pU17_37;
    jit_node_t		*nU17_37;
    U17_38		 pU17_38;
    jit_node_t		*nU17_38;
    U17_39		 pU17_39;
    jit_node_t		*nU17_39;
    U17_40		 pU17_40;
    jit_node_t		*nU17_40;
    U17_41		 pU17_41;
    jit_node_t		*nU17_41;
    U17_42		 pU17_42;
    jit_node_t		*nU17_42;
    U17_43		 pU17_43;
    jit_node_t		*nU17_43;
    U17_44		 pU17_44;
    jit_node_t		*nU17_44;
    U17_45		 pU17_45;
    jit_node_t		*nU17_45;
    U17_46		 pU17_46;
    jit_node_t		*nU17_46;
    U17_47		 pU17_47;
    jit_node_t		*nU17_47;
    /* Declare unsigned bitfields at offset 18 */
    U18_15		 pU18_15;
    jit_node_t		*nU18_15;
    U18_16		 pU18_16;
    jit_node_t		*nU18_16;
    U18_17		 pU18_17;
    jit_node_t		*nU18_17;
    U18_18		 pU18_18;
    jit_node_t		*nU18_18;
    U18_19		 pU18_19;
    jit_node_t		*nU18_19;
    U18_20		 pU18_20;
    jit_node_t		*nU18_20;
    U18_21		 pU18_21;
    jit_node_t		*nU18_21;
    U18_22		 pU18_22;
    jit_node_t		*nU18_22;
    U18_23		 pU18_23;
    jit_node_t		*nU18_23;
    U18_24		 pU18_24;
    jit_node_t		*nU18_24;
    U18_25		 pU18_25;
    jit_node_t		*nU18_25;
    U18_26		 pU18_26;
    jit_node_t		*nU18_26;
    U18_27		 pU18_27;
    jit_node_t		*nU18_27;
    U18_28		 pU18_28;
    jit_node_t		*nU18_28;
    U18_29		 pU18_29;
    jit_node_t		*nU18_29;
    U18_30		 pU18_30;
    jit_node_t		*nU18_30;
    U18_31		 pU18_31;
    jit_node_t		*nU18_31;
    U18_32		 pU18_32;
    jit_node_t		*nU18_32;
    U18_33		 pU18_33;
    jit_node_t		*nU18_33;
    U18_34		 pU18_34;
    jit_node_t		*nU18_34;
    U18_35		 pU18_35;
    jit_node_t		*nU18_35;
    U18_36		 pU18_36;
    jit_node_t		*nU18_36;
    U18_37		 pU18_37;
    jit_node_t		*nU18_37;
    U18_38		 pU18_38;
    jit_node_t		*nU18_38;
    U18_39		 pU18_39;
    jit_node_t		*nU18_39;
    U18_40		 pU18_40;
    jit_node_t		*nU18_40;
    U18_41		 pU18_41;
    jit_node_t		*nU18_41;
    U18_42		 pU18_42;
    jit_node_t		*nU18_42;
    U18_43		 pU18_43;
    jit_node_t		*nU18_43;
    U18_44		 pU18_44;
    jit_node_t		*nU18_44;
    U18_45		 pU18_45;
    jit_node_t		*nU18_45;
    U18_46		 pU18_46;
    jit_node_t		*nU18_46;
    /* Declare unsigned bitfields at offset 19 */
    U19_14		 pU19_14;
    jit_node_t		*nU19_14;
    U19_15		 pU19_15;
    jit_node_t		*nU19_15;
    U19_16		 pU19_16;
    jit_node_t		*nU19_16;
    U19_17		 pU19_17;
    jit_node_t		*nU19_17;
    U19_18		 pU19_18;
    jit_node_t		*nU19_18;
    U19_19		 pU19_19;
    jit_node_t		*nU19_19;
    U19_20		 pU19_20;
    jit_node_t		*nU19_20;
    U19_21		 pU19_21;
    jit_node_t		*nU19_21;
    U19_22		 pU19_22;
    jit_node_t		*nU19_22;
    U19_23		 pU19_23;
    jit_node_t		*nU19_23;
    U19_24		 pU19_24;
    jit_node_t		*nU19_24;
    U19_25		 pU19_25;
    jit_node_t		*nU19_25;
    U19_26		 pU19_26;
    jit_node_t		*nU19_26;
    U19_27		 pU19_27;
    jit_node_t		*nU19_27;
    U19_28		 pU19_28;
    jit_node_t		*nU19_28;
    U19_29		 pU19_29;
    jit_node_t		*nU19_29;
    U19_30		 pU19_30;
    jit_node_t		*nU19_30;
    U19_31		 pU19_31;
    jit_node_t		*nU19_31;
    U19_32		 pU19_32;
    jit_node_t		*nU19_32;
    U19_33		 pU19_33;
    jit_node_t		*nU19_33;
    U19_34		 pU19_34;
    jit_node_t		*nU19_34;
    U19_35		 pU19_35;
    jit_node_t		*nU19_35;
    U19_36		 pU19_36;
    jit_node_t		*nU19_36;
    U19_37		 pU19_37;
    jit_node_t		*nU19_37;
    U19_38		 pU19_38;
    jit_node_t		*nU19_38;
    U19_39		 pU19_39;
    jit_node_t		*nU19_39;
    U19_40		 pU19_40;
    jit_node_t		*nU19_40;
    U19_41		 pU19_41;
    jit_node_t		*nU19_41;
    U19_42		 pU19_42;
    jit_node_t		*nU19_42;
    U19_43		 pU19_43;
    jit_node_t		*nU19_43;
    U19_44		 pU19_44;
    jit_node_t		*nU19_44;
    U19_45		 pU19_45;
    jit_node_t		*nU19_45;
    /* Declare unsigned bitfields at offset 20 */
    U20_13		 pU20_13;
    jit_node_t		*nU20_13;
    U20_14		 pU20_14;
    jit_node_t		*nU20_14;
    U20_15		 pU20_15;
    jit_node_t		*nU20_15;
    U20_16		 pU20_16;
    jit_node_t		*nU20_16;
    U20_17		 pU20_17;
    jit_node_t		*nU20_17;
    U20_18		 pU20_18;
    jit_node_t		*nU20_18;
    U20_19		 pU20_19;
    jit_node_t		*nU20_19;
    U20_20		 pU20_20;
    jit_node_t		*nU20_20;
    U20_21		 pU20_21;
    jit_node_t		*nU20_21;
    U20_22		 pU20_22;
    jit_node_t		*nU20_22;
    U20_23		 pU20_23;
    jit_node_t		*nU20_23;
    U20_24		 pU20_24;
    jit_node_t		*nU20_24;
    U20_25		 pU20_25;
    jit_node_t		*nU20_25;
    U20_26		 pU20_26;
    jit_node_t		*nU20_26;
    U20_27		 pU20_27;
    jit_node_t		*nU20_27;
    U20_28		 pU20_28;
    jit_node_t		*nU20_28;
    U20_29		 pU20_29;
    jit_node_t		*nU20_29;
    U20_30		 pU20_30;
    jit_node_t		*nU20_30;
    U20_31		 pU20_31;
    jit_node_t		*nU20_31;
    U20_32		 pU20_32;
    jit_node_t		*nU20_32;
    U20_33		 pU20_33;
    jit_node_t		*nU20_33;
    U20_34		 pU20_34;
    jit_node_t		*nU20_34;
    U20_35		 pU20_35;
    jit_node_t		*nU20_35;
    U20_36		 pU20_36;
    jit_node_t		*nU20_36;
    U20_37		 pU20_37;
    jit_node_t		*nU20_37;
    U20_38		 pU20_38;
    jit_node_t		*nU20_38;
    U20_39		 pU20_39;
    jit_node_t		*nU20_39;
    U20_40		 pU20_40;
    jit_node_t		*nU20_40;
    U20_41		 pU20_41;
    jit_node_t		*nU20_41;
    U20_42		 pU20_42;
    jit_node_t		*nU20_42;
    U20_43		 pU20_43;
    jit_node_t		*nU20_43;
    U20_44		 pU20_44;
    jit_node_t		*nU20_44;
    /* Declare unsigned bitfields at offset 21 */
    U21_12		 pU21_12;
    jit_node_t		*nU21_12;
    U21_13		 pU21_13;
    jit_node_t		*nU21_13;
    U21_14		 pU21_14;
    jit_node_t		*nU21_14;
    U21_15		 pU21_15;
    jit_node_t		*nU21_15;
    U21_16		 pU21_16;
    jit_node_t		*nU21_16;
    U21_17		 pU21_17;
    jit_node_t		*nU21_17;
    U21_18		 pU21_18;
    jit_node_t		*nU21_18;
    U21_19		 pU21_19;
    jit_node_t		*nU21_19;
    U21_20		 pU21_20;
    jit_node_t		*nU21_20;
    U21_21		 pU21_21;
    jit_node_t		*nU21_21;
    U21_22		 pU21_22;
    jit_node_t		*nU21_22;
    U21_23		 pU21_23;
    jit_node_t		*nU21_23;
    U21_24		 pU21_24;
    jit_node_t		*nU21_24;
    U21_25		 pU21_25;
    jit_node_t		*nU21_25;
    U21_26		 pU21_26;
    jit_node_t		*nU21_26;
    U21_27		 pU21_27;
    jit_node_t		*nU21_27;
    U21_28		 pU21_28;
    jit_node_t		*nU21_28;
    U21_29		 pU21_29;
    jit_node_t		*nU21_29;
    U21_30		 pU21_30;
    jit_node_t		*nU21_30;
    U21_31		 pU21_31;
    jit_node_t		*nU21_31;
    U21_32		 pU21_32;
    jit_node_t		*nU21_32;
    U21_33		 pU21_33;
    jit_node_t		*nU21_33;
    U21_34		 pU21_34;
    jit_node_t		*nU21_34;
    U21_35		 pU21_35;
    jit_node_t		*nU21_35;
    U21_36		 pU21_36;
    jit_node_t		*nU21_36;
    U21_37		 pU21_37;
    jit_node_t		*nU21_37;
    U21_38		 pU21_38;
    jit_node_t		*nU21_38;
    U21_39		 pU21_39;
    jit_node_t		*nU21_39;
    U21_40		 pU21_40;
    jit_node_t		*nU21_40;
    U21_41		 pU21_41;
    jit_node_t		*nU21_41;
    U21_42		 pU21_42;
    jit_node_t		*nU21_42;
    U21_43		 pU21_43;
    jit_node_t		*nU21_43;
    /* Declare unsigned bitfields at offset 22 */
    U22_11		 pU22_11;
    jit_node_t		*nU22_11;
    U22_12		 pU22_12;
    jit_node_t		*nU22_12;
    U22_13		 pU22_13;
    jit_node_t		*nU22_13;
    U22_14		 pU22_14;
    jit_node_t		*nU22_14;
    U22_15		 pU22_15;
    jit_node_t		*nU22_15;
    U22_16		 pU22_16;
    jit_node_t		*nU22_16;
    U22_17		 pU22_17;
    jit_node_t		*nU22_17;
    U22_18		 pU22_18;
    jit_node_t		*nU22_18;
    U22_19		 pU22_19;
    jit_node_t		*nU22_19;
    U22_20		 pU22_20;
    jit_node_t		*nU22_20;
    U22_21		 pU22_21;
    jit_node_t		*nU22_21;
    U22_22		 pU22_22;
    jit_node_t		*nU22_22;
    U22_23		 pU22_23;
    jit_node_t		*nU22_23;
    U22_24		 pU22_24;
    jit_node_t		*nU22_24;
    U22_25		 pU22_25;
    jit_node_t		*nU22_25;
    U22_26		 pU22_26;
    jit_node_t		*nU22_26;
    U22_27		 pU22_27;
    jit_node_t		*nU22_27;
    U22_28		 pU22_28;
    jit_node_t		*nU22_28;
    U22_29		 pU22_29;
    jit_node_t		*nU22_29;
    U22_30		 pU22_30;
    jit_node_t		*nU22_30;
    U22_31		 pU22_31;
    jit_node_t		*nU22_31;
    U22_32		 pU22_32;
    jit_node_t		*nU22_32;
    U22_33		 pU22_33;
    jit_node_t		*nU22_33;
    U22_34		 pU22_34;
    jit_node_t		*nU22_34;
    U22_35		 pU22_35;
    jit_node_t		*nU22_35;
    U22_36		 pU22_36;
    jit_node_t		*nU22_36;
    U22_37		 pU22_37;
    jit_node_t		*nU22_37;
    U22_38		 pU22_38;
    jit_node_t		*nU22_38;
    U22_39		 pU22_39;
    jit_node_t		*nU22_39;
    U22_40		 pU22_40;
    jit_node_t		*nU22_40;
    U22_41		 pU22_41;
    jit_node_t		*nU22_41;
    U22_42		 pU22_42;
    jit_node_t		*nU22_42;
    /* Declare unsigned bitfields at offset 23 */
    U23_10		 pU23_10;
    jit_node_t		*nU23_10;
    U23_11		 pU23_11;
    jit_node_t		*nU23_11;
    U23_12		 pU23_12;
    jit_node_t		*nU23_12;
    U23_13		 pU23_13;
    jit_node_t		*nU23_13;
    U23_14		 pU23_14;
    jit_node_t		*nU23_14;
    U23_15		 pU23_15;
    jit_node_t		*nU23_15;
    U23_16		 pU23_16;
    jit_node_t		*nU23_16;
    U23_17		 pU23_17;
    jit_node_t		*nU23_17;
    U23_18		 pU23_18;
    jit_node_t		*nU23_18;
    U23_19		 pU23_19;
    jit_node_t		*nU23_19;
    U23_20		 pU23_20;
    jit_node_t		*nU23_20;
    U23_21		 pU23_21;
    jit_node_t		*nU23_21;
    U23_22		 pU23_22;
    jit_node_t		*nU23_22;
    U23_23		 pU23_23;
    jit_node_t		*nU23_23;
    U23_24		 pU23_24;
    jit_node_t		*nU23_24;
    U23_25		 pU23_25;
    jit_node_t		*nU23_25;
    U23_26		 pU23_26;
    jit_node_t		*nU23_26;
    U23_27		 pU23_27;
    jit_node_t		*nU23_27;
    U23_28		 pU23_28;
    jit_node_t		*nU23_28;
    U23_29		 pU23_29;
    jit_node_t		*nU23_29;
    U23_30		 pU23_30;
    jit_node_t		*nU23_30;
    U23_31		 pU23_31;
    jit_node_t		*nU23_31;
    U23_32		 pU23_32;
    jit_node_t		*nU23_32;
    U23_33		 pU23_33;
    jit_node_t		*nU23_33;
    U23_34		 pU23_34;
    jit_node_t		*nU23_34;
    U23_35		 pU23_35;
    jit_node_t		*nU23_35;
    U23_36		 pU23_36;
    jit_node_t		*nU23_36;
    U23_37		 pU23_37;
    jit_node_t		*nU23_37;
    U23_38		 pU23_38;
    jit_node_t		*nU23_38;
    U23_39		 pU23_39;
    jit_node_t		*nU23_39;
    U23_40		 pU23_40;
    jit_node_t		*nU23_40;
    U23_41		 pU23_41;
    jit_node_t		*nU23_41;
    /* Declare unsigned bitfields at offset 24 */
    U24_9		 pU24_9;
    jit_node_t		*nU24_9;
    U24_10		 pU24_10;
    jit_node_t		*nU24_10;
    U24_11		 pU24_11;
    jit_node_t		*nU24_11;
    U24_12		 pU24_12;
    jit_node_t		*nU24_12;
    U24_13		 pU24_13;
    jit_node_t		*nU24_13;
    U24_14		 pU24_14;
    jit_node_t		*nU24_14;
    U24_15		 pU24_15;
    jit_node_t		*nU24_15;
    U24_16		 pU24_16;
    jit_node_t		*nU24_16;
    U24_17		 pU24_17;
    jit_node_t		*nU24_17;
    U24_18		 pU24_18;
    jit_node_t		*nU24_18;
    U24_19		 pU24_19;
    jit_node_t		*nU24_19;
    U24_20		 pU24_20;
    jit_node_t		*nU24_20;
    U24_21		 pU24_21;
    jit_node_t		*nU24_21;
    U24_22		 pU24_22;
    jit_node_t		*nU24_22;
    U24_23		 pU24_23;
    jit_node_t		*nU24_23;
    U24_24		 pU24_24;
    jit_node_t		*nU24_24;
    U24_25		 pU24_25;
    jit_node_t		*nU24_25;
    U24_26		 pU24_26;
    jit_node_t		*nU24_26;
    U24_27		 pU24_27;
    jit_node_t		*nU24_27;
    U24_28		 pU24_28;
    jit_node_t		*nU24_28;
    U24_29		 pU24_29;
    jit_node_t		*nU24_29;
    U24_30		 pU24_30;
    jit_node_t		*nU24_30;
    U24_31		 pU24_31;
    jit_node_t		*nU24_31;
    U24_32		 pU24_32;
    jit_node_t		*nU24_32;
    U24_33		 pU24_33;
    jit_node_t		*nU24_33;
    U24_34		 pU24_34;
    jit_node_t		*nU24_34;
    U24_35		 pU24_35;
    jit_node_t		*nU24_35;
    U24_36		 pU24_36;
    jit_node_t		*nU24_36;
    U24_37		 pU24_37;
    jit_node_t		*nU24_37;
    U24_38		 pU24_38;
    jit_node_t		*nU24_38;
    U24_39		 pU24_39;
    jit_node_t		*nU24_39;
    U24_40		 pU24_40;
    jit_node_t		*nU24_40;
    /* Declare unsigned bitfields at offset 25 */
    U25_8		 pU25_8;
    jit_node_t		*nU25_8;
    U25_9		 pU25_9;
    jit_node_t		*nU25_9;
    U25_10		 pU25_10;
    jit_node_t		*nU25_10;
    U25_11		 pU25_11;
    jit_node_t		*nU25_11;
    U25_12		 pU25_12;
    jit_node_t		*nU25_12;
    U25_13		 pU25_13;
    jit_node_t		*nU25_13;
    U25_14		 pU25_14;
    jit_node_t		*nU25_14;
    U25_15		 pU25_15;
    jit_node_t		*nU25_15;
    U25_16		 pU25_16;
    jit_node_t		*nU25_16;
    U25_17		 pU25_17;
    jit_node_t		*nU25_17;
    U25_18		 pU25_18;
    jit_node_t		*nU25_18;
    U25_19		 pU25_19;
    jit_node_t		*nU25_19;
    U25_20		 pU25_20;
    jit_node_t		*nU25_20;
    U25_21		 pU25_21;
    jit_node_t		*nU25_21;
    U25_22		 pU25_22;
    jit_node_t		*nU25_22;
    U25_23		 pU25_23;
    jit_node_t		*nU25_23;
    U25_24		 pU25_24;
    jit_node_t		*nU25_24;
    U25_25		 pU25_25;
    jit_node_t		*nU25_25;
    U25_26		 pU25_26;
    jit_node_t		*nU25_26;
    U25_27		 pU25_27;
    jit_node_t		*nU25_27;
    U25_28		 pU25_28;
    jit_node_t		*nU25_28;
    U25_29		 pU25_29;
    jit_node_t		*nU25_29;
    U25_30		 pU25_30;
    jit_node_t		*nU25_30;
    U25_31		 pU25_31;
    jit_node_t		*nU25_31;
    U25_32		 pU25_32;
    jit_node_t		*nU25_32;
    U25_33		 pU25_33;
    jit_node_t		*nU25_33;
    U25_34		 pU25_34;
    jit_node_t		*nU25_34;
    U25_35		 pU25_35;
    jit_node_t		*nU25_35;
    U25_36		 pU25_36;
    jit_node_t		*nU25_36;
    U25_37		 pU25_37;
    jit_node_t		*nU25_37;
    U25_38		 pU25_38;
    jit_node_t		*nU25_38;
    U25_39		 pU25_39;
    jit_node_t		*nU25_39;
    /* Declare unsigned bitfields at offset 26 */
    U26_7		 pU26_7;
    jit_node_t		*nU26_7;
    U26_8		 pU26_8;
    jit_node_t		*nU26_8;
    U26_9		 pU26_9;
    jit_node_t		*nU26_9;
    U26_10		 pU26_10;
    jit_node_t		*nU26_10;
    U26_11		 pU26_11;
    jit_node_t		*nU26_11;
    U26_12		 pU26_12;
    jit_node_t		*nU26_12;
    U26_13		 pU26_13;
    jit_node_t		*nU26_13;
    U26_14		 pU26_14;
    jit_node_t		*nU26_14;
    U26_15		 pU26_15;
    jit_node_t		*nU26_15;
    U26_16		 pU26_16;
    jit_node_t		*nU26_16;
    U26_17		 pU26_17;
    jit_node_t		*nU26_17;
    U26_18		 pU26_18;
    jit_node_t		*nU26_18;
    U26_19		 pU26_19;
    jit_node_t		*nU26_19;
    U26_20		 pU26_20;
    jit_node_t		*nU26_20;
    U26_21		 pU26_21;
    jit_node_t		*nU26_21;
    U26_22		 pU26_22;
    jit_node_t		*nU26_22;
    U26_23		 pU26_23;
    jit_node_t		*nU26_23;
    U26_24		 pU26_24;
    jit_node_t		*nU26_24;
    U26_25		 pU26_25;
    jit_node_t		*nU26_25;
    U26_26		 pU26_26;
    jit_node_t		*nU26_26;
    U26_27		 pU26_27;
    jit_node_t		*nU26_27;
    U26_28		 pU26_28;
    jit_node_t		*nU26_28;
    U26_29		 pU26_29;
    jit_node_t		*nU26_29;
    U26_30		 pU26_30;
    jit_node_t		*nU26_30;
    U26_31		 pU26_31;
    jit_node_t		*nU26_31;
    U26_32		 pU26_32;
    jit_node_t		*nU26_32;
    U26_33		 pU26_33;
    jit_node_t		*nU26_33;
    U26_34		 pU26_34;
    jit_node_t		*nU26_34;
    U26_35		 pU26_35;
    jit_node_t		*nU26_35;
    U26_36		 pU26_36;
    jit_node_t		*nU26_36;
    U26_37		 pU26_37;
    jit_node_t		*nU26_37;
    U26_38		 pU26_38;
    jit_node_t		*nU26_38;
    /* Declare unsigned bitfields at offset 27 */
    U27_6		 pU27_6;
    jit_node_t		*nU27_6;
    U27_7		 pU27_7;
    jit_node_t		*nU27_7;
    U27_8		 pU27_8;
    jit_node_t		*nU27_8;
    U27_9		 pU27_9;
    jit_node_t		*nU27_9;
    U27_10		 pU27_10;
    jit_node_t		*nU27_10;
    U27_11		 pU27_11;
    jit_node_t		*nU27_11;
    U27_12		 pU27_12;
    jit_node_t		*nU27_12;
    U27_13		 pU27_13;
    jit_node_t		*nU27_13;
    U27_14		 pU27_14;
    jit_node_t		*nU27_14;
    U27_15		 pU27_15;
    jit_node_t		*nU27_15;
    U27_16		 pU27_16;
    jit_node_t		*nU27_16;
    U27_17		 pU27_17;
    jit_node_t		*nU27_17;
    U27_18		 pU27_18;
    jit_node_t		*nU27_18;
    U27_19		 pU27_19;
    jit_node_t		*nU27_19;
    U27_20		 pU27_20;
    jit_node_t		*nU27_20;
    U27_21		 pU27_21;
    jit_node_t		*nU27_21;
    U27_22		 pU27_22;
    jit_node_t		*nU27_22;
    U27_23		 pU27_23;
    jit_node_t		*nU27_23;
    U27_24		 pU27_24;
    jit_node_t		*nU27_24;
    U27_25		 pU27_25;
    jit_node_t		*nU27_25;
    U27_26		 pU27_26;
    jit_node_t		*nU27_26;
    U27_27		 pU27_27;
    jit_node_t		*nU27_27;
    U27_28		 pU27_28;
    jit_node_t		*nU27_28;
    U27_29		 pU27_29;
    jit_node_t		*nU27_29;
    U27_30		 pU27_30;
    jit_node_t		*nU27_30;
    U27_31		 pU27_31;
    jit_node_t		*nU27_31;
    U27_32		 pU27_32;
    jit_node_t		*nU27_32;
    U27_33		 pU27_33;
    jit_node_t		*nU27_33;
    U27_34		 pU27_34;
    jit_node_t		*nU27_34;
    U27_35		 pU27_35;
    jit_node_t		*nU27_35;
    U27_36		 pU27_36;
    jit_node_t		*nU27_36;
    U27_37		 pU27_37;
    jit_node_t		*nU27_37;
    /* Declare unsigned bitfields at offset 28 */
    U28_5		 pU28_5;
    jit_node_t		*nU28_5;
    U28_6		 pU28_6;
    jit_node_t		*nU28_6;
    U28_7		 pU28_7;
    jit_node_t		*nU28_7;
    U28_8		 pU28_8;
    jit_node_t		*nU28_8;
    U28_9		 pU28_9;
    jit_node_t		*nU28_9;
    U28_10		 pU28_10;
    jit_node_t		*nU28_10;
    U28_11		 pU28_11;
    jit_node_t		*nU28_11;
    U28_12		 pU28_12;
    jit_node_t		*nU28_12;
    U28_13		 pU28_13;
    jit_node_t		*nU28_13;
    U28_14		 pU28_14;
    jit_node_t		*nU28_14;
    U28_15		 pU28_15;
    jit_node_t		*nU28_15;
    U28_16		 pU28_16;
    jit_node_t		*nU28_16;
    U28_17		 pU28_17;
    jit_node_t		*nU28_17;
    U28_18		 pU28_18;
    jit_node_t		*nU28_18;
    U28_19		 pU28_19;
    jit_node_t		*nU28_19;
    U28_20		 pU28_20;
    jit_node_t		*nU28_20;
    U28_21		 pU28_21;
    jit_node_t		*nU28_21;
    U28_22		 pU28_22;
    jit_node_t		*nU28_22;
    U28_23		 pU28_23;
    jit_node_t		*nU28_23;
    U28_24		 pU28_24;
    jit_node_t		*nU28_24;
    U28_25		 pU28_25;
    jit_node_t		*nU28_25;
    U28_26		 pU28_26;
    jit_node_t		*nU28_26;
    U28_27		 pU28_27;
    jit_node_t		*nU28_27;
    U28_28		 pU28_28;
    jit_node_t		*nU28_28;
    U28_29		 pU28_29;
    jit_node_t		*nU28_29;
    U28_30		 pU28_30;
    jit_node_t		*nU28_30;
    U28_31		 pU28_31;
    jit_node_t		*nU28_31;
    U28_32		 pU28_32;
    jit_node_t		*nU28_32;
    U28_33		 pU28_33;
    jit_node_t		*nU28_33;
    U28_34		 pU28_34;
    jit_node_t		*nU28_34;
    U28_35		 pU28_35;
    jit_node_t		*nU28_35;
    U28_36		 pU28_36;
    jit_node_t		*nU28_36;
    /* Declare unsigned bitfields at offset 29 */
    U29_4		 pU29_4;
    jit_node_t		*nU29_4;
    U29_5		 pU29_5;
    jit_node_t		*nU29_5;
    U29_6		 pU29_6;
    jit_node_t		*nU29_6;
    U29_7		 pU29_7;
    jit_node_t		*nU29_7;
    U29_8		 pU29_8;
    jit_node_t		*nU29_8;
    U29_9		 pU29_9;
    jit_node_t		*nU29_9;
    U29_10		 pU29_10;
    jit_node_t		*nU29_10;
    U29_11		 pU29_11;
    jit_node_t		*nU29_11;
    U29_12		 pU29_12;
    jit_node_t		*nU29_12;
    U29_13		 pU29_13;
    jit_node_t		*nU29_13;
    U29_14		 pU29_14;
    jit_node_t		*nU29_14;
    U29_15		 pU29_15;
    jit_node_t		*nU29_15;
    U29_16		 pU29_16;
    jit_node_t		*nU29_16;
    U29_17		 pU29_17;
    jit_node_t		*nU29_17;
    U29_18		 pU29_18;
    jit_node_t		*nU29_18;
    U29_19		 pU29_19;
    jit_node_t		*nU29_19;
    U29_20		 pU29_20;
    jit_node_t		*nU29_20;
    U29_21		 pU29_21;
    jit_node_t		*nU29_21;
    U29_22		 pU29_22;
    jit_node_t		*nU29_22;
    U29_23		 pU29_23;
    jit_node_t		*nU29_23;
    U29_24		 pU29_24;
    jit_node_t		*nU29_24;
    U29_25		 pU29_25;
    jit_node_t		*nU29_25;
    U29_26		 pU29_26;
    jit_node_t		*nU29_26;
    U29_27		 pU29_27;
    jit_node_t		*nU29_27;
    U29_28		 pU29_28;
    jit_node_t		*nU29_28;
    U29_29		 pU29_29;
    jit_node_t		*nU29_29;
    U29_30		 pU29_30;
    jit_node_t		*nU29_30;
    U29_31		 pU29_31;
    jit_node_t		*nU29_31;
    U29_32		 pU29_32;
    jit_node_t		*nU29_32;
    U29_33		 pU29_33;
    jit_node_t		*nU29_33;
    U29_34		 pU29_34;
    jit_node_t		*nU29_34;
    U29_35		 pU29_35;
    jit_node_t		*nU29_35;
    /* Declare unsigned bitfields at offset 30 */
    U30_3		 pU30_3;
    jit_node_t		*nU30_3;
    U30_4		 pU30_4;
    jit_node_t		*nU30_4;
    U30_5		 pU30_5;
    jit_node_t		*nU30_5;
    U30_6		 pU30_6;
    jit_node_t		*nU30_6;
    U30_7		 pU30_7;
    jit_node_t		*nU30_7;
    U30_8		 pU30_8;
    jit_node_t		*nU30_8;
    U30_9		 pU30_9;
    jit_node_t		*nU30_9;
    U30_10		 pU30_10;
    jit_node_t		*nU30_10;
    U30_11		 pU30_11;
    jit_node_t		*nU30_11;
    U30_12		 pU30_12;
    jit_node_t		*nU30_12;
    U30_13		 pU30_13;
    jit_node_t		*nU30_13;
    U30_14		 pU30_14;
    jit_node_t		*nU30_14;
    U30_15		 pU30_15;
    jit_node_t		*nU30_15;
    U30_16		 pU30_16;
    jit_node_t		*nU30_16;
    U30_17		 pU30_17;
    jit_node_t		*nU30_17;
    U30_18		 pU30_18;
    jit_node_t		*nU30_18;
    U30_19		 pU30_19;
    jit_node_t		*nU30_19;
    U30_20		 pU30_20;
    jit_node_t		*nU30_20;
    U30_21		 pU30_21;
    jit_node_t		*nU30_21;
    U30_22		 pU30_22;
    jit_node_t		*nU30_22;
    U30_23		 pU30_23;
    jit_node_t		*nU30_23;
    U30_24		 pU30_24;
    jit_node_t		*nU30_24;
    U30_25		 pU30_25;
    jit_node_t		*nU30_25;
    U30_26		 pU30_26;
    jit_node_t		*nU30_26;
    U30_27		 pU30_27;
    jit_node_t		*nU30_27;
    U30_28		 pU30_28;
    jit_node_t		*nU30_28;
    U30_29		 pU30_29;
    jit_node_t		*nU30_29;
    U30_30		 pU30_30;
    jit_node_t		*nU30_30;
    U30_31		 pU30_31;
    jit_node_t		*nU30_31;
    U30_32		 pU30_32;
    jit_node_t		*nU30_32;
    U30_33		 pU30_33;
    jit_node_t		*nU30_33;
    U30_34		 pU30_34;
    jit_node_t		*nU30_34;
    /* Declare unsigned bitfields at offset 31 */
    U31_2		 pU31_2;
    jit_node_t		*nU31_2;
    U31_3		 pU31_3;
    jit_node_t		*nU31_3;
    U31_4		 pU31_4;
    jit_node_t		*nU31_4;
    U31_5		 pU31_5;
    jit_node_t		*nU31_5;
    U31_6		 pU31_6;
    jit_node_t		*nU31_6;
    U31_7		 pU31_7;
    jit_node_t		*nU31_7;
    U31_8		 pU31_8;
    jit_node_t		*nU31_8;
    U31_9		 pU31_9;
    jit_node_t		*nU31_9;
    U31_10		 pU31_10;
    jit_node_t		*nU31_10;
    U31_11		 pU31_11;
    jit_node_t		*nU31_11;
    U31_12		 pU31_12;
    jit_node_t		*nU31_12;
    U31_13		 pU31_13;
    jit_node_t		*nU31_13;
    U31_14		 pU31_14;
    jit_node_t		*nU31_14;
    U31_15		 pU31_15;
    jit_node_t		*nU31_15;
    U31_16		 pU31_16;
    jit_node_t		*nU31_16;
    U31_17		 pU31_17;
    jit_node_t		*nU31_17;
    U31_18		 pU31_18;
    jit_node_t		*nU31_18;
    U31_19		 pU31_19;
    jit_node_t		*nU31_19;
    U31_20		 pU31_20;
    jit_node_t		*nU31_20;
    U31_21		 pU31_21;
    jit_node_t		*nU31_21;
    U31_22		 pU31_22;
    jit_node_t		*nU31_22;
    U31_23		 pU31_23;
    jit_node_t		*nU31_23;
    U31_24		 pU31_24;
    jit_node_t		*nU31_24;
    U31_25		 pU31_25;
    jit_node_t		*nU31_25;
    U31_26		 pU31_26;
    jit_node_t		*nU31_26;
    U31_27		 pU31_27;
    jit_node_t		*nU31_27;
    U31_28		 pU31_28;
    jit_node_t		*nU31_28;
    U31_29		 pU31_29;
    jit_node_t		*nU31_29;
    U31_30		 pU31_30;
    jit_node_t		*nU31_30;
    U31_31		 pU31_31;
    jit_node_t		*nU31_31;
    U31_32		 pU31_32;
    jit_node_t		*nU31_32;
    U31_33		 pU31_33;
    jit_node_t		*nU31_33;
    /* Declare unsigned bitfields at offset 32 */
    U32_1		 pU32_1;
    jit_node_t		*nU32_1;
    U32_2		 pU32_2;
    jit_node_t		*nU32_2;
    U32_3		 pU32_3;
    jit_node_t		*nU32_3;
    U32_4		 pU32_4;
    jit_node_t		*nU32_4;
    U32_5		 pU32_5;
    jit_node_t		*nU32_5;
    U32_6		 pU32_6;
    jit_node_t		*nU32_6;
    U32_7		 pU32_7;
    jit_node_t		*nU32_7;
    U32_8		 pU32_8;
    jit_node_t		*nU32_8;
    U32_9		 pU32_9;
    jit_node_t		*nU32_9;
    U32_10		 pU32_10;
    jit_node_t		*nU32_10;
    U32_11		 pU32_11;
    jit_node_t		*nU32_11;
    U32_12		 pU32_12;
    jit_node_t		*nU32_12;
    U32_13		 pU32_13;
    jit_node_t		*nU32_13;
    U32_14		 pU32_14;
    jit_node_t		*nU32_14;
    U32_15		 pU32_15;
    jit_node_t		*nU32_15;
    U32_16		 pU32_16;
    jit_node_t		*nU32_16;
    U32_17		 pU32_17;
    jit_node_t		*nU32_17;
    U32_18		 pU32_18;
    jit_node_t		*nU32_18;
    U32_19		 pU32_19;
    jit_node_t		*nU32_19;
    U32_20		 pU32_20;
    jit_node_t		*nU32_20;
    U32_21		 pU32_21;
    jit_node_t		*nU32_21;
    U32_22		 pU32_22;
    jit_node_t		*nU32_22;
    U32_23		 pU32_23;
    jit_node_t		*nU32_23;
    U32_24		 pU32_24;
    jit_node_t		*nU32_24;
    U32_25		 pU32_25;
    jit_node_t		*nU32_25;
    U32_26		 pU32_26;
    jit_node_t		*nU32_26;
    U32_27		 pU32_27;
    jit_node_t		*nU32_27;
    U32_28		 pU32_28;
    jit_node_t		*nU32_28;
    U32_29		 pU32_29;
    jit_node_t		*nU32_29;
    U32_30		 pU32_30;
    jit_node_t		*nU32_30;
    U32_31		 pU32_31;
    jit_node_t		*nU32_31;
    U32_32		 pU32_32;
    jit_node_t		*nU32_32;
    /* Declare unsigned bitfields at offset 33 */
    U33_1		 pU33_1;
    jit_node_t		*nU33_1;
    U33_2		 pU33_2;
    jit_node_t		*nU33_2;
    U33_3		 pU33_3;
    jit_node_t		*nU33_3;
    U33_4		 pU33_4;
    jit_node_t		*nU33_4;
    U33_5		 pU33_5;
    jit_node_t		*nU33_5;
    U33_6		 pU33_6;
    jit_node_t		*nU33_6;
    U33_7		 pU33_7;
    jit_node_t		*nU33_7;
    U33_8		 pU33_8;
    jit_node_t		*nU33_8;
    U33_9		 pU33_9;
    jit_node_t		*nU33_9;
    U33_10		 pU33_10;
    jit_node_t		*nU33_10;
    U33_11		 pU33_11;
    jit_node_t		*nU33_11;
    U33_12		 pU33_12;
    jit_node_t		*nU33_12;
    U33_13		 pU33_13;
    jit_node_t		*nU33_13;
    U33_14		 pU33_14;
    jit_node_t		*nU33_14;
    U33_15		 pU33_15;
    jit_node_t		*nU33_15;
    U33_16		 pU33_16;
    jit_node_t		*nU33_16;
    U33_17		 pU33_17;
    jit_node_t		*nU33_17;
    U33_18		 pU33_18;
    jit_node_t		*nU33_18;
    U33_19		 pU33_19;
    jit_node_t		*nU33_19;
    U33_20		 pU33_20;
    jit_node_t		*nU33_20;
    U33_21		 pU33_21;
    jit_node_t		*nU33_21;
    U33_22		 pU33_22;
    jit_node_t		*nU33_22;
    U33_23		 pU33_23;
    jit_node_t		*nU33_23;
    U33_24		 pU33_24;
    jit_node_t		*nU33_24;
    U33_25		 pU33_25;
    jit_node_t		*nU33_25;
    U33_26		 pU33_26;
    jit_node_t		*nU33_26;
    U33_27		 pU33_27;
    jit_node_t		*nU33_27;
    U33_28		 pU33_28;
    jit_node_t		*nU33_28;
    U33_29		 pU33_29;
    jit_node_t		*nU33_29;
    U33_30		 pU33_30;
    jit_node_t		*nU33_30;
    U33_31		 pU33_31;
    jit_node_t		*nU33_31;
    /* Declare unsigned bitfields at offset 34 */
    U34_1		 pU34_1;
    jit_node_t		*nU34_1;
    U34_2		 pU34_2;
    jit_node_t		*nU34_2;
    U34_3		 pU34_3;
    jit_node_t		*nU34_3;
    U34_4		 pU34_4;
    jit_node_t		*nU34_4;
    U34_5		 pU34_5;
    jit_node_t		*nU34_5;
    U34_6		 pU34_6;
    jit_node_t		*nU34_6;
    U34_7		 pU34_7;
    jit_node_t		*nU34_7;
    U34_8		 pU34_8;
    jit_node_t		*nU34_8;
    U34_9		 pU34_9;
    jit_node_t		*nU34_9;
    U34_10		 pU34_10;
    jit_node_t		*nU34_10;
    U34_11		 pU34_11;
    jit_node_t		*nU34_11;
    U34_12		 pU34_12;
    jit_node_t		*nU34_12;
    U34_13		 pU34_13;
    jit_node_t		*nU34_13;
    U34_14		 pU34_14;
    jit_node_t		*nU34_14;
    U34_15		 pU34_15;
    jit_node_t		*nU34_15;
    U34_16		 pU34_16;
    jit_node_t		*nU34_16;
    U34_17		 pU34_17;
    jit_node_t		*nU34_17;
    U34_18		 pU34_18;
    jit_node_t		*nU34_18;
    U34_19		 pU34_19;
    jit_node_t		*nU34_19;
    U34_20		 pU34_20;
    jit_node_t		*nU34_20;
    U34_21		 pU34_21;
    jit_node_t		*nU34_21;
    U34_22		 pU34_22;
    jit_node_t		*nU34_22;
    U34_23		 pU34_23;
    jit_node_t		*nU34_23;
    U34_24		 pU34_24;
    jit_node_t		*nU34_24;
    U34_25		 pU34_25;
    jit_node_t		*nU34_25;
    U34_26		 pU34_26;
    jit_node_t		*nU34_26;
    U34_27		 pU34_27;
    jit_node_t		*nU34_27;
    U34_28		 pU34_28;
    jit_node_t		*nU34_28;
    U34_29		 pU34_29;
    jit_node_t		*nU34_29;
    U34_30		 pU34_30;
    jit_node_t		*nU34_30;
    /* Declare unsigned bitfields at offset 35 */
    U35_1		 pU35_1;
    jit_node_t		*nU35_1;
    U35_2		 pU35_2;
    jit_node_t		*nU35_2;
    U35_3		 pU35_3;
    jit_node_t		*nU35_3;
    U35_4		 pU35_4;
    jit_node_t		*nU35_4;
    U35_5		 pU35_5;
    jit_node_t		*nU35_5;
    U35_6		 pU35_6;
    jit_node_t		*nU35_6;
    U35_7		 pU35_7;
    jit_node_t		*nU35_7;
    U35_8		 pU35_8;
    jit_node_t		*nU35_8;
    U35_9		 pU35_9;
    jit_node_t		*nU35_9;
    U35_10		 pU35_10;
    jit_node_t		*nU35_10;
    U35_11		 pU35_11;
    jit_node_t		*nU35_11;
    U35_12		 pU35_12;
    jit_node_t		*nU35_12;
    U35_13		 pU35_13;
    jit_node_t		*nU35_13;
    U35_14		 pU35_14;
    jit_node_t		*nU35_14;
    U35_15		 pU35_15;
    jit_node_t		*nU35_15;
    U35_16		 pU35_16;
    jit_node_t		*nU35_16;
    U35_17		 pU35_17;
    jit_node_t		*nU35_17;
    U35_18		 pU35_18;
    jit_node_t		*nU35_18;
    U35_19		 pU35_19;
    jit_node_t		*nU35_19;
    U35_20		 pU35_20;
    jit_node_t		*nU35_20;
    U35_21		 pU35_21;
    jit_node_t		*nU35_21;
    U35_22		 pU35_22;
    jit_node_t		*nU35_22;
    U35_23		 pU35_23;
    jit_node_t		*nU35_23;
    U35_24		 pU35_24;
    jit_node_t		*nU35_24;
    U35_25		 pU35_25;
    jit_node_t		*nU35_25;
    U35_26		 pU35_26;
    jit_node_t		*nU35_26;
    U35_27		 pU35_27;
    jit_node_t		*nU35_27;
    U35_28		 pU35_28;
    jit_node_t		*nU35_28;
    U35_29		 pU35_29;
    jit_node_t		*nU35_29;
    /* Declare unsigned bitfields at offset 36 */
    U36_1		 pU36_1;
    jit_node_t		*nU36_1;
    U36_2		 pU36_2;
    jit_node_t		*nU36_2;
    U36_3		 pU36_3;
    jit_node_t		*nU36_3;
    U36_4		 pU36_4;
    jit_node_t		*nU36_4;
    U36_5		 pU36_5;
    jit_node_t		*nU36_5;
    U36_6		 pU36_6;
    jit_node_t		*nU36_6;
    U36_7		 pU36_7;
    jit_node_t		*nU36_7;
    U36_8		 pU36_8;
    jit_node_t		*nU36_8;
    U36_9		 pU36_9;
    jit_node_t		*nU36_9;
    U36_10		 pU36_10;
    jit_node_t		*nU36_10;
    U36_11		 pU36_11;
    jit_node_t		*nU36_11;
    U36_12		 pU36_12;
    jit_node_t		*nU36_12;
    U36_13		 pU36_13;
    jit_node_t		*nU36_13;
    U36_14		 pU36_14;
    jit_node_t		*nU36_14;
    U36_15		 pU36_15;
    jit_node_t		*nU36_15;
    U36_16		 pU36_16;
    jit_node_t		*nU36_16;
    U36_17		 pU36_17;
    jit_node_t		*nU36_17;
    U36_18		 pU36_18;
    jit_node_t		*nU36_18;
    U36_19		 pU36_19;
    jit_node_t		*nU36_19;
    U36_20		 pU36_20;
    jit_node_t		*nU36_20;
    U36_21		 pU36_21;
    jit_node_t		*nU36_21;
    U36_22		 pU36_22;
    jit_node_t		*nU36_22;
    U36_23		 pU36_23;
    jit_node_t		*nU36_23;
    U36_24		 pU36_24;
    jit_node_t		*nU36_24;
    U36_25		 pU36_25;
    jit_node_t		*nU36_25;
    U36_26		 pU36_26;
    jit_node_t		*nU36_26;
    U36_27		 pU36_27;
    jit_node_t		*nU36_27;
    U36_28		 pU36_28;
    jit_node_t		*nU36_28;
    /* Declare unsigned bitfields at offset 37 */
    U37_1		 pU37_1;
    jit_node_t		*nU37_1;
    U37_2		 pU37_2;
    jit_node_t		*nU37_2;
    U37_3		 pU37_3;
    jit_node_t		*nU37_3;
    U37_4		 pU37_4;
    jit_node_t		*nU37_4;
    U37_5		 pU37_5;
    jit_node_t		*nU37_5;
    U37_6		 pU37_6;
    jit_node_t		*nU37_6;
    U37_7		 pU37_7;
    jit_node_t		*nU37_7;
    U37_8		 pU37_8;
    jit_node_t		*nU37_8;
    U37_9		 pU37_9;
    jit_node_t		*nU37_9;
    U37_10		 pU37_10;
    jit_node_t		*nU37_10;
    U37_11		 pU37_11;
    jit_node_t		*nU37_11;
    U37_12		 pU37_12;
    jit_node_t		*nU37_12;
    U37_13		 pU37_13;
    jit_node_t		*nU37_13;
    U37_14		 pU37_14;
    jit_node_t		*nU37_14;
    U37_15		 pU37_15;
    jit_node_t		*nU37_15;
    U37_16		 pU37_16;
    jit_node_t		*nU37_16;
    U37_17		 pU37_17;
    jit_node_t		*nU37_17;
    U37_18		 pU37_18;
    jit_node_t		*nU37_18;
    U37_19		 pU37_19;
    jit_node_t		*nU37_19;
    U37_20		 pU37_20;
    jit_node_t		*nU37_20;
    U37_21		 pU37_21;
    jit_node_t		*nU37_21;
    U37_22		 pU37_22;
    jit_node_t		*nU37_22;
    U37_23		 pU37_23;
    jit_node_t		*nU37_23;
    U37_24		 pU37_24;
    jit_node_t		*nU37_24;
    U37_25		 pU37_25;
    jit_node_t		*nU37_25;
    U37_26		 pU37_26;
    jit_node_t		*nU37_26;
    U37_27		 pU37_27;
    jit_node_t		*nU37_27;
    /* Declare unsigned bitfields at offset 38 */
    U38_1		 pU38_1;
    jit_node_t		*nU38_1;
    U38_2		 pU38_2;
    jit_node_t		*nU38_2;
    U38_3		 pU38_3;
    jit_node_t		*nU38_3;
    U38_4		 pU38_4;
    jit_node_t		*nU38_4;
    U38_5		 pU38_5;
    jit_node_t		*nU38_5;
    U38_6		 pU38_6;
    jit_node_t		*nU38_6;
    U38_7		 pU38_7;
    jit_node_t		*nU38_7;
    U38_8		 pU38_8;
    jit_node_t		*nU38_8;
    U38_9		 pU38_9;
    jit_node_t		*nU38_9;
    U38_10		 pU38_10;
    jit_node_t		*nU38_10;
    U38_11		 pU38_11;
    jit_node_t		*nU38_11;
    U38_12		 pU38_12;
    jit_node_t		*nU38_12;
    U38_13		 pU38_13;
    jit_node_t		*nU38_13;
    U38_14		 pU38_14;
    jit_node_t		*nU38_14;
    U38_15		 pU38_15;
    jit_node_t		*nU38_15;
    U38_16		 pU38_16;
    jit_node_t		*nU38_16;
    U38_17		 pU38_17;
    jit_node_t		*nU38_17;
    U38_18		 pU38_18;
    jit_node_t		*nU38_18;
    U38_19		 pU38_19;
    jit_node_t		*nU38_19;
    U38_20		 pU38_20;
    jit_node_t		*nU38_20;
    U38_21		 pU38_21;
    jit_node_t		*nU38_21;
    U38_22		 pU38_22;
    jit_node_t		*nU38_22;
    U38_23		 pU38_23;
    jit_node_t		*nU38_23;
    U38_24		 pU38_24;
    jit_node_t		*nU38_24;
    U38_25		 pU38_25;
    jit_node_t		*nU38_25;
    U38_26		 pU38_26;
    jit_node_t		*nU38_26;
    /* Declare unsigned bitfields at offset 39 */
    U39_1		 pU39_1;
    jit_node_t		*nU39_1;
    U39_2		 pU39_2;
    jit_node_t		*nU39_2;
    U39_3		 pU39_3;
    jit_node_t		*nU39_3;
    U39_4		 pU39_4;
    jit_node_t		*nU39_4;
    U39_5		 pU39_5;
    jit_node_t		*nU39_5;
    U39_6		 pU39_6;
    jit_node_t		*nU39_6;
    U39_7		 pU39_7;
    jit_node_t		*nU39_7;
    U39_8		 pU39_8;
    jit_node_t		*nU39_8;
    U39_9		 pU39_9;
    jit_node_t		*nU39_9;
    U39_10		 pU39_10;
    jit_node_t		*nU39_10;
    U39_11		 pU39_11;
    jit_node_t		*nU39_11;
    U39_12		 pU39_12;
    jit_node_t		*nU39_12;
    U39_13		 pU39_13;
    jit_node_t		*nU39_13;
    U39_14		 pU39_14;
    jit_node_t		*nU39_14;
    U39_15		 pU39_15;
    jit_node_t		*nU39_15;
    U39_16		 pU39_16;
    jit_node_t		*nU39_16;
    U39_17		 pU39_17;
    jit_node_t		*nU39_17;
    U39_18		 pU39_18;
    jit_node_t		*nU39_18;
    U39_19		 pU39_19;
    jit_node_t		*nU39_19;
    U39_20		 pU39_20;
    jit_node_t		*nU39_20;
    U39_21		 pU39_21;
    jit_node_t		*nU39_21;
    U39_22		 pU39_22;
    jit_node_t		*nU39_22;
    U39_23		 pU39_23;
    jit_node_t		*nU39_23;
    U39_24		 pU39_24;
    jit_node_t		*nU39_24;
    U39_25		 pU39_25;
    jit_node_t		*nU39_25;
    /* Declare unsigned bitfields at offset 40 */
    U40_1		 pU40_1;
    jit_node_t		*nU40_1;
    U40_2		 pU40_2;
    jit_node_t		*nU40_2;
    U40_3		 pU40_3;
    jit_node_t		*nU40_3;
    U40_4		 pU40_4;
    jit_node_t		*nU40_4;
    U40_5		 pU40_5;
    jit_node_t		*nU40_5;
    U40_6		 pU40_6;
    jit_node_t		*nU40_6;
    U40_7		 pU40_7;
    jit_node_t		*nU40_7;
    U40_8		 pU40_8;
    jit_node_t		*nU40_8;
    U40_9		 pU40_9;
    jit_node_t		*nU40_9;
    U40_10		 pU40_10;
    jit_node_t		*nU40_10;
    U40_11		 pU40_11;
    jit_node_t		*nU40_11;
    U40_12		 pU40_12;
    jit_node_t		*nU40_12;
    U40_13		 pU40_13;
    jit_node_t		*nU40_13;
    U40_14		 pU40_14;
    jit_node_t		*nU40_14;
    U40_15		 pU40_15;
    jit_node_t		*nU40_15;
    U40_16		 pU40_16;
    jit_node_t		*nU40_16;
    U40_17		 pU40_17;
    jit_node_t		*nU40_17;
    U40_18		 pU40_18;
    jit_node_t		*nU40_18;
    U40_19		 pU40_19;
    jit_node_t		*nU40_19;
    U40_20		 pU40_20;
    jit_node_t		*nU40_20;
    U40_21		 pU40_21;
    jit_node_t		*nU40_21;
    U40_22		 pU40_22;
    jit_node_t		*nU40_22;
    U40_23		 pU40_23;
    jit_node_t		*nU40_23;
    U40_24		 pU40_24;
    jit_node_t		*nU40_24;
    /* Declare unsigned bitfields at offset 41 */
    U41_1		 pU41_1;
    jit_node_t		*nU41_1;
    U41_2		 pU41_2;
    jit_node_t		*nU41_2;
    U41_3		 pU41_3;
    jit_node_t		*nU41_3;
    U41_4		 pU41_4;
    jit_node_t		*nU41_4;
    U41_5		 pU41_5;
    jit_node_t		*nU41_5;
    U41_6		 pU41_6;
    jit_node_t		*nU41_6;
    U41_7		 pU41_7;
    jit_node_t		*nU41_7;
    U41_8		 pU41_8;
    jit_node_t		*nU41_8;
    U41_9		 pU41_9;
    jit_node_t		*nU41_9;
    U41_10		 pU41_10;
    jit_node_t		*nU41_10;
    U41_11		 pU41_11;
    jit_node_t		*nU41_11;
    U41_12		 pU41_12;
    jit_node_t		*nU41_12;
    U41_13		 pU41_13;
    jit_node_t		*nU41_13;
    U41_14		 pU41_14;
    jit_node_t		*nU41_14;
    U41_15		 pU41_15;
    jit_node_t		*nU41_15;
    U41_16		 pU41_16;
    jit_node_t		*nU41_16;
    U41_17		 pU41_17;
    jit_node_t		*nU41_17;
    U41_18		 pU41_18;
    jit_node_t		*nU41_18;
    U41_19		 pU41_19;
    jit_node_t		*nU41_19;
    U41_20		 pU41_20;
    jit_node_t		*nU41_20;
    U41_21		 pU41_21;
    jit_node_t		*nU41_21;
    U41_22		 pU41_22;
    jit_node_t		*nU41_22;
    U41_23		 pU41_23;
    jit_node_t		*nU41_23;
    /* Declare unsigned bitfields at offset 42 */
    U42_1		 pU42_1;
    jit_node_t		*nU42_1;
    U42_2		 pU42_2;
    jit_node_t		*nU42_2;
    U42_3		 pU42_3;
    jit_node_t		*nU42_3;
    U42_4		 pU42_4;
    jit_node_t		*nU42_4;
    U42_5		 pU42_5;
    jit_node_t		*nU42_5;
    U42_6		 pU42_6;
    jit_node_t		*nU42_6;
    U42_7		 pU42_7;
    jit_node_t		*nU42_7;
    U42_8		 pU42_8;
    jit_node_t		*nU42_8;
    U42_9		 pU42_9;
    jit_node_t		*nU42_9;
    U42_10		 pU42_10;
    jit_node_t		*nU42_10;
    U42_11		 pU42_11;
    jit_node_t		*nU42_11;
    U42_12		 pU42_12;
    jit_node_t		*nU42_12;
    U42_13		 pU42_13;
    jit_node_t		*nU42_13;
    U42_14		 pU42_14;
    jit_node_t		*nU42_14;
    U42_15		 pU42_15;
    jit_node_t		*nU42_15;
    U42_16		 pU42_16;
    jit_node_t		*nU42_16;
    U42_17		 pU42_17;
    jit_node_t		*nU42_17;
    U42_18		 pU42_18;
    jit_node_t		*nU42_18;
    U42_19		 pU42_19;
    jit_node_t		*nU42_19;
    U42_20		 pU42_20;
    jit_node_t		*nU42_20;
    U42_21		 pU42_21;
    jit_node_t		*nU42_21;
    U42_22		 pU42_22;
    jit_node_t		*nU42_22;
    /* Declare unsigned bitfields at offset 43 */
    U43_1		 pU43_1;
    jit_node_t		*nU43_1;
    U43_2		 pU43_2;
    jit_node_t		*nU43_2;
    U43_3		 pU43_3;
    jit_node_t		*nU43_3;
    U43_4		 pU43_4;
    jit_node_t		*nU43_4;
    U43_5		 pU43_5;
    jit_node_t		*nU43_5;
    U43_6		 pU43_6;
    jit_node_t		*nU43_6;
    U43_7		 pU43_7;
    jit_node_t		*nU43_7;
    U43_8		 pU43_8;
    jit_node_t		*nU43_8;
    U43_9		 pU43_9;
    jit_node_t		*nU43_9;
    U43_10		 pU43_10;
    jit_node_t		*nU43_10;
    U43_11		 pU43_11;
    jit_node_t		*nU43_11;
    U43_12		 pU43_12;
    jit_node_t		*nU43_12;
    U43_13		 pU43_13;
    jit_node_t		*nU43_13;
    U43_14		 pU43_14;
    jit_node_t		*nU43_14;
    U43_15		 pU43_15;
    jit_node_t		*nU43_15;
    U43_16		 pU43_16;
    jit_node_t		*nU43_16;
    U43_17		 pU43_17;
    jit_node_t		*nU43_17;
    U43_18		 pU43_18;
    jit_node_t		*nU43_18;
    U43_19		 pU43_19;
    jit_node_t		*nU43_19;
    U43_20		 pU43_20;
    jit_node_t		*nU43_20;
    U43_21		 pU43_21;
    jit_node_t		*nU43_21;
    /* Declare unsigned bitfields at offset 44 */
    U44_1		 pU44_1;
    jit_node_t		*nU44_1;
    U44_2		 pU44_2;
    jit_node_t		*nU44_2;
    U44_3		 pU44_3;
    jit_node_t		*nU44_3;
    U44_4		 pU44_4;
    jit_node_t		*nU44_4;
    U44_5		 pU44_5;
    jit_node_t		*nU44_5;
    U44_6		 pU44_6;
    jit_node_t		*nU44_6;
    U44_7		 pU44_7;
    jit_node_t		*nU44_7;
    U44_8		 pU44_8;
    jit_node_t		*nU44_8;
    U44_9		 pU44_9;
    jit_node_t		*nU44_9;
    U44_10		 pU44_10;
    jit_node_t		*nU44_10;
    U44_11		 pU44_11;
    jit_node_t		*nU44_11;
    U44_12		 pU44_12;
    jit_node_t		*nU44_12;
    U44_13		 pU44_13;
    jit_node_t		*nU44_13;
    U44_14		 pU44_14;
    jit_node_t		*nU44_14;
    U44_15		 pU44_15;
    jit_node_t		*nU44_15;
    U44_16		 pU44_16;
    jit_node_t		*nU44_16;
    U44_17		 pU44_17;
    jit_node_t		*nU44_17;
    U44_18		 pU44_18;
    jit_node_t		*nU44_18;
    U44_19		 pU44_19;
    jit_node_t		*nU44_19;
    U44_20		 pU44_20;
    jit_node_t		*nU44_20;
    /* Declare unsigned bitfields at offset 45 */
    U45_1		 pU45_1;
    jit_node_t		*nU45_1;
    U45_2		 pU45_2;
    jit_node_t		*nU45_2;
    U45_3		 pU45_3;
    jit_node_t		*nU45_3;
    U45_4		 pU45_4;
    jit_node_t		*nU45_4;
    U45_5		 pU45_5;
    jit_node_t		*nU45_5;
    U45_6		 pU45_6;
    jit_node_t		*nU45_6;
    U45_7		 pU45_7;
    jit_node_t		*nU45_7;
    U45_8		 pU45_8;
    jit_node_t		*nU45_8;
    U45_9		 pU45_9;
    jit_node_t		*nU45_9;
    U45_10		 pU45_10;
    jit_node_t		*nU45_10;
    U45_11		 pU45_11;
    jit_node_t		*nU45_11;
    U45_12		 pU45_12;
    jit_node_t		*nU45_12;
    U45_13		 pU45_13;
    jit_node_t		*nU45_13;
    U45_14		 pU45_14;
    jit_node_t		*nU45_14;
    U45_15		 pU45_15;
    jit_node_t		*nU45_15;
    U45_16		 pU45_16;
    jit_node_t		*nU45_16;
    U45_17		 pU45_17;
    jit_node_t		*nU45_17;
    U45_18		 pU45_18;
    jit_node_t		*nU45_18;
    U45_19		 pU45_19;
    jit_node_t		*nU45_19;
    /* Declare unsigned bitfields at offset 46 */
    U46_1		 pU46_1;
    jit_node_t		*nU46_1;
    U46_2		 pU46_2;
    jit_node_t		*nU46_2;
    U46_3		 pU46_3;
    jit_node_t		*nU46_3;
    U46_4		 pU46_4;
    jit_node_t		*nU46_4;
    U46_5		 pU46_5;
    jit_node_t		*nU46_5;
    U46_6		 pU46_6;
    jit_node_t		*nU46_6;
    U46_7		 pU46_7;
    jit_node_t		*nU46_7;
    U46_8		 pU46_8;
    jit_node_t		*nU46_8;
    U46_9		 pU46_9;
    jit_node_t		*nU46_9;
    U46_10		 pU46_10;
    jit_node_t		*nU46_10;
    U46_11		 pU46_11;
    jit_node_t		*nU46_11;
    U46_12		 pU46_12;
    jit_node_t		*nU46_12;
    U46_13		 pU46_13;
    jit_node_t		*nU46_13;
    U46_14		 pU46_14;
    jit_node_t		*nU46_14;
    U46_15		 pU46_15;
    jit_node_t		*nU46_15;
    U46_16		 pU46_16;
    jit_node_t		*nU46_16;
    U46_17		 pU46_17;
    jit_node_t		*nU46_17;
    U46_18		 pU46_18;
    jit_node_t		*nU46_18;
    /* Declare unsigned bitfields at offset 47 */
    U47_1		 pU47_1;
    jit_node_t		*nU47_1;
    U47_2		 pU47_2;
    jit_node_t		*nU47_2;
    U47_3		 pU47_3;
    jit_node_t		*nU47_3;
    U47_4		 pU47_4;
    jit_node_t		*nU47_4;
    U47_5		 pU47_5;
    jit_node_t		*nU47_5;
    U47_6		 pU47_6;
    jit_node_t		*nU47_6;
    U47_7		 pU47_7;
    jit_node_t		*nU47_7;
    U47_8		 pU47_8;
    jit_node_t		*nU47_8;
    U47_9		 pU47_9;
    jit_node_t		*nU47_9;
    U47_10		 pU47_10;
    jit_node_t		*nU47_10;
    U47_11		 pU47_11;
    jit_node_t		*nU47_11;
    U47_12		 pU47_12;
    jit_node_t		*nU47_12;
    U47_13		 pU47_13;
    jit_node_t		*nU47_13;
    U47_14		 pU47_14;
    jit_node_t		*nU47_14;
    U47_15		 pU47_15;
    jit_node_t		*nU47_15;
    U47_16		 pU47_16;
    jit_node_t		*nU47_16;
    U47_17		 pU47_17;
    jit_node_t		*nU47_17;
    /* Declare unsigned bitfields at offset 48 */
    U48_1		 pU48_1;
    jit_node_t		*nU48_1;
    U48_2		 pU48_2;
    jit_node_t		*nU48_2;
    U48_3		 pU48_3;
    jit_node_t		*nU48_3;
    U48_4		 pU48_4;
    jit_node_t		*nU48_4;
    U48_5		 pU48_5;
    jit_node_t		*nU48_5;
    U48_6		 pU48_6;
    jit_node_t		*nU48_6;
    U48_7		 pU48_7;
    jit_node_t		*nU48_7;
    U48_8		 pU48_8;
    jit_node_t		*nU48_8;
    U48_9		 pU48_9;
    jit_node_t		*nU48_9;
    U48_10		 pU48_10;
    jit_node_t		*nU48_10;
    U48_11		 pU48_11;
    jit_node_t		*nU48_11;
    U48_12		 pU48_12;
    jit_node_t		*nU48_12;
    U48_13		 pU48_13;
    jit_node_t		*nU48_13;
    U48_14		 pU48_14;
    jit_node_t		*nU48_14;
    U48_15		 pU48_15;
    jit_node_t		*nU48_15;
    U48_16		 pU48_16;
    jit_node_t		*nU48_16;
    /* Declare unsigned bitfields at offset 49 */
    U49_1		 pU49_1;
    jit_node_t		*nU49_1;
    U49_2		 pU49_2;
    jit_node_t		*nU49_2;
    U49_3		 pU49_3;
    jit_node_t		*nU49_3;
    U49_4		 pU49_4;
    jit_node_t		*nU49_4;
    U49_5		 pU49_5;
    jit_node_t		*nU49_5;
    U49_6		 pU49_6;
    jit_node_t		*nU49_6;
    U49_7		 pU49_7;
    jit_node_t		*nU49_7;
    U49_8		 pU49_8;
    jit_node_t		*nU49_8;
    U49_9		 pU49_9;
    jit_node_t		*nU49_9;
    U49_10		 pU49_10;
    jit_node_t		*nU49_10;
    U49_11		 pU49_11;
    jit_node_t		*nU49_11;
    U49_12		 pU49_12;
    jit_node_t		*nU49_12;
    U49_13		 pU49_13;
    jit_node_t		*nU49_13;
    U49_14		 pU49_14;
    jit_node_t		*nU49_14;
    U49_15		 pU49_15;
    jit_node_t		*nU49_15;
    /* Declare unsigned bitfields at offset 50 */
    U50_1		 pU50_1;
    jit_node_t		*nU50_1;
    U50_2		 pU50_2;
    jit_node_t		*nU50_2;
    U50_3		 pU50_3;
    jit_node_t		*nU50_3;
    U50_4		 pU50_4;
    jit_node_t		*nU50_4;
    U50_5		 pU50_5;
    jit_node_t		*nU50_5;
    U50_6		 pU50_6;
    jit_node_t		*nU50_6;
    U50_7		 pU50_7;
    jit_node_t		*nU50_7;
    U50_8		 pU50_8;
    jit_node_t		*nU50_8;
    U50_9		 pU50_9;
    jit_node_t		*nU50_9;
    U50_10		 pU50_10;
    jit_node_t		*nU50_10;
    U50_11		 pU50_11;
    jit_node_t		*nU50_11;
    U50_12		 pU50_12;
    jit_node_t		*nU50_12;
    U50_13		 pU50_13;
    jit_node_t		*nU50_13;
    U50_14		 pU50_14;
    jit_node_t		*nU50_14;
    /* Declare unsigned bitfields at offset 51 */
    U51_1		 pU51_1;
    jit_node_t		*nU51_1;
    U51_2		 pU51_2;
    jit_node_t		*nU51_2;
    U51_3		 pU51_3;
    jit_node_t		*nU51_3;
    U51_4		 pU51_4;
    jit_node_t		*nU51_4;
    U51_5		 pU51_5;
    jit_node_t		*nU51_5;
    U51_6		 pU51_6;
    jit_node_t		*nU51_6;
    U51_7		 pU51_7;
    jit_node_t		*nU51_7;
    U51_8		 pU51_8;
    jit_node_t		*nU51_8;
    U51_9		 pU51_9;
    jit_node_t		*nU51_9;
    U51_10		 pU51_10;
    jit_node_t		*nU51_10;
    U51_11		 pU51_11;
    jit_node_t		*nU51_11;
    U51_12		 pU51_12;
    jit_node_t		*nU51_12;
    U51_13		 pU51_13;
    jit_node_t		*nU51_13;
    /* Declare unsigned bitfields at offset 52 */
    U52_1		 pU52_1;
    jit_node_t		*nU52_1;
    U52_2		 pU52_2;
    jit_node_t		*nU52_2;
    U52_3		 pU52_3;
    jit_node_t		*nU52_3;
    U52_4		 pU52_4;
    jit_node_t		*nU52_4;
    U52_5		 pU52_5;
    jit_node_t		*nU52_5;
    U52_6		 pU52_6;
    jit_node_t		*nU52_6;
    U52_7		 pU52_7;
    jit_node_t		*nU52_7;
    U52_8		 pU52_8;
    jit_node_t		*nU52_8;
    U52_9		 pU52_9;
    jit_node_t		*nU52_9;
    U52_10		 pU52_10;
    jit_node_t		*nU52_10;
    U52_11		 pU52_11;
    jit_node_t		*nU52_11;
    U52_12		 pU52_12;
    jit_node_t		*nU52_12;
    /* Declare unsigned bitfields at offset 53 */
    U53_1		 pU53_1;
    jit_node_t		*nU53_1;
    U53_2		 pU53_2;
    jit_node_t		*nU53_2;
    U53_3		 pU53_3;
    jit_node_t		*nU53_3;
    U53_4		 pU53_4;
    jit_node_t		*nU53_4;
    U53_5		 pU53_5;
    jit_node_t		*nU53_5;
    U53_6		 pU53_6;
    jit_node_t		*nU53_6;
    U53_7		 pU53_7;
    jit_node_t		*nU53_7;
    U53_8		 pU53_8;
    jit_node_t		*nU53_8;
    U53_9		 pU53_9;
    jit_node_t		*nU53_9;
    U53_10		 pU53_10;
    jit_node_t		*nU53_10;
    U53_11		 pU53_11;
    jit_node_t		*nU53_11;
    /* Declare unsigned bitfields at offset 54 */
    U54_1		 pU54_1;
    jit_node_t		*nU54_1;
    U54_2		 pU54_2;
    jit_node_t		*nU54_2;
    U54_3		 pU54_3;
    jit_node_t		*nU54_3;
    U54_4		 pU54_4;
    jit_node_t		*nU54_4;
    U54_5		 pU54_5;
    jit_node_t		*nU54_5;
    U54_6		 pU54_6;
    jit_node_t		*nU54_6;
    U54_7		 pU54_7;
    jit_node_t		*nU54_7;
    U54_8		 pU54_8;
    jit_node_t		*nU54_8;
    U54_9		 pU54_9;
    jit_node_t		*nU54_9;
    U54_10		 pU54_10;
    jit_node_t		*nU54_10;
    /* Declare unsigned bitfields at offset 55 */
    U55_1		 pU55_1;
    jit_node_t		*nU55_1;
    U55_2		 pU55_2;
    jit_node_t		*nU55_2;
    U55_3		 pU55_3;
    jit_node_t		*nU55_3;
    U55_4		 pU55_4;
    jit_node_t		*nU55_4;
    U55_5		 pU55_5;
    jit_node_t		*nU55_5;
    U55_6		 pU55_6;
    jit_node_t		*nU55_6;
    U55_7		 pU55_7;
    jit_node_t		*nU55_7;
    U55_8		 pU55_8;
    jit_node_t		*nU55_8;
    U55_9		 pU55_9;
    jit_node_t		*nU55_9;
    /* Declare unsigned bitfields at offset 56 */
    U56_1		 pU56_1;
    jit_node_t		*nU56_1;
    U56_2		 pU56_2;
    jit_node_t		*nU56_2;
    U56_3		 pU56_3;
    jit_node_t		*nU56_3;
    U56_4		 pU56_4;
    jit_node_t		*nU56_4;
    U56_5		 pU56_5;
    jit_node_t		*nU56_5;
    U56_6		 pU56_6;
    jit_node_t		*nU56_6;
    U56_7		 pU56_7;
    jit_node_t		*nU56_7;
    U56_8		 pU56_8;
    jit_node_t		*nU56_8;
    /* Declare unsigned bitfields at offset 57 */
    U57_1		 pU57_1;
    jit_node_t		*nU57_1;
    U57_2		 pU57_2;
    jit_node_t		*nU57_2;
    U57_3		 pU57_3;
    jit_node_t		*nU57_3;
    U57_4		 pU57_4;
    jit_node_t		*nU57_4;
    U57_5		 pU57_5;
    jit_node_t		*nU57_5;
    U57_6		 pU57_6;
    jit_node_t		*nU57_6;
    U57_7		 pU57_7;
    jit_node_t		*nU57_7;
    /* Declare unsigned bitfields at offset 58 */
    U58_1		 pU58_1;
    jit_node_t		*nU58_1;
    U58_2		 pU58_2;
    jit_node_t		*nU58_2;
    U58_3		 pU58_3;
    jit_node_t		*nU58_3;
    U58_4		 pU58_4;
    jit_node_t		*nU58_4;
    U58_5		 pU58_5;
    jit_node_t		*nU58_5;
    U58_6		 pU58_6;
    jit_node_t		*nU58_6;
    /* Declare unsigned bitfields at offset 59 */
    U59_1		 pU59_1;
    jit_node_t		*nU59_1;
    U59_2		 pU59_2;
    jit_node_t		*nU59_2;
    U59_3		 pU59_3;
    jit_node_t		*nU59_3;
    U59_4		 pU59_4;
    jit_node_t		*nU59_4;
    U59_5		 pU59_5;
    jit_node_t		*nU59_5;
    /* Declare unsigned bitfields at offset 60 */
    U60_1		 pU60_1;
    jit_node_t		*nU60_1;
    U60_2		 pU60_2;
    jit_node_t		*nU60_2;
    U60_3		 pU60_3;
    jit_node_t		*nU60_3;
    U60_4		 pU60_4;
    jit_node_t		*nU60_4;
    /* Declare unsigned bitfields at offset 61 */
    U61_1		 pU61_1;
    jit_node_t		*nU61_1;
    U61_2		 pU61_2;
    jit_node_t		*nU61_2;
    U61_3		 pU61_3;
    jit_node_t		*nU61_3;
    /* Declare unsigned bitfields at offset 62 */
    U62_1		 pU62_1;
    jit_node_t		*nU62_1;
    U62_2		 pU62_2;
    jit_node_t		*nU62_2;
    /* Declare unsigned bitfields at offset 63 */
    U63_1		 pU63_1;
    jit_node_t		*nU63_1;
#endif

    init_jit(argv[0]);
    _jit = jit_new_state();

    jmpi_main = jit_jmpi();

    /* Define jit functions for signed bitfields at offset 0 */
    nS1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 1);
    jit_extr(JIT_R1, JIT_R2, 0, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 2);
    jit_extr(JIT_R1, JIT_R2, 0, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 3);
    jit_extr(JIT_R1, JIT_R2, 0, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 4);
    jit_extr(JIT_R1, JIT_R2, 0, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 5);
    jit_extr(JIT_R1, JIT_R2, 0, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 6);
    jit_extr(JIT_R1, JIT_R2, 0, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 7);
    jit_extr(JIT_R1, JIT_R2, 0, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 8);
    jit_extr(JIT_R1, JIT_R2, 0, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 9);
    jit_extr(JIT_R1, JIT_R2, 0, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 10);
    jit_extr(JIT_R1, JIT_R2, 0, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 11);
    jit_extr(JIT_R1, JIT_R2, 0, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 12);
    jit_extr(JIT_R1, JIT_R2, 0, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 13);
    jit_extr(JIT_R1, JIT_R2, 0, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 14);
    jit_extr(JIT_R1, JIT_R2, 0, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 15);
    jit_extr(JIT_R1, JIT_R2, 0, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 16);
    jit_extr(JIT_R1, JIT_R2, 0, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 17);
    jit_extr(JIT_R1, JIT_R2, 0, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 18);
    jit_extr(JIT_R1, JIT_R2, 0, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 19);
    jit_extr(JIT_R1, JIT_R2, 0, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 20);
    jit_extr(JIT_R1, JIT_R2, 0, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 21);
    jit_extr(JIT_R1, JIT_R2, 0, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 22);
    jit_extr(JIT_R1, JIT_R2, 0, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 23);
    jit_extr(JIT_R1, JIT_R2, 0, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 24);
    jit_extr(JIT_R1, JIT_R2, 0, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 25);
    jit_extr(JIT_R1, JIT_R2, 0, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 26);
    jit_extr(JIT_R1, JIT_R2, 0, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 27);
    jit_extr(JIT_R1, JIT_R2, 0, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 28);
    jit_extr(JIT_R1, JIT_R2, 0, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 29);
    jit_extr(JIT_R1, JIT_R2, 0, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 30);
    jit_extr(JIT_R1, JIT_R2, 0, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 31);
    jit_extr(JIT_R1, JIT_R2, 0, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 32);
    jit_extr(JIT_R1, JIT_R2, 0, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
#if __WORDSIZE == 64 && !SKIP_64_BITS
    nS33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 33);
    jit_extr(JIT_R1, JIT_R2, 0, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 34);
    jit_extr(JIT_R1, JIT_R2, 0, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 35);
    jit_extr(JIT_R1, JIT_R2, 0, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 36);
    jit_extr(JIT_R1, JIT_R2, 0, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 37);
    jit_extr(JIT_R1, JIT_R2, 0, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 38);
    jit_extr(JIT_R1, JIT_R2, 0, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 39);
    jit_extr(JIT_R1, JIT_R2, 0, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 40);
    jit_extr(JIT_R1, JIT_R2, 0, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 41);
    jit_extr(JIT_R1, JIT_R2, 0, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 42);
    jit_extr(JIT_R1, JIT_R2, 0, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 43);
    jit_extr(JIT_R1, JIT_R2, 0, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 44);
    jit_extr(JIT_R1, JIT_R2, 0, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 45);
    jit_extr(JIT_R1, JIT_R2, 0, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 46);
    jit_extr(JIT_R1, JIT_R2, 0, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 47);
    jit_extr(JIT_R1, JIT_R2, 0, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 48);
    jit_extr(JIT_R1, JIT_R2, 0, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 49);
    jit_extr(JIT_R1, JIT_R2, 0, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 50);
    jit_extr(JIT_R1, JIT_R2, 0, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 51);
    jit_extr(JIT_R1, JIT_R2, 0, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 52);
    jit_extr(JIT_R1, JIT_R2, 0, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 53);
    jit_extr(JIT_R1, JIT_R2, 0, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 54);
    jit_extr(JIT_R1, JIT_R2, 0, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 55);
    jit_extr(JIT_R1, JIT_R2, 0, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 56);
    jit_extr(JIT_R1, JIT_R2, 0, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS57 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 57) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 57);
    jit_extr(JIT_R1, JIT_R2, 0, 57);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS58 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 58) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 58);
    jit_extr(JIT_R1, JIT_R2, 0, 58);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS59 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 59) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 59);
    jit_extr(JIT_R1, JIT_R2, 0, 59);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS60 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 60) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 60);
    jit_extr(JIT_R1, JIT_R2, 0, 60);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS61 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 61) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 61);
    jit_extr(JIT_R1, JIT_R2, 0, 61);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS62 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 62) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 62);
    jit_extr(JIT_R1, JIT_R2, 0, 62);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS63 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 63) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 63);
    jit_extr(JIT_R1, JIT_R2, 0, 63);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS64 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, 0);
    jit_depr(JIT_R2, JIT_R1, 0, 64);
    jit_extr(JIT_R1, JIT_R2, 0, 64);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
#endif
    /* Define jit functions for unsigned bitfields at offset 0 */
    nU1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 1);
    jit_extr_u(JIT_R1, JIT_R2, 0, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 2);
    jit_extr_u(JIT_R1, JIT_R2, 0, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 3);
    jit_extr_u(JIT_R1, JIT_R2, 0, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 4);
    jit_extr_u(JIT_R1, JIT_R2, 0, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 5);
    jit_extr_u(JIT_R1, JIT_R2, 0, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 6);
    jit_extr_u(JIT_R1, JIT_R2, 0, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 7);
    jit_extr_u(JIT_R1, JIT_R2, 0, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 8);
    jit_extr_u(JIT_R1, JIT_R2, 0, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 9);
    jit_extr_u(JIT_R1, JIT_R2, 0, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 10);
    jit_extr_u(JIT_R1, JIT_R2, 0, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 11);
    jit_extr_u(JIT_R1, JIT_R2, 0, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 12);
    jit_extr_u(JIT_R1, JIT_R2, 0, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 13);
    jit_extr_u(JIT_R1, JIT_R2, 0, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 14);
    jit_extr_u(JIT_R1, JIT_R2, 0, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 15);
    jit_extr_u(JIT_R1, JIT_R2, 0, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 16);
    jit_extr_u(JIT_R1, JIT_R2, 0, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 17);
    jit_extr_u(JIT_R1, JIT_R2, 0, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 18);
    jit_extr_u(JIT_R1, JIT_R2, 0, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 19);
    jit_extr_u(JIT_R1, JIT_R2, 0, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 20);
    jit_extr_u(JIT_R1, JIT_R2, 0, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 21);
    jit_extr_u(JIT_R1, JIT_R2, 0, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 22);
    jit_extr_u(JIT_R1, JIT_R2, 0, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 23);
    jit_extr_u(JIT_R1, JIT_R2, 0, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 24);
    jit_extr_u(JIT_R1, JIT_R2, 0, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 25);
    jit_extr_u(JIT_R1, JIT_R2, 0, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 26);
    jit_extr_u(JIT_R1, JIT_R2, 0, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 27);
    jit_extr_u(JIT_R1, JIT_R2, 0, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 28);
    jit_extr_u(JIT_R1, JIT_R2, 0, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 29);
    jit_extr_u(JIT_R1, JIT_R2, 0, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 30);
    jit_extr_u(JIT_R1, JIT_R2, 0, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 31);
    jit_extr_u(JIT_R1, JIT_R2, 0, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 32);
    jit_extr_u(JIT_R1, JIT_R2, 0, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
#if __WORDSIZE == 64 && !SKIP_64_BITS
    nU33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 33);
    jit_extr_u(JIT_R1, JIT_R2, 0, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 34);
    jit_extr_u(JIT_R1, JIT_R2, 0, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 35);
    jit_extr_u(JIT_R1, JIT_R2, 0, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 36);
    jit_extr_u(JIT_R1, JIT_R2, 0, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 37);
    jit_extr_u(JIT_R1, JIT_R2, 0, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 38);
    jit_extr_u(JIT_R1, JIT_R2, 0, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 39);
    jit_extr_u(JIT_R1, JIT_R2, 0, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 40);
    jit_extr_u(JIT_R1, JIT_R2, 0, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 41);
    jit_extr_u(JIT_R1, JIT_R2, 0, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 42);
    jit_extr_u(JIT_R1, JIT_R2, 0, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 43);
    jit_extr_u(JIT_R1, JIT_R2, 0, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 44);
    jit_extr_u(JIT_R1, JIT_R2, 0, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 45);
    jit_extr_u(JIT_R1, JIT_R2, 0, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 46);
    jit_extr_u(JIT_R1, JIT_R2, 0, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 47);
    jit_extr_u(JIT_R1, JIT_R2, 0, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 48);
    jit_extr_u(JIT_R1, JIT_R2, 0, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 49);
    jit_extr_u(JIT_R1, JIT_R2, 0, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 50);
    jit_extr_u(JIT_R1, JIT_R2, 0, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 51);
    jit_extr_u(JIT_R1, JIT_R2, 0, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 52);
    jit_extr_u(JIT_R1, JIT_R2, 0, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 53);
    jit_extr_u(JIT_R1, JIT_R2, 0, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 54);
    jit_extr_u(JIT_R1, JIT_R2, 0, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 55);
    jit_extr_u(JIT_R1, JIT_R2, 0, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 56);
    jit_extr_u(JIT_R1, JIT_R2, 0, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU57 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 57) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 57);
    jit_extr_u(JIT_R1, JIT_R2, 0, 57);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU58 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 58) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 58);
    jit_extr_u(JIT_R1, JIT_R2, 0, 58);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU59 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 59) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 59);
    jit_extr_u(JIT_R1, JIT_R2, 0, 59);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU60 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 60) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 60);
    jit_extr_u(JIT_R1, JIT_R2, 0, 60);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU61 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 61) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 61);
    jit_extr_u(JIT_R1, JIT_R2, 0, 61);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU62 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 62) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 62);
    jit_extr_u(JIT_R1, JIT_R2, 0, 62);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU63 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, ((ONE << 63) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 0, 63);
    jit_extr_u(JIT_R1, JIT_R2, 0, 63);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU64 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
jit_movi(JIT_R1, 0);
    jit_depr(JIT_R2, JIT_R1, 0, 64);
    jit_extr_u(JIT_R1, JIT_R2, 0, 64);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
#endif
    /* Define jit functions for signed bitfields at offset 1 */
    nS1_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 1);
    jit_extr(JIT_R1, JIT_R2, 1, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 2);
    jit_extr(JIT_R1, JIT_R2, 1, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 3);
    jit_extr(JIT_R1, JIT_R2, 1, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 4);
    jit_extr(JIT_R1, JIT_R2, 1, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 5);
    jit_extr(JIT_R1, JIT_R2, 1, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 6);
    jit_extr(JIT_R1, JIT_R2, 1, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 7);
    jit_extr(JIT_R1, JIT_R2, 1, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 8);
    jit_extr(JIT_R1, JIT_R2, 1, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 9);
    jit_extr(JIT_R1, JIT_R2, 1, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 10);
    jit_extr(JIT_R1, JIT_R2, 1, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 11);
    jit_extr(JIT_R1, JIT_R2, 1, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 12);
    jit_extr(JIT_R1, JIT_R2, 1, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 13);
    jit_extr(JIT_R1, JIT_R2, 1, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 14);
    jit_extr(JIT_R1, JIT_R2, 1, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 15);
    jit_extr(JIT_R1, JIT_R2, 1, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 16);
    jit_extr(JIT_R1, JIT_R2, 1, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 17);
    jit_extr(JIT_R1, JIT_R2, 1, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 18);
    jit_extr(JIT_R1, JIT_R2, 1, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 19);
    jit_extr(JIT_R1, JIT_R2, 1, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 20);
    jit_extr(JIT_R1, JIT_R2, 1, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 21);
    jit_extr(JIT_R1, JIT_R2, 1, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 22);
    jit_extr(JIT_R1, JIT_R2, 1, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 23);
    jit_extr(JIT_R1, JIT_R2, 1, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 24);
    jit_extr(JIT_R1, JIT_R2, 1, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 25);
    jit_extr(JIT_R1, JIT_R2, 1, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 26);
    jit_extr(JIT_R1, JIT_R2, 1, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 27);
    jit_extr(JIT_R1, JIT_R2, 1, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 28);
    jit_extr(JIT_R1, JIT_R2, 1, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 29);
    jit_extr(JIT_R1, JIT_R2, 1, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 30);
    jit_extr(JIT_R1, JIT_R2, 1, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 31);
    jit_extr(JIT_R1, JIT_R2, 1, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 2 */
    nS2_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 1);
    jit_extr(JIT_R1, JIT_R2, 2, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 2);
    jit_extr(JIT_R1, JIT_R2, 2, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 3);
    jit_extr(JIT_R1, JIT_R2, 2, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 4);
    jit_extr(JIT_R1, JIT_R2, 2, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 5);
    jit_extr(JIT_R1, JIT_R2, 2, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 6);
    jit_extr(JIT_R1, JIT_R2, 2, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 7);
    jit_extr(JIT_R1, JIT_R2, 2, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 8);
    jit_extr(JIT_R1, JIT_R2, 2, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 9);
    jit_extr(JIT_R1, JIT_R2, 2, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 10);
    jit_extr(JIT_R1, JIT_R2, 2, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 11);
    jit_extr(JIT_R1, JIT_R2, 2, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 12);
    jit_extr(JIT_R1, JIT_R2, 2, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 13);
    jit_extr(JIT_R1, JIT_R2, 2, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 14);
    jit_extr(JIT_R1, JIT_R2, 2, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 15);
    jit_extr(JIT_R1, JIT_R2, 2, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 16);
    jit_extr(JIT_R1, JIT_R2, 2, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 17);
    jit_extr(JIT_R1, JIT_R2, 2, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 18);
    jit_extr(JIT_R1, JIT_R2, 2, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 19);
    jit_extr(JIT_R1, JIT_R2, 2, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 20);
    jit_extr(JIT_R1, JIT_R2, 2, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 21);
    jit_extr(JIT_R1, JIT_R2, 2, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 22);
    jit_extr(JIT_R1, JIT_R2, 2, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 23);
    jit_extr(JIT_R1, JIT_R2, 2, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 24);
    jit_extr(JIT_R1, JIT_R2, 2, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 25);
    jit_extr(JIT_R1, JIT_R2, 2, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 26);
    jit_extr(JIT_R1, JIT_R2, 2, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 27);
    jit_extr(JIT_R1, JIT_R2, 2, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 28);
    jit_extr(JIT_R1, JIT_R2, 2, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 29);
    jit_extr(JIT_R1, JIT_R2, 2, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 30);
    jit_extr(JIT_R1, JIT_R2, 2, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 3 */
    nS3_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 1);
    jit_extr(JIT_R1, JIT_R2, 3, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 2);
    jit_extr(JIT_R1, JIT_R2, 3, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 3);
    jit_extr(JIT_R1, JIT_R2, 3, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 4);
    jit_extr(JIT_R1, JIT_R2, 3, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 5);
    jit_extr(JIT_R1, JIT_R2, 3, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 6);
    jit_extr(JIT_R1, JIT_R2, 3, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 7);
    jit_extr(JIT_R1, JIT_R2, 3, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 8);
    jit_extr(JIT_R1, JIT_R2, 3, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 9);
    jit_extr(JIT_R1, JIT_R2, 3, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 10);
    jit_extr(JIT_R1, JIT_R2, 3, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 11);
    jit_extr(JIT_R1, JIT_R2, 3, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 12);
    jit_extr(JIT_R1, JIT_R2, 3, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 13);
    jit_extr(JIT_R1, JIT_R2, 3, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 14);
    jit_extr(JIT_R1, JIT_R2, 3, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 15);
    jit_extr(JIT_R1, JIT_R2, 3, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 16);
    jit_extr(JIT_R1, JIT_R2, 3, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 17);
    jit_extr(JIT_R1, JIT_R2, 3, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 18);
    jit_extr(JIT_R1, JIT_R2, 3, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 19);
    jit_extr(JIT_R1, JIT_R2, 3, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 20);
    jit_extr(JIT_R1, JIT_R2, 3, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 21);
    jit_extr(JIT_R1, JIT_R2, 3, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 22);
    jit_extr(JIT_R1, JIT_R2, 3, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 23);
    jit_extr(JIT_R1, JIT_R2, 3, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 24);
    jit_extr(JIT_R1, JIT_R2, 3, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 25);
    jit_extr(JIT_R1, JIT_R2, 3, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 26);
    jit_extr(JIT_R1, JIT_R2, 3, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 27);
    jit_extr(JIT_R1, JIT_R2, 3, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 28);
    jit_extr(JIT_R1, JIT_R2, 3, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 29);
    jit_extr(JIT_R1, JIT_R2, 3, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 4 */
    nS4_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 1);
    jit_extr(JIT_R1, JIT_R2, 4, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 2);
    jit_extr(JIT_R1, JIT_R2, 4, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 3);
    jit_extr(JIT_R1, JIT_R2, 4, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 4);
    jit_extr(JIT_R1, JIT_R2, 4, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 5);
    jit_extr(JIT_R1, JIT_R2, 4, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 6);
    jit_extr(JIT_R1, JIT_R2, 4, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 7);
    jit_extr(JIT_R1, JIT_R2, 4, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 8);
    jit_extr(JIT_R1, JIT_R2, 4, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 9);
    jit_extr(JIT_R1, JIT_R2, 4, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 10);
    jit_extr(JIT_R1, JIT_R2, 4, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 11);
    jit_extr(JIT_R1, JIT_R2, 4, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 12);
    jit_extr(JIT_R1, JIT_R2, 4, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 13);
    jit_extr(JIT_R1, JIT_R2, 4, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 14);
    jit_extr(JIT_R1, JIT_R2, 4, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 15);
    jit_extr(JIT_R1, JIT_R2, 4, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 16);
    jit_extr(JIT_R1, JIT_R2, 4, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 17);
    jit_extr(JIT_R1, JIT_R2, 4, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 18);
    jit_extr(JIT_R1, JIT_R2, 4, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 19);
    jit_extr(JIT_R1, JIT_R2, 4, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 20);
    jit_extr(JIT_R1, JIT_R2, 4, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 21);
    jit_extr(JIT_R1, JIT_R2, 4, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 22);
    jit_extr(JIT_R1, JIT_R2, 4, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 23);
    jit_extr(JIT_R1, JIT_R2, 4, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 24);
    jit_extr(JIT_R1, JIT_R2, 4, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 25);
    jit_extr(JIT_R1, JIT_R2, 4, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 26);
    jit_extr(JIT_R1, JIT_R2, 4, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 27);
    jit_extr(JIT_R1, JIT_R2, 4, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 28);
    jit_extr(JIT_R1, JIT_R2, 4, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 5 */
    nS5_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 1);
    jit_extr(JIT_R1, JIT_R2, 5, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 2);
    jit_extr(JIT_R1, JIT_R2, 5, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 3);
    jit_extr(JIT_R1, JIT_R2, 5, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 4);
    jit_extr(JIT_R1, JIT_R2, 5, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 5);
    jit_extr(JIT_R1, JIT_R2, 5, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 6);
    jit_extr(JIT_R1, JIT_R2, 5, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 7);
    jit_extr(JIT_R1, JIT_R2, 5, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 8);
    jit_extr(JIT_R1, JIT_R2, 5, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 9);
    jit_extr(JIT_R1, JIT_R2, 5, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 10);
    jit_extr(JIT_R1, JIT_R2, 5, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 11);
    jit_extr(JIT_R1, JIT_R2, 5, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 12);
    jit_extr(JIT_R1, JIT_R2, 5, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 13);
    jit_extr(JIT_R1, JIT_R2, 5, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 14);
    jit_extr(JIT_R1, JIT_R2, 5, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 15);
    jit_extr(JIT_R1, JIT_R2, 5, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 16);
    jit_extr(JIT_R1, JIT_R2, 5, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 17);
    jit_extr(JIT_R1, JIT_R2, 5, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 18);
    jit_extr(JIT_R1, JIT_R2, 5, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 19);
    jit_extr(JIT_R1, JIT_R2, 5, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 20);
    jit_extr(JIT_R1, JIT_R2, 5, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 21);
    jit_extr(JIT_R1, JIT_R2, 5, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 22);
    jit_extr(JIT_R1, JIT_R2, 5, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 23);
    jit_extr(JIT_R1, JIT_R2, 5, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 24);
    jit_extr(JIT_R1, JIT_R2, 5, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 25);
    jit_extr(JIT_R1, JIT_R2, 5, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 26);
    jit_extr(JIT_R1, JIT_R2, 5, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 27);
    jit_extr(JIT_R1, JIT_R2, 5, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 6 */
    nS6_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 1);
    jit_extr(JIT_R1, JIT_R2, 6, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 2);
    jit_extr(JIT_R1, JIT_R2, 6, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 3);
    jit_extr(JIT_R1, JIT_R2, 6, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 4);
    jit_extr(JIT_R1, JIT_R2, 6, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 5);
    jit_extr(JIT_R1, JIT_R2, 6, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 6);
    jit_extr(JIT_R1, JIT_R2, 6, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 7);
    jit_extr(JIT_R1, JIT_R2, 6, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 8);
    jit_extr(JIT_R1, JIT_R2, 6, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 9);
    jit_extr(JIT_R1, JIT_R2, 6, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 10);
    jit_extr(JIT_R1, JIT_R2, 6, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 11);
    jit_extr(JIT_R1, JIT_R2, 6, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 12);
    jit_extr(JIT_R1, JIT_R2, 6, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 13);
    jit_extr(JIT_R1, JIT_R2, 6, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 14);
    jit_extr(JIT_R1, JIT_R2, 6, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 15);
    jit_extr(JIT_R1, JIT_R2, 6, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 16);
    jit_extr(JIT_R1, JIT_R2, 6, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 17);
    jit_extr(JIT_R1, JIT_R2, 6, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 18);
    jit_extr(JIT_R1, JIT_R2, 6, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 19);
    jit_extr(JIT_R1, JIT_R2, 6, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 20);
    jit_extr(JIT_R1, JIT_R2, 6, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 21);
    jit_extr(JIT_R1, JIT_R2, 6, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 22);
    jit_extr(JIT_R1, JIT_R2, 6, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 23);
    jit_extr(JIT_R1, JIT_R2, 6, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 24);
    jit_extr(JIT_R1, JIT_R2, 6, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 25);
    jit_extr(JIT_R1, JIT_R2, 6, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 26);
    jit_extr(JIT_R1, JIT_R2, 6, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 7 */
    nS7_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 1);
    jit_extr(JIT_R1, JIT_R2, 7, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 2);
    jit_extr(JIT_R1, JIT_R2, 7, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 3);
    jit_extr(JIT_R1, JIT_R2, 7, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 4);
    jit_extr(JIT_R1, JIT_R2, 7, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 5);
    jit_extr(JIT_R1, JIT_R2, 7, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 6);
    jit_extr(JIT_R1, JIT_R2, 7, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 7);
    jit_extr(JIT_R1, JIT_R2, 7, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 8);
    jit_extr(JIT_R1, JIT_R2, 7, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 9);
    jit_extr(JIT_R1, JIT_R2, 7, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 10);
    jit_extr(JIT_R1, JIT_R2, 7, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 11);
    jit_extr(JIT_R1, JIT_R2, 7, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 12);
    jit_extr(JIT_R1, JIT_R2, 7, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 13);
    jit_extr(JIT_R1, JIT_R2, 7, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 14);
    jit_extr(JIT_R1, JIT_R2, 7, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 15);
    jit_extr(JIT_R1, JIT_R2, 7, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 16);
    jit_extr(JIT_R1, JIT_R2, 7, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 17);
    jit_extr(JIT_R1, JIT_R2, 7, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 18);
    jit_extr(JIT_R1, JIT_R2, 7, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 19);
    jit_extr(JIT_R1, JIT_R2, 7, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 20);
    jit_extr(JIT_R1, JIT_R2, 7, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 21);
    jit_extr(JIT_R1, JIT_R2, 7, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 22);
    jit_extr(JIT_R1, JIT_R2, 7, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 23);
    jit_extr(JIT_R1, JIT_R2, 7, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 24);
    jit_extr(JIT_R1, JIT_R2, 7, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 25);
    jit_extr(JIT_R1, JIT_R2, 7, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 8 */
    nS8_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 1);
    jit_extr(JIT_R1, JIT_R2, 8, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 2);
    jit_extr(JIT_R1, JIT_R2, 8, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 3);
    jit_extr(JIT_R1, JIT_R2, 8, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 4);
    jit_extr(JIT_R1, JIT_R2, 8, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 5);
    jit_extr(JIT_R1, JIT_R2, 8, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 6);
    jit_extr(JIT_R1, JIT_R2, 8, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 7);
    jit_extr(JIT_R1, JIT_R2, 8, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 8);
    jit_extr(JIT_R1, JIT_R2, 8, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 9);
    jit_extr(JIT_R1, JIT_R2, 8, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 10);
    jit_extr(JIT_R1, JIT_R2, 8, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 11);
    jit_extr(JIT_R1, JIT_R2, 8, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 12);
    jit_extr(JIT_R1, JIT_R2, 8, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 13);
    jit_extr(JIT_R1, JIT_R2, 8, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 14);
    jit_extr(JIT_R1, JIT_R2, 8, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 15);
    jit_extr(JIT_R1, JIT_R2, 8, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 16);
    jit_extr(JIT_R1, JIT_R2, 8, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 17);
    jit_extr(JIT_R1, JIT_R2, 8, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 18);
    jit_extr(JIT_R1, JIT_R2, 8, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 19);
    jit_extr(JIT_R1, JIT_R2, 8, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 20);
    jit_extr(JIT_R1, JIT_R2, 8, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 21);
    jit_extr(JIT_R1, JIT_R2, 8, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 22);
    jit_extr(JIT_R1, JIT_R2, 8, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 23);
    jit_extr(JIT_R1, JIT_R2, 8, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 24);
    jit_extr(JIT_R1, JIT_R2, 8, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 9 */
    nS9_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 1);
    jit_extr(JIT_R1, JIT_R2, 9, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 2);
    jit_extr(JIT_R1, JIT_R2, 9, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 3);
    jit_extr(JIT_R1, JIT_R2, 9, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 4);
    jit_extr(JIT_R1, JIT_R2, 9, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 5);
    jit_extr(JIT_R1, JIT_R2, 9, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 6);
    jit_extr(JIT_R1, JIT_R2, 9, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 7);
    jit_extr(JIT_R1, JIT_R2, 9, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 8);
    jit_extr(JIT_R1, JIT_R2, 9, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 9);
    jit_extr(JIT_R1, JIT_R2, 9, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 10);
    jit_extr(JIT_R1, JIT_R2, 9, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 11);
    jit_extr(JIT_R1, JIT_R2, 9, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 12);
    jit_extr(JIT_R1, JIT_R2, 9, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 13);
    jit_extr(JIT_R1, JIT_R2, 9, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 14);
    jit_extr(JIT_R1, JIT_R2, 9, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 15);
    jit_extr(JIT_R1, JIT_R2, 9, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 16);
    jit_extr(JIT_R1, JIT_R2, 9, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 17);
    jit_extr(JIT_R1, JIT_R2, 9, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 18);
    jit_extr(JIT_R1, JIT_R2, 9, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 19);
    jit_extr(JIT_R1, JIT_R2, 9, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 20);
    jit_extr(JIT_R1, JIT_R2, 9, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 21);
    jit_extr(JIT_R1, JIT_R2, 9, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 22);
    jit_extr(JIT_R1, JIT_R2, 9, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 23);
    jit_extr(JIT_R1, JIT_R2, 9, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 10 */
    nS10_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 1);
    jit_extr(JIT_R1, JIT_R2, 10, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 2);
    jit_extr(JIT_R1, JIT_R2, 10, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 3);
    jit_extr(JIT_R1, JIT_R2, 10, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 4);
    jit_extr(JIT_R1, JIT_R2, 10, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 5);
    jit_extr(JIT_R1, JIT_R2, 10, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 6);
    jit_extr(JIT_R1, JIT_R2, 10, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 7);
    jit_extr(JIT_R1, JIT_R2, 10, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 8);
    jit_extr(JIT_R1, JIT_R2, 10, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 9);
    jit_extr(JIT_R1, JIT_R2, 10, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 10);
    jit_extr(JIT_R1, JIT_R2, 10, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 11);
    jit_extr(JIT_R1, JIT_R2, 10, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 12);
    jit_extr(JIT_R1, JIT_R2, 10, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 13);
    jit_extr(JIT_R1, JIT_R2, 10, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 14);
    jit_extr(JIT_R1, JIT_R2, 10, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 15);
    jit_extr(JIT_R1, JIT_R2, 10, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 16);
    jit_extr(JIT_R1, JIT_R2, 10, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 17);
    jit_extr(JIT_R1, JIT_R2, 10, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 18);
    jit_extr(JIT_R1, JIT_R2, 10, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 19);
    jit_extr(JIT_R1, JIT_R2, 10, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 20);
    jit_extr(JIT_R1, JIT_R2, 10, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 21);
    jit_extr(JIT_R1, JIT_R2, 10, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 22);
    jit_extr(JIT_R1, JIT_R2, 10, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 11 */
    nS11_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 1);
    jit_extr(JIT_R1, JIT_R2, 11, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 2);
    jit_extr(JIT_R1, JIT_R2, 11, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 3);
    jit_extr(JIT_R1, JIT_R2, 11, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 4);
    jit_extr(JIT_R1, JIT_R2, 11, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 5);
    jit_extr(JIT_R1, JIT_R2, 11, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 6);
    jit_extr(JIT_R1, JIT_R2, 11, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 7);
    jit_extr(JIT_R1, JIT_R2, 11, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 8);
    jit_extr(JIT_R1, JIT_R2, 11, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 9);
    jit_extr(JIT_R1, JIT_R2, 11, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 10);
    jit_extr(JIT_R1, JIT_R2, 11, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 11);
    jit_extr(JIT_R1, JIT_R2, 11, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 12);
    jit_extr(JIT_R1, JIT_R2, 11, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 13);
    jit_extr(JIT_R1, JIT_R2, 11, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 14);
    jit_extr(JIT_R1, JIT_R2, 11, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 15);
    jit_extr(JIT_R1, JIT_R2, 11, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 16);
    jit_extr(JIT_R1, JIT_R2, 11, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 17);
    jit_extr(JIT_R1, JIT_R2, 11, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 18);
    jit_extr(JIT_R1, JIT_R2, 11, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 19);
    jit_extr(JIT_R1, JIT_R2, 11, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 20);
    jit_extr(JIT_R1, JIT_R2, 11, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 21);
    jit_extr(JIT_R1, JIT_R2, 11, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 12 */
    nS12_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 1);
    jit_extr(JIT_R1, JIT_R2, 12, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 2);
    jit_extr(JIT_R1, JIT_R2, 12, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 3);
    jit_extr(JIT_R1, JIT_R2, 12, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 4);
    jit_extr(JIT_R1, JIT_R2, 12, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 5);
    jit_extr(JIT_R1, JIT_R2, 12, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 6);
    jit_extr(JIT_R1, JIT_R2, 12, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 7);
    jit_extr(JIT_R1, JIT_R2, 12, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 8);
    jit_extr(JIT_R1, JIT_R2, 12, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 9);
    jit_extr(JIT_R1, JIT_R2, 12, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 10);
    jit_extr(JIT_R1, JIT_R2, 12, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 11);
    jit_extr(JIT_R1, JIT_R2, 12, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 12);
    jit_extr(JIT_R1, JIT_R2, 12, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 13);
    jit_extr(JIT_R1, JIT_R2, 12, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 14);
    jit_extr(JIT_R1, JIT_R2, 12, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 15);
    jit_extr(JIT_R1, JIT_R2, 12, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 16);
    jit_extr(JIT_R1, JIT_R2, 12, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 17);
    jit_extr(JIT_R1, JIT_R2, 12, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 18);
    jit_extr(JIT_R1, JIT_R2, 12, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 19);
    jit_extr(JIT_R1, JIT_R2, 12, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 20);
    jit_extr(JIT_R1, JIT_R2, 12, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 13 */
    nS13_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 1);
    jit_extr(JIT_R1, JIT_R2, 13, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 2);
    jit_extr(JIT_R1, JIT_R2, 13, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 3);
    jit_extr(JIT_R1, JIT_R2, 13, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 4);
    jit_extr(JIT_R1, JIT_R2, 13, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 5);
    jit_extr(JIT_R1, JIT_R2, 13, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 6);
    jit_extr(JIT_R1, JIT_R2, 13, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 7);
    jit_extr(JIT_R1, JIT_R2, 13, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 8);
    jit_extr(JIT_R1, JIT_R2, 13, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 9);
    jit_extr(JIT_R1, JIT_R2, 13, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 10);
    jit_extr(JIT_R1, JIT_R2, 13, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 11);
    jit_extr(JIT_R1, JIT_R2, 13, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 12);
    jit_extr(JIT_R1, JIT_R2, 13, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 13);
    jit_extr(JIT_R1, JIT_R2, 13, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 14);
    jit_extr(JIT_R1, JIT_R2, 13, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 15);
    jit_extr(JIT_R1, JIT_R2, 13, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 16);
    jit_extr(JIT_R1, JIT_R2, 13, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 17);
    jit_extr(JIT_R1, JIT_R2, 13, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 18);
    jit_extr(JIT_R1, JIT_R2, 13, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 19);
    jit_extr(JIT_R1, JIT_R2, 13, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 14 */
    nS14_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 1);
    jit_extr(JIT_R1, JIT_R2, 14, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 2);
    jit_extr(JIT_R1, JIT_R2, 14, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 3);
    jit_extr(JIT_R1, JIT_R2, 14, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 4);
    jit_extr(JIT_R1, JIT_R2, 14, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 5);
    jit_extr(JIT_R1, JIT_R2, 14, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 6);
    jit_extr(JIT_R1, JIT_R2, 14, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 7);
    jit_extr(JIT_R1, JIT_R2, 14, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 8);
    jit_extr(JIT_R1, JIT_R2, 14, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 9);
    jit_extr(JIT_R1, JIT_R2, 14, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 10);
    jit_extr(JIT_R1, JIT_R2, 14, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 11);
    jit_extr(JIT_R1, JIT_R2, 14, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 12);
    jit_extr(JIT_R1, JIT_R2, 14, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 13);
    jit_extr(JIT_R1, JIT_R2, 14, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 14);
    jit_extr(JIT_R1, JIT_R2, 14, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 15);
    jit_extr(JIT_R1, JIT_R2, 14, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 16);
    jit_extr(JIT_R1, JIT_R2, 14, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 17);
    jit_extr(JIT_R1, JIT_R2, 14, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 18);
    jit_extr(JIT_R1, JIT_R2, 14, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 15 */
    nS15_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 1);
    jit_extr(JIT_R1, JIT_R2, 15, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 2);
    jit_extr(JIT_R1, JIT_R2, 15, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 3);
    jit_extr(JIT_R1, JIT_R2, 15, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 4);
    jit_extr(JIT_R1, JIT_R2, 15, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 5);
    jit_extr(JIT_R1, JIT_R2, 15, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 6);
    jit_extr(JIT_R1, JIT_R2, 15, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 7);
    jit_extr(JIT_R1, JIT_R2, 15, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 8);
    jit_extr(JIT_R1, JIT_R2, 15, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 9);
    jit_extr(JIT_R1, JIT_R2, 15, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 10);
    jit_extr(JIT_R1, JIT_R2, 15, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 11);
    jit_extr(JIT_R1, JIT_R2, 15, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 12);
    jit_extr(JIT_R1, JIT_R2, 15, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 13);
    jit_extr(JIT_R1, JIT_R2, 15, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 14);
    jit_extr(JIT_R1, JIT_R2, 15, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 15);
    jit_extr(JIT_R1, JIT_R2, 15, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 16);
    jit_extr(JIT_R1, JIT_R2, 15, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 17);
    jit_extr(JIT_R1, JIT_R2, 15, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 16 */
    nS16_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 1);
    jit_extr(JIT_R1, JIT_R2, 16, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 2);
    jit_extr(JIT_R1, JIT_R2, 16, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 3);
    jit_extr(JIT_R1, JIT_R2, 16, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 4);
    jit_extr(JIT_R1, JIT_R2, 16, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 5);
    jit_extr(JIT_R1, JIT_R2, 16, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 6);
    jit_extr(JIT_R1, JIT_R2, 16, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 7);
    jit_extr(JIT_R1, JIT_R2, 16, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 8);
    jit_extr(JIT_R1, JIT_R2, 16, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 9);
    jit_extr(JIT_R1, JIT_R2, 16, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 10);
    jit_extr(JIT_R1, JIT_R2, 16, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 11);
    jit_extr(JIT_R1, JIT_R2, 16, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 12);
    jit_extr(JIT_R1, JIT_R2, 16, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 13);
    jit_extr(JIT_R1, JIT_R2, 16, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 14);
    jit_extr(JIT_R1, JIT_R2, 16, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 15);
    jit_extr(JIT_R1, JIT_R2, 16, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 16);
    jit_extr(JIT_R1, JIT_R2, 16, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 17 */
    nS17_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 1);
    jit_extr(JIT_R1, JIT_R2, 17, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 2);
    jit_extr(JIT_R1, JIT_R2, 17, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 3);
    jit_extr(JIT_R1, JIT_R2, 17, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 4);
    jit_extr(JIT_R1, JIT_R2, 17, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 5);
    jit_extr(JIT_R1, JIT_R2, 17, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 6);
    jit_extr(JIT_R1, JIT_R2, 17, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 7);
    jit_extr(JIT_R1, JIT_R2, 17, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 8);
    jit_extr(JIT_R1, JIT_R2, 17, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 9);
    jit_extr(JIT_R1, JIT_R2, 17, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 10);
    jit_extr(JIT_R1, JIT_R2, 17, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 11);
    jit_extr(JIT_R1, JIT_R2, 17, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 12);
    jit_extr(JIT_R1, JIT_R2, 17, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 13);
    jit_extr(JIT_R1, JIT_R2, 17, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 14);
    jit_extr(JIT_R1, JIT_R2, 17, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 15);
    jit_extr(JIT_R1, JIT_R2, 17, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 18 */
    nS18_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 1);
    jit_extr(JIT_R1, JIT_R2, 18, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 2);
    jit_extr(JIT_R1, JIT_R2, 18, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 3);
    jit_extr(JIT_R1, JIT_R2, 18, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 4);
    jit_extr(JIT_R1, JIT_R2, 18, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 5);
    jit_extr(JIT_R1, JIT_R2, 18, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 6);
    jit_extr(JIT_R1, JIT_R2, 18, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 7);
    jit_extr(JIT_R1, JIT_R2, 18, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 8);
    jit_extr(JIT_R1, JIT_R2, 18, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 9);
    jit_extr(JIT_R1, JIT_R2, 18, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 10);
    jit_extr(JIT_R1, JIT_R2, 18, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 11);
    jit_extr(JIT_R1, JIT_R2, 18, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 12);
    jit_extr(JIT_R1, JIT_R2, 18, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 13);
    jit_extr(JIT_R1, JIT_R2, 18, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 14);
    jit_extr(JIT_R1, JIT_R2, 18, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 19 */
    nS19_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 1);
    jit_extr(JIT_R1, JIT_R2, 19, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 2);
    jit_extr(JIT_R1, JIT_R2, 19, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 3);
    jit_extr(JIT_R1, JIT_R2, 19, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 4);
    jit_extr(JIT_R1, JIT_R2, 19, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 5);
    jit_extr(JIT_R1, JIT_R2, 19, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 6);
    jit_extr(JIT_R1, JIT_R2, 19, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 7);
    jit_extr(JIT_R1, JIT_R2, 19, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 8);
    jit_extr(JIT_R1, JIT_R2, 19, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 9);
    jit_extr(JIT_R1, JIT_R2, 19, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 10);
    jit_extr(JIT_R1, JIT_R2, 19, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 11);
    jit_extr(JIT_R1, JIT_R2, 19, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 12);
    jit_extr(JIT_R1, JIT_R2, 19, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 13);
    jit_extr(JIT_R1, JIT_R2, 19, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 20 */
    nS20_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 1);
    jit_extr(JIT_R1, JIT_R2, 20, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 2);
    jit_extr(JIT_R1, JIT_R2, 20, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 3);
    jit_extr(JIT_R1, JIT_R2, 20, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 4);
    jit_extr(JIT_R1, JIT_R2, 20, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 5);
    jit_extr(JIT_R1, JIT_R2, 20, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 6);
    jit_extr(JIT_R1, JIT_R2, 20, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 7);
    jit_extr(JIT_R1, JIT_R2, 20, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 8);
    jit_extr(JIT_R1, JIT_R2, 20, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 9);
    jit_extr(JIT_R1, JIT_R2, 20, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 10);
    jit_extr(JIT_R1, JIT_R2, 20, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 11);
    jit_extr(JIT_R1, JIT_R2, 20, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 12);
    jit_extr(JIT_R1, JIT_R2, 20, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 21 */
    nS21_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 1);
    jit_extr(JIT_R1, JIT_R2, 21, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 2);
    jit_extr(JIT_R1, JIT_R2, 21, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 3);
    jit_extr(JIT_R1, JIT_R2, 21, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 4);
    jit_extr(JIT_R1, JIT_R2, 21, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 5);
    jit_extr(JIT_R1, JIT_R2, 21, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 6);
    jit_extr(JIT_R1, JIT_R2, 21, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 7);
    jit_extr(JIT_R1, JIT_R2, 21, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 8);
    jit_extr(JIT_R1, JIT_R2, 21, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 9);
    jit_extr(JIT_R1, JIT_R2, 21, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 10);
    jit_extr(JIT_R1, JIT_R2, 21, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 11);
    jit_extr(JIT_R1, JIT_R2, 21, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 22 */
    nS22_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 1);
    jit_extr(JIT_R1, JIT_R2, 22, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 2);
    jit_extr(JIT_R1, JIT_R2, 22, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 3);
    jit_extr(JIT_R1, JIT_R2, 22, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 4);
    jit_extr(JIT_R1, JIT_R2, 22, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 5);
    jit_extr(JIT_R1, JIT_R2, 22, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 6);
    jit_extr(JIT_R1, JIT_R2, 22, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 7);
    jit_extr(JIT_R1, JIT_R2, 22, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 8);
    jit_extr(JIT_R1, JIT_R2, 22, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 9);
    jit_extr(JIT_R1, JIT_R2, 22, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 10);
    jit_extr(JIT_R1, JIT_R2, 22, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 23 */
    nS23_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 1);
    jit_extr(JIT_R1, JIT_R2, 23, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 2);
    jit_extr(JIT_R1, JIT_R2, 23, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 3);
    jit_extr(JIT_R1, JIT_R2, 23, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 4);
    jit_extr(JIT_R1, JIT_R2, 23, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 5);
    jit_extr(JIT_R1, JIT_R2, 23, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 6);
    jit_extr(JIT_R1, JIT_R2, 23, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 7);
    jit_extr(JIT_R1, JIT_R2, 23, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 8);
    jit_extr(JIT_R1, JIT_R2, 23, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 9);
    jit_extr(JIT_R1, JIT_R2, 23, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 24 */
    nS24_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 1);
    jit_extr(JIT_R1, JIT_R2, 24, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 2);
    jit_extr(JIT_R1, JIT_R2, 24, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 3);
    jit_extr(JIT_R1, JIT_R2, 24, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 4);
    jit_extr(JIT_R1, JIT_R2, 24, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 5);
    jit_extr(JIT_R1, JIT_R2, 24, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 6);
    jit_extr(JIT_R1, JIT_R2, 24, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 7);
    jit_extr(JIT_R1, JIT_R2, 24, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 8);
    jit_extr(JIT_R1, JIT_R2, 24, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 25 */
    nS25_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 1);
    jit_extr(JIT_R1, JIT_R2, 25, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 2);
    jit_extr(JIT_R1, JIT_R2, 25, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 3);
    jit_extr(JIT_R1, JIT_R2, 25, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 4);
    jit_extr(JIT_R1, JIT_R2, 25, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 5);
    jit_extr(JIT_R1, JIT_R2, 25, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 6);
    jit_extr(JIT_R1, JIT_R2, 25, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 7);
    jit_extr(JIT_R1, JIT_R2, 25, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 26 */
    nS26_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 1);
    jit_extr(JIT_R1, JIT_R2, 26, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 2);
    jit_extr(JIT_R1, JIT_R2, 26, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 3);
    jit_extr(JIT_R1, JIT_R2, 26, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 4);
    jit_extr(JIT_R1, JIT_R2, 26, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 5);
    jit_extr(JIT_R1, JIT_R2, 26, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 6);
    jit_extr(JIT_R1, JIT_R2, 26, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 27 */
    nS27_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 1);
    jit_extr(JIT_R1, JIT_R2, 27, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 2);
    jit_extr(JIT_R1, JIT_R2, 27, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 3);
    jit_extr(JIT_R1, JIT_R2, 27, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 4);
    jit_extr(JIT_R1, JIT_R2, 27, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 5);
    jit_extr(JIT_R1, JIT_R2, 27, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 28 */
    nS28_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 1);
    jit_extr(JIT_R1, JIT_R2, 28, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 2);
    jit_extr(JIT_R1, JIT_R2, 28, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 3);
    jit_extr(JIT_R1, JIT_R2, 28, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 4);
    jit_extr(JIT_R1, JIT_R2, 28, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 29 */
    nS29_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 1);
    jit_extr(JIT_R1, JIT_R2, 29, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 2);
    jit_extr(JIT_R1, JIT_R2, 29, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 3);
    jit_extr(JIT_R1, JIT_R2, 29, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 30 */
    nS30_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 1);
    jit_extr(JIT_R1, JIT_R2, 30, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 2);
    jit_extr(JIT_R1, JIT_R2, 30, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for signed bitfields at offset 31 */
    nS31_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 1);
    jit_extr(JIT_R1, JIT_R2, 31, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
#if __WORDSIZE == 64 && !SKIP_64_BITS
    /* Declare jit functions for signed bitfields at offset 1 */
    nS1_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 32);
    jit_extr(JIT_R1, JIT_R2, 1, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 33);
    jit_extr(JIT_R1, JIT_R2, 1, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 34);
    jit_extr(JIT_R1, JIT_R2, 1, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 35);
    jit_extr(JIT_R1, JIT_R2, 1, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 36);
    jit_extr(JIT_R1, JIT_R2, 1, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 37);
    jit_extr(JIT_R1, JIT_R2, 1, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 38);
    jit_extr(JIT_R1, JIT_R2, 1, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 39);
    jit_extr(JIT_R1, JIT_R2, 1, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 40);
    jit_extr(JIT_R1, JIT_R2, 1, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 41);
    jit_extr(JIT_R1, JIT_R2, 1, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 42);
    jit_extr(JIT_R1, JIT_R2, 1, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 43);
    jit_extr(JIT_R1, JIT_R2, 1, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 44);
    jit_extr(JIT_R1, JIT_R2, 1, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 45);
    jit_extr(JIT_R1, JIT_R2, 1, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 46);
    jit_extr(JIT_R1, JIT_R2, 1, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 47);
    jit_extr(JIT_R1, JIT_R2, 1, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 48);
    jit_extr(JIT_R1, JIT_R2, 1, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 49);
    jit_extr(JIT_R1, JIT_R2, 1, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 50);
    jit_extr(JIT_R1, JIT_R2, 1, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 51);
    jit_extr(JIT_R1, JIT_R2, 1, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 52);
    jit_extr(JIT_R1, JIT_R2, 1, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 53);
    jit_extr(JIT_R1, JIT_R2, 1, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 54);
    jit_extr(JIT_R1, JIT_R2, 1, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 55);
    jit_extr(JIT_R1, JIT_R2, 1, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 56);
    jit_extr(JIT_R1, JIT_R2, 1, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_57 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 57) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 57);
    jit_extr(JIT_R1, JIT_R2, 1, 57);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_58 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 58) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 58);
    jit_extr(JIT_R1, JIT_R2, 1, 58);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_59 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 59) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 59);
    jit_extr(JIT_R1, JIT_R2, 1, 59);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_60 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 60) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 60);
    jit_extr(JIT_R1, JIT_R2, 1, 60);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_61 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 61) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 61);
    jit_extr(JIT_R1, JIT_R2, 1, 61);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_62 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 62) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 62);
    jit_extr(JIT_R1, JIT_R2, 1, 62);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS1_63 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 63) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 63);
    jit_extr(JIT_R1, JIT_R2, 1, 63);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 2 */
    nS2_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 31);
    jit_extr(JIT_R1, JIT_R2, 2, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 32);
    jit_extr(JIT_R1, JIT_R2, 2, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 33);
    jit_extr(JIT_R1, JIT_R2, 2, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 34);
    jit_extr(JIT_R1, JIT_R2, 2, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 35);
    jit_extr(JIT_R1, JIT_R2, 2, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 36);
    jit_extr(JIT_R1, JIT_R2, 2, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 37);
    jit_extr(JIT_R1, JIT_R2, 2, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 38);
    jit_extr(JIT_R1, JIT_R2, 2, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 39);
    jit_extr(JIT_R1, JIT_R2, 2, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 40);
    jit_extr(JIT_R1, JIT_R2, 2, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 41);
    jit_extr(JIT_R1, JIT_R2, 2, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 42);
    jit_extr(JIT_R1, JIT_R2, 2, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 43);
    jit_extr(JIT_R1, JIT_R2, 2, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 44);
    jit_extr(JIT_R1, JIT_R2, 2, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 45);
    jit_extr(JIT_R1, JIT_R2, 2, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 46);
    jit_extr(JIT_R1, JIT_R2, 2, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 47);
    jit_extr(JIT_R1, JIT_R2, 2, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 48);
    jit_extr(JIT_R1, JIT_R2, 2, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 49);
    jit_extr(JIT_R1, JIT_R2, 2, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 50);
    jit_extr(JIT_R1, JIT_R2, 2, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 51);
    jit_extr(JIT_R1, JIT_R2, 2, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 52);
    jit_extr(JIT_R1, JIT_R2, 2, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 53);
    jit_extr(JIT_R1, JIT_R2, 2, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 54);
    jit_extr(JIT_R1, JIT_R2, 2, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 55);
    jit_extr(JIT_R1, JIT_R2, 2, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 56);
    jit_extr(JIT_R1, JIT_R2, 2, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_57 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 57) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 57);
    jit_extr(JIT_R1, JIT_R2, 2, 57);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_58 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 58) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 58);
    jit_extr(JIT_R1, JIT_R2, 2, 58);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_59 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 59) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 59);
    jit_extr(JIT_R1, JIT_R2, 2, 59);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_60 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 60) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 60);
    jit_extr(JIT_R1, JIT_R2, 2, 60);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_61 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 61) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 61);
    jit_extr(JIT_R1, JIT_R2, 2, 61);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS2_62 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 62) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 62);
    jit_extr(JIT_R1, JIT_R2, 2, 62);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 3 */
    nS3_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 30);
    jit_extr(JIT_R1, JIT_R2, 3, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 31);
    jit_extr(JIT_R1, JIT_R2, 3, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 32);
    jit_extr(JIT_R1, JIT_R2, 3, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 33);
    jit_extr(JIT_R1, JIT_R2, 3, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 34);
    jit_extr(JIT_R1, JIT_R2, 3, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 35);
    jit_extr(JIT_R1, JIT_R2, 3, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 36);
    jit_extr(JIT_R1, JIT_R2, 3, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 37);
    jit_extr(JIT_R1, JIT_R2, 3, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 38);
    jit_extr(JIT_R1, JIT_R2, 3, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 39);
    jit_extr(JIT_R1, JIT_R2, 3, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 40);
    jit_extr(JIT_R1, JIT_R2, 3, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 41);
    jit_extr(JIT_R1, JIT_R2, 3, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 42);
    jit_extr(JIT_R1, JIT_R2, 3, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 43);
    jit_extr(JIT_R1, JIT_R2, 3, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 44);
    jit_extr(JIT_R1, JIT_R2, 3, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 45);
    jit_extr(JIT_R1, JIT_R2, 3, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 46);
    jit_extr(JIT_R1, JIT_R2, 3, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 47);
    jit_extr(JIT_R1, JIT_R2, 3, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 48);
    jit_extr(JIT_R1, JIT_R2, 3, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 49);
    jit_extr(JIT_R1, JIT_R2, 3, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 50);
    jit_extr(JIT_R1, JIT_R2, 3, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 51);
    jit_extr(JIT_R1, JIT_R2, 3, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 52);
    jit_extr(JIT_R1, JIT_R2, 3, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 53);
    jit_extr(JIT_R1, JIT_R2, 3, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 54);
    jit_extr(JIT_R1, JIT_R2, 3, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 55);
    jit_extr(JIT_R1, JIT_R2, 3, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 56);
    jit_extr(JIT_R1, JIT_R2, 3, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_57 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 57) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 57);
    jit_extr(JIT_R1, JIT_R2, 3, 57);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_58 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 58) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 58);
    jit_extr(JIT_R1, JIT_R2, 3, 58);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_59 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 59) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 59);
    jit_extr(JIT_R1, JIT_R2, 3, 59);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_60 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 60) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 60);
    jit_extr(JIT_R1, JIT_R2, 3, 60);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS3_61 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 61) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 61);
    jit_extr(JIT_R1, JIT_R2, 3, 61);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 4 */
    nS4_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 29);
    jit_extr(JIT_R1, JIT_R2, 4, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 30);
    jit_extr(JIT_R1, JIT_R2, 4, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 31);
    jit_extr(JIT_R1, JIT_R2, 4, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 32);
    jit_extr(JIT_R1, JIT_R2, 4, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 33);
    jit_extr(JIT_R1, JIT_R2, 4, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 34);
    jit_extr(JIT_R1, JIT_R2, 4, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 35);
    jit_extr(JIT_R1, JIT_R2, 4, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 36);
    jit_extr(JIT_R1, JIT_R2, 4, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 37);
    jit_extr(JIT_R1, JIT_R2, 4, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 38);
    jit_extr(JIT_R1, JIT_R2, 4, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 39);
    jit_extr(JIT_R1, JIT_R2, 4, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 40);
    jit_extr(JIT_R1, JIT_R2, 4, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 41);
    jit_extr(JIT_R1, JIT_R2, 4, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 42);
    jit_extr(JIT_R1, JIT_R2, 4, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 43);
    jit_extr(JIT_R1, JIT_R2, 4, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 44);
    jit_extr(JIT_R1, JIT_R2, 4, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 45);
    jit_extr(JIT_R1, JIT_R2, 4, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 46);
    jit_extr(JIT_R1, JIT_R2, 4, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 47);
    jit_extr(JIT_R1, JIT_R2, 4, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 48);
    jit_extr(JIT_R1, JIT_R2, 4, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 49);
    jit_extr(JIT_R1, JIT_R2, 4, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 50);
    jit_extr(JIT_R1, JIT_R2, 4, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 51);
    jit_extr(JIT_R1, JIT_R2, 4, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 52);
    jit_extr(JIT_R1, JIT_R2, 4, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 53);
    jit_extr(JIT_R1, JIT_R2, 4, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 54);
    jit_extr(JIT_R1, JIT_R2, 4, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 55);
    jit_extr(JIT_R1, JIT_R2, 4, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 56);
    jit_extr(JIT_R1, JIT_R2, 4, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_57 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 57) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 57);
    jit_extr(JIT_R1, JIT_R2, 4, 57);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_58 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 58) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 58);
    jit_extr(JIT_R1, JIT_R2, 4, 58);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_59 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 59) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 59);
    jit_extr(JIT_R1, JIT_R2, 4, 59);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS4_60 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 60) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 60);
    jit_extr(JIT_R1, JIT_R2, 4, 60);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 5 */
    nS5_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 28);
    jit_extr(JIT_R1, JIT_R2, 5, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 29);
    jit_extr(JIT_R1, JIT_R2, 5, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 30);
    jit_extr(JIT_R1, JIT_R2, 5, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 31);
    jit_extr(JIT_R1, JIT_R2, 5, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 32);
    jit_extr(JIT_R1, JIT_R2, 5, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 33);
    jit_extr(JIT_R1, JIT_R2, 5, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 34);
    jit_extr(JIT_R1, JIT_R2, 5, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 35);
    jit_extr(JIT_R1, JIT_R2, 5, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 36);
    jit_extr(JIT_R1, JIT_R2, 5, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 37);
    jit_extr(JIT_R1, JIT_R2, 5, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 38);
    jit_extr(JIT_R1, JIT_R2, 5, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 39);
    jit_extr(JIT_R1, JIT_R2, 5, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 40);
    jit_extr(JIT_R1, JIT_R2, 5, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 41);
    jit_extr(JIT_R1, JIT_R2, 5, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 42);
    jit_extr(JIT_R1, JIT_R2, 5, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 43);
    jit_extr(JIT_R1, JIT_R2, 5, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 44);
    jit_extr(JIT_R1, JIT_R2, 5, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 45);
    jit_extr(JIT_R1, JIT_R2, 5, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 46);
    jit_extr(JIT_R1, JIT_R2, 5, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 47);
    jit_extr(JIT_R1, JIT_R2, 5, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 48);
    jit_extr(JIT_R1, JIT_R2, 5, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 49);
    jit_extr(JIT_R1, JIT_R2, 5, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 50);
    jit_extr(JIT_R1, JIT_R2, 5, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 51);
    jit_extr(JIT_R1, JIT_R2, 5, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 52);
    jit_extr(JIT_R1, JIT_R2, 5, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 53);
    jit_extr(JIT_R1, JIT_R2, 5, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 54);
    jit_extr(JIT_R1, JIT_R2, 5, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 55);
    jit_extr(JIT_R1, JIT_R2, 5, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 56);
    jit_extr(JIT_R1, JIT_R2, 5, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_57 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 57) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 57);
    jit_extr(JIT_R1, JIT_R2, 5, 57);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_58 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 58) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 58);
    jit_extr(JIT_R1, JIT_R2, 5, 58);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS5_59 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 59) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 5, 59);
    jit_extr(JIT_R1, JIT_R2, 5, 59);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 6 */
    nS6_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 27);
    jit_extr(JIT_R1, JIT_R2, 6, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 28);
    jit_extr(JIT_R1, JIT_R2, 6, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 29);
    jit_extr(JIT_R1, JIT_R2, 6, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 30);
    jit_extr(JIT_R1, JIT_R2, 6, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 31);
    jit_extr(JIT_R1, JIT_R2, 6, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 32);
    jit_extr(JIT_R1, JIT_R2, 6, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 33);
    jit_extr(JIT_R1, JIT_R2, 6, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 34);
    jit_extr(JIT_R1, JIT_R2, 6, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 35);
    jit_extr(JIT_R1, JIT_R2, 6, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 36);
    jit_extr(JIT_R1, JIT_R2, 6, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 37);
    jit_extr(JIT_R1, JIT_R2, 6, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 38);
    jit_extr(JIT_R1, JIT_R2, 6, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 39);
    jit_extr(JIT_R1, JIT_R2, 6, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 40);
    jit_extr(JIT_R1, JIT_R2, 6, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 41);
    jit_extr(JIT_R1, JIT_R2, 6, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 42);
    jit_extr(JIT_R1, JIT_R2, 6, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 43);
    jit_extr(JIT_R1, JIT_R2, 6, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 44);
    jit_extr(JIT_R1, JIT_R2, 6, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 45);
    jit_extr(JIT_R1, JIT_R2, 6, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 46);
    jit_extr(JIT_R1, JIT_R2, 6, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 47);
    jit_extr(JIT_R1, JIT_R2, 6, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 48);
    jit_extr(JIT_R1, JIT_R2, 6, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 49);
    jit_extr(JIT_R1, JIT_R2, 6, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 50);
    jit_extr(JIT_R1, JIT_R2, 6, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 51);
    jit_extr(JIT_R1, JIT_R2, 6, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 52);
    jit_extr(JIT_R1, JIT_R2, 6, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 53);
    jit_extr(JIT_R1, JIT_R2, 6, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 54);
    jit_extr(JIT_R1, JIT_R2, 6, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 55);
    jit_extr(JIT_R1, JIT_R2, 6, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 56);
    jit_extr(JIT_R1, JIT_R2, 6, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_57 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 57) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 57);
    jit_extr(JIT_R1, JIT_R2, 6, 57);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS6_58 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 58) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 6, 58);
    jit_extr(JIT_R1, JIT_R2, 6, 58);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 7 */
    nS7_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 26);
    jit_extr(JIT_R1, JIT_R2, 7, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 27);
    jit_extr(JIT_R1, JIT_R2, 7, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 28);
    jit_extr(JIT_R1, JIT_R2, 7, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 29);
    jit_extr(JIT_R1, JIT_R2, 7, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 30);
    jit_extr(JIT_R1, JIT_R2, 7, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 31);
    jit_extr(JIT_R1, JIT_R2, 7, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 32);
    jit_extr(JIT_R1, JIT_R2, 7, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 33);
    jit_extr(JIT_R1, JIT_R2, 7, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 34);
    jit_extr(JIT_R1, JIT_R2, 7, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 35);
    jit_extr(JIT_R1, JIT_R2, 7, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 36);
    jit_extr(JIT_R1, JIT_R2, 7, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 37);
    jit_extr(JIT_R1, JIT_R2, 7, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 38);
    jit_extr(JIT_R1, JIT_R2, 7, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 39);
    jit_extr(JIT_R1, JIT_R2, 7, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 40);
    jit_extr(JIT_R1, JIT_R2, 7, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 41);
    jit_extr(JIT_R1, JIT_R2, 7, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 42);
    jit_extr(JIT_R1, JIT_R2, 7, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 43);
    jit_extr(JIT_R1, JIT_R2, 7, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 44);
    jit_extr(JIT_R1, JIT_R2, 7, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 45);
    jit_extr(JIT_R1, JIT_R2, 7, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 46);
    jit_extr(JIT_R1, JIT_R2, 7, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 47);
    jit_extr(JIT_R1, JIT_R2, 7, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 48);
    jit_extr(JIT_R1, JIT_R2, 7, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 49);
    jit_extr(JIT_R1, JIT_R2, 7, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 50);
    jit_extr(JIT_R1, JIT_R2, 7, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 51);
    jit_extr(JIT_R1, JIT_R2, 7, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 52);
    jit_extr(JIT_R1, JIT_R2, 7, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 53);
    jit_extr(JIT_R1, JIT_R2, 7, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 54);
    jit_extr(JIT_R1, JIT_R2, 7, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 55);
    jit_extr(JIT_R1, JIT_R2, 7, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 56);
    jit_extr(JIT_R1, JIT_R2, 7, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS7_57 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 57) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 7, 57);
    jit_extr(JIT_R1, JIT_R2, 7, 57);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 8 */
    nS8_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 25);
    jit_extr(JIT_R1, JIT_R2, 8, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 26);
    jit_extr(JIT_R1, JIT_R2, 8, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 27);
    jit_extr(JIT_R1, JIT_R2, 8, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 28);
    jit_extr(JIT_R1, JIT_R2, 8, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 29);
    jit_extr(JIT_R1, JIT_R2, 8, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 30);
    jit_extr(JIT_R1, JIT_R2, 8, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 31);
    jit_extr(JIT_R1, JIT_R2, 8, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 32);
    jit_extr(JIT_R1, JIT_R2, 8, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 33);
    jit_extr(JIT_R1, JIT_R2, 8, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 34);
    jit_extr(JIT_R1, JIT_R2, 8, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 35);
    jit_extr(JIT_R1, JIT_R2, 8, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 36);
    jit_extr(JIT_R1, JIT_R2, 8, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 37);
    jit_extr(JIT_R1, JIT_R2, 8, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 38);
    jit_extr(JIT_R1, JIT_R2, 8, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 39);
    jit_extr(JIT_R1, JIT_R2, 8, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 40);
    jit_extr(JIT_R1, JIT_R2, 8, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 41);
    jit_extr(JIT_R1, JIT_R2, 8, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 42);
    jit_extr(JIT_R1, JIT_R2, 8, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 43);
    jit_extr(JIT_R1, JIT_R2, 8, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 44);
    jit_extr(JIT_R1, JIT_R2, 8, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 45);
    jit_extr(JIT_R1, JIT_R2, 8, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 46);
    jit_extr(JIT_R1, JIT_R2, 8, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 47);
    jit_extr(JIT_R1, JIT_R2, 8, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 48);
    jit_extr(JIT_R1, JIT_R2, 8, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 49);
    jit_extr(JIT_R1, JIT_R2, 8, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 50);
    jit_extr(JIT_R1, JIT_R2, 8, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 51);
    jit_extr(JIT_R1, JIT_R2, 8, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 52);
    jit_extr(JIT_R1, JIT_R2, 8, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 53);
    jit_extr(JIT_R1, JIT_R2, 8, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 54);
    jit_extr(JIT_R1, JIT_R2, 8, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 55);
    jit_extr(JIT_R1, JIT_R2, 8, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS8_56 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 56) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 8, 56);
    jit_extr(JIT_R1, JIT_R2, 8, 56);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 9 */
    nS9_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 24);
    jit_extr(JIT_R1, JIT_R2, 9, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 25);
    jit_extr(JIT_R1, JIT_R2, 9, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 26);
    jit_extr(JIT_R1, JIT_R2, 9, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 27);
    jit_extr(JIT_R1, JIT_R2, 9, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 28);
    jit_extr(JIT_R1, JIT_R2, 9, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 29);
    jit_extr(JIT_R1, JIT_R2, 9, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 30);
    jit_extr(JIT_R1, JIT_R2, 9, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 31);
    jit_extr(JIT_R1, JIT_R2, 9, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 32);
    jit_extr(JIT_R1, JIT_R2, 9, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 33);
    jit_extr(JIT_R1, JIT_R2, 9, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 34);
    jit_extr(JIT_R1, JIT_R2, 9, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 35);
    jit_extr(JIT_R1, JIT_R2, 9, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 36);
    jit_extr(JIT_R1, JIT_R2, 9, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 37);
    jit_extr(JIT_R1, JIT_R2, 9, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 38);
    jit_extr(JIT_R1, JIT_R2, 9, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 39);
    jit_extr(JIT_R1, JIT_R2, 9, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 40);
    jit_extr(JIT_R1, JIT_R2, 9, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 41);
    jit_extr(JIT_R1, JIT_R2, 9, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 42);
    jit_extr(JIT_R1, JIT_R2, 9, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 43);
    jit_extr(JIT_R1, JIT_R2, 9, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 44);
    jit_extr(JIT_R1, JIT_R2, 9, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 45);
    jit_extr(JIT_R1, JIT_R2, 9, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 46);
    jit_extr(JIT_R1, JIT_R2, 9, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 47);
    jit_extr(JIT_R1, JIT_R2, 9, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 48);
    jit_extr(JIT_R1, JIT_R2, 9, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 49);
    jit_extr(JIT_R1, JIT_R2, 9, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 50);
    jit_extr(JIT_R1, JIT_R2, 9, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 51);
    jit_extr(JIT_R1, JIT_R2, 9, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 52);
    jit_extr(JIT_R1, JIT_R2, 9, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 53);
    jit_extr(JIT_R1, JIT_R2, 9, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 54);
    jit_extr(JIT_R1, JIT_R2, 9, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS9_55 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 55) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 9, 55);
    jit_extr(JIT_R1, JIT_R2, 9, 55);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 10 */
    nS10_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 23);
    jit_extr(JIT_R1, JIT_R2, 10, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 24);
    jit_extr(JIT_R1, JIT_R2, 10, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 25);
    jit_extr(JIT_R1, JIT_R2, 10, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 26);
    jit_extr(JIT_R1, JIT_R2, 10, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 27);
    jit_extr(JIT_R1, JIT_R2, 10, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 28);
    jit_extr(JIT_R1, JIT_R2, 10, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 29);
    jit_extr(JIT_R1, JIT_R2, 10, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 30);
    jit_extr(JIT_R1, JIT_R2, 10, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 31);
    jit_extr(JIT_R1, JIT_R2, 10, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 32);
    jit_extr(JIT_R1, JIT_R2, 10, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 33);
    jit_extr(JIT_R1, JIT_R2, 10, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 34);
    jit_extr(JIT_R1, JIT_R2, 10, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 35);
    jit_extr(JIT_R1, JIT_R2, 10, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 36);
    jit_extr(JIT_R1, JIT_R2, 10, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 37);
    jit_extr(JIT_R1, JIT_R2, 10, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 38);
    jit_extr(JIT_R1, JIT_R2, 10, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 39);
    jit_extr(JIT_R1, JIT_R2, 10, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 40);
    jit_extr(JIT_R1, JIT_R2, 10, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 41);
    jit_extr(JIT_R1, JIT_R2, 10, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 42);
    jit_extr(JIT_R1, JIT_R2, 10, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 43);
    jit_extr(JIT_R1, JIT_R2, 10, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 44);
    jit_extr(JIT_R1, JIT_R2, 10, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 45);
    jit_extr(JIT_R1, JIT_R2, 10, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 46);
    jit_extr(JIT_R1, JIT_R2, 10, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 47);
    jit_extr(JIT_R1, JIT_R2, 10, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 48);
    jit_extr(JIT_R1, JIT_R2, 10, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 49);
    jit_extr(JIT_R1, JIT_R2, 10, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 50);
    jit_extr(JIT_R1, JIT_R2, 10, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 51);
    jit_extr(JIT_R1, JIT_R2, 10, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 52);
    jit_extr(JIT_R1, JIT_R2, 10, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 53);
    jit_extr(JIT_R1, JIT_R2, 10, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS10_54 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 54) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 10, 54);
    jit_extr(JIT_R1, JIT_R2, 10, 54);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 11 */
    nS11_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 22);
    jit_extr(JIT_R1, JIT_R2, 11, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 23);
    jit_extr(JIT_R1, JIT_R2, 11, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 24);
    jit_extr(JIT_R1, JIT_R2, 11, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 25);
    jit_extr(JIT_R1, JIT_R2, 11, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 26);
    jit_extr(JIT_R1, JIT_R2, 11, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 27);
    jit_extr(JIT_R1, JIT_R2, 11, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 28);
    jit_extr(JIT_R1, JIT_R2, 11, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 29);
    jit_extr(JIT_R1, JIT_R2, 11, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 30);
    jit_extr(JIT_R1, JIT_R2, 11, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 31);
    jit_extr(JIT_R1, JIT_R2, 11, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 32);
    jit_extr(JIT_R1, JIT_R2, 11, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 33);
    jit_extr(JIT_R1, JIT_R2, 11, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 34);
    jit_extr(JIT_R1, JIT_R2, 11, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 35);
    jit_extr(JIT_R1, JIT_R2, 11, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 36);
    jit_extr(JIT_R1, JIT_R2, 11, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 37);
    jit_extr(JIT_R1, JIT_R2, 11, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 38);
    jit_extr(JIT_R1, JIT_R2, 11, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 39);
    jit_extr(JIT_R1, JIT_R2, 11, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 40);
    jit_extr(JIT_R1, JIT_R2, 11, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 41);
    jit_extr(JIT_R1, JIT_R2, 11, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 42);
    jit_extr(JIT_R1, JIT_R2, 11, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 43);
    jit_extr(JIT_R1, JIT_R2, 11, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 44);
    jit_extr(JIT_R1, JIT_R2, 11, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 45);
    jit_extr(JIT_R1, JIT_R2, 11, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 46);
    jit_extr(JIT_R1, JIT_R2, 11, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 47);
    jit_extr(JIT_R1, JIT_R2, 11, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 48);
    jit_extr(JIT_R1, JIT_R2, 11, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 49);
    jit_extr(JIT_R1, JIT_R2, 11, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 50);
    jit_extr(JIT_R1, JIT_R2, 11, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 51);
    jit_extr(JIT_R1, JIT_R2, 11, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 52);
    jit_extr(JIT_R1, JIT_R2, 11, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS11_53 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 53) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 11, 53);
    jit_extr(JIT_R1, JIT_R2, 11, 53);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 12 */
    nS12_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 21);
    jit_extr(JIT_R1, JIT_R2, 12, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 22);
    jit_extr(JIT_R1, JIT_R2, 12, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 23);
    jit_extr(JIT_R1, JIT_R2, 12, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 24);
    jit_extr(JIT_R1, JIT_R2, 12, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 25);
    jit_extr(JIT_R1, JIT_R2, 12, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 26);
    jit_extr(JIT_R1, JIT_R2, 12, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 27);
    jit_extr(JIT_R1, JIT_R2, 12, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 28);
    jit_extr(JIT_R1, JIT_R2, 12, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 29);
    jit_extr(JIT_R1, JIT_R2, 12, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 30);
    jit_extr(JIT_R1, JIT_R2, 12, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 31);
    jit_extr(JIT_R1, JIT_R2, 12, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 32);
    jit_extr(JIT_R1, JIT_R2, 12, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 33);
    jit_extr(JIT_R1, JIT_R2, 12, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 34);
    jit_extr(JIT_R1, JIT_R2, 12, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 35);
    jit_extr(JIT_R1, JIT_R2, 12, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 36);
    jit_extr(JIT_R1, JIT_R2, 12, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 37);
    jit_extr(JIT_R1, JIT_R2, 12, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 38);
    jit_extr(JIT_R1, JIT_R2, 12, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 39);
    jit_extr(JIT_R1, JIT_R2, 12, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 40);
    jit_extr(JIT_R1, JIT_R2, 12, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 41);
    jit_extr(JIT_R1, JIT_R2, 12, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 42);
    jit_extr(JIT_R1, JIT_R2, 12, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 43);
    jit_extr(JIT_R1, JIT_R2, 12, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 44);
    jit_extr(JIT_R1, JIT_R2, 12, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 45);
    jit_extr(JIT_R1, JIT_R2, 12, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 46);
    jit_extr(JIT_R1, JIT_R2, 12, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 47);
    jit_extr(JIT_R1, JIT_R2, 12, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 48);
    jit_extr(JIT_R1, JIT_R2, 12, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 49);
    jit_extr(JIT_R1, JIT_R2, 12, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 50);
    jit_extr(JIT_R1, JIT_R2, 12, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 51);
    jit_extr(JIT_R1, JIT_R2, 12, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS12_52 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 52) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 12, 52);
    jit_extr(JIT_R1, JIT_R2, 12, 52);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 13 */
    nS13_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 20);
    jit_extr(JIT_R1, JIT_R2, 13, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 21);
    jit_extr(JIT_R1, JIT_R2, 13, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 22);
    jit_extr(JIT_R1, JIT_R2, 13, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 23);
    jit_extr(JIT_R1, JIT_R2, 13, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 24);
    jit_extr(JIT_R1, JIT_R2, 13, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 25);
    jit_extr(JIT_R1, JIT_R2, 13, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 26);
    jit_extr(JIT_R1, JIT_R2, 13, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 27);
    jit_extr(JIT_R1, JIT_R2, 13, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 28);
    jit_extr(JIT_R1, JIT_R2, 13, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 29);
    jit_extr(JIT_R1, JIT_R2, 13, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 30);
    jit_extr(JIT_R1, JIT_R2, 13, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 31);
    jit_extr(JIT_R1, JIT_R2, 13, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 32);
    jit_extr(JIT_R1, JIT_R2, 13, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 33);
    jit_extr(JIT_R1, JIT_R2, 13, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 34);
    jit_extr(JIT_R1, JIT_R2, 13, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 35);
    jit_extr(JIT_R1, JIT_R2, 13, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 36);
    jit_extr(JIT_R1, JIT_R2, 13, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 37);
    jit_extr(JIT_R1, JIT_R2, 13, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 38);
    jit_extr(JIT_R1, JIT_R2, 13, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 39);
    jit_extr(JIT_R1, JIT_R2, 13, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 40);
    jit_extr(JIT_R1, JIT_R2, 13, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 41);
    jit_extr(JIT_R1, JIT_R2, 13, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 42);
    jit_extr(JIT_R1, JIT_R2, 13, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 43);
    jit_extr(JIT_R1, JIT_R2, 13, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 44);
    jit_extr(JIT_R1, JIT_R2, 13, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 45);
    jit_extr(JIT_R1, JIT_R2, 13, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 46);
    jit_extr(JIT_R1, JIT_R2, 13, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 47);
    jit_extr(JIT_R1, JIT_R2, 13, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 48);
    jit_extr(JIT_R1, JIT_R2, 13, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 49);
    jit_extr(JIT_R1, JIT_R2, 13, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 50);
    jit_extr(JIT_R1, JIT_R2, 13, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS13_51 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 51) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 13, 51);
    jit_extr(JIT_R1, JIT_R2, 13, 51);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 14 */
    nS14_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 19);
    jit_extr(JIT_R1, JIT_R2, 14, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 20);
    jit_extr(JIT_R1, JIT_R2, 14, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 21);
    jit_extr(JIT_R1, JIT_R2, 14, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 22);
    jit_extr(JIT_R1, JIT_R2, 14, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 23);
    jit_extr(JIT_R1, JIT_R2, 14, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 24);
    jit_extr(JIT_R1, JIT_R2, 14, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 25);
    jit_extr(JIT_R1, JIT_R2, 14, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 26);
    jit_extr(JIT_R1, JIT_R2, 14, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 27);
    jit_extr(JIT_R1, JIT_R2, 14, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 28);
    jit_extr(JIT_R1, JIT_R2, 14, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 29);
    jit_extr(JIT_R1, JIT_R2, 14, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 30);
    jit_extr(JIT_R1, JIT_R2, 14, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 31);
    jit_extr(JIT_R1, JIT_R2, 14, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 32);
    jit_extr(JIT_R1, JIT_R2, 14, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 33);
    jit_extr(JIT_R1, JIT_R2, 14, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 34);
    jit_extr(JIT_R1, JIT_R2, 14, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 35);
    jit_extr(JIT_R1, JIT_R2, 14, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 36);
    jit_extr(JIT_R1, JIT_R2, 14, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 37);
    jit_extr(JIT_R1, JIT_R2, 14, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 38);
    jit_extr(JIT_R1, JIT_R2, 14, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 39);
    jit_extr(JIT_R1, JIT_R2, 14, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 40);
    jit_extr(JIT_R1, JIT_R2, 14, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 41);
    jit_extr(JIT_R1, JIT_R2, 14, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 42);
    jit_extr(JIT_R1, JIT_R2, 14, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 43);
    jit_extr(JIT_R1, JIT_R2, 14, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 44);
    jit_extr(JIT_R1, JIT_R2, 14, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 45);
    jit_extr(JIT_R1, JIT_R2, 14, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 46);
    jit_extr(JIT_R1, JIT_R2, 14, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 47);
    jit_extr(JIT_R1, JIT_R2, 14, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 48);
    jit_extr(JIT_R1, JIT_R2, 14, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 49);
    jit_extr(JIT_R1, JIT_R2, 14, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS14_50 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 50) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 14, 50);
    jit_extr(JIT_R1, JIT_R2, 14, 50);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 15 */
    nS15_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 18);
    jit_extr(JIT_R1, JIT_R2, 15, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 19);
    jit_extr(JIT_R1, JIT_R2, 15, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 20);
    jit_extr(JIT_R1, JIT_R2, 15, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 21);
    jit_extr(JIT_R1, JIT_R2, 15, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 22);
    jit_extr(JIT_R1, JIT_R2, 15, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 23);
    jit_extr(JIT_R1, JIT_R2, 15, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 24);
    jit_extr(JIT_R1, JIT_R2, 15, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 25);
    jit_extr(JIT_R1, JIT_R2, 15, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 26);
    jit_extr(JIT_R1, JIT_R2, 15, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 27);
    jit_extr(JIT_R1, JIT_R2, 15, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 28);
    jit_extr(JIT_R1, JIT_R2, 15, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 29);
    jit_extr(JIT_R1, JIT_R2, 15, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 30);
    jit_extr(JIT_R1, JIT_R2, 15, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 31);
    jit_extr(JIT_R1, JIT_R2, 15, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 32);
    jit_extr(JIT_R1, JIT_R2, 15, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 33);
    jit_extr(JIT_R1, JIT_R2, 15, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 34);
    jit_extr(JIT_R1, JIT_R2, 15, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 35);
    jit_extr(JIT_R1, JIT_R2, 15, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 36);
    jit_extr(JIT_R1, JIT_R2, 15, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 37);
    jit_extr(JIT_R1, JIT_R2, 15, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 38);
    jit_extr(JIT_R1, JIT_R2, 15, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 39);
    jit_extr(JIT_R1, JIT_R2, 15, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 40);
    jit_extr(JIT_R1, JIT_R2, 15, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 41);
    jit_extr(JIT_R1, JIT_R2, 15, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 42);
    jit_extr(JIT_R1, JIT_R2, 15, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 43);
    jit_extr(JIT_R1, JIT_R2, 15, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 44);
    jit_extr(JIT_R1, JIT_R2, 15, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 45);
    jit_extr(JIT_R1, JIT_R2, 15, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 46);
    jit_extr(JIT_R1, JIT_R2, 15, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 47);
    jit_extr(JIT_R1, JIT_R2, 15, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 48);
    jit_extr(JIT_R1, JIT_R2, 15, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS15_49 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 49) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 15, 49);
    jit_extr(JIT_R1, JIT_R2, 15, 49);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 16 */
    nS16_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 17);
    jit_extr(JIT_R1, JIT_R2, 16, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 18);
    jit_extr(JIT_R1, JIT_R2, 16, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 19);
    jit_extr(JIT_R1, JIT_R2, 16, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 20);
    jit_extr(JIT_R1, JIT_R2, 16, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 21);
    jit_extr(JIT_R1, JIT_R2, 16, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 22);
    jit_extr(JIT_R1, JIT_R2, 16, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 23);
    jit_extr(JIT_R1, JIT_R2, 16, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 24);
    jit_extr(JIT_R1, JIT_R2, 16, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 25);
    jit_extr(JIT_R1, JIT_R2, 16, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 26);
    jit_extr(JIT_R1, JIT_R2, 16, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 27);
    jit_extr(JIT_R1, JIT_R2, 16, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 28);
    jit_extr(JIT_R1, JIT_R2, 16, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 29);
    jit_extr(JIT_R1, JIT_R2, 16, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 30);
    jit_extr(JIT_R1, JIT_R2, 16, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 31);
    jit_extr(JIT_R1, JIT_R2, 16, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 32);
    jit_extr(JIT_R1, JIT_R2, 16, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 33);
    jit_extr(JIT_R1, JIT_R2, 16, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 34);
    jit_extr(JIT_R1, JIT_R2, 16, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 35);
    jit_extr(JIT_R1, JIT_R2, 16, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 36);
    jit_extr(JIT_R1, JIT_R2, 16, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 37);
    jit_extr(JIT_R1, JIT_R2, 16, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 38);
    jit_extr(JIT_R1, JIT_R2, 16, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 39);
    jit_extr(JIT_R1, JIT_R2, 16, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 40);
    jit_extr(JIT_R1, JIT_R2, 16, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 41);
    jit_extr(JIT_R1, JIT_R2, 16, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 42);
    jit_extr(JIT_R1, JIT_R2, 16, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 43);
    jit_extr(JIT_R1, JIT_R2, 16, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 44);
    jit_extr(JIT_R1, JIT_R2, 16, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 45);
    jit_extr(JIT_R1, JIT_R2, 16, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 46);
    jit_extr(JIT_R1, JIT_R2, 16, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 47);
    jit_extr(JIT_R1, JIT_R2, 16, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS16_48 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 48) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 16, 48);
    jit_extr(JIT_R1, JIT_R2, 16, 48);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 17 */
    nS17_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 16);
    jit_extr(JIT_R1, JIT_R2, 17, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 17);
    jit_extr(JIT_R1, JIT_R2, 17, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 18);
    jit_extr(JIT_R1, JIT_R2, 17, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 19);
    jit_extr(JIT_R1, JIT_R2, 17, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 20);
    jit_extr(JIT_R1, JIT_R2, 17, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 21);
    jit_extr(JIT_R1, JIT_R2, 17, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 22);
    jit_extr(JIT_R1, JIT_R2, 17, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 23);
    jit_extr(JIT_R1, JIT_R2, 17, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 24);
    jit_extr(JIT_R1, JIT_R2, 17, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 25);
    jit_extr(JIT_R1, JIT_R2, 17, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 26);
    jit_extr(JIT_R1, JIT_R2, 17, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 27);
    jit_extr(JIT_R1, JIT_R2, 17, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 28);
    jit_extr(JIT_R1, JIT_R2, 17, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 29);
    jit_extr(JIT_R1, JIT_R2, 17, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 30);
    jit_extr(JIT_R1, JIT_R2, 17, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 31);
    jit_extr(JIT_R1, JIT_R2, 17, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 32);
    jit_extr(JIT_R1, JIT_R2, 17, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 33);
    jit_extr(JIT_R1, JIT_R2, 17, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 34);
    jit_extr(JIT_R1, JIT_R2, 17, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 35);
    jit_extr(JIT_R1, JIT_R2, 17, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 36);
    jit_extr(JIT_R1, JIT_R2, 17, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 37);
    jit_extr(JIT_R1, JIT_R2, 17, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 38);
    jit_extr(JIT_R1, JIT_R2, 17, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 39);
    jit_extr(JIT_R1, JIT_R2, 17, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 40);
    jit_extr(JIT_R1, JIT_R2, 17, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 41);
    jit_extr(JIT_R1, JIT_R2, 17, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 42);
    jit_extr(JIT_R1, JIT_R2, 17, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 43);
    jit_extr(JIT_R1, JIT_R2, 17, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 44);
    jit_extr(JIT_R1, JIT_R2, 17, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 45);
    jit_extr(JIT_R1, JIT_R2, 17, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 46);
    jit_extr(JIT_R1, JIT_R2, 17, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS17_47 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 47) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 17, 47);
    jit_extr(JIT_R1, JIT_R2, 17, 47);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 18 */
    nS18_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 15);
    jit_extr(JIT_R1, JIT_R2, 18, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 16);
    jit_extr(JIT_R1, JIT_R2, 18, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 17);
    jit_extr(JIT_R1, JIT_R2, 18, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 18);
    jit_extr(JIT_R1, JIT_R2, 18, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 19);
    jit_extr(JIT_R1, JIT_R2, 18, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 20);
    jit_extr(JIT_R1, JIT_R2, 18, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 21);
    jit_extr(JIT_R1, JIT_R2, 18, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 22);
    jit_extr(JIT_R1, JIT_R2, 18, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 23);
    jit_extr(JIT_R1, JIT_R2, 18, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 24);
    jit_extr(JIT_R1, JIT_R2, 18, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 25);
    jit_extr(JIT_R1, JIT_R2, 18, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 26);
    jit_extr(JIT_R1, JIT_R2, 18, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 27);
    jit_extr(JIT_R1, JIT_R2, 18, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 28);
    jit_extr(JIT_R1, JIT_R2, 18, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 29);
    jit_extr(JIT_R1, JIT_R2, 18, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 30);
    jit_extr(JIT_R1, JIT_R2, 18, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 31);
    jit_extr(JIT_R1, JIT_R2, 18, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 32);
    jit_extr(JIT_R1, JIT_R2, 18, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 33);
    jit_extr(JIT_R1, JIT_R2, 18, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 34);
    jit_extr(JIT_R1, JIT_R2, 18, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 35);
    jit_extr(JIT_R1, JIT_R2, 18, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 36);
    jit_extr(JIT_R1, JIT_R2, 18, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 37);
    jit_extr(JIT_R1, JIT_R2, 18, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 38);
    jit_extr(JIT_R1, JIT_R2, 18, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 39);
    jit_extr(JIT_R1, JIT_R2, 18, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 40);
    jit_extr(JIT_R1, JIT_R2, 18, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 41);
    jit_extr(JIT_R1, JIT_R2, 18, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 42);
    jit_extr(JIT_R1, JIT_R2, 18, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 43);
    jit_extr(JIT_R1, JIT_R2, 18, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 44);
    jit_extr(JIT_R1, JIT_R2, 18, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 45);
    jit_extr(JIT_R1, JIT_R2, 18, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS18_46 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 46) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 18, 46);
    jit_extr(JIT_R1, JIT_R2, 18, 46);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 19 */
    nS19_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 14);
    jit_extr(JIT_R1, JIT_R2, 19, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 15);
    jit_extr(JIT_R1, JIT_R2, 19, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 16);
    jit_extr(JIT_R1, JIT_R2, 19, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 17);
    jit_extr(JIT_R1, JIT_R2, 19, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 18);
    jit_extr(JIT_R1, JIT_R2, 19, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 19);
    jit_extr(JIT_R1, JIT_R2, 19, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 20);
    jit_extr(JIT_R1, JIT_R2, 19, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 21);
    jit_extr(JIT_R1, JIT_R2, 19, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 22);
    jit_extr(JIT_R1, JIT_R2, 19, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 23);
    jit_extr(JIT_R1, JIT_R2, 19, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 24);
    jit_extr(JIT_R1, JIT_R2, 19, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 25);
    jit_extr(JIT_R1, JIT_R2, 19, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 26);
    jit_extr(JIT_R1, JIT_R2, 19, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 27);
    jit_extr(JIT_R1, JIT_R2, 19, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 28);
    jit_extr(JIT_R1, JIT_R2, 19, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 29);
    jit_extr(JIT_R1, JIT_R2, 19, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 30);
    jit_extr(JIT_R1, JIT_R2, 19, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 31);
    jit_extr(JIT_R1, JIT_R2, 19, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 32);
    jit_extr(JIT_R1, JIT_R2, 19, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 33);
    jit_extr(JIT_R1, JIT_R2, 19, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 34);
    jit_extr(JIT_R1, JIT_R2, 19, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 35);
    jit_extr(JIT_R1, JIT_R2, 19, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 36);
    jit_extr(JIT_R1, JIT_R2, 19, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 37);
    jit_extr(JIT_R1, JIT_R2, 19, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 38);
    jit_extr(JIT_R1, JIT_R2, 19, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 39);
    jit_extr(JIT_R1, JIT_R2, 19, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 40);
    jit_extr(JIT_R1, JIT_R2, 19, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 41);
    jit_extr(JIT_R1, JIT_R2, 19, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 42);
    jit_extr(JIT_R1, JIT_R2, 19, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 43);
    jit_extr(JIT_R1, JIT_R2, 19, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 44);
    jit_extr(JIT_R1, JIT_R2, 19, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS19_45 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 45) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 19, 45);
    jit_extr(JIT_R1, JIT_R2, 19, 45);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 20 */
    nS20_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 13);
    jit_extr(JIT_R1, JIT_R2, 20, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 14);
    jit_extr(JIT_R1, JIT_R2, 20, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 15);
    jit_extr(JIT_R1, JIT_R2, 20, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 16);
    jit_extr(JIT_R1, JIT_R2, 20, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 17);
    jit_extr(JIT_R1, JIT_R2, 20, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 18);
    jit_extr(JIT_R1, JIT_R2, 20, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 19);
    jit_extr(JIT_R1, JIT_R2, 20, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 20);
    jit_extr(JIT_R1, JIT_R2, 20, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 21);
    jit_extr(JIT_R1, JIT_R2, 20, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 22);
    jit_extr(JIT_R1, JIT_R2, 20, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 23);
    jit_extr(JIT_R1, JIT_R2, 20, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 24);
    jit_extr(JIT_R1, JIT_R2, 20, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 25);
    jit_extr(JIT_R1, JIT_R2, 20, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 26);
    jit_extr(JIT_R1, JIT_R2, 20, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 27);
    jit_extr(JIT_R1, JIT_R2, 20, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 28);
    jit_extr(JIT_R1, JIT_R2, 20, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 29);
    jit_extr(JIT_R1, JIT_R2, 20, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 30);
    jit_extr(JIT_R1, JIT_R2, 20, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 31);
    jit_extr(JIT_R1, JIT_R2, 20, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 32);
    jit_extr(JIT_R1, JIT_R2, 20, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 33);
    jit_extr(JIT_R1, JIT_R2, 20, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 34);
    jit_extr(JIT_R1, JIT_R2, 20, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 35);
    jit_extr(JIT_R1, JIT_R2, 20, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 36);
    jit_extr(JIT_R1, JIT_R2, 20, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 37);
    jit_extr(JIT_R1, JIT_R2, 20, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 38);
    jit_extr(JIT_R1, JIT_R2, 20, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 39);
    jit_extr(JIT_R1, JIT_R2, 20, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 40);
    jit_extr(JIT_R1, JIT_R2, 20, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 41);
    jit_extr(JIT_R1, JIT_R2, 20, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 42);
    jit_extr(JIT_R1, JIT_R2, 20, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 43);
    jit_extr(JIT_R1, JIT_R2, 20, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS20_44 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 44) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 20, 44);
    jit_extr(JIT_R1, JIT_R2, 20, 44);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 21 */
    nS21_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 12);
    jit_extr(JIT_R1, JIT_R2, 21, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 13);
    jit_extr(JIT_R1, JIT_R2, 21, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 14);
    jit_extr(JIT_R1, JIT_R2, 21, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 15);
    jit_extr(JIT_R1, JIT_R2, 21, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 16);
    jit_extr(JIT_R1, JIT_R2, 21, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 17);
    jit_extr(JIT_R1, JIT_R2, 21, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 18);
    jit_extr(JIT_R1, JIT_R2, 21, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 19);
    jit_extr(JIT_R1, JIT_R2, 21, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 20);
    jit_extr(JIT_R1, JIT_R2, 21, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 21);
    jit_extr(JIT_R1, JIT_R2, 21, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 22);
    jit_extr(JIT_R1, JIT_R2, 21, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 23);
    jit_extr(JIT_R1, JIT_R2, 21, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 24);
    jit_extr(JIT_R1, JIT_R2, 21, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 25);
    jit_extr(JIT_R1, JIT_R2, 21, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 26);
    jit_extr(JIT_R1, JIT_R2, 21, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 27);
    jit_extr(JIT_R1, JIT_R2, 21, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 28);
    jit_extr(JIT_R1, JIT_R2, 21, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 29);
    jit_extr(JIT_R1, JIT_R2, 21, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 30);
    jit_extr(JIT_R1, JIT_R2, 21, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 31);
    jit_extr(JIT_R1, JIT_R2, 21, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 32);
    jit_extr(JIT_R1, JIT_R2, 21, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 33);
    jit_extr(JIT_R1, JIT_R2, 21, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 34);
    jit_extr(JIT_R1, JIT_R2, 21, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 35);
    jit_extr(JIT_R1, JIT_R2, 21, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 36);
    jit_extr(JIT_R1, JIT_R2, 21, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 37);
    jit_extr(JIT_R1, JIT_R2, 21, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 38);
    jit_extr(JIT_R1, JIT_R2, 21, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 39);
    jit_extr(JIT_R1, JIT_R2, 21, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 40);
    jit_extr(JIT_R1, JIT_R2, 21, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 41);
    jit_extr(JIT_R1, JIT_R2, 21, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 42);
    jit_extr(JIT_R1, JIT_R2, 21, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS21_43 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 43) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 21, 43);
    jit_extr(JIT_R1, JIT_R2, 21, 43);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 22 */
    nS22_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 11);
    jit_extr(JIT_R1, JIT_R2, 22, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 12);
    jit_extr(JIT_R1, JIT_R2, 22, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 13);
    jit_extr(JIT_R1, JIT_R2, 22, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 14);
    jit_extr(JIT_R1, JIT_R2, 22, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 15);
    jit_extr(JIT_R1, JIT_R2, 22, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 16);
    jit_extr(JIT_R1, JIT_R2, 22, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 17);
    jit_extr(JIT_R1, JIT_R2, 22, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 18);
    jit_extr(JIT_R1, JIT_R2, 22, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 19);
    jit_extr(JIT_R1, JIT_R2, 22, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 20);
    jit_extr(JIT_R1, JIT_R2, 22, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 21);
    jit_extr(JIT_R1, JIT_R2, 22, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 22);
    jit_extr(JIT_R1, JIT_R2, 22, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 23);
    jit_extr(JIT_R1, JIT_R2, 22, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 24);
    jit_extr(JIT_R1, JIT_R2, 22, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 25);
    jit_extr(JIT_R1, JIT_R2, 22, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 26);
    jit_extr(JIT_R1, JIT_R2, 22, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 27);
    jit_extr(JIT_R1, JIT_R2, 22, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 28);
    jit_extr(JIT_R1, JIT_R2, 22, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 29);
    jit_extr(JIT_R1, JIT_R2, 22, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 30);
    jit_extr(JIT_R1, JIT_R2, 22, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 31);
    jit_extr(JIT_R1, JIT_R2, 22, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 32);
    jit_extr(JIT_R1, JIT_R2, 22, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 33);
    jit_extr(JIT_R1, JIT_R2, 22, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 34);
    jit_extr(JIT_R1, JIT_R2, 22, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 35);
    jit_extr(JIT_R1, JIT_R2, 22, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 36);
    jit_extr(JIT_R1, JIT_R2, 22, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 37);
    jit_extr(JIT_R1, JIT_R2, 22, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 38);
    jit_extr(JIT_R1, JIT_R2, 22, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 39);
    jit_extr(JIT_R1, JIT_R2, 22, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 40);
    jit_extr(JIT_R1, JIT_R2, 22, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 41);
    jit_extr(JIT_R1, JIT_R2, 22, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS22_42 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 42) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 22, 42);
    jit_extr(JIT_R1, JIT_R2, 22, 42);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 23 */
    nS23_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 10);
    jit_extr(JIT_R1, JIT_R2, 23, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 11);
    jit_extr(JIT_R1, JIT_R2, 23, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 12);
    jit_extr(JIT_R1, JIT_R2, 23, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 13);
    jit_extr(JIT_R1, JIT_R2, 23, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 14);
    jit_extr(JIT_R1, JIT_R2, 23, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 15);
    jit_extr(JIT_R1, JIT_R2, 23, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 16);
    jit_extr(JIT_R1, JIT_R2, 23, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 17);
    jit_extr(JIT_R1, JIT_R2, 23, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 18);
    jit_extr(JIT_R1, JIT_R2, 23, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 19);
    jit_extr(JIT_R1, JIT_R2, 23, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 20);
    jit_extr(JIT_R1, JIT_R2, 23, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 21);
    jit_extr(JIT_R1, JIT_R2, 23, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 22);
    jit_extr(JIT_R1, JIT_R2, 23, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 23);
    jit_extr(JIT_R1, JIT_R2, 23, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 24);
    jit_extr(JIT_R1, JIT_R2, 23, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 25);
    jit_extr(JIT_R1, JIT_R2, 23, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 26);
    jit_extr(JIT_R1, JIT_R2, 23, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 27);
    jit_extr(JIT_R1, JIT_R2, 23, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 28);
    jit_extr(JIT_R1, JIT_R2, 23, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 29);
    jit_extr(JIT_R1, JIT_R2, 23, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 30);
    jit_extr(JIT_R1, JIT_R2, 23, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 31);
    jit_extr(JIT_R1, JIT_R2, 23, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 32);
    jit_extr(JIT_R1, JIT_R2, 23, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 33);
    jit_extr(JIT_R1, JIT_R2, 23, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 34);
    jit_extr(JIT_R1, JIT_R2, 23, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 35);
    jit_extr(JIT_R1, JIT_R2, 23, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 36);
    jit_extr(JIT_R1, JIT_R2, 23, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 37);
    jit_extr(JIT_R1, JIT_R2, 23, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 38);
    jit_extr(JIT_R1, JIT_R2, 23, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 39);
    jit_extr(JIT_R1, JIT_R2, 23, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 40);
    jit_extr(JIT_R1, JIT_R2, 23, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS23_41 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 41) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 23, 41);
    jit_extr(JIT_R1, JIT_R2, 23, 41);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 24 */
    nS24_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 9);
    jit_extr(JIT_R1, JIT_R2, 24, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 10);
    jit_extr(JIT_R1, JIT_R2, 24, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 11);
    jit_extr(JIT_R1, JIT_R2, 24, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 12);
    jit_extr(JIT_R1, JIT_R2, 24, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 13);
    jit_extr(JIT_R1, JIT_R2, 24, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 14);
    jit_extr(JIT_R1, JIT_R2, 24, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 15);
    jit_extr(JIT_R1, JIT_R2, 24, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 16);
    jit_extr(JIT_R1, JIT_R2, 24, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 17);
    jit_extr(JIT_R1, JIT_R2, 24, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 18);
    jit_extr(JIT_R1, JIT_R2, 24, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 19);
    jit_extr(JIT_R1, JIT_R2, 24, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 20);
    jit_extr(JIT_R1, JIT_R2, 24, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 21);
    jit_extr(JIT_R1, JIT_R2, 24, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 22);
    jit_extr(JIT_R1, JIT_R2, 24, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 23);
    jit_extr(JIT_R1, JIT_R2, 24, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 24);
    jit_extr(JIT_R1, JIT_R2, 24, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 25);
    jit_extr(JIT_R1, JIT_R2, 24, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 26);
    jit_extr(JIT_R1, JIT_R2, 24, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 27);
    jit_extr(JIT_R1, JIT_R2, 24, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 28);
    jit_extr(JIT_R1, JIT_R2, 24, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 29);
    jit_extr(JIT_R1, JIT_R2, 24, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 30);
    jit_extr(JIT_R1, JIT_R2, 24, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 31);
    jit_extr(JIT_R1, JIT_R2, 24, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 32);
    jit_extr(JIT_R1, JIT_R2, 24, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 33);
    jit_extr(JIT_R1, JIT_R2, 24, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 34);
    jit_extr(JIT_R1, JIT_R2, 24, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 35);
    jit_extr(JIT_R1, JIT_R2, 24, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 36);
    jit_extr(JIT_R1, JIT_R2, 24, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 37);
    jit_extr(JIT_R1, JIT_R2, 24, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 38);
    jit_extr(JIT_R1, JIT_R2, 24, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 39);
    jit_extr(JIT_R1, JIT_R2, 24, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS24_40 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 40) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 24, 40);
    jit_extr(JIT_R1, JIT_R2, 24, 40);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 25 */
    nS25_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 8);
    jit_extr(JIT_R1, JIT_R2, 25, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 9);
    jit_extr(JIT_R1, JIT_R2, 25, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 10);
    jit_extr(JIT_R1, JIT_R2, 25, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 11);
    jit_extr(JIT_R1, JIT_R2, 25, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 12);
    jit_extr(JIT_R1, JIT_R2, 25, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 13);
    jit_extr(JIT_R1, JIT_R2, 25, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 14);
    jit_extr(JIT_R1, JIT_R2, 25, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 15);
    jit_extr(JIT_R1, JIT_R2, 25, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 16);
    jit_extr(JIT_R1, JIT_R2, 25, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 17);
    jit_extr(JIT_R1, JIT_R2, 25, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 18);
    jit_extr(JIT_R1, JIT_R2, 25, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 19);
    jit_extr(JIT_R1, JIT_R2, 25, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 20);
    jit_extr(JIT_R1, JIT_R2, 25, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 21);
    jit_extr(JIT_R1, JIT_R2, 25, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 22);
    jit_extr(JIT_R1, JIT_R2, 25, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 23);
    jit_extr(JIT_R1, JIT_R2, 25, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 24);
    jit_extr(JIT_R1, JIT_R2, 25, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 25);
    jit_extr(JIT_R1, JIT_R2, 25, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 26);
    jit_extr(JIT_R1, JIT_R2, 25, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 27);
    jit_extr(JIT_R1, JIT_R2, 25, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 28);
    jit_extr(JIT_R1, JIT_R2, 25, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 29);
    jit_extr(JIT_R1, JIT_R2, 25, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 30);
    jit_extr(JIT_R1, JIT_R2, 25, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 31);
    jit_extr(JIT_R1, JIT_R2, 25, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 32);
    jit_extr(JIT_R1, JIT_R2, 25, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 33);
    jit_extr(JIT_R1, JIT_R2, 25, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 34);
    jit_extr(JIT_R1, JIT_R2, 25, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 35);
    jit_extr(JIT_R1, JIT_R2, 25, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 36);
    jit_extr(JIT_R1, JIT_R2, 25, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 37);
    jit_extr(JIT_R1, JIT_R2, 25, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 38);
    jit_extr(JIT_R1, JIT_R2, 25, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS25_39 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 39) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 25, 39);
    jit_extr(JIT_R1, JIT_R2, 25, 39);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 26 */
    nS26_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 7);
    jit_extr(JIT_R1, JIT_R2, 26, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 8);
    jit_extr(JIT_R1, JIT_R2, 26, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 9);
    jit_extr(JIT_R1, JIT_R2, 26, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 10);
    jit_extr(JIT_R1, JIT_R2, 26, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 11);
    jit_extr(JIT_R1, JIT_R2, 26, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 12);
    jit_extr(JIT_R1, JIT_R2, 26, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 13);
    jit_extr(JIT_R1, JIT_R2, 26, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 14);
    jit_extr(JIT_R1, JIT_R2, 26, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 15);
    jit_extr(JIT_R1, JIT_R2, 26, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 16);
    jit_extr(JIT_R1, JIT_R2, 26, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 17);
    jit_extr(JIT_R1, JIT_R2, 26, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 18);
    jit_extr(JIT_R1, JIT_R2, 26, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 19);
    jit_extr(JIT_R1, JIT_R2, 26, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 20);
    jit_extr(JIT_R1, JIT_R2, 26, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 21);
    jit_extr(JIT_R1, JIT_R2, 26, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 22);
    jit_extr(JIT_R1, JIT_R2, 26, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 23);
    jit_extr(JIT_R1, JIT_R2, 26, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 24);
    jit_extr(JIT_R1, JIT_R2, 26, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 25);
    jit_extr(JIT_R1, JIT_R2, 26, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 26);
    jit_extr(JIT_R1, JIT_R2, 26, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 27);
    jit_extr(JIT_R1, JIT_R2, 26, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 28);
    jit_extr(JIT_R1, JIT_R2, 26, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 29);
    jit_extr(JIT_R1, JIT_R2, 26, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 30);
    jit_extr(JIT_R1, JIT_R2, 26, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 31);
    jit_extr(JIT_R1, JIT_R2, 26, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 32);
    jit_extr(JIT_R1, JIT_R2, 26, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 33);
    jit_extr(JIT_R1, JIT_R2, 26, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 34);
    jit_extr(JIT_R1, JIT_R2, 26, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 35);
    jit_extr(JIT_R1, JIT_R2, 26, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 36);
    jit_extr(JIT_R1, JIT_R2, 26, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 37);
    jit_extr(JIT_R1, JIT_R2, 26, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS26_38 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 38) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 26, 38);
    jit_extr(JIT_R1, JIT_R2, 26, 38);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 27 */
    nS27_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 6);
    jit_extr(JIT_R1, JIT_R2, 27, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 7);
    jit_extr(JIT_R1, JIT_R2, 27, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 8);
    jit_extr(JIT_R1, JIT_R2, 27, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 9);
    jit_extr(JIT_R1, JIT_R2, 27, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 10);
    jit_extr(JIT_R1, JIT_R2, 27, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 11);
    jit_extr(JIT_R1, JIT_R2, 27, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 12);
    jit_extr(JIT_R1, JIT_R2, 27, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 13);
    jit_extr(JIT_R1, JIT_R2, 27, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 14);
    jit_extr(JIT_R1, JIT_R2, 27, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 15);
    jit_extr(JIT_R1, JIT_R2, 27, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 16);
    jit_extr(JIT_R1, JIT_R2, 27, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 17);
    jit_extr(JIT_R1, JIT_R2, 27, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 18);
    jit_extr(JIT_R1, JIT_R2, 27, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 19);
    jit_extr(JIT_R1, JIT_R2, 27, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 20);
    jit_extr(JIT_R1, JIT_R2, 27, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 21);
    jit_extr(JIT_R1, JIT_R2, 27, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 22);
    jit_extr(JIT_R1, JIT_R2, 27, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 23);
    jit_extr(JIT_R1, JIT_R2, 27, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 24);
    jit_extr(JIT_R1, JIT_R2, 27, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 25);
    jit_extr(JIT_R1, JIT_R2, 27, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 26);
    jit_extr(JIT_R1, JIT_R2, 27, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 27);
    jit_extr(JIT_R1, JIT_R2, 27, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 28);
    jit_extr(JIT_R1, JIT_R2, 27, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 29);
    jit_extr(JIT_R1, JIT_R2, 27, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 30);
    jit_extr(JIT_R1, JIT_R2, 27, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 31);
    jit_extr(JIT_R1, JIT_R2, 27, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 32);
    jit_extr(JIT_R1, JIT_R2, 27, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 33);
    jit_extr(JIT_R1, JIT_R2, 27, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 34);
    jit_extr(JIT_R1, JIT_R2, 27, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 35);
    jit_extr(JIT_R1, JIT_R2, 27, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 36);
    jit_extr(JIT_R1, JIT_R2, 27, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS27_37 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 37) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 27, 37);
    jit_extr(JIT_R1, JIT_R2, 27, 37);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 28 */
    nS28_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 5);
    jit_extr(JIT_R1, JIT_R2, 28, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 6);
    jit_extr(JIT_R1, JIT_R2, 28, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 7);
    jit_extr(JIT_R1, JIT_R2, 28, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 8);
    jit_extr(JIT_R1, JIT_R2, 28, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 9);
    jit_extr(JIT_R1, JIT_R2, 28, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 10);
    jit_extr(JIT_R1, JIT_R2, 28, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 11);
    jit_extr(JIT_R1, JIT_R2, 28, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 12);
    jit_extr(JIT_R1, JIT_R2, 28, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 13);
    jit_extr(JIT_R1, JIT_R2, 28, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 14);
    jit_extr(JIT_R1, JIT_R2, 28, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 15);
    jit_extr(JIT_R1, JIT_R2, 28, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 16);
    jit_extr(JIT_R1, JIT_R2, 28, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 17);
    jit_extr(JIT_R1, JIT_R2, 28, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 18);
    jit_extr(JIT_R1, JIT_R2, 28, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 19);
    jit_extr(JIT_R1, JIT_R2, 28, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 20);
    jit_extr(JIT_R1, JIT_R2, 28, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 21);
    jit_extr(JIT_R1, JIT_R2, 28, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 22);
    jit_extr(JIT_R1, JIT_R2, 28, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 23);
    jit_extr(JIT_R1, JIT_R2, 28, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 24);
    jit_extr(JIT_R1, JIT_R2, 28, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 25);
    jit_extr(JIT_R1, JIT_R2, 28, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 26);
    jit_extr(JIT_R1, JIT_R2, 28, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 27);
    jit_extr(JIT_R1, JIT_R2, 28, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 28);
    jit_extr(JIT_R1, JIT_R2, 28, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 29);
    jit_extr(JIT_R1, JIT_R2, 28, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 30);
    jit_extr(JIT_R1, JIT_R2, 28, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 31);
    jit_extr(JIT_R1, JIT_R2, 28, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 32);
    jit_extr(JIT_R1, JIT_R2, 28, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 33);
    jit_extr(JIT_R1, JIT_R2, 28, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 34);
    jit_extr(JIT_R1, JIT_R2, 28, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 35);
    jit_extr(JIT_R1, JIT_R2, 28, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS28_36 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 36) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 28, 36);
    jit_extr(JIT_R1, JIT_R2, 28, 36);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 29 */
    nS29_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 4);
    jit_extr(JIT_R1, JIT_R2, 29, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 5);
    jit_extr(JIT_R1, JIT_R2, 29, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 6);
    jit_extr(JIT_R1, JIT_R2, 29, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 7);
    jit_extr(JIT_R1, JIT_R2, 29, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 8);
    jit_extr(JIT_R1, JIT_R2, 29, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 9);
    jit_extr(JIT_R1, JIT_R2, 29, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 10);
    jit_extr(JIT_R1, JIT_R2, 29, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 11);
    jit_extr(JIT_R1, JIT_R2, 29, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 12);
    jit_extr(JIT_R1, JIT_R2, 29, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 13);
    jit_extr(JIT_R1, JIT_R2, 29, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 14);
    jit_extr(JIT_R1, JIT_R2, 29, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 15);
    jit_extr(JIT_R1, JIT_R2, 29, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 16);
    jit_extr(JIT_R1, JIT_R2, 29, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 17);
    jit_extr(JIT_R1, JIT_R2, 29, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 18);
    jit_extr(JIT_R1, JIT_R2, 29, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 19);
    jit_extr(JIT_R1, JIT_R2, 29, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 20);
    jit_extr(JIT_R1, JIT_R2, 29, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 21);
    jit_extr(JIT_R1, JIT_R2, 29, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 22);
    jit_extr(JIT_R1, JIT_R2, 29, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 23);
    jit_extr(JIT_R1, JIT_R2, 29, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 24);
    jit_extr(JIT_R1, JIT_R2, 29, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 25);
    jit_extr(JIT_R1, JIT_R2, 29, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 26);
    jit_extr(JIT_R1, JIT_R2, 29, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 27);
    jit_extr(JIT_R1, JIT_R2, 29, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 28);
    jit_extr(JIT_R1, JIT_R2, 29, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 29);
    jit_extr(JIT_R1, JIT_R2, 29, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 30);
    jit_extr(JIT_R1, JIT_R2, 29, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 31);
    jit_extr(JIT_R1, JIT_R2, 29, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 32);
    jit_extr(JIT_R1, JIT_R2, 29, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 33);
    jit_extr(JIT_R1, JIT_R2, 29, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 34);
    jit_extr(JIT_R1, JIT_R2, 29, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS29_35 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 35) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 29, 35);
    jit_extr(JIT_R1, JIT_R2, 29, 35);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 30 */
    nS30_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 3);
    jit_extr(JIT_R1, JIT_R2, 30, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 4);
    jit_extr(JIT_R1, JIT_R2, 30, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 5);
    jit_extr(JIT_R1, JIT_R2, 30, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 6);
    jit_extr(JIT_R1, JIT_R2, 30, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 7);
    jit_extr(JIT_R1, JIT_R2, 30, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 8);
    jit_extr(JIT_R1, JIT_R2, 30, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 9);
    jit_extr(JIT_R1, JIT_R2, 30, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 10);
    jit_extr(JIT_R1, JIT_R2, 30, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 11);
    jit_extr(JIT_R1, JIT_R2, 30, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 12);
    jit_extr(JIT_R1, JIT_R2, 30, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 13);
    jit_extr(JIT_R1, JIT_R2, 30, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 14);
    jit_extr(JIT_R1, JIT_R2, 30, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 15);
    jit_extr(JIT_R1, JIT_R2, 30, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 16);
    jit_extr(JIT_R1, JIT_R2, 30, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 17);
    jit_extr(JIT_R1, JIT_R2, 30, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 18);
    jit_extr(JIT_R1, JIT_R2, 30, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 19);
    jit_extr(JIT_R1, JIT_R2, 30, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 20);
    jit_extr(JIT_R1, JIT_R2, 30, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 21);
    jit_extr(JIT_R1, JIT_R2, 30, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 22);
    jit_extr(JIT_R1, JIT_R2, 30, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 23);
    jit_extr(JIT_R1, JIT_R2, 30, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 24);
    jit_extr(JIT_R1, JIT_R2, 30, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 25);
    jit_extr(JIT_R1, JIT_R2, 30, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 26);
    jit_extr(JIT_R1, JIT_R2, 30, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 27);
    jit_extr(JIT_R1, JIT_R2, 30, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 28);
    jit_extr(JIT_R1, JIT_R2, 30, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 29);
    jit_extr(JIT_R1, JIT_R2, 30, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 30);
    jit_extr(JIT_R1, JIT_R2, 30, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 31);
    jit_extr(JIT_R1, JIT_R2, 30, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 32);
    jit_extr(JIT_R1, JIT_R2, 30, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 33);
    jit_extr(JIT_R1, JIT_R2, 30, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS30_34 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 34) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 30, 34);
    jit_extr(JIT_R1, JIT_R2, 30, 34);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 31 */
    nS31_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 2);
    jit_extr(JIT_R1, JIT_R2, 31, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 3);
    jit_extr(JIT_R1, JIT_R2, 31, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 4);
    jit_extr(JIT_R1, JIT_R2, 31, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 5);
    jit_extr(JIT_R1, JIT_R2, 31, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 6);
    jit_extr(JIT_R1, JIT_R2, 31, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 7);
    jit_extr(JIT_R1, JIT_R2, 31, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 8);
    jit_extr(JIT_R1, JIT_R2, 31, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 9);
    jit_extr(JIT_R1, JIT_R2, 31, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 10);
    jit_extr(JIT_R1, JIT_R2, 31, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 11);
    jit_extr(JIT_R1, JIT_R2, 31, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 12);
    jit_extr(JIT_R1, JIT_R2, 31, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 13);
    jit_extr(JIT_R1, JIT_R2, 31, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 14);
    jit_extr(JIT_R1, JIT_R2, 31, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 15);
    jit_extr(JIT_R1, JIT_R2, 31, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 16);
    jit_extr(JIT_R1, JIT_R2, 31, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 17);
    jit_extr(JIT_R1, JIT_R2, 31, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 18);
    jit_extr(JIT_R1, JIT_R2, 31, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 19);
    jit_extr(JIT_R1, JIT_R2, 31, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 20);
    jit_extr(JIT_R1, JIT_R2, 31, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 21);
    jit_extr(JIT_R1, JIT_R2, 31, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 22);
    jit_extr(JIT_R1, JIT_R2, 31, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 23);
    jit_extr(JIT_R1, JIT_R2, 31, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 24);
    jit_extr(JIT_R1, JIT_R2, 31, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 25);
    jit_extr(JIT_R1, JIT_R2, 31, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 26);
    jit_extr(JIT_R1, JIT_R2, 31, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 27);
    jit_extr(JIT_R1, JIT_R2, 31, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 28);
    jit_extr(JIT_R1, JIT_R2, 31, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 29);
    jit_extr(JIT_R1, JIT_R2, 31, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 30);
    jit_extr(JIT_R1, JIT_R2, 31, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 31);
    jit_extr(JIT_R1, JIT_R2, 31, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 32);
    jit_extr(JIT_R1, JIT_R2, 31, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS31_33 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 33) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 31, 33);
    jit_extr(JIT_R1, JIT_R2, 31, 33);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 32 */
    nS32_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 1);
    jit_extr(JIT_R1, JIT_R2, 32, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 2);
    jit_extr(JIT_R1, JIT_R2, 32, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 3);
    jit_extr(JIT_R1, JIT_R2, 32, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 4);
    jit_extr(JIT_R1, JIT_R2, 32, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 5);
    jit_extr(JIT_R1, JIT_R2, 32, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 6);
    jit_extr(JIT_R1, JIT_R2, 32, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 7);
    jit_extr(JIT_R1, JIT_R2, 32, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 8);
    jit_extr(JIT_R1, JIT_R2, 32, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 9);
    jit_extr(JIT_R1, JIT_R2, 32, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 10);
    jit_extr(JIT_R1, JIT_R2, 32, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 11);
    jit_extr(JIT_R1, JIT_R2, 32, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 12);
    jit_extr(JIT_R1, JIT_R2, 32, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 13);
    jit_extr(JIT_R1, JIT_R2, 32, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 14);
    jit_extr(JIT_R1, JIT_R2, 32, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 15);
    jit_extr(JIT_R1, JIT_R2, 32, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 16);
    jit_extr(JIT_R1, JIT_R2, 32, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 17);
    jit_extr(JIT_R1, JIT_R2, 32, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 18);
    jit_extr(JIT_R1, JIT_R2, 32, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 19);
    jit_extr(JIT_R1, JIT_R2, 32, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 20);
    jit_extr(JIT_R1, JIT_R2, 32, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 21);
    jit_extr(JIT_R1, JIT_R2, 32, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 22);
    jit_extr(JIT_R1, JIT_R2, 32, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 23);
    jit_extr(JIT_R1, JIT_R2, 32, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 24);
    jit_extr(JIT_R1, JIT_R2, 32, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 25);
    jit_extr(JIT_R1, JIT_R2, 32, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 26);
    jit_extr(JIT_R1, JIT_R2, 32, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 27);
    jit_extr(JIT_R1, JIT_R2, 32, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 28);
    jit_extr(JIT_R1, JIT_R2, 32, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 29);
    jit_extr(JIT_R1, JIT_R2, 32, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 30);
    jit_extr(JIT_R1, JIT_R2, 32, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 31);
    jit_extr(JIT_R1, JIT_R2, 32, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS32_32 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 32) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 32, 32);
    jit_extr(JIT_R1, JIT_R2, 32, 32);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 33 */
    nS33_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 1);
    jit_extr(JIT_R1, JIT_R2, 33, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 2);
    jit_extr(JIT_R1, JIT_R2, 33, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 3);
    jit_extr(JIT_R1, JIT_R2, 33, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 4);
    jit_extr(JIT_R1, JIT_R2, 33, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 5);
    jit_extr(JIT_R1, JIT_R2, 33, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 6);
    jit_extr(JIT_R1, JIT_R2, 33, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 7);
    jit_extr(JIT_R1, JIT_R2, 33, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 8);
    jit_extr(JIT_R1, JIT_R2, 33, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 9);
    jit_extr(JIT_R1, JIT_R2, 33, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 10);
    jit_extr(JIT_R1, JIT_R2, 33, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 11);
    jit_extr(JIT_R1, JIT_R2, 33, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 12);
    jit_extr(JIT_R1, JIT_R2, 33, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 13);
    jit_extr(JIT_R1, JIT_R2, 33, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 14);
    jit_extr(JIT_R1, JIT_R2, 33, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 15);
    jit_extr(JIT_R1, JIT_R2, 33, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 16);
    jit_extr(JIT_R1, JIT_R2, 33, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 17);
    jit_extr(JIT_R1, JIT_R2, 33, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 18);
    jit_extr(JIT_R1, JIT_R2, 33, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 19);
    jit_extr(JIT_R1, JIT_R2, 33, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 20);
    jit_extr(JIT_R1, JIT_R2, 33, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 21);
    jit_extr(JIT_R1, JIT_R2, 33, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 22);
    jit_extr(JIT_R1, JIT_R2, 33, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 23);
    jit_extr(JIT_R1, JIT_R2, 33, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 24);
    jit_extr(JIT_R1, JIT_R2, 33, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 25);
    jit_extr(JIT_R1, JIT_R2, 33, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 26);
    jit_extr(JIT_R1, JIT_R2, 33, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 27);
    jit_extr(JIT_R1, JIT_R2, 33, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 28);
    jit_extr(JIT_R1, JIT_R2, 33, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 29);
    jit_extr(JIT_R1, JIT_R2, 33, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 30);
    jit_extr(JIT_R1, JIT_R2, 33, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS33_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 33, 31);
    jit_extr(JIT_R1, JIT_R2, 33, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 34 */
    nS34_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 1);
    jit_extr(JIT_R1, JIT_R2, 34, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 2);
    jit_extr(JIT_R1, JIT_R2, 34, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 3);
    jit_extr(JIT_R1, JIT_R2, 34, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 4);
    jit_extr(JIT_R1, JIT_R2, 34, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 5);
    jit_extr(JIT_R1, JIT_R2, 34, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 6);
    jit_extr(JIT_R1, JIT_R2, 34, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 7);
    jit_extr(JIT_R1, JIT_R2, 34, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 8);
    jit_extr(JIT_R1, JIT_R2, 34, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 9);
    jit_extr(JIT_R1, JIT_R2, 34, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 10);
    jit_extr(JIT_R1, JIT_R2, 34, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 11);
    jit_extr(JIT_R1, JIT_R2, 34, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 12);
    jit_extr(JIT_R1, JIT_R2, 34, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 13);
    jit_extr(JIT_R1, JIT_R2, 34, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 14);
    jit_extr(JIT_R1, JIT_R2, 34, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 15);
    jit_extr(JIT_R1, JIT_R2, 34, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 16);
    jit_extr(JIT_R1, JIT_R2, 34, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 17);
    jit_extr(JIT_R1, JIT_R2, 34, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 18);
    jit_extr(JIT_R1, JIT_R2, 34, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 19);
    jit_extr(JIT_R1, JIT_R2, 34, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 20);
    jit_extr(JIT_R1, JIT_R2, 34, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 21);
    jit_extr(JIT_R1, JIT_R2, 34, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 22);
    jit_extr(JIT_R1, JIT_R2, 34, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 23);
    jit_extr(JIT_R1, JIT_R2, 34, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 24);
    jit_extr(JIT_R1, JIT_R2, 34, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 25);
    jit_extr(JIT_R1, JIT_R2, 34, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 26);
    jit_extr(JIT_R1, JIT_R2, 34, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 27);
    jit_extr(JIT_R1, JIT_R2, 34, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 28);
    jit_extr(JIT_R1, JIT_R2, 34, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 29);
    jit_extr(JIT_R1, JIT_R2, 34, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS34_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 34, 30);
    jit_extr(JIT_R1, JIT_R2, 34, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 35 */
    nS35_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 1);
    jit_extr(JIT_R1, JIT_R2, 35, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 2);
    jit_extr(JIT_R1, JIT_R2, 35, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 3);
    jit_extr(JIT_R1, JIT_R2, 35, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 4);
    jit_extr(JIT_R1, JIT_R2, 35, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 5);
    jit_extr(JIT_R1, JIT_R2, 35, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 6);
    jit_extr(JIT_R1, JIT_R2, 35, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 7);
    jit_extr(JIT_R1, JIT_R2, 35, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 8);
    jit_extr(JIT_R1, JIT_R2, 35, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 9);
    jit_extr(JIT_R1, JIT_R2, 35, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 10);
    jit_extr(JIT_R1, JIT_R2, 35, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 11);
    jit_extr(JIT_R1, JIT_R2, 35, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 12);
    jit_extr(JIT_R1, JIT_R2, 35, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 13);
    jit_extr(JIT_R1, JIT_R2, 35, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 14);
    jit_extr(JIT_R1, JIT_R2, 35, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 15);
    jit_extr(JIT_R1, JIT_R2, 35, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 16);
    jit_extr(JIT_R1, JIT_R2, 35, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 17);
    jit_extr(JIT_R1, JIT_R2, 35, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 18);
    jit_extr(JIT_R1, JIT_R2, 35, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 19);
    jit_extr(JIT_R1, JIT_R2, 35, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 20);
    jit_extr(JIT_R1, JIT_R2, 35, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 21);
    jit_extr(JIT_R1, JIT_R2, 35, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 22);
    jit_extr(JIT_R1, JIT_R2, 35, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 23);
    jit_extr(JIT_R1, JIT_R2, 35, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 24);
    jit_extr(JIT_R1, JIT_R2, 35, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 25);
    jit_extr(JIT_R1, JIT_R2, 35, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 26);
    jit_extr(JIT_R1, JIT_R2, 35, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 27);
    jit_extr(JIT_R1, JIT_R2, 35, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 28);
    jit_extr(JIT_R1, JIT_R2, 35, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS35_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 35, 29);
    jit_extr(JIT_R1, JIT_R2, 35, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 36 */
    nS36_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 1);
    jit_extr(JIT_R1, JIT_R2, 36, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 2);
    jit_extr(JIT_R1, JIT_R2, 36, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 3);
    jit_extr(JIT_R1, JIT_R2, 36, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 4);
    jit_extr(JIT_R1, JIT_R2, 36, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 5);
    jit_extr(JIT_R1, JIT_R2, 36, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 6);
    jit_extr(JIT_R1, JIT_R2, 36, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 7);
    jit_extr(JIT_R1, JIT_R2, 36, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 8);
    jit_extr(JIT_R1, JIT_R2, 36, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 9);
    jit_extr(JIT_R1, JIT_R2, 36, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 10);
    jit_extr(JIT_R1, JIT_R2, 36, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 11);
    jit_extr(JIT_R1, JIT_R2, 36, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 12);
    jit_extr(JIT_R1, JIT_R2, 36, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 13);
    jit_extr(JIT_R1, JIT_R2, 36, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 14);
    jit_extr(JIT_R1, JIT_R2, 36, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 15);
    jit_extr(JIT_R1, JIT_R2, 36, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 16);
    jit_extr(JIT_R1, JIT_R2, 36, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 17);
    jit_extr(JIT_R1, JIT_R2, 36, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 18);
    jit_extr(JIT_R1, JIT_R2, 36, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 19);
    jit_extr(JIT_R1, JIT_R2, 36, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 20);
    jit_extr(JIT_R1, JIT_R2, 36, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 21);
    jit_extr(JIT_R1, JIT_R2, 36, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 22);
    jit_extr(JIT_R1, JIT_R2, 36, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 23);
    jit_extr(JIT_R1, JIT_R2, 36, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 24);
    jit_extr(JIT_R1, JIT_R2, 36, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 25);
    jit_extr(JIT_R1, JIT_R2, 36, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 26);
    jit_extr(JIT_R1, JIT_R2, 36, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 27);
    jit_extr(JIT_R1, JIT_R2, 36, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS36_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 36, 28);
    jit_extr(JIT_R1, JIT_R2, 36, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 37 */
    nS37_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 1);
    jit_extr(JIT_R1, JIT_R2, 37, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 2);
    jit_extr(JIT_R1, JIT_R2, 37, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 3);
    jit_extr(JIT_R1, JIT_R2, 37, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 4);
    jit_extr(JIT_R1, JIT_R2, 37, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 5);
    jit_extr(JIT_R1, JIT_R2, 37, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 6);
    jit_extr(JIT_R1, JIT_R2, 37, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 7);
    jit_extr(JIT_R1, JIT_R2, 37, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 8);
    jit_extr(JIT_R1, JIT_R2, 37, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 9);
    jit_extr(JIT_R1, JIT_R2, 37, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 10);
    jit_extr(JIT_R1, JIT_R2, 37, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 11);
    jit_extr(JIT_R1, JIT_R2, 37, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 12);
    jit_extr(JIT_R1, JIT_R2, 37, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 13);
    jit_extr(JIT_R1, JIT_R2, 37, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 14);
    jit_extr(JIT_R1, JIT_R2, 37, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 15);
    jit_extr(JIT_R1, JIT_R2, 37, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 16);
    jit_extr(JIT_R1, JIT_R2, 37, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 17);
    jit_extr(JIT_R1, JIT_R2, 37, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 18);
    jit_extr(JIT_R1, JIT_R2, 37, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 19);
    jit_extr(JIT_R1, JIT_R2, 37, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 20);
    jit_extr(JIT_R1, JIT_R2, 37, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 21);
    jit_extr(JIT_R1, JIT_R2, 37, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 22);
    jit_extr(JIT_R1, JIT_R2, 37, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 23);
    jit_extr(JIT_R1, JIT_R2, 37, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 24);
    jit_extr(JIT_R1, JIT_R2, 37, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 25);
    jit_extr(JIT_R1, JIT_R2, 37, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 26);
    jit_extr(JIT_R1, JIT_R2, 37, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS37_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 37, 27);
    jit_extr(JIT_R1, JIT_R2, 37, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 38 */
    nS38_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 1);
    jit_extr(JIT_R1, JIT_R2, 38, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 2);
    jit_extr(JIT_R1, JIT_R2, 38, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 3);
    jit_extr(JIT_R1, JIT_R2, 38, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 4);
    jit_extr(JIT_R1, JIT_R2, 38, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 5);
    jit_extr(JIT_R1, JIT_R2, 38, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 6);
    jit_extr(JIT_R1, JIT_R2, 38, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 7);
    jit_extr(JIT_R1, JIT_R2, 38, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 8);
    jit_extr(JIT_R1, JIT_R2, 38, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 9);
    jit_extr(JIT_R1, JIT_R2, 38, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 10);
    jit_extr(JIT_R1, JIT_R2, 38, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 11);
    jit_extr(JIT_R1, JIT_R2, 38, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 12);
    jit_extr(JIT_R1, JIT_R2, 38, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 13);
    jit_extr(JIT_R1, JIT_R2, 38, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 14);
    jit_extr(JIT_R1, JIT_R2, 38, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 15);
    jit_extr(JIT_R1, JIT_R2, 38, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 16);
    jit_extr(JIT_R1, JIT_R2, 38, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 17);
    jit_extr(JIT_R1, JIT_R2, 38, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 18);
    jit_extr(JIT_R1, JIT_R2, 38, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 19);
    jit_extr(JIT_R1, JIT_R2, 38, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 20);
    jit_extr(JIT_R1, JIT_R2, 38, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 21);
    jit_extr(JIT_R1, JIT_R2, 38, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 22);
    jit_extr(JIT_R1, JIT_R2, 38, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 23);
    jit_extr(JIT_R1, JIT_R2, 38, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 24);
    jit_extr(JIT_R1, JIT_R2, 38, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 25);
    jit_extr(JIT_R1, JIT_R2, 38, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS38_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 38, 26);
    jit_extr(JIT_R1, JIT_R2, 38, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 39 */
    nS39_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 1);
    jit_extr(JIT_R1, JIT_R2, 39, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 2);
    jit_extr(JIT_R1, JIT_R2, 39, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 3);
    jit_extr(JIT_R1, JIT_R2, 39, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 4);
    jit_extr(JIT_R1, JIT_R2, 39, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 5);
    jit_extr(JIT_R1, JIT_R2, 39, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 6);
    jit_extr(JIT_R1, JIT_R2, 39, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 7);
    jit_extr(JIT_R1, JIT_R2, 39, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 8);
    jit_extr(JIT_R1, JIT_R2, 39, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 9);
    jit_extr(JIT_R1, JIT_R2, 39, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 10);
    jit_extr(JIT_R1, JIT_R2, 39, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 11);
    jit_extr(JIT_R1, JIT_R2, 39, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 12);
    jit_extr(JIT_R1, JIT_R2, 39, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 13);
    jit_extr(JIT_R1, JIT_R2, 39, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 14);
    jit_extr(JIT_R1, JIT_R2, 39, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 15);
    jit_extr(JIT_R1, JIT_R2, 39, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 16);
    jit_extr(JIT_R1, JIT_R2, 39, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 17);
    jit_extr(JIT_R1, JIT_R2, 39, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 18);
    jit_extr(JIT_R1, JIT_R2, 39, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 19);
    jit_extr(JIT_R1, JIT_R2, 39, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 20);
    jit_extr(JIT_R1, JIT_R2, 39, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 21);
    jit_extr(JIT_R1, JIT_R2, 39, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 22);
    jit_extr(JIT_R1, JIT_R2, 39, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 23);
    jit_extr(JIT_R1, JIT_R2, 39, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 24);
    jit_extr(JIT_R1, JIT_R2, 39, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS39_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 39, 25);
    jit_extr(JIT_R1, JIT_R2, 39, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 40 */
    nS40_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 1);
    jit_extr(JIT_R1, JIT_R2, 40, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 2);
    jit_extr(JIT_R1, JIT_R2, 40, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 3);
    jit_extr(JIT_R1, JIT_R2, 40, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 4);
    jit_extr(JIT_R1, JIT_R2, 40, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 5);
    jit_extr(JIT_R1, JIT_R2, 40, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 6);
    jit_extr(JIT_R1, JIT_R2, 40, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 7);
    jit_extr(JIT_R1, JIT_R2, 40, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 8);
    jit_extr(JIT_R1, JIT_R2, 40, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 9);
    jit_extr(JIT_R1, JIT_R2, 40, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 10);
    jit_extr(JIT_R1, JIT_R2, 40, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 11);
    jit_extr(JIT_R1, JIT_R2, 40, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 12);
    jit_extr(JIT_R1, JIT_R2, 40, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 13);
    jit_extr(JIT_R1, JIT_R2, 40, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 14);
    jit_extr(JIT_R1, JIT_R2, 40, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 15);
    jit_extr(JIT_R1, JIT_R2, 40, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 16);
    jit_extr(JIT_R1, JIT_R2, 40, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 17);
    jit_extr(JIT_R1, JIT_R2, 40, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 18);
    jit_extr(JIT_R1, JIT_R2, 40, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 19);
    jit_extr(JIT_R1, JIT_R2, 40, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 20);
    jit_extr(JIT_R1, JIT_R2, 40, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 21);
    jit_extr(JIT_R1, JIT_R2, 40, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 22);
    jit_extr(JIT_R1, JIT_R2, 40, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 23);
    jit_extr(JIT_R1, JIT_R2, 40, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS40_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 40, 24);
    jit_extr(JIT_R1, JIT_R2, 40, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 41 */
    nS41_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 1);
    jit_extr(JIT_R1, JIT_R2, 41, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 2);
    jit_extr(JIT_R1, JIT_R2, 41, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 3);
    jit_extr(JIT_R1, JIT_R2, 41, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 4);
    jit_extr(JIT_R1, JIT_R2, 41, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 5);
    jit_extr(JIT_R1, JIT_R2, 41, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 6);
    jit_extr(JIT_R1, JIT_R2, 41, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 7);
    jit_extr(JIT_R1, JIT_R2, 41, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 8);
    jit_extr(JIT_R1, JIT_R2, 41, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 9);
    jit_extr(JIT_R1, JIT_R2, 41, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 10);
    jit_extr(JIT_R1, JIT_R2, 41, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 11);
    jit_extr(JIT_R1, JIT_R2, 41, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 12);
    jit_extr(JIT_R1, JIT_R2, 41, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 13);
    jit_extr(JIT_R1, JIT_R2, 41, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 14);
    jit_extr(JIT_R1, JIT_R2, 41, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 15);
    jit_extr(JIT_R1, JIT_R2, 41, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 16);
    jit_extr(JIT_R1, JIT_R2, 41, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 17);
    jit_extr(JIT_R1, JIT_R2, 41, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 18);
    jit_extr(JIT_R1, JIT_R2, 41, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 19);
    jit_extr(JIT_R1, JIT_R2, 41, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 20);
    jit_extr(JIT_R1, JIT_R2, 41, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 21);
    jit_extr(JIT_R1, JIT_R2, 41, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 22);
    jit_extr(JIT_R1, JIT_R2, 41, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS41_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 41, 23);
    jit_extr(JIT_R1, JIT_R2, 41, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 42 */
    nS42_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 1);
    jit_extr(JIT_R1, JIT_R2, 42, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 2);
    jit_extr(JIT_R1, JIT_R2, 42, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 3);
    jit_extr(JIT_R1, JIT_R2, 42, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 4);
    jit_extr(JIT_R1, JIT_R2, 42, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 5);
    jit_extr(JIT_R1, JIT_R2, 42, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 6);
    jit_extr(JIT_R1, JIT_R2, 42, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 7);
    jit_extr(JIT_R1, JIT_R2, 42, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 8);
    jit_extr(JIT_R1, JIT_R2, 42, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 9);
    jit_extr(JIT_R1, JIT_R2, 42, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 10);
    jit_extr(JIT_R1, JIT_R2, 42, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 11);
    jit_extr(JIT_R1, JIT_R2, 42, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 12);
    jit_extr(JIT_R1, JIT_R2, 42, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 13);
    jit_extr(JIT_R1, JIT_R2, 42, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 14);
    jit_extr(JIT_R1, JIT_R2, 42, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 15);
    jit_extr(JIT_R1, JIT_R2, 42, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 16);
    jit_extr(JIT_R1, JIT_R2, 42, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 17);
    jit_extr(JIT_R1, JIT_R2, 42, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 18);
    jit_extr(JIT_R1, JIT_R2, 42, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 19);
    jit_extr(JIT_R1, JIT_R2, 42, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 20);
    jit_extr(JIT_R1, JIT_R2, 42, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 21);
    jit_extr(JIT_R1, JIT_R2, 42, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS42_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 42, 22);
    jit_extr(JIT_R1, JIT_R2, 42, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 43 */
    nS43_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 1);
    jit_extr(JIT_R1, JIT_R2, 43, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 2);
    jit_extr(JIT_R1, JIT_R2, 43, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 3);
    jit_extr(JIT_R1, JIT_R2, 43, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 4);
    jit_extr(JIT_R1, JIT_R2, 43, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 5);
    jit_extr(JIT_R1, JIT_R2, 43, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 6);
    jit_extr(JIT_R1, JIT_R2, 43, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 7);
    jit_extr(JIT_R1, JIT_R2, 43, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 8);
    jit_extr(JIT_R1, JIT_R2, 43, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 9);
    jit_extr(JIT_R1, JIT_R2, 43, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 10);
    jit_extr(JIT_R1, JIT_R2, 43, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 11);
    jit_extr(JIT_R1, JIT_R2, 43, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 12);
    jit_extr(JIT_R1, JIT_R2, 43, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 13);
    jit_extr(JIT_R1, JIT_R2, 43, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 14);
    jit_extr(JIT_R1, JIT_R2, 43, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 15);
    jit_extr(JIT_R1, JIT_R2, 43, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 16);
    jit_extr(JIT_R1, JIT_R2, 43, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 17);
    jit_extr(JIT_R1, JIT_R2, 43, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 18);
    jit_extr(JIT_R1, JIT_R2, 43, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 19);
    jit_extr(JIT_R1, JIT_R2, 43, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 20);
    jit_extr(JIT_R1, JIT_R2, 43, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS43_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 43, 21);
    jit_extr(JIT_R1, JIT_R2, 43, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 44 */
    nS44_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 1);
    jit_extr(JIT_R1, JIT_R2, 44, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 2);
    jit_extr(JIT_R1, JIT_R2, 44, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 3);
    jit_extr(JIT_R1, JIT_R2, 44, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 4);
    jit_extr(JIT_R1, JIT_R2, 44, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 5);
    jit_extr(JIT_R1, JIT_R2, 44, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 6);
    jit_extr(JIT_R1, JIT_R2, 44, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 7);
    jit_extr(JIT_R1, JIT_R2, 44, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 8);
    jit_extr(JIT_R1, JIT_R2, 44, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 9);
    jit_extr(JIT_R1, JIT_R2, 44, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 10);
    jit_extr(JIT_R1, JIT_R2, 44, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 11);
    jit_extr(JIT_R1, JIT_R2, 44, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 12);
    jit_extr(JIT_R1, JIT_R2, 44, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 13);
    jit_extr(JIT_R1, JIT_R2, 44, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 14);
    jit_extr(JIT_R1, JIT_R2, 44, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 15);
    jit_extr(JIT_R1, JIT_R2, 44, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 16);
    jit_extr(JIT_R1, JIT_R2, 44, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 17);
    jit_extr(JIT_R1, JIT_R2, 44, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 18);
    jit_extr(JIT_R1, JIT_R2, 44, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 19);
    jit_extr(JIT_R1, JIT_R2, 44, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS44_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 44, 20);
    jit_extr(JIT_R1, JIT_R2, 44, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 45 */
    nS45_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 1);
    jit_extr(JIT_R1, JIT_R2, 45, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 2);
    jit_extr(JIT_R1, JIT_R2, 45, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 3);
    jit_extr(JIT_R1, JIT_R2, 45, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 4);
    jit_extr(JIT_R1, JIT_R2, 45, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 5);
    jit_extr(JIT_R1, JIT_R2, 45, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 6);
    jit_extr(JIT_R1, JIT_R2, 45, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 7);
    jit_extr(JIT_R1, JIT_R2, 45, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 8);
    jit_extr(JIT_R1, JIT_R2, 45, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 9);
    jit_extr(JIT_R1, JIT_R2, 45, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 10);
    jit_extr(JIT_R1, JIT_R2, 45, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 11);
    jit_extr(JIT_R1, JIT_R2, 45, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 12);
    jit_extr(JIT_R1, JIT_R2, 45, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 13);
    jit_extr(JIT_R1, JIT_R2, 45, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 14);
    jit_extr(JIT_R1, JIT_R2, 45, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 15);
    jit_extr(JIT_R1, JIT_R2, 45, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 16);
    jit_extr(JIT_R1, JIT_R2, 45, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 17);
    jit_extr(JIT_R1, JIT_R2, 45, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 18);
    jit_extr(JIT_R1, JIT_R2, 45, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS45_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 45, 19);
    jit_extr(JIT_R1, JIT_R2, 45, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 46 */
    nS46_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 1);
    jit_extr(JIT_R1, JIT_R2, 46, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 2);
    jit_extr(JIT_R1, JIT_R2, 46, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 3);
    jit_extr(JIT_R1, JIT_R2, 46, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 4);
    jit_extr(JIT_R1, JIT_R2, 46, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 5);
    jit_extr(JIT_R1, JIT_R2, 46, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 6);
    jit_extr(JIT_R1, JIT_R2, 46, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 7);
    jit_extr(JIT_R1, JIT_R2, 46, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 8);
    jit_extr(JIT_R1, JIT_R2, 46, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 9);
    jit_extr(JIT_R1, JIT_R2, 46, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 10);
    jit_extr(JIT_R1, JIT_R2, 46, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 11);
    jit_extr(JIT_R1, JIT_R2, 46, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 12);
    jit_extr(JIT_R1, JIT_R2, 46, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 13);
    jit_extr(JIT_R1, JIT_R2, 46, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 14);
    jit_extr(JIT_R1, JIT_R2, 46, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 15);
    jit_extr(JIT_R1, JIT_R2, 46, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 16);
    jit_extr(JIT_R1, JIT_R2, 46, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 17);
    jit_extr(JIT_R1, JIT_R2, 46, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS46_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 46, 18);
    jit_extr(JIT_R1, JIT_R2, 46, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 47 */
    nS47_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 1);
    jit_extr(JIT_R1, JIT_R2, 47, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 2);
    jit_extr(JIT_R1, JIT_R2, 47, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 3);
    jit_extr(JIT_R1, JIT_R2, 47, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 4);
    jit_extr(JIT_R1, JIT_R2, 47, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 5);
    jit_extr(JIT_R1, JIT_R2, 47, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 6);
    jit_extr(JIT_R1, JIT_R2, 47, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 7);
    jit_extr(JIT_R1, JIT_R2, 47, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 8);
    jit_extr(JIT_R1, JIT_R2, 47, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 9);
    jit_extr(JIT_R1, JIT_R2, 47, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 10);
    jit_extr(JIT_R1, JIT_R2, 47, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 11);
    jit_extr(JIT_R1, JIT_R2, 47, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 12);
    jit_extr(JIT_R1, JIT_R2, 47, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 13);
    jit_extr(JIT_R1, JIT_R2, 47, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 14);
    jit_extr(JIT_R1, JIT_R2, 47, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 15);
    jit_extr(JIT_R1, JIT_R2, 47, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 16);
    jit_extr(JIT_R1, JIT_R2, 47, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS47_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 47, 17);
    jit_extr(JIT_R1, JIT_R2, 47, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 48 */
    nS48_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 1);
    jit_extr(JIT_R1, JIT_R2, 48, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 2);
    jit_extr(JIT_R1, JIT_R2, 48, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 3);
    jit_extr(JIT_R1, JIT_R2, 48, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 4);
    jit_extr(JIT_R1, JIT_R2, 48, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 5);
    jit_extr(JIT_R1, JIT_R2, 48, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 6);
    jit_extr(JIT_R1, JIT_R2, 48, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 7);
    jit_extr(JIT_R1, JIT_R2, 48, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 8);
    jit_extr(JIT_R1, JIT_R2, 48, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 9);
    jit_extr(JIT_R1, JIT_R2, 48, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 10);
    jit_extr(JIT_R1, JIT_R2, 48, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 11);
    jit_extr(JIT_R1, JIT_R2, 48, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 12);
    jit_extr(JIT_R1, JIT_R2, 48, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 13);
    jit_extr(JIT_R1, JIT_R2, 48, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 14);
    jit_extr(JIT_R1, JIT_R2, 48, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 15);
    jit_extr(JIT_R1, JIT_R2, 48, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS48_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 48, 16);
    jit_extr(JIT_R1, JIT_R2, 48, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 49 */
    nS49_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 1);
    jit_extr(JIT_R1, JIT_R2, 49, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 2);
    jit_extr(JIT_R1, JIT_R2, 49, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 3);
    jit_extr(JIT_R1, JIT_R2, 49, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 4);
    jit_extr(JIT_R1, JIT_R2, 49, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 5);
    jit_extr(JIT_R1, JIT_R2, 49, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 6);
    jit_extr(JIT_R1, JIT_R2, 49, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 7);
    jit_extr(JIT_R1, JIT_R2, 49, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 8);
    jit_extr(JIT_R1, JIT_R2, 49, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 9);
    jit_extr(JIT_R1, JIT_R2, 49, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 10);
    jit_extr(JIT_R1, JIT_R2, 49, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 11);
    jit_extr(JIT_R1, JIT_R2, 49, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 12);
    jit_extr(JIT_R1, JIT_R2, 49, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 13);
    jit_extr(JIT_R1, JIT_R2, 49, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 14);
    jit_extr(JIT_R1, JIT_R2, 49, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS49_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 49, 15);
    jit_extr(JIT_R1, JIT_R2, 49, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 50 */
    nS50_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 1);
    jit_extr(JIT_R1, JIT_R2, 50, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 2);
    jit_extr(JIT_R1, JIT_R2, 50, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 3);
    jit_extr(JIT_R1, JIT_R2, 50, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 4);
    jit_extr(JIT_R1, JIT_R2, 50, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 5);
    jit_extr(JIT_R1, JIT_R2, 50, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 6);
    jit_extr(JIT_R1, JIT_R2, 50, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 7);
    jit_extr(JIT_R1, JIT_R2, 50, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 8);
    jit_extr(JIT_R1, JIT_R2, 50, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 9);
    jit_extr(JIT_R1, JIT_R2, 50, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 10);
    jit_extr(JIT_R1, JIT_R2, 50, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 11);
    jit_extr(JIT_R1, JIT_R2, 50, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 12);
    jit_extr(JIT_R1, JIT_R2, 50, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 13);
    jit_extr(JIT_R1, JIT_R2, 50, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS50_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 50, 14);
    jit_extr(JIT_R1, JIT_R2, 50, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 51 */
    nS51_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 1);
    jit_extr(JIT_R1, JIT_R2, 51, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 2);
    jit_extr(JIT_R1, JIT_R2, 51, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 3);
    jit_extr(JIT_R1, JIT_R2, 51, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 4);
    jit_extr(JIT_R1, JIT_R2, 51, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 5);
    jit_extr(JIT_R1, JIT_R2, 51, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 6);
    jit_extr(JIT_R1, JIT_R2, 51, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 7);
    jit_extr(JIT_R1, JIT_R2, 51, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 8);
    jit_extr(JIT_R1, JIT_R2, 51, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 9);
    jit_extr(JIT_R1, JIT_R2, 51, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 10);
    jit_extr(JIT_R1, JIT_R2, 51, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 11);
    jit_extr(JIT_R1, JIT_R2, 51, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 12);
    jit_extr(JIT_R1, JIT_R2, 51, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS51_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 51, 13);
    jit_extr(JIT_R1, JIT_R2, 51, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 52 */
    nS52_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 1);
    jit_extr(JIT_R1, JIT_R2, 52, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 2);
    jit_extr(JIT_R1, JIT_R2, 52, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 3);
    jit_extr(JIT_R1, JIT_R2, 52, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 4);
    jit_extr(JIT_R1, JIT_R2, 52, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 5);
    jit_extr(JIT_R1, JIT_R2, 52, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 6);
    jit_extr(JIT_R1, JIT_R2, 52, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 7);
    jit_extr(JIT_R1, JIT_R2, 52, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 8);
    jit_extr(JIT_R1, JIT_R2, 52, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 9);
    jit_extr(JIT_R1, JIT_R2, 52, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 10);
    jit_extr(JIT_R1, JIT_R2, 52, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 11);
    jit_extr(JIT_R1, JIT_R2, 52, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS52_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 52, 12);
    jit_extr(JIT_R1, JIT_R2, 52, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 53 */
    nS53_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 1);
    jit_extr(JIT_R1, JIT_R2, 53, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 2);
    jit_extr(JIT_R1, JIT_R2, 53, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 3);
    jit_extr(JIT_R1, JIT_R2, 53, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 4);
    jit_extr(JIT_R1, JIT_R2, 53, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 5);
    jit_extr(JIT_R1, JIT_R2, 53, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 6);
    jit_extr(JIT_R1, JIT_R2, 53, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 7);
    jit_extr(JIT_R1, JIT_R2, 53, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 8);
    jit_extr(JIT_R1, JIT_R2, 53, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 9);
    jit_extr(JIT_R1, JIT_R2, 53, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 10);
    jit_extr(JIT_R1, JIT_R2, 53, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS53_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 53, 11);
    jit_extr(JIT_R1, JIT_R2, 53, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 54 */
    nS54_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 1);
    jit_extr(JIT_R1, JIT_R2, 54, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 2);
    jit_extr(JIT_R1, JIT_R2, 54, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 3);
    jit_extr(JIT_R1, JIT_R2, 54, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 4);
    jit_extr(JIT_R1, JIT_R2, 54, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 5);
    jit_extr(JIT_R1, JIT_R2, 54, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 6);
    jit_extr(JIT_R1, JIT_R2, 54, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 7);
    jit_extr(JIT_R1, JIT_R2, 54, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 8);
    jit_extr(JIT_R1, JIT_R2, 54, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 9);
    jit_extr(JIT_R1, JIT_R2, 54, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS54_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 54, 10);
    jit_extr(JIT_R1, JIT_R2, 54, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 55 */
    nS55_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 55, 1);
    jit_extr(JIT_R1, JIT_R2, 55, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS55_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 55, 2);
    jit_extr(JIT_R1, JIT_R2, 55, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS55_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 55, 3);
    jit_extr(JIT_R1, JIT_R2, 55, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS55_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 55, 4);
    jit_extr(JIT_R1, JIT_R2, 55, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS55_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 55, 5);
    jit_extr(JIT_R1, JIT_R2, 55, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS55_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 55, 6);
    jit_extr(JIT_R1, JIT_R2, 55, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS55_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 55, 7);
    jit_extr(JIT_R1, JIT_R2, 55, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS55_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 55, 8);
    jit_extr(JIT_R1, JIT_R2, 55, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS55_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 55, 9);
    jit_extr(JIT_R1, JIT_R2, 55, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 56 */
    nS56_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 56, 1);
    jit_extr(JIT_R1, JIT_R2, 56, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS56_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 56, 2);
    jit_extr(JIT_R1, JIT_R2, 56, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS56_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 56, 3);
    jit_extr(JIT_R1, JIT_R2, 56, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS56_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 56, 4);
    jit_extr(JIT_R1, JIT_R2, 56, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS56_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 56, 5);
    jit_extr(JIT_R1, JIT_R2, 56, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS56_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 56, 6);
    jit_extr(JIT_R1, JIT_R2, 56, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS56_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 56, 7);
    jit_extr(JIT_R1, JIT_R2, 56, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS56_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 56, 8);
    jit_extr(JIT_R1, JIT_R2, 56, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 57 */
    nS57_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 57, 1);
    jit_extr(JIT_R1, JIT_R2, 57, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS57_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 57, 2);
    jit_extr(JIT_R1, JIT_R2, 57, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS57_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 57, 3);
    jit_extr(JIT_R1, JIT_R2, 57, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS57_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 57, 4);
    jit_extr(JIT_R1, JIT_R2, 57, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS57_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 57, 5);
    jit_extr(JIT_R1, JIT_R2, 57, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS57_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 57, 6);
    jit_extr(JIT_R1, JIT_R2, 57, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS57_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 57, 7);
    jit_extr(JIT_R1, JIT_R2, 57, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 58 */
    nS58_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 58, 1);
    jit_extr(JIT_R1, JIT_R2, 58, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS58_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 58, 2);
    jit_extr(JIT_R1, JIT_R2, 58, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS58_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 58, 3);
    jit_extr(JIT_R1, JIT_R2, 58, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS58_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 58, 4);
    jit_extr(JIT_R1, JIT_R2, 58, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS58_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 58, 5);
    jit_extr(JIT_R1, JIT_R2, 58, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS58_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 58, 6);
    jit_extr(JIT_R1, JIT_R2, 58, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 59 */
    nS59_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 59, 1);
    jit_extr(JIT_R1, JIT_R2, 59, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS59_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 59, 2);
    jit_extr(JIT_R1, JIT_R2, 59, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS59_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 59, 3);
    jit_extr(JIT_R1, JIT_R2, 59, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS59_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 59, 4);
    jit_extr(JIT_R1, JIT_R2, 59, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS59_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 59, 5);
    jit_extr(JIT_R1, JIT_R2, 59, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 60 */
    nS60_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 60, 1);
    jit_extr(JIT_R1, JIT_R2, 60, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS60_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 60, 2);
    jit_extr(JIT_R1, JIT_R2, 60, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS60_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 60, 3);
    jit_extr(JIT_R1, JIT_R2, 60, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS60_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 60, 4);
    jit_extr(JIT_R1, JIT_R2, 60, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 61 */
    nS61_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 61, 1);
    jit_extr(JIT_R1, JIT_R2, 61, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS61_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 61, 2);
    jit_extr(JIT_R1, JIT_R2, 61, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS61_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 61, 3);
    jit_extr(JIT_R1, JIT_R2, 61, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 62 */
    nS62_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 62, 1);
    jit_extr(JIT_R1, JIT_R2, 62, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nS62_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 62, 2);
    jit_extr(JIT_R1, JIT_R2, 62, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Declare jit functions for signed bitfields at offset 63 */
    nS63_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 63, 1);
    jit_extr(JIT_R1, JIT_R2, 63, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
#endif
    /* Define jit functions for unsigned bitfields at offset 1 */
    nU1_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 1);
    jit_extr_u(JIT_R1, JIT_R2, 1, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 2);
    jit_extr_u(JIT_R1, JIT_R2, 1, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 3);
    jit_extr_u(JIT_R1, JIT_R2, 1, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 4);
    jit_extr_u(JIT_R1, JIT_R2, 1, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 5);
    jit_extr_u(JIT_R1, JIT_R2, 1, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 6);
    jit_extr_u(JIT_R1, JIT_R2, 1, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 7);
    jit_extr_u(JIT_R1, JIT_R2, 1, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 8);
    jit_extr_u(JIT_R1, JIT_R2, 1, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 9);
    jit_extr_u(JIT_R1, JIT_R2, 1, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 10);
    jit_extr_u(JIT_R1, JIT_R2, 1, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 11);
    jit_extr_u(JIT_R1, JIT_R2, 1, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 12);
    jit_extr_u(JIT_R1, JIT_R2, 1, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 13);
    jit_extr_u(JIT_R1, JIT_R2, 1, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 14);
    jit_extr_u(JIT_R1, JIT_R2, 1, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 15);
    jit_extr_u(JIT_R1, JIT_R2, 1, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 16);
    jit_extr_u(JIT_R1, JIT_R2, 1, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 17);
    jit_extr_u(JIT_R1, JIT_R2, 1, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 18);
    jit_extr_u(JIT_R1, JIT_R2, 1, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 19);
    jit_extr_u(JIT_R1, JIT_R2, 1, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 20);
    jit_extr_u(JIT_R1, JIT_R2, 1, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 21);
    jit_extr_u(JIT_R1, JIT_R2, 1, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 22);
    jit_extr_u(JIT_R1, JIT_R2, 1, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 23);
    jit_extr_u(JIT_R1, JIT_R2, 1, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 24);
    jit_extr_u(JIT_R1, JIT_R2, 1, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 25);
    jit_extr_u(JIT_R1, JIT_R2, 1, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 26);
    jit_extr_u(JIT_R1, JIT_R2, 1, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 27);
    jit_extr_u(JIT_R1, JIT_R2, 1, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 28);
    jit_extr_u(JIT_R1, JIT_R2, 1, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 29);
    jit_extr_u(JIT_R1, JIT_R2, 1, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 30);
    jit_extr_u(JIT_R1, JIT_R2, 1, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU1_31 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 31) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 1, 31);
    jit_extr_u(JIT_R1, JIT_R2, 1, 31);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for unsigned bitfields at offset 2 */
    nU2_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 1);
    jit_extr_u(JIT_R1, JIT_R2, 2, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 2);
    jit_extr_u(JIT_R1, JIT_R2, 2, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 3);
    jit_extr_u(JIT_R1, JIT_R2, 2, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 4);
    jit_extr_u(JIT_R1, JIT_R2, 2, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 5);
    jit_extr_u(JIT_R1, JIT_R2, 2, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 6);
    jit_extr_u(JIT_R1, JIT_R2, 2, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 7);
    jit_extr_u(JIT_R1, JIT_R2, 2, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 8);
    jit_extr_u(JIT_R1, JIT_R2, 2, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 9);
    jit_extr_u(JIT_R1, JIT_R2, 2, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 10);
    jit_extr_u(JIT_R1, JIT_R2, 2, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 11);
    jit_extr_u(JIT_R1, JIT_R2, 2, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 12);
    jit_extr_u(JIT_R1, JIT_R2, 2, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 13);
    jit_extr_u(JIT_R1, JIT_R2, 2, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 14);
    jit_extr_u(JIT_R1, JIT_R2, 2, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 15);
    jit_extr_u(JIT_R1, JIT_R2, 2, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 16);
    jit_extr_u(JIT_R1, JIT_R2, 2, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 17);
    jit_extr_u(JIT_R1, JIT_R2, 2, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 18);
    jit_extr_u(JIT_R1, JIT_R2, 2, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 19);
    jit_extr_u(JIT_R1, JIT_R2, 2, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 20);
    jit_extr_u(JIT_R1, JIT_R2, 2, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 21);
    jit_extr_u(JIT_R1, JIT_R2, 2, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 22);
    jit_extr_u(JIT_R1, JIT_R2, 2, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 23);
    jit_extr_u(JIT_R1, JIT_R2, 2, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 24);
    jit_extr_u(JIT_R1, JIT_R2, 2, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 25);
    jit_extr_u(JIT_R1, JIT_R2, 2, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 26);
    jit_extr_u(JIT_R1, JIT_R2, 2, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 27);
    jit_extr_u(JIT_R1, JIT_R2, 2, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 28);
    jit_extr_u(JIT_R1, JIT_R2, 2, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 29);
    jit_extr_u(JIT_R1, JIT_R2, 2, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU2_30 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 30) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 2, 30);
    jit_extr_u(JIT_R1, JIT_R2, 2, 30);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for unsigned bitfields at offset 3 */
    nU3_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 1);
    jit_extr_u(JIT_R1, JIT_R2, 3, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 2);
    jit_extr_u(JIT_R1, JIT_R2, 3, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 3);
    jit_extr_u(JIT_R1, JIT_R2, 3, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 4);
    jit_extr_u(JIT_R1, JIT_R2, 3, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 5);
    jit_extr_u(JIT_R1, JIT_R2, 3, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 6);
    jit_extr_u(JIT_R1, JIT_R2, 3, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 7);
    jit_extr_u(JIT_R1, JIT_R2, 3, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 8);
    jit_extr_u(JIT_R1, JIT_R2, 3, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 9);
    jit_extr_u(JIT_R1, JIT_R2, 3, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 10);
    jit_extr_u(JIT_R1, JIT_R2, 3, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 11);
    jit_extr_u(JIT_R1, JIT_R2, 3, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 12);
    jit_extr_u(JIT_R1, JIT_R2, 3, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 13);
    jit_extr_u(JIT_R1, JIT_R2, 3, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 14);
    jit_extr_u(JIT_R1, JIT_R2, 3, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 15);
    jit_extr_u(JIT_R1, JIT_R2, 3, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 16);
    jit_extr_u(JIT_R1, JIT_R2, 3, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 17);
    jit_extr_u(JIT_R1, JIT_R2, 3, 17);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_18 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 18) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 18);
    jit_extr_u(JIT_R1, JIT_R2, 3, 18);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_19 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 19) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 19);
    jit_extr_u(JIT_R1, JIT_R2, 3, 19);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_20 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 20) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 20);
    jit_extr_u(JIT_R1, JIT_R2, 3, 20);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_21 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 21) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 21);
    jit_extr_u(JIT_R1, JIT_R2, 3, 21);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_22 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 22) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 22);
    jit_extr_u(JIT_R1, JIT_R2, 3, 22);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_23 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 23) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 23);
    jit_extr_u(JIT_R1, JIT_R2, 3, 23);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_24 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 24) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 24);
    jit_extr_u(JIT_R1, JIT_R2, 3, 24);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_25 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 25) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 25);
    jit_extr_u(JIT_R1, JIT_R2, 3, 25);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_26 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 26) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 26);
    jit_extr_u(JIT_R1, JIT_R2, 3, 26);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_27 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 27) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 27);
    jit_extr_u(JIT_R1, JIT_R2, 3, 27);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_28 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 28) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 28);
    jit_extr_u(JIT_R1, JIT_R2, 3, 28);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU3_29 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 29) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 3, 29);
    jit_extr_u(JIT_R1, JIT_R2, 3, 29);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    /* Define jit functions for unsigned bitfields at offset 4 */
    nU4_1 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 1) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 1);
    jit_extr_u(JIT_R1, JIT_R2, 4, 1);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_2 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 2) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 2);
    jit_extr_u(JIT_R1, JIT_R2, 4, 2);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_3 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 3) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 3);
    jit_extr_u(JIT_R1, JIT_R2, 4, 3);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_4 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 4) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 4);
    jit_extr_u(JIT_R1, JIT_R2, 4, 4);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_5 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 5) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 5);
    jit_extr_u(JIT_R1, JIT_R2, 4, 5);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_6 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 6) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 6);
    jit_extr_u(JIT_R1, JIT_R2, 4, 6);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_7 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 7) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 7);
    jit_extr_u(JIT_R1, JIT_R2, 4, 7);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_8 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 8) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 8);
    jit_extr_u(JIT_R1, JIT_R2, 4, 8);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_9 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 9) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 9);
    jit_extr_u(JIT_R1, JIT_R2, 4, 9);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_10 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 10) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 10);
    jit_extr_u(JIT_R1, JIT_R2, 4, 10);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_11 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 11) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 11);
    jit_extr_u(JIT_R1, JIT_R2, 4, 11);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_12 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 12) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 12);
    jit_extr_u(JIT_R1, JIT_R2, 4, 12);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_13 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 13) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 13);
    jit_extr_u(JIT_R1, JIT_R2, 4, 13);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_14 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 14) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 14);
    jit_extr_u(JIT_R1, JIT_R2, 4, 14);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_15 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 15) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 15);
    jit_extr_u(JIT_R1, JIT_R2, 4, 15);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_16 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 16) - 1) ^ 1);
    jit_depr(JIT_R2, JIT_R1, 4, 16);
    jit_extr_u(JIT_R1, JIT_R2, 4, 16);
    jit_str(JIT_R0, JIT_R2);
    jit_retr(JIT_R1);
    jit_epilog();
    nU4_17 = jit_label();
    jit_prolog();
    arg = jit_arg();
    jit_getarg(JIT_R0, arg);
    jit_ldr(JIT_R2, JIT_R0);
    jit_movi(JIT_R1, ((ONE << 17) - 1) ^ 1);
    jit_depr(JIT_R2, JI