/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.27
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPYTHON
/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif



#include <Python.h>

/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------
 * SWIG API. Portion that goes into the runtime
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
 * for internal method declarations
 * ----------------------------------------------------------------------------- */

#ifndef SWIGINTERN
#  define SWIGINTERN static SWIGUNUSED
#endif

#ifndef SWIGINTERNINLINE
#  define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/*
  Exception handling in wrappers
*/
#define SWIG_fail                goto fail
#define SWIG_arg_fail(arg)       SWIG_Python_ArgFail(arg)
#define SWIG_append_errmsg(msg)   SWIG_Python_AddErrMesg(msg,0)
#define SWIG_preppend_errmsg(msg) SWIG_Python_AddErrMesg(msg,1)
#define SWIG_type_error(type,obj) SWIG_Python_TypeError(type,obj)
#define SWIG_null_ref(type)       SWIG_Python_NullRef(type)

/*
  Contract support
*/
#define SWIG_contract_assert(expr, msg) \
 if (!(expr)) { PyErr_SetString(PyExc_RuntimeError, (char *) msg ); goto fail; } else

/* -----------------------------------------------------------------------------
 * Constant declarations
 * ----------------------------------------------------------------------------- */

/* Constant Types */
#define SWIG_PY_INT     1
#define SWIG_PY_FLOAT   2
#define SWIG_PY_STRING  3
#define SWIG_PY_POINTER 4
#define SWIG_PY_BINARY  5

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;


/* -----------------------------------------------------------------------------
 * Alloc. memory flags
 * ----------------------------------------------------------------------------- */
#define SWIG_OLDOBJ  1
#define SWIG_NEWOBJ  SWIG_OLDOBJ + 1
#define SWIG_PYSTR   SWIG_NEWOBJ + 1

#ifdef __cplusplus
}
#endif


/***********************************************************************
 * pyrun.swg
 *
 *     This file contains the runtime support for Python modules
 *     and includes code for managing global variables and pointer
 *     type checking.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 ************************************************************************/

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags)    SWIG_Python_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags)       SWIG_Python_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags)  SWIG_Python_MustGetPtr(p, type, argnum, flags)
 

/* Python-specific SWIG API */
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags)   SWIG_Python_ConvertPacked(obj, ptr, sz, ty, flags)
#define SWIG_NewPackedObj(ptr, sz, type)              SWIG_Python_NewPackedObj(ptr, sz, type)

/* Runtime API */
#define SWIG_GetModule(clientdata) SWIG_Python_GetModule()
#define SWIG_SetModule(clientdata, pointer) SWIG_Python_SetModule(pointer)

/* -----------------------------------------------------------------------------
 * Pointer declarations
 * ----------------------------------------------------------------------------- */
/*
  Use SWIG_NO_COBJECT_TYPES to force the use of strings to represent
  C/C++ pointers in the python side. Very useful for debugging, but
  not always safe.
*/
#if !defined(SWIG_NO_COBJECT_TYPES) && !defined(SWIG_COBJECT_TYPES)
#  define SWIG_COBJECT_TYPES
#endif

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2


/* Add PyOS_snprintf for old Pythons */
#if PY_VERSION_HEX < 0x02020000
#define PyOS_snprintf snprintf
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------------
 * Create a new pointer string 
 * ----------------------------------------------------------------------------- */
#ifndef SWIG_BUFFER_SIZE
#define SWIG_BUFFER_SIZE 1024
#endif

/* A crude PyString_FromFormat implementation for old Pythons */
#if PY_VERSION_HEX < 0x02020000
static PyObject *
PyString_FromFormat(const char *fmt, ...) {
  va_list ap;
  char buf[SWIG_BUFFER_SIZE * 2];
  int res;
  va_start(ap, fmt);
  res = vsnprintf(buf, sizeof(buf), fmt, ap);
  va_end(ap);
  return (res < 0 || res >= sizeof(buf)) ? 0 : PyString_FromString(buf);
}
#endif

#if PY_VERSION_HEX < 0x01060000
#define PyObject_Del(op) PyMem_DEL((op))
#endif

#if defined(SWIG_COBJECT_TYPES)
#if !defined(SWIG_COBJECT_PYTHON)
/* -----------------------------------------------------------------------------
 * Implements a simple Swig Object type, and use it instead of PyCObject
 * ----------------------------------------------------------------------------- */

typedef struct {
  PyObject_HEAD
  void *ptr;
  const char *desc;
} PySwigObject;

/* Declarations for objects of type PySwigObject */

SWIGRUNTIME int
PySwigObject_print(PySwigObject *v, FILE *fp, int flags)
{
  char result[SWIG_BUFFER_SIZE];
  flags = flags;
  if (SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result))) {
    fputs("<Swig Object at ", fp); fputs(result, fp); fputs(">", fp);
    return 0; 
  } else {
    return 1; 
  }
}
  
SWIGRUNTIME PyObject *
PySwigObject_repr(PySwigObject *v)
{
  char result[SWIG_BUFFER_SIZE];
  return SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result)) ?
    PyString_FromFormat("<Swig Object at %s>", result) : 0;
}

SWIGRUNTIME PyObject *
PySwigObject_str(PySwigObject *v)
{
  char result[SWIG_BUFFER_SIZE];
  return SWIG_PackVoidPtr(result, v->ptr, v->desc, sizeof(result)) ?
    PyString_FromString(result) : 0;
}

SWIGRUNTIME PyObject *
PySwigObject_long(PySwigObject *v)
{
  return PyLong_FromVoidPtr(v->ptr);
}

SWIGRUNTIME PyObject *
PySwigObject_format(const char* fmt, PySwigObject *v)
{
  PyObject *res = NULL;
  PyObject *args = PyTuple_New(1);
  if (args && (PyTuple_SetItem(args, 0, PySwigObject_long(v)) == 0)) {
    PyObject *ofmt = PyString_FromString(fmt);
    if (ofmt) {
      res = PyString_Format(ofmt,args);
      Py_DECREF(ofmt);
    }
    Py_DECREF(args);
  }  
  return res;
}

SWIGRUNTIME PyObject *
PySwigObject_oct(PySwigObject *v)
{
  return PySwigObject_format("%o",v);
}

SWIGRUNTIME PyObject *
PySwigObject_hex(PySwigObject *v)
{
  return PySwigObject_format("%x",v);
}

SWIGRUNTIME int
PySwigObject_compare(PySwigObject *v, PySwigObject *w)
{
  int c = strcmp(v->desc, w->desc);
  if (c) {
    return (c > 0) ? 1 : -1;
  } else {
    void *i = v->ptr;
    void *j = w->ptr;
    return (i < j) ? -1 : ((i > j) ? 1 : 0);
  }
}

SWIGRUNTIME void
PySwigObject_dealloc(PySwigObject *self)
{
  PyObject_Del(self);
}

SWIGRUNTIME PyTypeObject*
PySwigObject_type(void) {
  static char pyswigobject_type__doc__[] = 
    "Swig object carries a C/C++ instance pointer";
  
  static PyNumberMethods PySwigObject_as_number = {
    (binaryfunc)0, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)0, /*nb_multiply*/
    (binaryfunc)0, /*nb_divide*/
    (binaryfunc)0, /*nb_remainder*/
    (binaryfunc)0, /*nb_divmod*/
    (ternaryfunc)0,/*nb_power*/
    (unaryfunc)0,  /*nb_negative*/
    (unaryfunc)0,  /*nb_positive*/
    (unaryfunc)0,  /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    0,		   /*nb_invert*/
    0,		   /*nb_lshift*/
    0,		   /*nb_rshift*/
    0,		   /*nb_and*/
    0,		   /*nb_xor*/
    0,		   /*nb_or*/
    (coercion)0,   /*nb_coerce*/
    (unaryfunc)PySwigObject_long, /*nb_int*/
    (unaryfunc)PySwigObject_long, /*nb_long*/
    (unaryfunc)0,                 /*nb_float*/
    (unaryfunc)PySwigObject_oct,  /*nb_oct*/
    (unaryfunc)PySwigObject_hex,  /*nb_hex*/
#if PY_VERSION_HEX >= 0x02020000
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_inplace_true_divide */ 
#elif PY_VERSION_HEX >= 0x02000000
    0,0,0,0,0,0,0,0,0,0,0 /* nb_inplace_add -> nb_inplace_or */
#endif
  };

  static PyTypeObject pyswigobject_type
#if !defined(__cplusplus)
  ;  
  static int type_init = 0;
  if (!type_init) {
    PyTypeObject tmp
#endif
    = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,					/*ob_size*/
    (char *)"PySwigObject",		/*tp_name*/
    sizeof(PySwigObject),		/*tp_basicsize*/
    0,					/*tp_itemsize*/
    /* methods */
    (destructor)PySwigObject_dealloc,	/*tp_dealloc*/
    (printfunc)PySwigObject_print,	/*tp_print*/
    (getattrfunc)0,			/*tp_getattr*/
    (setattrfunc)0,			/*tp_setattr*/
    (cmpfunc)PySwigObject_compare,	/*tp_compare*/
    (reprfunc)PySwigObject_repr,	/*tp_repr*/
    &PySwigObject_as_number,	        /*tp_as_number*/
    0,					/*tp_as_sequence*/
    0,					/*tp_as_mapping*/
    (hashfunc)0,			/*tp_hash*/
    (ternaryfunc)0,			/*tp_call*/
    (reprfunc)PySwigObject_str,		/*tp_str*/
    /* Space for future expansion */
    0,0,0,0,
    pyswigobject_type__doc__, 	        /* Documentation string */
#if PY_VERSION_HEX >= 0x02000000
    0,                                  /* tp_traverse */
    0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
    0,                                  /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
    0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
    0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };
#if !defined(__cplusplus)
    pyswigobject_type = tmp;
    type_init = 1;
  }
#endif
  return &pyswigobject_type;
}

SWIGRUNTIME PyObject *
PySwigObject_FromVoidPtrAndDesc(void *ptr, const char *desc)
{
  PySwigObject *self = PyObject_NEW(PySwigObject, PySwigObject_type());
  if (self) {
    self->ptr = ptr;
    self->desc = desc;
  }
  return (PyObject *)self;
}

SWIGRUNTIMEINLINE void *
PySwigObject_AsVoidPtr(PyObject *self)
{
  return ((PySwigObject *)self)->ptr;
}

SWIGRUNTIMEINLINE const char *
PySwigObject_GetDesc(PyObject *self)
{
  return ((PySwigObject *)self)->desc;
}

SWIGRUNTIMEINLINE int
PySwigObject_Check(PyObject *op) {
  return ((op)->ob_type == PySwigObject_type()) 
    || (strcmp((op)->ob_type->tp_name,"PySwigObject") == 0);
}

/* -----------------------------------------------------------------------------
 * Implements a simple Swig Packed type, and use it instead of string
 * ----------------------------------------------------------------------------- */

typedef struct {
  PyObject_HEAD
  void *pack;
  const char *desc;
  size_t size;
} PySwigPacked;

SWIGRUNTIME int
PySwigPacked_print(PySwigPacked *v, FILE *fp, int flags)
{
  char result[SWIG_BUFFER_SIZE];
  flags = flags;
  fputs("<Swig Packed ", fp); 
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    fputs("at ", fp); 
    fputs(result, fp); 
  }
  fputs(v->desc,fp); 
  fputs(">", fp);
  return 0; 
}
  
SWIGRUNTIME PyObject *
PySwigPacked_repr(PySwigPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))) {
    return PyString_FromFormat("<Swig Packed at %s%s>", result, v->desc);
  } else {
    return PyString_FromFormat("<Swig Packed %s>", v->desc);
  }  
}

SWIGRUNTIME PyObject *
PySwigPacked_str(PySwigPacked *v)
{
  char result[SWIG_BUFFER_SIZE];
  if (SWIG_PackDataName(result, v->pack, v->size, 0, sizeof(result))){
    return PyString_FromFormat("%s%s", result, v->desc);
  } else {
    return PyString_FromString(v->desc);
  }  
}

SWIGRUNTIME int
PySwigPacked_compare(PySwigPacked *v, PySwigPacked *w)
{
  int c = strcmp(v->desc, w->desc);
  if (c) {
    return (c > 0) ? 1 : -1;
  } else {
    size_t i = v->size;
    size_t j = w->size;
    int s = (i < j) ? -1 : ((i > j) ? 1 : 0);
    return s ? s : strncmp((char *)v->pack, (char *)w->pack, 2*v->size);
  }
}

SWIGRUNTIME void
PySwigPacked_dealloc(PySwigPacked *self)
{
  free(self->pack);
  PyObject_Del(self);
}

SWIGRUNTIME PyTypeObject*
PySwigPacked_type(void) {
  static char pyswigpacked_type__doc__[] = 
    "Swig object carries a C/C++ instance pointer";
  static PyTypeObject pyswigpacked_type
#if !defined(__cplusplus)
  ;
  static int type_init = 0;  
  if (!type_init) {
    PyTypeObject tmp
#endif
    = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,					/*ob_size*/
    (char *)"PySwigPacked",		/*tp_name*/
    sizeof(PySwigPacked),		/*tp_basicsize*/
    0,					/*tp_itemsize*/
    /* methods */
    (destructor)PySwigPacked_dealloc,	/*tp_dealloc*/
    (printfunc)PySwigPacked_print,	/*tp_print*/
    (getattrfunc)0,			/*tp_getattr*/
    (setattrfunc)0,			/*tp_setattr*/
    (cmpfunc)PySwigPacked_compare,	/*tp_compare*/
    (reprfunc)PySwigPacked_repr,	/*tp_repr*/
    0,	                                /*tp_as_number*/
    0,					/*tp_as_sequence*/
    0,					/*tp_as_mapping*/
    (hashfunc)0,			/*tp_hash*/
    (ternaryfunc)0,			/*tp_call*/
    (reprfunc)PySwigPacked_str,		/*tp_str*/
    /* Space for future expansion */
    0,0,0,0,
    pyswigpacked_type__doc__, 	        /* Documentation string */
#if PY_VERSION_HEX >= 0x02000000
    0,                                  /* tp_traverse */
    0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
    0,                                  /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000         
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
    0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
    0,0,0,0                             /* tp_alloc -> tp_next */
#endif
    };
#if !defined(__cplusplus)
    pyswigpacked_type = tmp;
    type_init = 1;
  }
#endif
  return &pyswigpacked_type;
}

SWIGRUNTIME PyObject *
PySwigPacked_FromDataAndDesc(void *ptr, size_t size, const char *desc)
{
  PySwigPacked *self = PyObject_NEW(PySwigPacked, PySwigPacked_type());
  if (self == NULL) {
    return NULL;
  } else {
    void *pack = malloc(size);
    if (pack) {
      memcpy(pack, ptr, size);
      self->pack = pack;
      self->desc = desc;
      self->size = size;
      return (PyObject *) self;
    }
    return NULL;
  }
}

SWIGRUNTIMEINLINE const char *
PySwigPacked_UnpackData(PyObject *obj, void *ptr, size_t size)
{
  PySwigPacked *self = (PySwigPacked *)obj;
  if (self->size != size) return 0;
  memcpy(ptr, self->pack, size);
  return self->desc;
}

SWIGRUNTIMEINLINE const char *
PySwigPacked_GetDesc(PyObject *self)
{
  return ((PySwigPacked *)self)->desc;
}

SWIGRUNTIMEINLINE int
PySwigPacked_Check(PyObject *op) {
  return ((op)->ob_type == PySwigPacked_type()) 
    || (strcmp((op)->ob_type->tp_name,"PySwigPacked") == 0);
}

#else
/* -----------------------------------------------------------------------------
 * Use the old Python PyCObject instead of PySwigObject
 * ----------------------------------------------------------------------------- */

#define PySwigObject_GetDesc(obj)	           PyCObject_GetDesc(obj)
#define PySwigObject_Check(obj)	           PyCObject_Check(obj)
#define PySwigObject_AsVoidPtr(obj)	   PyCObject_AsVoidPtr(obj)
#define PySwigObject_FromVoidPtrAndDesc(p, d)  PyCObject_FromVoidPtrAndDesc(p, d, NULL)

#endif

#endif

/* -----------------------------------------------------------------------------
 * errors manipulation
 * ----------------------------------------------------------------------------- */

SWIGRUNTIME void
SWIG_Python_TypeError(const char *type, PyObject *obj)
{
  if (type) {
#if defined(SWIG_COBJECT_TYPES)
    if (obj && PySwigObject_Check(obj)) {
      const char *otype = (const char *) PySwigObject_GetDesc(obj);
      if (otype) {
	PyErr_Format(PyExc_TypeError, "a '%s' is expected, 'PySwigObject(%s)' is received",
		     type, otype);
	return;
      }
    } else 
#endif      
    {
      const char *otype = (obj ? obj->ob_type->tp_name : 0); 
      if (otype) {
	PyObject *str = PyObject_Str(obj);
	const char *cstr = str ? PyString_AsString(str) : 0;
	if (cstr) {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s(%s)' is received",
		       type, otype, cstr);
	} else {
	  PyErr_Format(PyExc_TypeError, "a '%s' is expected, '%s' is received",
		       type, otype);
	}
	Py_XDECREF(str);
	return;
      }
    }   
    PyErr_Format(PyExc_TypeError, "a '%s' is expected", type);
  } else {
    PyErr_Format(PyExc_TypeError, "unexpected type is received");
  }
}

SWIGRUNTIMEINLINE void
SWIG_Python_NullRef(const char *type)
{
  if (type) {
    PyErr_Format(PyExc_TypeError, "null reference of type '%s' was received",type);
  } else {
    PyErr_Format(PyExc_TypeError, "null reference was received");
  }
}

SWIGRUNTIME int
SWIG_Python_AddErrMesg(const char* mesg, int infront)
{
  if (PyErr_Occurred()) {
    PyObject *type = 0;
    PyObject *value = 0;
    PyObject *traceback = 0;
    PyErr_Fetch(&type, &value, &traceback);
    if (value) {
      PyObject *old_str = PyObject_Str(value);
      Py_XINCREF(type);
      PyErr_Clear();
      if (infront) {
	PyErr_Format(type, "%s %s", mesg, PyString_AsString(old_str));
      } else {
	PyErr_Format(type, "%s %s", PyString_AsString(old_str), mesg);
      }
      Py_DECREF(old_str);
    }
    return 1;
  } else {
    return 0;
  }
}

SWIGRUNTIME int
SWIG_Python_ArgFail(int argnum)
{
  if (PyErr_Occurred()) {
    /* add information about failing argument */
    char mesg[256];
    PyOS_snprintf(mesg, sizeof(mesg), "argument number %d:", argnum);
    return SWIG_Python_AddErrMesg(mesg, 1);
  } else {
    return 0;
  }
}


/* -----------------------------------------------------------------------------
 * pointers/data manipulation
 * ----------------------------------------------------------------------------- */

/* Convert a pointer value */
SWIGRUNTIME int
SWIG_Python_ConvertPtr(PyObject *obj, void **ptr, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char *c = 0;
  static PyObject *SWIG_this = 0;
  int    newref = 0;
  PyObject  *pyobj = 0;
  void *vptr;
  
  if (!obj) return 0;
  if (obj == Py_None) {
    *ptr = 0;
    return 0;
  }

#ifdef SWIG_COBJECT_TYPES
  if (!(PySwigObject_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PySwigObject_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  }  
  vptr = PySwigObject_AsVoidPtr(obj);
  c = (const char *) PySwigObject_GetDesc(obj);
  if (newref) { Py_DECREF(obj); }
  goto type_check;
#else
  if (!(PyString_Check(obj))) {
    if (!SWIG_this)
      SWIG_this = PyString_FromString("this");
    pyobj = obj;
    obj = PyObject_GetAttr(obj,SWIG_this);
    newref = 1;
    if (!obj) goto type_error;
    if (!PyString_Check(obj)) {
      Py_DECREF(obj);
      goto type_error;
    }
  } 
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  c = SWIG_UnpackVoidPtr(c, &vptr, ty->name);
  if (newref) { Py_DECREF(obj); }
  if (!c) goto type_error;
#endif

type_check:
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
    *ptr = SWIG_TypeCast(tc,vptr);
  } else {
    *ptr = vptr;
  }
  if ((pyobj) && (flags & SWIG_POINTER_DISOWN)) {
    PyObject_SetAttrString(pyobj,(char*)"thisown",Py_False);
  }
  return 0;

type_error:
  PyErr_Clear();
  if (pyobj && !obj) {    
    obj = pyobj;
    if (PyCFunction_Check(obj)) {
      /* here we get the method pointer for callbacks */
      char *doc = (((PyCFunctionObject *)obj) -> m_ml -> ml_doc);
      c = doc ? strstr(doc, "swig_ptr: ") : 0;
      if (c) {
	c = ty ? SWIG_UnpackVoidPtr(c + 10, &vptr, ty->name) : 0;
	if (!c) goto type_error;
	goto type_check;
      }
    }
  }
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
    } else {
      SWIG_Python_TypeError("C/C++ pointer", obj);
    }
  }
  return -1;
}

/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME void *
SWIG_Python_MustGetPtr(PyObject *obj, swig_type_info *ty, int argnum, int flags) {
  void *result;
  if (SWIG_Python_ConvertPtr(obj, &result, ty, flags) == -1) {
    PyErr_Clear();
    if (flags & SWIG_POINTER_EXCEPTION) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
      SWIG_Python_ArgFail(argnum);
    }
  }
  return result;
}

/* Convert a packed value value */
SWIGRUNTIME int
SWIG_Python_ConvertPacked(PyObject *obj, void *ptr, size_t sz, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char *c = 0;

#if defined(SWIG_COBJECT_TYPES) && !defined(SWIG_COBJECT_PYTHON)
  c = PySwigPacked_UnpackData(obj, ptr, sz);
#else
  if ((!obj) || (!PyString_Check(obj))) goto type_error;
  c = PyString_AsString(obj);
  /* Pointer values must start with leading underscore */
  c = SWIG_UnpackDataName(c, ptr, sz, ty->name);
#endif
  if (!c) goto type_error;
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return 0;

type_error:
  PyErr_Clear();
  if (flags & SWIG_POINTER_EXCEPTION) {
    if (ty) {
      SWIG_Python_TypeError(SWIG_TypePrettyName(ty), obj);
    } else {
      SWIG_Python_TypeError("C/C++ packed data", obj);
    }
  }
  return -1;
}  

/* Create a new array object */
SWIGRUNTIME PyObject *
SWIG_Python_NewPointerObj(void *ptr, swig_type_info *type, int own) {
  PyObject *robj = 0;
  if (!type) {
    if (!PyErr_Occurred()) {
      PyErr_Format(PyExc_TypeError, "Swig: null type passed to NewPointerObj");
    }
    return robj;
  }
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#ifdef SWIG_COBJECT_TYPES
  robj = PySwigObject_FromVoidPtrAndDesc((void *) ptr, (char *)type->name);
#else
  {
    char result[SWIG_BUFFER_SIZE];
    robj = SWIG_PackVoidPtr(result, ptr, type->name, sizeof(result)) ?
      PyString_FromString(result) : 0;
  }
#endif
  if (!robj || (robj == Py_None)) return robj;
  if (type->clientdata) {
    PyObject *inst;
    PyObject *args = Py_BuildValue((char*)"(O)", robj);
    Py_DECREF(robj);
    inst = PyObject_CallObject((PyObject *) type->clientdata, args);
    Py_DECREF(args);
    if (inst) {
      if (own) {
        PyObject_SetAttrString(inst,(char*)"thisown",Py_True);
      }
      robj = inst;
    }
  }
  return robj;
}

SWIGRUNTIME PyObject *
SWIG_Python_NewPackedObj(void *ptr, size_t sz, swig_type_info *type) {
  PyObject *robj = 0;
  if (!ptr) {
    Py_INCREF(Py_None);
    return Py_None;
  }
#if defined(SWIG_COBJECT_TYPES) && !defined(SWIG_COBJECT_PYTHON)
  robj = PySwigPacked_FromDataAndDesc((void *) ptr, sz, (char *)type->name);
#else
  {
    char result[SWIG_BUFFER_SIZE];
    robj = SWIG_PackDataName(result, ptr, sz, type->name, sizeof(result)) ?
      PyString_FromString(result) : 0;
  }
#endif
  return robj;
}

/* -----------------------------------------------------------------------------*
 *  Get type list 
 * -----------------------------------------------------------------------------*/

#ifdef SWIG_LINK_RUNTIME
void *SWIG_ReturnGlobalTypeList(void *);
#endif

SWIGRUNTIME swig_module_info *
SWIG_Python_GetModule(void) {
  static void *type_pointer = (void *)0;
  /* first check if module already created */
  if (!type_pointer) {
#ifdef SWIG_LINK_RUNTIME
    type_pointer = SWIG_ReturnGlobalTypeList((void *)0);
#else
    type_pointer = PyCObject_Import((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION,
				    (char*)"type_pointer" SWIG_TYPE_TABLE_NAME);
    if (PyErr_Occurred()) {
      PyErr_Clear();
      type_pointer = (void *)0;
    }
#endif
  }
  return (swig_module_info *) type_pointer;
}

#if PY_MAJOR_VERSION < 2
/* PyModule_AddObject function was introduced in Python 2.0.  The following function
is copied out of Python/modsupport.c in python version 2.3.4 */
SWIGINTERN int
PyModule_AddObject(PyObject *m, char *name, PyObject *o)
{
  PyObject *dict;
  if (!PyModule_Check(m)) {
    PyErr_SetString(PyExc_TypeError,
		    "PyModule_AddObject() needs module as first arg");
    return -1;
  }
  if (!o) {
    PyErr_SetString(PyExc_TypeError,
		    "PyModule_AddObject() needs non-NULL value");
    return -1;
  }
  
  dict = PyModule_GetDict(m);
  if (dict == NULL) {
    /* Internal error -- modules must have a dict! */
    PyErr_Format(PyExc_SystemError, "module '%s' has no __dict__",
		 PyModule_GetName(m));
    return -1;
  }
  if (PyDict_SetItemString(dict, name, o))
    return -1;
  Py_DECREF(o);
  return 0;
}
#endif

SWIGRUNTIME void
SWIG_Python_SetModule(swig_module_info *swig_module) {
  static PyMethodDef swig_empty_runtime_method_table[] = { {NULL, NULL, 0, NULL} };/* Sentinel */

  PyObject *module = Py_InitModule((char*)"swig_runtime_data" SWIG_RUNTIME_VERSION,
				   swig_empty_runtime_method_table);
  PyObject *pointer = PyCObject_FromVoidPtr((void *) swig_module, NULL);
  if (pointer && module) {
    PyModule_AddObject(module, (char*)"type_pointer" SWIG_TYPE_TABLE_NAME, pointer);
  }
}

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_CdIo_t swig_types[0]
#define SWIGTYPE_p_CdioList_t swig_types[1]
#define SWIGTYPE_p_cdio_read_mode_t swig_types[2]
#define SWIGTYPE_p_char swig_types[3]
#define SWIGTYPE_p_int swig_types[4]
#define SWIGTYPE_p_iso9660_dir_t swig_types[5]
#define SWIGTYPE_p_iso9660_dtime_t swig_types[6]
#define SWIGTYPE_p_iso9660_ltime_t swig_types[7]
#define SWIGTYPE_p_iso9660_pvd_t swig_types[8]
#define SWIGTYPE_p_iso9660_stat_t swig_types[9]
#define SWIGTYPE_p_iso9660_t swig_types[10]
#define SWIGTYPE_p_long swig_types[11]
#define SWIGTYPE_p_unsigned_int swig_types[12]
#define SWIGTYPE_ptrdiff_t swig_types[13]
#define SWIGTYPE_size_t swig_types[14]
static swig_type_info *swig_types[16];
static swig_module_info swig_module = {swig_types, 15, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */


/*-----------------------------------------------
              @(target):= _pyiso9660.so
  ------------------------------------------------*/
#define SWIG_init    init_pyiso9660

#define SWIG_name    "_pyiso9660"

/* Includes the header in the wrapper code */
#include <time.h>
#include <cdio/iso9660.h>
#include <cdio/version.h>


  /*@/usr/share/swig/1.3.27/python/pymacros.swg,72,SWIG_define@*/
#define SWIG_From_long PyInt_FromLong
/*@@*/


/* When libcdio version > 0.76 comes out this won't be needed. */
#include <cdio/version.h>
#if LIBCDIO_VERSION_NUM <= 76

/**< Masks derived from above... */
#undef CDIO_DRIVE_CAP_WRITE_DVD
#define CDIO_DRIVE_CAP_WRITE_DVD (               \
      CDIO_DRIVE_CAP_WRITE_DVD_R                 \
    | CDIO_DRIVE_CAP_WRITE_DVD_PR                \
    | CDIO_DRIVE_CAP_WRITE_DVD_RAM               \
    | CDIO_DRIVE_CAP_WRITE_DVD_RW                \
    | CDIO_DRIVE_CAP_WRITE_DVD_RPW               \
    ) 

/** All the different ways a block/sector can be read. */
typedef enum {
  CDIO_READ_MODE_AUDIO,  /**< CD-DA, audio, Red Book */
  CDIO_READ_MODE_M1F1,   /**< Mode 1 Form 1 */
  CDIO_READ_MODE_M1F2,   /**< Mode 1 Form 2 */
  CDIO_READ_MODE_M2F1,   /**< Mode 2 Form 1 */
  CDIO_READ_MODE_M2F2,   /**< Mode 2 Form 2 */
} cdio_read_mode_t;

/*!
  Reads a number of sectors (AKA blocks).
  
  @param p_buf place to read data into. The caller should make sure
  this location is large enough. See below for size information.
  @param read_mode the kind of "mode" to use in reading.
  @param i_lsn sector to read
  @param i_blocks number of sectors to read
  @return DRIVER_OP_SUCCESS (0) if no error, other (negative) enumerations
  are returned on error.
  
  If read_mode is CDIO_MODE_AUDIO,
    *p_buf should hold at least CDIO_FRAMESIZE_RAW * i_blocks bytes.

  If read_mode is CDIO_MODE_DATA,
    *p_buf should hold at least i_blocks times either ISO_BLOCKSIZE, 
    M1RAW_SECTOR_SIZE or M2F2_SECTOR_SIZE depending on the kind of 
    sector getting read. If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is M2RAW_SECTOR_SIZE.

  If read_mode is CDIO_MODE_M2F1,
    *p_buf should hold at least M2RAW_SECTOR_SIZE * i_blocks bytes.

  If read_mode is CDIO_MODE_M2F2,
    *p_buf should hold at least CDIO_CD_FRAMESIZE * i_blocks bytes.


*/
driver_return_code_t 
cdio_read_sectors(const CdIo_t *p_cdio, void *p_buf, lsn_t i_lsn, 
                  cdio_read_mode_t read_mode, uint32_t i_blocks)
{
  switch(read_mode) {
  case CDIO_READ_MODE_AUDIO:
    return cdio_read_audio_sectors (p_cdio, p_buf, i_lsn, i_blocks);
  case CDIO_READ_MODE_M1F1:
    return cdio_read_mode1_sectors (p_cdio, p_buf, i_lsn, false, i_blocks);
  case CDIO_READ_MODE_M1F2:
    return cdio_read_mode1_sectors (p_cdio, p_buf, i_lsn, true,  i_blocks);
  case CDIO_READ_MODE_M2F1:
    return cdio_read_mode2_sectors (p_cdio, p_buf, i_lsn, false, i_blocks);
  case CDIO_READ_MODE_M2F2:
    return cdio_read_mode2_sectors (p_cdio, p_buf, i_lsn, true,  i_blocks);
  }
  /* Can't happen. Just to shut up gcc. */
  return DRIVER_OP_ERROR; 
}

driver_return_code_t
cdio_eject_media_drive (const char *psz_drive)
{
  CdIo_t *p_cdio = cdio_open (psz_drive, DRIVER_DEVICE);
  if (p_cdio) {
    return cdio_eject_media(&p_cdio);
  } else {
    return DRIVER_OP_UNINIT;
  }
}
#endif /* LIBCDIO_VERSION_NUM <= 76 */


  /*@/usr/share/swig/1.3.27/python/pymacros.swg,72,SWIG_define@*/
#define SWIG_From_int PyInt_FromLong
/*@@*/


#include <limits.h>


SWIGINTERN int
  SWIG_CheckLongInRange(long value, long min_value, long max_value,
			const char *errmsg)
{
  if (value < min_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError, 
		   "value %ld is less than '%s' minimum %ld", 
		   value, errmsg, min_value);
    }
    return 0;    
  } else if (value > max_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError,
		   "value %ld is greater than '%s' maximum %ld", 
		   value, errmsg, max_value);
    }
    return 0;
  }
  return 1;
}


SWIGINTERN int
  SWIG_AsVal_long(PyObject * obj, long* val)
{
  if (PyLong_Check(obj)) {
    long v = PyLong_AsLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  }
  if (PyInt_Check(obj)) {
    if (val) *val = PyInt_AsLong(obj);
    return 1;
  }
  if (val) {
    SWIG_type_error("long", obj);
  }
  return 0;
 }


#if INT_MAX != LONG_MAX
SWIGINTERN int
  SWIG_AsVal_int(PyObject *obj, int *val)
{ 
  const char* errmsg = val ? "int" : (char*)0;
  long v;
  if (SWIG_AsVal_long(obj, &v)) {
    if (SWIG_CheckLongInRange(v, INT_MIN,INT_MAX, errmsg)) {
      if (val) *val = (int)(v);
      return 1;
    } else {
      return 0;
    }
  } else {
    PyErr_Clear();
  }
  if (val) {
    SWIG_type_error(errmsg, obj);
  }
  return 0;    
}
#else
SWIGINTERNINLINE int
  SWIG_AsVal_int(PyObject *obj, int *val)
{
  return SWIG_AsVal_long(obj,(long*)val);
}
#endif


SWIGINTERNINLINE int
SWIG_As_int(PyObject* obj)
{
  int v;
  if (!SWIG_AsVal_int(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(int));
  }
  return v;
}


SWIGINTERNINLINE int
  SWIG_CheckUnsignedLongInRange(unsigned long value,
				unsigned long max_value,
				const char *errmsg) 
{
  if (value > max_value) {
    if (errmsg) {
      PyErr_Format(PyExc_OverflowError,
		   "value %lu is greater than '%s' minimum %lu",
		   value, errmsg, max_value);
    }
    return 0;
  }
  return 1;
 }


SWIGINTERN int
  SWIG_AsVal_unsigned_SS_long(PyObject *obj, unsigned long *val) 
{
  if (PyLong_Check(obj)) {
    unsigned long v = PyLong_AsUnsignedLong(obj);
    if (!PyErr_Occurred()) {
      if (val) *val = v;
      return 1;
    } else {
      if (!val) PyErr_Clear();
      return 0;
    }
  } 
  if (PyInt_Check(obj)) {
    long v = PyInt_AsLong(obj);
    if (v >= 0) {
      if (val) *val = v;
      return 1;
    }   
  }
  if (val) {
    SWIG_type_error("unsigned long", obj);
  }
  return 0;
}


#if UINT_MAX != ULONG_MAX
SWIGINTERN int
  SWIG_AsVal_unsigned_SS_int(PyObject *obj, unsigned int *val)
{ 
  const char* errmsg = val ? "unsigned int" : (char*)0;
  unsigned long v;
  if (SWIG_AsVal_unsigned_SS_long(obj, &v)) {
    if (SWIG_CheckUnsignedLongInRange(v, INT_MAX, errmsg)) {
      if (val) *val = (unsigned int)(v);
      return 1;
    }
  } else {
    PyErr_Clear();
  }
  if (val) {
    SWIG_type_error(errmsg, obj);
  }
  return 0;    
}
#else
SWIGINTERNINLINE unsigned int
  SWIG_AsVal_unsigned_SS_int(PyObject *obj, unsigned int *val)
{
  return SWIG_AsVal_unsigned_SS_long(obj,(unsigned long *)val);
}
#endif


SWIGINTERNINLINE unsigned int
SWIG_As_unsigned_SS_int(PyObject* obj)
{
  unsigned int v;
  if (!SWIG_AsVal_unsigned_SS_int(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(unsigned int));
  }
  return v;
}

  
SWIGINTERNINLINE int
SWIG_Check_int(PyObject* obj)
{
  return SWIG_AsVal_int(obj, (int*)0);
}

  
SWIGINTERNINLINE int
SWIG_Check_unsigned_SS_int(PyObject* obj)
{
  return SWIG_AsVal_unsigned_SS_int(obj, (unsigned int*)0);
}


/* returns SWIG_OLDOBJ if the input is a raw char*, SWIG_PYSTR if is a PyString */
SWIGINTERN int
SWIG_AsCharPtrAndSize(PyObject *obj, char** cptr, size_t* psize)
{
  static swig_type_info* pchar_info = 0;
  char* vptr = 0;
  if (!pchar_info) pchar_info = SWIG_TypeQuery("char *");
  if (SWIG_ConvertPtr(obj, (void**)&vptr, pchar_info, 0) != -1) {
    if (cptr) *cptr = vptr;
    if (psize) *psize = vptr ? (strlen(vptr) + 1) : 0;
    return SWIG_OLDOBJ;
  } else {
    PyErr_Clear();
    if (PyString_Check(obj)) {
      if (cptr) {
	*cptr = PyString_AS_STRING(obj);
	if (psize) {
	  *psize = PyString_GET_SIZE(obj) + 1;
	}
      }
      return SWIG_PYSTR;
    }
  }
  if (cptr) {
    SWIG_type_error("char *", obj);
  }
  return 0;
}


SWIGINTERNINLINE int
SWIG_AsCharPtr(PyObject *obj, char **val)
{
  if (SWIG_AsCharPtrAndSize(obj, val, (size_t*)(0))) {
    return 1;
  }
  if (val) {
    PyErr_Clear();
    SWIG_type_error("char *", obj);
  }
  return 0;
}


typedef CdioList_t IsoStatList_t;
typedef iso9660_stat_t IsoStat_t;


SWIGINTERNINLINE PyObject*
  SWIG_From_bool(bool value)
{
  PyObject *obj = value ? Py_True : Py_False;
  Py_INCREF(obj);
  return obj;
}


SWIGINTERNINLINE unsigned long
SWIG_As_unsigned_SS_long(PyObject* obj)
{
  unsigned long v;
  if (!SWIG_AsVal_unsigned_SS_long(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(unsigned long));
  }
  return v;
}


SWIGINTERN PyObject*
t_output_helper(PyObject* target, PyObject* o) {
  if (!target) {
    target = o;
  } else if (target == Py_None) {  
    Py_DECREF(target);
    target = o;
  } else {
    if (!PyList_Check(target)) {
      PyObject *o2 = target;
      target = PyList_New(1);
      PyList_SetItem(target, 0, o2);
    }
    PyList_Append(target,o);
    Py_DECREF(o);
    }
  return target;
}


SWIGINTERNINLINE PyObject *
SWIG_FromCharArray(const char* carray, size_t size)
{
  if (size > INT_MAX) {
    return SWIG_NewPointerObj((char *)(carray), 
			      SWIG_TypeQuery("char *"), 0);
  } else {
    return PyString_FromStringAndSize(carray, (int)(size));
  }
}


ssize_t 
seek_read (const iso9660_t *p_iso, lsn_t start, char *p_buf, 
	   ssize_t *pi_size) 
{
  *pi_size = iso9660_iso_seek_read(p_iso, p_buf, start, 
				   (*pi_size) / ISO_BLOCKSIZE);
  return *pi_size;
 }


iso9660_pvd_t *fs_read_pvd ( const CdIo_t *p_cdio ) {
  static iso9660_pvd_t pvd;
  bool b_ok = iso9660_fs_read_pvd ( p_cdio, &pvd );
  if (!b_ok) return NULL;
  return &pvd;
 }


iso9660_pvd_t *ifs_read_pvd ( const iso9660_t *p_iso ) {
  static iso9660_pvd_t pvd;
  bool b_ok = iso9660_ifs_read_pvd ( p_iso, &pvd );
  if (!b_ok) return NULL;
  return &pvd;
 }


iso9660_dtime_t *
set_dtime ( int year, int mon,  int mday, int hour, int min, int sec)
{
  struct tm tm = { sec,  min, hour, mday, mon-1, year-1900, 0, 0, -1 };
  static iso9660_dtime_t dtime;
  iso9660_set_dtime (&tm, &dtime);
  return &dtime;
}


iso9660_ltime_t *
set_ltime ( int year, int mon,  int mday, int hour, int min, int sec)
 {
   struct tm tm = { sec, min, hour, mday, mon-1, year-1900, 0, 0, -1 };
  static iso9660_ltime_t ldate;
  iso9660_set_ltime (&tm, &ldate);
  return &ldate;
}


SWIGINTERN int
  SWIG_AsVal_bool(PyObject *obj, bool *val)
{
  if (obj == Py_True) {
    if (val) *val = true;
    return 1;
  }
  if (obj == Py_False) {
    if (val) *val = false;
    return 1;
  }
  int res = 0;
  if (SWIG_AsVal_int(obj, &res)) {    
    if (val) *val = res ? true : false;
    return 1;
  } else {
    PyErr_Clear();
  }  
  if (val) {
    SWIG_type_error("bool", obj);
  }
  return 0;
}


SWIGINTERNINLINE bool
SWIG_As_bool(PyObject* obj)
{
  bool v;
  if (!SWIG_AsVal_bool(obj, &v)) {
    /*
      this is needed to make valgrind/purify happier. 
     */
    memset((void*)&v, 0, sizeof(bool));
  }
  return v;
}

  
SWIGINTERNINLINE int
SWIG_Check_bool(PyObject* obj)
{
  return SWIG_AsVal_bool(obj, (bool*)0);
}


struct tm *get_dtime (const iso9660_dtime_t *p_dtime, bool use_localtime) {
  struct tm *p_tm = (struct tm *) calloc(1, sizeof(struct tm));
  if (!iso9660_get_dtime (p_dtime, use_localtime, p_tm)) {
    free(p_tm);
    return NULL;
  }
  return p_tm;
 }


struct tm *get_ltime (const iso9660_ltime_t *p_ltime)
{
  struct tm *p_tm = (struct tm *) calloc(1, sizeof(struct tm));
  if (!iso9660_get_ltime (p_ltime, p_tm)) {
    free(p_tm);
    return NULL;
  }
  return p_tm;
}


SWIGINTERN PyObject *
SWIG_FromCharPtr(const char* cptr)
{ 
  if (cptr) {
    size_t size = strlen(cptr);
    if (size > INT_MAX) {
      return SWIG_NewPointerObj((char*)(cptr), 
				SWIG_TypeQuery("char *"), 0);
    } else {
      if (size != 0) {
	return PyString_FromStringAndSize(cptr, size);
      } else {
	return PyString_FromString(cptr);
      }
    }
  }
  Py_INCREF(Py_None);
  return Py_None;
}


char *
name_translate(const char *psz_oldname) {
  char *psz_newname=calloc(sizeof(char), strlen(psz_oldname));
  iso9660_name_translate(psz_oldname, psz_newname);
  return psz_newname;
}


char * 
name_translate_ext(const char *psz_oldname, uint8_t i_joliet_level) {
  char *psz_newname=calloc(sizeof(char), strlen(psz_oldname));
  iso9660_name_translate_ext(psz_oldname, psz_newname, i_joliet_level);
  return psz_newname;
}

  
SWIGINTERNINLINE int
SWIG_Check_unsigned_SS_long(PyObject* obj)
{
  return SWIG_AsVal_unsigned_SS_long(obj, (unsigned long*)0);
}


char *
strncpy_pad(const char src[], size_t len, enum strncpy_pad_check _check) {
  char *dst = calloc(sizeof(char), len+1);
  return iso9660_strncpy_pad(dst, src, len, _check);
}


IsoStatList_t *fs_readdir (CdIo_t *p_cdio, const char psz_path[])
{
  CdioList_t *p_statlist = iso9660_fs_readdir (p_cdio, psz_path, false);
  return p_statlist;
}


IsoStatList_t *ifs_readdir (iso9660_t *p_iso, const char psz_path[])
{
  CdioList_t *p_statlist = iso9660_ifs_readdir (p_iso, psz_path);
  return p_statlist;
}


char *
ifs_get_application_id(iso9660_t *p_iso) {
  char *psz;
  bool ok = iso9660_ifs_get_application_id(p_iso, &psz);
  if (!ok) return NULL;
  return psz;
}


SWIGINTERNINLINE PyObject* 
  SWIG_From_unsigned_SS_long(unsigned long value)
{
  return (value > LONG_MAX) ?
    PyLong_FromUnsignedLong(value) 
    : PyInt_FromLong((long)(value)); 
}


#if UINT_MAX < LONG_MAX
/*@/usr/share/swig/1.3.27/python/pymacros.swg,72,SWIG_define@*/
#define SWIG_From_unsigned_SS_int SWIG_From_long
/*@@*/
#else
/*@/usr/share/swig/1.3.27/python/pymacros.swg,72,SWIG_define@*/
#define SWIG_From_unsigned_SS_int SWIG_From_unsigned_SS_long
/*@@*/
#endif


char *
ifs_get_preparer_id(iso9660_t *p_iso) {
  char *psz;
  bool ok = iso9660_ifs_get_preparer_id(p_iso, &psz);
  if (!ok) return NULL;
  return psz;
}


char *
ifs_get_publisher_id(iso9660_t *p_iso) {
  char *psz;
  bool ok = iso9660_ifs_get_publisher_id(p_iso, &psz);
  if (!ok) return NULL;
  return psz;
}


char *
ifs_get_system_id(iso9660_t *p_iso) {
  char *psz;
  bool ok = iso9660_ifs_get_system_id(p_iso, &psz);
  if (!ok) return NULL;
  return psz;
}


char *
ifs_get_volume_id(iso9660_t *p_iso) {
  char *psz;
  bool ok = iso9660_ifs_get_volume_id(p_iso, &psz);
  if (!ok) return NULL;
  return psz;
}


char *
ifs_get_volumeset_id(iso9660_t *p_iso) {
  char *psz;
  bool ok = iso9660_ifs_get_volumeset_id(p_iso, &psz);
  if (!ok) return NULL;
  return psz;
}

#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_cdio_read_sectors(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    void *arg2 = (void *) 0 ;
    lsn_t arg3 ;
    cdio_read_mode_t arg4 ;
    unsigned int arg5 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOO:cdio_read_sectors",&obj0,&obj1,&obj2,&obj3,&obj4)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        if ((SWIG_ConvertPtr(obj1,(void **)(&arg2),0,SWIG_POINTER_EXCEPTION|0))== -1) {
            SWIG_arg_fail(2);SWIG_fail;
        }
    }
    {
        arg3 = (lsn_t)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (cdio_read_mode_t)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (unsigned int)(SWIG_As_unsigned_SS_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    result = (driver_return_code_t)cdio_read_sectors((CdIo_t const *)arg1,arg2,arg3,arg4,arg5);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_cdio_eject_media_drive(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 = (char *) 0 ;
    driver_return_code_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:cdio_eject_media_drive",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (driver_return_code_t)cdio_eject_media_drive((char const *)arg1);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_open_iso(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 = (char *) 0 ;
    iso9660_t *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:open_iso",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (iso9660_t *)iso9660_open((char const *)arg1);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_iso9660_t, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_open_ext(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 = (char *) 0 ;
    iso_extension_mask_t arg2 ;
    iso9660_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:open_ext",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    {
        arg2 = (iso_extension_mask_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (iso9660_t *)iso9660_open_ext((char const *)arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_iso9660_t, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_open_fuzzy(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 = (char *) 0 ;
    uint16_t arg2 ;
    iso9660_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:open_fuzzy",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    {
        arg2 = (uint16_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (iso9660_t *)iso9660_open_fuzzy((char const *)arg1,arg2);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_iso9660_t, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_iso9660_open_fuzzy_ext(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 = (char *) 0 ;
    iso_extension_mask_t arg2 ;
    uint16_t arg3 ;
    iso9660_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:iso9660_open_fuzzy_ext",&obj0,&obj1,&obj2)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    {
        arg2 = (iso_extension_mask_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (uint16_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    result = (iso9660_t *)iso9660_open_fuzzy_ext((char const *)arg1,arg2,arg3);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_iso9660_t, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_fuzzy_read_superblock(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    iso_extension_mask_t arg2 ;
    uint16_t arg3 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:ifs_fuzzy_read_superblock",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (iso_extension_mask_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (uint16_t)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    result = (bool)iso9660_ifs_fuzzy_read_superblock(arg1,arg2,arg3);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_close(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:close",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (bool)iso9660_close(arg1);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_seek_read(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    lsn_t arg2 ;
    char *arg3 = (char *) 0 ;
    ssize_t *arg4 = (ssize_t *) 0 ;
    ssize_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:seek_read",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (lsn_t)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        size_t n = SWIG_As_unsigned_SS_long(obj2);                           
        if (SWIG_arg_fail(3)) SWIG_fail;                               
        arg3 = ((char*) malloc((n+1)*sizeof(char)));				       
        arg4 = ((ssize_t*)malloc(sizeof(ssize_t)));				               
        *arg4 = n;							       
    }
    result = (ssize_t)seek_read((iso9660_t const *)arg1,arg2,arg3,arg4);
    
    {
        resultobj = SWIG_From_long((long)(result)); 
    }
    {
        resultobj = t_output_helper(resultobj, SWIG_FromCharArray(arg3,*arg4));      
        free((char*)arg3);					       
        free((char*)arg4);						       
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_fs_read_pvd(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    iso9660_pvd_t *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:fs_read_pvd",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (iso9660_pvd_t *)fs_read_pvd((CdIo_t const *)arg1);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_iso9660_pvd_t, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_read_pvd(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    iso9660_pvd_t *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ifs_read_pvd",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (iso9660_pvd_t *)ifs_read_pvd((iso9660_t const *)arg1);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_iso9660_pvd_t, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_fs_read_superblock(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    iso_extension_mask_t arg2 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:fs_read_superblock",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (iso_extension_mask_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (bool)iso9660_fs_read_superblock(arg1,arg2);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_read_superblock(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    iso_extension_mask_t arg2 ;
    bool result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:ifs_read_superblock",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (iso_extension_mask_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (bool)iso9660_ifs_read_superblock(arg1,arg2);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_set_dtime(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    int arg1 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    iso9660_dtime_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:set_dtime",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    {
        arg1 = (int)(SWIG_As_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        arg2 = (int)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (int)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (int)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (int)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        arg6 = (int)(SWIG_As_int(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    result = (iso9660_dtime_t *)set_dtime(arg1,arg2,arg3,arg4,arg5,arg6);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_iso9660_dtime_t, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_set_ltime(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    int arg1 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    iso9660_ltime_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    PyObject * obj4 = 0 ;
    PyObject * obj5 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOOOO:set_ltime",&obj0,&obj1,&obj2,&obj3,&obj4,&obj5)) goto fail;
    {
        arg1 = (int)(SWIG_As_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    {
        arg2 = (int)(SWIG_As_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (int)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (int)(SWIG_As_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    {
        arg5 = (int)(SWIG_As_int(obj4)); 
        if (SWIG_arg_fail(5)) SWIG_fail;
    }
    {
        arg6 = (int)(SWIG_As_int(obj5)); 
        if (SWIG_arg_fail(6)) SWIG_fail;
    }
    result = (iso9660_ltime_t *)set_ltime(arg1,arg2,arg3,arg4,arg5,arg6);
    
    resultobj = SWIG_NewPointerObj((void*)(result), SWIGTYPE_p_iso9660_ltime_t, 0);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_dtime(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_dtime_t *arg1 = (iso9660_dtime_t *) 0 ;
    bool arg2 ;
    struct tm *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:get_dtime",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_dtime_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    {
        arg2 = (bool)(SWIG_As_bool(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (struct tm *)get_dtime((iso9660_dtime_t const *)arg1,arg2);
    
    {
        struct tm *p_tm = result;
        
        if (result) {
            PyObject *o;
            resultobj = PyList_New(9);
            o = SWIG_From_int(p_tm->tm_year+1900);
            PyList_SetItem(resultobj, 0, o);
            o = SWIG_From_int(p_tm->tm_mon+1);
            PyList_SetItem(resultobj, 1, o);
            o = SWIG_From_int(p_tm->tm_mday);
            PyList_SetItem(resultobj, 2, o);
            o = SWIG_From_int(p_tm->tm_hour);
            PyList_SetItem(resultobj, 3, o);
            o = SWIG_From_int(p_tm->tm_min);
            PyList_SetItem(resultobj, 4, o);
            o = SWIG_From_int(p_tm->tm_sec);
            PyList_SetItem(resultobj, 5, o);
            o = SWIG_From_int((p_tm->tm_wday-1)%7);
            PyList_SetItem(resultobj, 6, o);
            o = SWIG_From_int(p_tm->tm_yday+1);
            PyList_SetItem(resultobj, 7, o);
            o = SWIG_From_int(p_tm->tm_isdst);
            PyList_SetItem(resultobj, 8, o);
            free (p_tm);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_ltime(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_ltime_t *arg1 = (iso9660_ltime_t *) 0 ;
    struct tm *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_ltime",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_ltime_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (struct tm *)get_ltime((iso9660_ltime_t const *)arg1);
    
    {
        struct tm *p_tm = result;
        
        if (result) {
            PyObject *o;
            resultobj = PyList_New(9);
            o = SWIG_From_int(p_tm->tm_year+1900);
            PyList_SetItem(resultobj, 0, o);
            o = SWIG_From_int(p_tm->tm_mon+1);
            PyList_SetItem(resultobj, 1, o);
            o = SWIG_From_int(p_tm->tm_mday);
            PyList_SetItem(resultobj, 2, o);
            o = SWIG_From_int(p_tm->tm_hour);
            PyList_SetItem(resultobj, 3, o);
            o = SWIG_From_int(p_tm->tm_min);
            PyList_SetItem(resultobj, 4, o);
            o = SWIG_From_int(p_tm->tm_sec);
            PyList_SetItem(resultobj, 5, o);
            o = SWIG_From_int((p_tm->tm_wday-1)%7);
            PyList_SetItem(resultobj, 6, o);
            o = SWIG_From_int(p_tm->tm_yday+1);
            PyList_SetItem(resultobj, 7, o);
            o = SWIG_From_int(p_tm->tm_isdst);
            PyList_SetItem(resultobj, 8, o);
            free (p_tm);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_is_dchar(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    int arg1 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:is_dchar",&obj0)) goto fail;
    {
        arg1 = (int)(SWIG_As_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    result = (bool)iso9660_isdchar(arg1);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_is_achar(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    int arg1 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:is_achar",&obj0)) goto fail;
    {
        arg1 = (int)(SWIG_As_int(obj0)); 
        if (SWIG_arg_fail(1)) SWIG_fail;
    }
    result = (bool)iso9660_isachar(arg1);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_name_translate(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 = (char *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:name_translate",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (char *)name_translate((char const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_name_translate_ext(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 = (char *) 0 ;
    uint8_t arg2 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:name_translate_ext",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    {
        arg2 = (uint8_t)(SWIG_As_unsigned_SS_int(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    result = (char *)name_translate_ext((char const *)arg1,arg2);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_strncpy_pad(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 ;
    size_t arg2 ;
    enum strncpy_pad_check arg3 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOO:strncpy_pad",&obj0,&obj1,&obj2)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    {
        arg2 = (size_t)(SWIG_As_unsigned_SS_long(obj1)); 
        if (SWIG_arg_fail(2)) SWIG_fail;
    }
    {
        arg3 = (enum strncpy_pad_check)(SWIG_As_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    result = (char *)strncpy_pad((char const (*))arg1,arg2,arg3);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_dirname_valid_p(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:dirname_valid_p",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (bool)iso9660_dirname_valid_p((char const (*))arg1);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_pathname_isofy(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 ;
    uint16_t arg2 = (uint16_t) 1 ;
    char *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O|O:pathname_isofy",&obj0,&obj1)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    if (obj1) {
        {
            arg2 = (uint16_t)(SWIG_As_unsigned_SS_int(obj1)); 
            if (SWIG_arg_fail(2)) SWIG_fail;
        }
    }
    result = (char *)iso9660_pathname_isofy((char const (*))arg1,arg2);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_pathname_valid_p(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    char *arg1 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:pathname_valid_p",&obj0)) goto fail;
    if (!SWIG_AsCharPtr(obj0, (char**)&arg1)) {
        SWIG_arg_fail(1);SWIG_fail;
    }
    result = (bool)iso9660_pathname_valid_p((char const (*))arg1);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_fs_stat(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *arg2 ;
    IsoStat_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:fs_stat",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (IsoStat_t *)iso9660_fs_stat(arg1,(char const (*))arg2);
    
    {
        iso9660_stat_t *p_statbuf = result;
        
        if (result) {
            PyObject *o;
            resultobj = PyList_New(0);
            o = PyString_FromString(p_statbuf->filename);
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->lsn)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->size)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->secsize)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->type)); 
            PyList_Append(resultobj, o);
            free (p_statbuf);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_fs_stat_translate(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *arg2 ;
    bool arg3 = (bool) false ;
    IsoStat_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO|O:fs_stat_translate",&obj0,&obj1,&obj2)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    if (obj2) {
        {
            arg3 = (bool)(SWIG_As_bool(obj2)); 
            if (SWIG_arg_fail(3)) SWIG_fail;
        }
    }
    result = (IsoStat_t *)iso9660_fs_stat_translate(arg1,(char const (*))arg2,arg3);
    
    {
        iso9660_stat_t *p_statbuf = result;
        
        if (result) {
            PyObject *o;
            resultobj = PyList_New(0);
            o = PyString_FromString(p_statbuf->filename);
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->lsn)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->size)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->secsize)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->type)); 
            PyList_Append(resultobj, o);
            free (p_statbuf);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_stat(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    char *arg2 ;
    IsoStat_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:ifs_stat",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (IsoStat_t *)iso9660_ifs_stat(arg1,(char const (*))arg2);
    
    {
        iso9660_stat_t *p_statbuf = result;
        
        if (result) {
            PyObject *o;
            resultobj = PyList_New(0);
            o = PyString_FromString(p_statbuf->filename);
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->lsn)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->size)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->secsize)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->type)); 
            PyList_Append(resultobj, o);
            free (p_statbuf);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_stat_translate(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    char *arg2 ;
    IsoStat_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:ifs_stat_translate",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (IsoStat_t *)iso9660_ifs_stat_translate(arg1,(char const (*))arg2);
    
    {
        iso9660_stat_t *p_statbuf = result;
        
        if (result) {
            PyObject *o;
            resultobj = PyList_New(0);
            o = PyString_FromString(p_statbuf->filename);
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->lsn)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->size)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->secsize)); 
            PyList_Append(resultobj, o);
            o = SWIG_From_long((long)(p_statbuf->type)); 
            PyList_Append(resultobj, o);
            free (p_statbuf);
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_fs_readdir(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    CdIo_t *arg1 = (CdIo_t *) 0 ;
    char *arg2 ;
    IsoStatList_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:fs_readdir",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_CdIo_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (IsoStatList_t *)fs_readdir(arg1,(char const (*))arg2);
    
    {
        CdioList_t *p_entlist   = result;
        CdioListNode_t *p_entnode;
        
        if (result) {
            resultobj = PyList_New(0);
            _CDIO_LIST_FOREACH (p_entnode, p_entlist) {
                PyObject *py_list = PyList_New(5);
                iso9660_stat_t *p_statbuf = 
                (iso9660_stat_t *) _cdio_list_node_data (p_entnode);
                PyObject *o;
                o = PyString_FromString(p_statbuf->filename);
                PyList_SetItem(py_list, 0, o);
                o = SWIG_From_long((long)(p_statbuf->lsn)); 
                PyList_SetItem(py_list, 1, o);
                o = SWIG_From_long((long)(p_statbuf->size)); 
                PyList_SetItem(py_list, 2, o);
                o = SWIG_From_long((long)(p_statbuf->secsize)); 
                PyList_SetItem(py_list, 3, o);
                o = SWIG_From_long((long)(p_statbuf->type)); 
                PyList_SetItem(py_list, 4, o);
                PyList_Append(resultobj, py_list);
            }
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_readdir(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    char *arg2 ;
    IsoStatList_t *result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OO:ifs_readdir",&obj0,&obj1)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    result = (IsoStatList_t *)ifs_readdir(arg1,(char const (*))arg2);
    
    {
        CdioList_t *p_entlist   = result;
        CdioListNode_t *p_entnode;
        
        if (result) {
            resultobj = PyList_New(0);
            _CDIO_LIST_FOREACH (p_entnode, p_entlist) {
                PyObject *py_list = PyList_New(5);
                iso9660_stat_t *p_statbuf = 
                (iso9660_stat_t *) _cdio_list_node_data (p_entnode);
                PyObject *o;
                o = PyString_FromString(p_statbuf->filename);
                PyList_SetItem(py_list, 0, o);
                o = SWIG_From_long((long)(p_statbuf->lsn)); 
                PyList_SetItem(py_list, 1, o);
                o = SWIG_From_long((long)(p_statbuf->size)); 
                PyList_SetItem(py_list, 2, o);
                o = SWIG_From_long((long)(p_statbuf->secsize)); 
                PyList_SetItem(py_list, 3, o);
                o = SWIG_From_long((long)(p_statbuf->type)); 
                PyList_SetItem(py_list, 4, o);
                PyList_Append(resultobj, py_list);
            }
        }
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_application_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_application_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)iso9660_get_application_id(arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_get_application_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ifs_get_application_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)ifs_get_application_id(arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_joliet_level(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    uint8_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_joliet_level",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (uint8_t)iso9660_ifs_get_joliet_level(arg1);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_dir_len(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_dir_t *arg1 = (iso9660_dir_t *) 0 ;
    uint8_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_dir_len",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_dir_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (uint8_t)iso9660_get_dir_len((iso9660_dir_t const *)arg1);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_iso9660_dir_to_name(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_dir_t *arg1 = (iso9660_dir_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:iso9660_dir_to_name",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_dir_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)iso9660_dir_to_name((iso9660_dir_t const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_preparer_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_preparer_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)iso9660_get_preparer_id((iso9660_pvd_t const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_get_preparer_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ifs_get_preparer_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)ifs_get_preparer_id(arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_publisher_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_publisher_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)iso9660_get_publisher_id((iso9660_pvd_t const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_get_publisher_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ifs_get_publisher_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)ifs_get_publisher_id(arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_pvd_type(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    uint8_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_pvd_type",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (uint8_t)iso9660_get_pvd_type((iso9660_pvd_t const *)arg1);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_pvd_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_pvd_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)iso9660_get_pvd_id((iso9660_pvd_t const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_pvd_space_size(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_pvd_space_size",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (int)iso9660_get_pvd_space_size((iso9660_pvd_t const *)arg1);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_pvd_block_size(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_pvd_block_size",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (int)iso9660_get_pvd_block_size((iso9660_pvd_t const *)arg1);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_pvd_version(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_pvd_version",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (int)iso9660_get_pvd_version((iso9660_pvd_t const *)arg1);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_system_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_system_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)iso9660_get_system_id((iso9660_pvd_t const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_get_system_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ifs_get_system_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)ifs_get_system_id(arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_root_lsn(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    lsn_t result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_root_lsn",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (lsn_t)iso9660_get_root_lsn((iso9660_pvd_t const *)arg1);
    
    {
        resultobj = SWIG_From_int((int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_volume_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_volume_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)iso9660_get_volume_id((iso9660_pvd_t const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_get_volume_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ifs_get_volume_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)ifs_get_volume_id(arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_get_volumeset_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_pvd_t *arg1 = (iso9660_pvd_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:get_volumeset_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_pvd_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)iso9660_get_volumeset_id((iso9660_pvd_t const *)arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_ifs_get_volumeset_id(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    char *result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:ifs_get_volumeset_id",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (char *)ifs_get_volumeset_id(arg1);
    
    resultobj = SWIG_FromCharPtr(result);
    free(result);
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_pathtable_init(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    void *arg1 = (void *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:pathtable_init",&obj0)) goto fail;
    {
        if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),0,SWIG_POINTER_EXCEPTION|0))== -1) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    iso9660_pathtable_init(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_pathtable_get_size(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    void *arg1 = (void *) 0 ;
    unsigned int result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:pathtable_get_size",&obj0)) goto fail;
    {
        if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),0,SWIG_POINTER_EXCEPTION|0))== -1) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    result = (unsigned int)iso9660_pathtable_get_size((void const *)arg1);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_pathtable_l_add_entry(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    void *arg1 = (void *) 0 ;
    char *arg2 ;
    unsigned int arg3 ;
    uint16_t arg4 ;
    uint16_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:pathtable_l_add_entry",&obj0,&obj1,&obj2,&obj3)) goto fail;
    {
        if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),0,SWIG_POINTER_EXCEPTION|0))== -1) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = (unsigned int)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (uint16_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    result = (uint16_t)iso9660_pathtable_l_add_entry(arg1,(char const (*))arg2,arg3,arg4);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_pathtable_m_add_entry(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    void *arg1 = (void *) 0 ;
    char *arg2 ;
    unsigned int arg3 ;
    uint16_t arg4 ;
    uint16_t result;
    PyObject * obj0 = 0 ;
    PyObject * obj1 = 0 ;
    PyObject * obj2 = 0 ;
    PyObject * obj3 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"OOOO:pathtable_m_add_entry",&obj0,&obj1,&obj2,&obj3)) goto fail;
    {
        if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),0,SWIG_POINTER_EXCEPTION|0))== -1) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    if (!SWIG_AsCharPtr(obj1, (char**)&arg2)) {
        SWIG_arg_fail(2);SWIG_fail;
    }
    {
        arg3 = (unsigned int)(SWIG_As_unsigned_SS_int(obj2)); 
        if (SWIG_arg_fail(3)) SWIG_fail;
    }
    {
        arg4 = (uint16_t)(SWIG_As_unsigned_SS_int(obj3)); 
        if (SWIG_arg_fail(4)) SWIG_fail;
    }
    result = (uint16_t)iso9660_pathtable_m_add_entry(arg1,(char const (*))arg2,arg3,arg4);
    
    {
        resultobj = SWIG_From_unsigned_SS_int((unsigned int)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_set_evd(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    void *arg1 = (void *) 0 ;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:set_evd",&obj0)) goto fail;
    {
        if ((SWIG_ConvertPtr(obj0,(void **)(&arg1),0,SWIG_POINTER_EXCEPTION|0))== -1) {
            SWIG_arg_fail(1);SWIG_fail;
        }
    }
    iso9660_set_evd(arg1);
    
    Py_INCREF(Py_None); resultobj = Py_None;
    return resultobj;
    fail:
    return NULL;
}


static PyObject *_wrap_is_xa(PyObject *self, PyObject *args) {
    PyObject *resultobj = NULL;
    iso9660_t *arg1 = (iso9660_t *) 0 ;
    bool result;
    PyObject * obj0 = 0 ;
    
    if(!PyArg_ParseTuple(args,(char *)"O:is_xa",&obj0)) goto fail;
    SWIG_Python_ConvertPtr(obj0, (void **)&arg1, SWIGTYPE_p_iso9660_t, SWIG_POINTER_EXCEPTION | 0);
    if (SWIG_arg_fail(1)) SWIG_fail;
    result = (bool)iso9660_ifs_is_xa((iso9660_t const *)arg1);
    
    {
        resultobj = SWIG_From_bool((bool)(result)); 
    }
    return resultobj;
    fail:
    return NULL;
}


static PyMethodDef SwigMethods[] = {
	 { (char *)"cdio_read_sectors", _wrap_cdio_read_sectors, METH_VARARGS, NULL},
	 { (char *)"cdio_eject_media_drive", _wrap_cdio_eject_media_drive, METH_VARARGS, NULL},
	 { (char *)"open_iso", _wrap_open_iso, METH_VARARGS, NULL},
	 { (char *)"open_ext", _wrap_open_ext, METH_VARARGS, NULL},
	 { (char *)"open_fuzzy", _wrap_open_fuzzy, METH_VARARGS, NULL},
	 { (char *)"iso9660_open_fuzzy_ext", _wrap_iso9660_open_fuzzy_ext, METH_VARARGS, NULL},
	 { (char *)"ifs_fuzzy_read_superblock", _wrap_ifs_fuzzy_read_superblock, METH_VARARGS, NULL},
	 { (char *)"close", _wrap_close, METH_VARARGS, NULL},
	 { (char *)"seek_read", _wrap_seek_read, METH_VARARGS, NULL},
	 { (char *)"fs_read_pvd", _wrap_fs_read_pvd, METH_VARARGS, NULL},
	 { (char *)"ifs_read_pvd", _wrap_ifs_read_pvd, METH_VARARGS, NULL},
	 { (char *)"fs_read_superblock", _wrap_fs_read_superblock, METH_VARARGS, NULL},
	 { (char *)"ifs_read_superblock", _wrap_ifs_read_superblock, METH_VARARGS, NULL},
	 { (char *)"set_dtime", _wrap_set_dtime, METH_VARARGS, NULL},
	 { (char *)"set_ltime", _wrap_set_ltime, METH_VARARGS, NULL},
	 { (char *)"get_dtime", _wrap_get_dtime, METH_VARARGS, NULL},
	 { (char *)"get_ltime", _wrap_get_ltime, METH_VARARGS, NULL},
	 { (char *)"is_dchar", _wrap_is_dchar, METH_VARARGS, NULL},
	 { (char *)"is_achar", _wrap_is_achar, METH_VARARGS, NULL},
	 { (char *)"name_translate", _wrap_name_translate, METH_VARARGS, NULL},
	 { (char *)"name_translate_ext", _wrap_name_translate_ext, METH_VARARGS, NULL},
	 { (char *)"strncpy_pad", _wrap_strncpy_pad, METH_VARARGS, NULL},
	 { (char *)"dirname_valid_p", _wrap_dirname_valid_p, METH_VARARGS, NULL},
	 { (char *)"pathname_isofy", _wrap_pathname_isofy, METH_VARARGS, NULL},
	 { (char *)"pathname_valid_p", _wrap_pathname_valid_p, METH_VARARGS, NULL},
	 { (char *)"fs_stat", _wrap_fs_stat, METH_VARARGS, NULL},
	 { (char *)"fs_stat_translate", _wrap_fs_stat_translate, METH_VARARGS, NULL},
	 { (char *)"ifs_stat", _wrap_ifs_stat, METH_VARARGS, NULL},
	 { (char *)"ifs_stat_translate", _wrap_ifs_stat_translate, METH_VARARGS, NULL},
	 { (char *)"fs_readdir", _wrap_fs_readdir, METH_VARARGS, NULL},
	 { (char *)"ifs_readdir", _wrap_ifs_readdir, METH_VARARGS, NULL},
	 { (char *)"get_application_id", _wrap_get_application_id, METH_VARARGS, NULL},
	 { (char *)"ifs_get_application_id", _wrap_ifs_get_application_id, METH_VARARGS, NULL},
	 { (char *)"get_joliet_level", _wrap_get_joliet_level, METH_VARARGS, NULL},
	 { (char *)"get_dir_len", _wrap_get_dir_len, METH_VARARGS, NULL},
	 { (char *)"iso9660_dir_to_name", _wrap_iso9660_dir_to_name, METH_VARARGS, NULL},
	 { (char *)"get_preparer_id", _wrap_get_preparer_id, METH_VARARGS, NULL},
	 { (char *)"ifs_get_preparer_id", _wrap_ifs_get_preparer_id, METH_VARARGS, NULL},
	 { (char *)"get_publisher_id", _wrap_get_publisher_id, METH_VARARGS, NULL},
	 { (char *)"ifs_get_publisher_id", _wrap_ifs_get_publisher_id, METH_VARARGS, NULL},
	 { (char *)"get_pvd_type", _wrap_get_pvd_type, METH_VARARGS, NULL},
	 { (char *)"get_pvd_id", _wrap_get_pvd_id, METH_VARARGS, NULL},
	 { (char *)"get_pvd_space_size", _wrap_get_pvd_space_size, METH_VARARGS, NULL},
	 { (char *)"get_pvd_block_size", _wrap_get_pvd_block_size, METH_VARARGS, NULL},
	 { (char *)"get_pvd_version", _wrap_get_pvd_version, METH_VARARGS, NULL},
	 { (char *)"get_system_id", _wrap_get_system_id, METH_VARARGS, NULL},
	 { (char *)"ifs_get_system_id", _wrap_ifs_get_system_id, METH_VARARGS, NULL},
	 { (char *)"get_root_lsn", _wrap_get_root_lsn, METH_VARARGS, NULL},
	 { (char *)"get_volume_id", _wrap_get_volume_id, METH_VARARGS, NULL},
	 { (char *)"ifs_get_volume_id", _wrap_ifs_get_volume_id, METH_VARARGS, NULL},
	 { (char *)"get_volumeset_id", _wrap_get_volumeset_id, METH_VARARGS, NULL},
	 { (char *)"ifs_get_volumeset_id", _wrap_ifs_get_volumeset_id, METH_VARARGS, NULL},
	 { (char *)"pathtable_init", _wrap_pathtable_init, METH_VARARGS, NULL},
	 { (char *)"pathtable_get_size", _wrap_pathtable_get_size, METH_VARARGS, NULL},
	 { (char *)"pathtable_l_add_entry", _wrap_pathtable_l_add_entry, METH_VARARGS, NULL},
	 { (char *)"pathtable_m_add_entry", _wrap_pathtable_m_add_entry, METH_VARARGS, NULL},
	 { (char *)"set_evd", _wrap_set_evd, METH_VARARGS, NULL},
	 { (char *)"is_xa", _wrap_is_xa, METH_VARARGS, NULL},
	 { NULL, NULL, 0, NULL }
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_CdIo_t = {"_p_CdIo_t", "CdIo_t *", 0, 0, 0};
static swig_type_info _swigt__p_CdioList_t = {"_p_CdioList_t", "CdioList_t *|IsoStatList_t *", 0, 0, 0};
static swig_type_info _swigt__p_cdio_read_mode_t = {"_p_cdio_read_mode_t", "enum cdio_read_mode_t *|cdio_read_mode_t *", 0, 0, 0};
static swig_type_info _swigt__p_char = {"_p_char", "char *", 0, 0, 0};
static swig_type_info _swigt__p_int = {"_p_int", "int *|lba_t *", 0, 0, 0};
static swig_type_info _swigt__p_iso9660_dir_t = {"_p_iso9660_dir_t", "iso9660_dir_t *", 0, 0, 0};
static swig_type_info _swigt__p_iso9660_dtime_t = {"_p_iso9660_dtime_t", "iso9660_dtime_t *", 0, 0, 0};
static swig_type_info _swigt__p_iso9660_ltime_t = {"_p_iso9660_ltime_t", "iso9660_ltime_t *", 0, 0, 0};
static swig_type_info _swigt__p_iso9660_pvd_t = {"_p_iso9660_pvd_t", "iso9660_pvd_t *", 0, 0, 0};
static swig_type_info _swigt__p_iso9660_stat_t = {"_p_iso9660_stat_t", "iso9660_stat_t *|IsoStat_t *", 0, 0, 0};
static swig_type_info _swigt__p_iso9660_t = {"_p_iso9660_t", "iso9660_t *", 0, 0, 0};
static swig_type_info _swigt__p_long = {"_p_long", "long *|ssize_t *", 0, 0, 0};
static swig_type_info _swigt__p_unsigned_int = {"_p_unsigned_int", "unsigned int *|uint16_t *", 0, 0, 0};
static swig_type_info _swigt__ptrdiff_t = {"_ptrdiff_t", "ptrdiff_t", 0, 0, 0};
static swig_type_info _swigt__size_t = {"_size_t", "size_t", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_CdIo_t,
  &_swigt__p_CdioList_t,
  &_swigt__p_cdio_read_mode_t,
  &_swigt__p_char,
  &_swigt__p_int,
  &_swigt__p_iso9660_dir_t,
  &_swigt__p_iso9660_dtime_t,
  &_swigt__p_iso9660_ltime_t,
  &_swigt__p_iso9660_pvd_t,
  &_swigt__p_iso9660_stat_t,
  &_swigt__p_iso9660_t,
  &_swigt__p_long,
  &_swigt__p_unsigned_int,
  &_swigt__ptrdiff_t,
  &_swigt__size_t,
};

static swig_cast_info _swigc__p_CdIo_t[] = {  {&_swigt__p_CdIo_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_CdioList_t[] = {  {&_swigt__p_CdioList_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_cdio_read_mode_t[] = {  {&_swigt__p_cdio_read_mode_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_char[] = {  {&_swigt__p_char, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_int[] = {  {&_swigt__p_int, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_iso9660_dir_t[] = {  {&_swigt__p_iso9660_dir_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_iso9660_dtime_t[] = {  {&_swigt__p_iso9660_dtime_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_iso9660_ltime_t[] = {  {&_swigt__p_iso9660_ltime_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_iso9660_pvd_t[] = {  {&_swigt__p_iso9660_pvd_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_iso9660_stat_t[] = {  {&_swigt__p_iso9660_stat_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_iso9660_t[] = {  {&_swigt__p_iso9660_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_long[] = {  {&_swigt__p_long, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_unsigned_int[] = {  {&_swigt__p_unsigned_int, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__ptrdiff_t[] = {  {&_swigt__ptrdiff_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__size_t[] = {  {&_swigt__size_t, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_CdIo_t,
  _swigc__p_CdioList_t,
  _swigc__p_cdio_read_mode_t,
  _swigc__p_char,
  _swigc__p_int,
  _swigc__p_iso9660_dir_t,
  _swigc__p_iso9660_dtime_t,
  _swigc__p_iso9660_ltime_t,
  _swigc__p_iso9660_pvd_t,
  _swigc__p_iso9660_stat_t,
  _swigc__p_iso9660_t,
  _swigc__p_long,
  _swigc__p_unsigned_int,
  _swigc__ptrdiff_t,
  _swigc__size_t,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_const_info swig_const_table[] = {
{0, 0, 0, 0.0, 0, 0}};

#ifdef __cplusplus
}
#endif
/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif
    
    SWIGRUNTIME void
    SWIG_InitializeModule(void *clientdata) {
        swig_type_info *type, *ret;
        swig_cast_info *cast;
        size_t i;
        swig_module_info *module_head;
        static int init_run = 0;
        
        clientdata = clientdata;
        
        if (init_run) return;
        init_run = 1;
        
        /* Initialize the swig_module */
        swig_module.type_initial = swig_type_initial;
        swig_module.cast_initial = swig_cast_initial;
        
        /* Try and load any already created modules */
        module_head = SWIG_GetModule(clientdata);
        if (module_head) {
            swig_module.next = module_head->next;
            module_head->next = &swig_module;
        } else {
            /* This is the first module loaded */
            swig_module.next = &swig_module;
            SWIG_SetModule(clientdata, &swig_module);
        }
        
        /* Now work on filling in swig_module.types */
        for (i = 0; i < swig_module.size; ++i) {
            type = 0;
            
            /* if there is another module already loaded */
            if (swig_module.next != &swig_module) {
                type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
            }
            if (type) {
                /* Overwrite clientdata field */
                if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
            } else {
                type = swig_module.type_initial[i];
            }
            
            /* Insert casting types */
            cast = swig_module.cast_initial[i];
            while (cast->type) {
                /* Don't need to add information already in the list */
                ret = 0;
                if (swig_module.next != &swig_module) {
                    ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
                }
                if (ret && type == swig_module.type_initial[i]) {
                    cast->type = ret;
                    ret = 0;
                }
                
                if (!ret) {
                    if (type->cast) {
                        type->cast->prev = cast;
                        cast->next = type->cast;
                    }
                    type->cast = cast;
                }
                
                cast++;
            }
            
            /* Set entry in modules->types array equal to the type */
            swig_module.types[i] = type;
        }
        swig_module.types[i] = 0;
    }
    
    /* This function will propagate the clientdata field of type to
    * any new swig_type_info structures that have been added into the list
    * of equivalent types.  It is like calling
    * SWIG_TypeClientData(type, clientdata) a second time.
    */
    SWIGRUNTIME void
    SWIG_PropagateClientData(void) {
        size_t i;
        swig_cast_info *equiv;
        static int init_run = 0;
        
        if (init_run) return;
        init_run = 1;
        
        for (i = 0; i < swig_module.size; i++) {
            if (swig_module.types[i]->clientdata) {
                equiv = swig_module.types[i]->cast;
                while (equiv) {
                    if (!equiv->converter) {
                        if (equiv->type && !equiv->type->clientdata)
                        SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
                    }
                    equiv = equiv->next;
                }
            }
        }
    }
    
#ifdef __cplusplus
}
#endif



#ifdef __cplusplus
extern "C" {
#endif
    
    /* Python-specific SWIG API */
#define SWIG_newvarlink()                             SWIG_Python_newvarlink()
#define SWIG_addvarlink(p, name, get_attr, set_attr)  SWIG_Python_addvarlink(p, name, get_attr, set_attr)
#define SWIG_InstallConstants(d, constants)           SWIG_Python_InstallConstants(d, constants)
    
    /* -----------------------------------------------------------------------------
     * global variable support code.
     * ----------------------------------------------------------------------------- */
    
    typedef struct swig_globalvar {
        char       *name;                  /* Name of global variable */
        PyObject *(*get_attr)(void);       /* Return the current value */
        int       (*set_attr)(PyObject *); /* Set the value */
        struct swig_globalvar *next;
    } swig_globalvar;
    
    typedef struct swig_varlinkobject {
        PyObject_HEAD
        swig_globalvar *vars;
    } swig_varlinkobject;
    
    SWIGINTERN PyObject *
    swig_varlink_repr(swig_varlinkobject *v) {
        v = v;
        return PyString_FromString("<Swig global variables>");
    }
    
    SWIGINTERN int
    swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags) {
        swig_globalvar  *var;
        flags = flags;
        fprintf(fp,"Swig global variables { ");
        for (var = v->vars; var; var=var->next) {
            fprintf(fp,"%s", var->name);
            if (var->next) fprintf(fp,", ");
        }
        fprintf(fp," }\n");
        return 0;
    }
    
    SWIGINTERN PyObject *
    swig_varlink_getattr(swig_varlinkobject *v, char *n) {
        swig_globalvar *var = v->vars;
        while (var) {
            if (strcmp(var->name,n) == 0) {
                return (*var->get_attr)();
            }
            var = var->next;
        }
        PyErr_SetString(PyExc_NameError,"Unknown C global variable");
        return NULL;
    }
    
    SWIGINTERN int
    swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p) {
        swig_globalvar *var = v->vars;
        while (var) {
            if (strcmp(var->name,n) == 0) {
                return (*var->set_attr)(p);
            }
            var = var->next;
        }
        PyErr_SetString(PyExc_NameError,"Unknown C global variable");
        return 1;
    }
    
    SWIGINTERN PyTypeObject*
    swig_varlink_type(void) {
        static char varlink__doc__[] = "Swig var link object";
        static PyTypeObject varlink_type
#if !defined(__cplusplus)
        ;
        static int type_init = 0;  
        if (!type_init) {
            PyTypeObject tmp
#endif
            = {
                PyObject_HEAD_INIT(&PyType_Type)
                0,                                  /* Number of items in variable part (ob_size) */
                (char *)"swigvarlink",              /* Type name (tp_name) */
                sizeof(swig_varlinkobject),         /* Basic size (tp_basicsize) */
                0,                                  /* Itemsize (tp_itemsize) */
                0,                                  /* Deallocator (tp_dealloc) */ 
                (printfunc) swig_varlink_print,     /* Print (tp_print) */
                (getattrfunc) swig_varlink_getattr, /* get attr (tp_getattr) */
                (setattrfunc) swig_varlink_setattr, /* Set attr (tp_setattr) */
                0,                                  /* tp_compare */
                (reprfunc) swig_varlink_repr,       /* tp_repr */
                0,                                  /* tp_as_number */
                0,                                  /* tp_as_sequence */
                0,                                  /* tp_as_mapping */
                0,                                  /* tp_hash */
                0,                                  /* tp_call */
                0,                                  /* tp_str */
                0,                                  /* tp_getattro */
                0,                                  /* tp_setattro */
                0,                                  /* tp_as_buffer */
                0,                                  /* tp_flags */
                varlink__doc__,                     /* tp_doc */
#if PY_VERSION_HEX >= 0x02000000
                0,                                  /* tp_traverse */
                0,                                  /* tp_clear */
#endif
#if PY_VERSION_HEX >= 0x02010000
                0,                                  /* tp_richcompare */
                0,                                  /* tp_weaklistoffset */
#endif
#if PY_VERSION_HEX >= 0x02020000
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* tp_iter -> tp_weaklist */
#endif
#if PY_VERSION_HEX >= 0x02030000
                0,                                  /* tp_del */
#endif
#ifdef COUNT_ALLOCS
                0,0,0,0                             /* tp_alloc -> tp_next */
#endif
            };
#if !defined(__cplusplus)
            varlink_type = tmp;
            type_init = 1;
        }
#endif
        return &varlink_type;
    }
    
    /* Create a variable linking object for use later */
    SWIGINTERN PyObject *
    SWIG_Python_newvarlink(void) {
        swig_varlinkobject *result = PyObject_NEW(swig_varlinkobject, swig_varlink_type());
        if (result) {
            result->vars = 0;
        }
        return ((PyObject*) result);
    }
    
    SWIGINTERN void 
    SWIG_Python_addvarlink(PyObject *p, char *name, PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p)) {
        swig_varlinkobject *v = (swig_varlinkobject *) p;
        swig_globalvar *gv = (swig_globalvar *) malloc(sizeof(swig_globalvar));
        if (gv) {
            size_t size = strlen(name)+1;
            gv->name = (char *)malloc(size);
            if (gv->name) {
                strncpy(gv->name,name,size);
                gv->get_attr = get_attr;
                gv->set_attr = set_attr;
                gv->next = v->vars;
            }
        }
        v->vars = gv;
    }
    
    /* -----------------------------------------------------------------------------
     * constants/methods manipulation
     * ----------------------------------------------------------------------------- */
    
    /* Install Constants */
    SWIGINTERN void
    SWIG_Python_InstallConstants(PyObject *d, swig_const_info constants[]) {
        PyObject *obj = 0;
        size_t i;
        for (i = 0; constants[i].type; ++i) {
            switch(constants[i].type) {
                case SWIG_PY_INT:
                obj = PyInt_FromLong(constants[i].lvalue);
                break;
                case SWIG_PY_FLOAT:
                obj = PyFloat_FromDouble(constants[i].dvalue);
                break;
                case SWIG_PY_STRING:
                if (constants[i].pvalue) {
                    obj = PyString_FromString((char *) constants[i].pvalue);
                } else {
                    Py_INCREF(Py_None);
                    obj = Py_None;
                }
                break;
                case SWIG_PY_POINTER:
                obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
                break;
                case SWIG_PY_BINARY:
                obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype));
                break;
                default:
                obj = 0;
                break;
            }
            if (obj) {
                PyDict_SetItemString(d,constants[i].name,obj);
                Py_DECREF(obj);
            }
        }
    }
    
    /* -----------------------------------------------------------------------------*/
    /* Fix SwigMethods to carry the callback ptrs when needed */
    /* -----------------------------------------------------------------------------*/
    
    SWIGINTERN void
    SWIG_Python_FixMethods(PyMethodDef *methods,
    swig_const_info *const_table,
    swig_type_info **types,
    swig_type_info **types_initial) {
        size_t i;
        for (i = 0; methods[i].ml_name; ++i) {
            char *c = methods[i].ml_doc;
            if (c && (c = strstr(c, "swig_ptr: "))) {
                int j;
                swig_const_info *ci = 0;
                char *name = c + 10;
                for (j = 0; const_table[j].type; ++j) {
                    if (strncmp(const_table[j].name, name, 
                    strlen(const_table[j].name)) == 0) {
                        ci = &(const_table[j]);
                        break;
                    }
                }
                if (ci) {
                    size_t shift = (ci->ptype) - types;
                    swig_type_info *ty = types_initial[shift];
                    size_t ldoc = (c - methods[i].ml_doc);
                    size_t lptr = strlen(ty->name)+2*sizeof(void*)+2;
                    char *ndoc = (char*)malloc(ldoc + lptr + 10);
                    if (ndoc) {
                        char *buff = ndoc;
                        void *ptr = (ci->type == SWIG_PY_POINTER) ? ci->pvalue : 0;
                        if (ptr) {
                            strncpy(buff, methods[i].ml_doc, ldoc);
                            buff += ldoc;
                            strncpy(buff, "swig_ptr: ", 10);
                            buff += 10;
                            SWIG_PackVoidPtr(buff, ptr, ty->name, lptr);
                            methods[i].ml_doc = ndoc;
                        }
                    }
                }
            }
        }
    }
    
    /* -----------------------------------------------------------------------------*
     *  Initialize type list
     * -----------------------------------------------------------------------------*/
    
#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------*
 *  Partial Init method
 * -----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT void SWIG_init(void) {
    static PyObject *SWIG_globals = 0; 
    PyObject *m, *d;
    if (!SWIG_globals) SWIG_globals = SWIG_newvarlink();
    
    /* Fix SwigMethods to carry the callback ptrs when needed */
    SWIG_Python_FixMethods(SwigMethods, swig_const_table, swig_types, swig_type_initial);
    
    m = Py_InitModule((char *) SWIG_name, SwigMethods);
    d = PyModule_GetDict(m);
    
    SWIG_InitializeModule(0);
    SWIG_InstallConstants(d,swig_const_table);
    
    {
        PyDict_SetItemString(d,"VERSION_NUM", SWIG_From_long((long)(LIBCDIO_VERSION_NUM))); 
    }
    {
        PyDict_SetItemString(d,"INVALID_LBA", SWIG_From_long((long)(CDIO_INVALID_LBA))); 
    }
    {
        PyDict_SetItemString(d,"INVALID_LSN", SWIG_From_long((long)(CDIO_INVALID_LSN))); 
    }
    {
        PyDict_SetItemString(d,"CD_FRAMESIZE", SWIG_From_long((long)(CDIO_CD_FRAMESIZE))); 
    }
    {
        PyDict_SetItemString(d,"CD_FRAMESIZE_RAW", SWIG_From_long((long)(CDIO_CD_FRAMESIZE_RAW))); 
    }
    {
        PyDict_SetItemString(d,"ISO_BLOCKSIZE", SWIG_From_long((long)(CDIO_CD_FRAMESIZE))); 
    }
    {
        PyDict_SetItemString(d,"M2F2_SECTOR_SIZE", SWIG_From_long((long)(M2F2_SECTOR_SIZE))); 
    }
    {
        PyDict_SetItemString(d,"M2RAW_SECTOR_SIZE", SWIG_From_long((long)(M2RAW_SECTOR_SIZE))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_AUDIO", SWIG_From_int((int)(CDIO_READ_MODE_AUDIO))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_M1F1", SWIG_From_int((int)(CDIO_READ_MODE_M1F1))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_M1F2", SWIG_From_int((int)(CDIO_READ_MODE_M1F2))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_M2F1", SWIG_From_int((int)(CDIO_READ_MODE_M2F1))); 
    }
    {
        PyDict_SetItemString(d,"CDIO_READ_MODE_M2F2", SWIG_From_int((int)(CDIO_READ_MODE_M2F2))); 
    }
    {
        PyDict_SetItemString(d,"PVD_SECTOR", SWIG_From_long((long)(ISO_PVD_SECTOR))); 
    }
    {
        PyDict_SetItemString(d,"EVD_SECTOR", SWIG_From_long((long)(ISO_EVD_SECTOR))); 
    }
    {
        PyDict_SetItemString(d,"LEN_ISONAME", SWIG_From_long((long)(LEN_ISONAME))); 
    }
    {
        PyDict_SetItemString(d,"MAX_SYSTEM_ID", SWIG_From_long((long)(ISO_MAX_SYSTEM_ID))); 
    }
    {
        PyDict_SetItemString(d,"MAX_ISONAME", SWIG_From_long((long)(MAX_ISONAME))); 
    }
    {
        PyDict_SetItemString(d,"MAX_PREPARER_ID", SWIG_From_long((long)(ISO_MAX_PREPARER_ID))); 
    }
    {
        PyDict_SetItemString(d,"MAX_ISOPATHNAME", SWIG_From_long((long)(MAX_ISOPATHNAME))); 
    }
    {
        PyDict_SetItemString(d,"FILE", SWIG_From_long((long)(ISO_FILE))); 
    }
    {
        PyDict_SetItemString(d,"EXISTENCE", SWIG_From_long((long)(ISO_EXISTENCE))); 
    }
    {
        PyDict_SetItemString(d,"DIRECTORY", SWIG_From_long((long)(ISO_DIRECTORY))); 
    }
    {
        PyDict_SetItemString(d,"ASSOCIATED", SWIG_From_long((long)(ISO_ASSOCIATED))); 
    }
    {
        PyDict_SetItemString(d,"RECORD", SWIG_From_long((long)(ISO_RECORD))); 
    }
    {
        PyDict_SetItemString(d,"PROTECTION", SWIG_From_long((long)(ISO_PROTECTION))); 
    }
    {
        PyDict_SetItemString(d,"DRESERVED1", SWIG_From_long((long)(ISO_DRESERVED1))); 
    }
    {
        PyDict_SetItemString(d,"DRESERVED2", SWIG_From_long((long)(ISO_DRESERVED2))); 
    }
    {
        PyDict_SetItemString(d,"MULTIEXTENT", SWIG_From_long((long)(ISO_MULTIEXTENT))); 
    }
    {
        PyDict_SetItemString(d,"VD_BOOT_RECORD", SWIG_From_long((long)(ISO_VD_BOOT_RECORD))); 
    }
    {
        PyDict_SetItemString(d,"VD_PRIMARY", SWIG_From_long((long)(ISO_VD_PRIMARY))); 
    }
    {
        PyDict_SetItemString(d,"VD_SUPPLEMENTARY", SWIG_From_long((long)(ISO_VD_SUPPLEMENTARY))); 
    }
    {
        PyDict_SetItemString(d,"VD_PARITION", SWIG_From_long((long)(ISO_VD_PARITION))); 
    }
    {
        PyDict_SetItemString(d,"VD_END", SWIG_From_long((long)(ISO_VD_END))); 
    }
    {
        PyDict_SetItemString(d,"MAX_PUBLISHER_ID", SWIG_From_long((long)(ISO_MAX_PUBLISHER_ID))); 
    }
    {
        PyDict_SetItemString(d,"MAX_APPLICATION_ID", SWIG_From_long((long)(ISO_MAX_APPLICATION_ID))); 
    }
    {
        PyDict_SetItemString(d,"MAX_VOLUME_ID", SWIG_From_long((long)(ISO_MAX_VOLUME_ID))); 
    }
    {
        PyDict_SetItemString(d,"MAX_VOLUMESET_ID", SWIG_From_long((long)(ISO_MAX_VOLUMESET_ID))); 
    }
    {
        PyDict_SetItemString(d,"STANDARD_ID", SWIG_From_long((long)(ISO_STANDARD_ID))); 
    }
    {
        PyDict_SetItemString(d,"NOCHECK", SWIG_From_long((long)(ISO9660_NOCHECK))); 
    }
    {
        PyDict_SetItemString(d,"SEVEN_BIT", SWIG_From_long((long)(ISO9660_7BIT))); 
    }
    {
        PyDict_SetItemString(d,"ACHARS", SWIG_From_long((long)(ISO9660_ACHARS))); 
    }
    {
        PyDict_SetItemString(d,"DCHARS", SWIG_From_long((long)(ISO9660_DCHARS))); 
    }
    {
        PyDict_SetItemString(d,"EXTENSION_JOLIET_LEVEL1", SWIG_From_long((long)(ISO_EXTENSION_JOLIET_LEVEL1))); 
    }
    {
        PyDict_SetItemString(d,"EXTENSION_JOLIET_LEVEL2", SWIG_From_long((long)(ISO_EXTENSION_JOLIET_LEVEL2))); 
    }
    {
        PyDict_SetItemString(d,"EXTENSION_JOLIET_LEVEL3", SWIG_From_long((long)(ISO_EXTENSION_JOLIET_LEVEL3))); 
    }
    {
        PyDict_SetItemString(d,"EXTENSION_ROCK_RIDGE", SWIG_From_long((long)(ISO_EXTENSION_ROCK_RIDGE))); 
    }
    {
        PyDict_SetItemString(d,"EXTENSION_HIGH_SIERRA", SWIG_From_long((long)(ISO_EXTENSION_HIGH_SIERRA))); 
    }
    {
        PyDict_SetItemString(d,"EXTENSION_ALL", SWIG_From_long((long)(ISO_EXTENSION_ALL))); 
    }
    {
        PyDict_SetItemString(d,"EXTENSION_NONE", SWIG_From_long((long)(ISO_EXTENSION_NONE))); 
    }
    {
        PyDict_SetItemString(d,"EXTENSION_JOLIET", SWIG_From_long((long)(ISO_EXTENSION_JOLIET))); 
    }
}

