
;;; d-lisp.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-lisp.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Lisp mode code
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun d-elisp-stuff ()
  "My own Emacs Lisp stuff.  Currently remaps ^J and ^M and customizes
dynamic abbrevs."
  (set (make-local-variable 'dabbrev-case-fold-search) nil)
  (set (make-local-variable 'dabbrev-case-replace) nil)
  (modify-syntax-entry ?- "w")
  ;;; NOTE: temporary workaround for d-latexize.el
  (modify-syntax-entry ?{ "(")
  (modify-syntax-entry ?} ")")
  (setq case-fold-search nil)
  (define-key emacs-lisp-mode-map "\C-j" 'd-indent-new-comment-line)
  (define-key emacs-lisp-mode-map "\C-m" 'd-indent-new-comment-line)
  (if emacs-dialect--xemacs-p
      (define-key emacs-lisp-mode-map [return] 'd-indent-new-comment-line))
  (define-key emacs-lisp-mode-map "\C-f" nil)
  (define-key emacs-lisp-mode-map "\C-t" 'find-lisp-definition)
  (progn
    (define-key emacs-lisp-mode-map [(control prior)] 'd-control-prior)
    (define-key emacs-lisp-mode-map [(control next)]  'd-control-next)
    (define-key emacs-lisp-mode-map [(shift prior)] 'backward-paragraph)
    (define-key emacs-lisp-mode-map [(shift next)]  'forward-paragraph)
    )
  (setq truncate-lines nil)
  )
(add-hook 'emacs-lisp-mode-hook 'd-elisp-stuff)
(add-hook 'emacs-lisp-mode-hook 'turn-on-font-lock)

;;(defadvice error (before fix-bug activate)
;;  (setq debug-on-error global-debug-on-error))

;;(error "smeg")

(provide 'd-lisp)
;;; d-lisp.el ends here
