/* LocaleInformation_mt.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_mt extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "MTL";

  private static final String currenciesDisplayNameValues = "Lira Maltija";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "MTL";

  private static final String currenciesSymbolValues = "Lm";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Fra",
    "Mar",
    "Apr",
    "Mej",
    "\u0120un",
    "Lul",
    "Awi",
    "Set",
    "Ott",
    "Nov",
    "Di\u010b",
    null,
  };

  private static final String[] months = {
    "Jannar",
    "Frar",
    "Marzu",
    "April",
    "Mejju",
    "\u0120unju",
    "Lulju",
    "Awissu",
    "Settembru",
    "Ottubru",
    "Novembru",
    "Di\u010bembru",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u0126ad",
    "Tne",
    "Tli",
    "Erb",
    "\u0126am",
    "\u0120im",
    "Sib",
  };

  private static final String[] weekdays = {
    null,
    "Il-\u0126add",
    "It-Tnejn",
    "It-Tlieta",
    "L-Erbg\u0127a",
    "Il-\u0126amis",
    "Il-\u0120img\u0127a",
    "Is-Sibt",
  };

  private static final String[] eras = {
    "QK",
    "WK",
  };

  private static final String[][] zoneStrings =
  {
    { "CET", "\u0126in \u010aentrali Ewropew", "CEST", "\u0126in \u010aentrali Ewropew tas-Sajf",  "Europe/Malta" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Timor tal-Lvant|Tokelaw|Ta\u0121ikistan|Tajlandja|Togo|Territorji Fran\u010bi\u017ci ta' Nofsinhar|Gujana|\u010aad|Turks and Caicos Islands|Ginea-Bissaw|Gwam|Gwatemala|South Georgia and the South Sandwich Islands|Gre\u010bja|Ginea Ekwatorjali|Gwadelupe|Swa\u017ciland|Sirja|Gineja|Gambja|Grinlandja|El Salvador|Sao Tome and Principe|Gibraltar|Gana|Surinam|Gujana Fran\u010bi\u017ca|Serbja|\u0120or\u0121ja|Somalja|Grenada|Senegal|San Marino|Ingilterra|Sierra Leone|Gabon|Slovakkja|Svalbard and Jan Mayen|Slovenja|Saint Helena|Singapor|\u017bvezja|Sudan|Seychelles|Solomon Islands|G\u0127arabja Sawdita|Franza|G\u017cejjer Faroe|Mikronesja|Rwanda|Falkland Islands|Russja|Fi\u0121i|Finlandja|Rumanija|R\u00e9union|Etijopja|Spanja|Eritreja|Sahara tal-Punent|E\u0121ittu|Estonja|Ekwador|Al\u0121erija|Qatar|Republikka Domenikana|Paragwaj|Dominika|Palau|Danimarka|\u0120ibuti|Portugall|Palestinian Territory|Puerto Rico|\u0120ermanja|Pitcairn|Saint Pierre and Miquelon|Polonja|Pakistan|Filippini|Papwa-Ginea \u0120dida|Polinesja Fran\u010bi\u017ca|Repubblika \u010aeka|Peru|\u010aipru|Christmas Island|Kape Verde|Panama|Kuba|Kosta Rika|Kolumbja|\u010aina|Kamerun|\u010aili|Cook Islands|Kosta ta' l-Avorju|Svizzera|Kongo|Repubblika Afrikana \u010aentrali|Democratic Republic of the Congo|Cocos (Keeling) Islands|Oman|Kanada|Beli\u017ce|Bjelorussja|Botswana|Bouvet Island|Butan|Ba\u0127amas|Bra\u017cil|New Zealand|Bolivja|Brunej|Bermuda|Niue|Benin|Burundi|Ba\u0127rajn|Nauru|Bulgarija|Burkina Faso|Nepal|Bel\u0121ju|Norve\u0121ja|Bangladexx|Barbados|\u017bimbabwe|Olanda|Bo\u017cnija \u0126er\u017cegovina|Nikaragwa|Ni\u0121erja|Norfolk Island|A\u017cerbaj\u0121an|Ni\u0121er|New Caledonia|Aruba|\u017bambja|Namibja|Awstralja|Awstrija|Samoa Amerikana|Ar\u0121entina|Antarctica|Mo\u017cambik|Angola|Malasja|Antilles Olandi\u017ci|Messiku|Armenja|Malawi|Albanija|Maldives|Afrika t'Isfel|Mawrizju|Malta|Angwilla|Montserrat|Mawritanja|Antigua and Barbuda|Martinik|Afganistan|G\u017cejjer Marjana ta' Fuq|Emirati G\u0127arab Maqg\u0127uda|Macao S.A.R., China|Andorra|Mongolja|Mjanmar|Mali|Ma\u010bedonja|Jugoslavja|Majotte|G\u017cejjer ta' Marshall|Madagaskar|Maldova|Monako|Marokk|Jemen|Libja|Latvja|Lussemburgu|Litwanja|Lesoto|Liberja|Sri Lanka|Liechtenstein|Saint Lucia|Libanu|Laos|Ka\u017cakstan|Cayman Islands|Kuwajt|Koreja t'Isfel|Koreja ta' Fuq|Saint Kitts and Nevis|Komoros|Kiribati|Samoa|Kambodja|Kirgistan|Kenja|Wallis and Futuna|\u0120appun|\u0120ordan|\u0120amajka|Vanwatu|Vjetnam|U.S. Virgin Islands|British Virgin Islands|Venezwela|Saint Vincent and the Grenadines|Vatikan|Italja|Islanda|Iran|Iraq|U\u017cbekistan|British Indian Ocean Territory|Urugwaj|Indja|I\u017crael|Stati Uniti|Irlanda|Indone\u017cja|United States Minor Outlying Islands|Uganda|Ukraina|Ungerija|\u0126aiti|Kroazja|Tan\u017canija|\u0126onduras|Heard Island and McDonald Islands|Tajwan|Tuvalu|\u0126ong Kong S.A.R., \u010aina|Trinidad u Tobago|Turkija|Tonga|Tune\u017c|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tlh|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|nwc|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|root|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "Gwi\u010bin|Akkadjen|Ekajuk|I\u0121o|\u0126o\u017ca|Sumerjan|Susu|Lingwi O\u0127ra|Lo\u017ci|Tonga (Njasa)|Ponpejan|Minangkabaw|Sukuma|Wolof|Mongo|Kutenaj|Mikmek|Walloon|Kumiku|\u017bapotek|Kuxtiku (O\u0127ra)|Lojban|Dogri|Volapuk|Lingwi Otomjani|Vjetnami\u017c|Vai|Rarotongani|Venda|Rapanwi|Ra\u0121astani|Tork (Imperu Ottoman)|N\u017cima|Neapolitan|U\u017cbek|Ugaritiku|Tamaxek|Indjan tal-Amerika ta' Fuq (O\u0127ra)|Na\u0127watil|Urdu|Fanti|Ukranjan|E\u0121izzjan (Antik)|Wigur|Fang|Nilo-Sa\u0127aram|Irlandi\u017c, Medjevali (900-1200)|Baltiku (O\u0127ra)|Njoro|Basa|Nyankole|Njamwe\u017ci|\u0126mong|Balini\u017c|Osa\u0121jan|Balu\u010bi|Ta\u0127itjan|Lingwi Bamileke|Twi|Serer|Tlingit|Klingon|Tatar|Tsonga|Banda|Tork|Tongan (G\u017cejjer ta' Tonga)|Zwana|Tagalog|Turkmeni|Tigrinja|Tajlandi\u017c|Kurusk|Ta\u0121ik|Blin|Telugu|Kru|Kashubian|Tamil|Tokelau|Efik|Swa\u0127ili|Svedi\u017c|Sundani\u017c|Karachay-Balkar|Soto, t'Isfel|Swati|Serb|Albani\u017c|Mende|Kreoli u Pi\u0121ini (O\u0127ra)|Somali|Afri\u0127ili|Xona|Samojan|Slav|Grieg, Antik (to 1453)|Slovakk|\u0120erbo|Sin\u0127ali\u017c|Serbo-Kroat|Crimean Turkish; Crimean Tatar|Afro-Asjatiku (O\u0127ra)|Sango|Sami ta' Fuq|Sindi|Udmurt|Sardinjan|Sanskrit|Kinjarwanda|Classical Newari|Russu|Mandar|Rumen|Rundi|Reto-Romanz|Moksha|Tiv|Adyghe|\u017buni|Kpelle|Ke\u010bwa|Tigre|Songaj|Creoles and pidgins, Portuguese-based (Other)|Sogdien|Adangme|Kosrejan|\u0126ittit|Kreoli u Pi\u0121ini, Bba\u017cat fuq il-Fran\u010bi\u017c (O\u0127ra)|Kreoli u Pi\u0121ini, Bba\u017cat fuq l-Ingli\u017c (O\u0127ra)|\u0126ima\u010bali|Konkani|Hiligaynon|Gotiku|Gorontalo|Gondi|Dinka|Lingwi Nubjani|Portugi\u017c|Paxtun|Frijuljan|Feni\u010bju|\u0120ermaniku, Antik Pulit (ca. 750-1050)|Soninke|Koptiku|Japese|Akoli|Jao|Filippin (O\u0127ra)|Pollakk|A\u010bini\u017c|Pali|Pun\u0121abi|Bugini\u017c|Iban|Skolt Sami|Burjat|Masaj|Inari Sami|Ossettiku|Awstronesjan|Orija|Mandingwan|Lule Sami|Sami languages (Other)|Makasar|Oromo (Afan)|Majtili|O\u0121ibwa|Maga\u0127i|Maduri\u017c|Southern Sami|Provenzal (wara 1500)|Soto, ta' Fuq|Batak|Erzya|Dogrib|\u010ai\u010bewa; Njan\u0121a|Majan|Nava\u0127o|Kimbundu|Ndebele, t'Isfel|\u0120ermaniku, Medjevali Pulit (ca. 1050-1500)|Norve\u0121i\u017c|Ninorsk Norve\u0121i\u017c|Olandi\u017c|G\u0127erq|Ndonga|Slavic (Other)|Nepali\u017c|Ndebele, ta' Fuq|Lingwi \u010aamiki|Tetum|Bokmahal Norve\u0121i\u017c|Nawuru|Tereno|Timne|Burmi\u017c|Le\u017cgjan|Malti|Persjan Antik (ca. 600-400 Q.K.)|Malajan|Marati|Fran\u010bi\u017c, Antik (842-ca. 1400)|Moldavjan|Fran\u010bi\u017c, Medjevali (ca. 1400-1600)|Mongoljan|Lhudi-G\u0127arbi|Malajalam|Ma\u010bedonjan|Maori|Marxall|Malaga\u017ci|Marwari|Braj|Slav|Latvjan (Lettix)|Luba-Katanga|Delawerjan|Litwanjan|Lao|Lingaljan|Limburgish|Ewondo|Ganda|Let\u017cburgi\u017c|Latin|Lhudi-Persjan|Votik|Sino-Tibetjani (O\u0127ra)|Kirgi\u017c|Korniku|Komi|Kurdi\u017c|Lingwi Suwjani|Kaxmiri|Kanuri|Awad\u0127i|Korejan|Kannada|Kmer|Kalallisut|Ka\u017cak|\u017bingaru|Kuanyama|Sidamo|Kikuju|Kongo|Skandinav, Antik|\u0120or\u0121jan|Kriek|Romanz (O\u0127ra)|Nogai|Lingwi tal-Munda|Lingwi Diversi|\u0120avani\u017c|Gilbertjan|\u017bande|Xan|Fon|Kalmyk|Lingwi Awstraljani|Kotani\u017c|\u0120appuni\u017c|Kojsan|Palawjan|Xajenn|Tai (O\u0127ra)|Inukitut|Papjamento|Taljan|Lingwa tas-Sinjali|I\u017clandi\u017c|Kasi|\u010aerokij|Pampamga|Pa\u0127lavi|\u010aipewjan|Ido|\u010aostaw|\u0120argon ta\u010b-\u010ainuk|Mari|Tuvinjan|Bantu|Pangasinjan|Inupjak|\u010aukese|Sichuan Yi|\u0126awajjan|Lamba|Igbo|\u010aagataj|Irlandi\u017c, Antik (sa l-900)|Papwan (O\u0127ra)|Interlingue|Indone\u017cjan|Landa|Dajak|\u010aib\u010ba|Interlingua|Ladino|\u0126erero|\u0126ajda|Dargwa|Armenjan|Lingwi Atabaskani|Ungeri\u017c|Haitian|Dakota|Kroat|\u0126iri Motu|\u0126indi|Djula|Ebrajk|Asturian|\u0126awsa|Lingwi Sorbjani|Manks|Gu\u0121arati|Semitiku|Selkup|Lingwi Irogwjani|Gwarani|Gallegjan|Arawak|Geez|Artifi\u010bjali (O\u0127ra)|Galliku Sko\u010b\u010bi\u017c|Iranjan|Irlandi\u017c|Arapa\u0127o|Arawkanjan|Fri\u017cjan|Siksika|\u0120ermaniku (O\u0127ra)|Lingwi Jupi\u010bi|Aramajk|Fran\u010bi\u017c|Fawri\u017c|Keltiku (O\u0127ra)|Fi\u0121i|Finlandi\u017c|Fula\u0127|Tuvalu|Sibwano|Persjan|Bask|Sko\u010b\u010bi\u017c|Estonjan|Spanjol|Esperanto|Ingli\u017c|Grieg|Altajk (O\u0127ra)|Nijuwejan|Tupi languages|Ewe|Tumbuka|Mossi|D\u017congka|Ni\u0121erjan - Kordofanjan|Luxaj|Finno - Ugrijan|Dive\u0127i|Nijas|Mo\u0127ak|Luwa|Lunda|Lingwi Apa\u010bi|Luwisinu\u017c|\u0126upa|Bini|\u0120ermani\u017c|Luba-Luluwa|Bikol|Waxo|Indeterminat|Waraj|Dani\u017c|Olandi\u017c, Medjevali (ca. 1050-1350)|Walamo|Lingwi Manobo|Lingwi Wakaxani|Santali|Welx|Saska|Kabardian|\u010auvax|Slaviku tal-Knisja|Manipuri|\u010aek|Samritan|Krij|Salixan|Dwala|Korsiku|Indjan tal-Amerika t'Isfel (O\u0127ra)|Man\u010burjan|Jakut|Kawi|Ingush|Gbaja|Sandawe|\u010aamorro|Indo-Ewropew|Bojpuri|Ingli\u017c, Medjevali (1100-1500)|Karen|Indjan (O\u0127ra)|\u010ae\u010ben|Gajo|Katalan|Umbundu|Sirjan|Kamba|Zimxjan|Ingli\u017c, Antik (ca.450-1100)|Ka\u010bin|Kawkasu (O\u0127ra)|Kabuljan|Kara-Kalpak|Bosnijan|Karib|Brenton|Tibetjan|Bengali|Bambara|Ga|Amerika \u010aentrali (O\u0127ra)|Bislama|Bi\u0127ari|Bulgaru|Belarussu|Kaddo|Baxkir|\u017bulu|\u017benaga|Provenzal, Antik (sa l-1500)|Upper Sorbian|A\u017cerbaj\u0121ani|Ajmara|Avarik|Assamese|Lower Sorbian|G\u0127arbi|Iloko|Elamit|\u010aini\u017c|Aragonese|Lingwi Prakriti|Am\u0127ariku|Newari|Akan|\u017bwang|Afrikans|Avestan|Abka\u017cjan|Afar|Joruba|Lingwi Algonqwinjani|Aleut|Mon-Kmer (O\u0127ra)|Jiddix|Dravidjan (O\u0127ra)|Beber|\u0120ermani\u017c Komuni; Sassonu Komuni|Bemba|Beja|Tok Pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd/MM/yyyy" },
    { "mediumDateFormat", "dd MMM yyyy" },
    { "longDateFormat", "d 'ta''' MMMM yyyy" },
    { "fullDateFormat", "EEEE, d 'ta''' MMMM yyyy" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
