/* LocaleInformation_et.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_et extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "EEK";

  private static final String currenciesDisplayNameValues = "EEK";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "EEK";

  private static final String currenciesSymbolValues = "kr";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jaan",
    "veebr",
    "m\u00e4rts",
    "apr",
    "mai",
    "juuni",
    "juuli",
    "aug",
    "sept",
    "okt",
    "nov",
    "dets",
    null,
  };

  private static final String[] months = {
    "jaanuar",
    "veebruar",
    "m\u00e4rts",
    "aprill",
    "mai",
    "juuni",
    "juuli",
    "august",
    "september",
    "oktoober",
    "november",
    "detsember",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "P",
    "E",
    "T",
    "K",
    "N",
    "R",
    "L",
  };

  private static final String[] weekdays = {
    null,
    "p\u00fchap\u00e4ev",
    "esmasp\u00e4ev",
    "teisip\u00e4ev",
    "kolmap\u00e4ev",
    "neljap\u00e4ev",
    "reede",
    "laup\u00e4ev",
  };

  private static final String[] eras = {
    "e.m.a.",
    "m.a.j.",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Ida-Timor|Tokelau|Tad\u012aikistan|Tai|Togo|Prantsuse L\u00f5unaalad|Guyana|Tiaad|Turks ja Caicos|Guinea-Bissau|Guam|Guatemala|L\u00f5una-Georgia ja L\u00f5una-Sandwichi saared|Kreeka|Ekvatoriaal-Guinea|Guadeloupe|Svaasimaa|S\u00fc\u00fcria|Guinea|Gambia|Gr\u00f6\u00f6nimaa|El Salvador|Sao Tom\u00e9 ja Principe|Gibraltar|Ghana|Suriname|Prantsuse Guajaana|Serbia|Gruusia|Somaalia|Grenada|Senegal|San Marino|\u00dchendkuningriik|Sierra Leone|Gabon|Slovakkia|Svalbard ja Jan Mayen|Sloveenia|Saint Helena|Singapur|Rootsi|Sudaan|Seiiellid|Saalomoni Saared|Saudi Araabia|Prantsusmaa|F\u00e4\u00e4ri saared|Mikroneesia Liiduriigid|Rwanda|Falklandi saared|Venemaa|Fid\u012ai|Soome|Rumeenia|R\u00e9union|Etioopia|Hispaania|Eritrea|L\u00e4\u00e4ne-Sahara|Egiptus|Eesti|Ecuador|Al\u012aeeria|Katar|Dominikaani Vabariik|Paraguay|Dominica|Belau|Taani|Djibouti|Portugal|Palestiina Omavalitsus|Puerto Rico|Saksamaa|Pitcairn|Saint-Pierre ja Miquelon|Poola|Pakistan|Filipiinid|Paapua Uus-Guinea|Prantsuse Pol\u00fcneesia|Tiehhi Vabariik|Peruu|K\u00fcpros|J\u00f5ulusaar|Cabo Verde|Panama|Kuuba|Costa Rica|Colombia|Hiina|Kamerun|Tiiili|Cooki saared|Cote d\u2019Ivoire|\u0128veits|Kongo|Kesk-Aafrika Vabariik|Kongo DV|Kookossaared|Omaan|Kanada|Belize|Valgevene|Botswana|Bouvet\u2019 saar|Bhutan|Bahama saared|Brasiilia|Uus-Meremaa|Boliivia|Brunei|Bermuda|Niue|Benin|Burundi|Bahrein|Nauru|Bulgaaria|Burkina Faso|Nepal|Belgia|Norra|Bangladesh|Barbados|Zimbabwe|Holland|Bosnia ja Hertsegoviina|Nicaragua|Nigeeria|Norfolk|Aserbaid\u012aaan|Niger|Uus-Kaledoonia|Aruba|Sambia|Namiibia|Austraalia|Austria|Ameerika Samoa|Argentina|Antarktika|Mosambiik|Angola|Malaisia|Hollandi Antillid|Mehhiko|Armeenia|Malawi|Albaania|Maldiivid|L\u00f5una-Aafrika Vabariik|Mauritius|Malta|Anguilla|Montserrat|Mauritaania|Antigua ja Barbuda|Martinique|Afganistan|P\u00f5hja-Mariaanid|Araabia \u00dchendemiraadid|Aomeni Hiina erihalduspiirkond|Andorra|Mongoolia|Myanmar|Mali|Makedoonia Vabariik|Jugoslaavia|Mayotte|Marshalli Saared|Madagaskar|Moldova|Monaco|Maroko|Jeemen|Liib\u00fca|L\u00e4ti|Luksemburg|Leedu|Lesotho|Libeeria|Sri Lanka|Liechtenstein|Saint Lucia|Liibanon|Laose DRV|Kasahstan|Kaimani saared|Kuveit|L\u00f5una-Korea|P\u00f5hja-Korea|Saint Kitts ja Nevis|Komoorid|Kiribati|Samoa|Kambod\u012aa|K\u00f5rg\u00f5zstan|Kenya|Wallis ja Futuna|Jaapan|Jordaania|Jamaica|Vanuatu|Vietnam|USA Neitsisaared|Briti Neitsisaared|Venezuela|Saint Vincent ja Grenadiinid|P\u00fcha Tool (Vatikan)|Itaalia|Island|Iraan|Iraak|Usbekistan|Briti India ookeani ala|Uruguay|India|Iisrael|Ameerika \u00dchendriigid|Iirimaa|Indoneesia|\u00dchendriikide hajasaared|Uganda|Ukraina|Ungari|Haiti|Horvaatia|Tansaania|Honduras|Heard ja McDonald|Taiwan|Tuvalu|Hongkongi erihalduspiirkond|Trinidad ja Tobago|T\u00fcrgi|Tonga|Tuneesia|T\u00fcrkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ja|en|tr|ko|no|el|nl|bg|lv|he|cs|it|lt|fr|zh|ru|ro|fi|ar|sv|pt|pl|sl|sk|de|hu|et|es|hr|da";

  private static final String languagesValues = "Jaapani|Inglise|T\u00fcrgi|Korea|Norra|Kreeka|Hollandi|Bulgaaria|L\u00e4ti|Heebrea|Tiehhi|Itaalia|Leedu|Prantsuse|Hiina|Vene|Rumeenia|Soome|Araabia|Rootsi|Portugali|Poola|Sloveeni|Slovaki|Saksa|Ungari|Eesti|Hispaania|Horvaadi|Taani";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd.MM.yy" },
    { "mediumDateFormat", "dd.MM.yyyy" },
    { "longDateFormat", "d MMMM yyyy" },
    { "fullDateFormat", "EEEE, d, MMMM yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H:mm:ss z" },
    { "fullTimeFormat", "H:mm:ss z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
