
#include "sysincludes.h"

/* commands with one filename and one "other" argument */
#define ALIAS(name, alias, type) \
int alias(char *filename, type var) \
{ \
	return name(filename, var); \
}

ALIAS(access, real_access, int)
ALIAS(chmod, real_chmod, int)

ALIAS(stat, real_stat, struct stat*)
ALIAS(lstat, real_lstat, struct stat*)

int utimes();
ALIAS(utimes, real_utimes, struct timeval *)

#undef ALIAS


/* commands with two filenames */
#define ALIAS(name, alias) \
int alias(const char *filename, const char *filename2) \
{ \
	return name(filename, filename2); \
}

ALIAS(link, real_link);
ALIAS(symlink, real_symlink);
ALIAS(rename, real_rename);

#undef ALIAS



int real_chown(const char *filename, int o, int g)
{
	return chown(filename, o, g);
}

int open();
int real_open(const char *pathname, int flags, mode_t mode)
{
	return open(pathname, flags, mode);
}

int real_unlink(const char *pathname)
{
	return open(pathname);
}

int real_readlink(const char *path, char *buf, size_t bufsiz)
{
	return readlink(path, buf, bufsiz);
}
