/*
 * chmod.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#include "sysincludes.h"

int chmod(__const char *file_name, mode_t mode)
{
  int st;
  char newname[MAXPATHLEN + MAXEXTLEN + 1];

  st = real_chmod(file_name, mode);

  if ( st >= 0 || errno != ENOENT )
    return st;


  zlib_initialise();
  if ( zlib_mode & CM_DISAB )
    return st;
  if ( (zlib_getfiletype(file_name,-1) & PM_READ_MASK) == PM_LEAVE_COMPR)
    return st;
  
  if ( zlib_mode & CM_VERBOSE )
    fprintf(stderr,"Chowning %s\n",file_name);
  
  strncpy(newname,file_name,1024);
  strcat(newname,zlib_ext);
  
  errno = 0;
  return real_chmod(newname, mode);
}
