/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif /* HAVE_MALLOC_H */
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>

#include <read_file.h>
#include <salloc.h>

char* read_file(char* path, int* size)
{
  char* content;
  if((content = read_file_1(path, size)) == 0) {
    exit(1);
  }
  return content;
}

char* read_file_1(char* path, int* size)
{
  struct stat statbuf;
  int fd;
  char* buffer;
  int r;

  if((fd = open(path, O_RDONLY)) < 0) {
    fprintf(stderr, "could not open %s\n", path);
    perror("");
    return 0;
  }
  if(fstat(fd, &statbuf) < 0) {
    fprintf(stderr, "could not stat %s\n", path);
    perror("");
    return 0;
  }

  buffer = smalloc(statbuf.st_size + 1);

  if((r = read(fd, buffer, statbuf.st_size)) != statbuf.st_size) {
    fprintf(stderr, "%s only read %d bytes ", path, r);
    perror("");
    free(buffer);
    return 0;
  }
  buffer[statbuf.st_size] = '\0';
  if(size) *size = statbuf.st_size;
  close(fd);
  return buffer;
}
