/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>

#include <string.h>
#include <stdlib.h>
#include <getopt.h>
#include <getopttools.h>

#define OPTION_FIELD_LENGTH 40

static int verbose = 0;

void getopt_merge(struct option to[], struct option from[])
{
  int from_i;
  int to_i;
  int flags;
  int max;
  for(to_i = 0; to[to_i].name; to_i++)
    ;
  flags = to[to_i].val;
  max = to[to_i].has_arg;
  if(verbose) fprintf(stderr, "getopt_merge: flags = 0x%x, max = %d\n", flags, max);

  if(to_i >= max) {
    fprintf(stderr, "getopt_merge: too many options in to (> %d)\n", max);
    exit(1);
  }
  for(from_i = 0; from[from_i].name; from_i++)
    ;
  if(verbose) fprintf(stderr, "getopt_merge: val = 0x%x\n", from[from_i].val);
  if((from[from_i].val & flags) == 0) {
    if(verbose) fprintf(stderr, "getopt_merge: accept\n");
    flags |= from[from_i].val;
    for(from_i = 0; to_i < max && from[from_i].name;)
      to[to_i++] = from[from_i++];
    if(to_i >= max) {
      fprintf(stderr, "getopt_merge: too many options in to (> %d)\n", max);
      exit(1);
    }
  }
  memset((char*)&to[to_i], '\0', sizeof(struct option));
  to[to_i].val = flags;  
  if(verbose) fprintf(stderr, "getopt_merge: %s %d\n", from[0].name, max);
  to[to_i].has_arg = max;
}

void getopt_help_merge(struct option_help to[], struct option_help from[])
{
  int from_i=0;
  int to_i=0;
  int max;
  char *max_str;

  while (strncmp("0",to[to_i].name,strlen(to[to_i].name)) != 0)
    to_i++;
  max_str = strdup(to[to_i].description);
  max = atoi(max_str);

  if (verbose) fprintf(stderr, "getopt_help_merge: max = %d\n", max);

  if(to_i >= max) {
    fprintf(stderr, "getopt_help_merge: too many options in to (> %d)\n", max);
    exit(1);
  }
  while (strncmp("0",from[from_i].name,strlen(from[from_i].name)) != 0)
    from_i++;
  /*
   * in order to fix memory leak, store the last entry of _to_ into _from_
   * permits to avoid use of malloc
   * by benoit orihuela (benoit.orihuela@IDEALX.com), 2000/08/03
   */
  from[from_i] = to[to_i];
  if(strcmp(from[from_i].name,"0") == 0) {
    if (verbose) fprintf(stderr, "getopt_help_merge: accept\n");
    for(from_i = 0; to_i < max ;)
      {
	if (strcmp(from[from_i].name,"0") == 0)
	  {
	    /* 
	     * retrieve value stored in _from_
	     * see above
	     */
	    to[to_i] = from[from_i];
	    break;
	  }
	to[to_i++] = from[from_i++];
      }
    if(to_i >= max) {
      fprintf(stderr, "getopt_help_merge: too many options in to (> %d)\n", max);
      exit(1);
    }
  }

  if (verbose) fprintf(stderr, "getopt_help_merge: %s %d\n", from[0].name, max);
  free(max_str);
}

void getopt_dump(struct option_help options_help[])
{
  int i=0;
  int option_space;
  /*
   * buf is used to count needed space after displaying option name
   * => align options descriptions
   */
  char *buf = (char *) malloc((size_t) OPTION_FIELD_LENGTH);
  while (strncmp("0",options_help[i].name,strlen(options_help[i].name)) != 0)
    {
      option_space = OPTION_FIELD_LENGTH - strlen(options_help[i].name);
      /*
       * fixed memory leak
       * use realloc instead of malloc and initialize last byte of buf
       * by benoit orihuela (benoit.orihuela@IDEALX.com)
       */
      buf = (char *) realloc((void*) buf, (size_t) option_space+1);
      memset(buf,' ',option_space);
      buf[option_space] = '\0';
      printf("-%s", options_help[i].name);
      printf("%s", buf);
      printf("%s\n", options_help[i].description);
      i++;
    }
  free(buf);
}








