/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#include <stdio.h>
#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif
#if HAVE_STRING_H
# include <string.h>
# include <memory.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif


#include <find.h>
#include <file_isdir.h>
#include <salloc.h>

#define MAX_FIND_DEPTH 30
static int find_depth = 0;

void find(char* dir, find_callback function)
{
  DIR* dirp;
  struct dirent* dirent;
  char* path;
  int dir_length = strlen(dir);

  find_depth++;
  if(find_depth > MAX_FIND_DEPTH) {
    fprintf(stderr, "directory nesting too deep, stop here %s\n", dir);
    find_depth--;
    return;
  }
  if((dirp = opendir(dir)) == 0) {
    fprintf(stderr, "cannot opendir %s\n", dir);
    find_depth--;
    perror("");
    return;
  }
  path = (char*)smalloc(dir_length + 1 + MAXNAMLEN + 1);
  while((dirent = readdir(dirp))) {
    if(!strcmp(dirent->d_name, ".") ||
       !strcmp(dirent->d_name, ".."))
      continue;
    strcpy(path, dir);
    strcat(path, "/");
    strcat(path, dirent->d_name);
    if(file_isdir(path)) {
      find(path, function);
    } else {
      (*function)(path, dir, dirent->d_name);
    }
  }
  closedir(dirp);
  free(path);
  find_depth--;
}

