dnl
dnl Local autoconf definitions. Try to follow the guidelines of the autoconf
dnl macro repository so that integration in the repository is easy.
dnl To submit a macro to the repository send the macro (one macro per mail)
dnl to Peter Simons <simons@computer.org>.
dnl The repository itself is at http://www.gnu.org/software/ac-archive/
dnl

dnl @synopsis AC_MANDATORY_HEADERS(HEADER-FILE, [INCLUDES])
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([AC_MANDATORY_HEADERS],
[AC_CHECK_HEADERS([$1],,AC_MSG_ERROR(header $1 not found check config.log),[$2])])

dnl @synopsis AC_MANDATORY_LIB(LIBRARY, FUNCTION, [OTHER-LIBRARIES])
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([AC_MANDATORY_LIB],
[AC_CHECK_LIB([$1],[$2],,AC_MSG_ERROR(library $1 not found check config.log),[$3])])

dnl @synopsis AC_COMPILE_WARNINGS
dnl
dnl Set the maximum warning verbosity according to compiler used.
dnl Currently supports g++ and gcc.
dnl This macro must be put after AC_PROG_CC and AC_PROG_CXX in
dnl configure.in
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([AC_COMPILE_WARNINGS],
[AC_MSG_CHECKING(maximum warning verbosity option)
if test -n "$CXX"
then
  if test "$GXX" = "yes"
  then
    ac_compile_warnings_opt='-Wall'
  fi
  CXXFLAGS="$CXXFLAGS $ac_compile_warnings_opt"
  ac_compile_warnings_msg="$ac_compile_warnings_opt for C++"
fi

if test -n "$CC"
then
  if test "$GCC" = "yes"
  then
    ac_compile_warnings_opt='-Wall'
  fi
  CFLAGS="$CFLAGS $ac_compile_warnings_opt"
  ac_compile_warnings_msg="$ac_compile_warnings_msg $ac_compile_warnings_opt for C"
fi
AC_MSG_RESULT($ac_compile_warnings_msg)
unset ac_compile_warnings_msg
unset ac_compile_warnings_opt
])

dnl @synopsis CHECK_ZLIB()
dnl
dnl This macro searches for an installed zlib library. If nothing
dnl was specified when calling configure, it searches first in /usr/local
dnl and then in /usr. If the --with-zlib=DIR is specified, it will try
dnl to find it in DIR/include/zlib.h and DIR/lib/libz.a. If --without-zlib
dnl is specified, the library is not searched at all.
dnl
dnl If either the header file (zlib.h) or the library (libz) is not
dnl found, the configuration exits on error.
dnl
dnl The macro defines the symbol HAVE_LIBZ if the library is found. You should
dnl use autoheader to include a definition for this symbol in a config.h.in
dnl file. Sample usage in a C/C++ source is as follows:
dnl
dnl   #ifdef HAVE_LIBZ
dnl   #include <zlib.h>
dnl   #endif /* HAVE_LIBZ */
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([CHECK_ZLIB],
#
# Handle user hints
#
[AC_MSG_CHECKING(if zlib is wanted)
AC_ARG_WITH(zlib,
[  --with-zlib=DIR root directory path of zlib installation [defaults to
		    /usr/local or /usr if not found in /usr/local]
  --without-zlib to disable zlib usage completely],
[if test "$withval" != no ; then
  AC_MSG_RESULT(yes)
  ZLIB_HOME="$withval"
else
  AC_MSG_RESULT(no)
fi], [
AC_MSG_RESULT(yes)
ZLIB_HOME=/usr/local
if test ! -f "${ZLIB_HOME}/include/zlib.h"
then
	ZLIB_HOME=/usr
fi
])

#
# Locate zlib, if wanted
#
if test -n "${ZLIB_HOME}"
then
	#
	# Adding /usr/lib or /usr/include to the flags/libs may
	# hurt if using a compiler not installed in the standard 
	# place.
	#
        if test "${ZLIB_HOME}" != "/usr"
	then
		LDFLAGS="$LDFLAGS -L${ZLIB_HOME}/lib"
		CPPFLAGS="$CPPFLAGS -I${ZLIB_HOME}/include"
	fi
        AC_LANG_PUSH(C)
	AC_MANDATORY_LIB(z, inflateEnd)
        AC_MANDATORY_HEADERS(zlib.h)
        AC_LANG_POP
fi

])

dnl @synopsis CHECK_MIFLUZ()
dnl
dnl This macro searches for an installed mifluz library. If nothing
dnl was specified when calling configure, it searches first in /usr/local
dnl and then in /usr. If the --with-mifluz=DIR is specified, it will try
dnl to find it in DIR/include/mifluz.h and DIR/lib/libmifluz.a. 
dnl If --without-mifluz is specified, the library is not searched at all.
dnl
dnl If either the header file (mifluz.h) or the library (libmifluz) is not
dnl found, the configuration exits on error.
dnl
dnl The macro defines the symbol HAVE_LIBMIFLUZ if the library is found. 
dnl You should use autoheader to include a definition for this symbol in 
dnl a config.h.in file. Sample usage in a C/C++ source is as follows:
dnl
dnl   #ifdef HAVE_LIBMIFLUZ
dnl   #include <mifluz.h>
dnl   #endif /* HAVE_LIBMIFLUZ */
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([CHECK_MIFLUZ],
#
# Handle user hints
#
[
AC_MSG_CHECKING(if mifluz is wanted)
AC_ARG_WITH(mifluz,
[  --with-mifluz[=DIR] root directory path of mifluz installation [defaults to
		    /usr/local or /usr if not found in /usr/local]
  --without-mifluz to disable mifluz usage completely],
[if test "$withval" != no ; then
  AC_MSG_RESULT(yes)
  if test "$withval" = "yes"
  then
    MIFLUZ_HOME=/usr/local
    if test ! -f "${MIFLUZ_HOME}/include/mifluz.h"
    then
      MIFLUZ_HOME=/usr
    fi
  else
    MIFLUZ_HOME="$withval"
  fi
else
  AC_MSG_RESULT(no)
fi], [
AC_MSG_RESULT(no)
])

#
# Locate mifluz, if wanted
#
if test -n "${MIFLUZ_HOME}"
then
  CHECK_ZLIB()
  #
  # Adding /usr/lib or /usr/include to the flags/libs may
  # hurt if using a compiler not installed in the standard 
  # place.
  #
  if test "${MIFLUZ_HOME}" != "/usr"
  then
    LDFLAGS="-L${MIFLUZ_HOME}/lib $LDFLAGS"
    CPPFLAGS="-I${MIFLUZ_HOME}/include $CPPFLAGS"
  fi

  AC_LANG_PUSH(C++)
  AC_MANDATORY_LIB(mifluz, main)

  AC_MANDATORY_HEADERS(mifluz.h)
  AC_LANG_POP

  AC_DEFINE(MIFLUZ)
  MIFLUZ=yes
  AC_SUBST(MIFLUZ)
fi
])

dnl @synopsis CHECK_MYSQL()
dnl
dnl This macro searches for an installed mysql library. If nothing
dnl was specified when calling configure, it searches first in /usr/local
dnl and then in /usr. If the --with-mysql=DIR is specified, it will try
dnl to find it in DIR/include/mysql/mysql.h and DIR/lib/libmysqlclient.a. 
dnl
dnl In the event where mysql is installed in two different trees (it is
dnl the case when --prefix is distinct from --exec-prefix), one can use
dnl the --with-mysql-include=DIR and --with-mysql-lib=DIR options to 
dnl specify the exact location of the headers and library directories.
dnl
dnl Examples:
dnl ./configure --with-mysql=$HOME/local
dnl ./configure --with-mysql-lib=$HOME/local/sparc/lib/mysql \
dnl             --with-mysql-include=$HOME/local/include/mysql
dnl
dnl If either the header file (mysql.h) or the library (libmysqlclient) is not
dnl found, the configuration exits on error.
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([CHECK_MYSQL],[

AC_ARG_WITH(mysql,
[  --with-mysql=DIR root directory path of mysql installation [defaults to
		    /usr/local or /usr if not found in /usr/local]
],
[if test "$withval" != no ; then
  if test "$withval" != yes 
  then
	MYSQL_HOME="$withval"
  fi
else
  AC_MSG_ERROR("do not use --without-mysql because MySQL is mandatory")
fi])

if test -z "${MYSQL_HOME}"
then
	MYSQL_HOME=/usr/local
	if test ! -f "${MYSQL_HOME}/include/mysql/mysql.h"
	then
		MYSQL_HOME=/usr
	fi
fi

AC_ARG_WITH(mysql-include,
[  --with-mysql-include=DIR directory path of mysql include files [defaults to
		    /usr/local/include/mysql or /usr/include/mysql]
],
[if test "$withval" != no ; then
  MYSQL_INCLUDE="$withval"
else
  AC_MSG_ERROR("do not use --without-mysql-include because MySQL is mandatory")
fi], [

if test -z "$MYSQL_INCLUDE"
then
	MYSQL_INCLUDE=${MYSQL_HOME}/include/mysql
fi
])

if test ! -f "${MYSQL_INCLUDE}/mysql.h"
then
	AC_MSG_ERROR(${MYSQL_INCLUDE}/mysql.h is not an existing file, use --with-mysql or --with-mysql-include options)
fi

AC_ARG_WITH(mysql-lib,
[  --with-mysql-lib=DIR directory path of mysql libraries [defaults to
		    /usr/local/lib/mysql or /usr/lib/mysql]
],
[if test "$withval" != no ; then
  MYSQL_LIB="$withval"
else
  AC_MSG_ERROR("do not use --without-mysql-lib because MySQL is mandatory")
fi], [

if test -z "$MYSQL_LIB"
then
	MYSQL_LIB=${MYSQL_HOME}/lib/mysql
fi
])

if test ! -f "${MYSQL_LIB}/libmysqlclient.a"
then
	if test -f "${MYSQL_HOME}/lib/libmysqlclient.a"
	then
		MYSQL_LIB=${MYSQL_HOME}/lib
	else
		AC_MSG_ERROR(${MYSQL_LIB}/libmysqlclient.a is not an existing file, use --with-mysql or --with-mysql-lib options)
	fi
fi

AC_MSG_CHECKING(mysql installation directory)

AC_MSG_RESULT(lib = $MYSQL_LIB include = $MYSQL_INCLUDE)

LDFLAGS="-L${MYSQL_LIB} $LDFLAGS"
CPPFLAGS="-I${MYSQL_INCLUDE} $CPPFLAGS"

AC_LANG_PUSH(C)
AC_MANDATORY_LIB(mysqlclient, mysql_store_result)
AC_MANDATORY_HEADERS(mysql.h)
AC_LANG_POP
])

dnl @synopsis CHECK_URI()
dnl
dnl This macro searches for an installed uri library. If nothing
dnl was specified when calling configure, it searches first in /usr/local
dnl and then in /usr. If the --with-uri=DIR is specified, it will try
dnl to find it in DIR/include/uri.h and DIR/lib/liburi.a. 
dnl
dnl If either the header file (uri.h) or the library (liburi) is not
dnl found, the configuration exits on error.
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([CHECK_URI],[

AC_ARG_WITH(uri,
[  --with-uri=DIR root directory path of uri installation [defaults to
		    /usr/local or /usr if not found in /usr/local]
],
[if test "$withval" != no ; then
  if test "$withval" != yes
  then
    URI_HOME="$withval"
  fi
else
  AC_MSG_ERROR(do not use --without-uri uri is mandatory)
fi])

if test -z "${URI_HOME}"
then
  URI_HOME=/usr/local
  if test ! -f "${URI_HOME}/include/uri.h"
  then
	URI_HOME=/usr
  fi
fi

AC_MSG_CHECKING(uri installation directory)
AC_MSG_RESULT($URI_HOME)

#
# Adding /usr/lib or /usr/include to the flags/libs may
# hurt if using a compiler not installed in the standard 
# place.
#
if test "${URI_HOME}" != "/usr"
then
  LDFLAGS="-L${URI_HOME}/lib $LDFLAGS"
  CPPFLAGS="-I${URI_HOME}/include $CPPFLAGS"
fi

AC_LANG_PUSH(C)
AC_MANDATORY_LIB(uri, uri_uri)
AC_MANDATORY_HEADERS(uri.h)
AC_LANG_POP
])

dnl @synopsis CHECK_LANGREC()
dnl
dnl This macro searches for an installed langrec library. If nothing
dnl was specified when calling configure, it searches first in /usr/local
dnl and then in /usr. If the --with-langrec=DIR is specified, it will try
dnl to find it in DIR/include/decodage_usr.h, DIR/lib/libdecodage.a and
dnl DIR/lib/libdicoMySQL.a. 
dnl If --without-langrec is specified, the library is not searched at all.
dnl
dnl If either the header file (decodage_usr.h) or the libraries
dnl (libdecodage.a or libdicoMySQL) are not found, the configuration exits
dnl on error.
dnl
dnl The macro defines the symbol LANGREC if the library is found. 
dnl You should use autoheader to include a definition for this symbol in 
dnl a config.h.in file. Sample usage in a C/C++ source is as follows:
dnl
dnl   #ifdef LANGREC
dnl   #include <decodage_usr.h>
dnl   #endif /* LANGREC */
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([CHECK_LANGREC],
[
AC_MSG_CHECKING(if langrec is wanted)
AC_ARG_WITH(langrec,
[  --with-langrec[=DIR] root directory path of langrec installation [defaults to
		    /usr/local or /usr if not found in /usr/local]
  --without-langrec to disable langrec usage completely],
[if test "$withval" != no ; then
  AC_MSG_RESULT(yes)
  if test "$withval" = "yes"
  then
    LANGREC_HOME=/usr/local
    if test ! -f "${LANGREC_HOME}/include/decodage_usr.h"
    then
      LANGREC_HOME=/usr
    fi
  else
    LANGREC_HOME="$withval"
  fi
else
  AC_MSG_RESULT(no)
fi], [
AC_MSG_RESULT(no)
])

# Locate langrec, if wanted
#
if test -n "${LANGREC_HOME}"
then
  #
  # Adding /usr/lib or /usr/include to the flags/libs may
  # hurt if using a compiler not installed in the standard 
  # place.
  #
  if test "${LANGREC_HOME}" != "/usr"
  then
    LDFLAGS="$LDFLAGS -L${LANGREC_HOME}/lib"
    CPPFLAGS="$CPPFLAGS -I${LANGREC_HOME}/include"
  fi

  AC_MANDATORY_LIB(dicoMySQL, open_dicoMySQL)
  AC_MANDATORY_LIB(decodage, textlang_in_file)

  AC_MANDATORY_HEADERS(decodage_usr.h)

  AC_DEFINE(LANGREC)
  LANGREC=yes
  AC_SUBST(LANGREC)
fi

])

dnl @synopsis AC_PROG_APACHE([version])
dnl
dnl This macro searches for an installed apache server. If nothing
dnl was specified when calling configure or just --with-apache, it searches in 
dnl /usr/local/apache/bin:/usr/local/bin:/usr/local/sbin:/usr/bin:/usr/sbin
dnl The argument of --with-apache specifies the full pathname of the
dnl httpd argument. For instance --with-apache=/usr/sbin/httpd.
dnl
dnl If the version argument is given, AC_PROG_APACHE checks that the
dnl apache server is this version number or higher.
dnl
dnl If the apache server is not found, abort configuration with error
dnl message. 
dnl
dnl It defines the symbol APACHE if the server is found. 
dnl
dnl Files using apache should do the following:
dnl
dnl   @APACHE@ -d /etc/httpd
dnl
dnl It defines the symbol APACHE_MODULES if a directory containing mod_env.*
dnl is found in the default server root directory (obtained with httpd -V).
dnl 
dnl The httpd.conf file listing modules to be loaded dynamicaly can use
dnl @APACHE_MODULES@ to grab them in the appropriate sub directory. For
dnl instance:
dnl ...
dnl <IfModule mod_so.c>
dnl LoadModule env_module         @APACHE_MODULES@/mod_env.so
dnl LoadModule config_log_module  @APACHE_MODULES@/mod_log_config.so
dnl ...
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl

AC_DEFUN([AC_PROG_APACHE],
#
# Handle user hints
#
[
 AC_MSG_CHECKING(if apache is wanted)
 AC_ARG_WITH(apache,
  [  --with-apache=PATH absolute path name of apache server (default is to search httpd or apache in
    /usr/local/apache/bin:/usr/local/bin:/usr/local/sbin:/usr/bin:/usr/sbin),
    --without-apache to disable apache detection],
  [
    #
    # Run this if -with or -without was specified
    #
    if test "$withval" != no ; then
       AC_MSG_RESULT(yes)
       APACHE_WANTED=yes
       if test "$withval" != yes ; then
         APACHE="$withval"
       fi
    else
       APACHE_WANTED=no
       AC_MSG_RESULT(no)
    fi
  ], [
    #
    # Run this if nothing was said
    #
    APACHE_WANTED=yes
    AC_MSG_RESULT(yes)
  ])
  #
  # Now we know if we want apache or not, only go further if
  # it's wanted.
  #
  if test $APACHE_WANTED = yes ; then
    #
    # If not specified by caller, search in standard places
    #
    if test -z "$APACHE" ; then
      AC_PATH_PROG(APACHE, httpd, , /usr/local/apache/bin:/usr/local/bin:/usr/local/sbin:/usr/bin:/usr/sbin)
    fi
    if test -z "$APACHE" ; then
      AC_PATH_PROG(APACHE, apache, , /usr/local/apache/bin:/usr/local/bin:/usr/local/sbin:/usr/bin:/usr/sbin)
    fi
    AC_SUBST(APACHE)
    if test -z "$APACHE" ; then
	AC_MSG_ERROR("apache server executable not found");
    fi
    #
    # Collect apache version number. If for nothing else, this
    # guaranties that httpd/apache is a working apache executable.
    #
    changequote(<<, >>)dnl
    APACHE_READABLE_VERSION=`$APACHE -v | grep 'Server version' | sed -e 's;.*/\([0-9\.][0-9\.]*\).*;\1;'`
    changequote([, ])dnl
    APACHE_VERSION=`echo $APACHE_READABLE_VERSION | sed -e 's/\.//g'`
    if test -z "$APACHE_VERSION" ; then
	AC_MSG_ERROR("could not determine apache version number");
    fi
    APACHE_MAJOR=`expr $APACHE_VERSION : '\(..\)'`
    APACHE_MINOR=`expr $APACHE_VERSION : '..\(.*\)'`
    #
    # Check that apache version matches requested version or above
    #
    if test -n "$1" ; then
      AC_MSG_CHECKING(apache version >= $1)
      APACHE_REQUEST=`echo $1 | sed -e 's/\.//g'`
      APACHE_REQUEST_MAJOR=`expr $APACHE_REQUEST : '\(..\)'`
      APACHE_REQUEST_MINOR=`expr $APACHE_REQUEST : '..\(.*\)'`
      if test "$APACHE_MAJOR" -lt "$APACHE_REQUEST_MAJOR" -o "$APACHE_MINOR" -lt "$APACHE_REQUEST_MINOR" ; then
        AC_MSG_RESULT(no)
        AC_MSG_ERROR(apache version is $APACHE_READABLE_VERSION)
      else
        AC_MSG_RESULT(yes)
      fi
    fi
    #
    # Find out if .so modules are in libexec/module.so or modules/module.so
    #
    HTTP_ROOT=`$APACHE -V | grep HTTPD_ROOT | sed -e 's/.*"\(.*\)"/\1/'`
    AC_MSG_CHECKING(apache modules)
    APACHE_READABLE_MAJOR=`expr $APACHE_READABLE_VERSION : '\(.*\)\..*'`
    for dir in libexec modules lib/apache lib/apache/$APACHE_READABLE_MAJOR
    do
      if test -f $HTTP_ROOT/$dir/mod_env.*
      then
	APACHE_MODULES=$dir
      fi
    done
    if test -z "$APACHE_MODULES"
    then
      AC_MSG_RESULT(not found)
    else
      AC_MSG_RESULT(in $HTTP_ROOT/$APACHE_MODULES)
    fi
    AC_SUBST(APACHE_MODULES)
  fi
])

dnl @synopsis CHECK_ID()
dnl
dnl Defines the USER and GROUP symbol from the id command,
dnl If USER=root, set to nobody.
dnl
dnl Usage example in Makefile.am:
dnl   
dnl   program $(USER) $(GROUP)
dnl
dnl or in Makefile.in:
dnl 
dnl   program @USER@ @GROUP@
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl

AC_DEFUN([CHECK_ID],
[AC_MSG_CHECKING(user and group name)
USER=`id -un`
GROUP=`id -gn`
if test "$USER" = "root"
then USER=nobody ; GROUP=`id -gn nobody` 
fi
AC_SUBST(USER)
AC_SUBST(GROUP)
AC_MSG_RESULT(user = $USER group = $GROUP)
])

dnl @synopsis AC_PROTOTYPE(function, includes, code, TAG1, values1 [, TAG2, values2 [...]])
dnl
dnl Try all the combinations of <TAG1>, <TAG2>... to successfully compile <code>.
dnl <TAG1>, <TAG2>, ... are substituted in <code> and <include> with values found in
dnl <values1>, <values2>, ... respectively. <values1>, <values2>, ... contain a list of
dnl possible values for each corresponding tag and all combinations are tested.
dnl When AC_TRY_COMPILE(include, code) is successfull for a given substitution, the macro
dnl stops and defines the following macros: FUNCTION_TAG1, FUNCTION_TAG2, ... using AC_DEFINE()
dnl with values set to the current values of <TAG1>, <TAG2>, ...
dnl If no combination is successfull the configure script is aborted with a message.
dnl
dnl Intended purpose is to find which combination of argument types is acceptable for a
dnl given function <function>. It is recommended to list the most specific types first.
dnl For instance ARG1, [size_t, int] instead of ARG1, [int, size_t].
dnl
dnl Generic usage pattern:
dnl
dnl 1) add a call in configure.in
dnl
dnl  AC_PROTOTYPE(...)
dnl
dnl 2) call autoheader to see which symbols are not covered
dnl
dnl 3) add the lines in acconfig.h
dnl
dnl  /* Type of Nth argument of function */
dnl  #undef FUNCTION_ARGN
dnl
dnl 4) Within the code use FUNCTION_ARGN instead of an hardwired type
dnl
dnl Complete example:
dnl
dnl 1) configure.in
dnl
dnl  AC_PROTOTYPE(getpeername,
dnl  [
dnl   #include <sys/types.h>
dnl   #include <sys/socket.h>
dnl  ],
dnl  [
dnl   int a = 0;
dnl   ARG2 * b = 0;
dnl   ARG3 * c = 0;
dnl   getpeername(a, b, c);
dnl  ],
dnl  ARG2, [struct sockaddr, void],
dnl  ARG3, [socklen_t, size_t, int, unsigned int, long unsigned int])
dnl
dnl 2) call autoheader
dnl
dnl  autoheader: Symbol `GETPEERNAME_ARG2' is not covered by ./acconfig.h
dnl  autoheader: Symbol `GETPEERNAME_ARG3' is not covered by ./acconfig.h
dnl
dnl 3) acconfig.h
dnl
dnl  /* Type of second argument of getpeername */
dnl  #undef GETPEERNAME_ARG2
dnl
dnl  /* Type of third argument of getpeername */
dnl  #undef GETPEERNAME_ARG3
dnl
dnl 4) in the code
dnl      ...
dnl      GETPEERNAME_ARG2 name;
dnl      GETPEERNAME_ARG3 namelen;
dnl      ...
dnl      ret = getpeername(socket, &name, &namelen);
dnl      ...
dnl
dnl Implementation notes: generating all possible permutations of
dnl the arguments is not easily done with the usual mixture of shell and m4,
dnl that is why this macro is almost 100% m4 code. It generates long but simple
dnl to read code.
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl

AC_DEFUN([AC_PROTOTYPE],[
dnl
dnl Upper case function name
dnl
 pushdef([function],translit([$1], [a-z], [A-Z]))
dnl
dnl Collect tags that will be substituted
dnl
 pushdef([tags],[AC_PROTOTYPE_TAGS(builtin([shift],builtin([shift],builtin([shift],$@))))])
dnl
dnl Wrap in a 1 time loop, when a combination is found break to stop the combinatory exploration
dnl
 for i in 1
 do
   AC_PROTOTYPE_LOOP(AC_PROTOTYPE_REVERSE($1, AC_PROTOTYPE_SUBST($2,tags),AC_PROTOTYPE_SUBST($3,tags),builtin([shift],builtin([shift],builtin([shift],$@)))))
   AC_MSG_ERROR($1 unable to find a working combination)
 done
 popdef([tags])
 popdef([function])
])

dnl
dnl AC_PROTOTYPE_REVERSE(list)
dnl
dnl Reverse the order of the <list>
dnl
AC_DEFUN([AC_PROTOTYPE_REVERSE],[ifelse($#,0,,$#,1,[[$1]],[AC_PROTOTYPE_REVERSE(builtin([shift],$@)),[$1]])])

dnl
dnl AC_PROTOTYPE_SUBST(string, tag)
dnl
dnl Substitute all occurence of <tag> in <string> with <tag>_VAL.
dnl Assumes that tag_VAL is a macro containing the value associated to tag.
dnl
AC_DEFUN([AC_PROTOTYPE_SUBST],[ifelse($2,,[$1],[AC_PROTOTYPE_SUBST(patsubst([$1],[$2],[$2[]_VAL]),builtin([shift],builtin([shift],$@)))])])

dnl
dnl AC_PROTOTYPE_TAGS([tag, values, [tag, values ...]])
dnl
dnl Generate a list of <tag> by skipping <values>.
dnl
AC_DEFUN([AC_PROTOTYPE_TAGS],[ifelse($1,,[],[$1, AC_PROTOTYPE_TAGS(builtin([shift],builtin([shift],$@)))])])

dnl
dnl AC_PROTOTYPE_DEFINES(tags)
dnl
dnl Generate a AC_DEFINE(function_tag, tag_VAL) for each tag in <tags> list
dnl Assumes that function is a macro containing the name of the function in upper case
dnl and that tag_VAL is a macro containing the value associated to tag.
dnl
AC_DEFUN([AC_PROTOTYPE_DEFINES],[ifelse($1,,[],[AC_DEFINE(function[]_$1, $1_VAL) AC_PROTOTYPE_DEFINES(builtin([shift],$@))])])

dnl
dnl AC_PROTOTYPE_STATUS(tags)
dnl
dnl Generates a message suitable for argument to AC_MSG_* macros. For each tag
dnl in the <tags> list the message tag => tag_VAL is generated.
dnl Assumes that tag_VAL is a macro containing the value associated to tag.
dnl
AC_DEFUN([AC_PROTOTYPE_STATUS],[ifelse($1,,[],[$1 => $1_VAL AC_PROTOTYPE_STATUS(builtin([shift],$@))])])

dnl
dnl AC_PROTOTYPE_EACH(tag, values)
dnl
dnl Call AC_PROTOTYPE_LOOP for each values and define the macro tag_VAL to
dnl the current value.
dnl
AC_DEFUN([AC_PROTOTYPE_EACH],[
  ifelse($2,, [
  ], [
    pushdef([$1_VAL], $2)
    AC_PROTOTYPE_LOOP(rest)
    popdef([$1_VAL])
    AC_PROTOTYPE_EACH($1, builtin([shift], builtin([shift], $@)))
  ])
])

dnl
dnl AC_PROTOTYPE_LOOP([tag, values, [tag, values ...]], code, include, function)
dnl
dnl If there is a tag/values pair, call AC_PROTOTYPE_EACH with it.
dnl If there is no tag/values pair left, tries to compile the code and include
dnl using AC_TRY_COMPILE. If it compiles, AC_DEFINE all the tags to their
dnl current value and exit with success.
dnl
AC_DEFUN([AC_PROTOTYPE_LOOP],[
 ifelse(builtin([eval], $# > 3), 1,
   [
     pushdef([rest],[builtin([shift],builtin([shift],$@))])
     AC_PROTOTYPE_EACH($2,$1)
     popdef([rest])
   ], [
     AC_MSG_CHECKING($3 AC_PROTOTYPE_STATUS(tags))
dnl
dnl Activate fatal warnings if possible, gives better guess
dnl
     ac_save_CPPFLAGS="$CPPFLAGS"
     ifelse(_AC_LANG,CPLUSPLUS,if test "$GXX" = "yes" ; then CPPFLAGS="$CPPFLAGS -Werror" ; fi)
     ifelse(_AC_LANG,C,if test "$GCC" = "yes" ; then CPPFLAGS="$CPPFLAGS -Werror" ; fi)
     AC_TRY_COMPILE($2, $1, [
      CPPFLAGS="$ac_save_CPPFLAGS"
      AC_MSG_RESULT(ok)
      AC_PROTOTYPE_DEFINES(tags)
      break;
     ], [
      CPPFLAGS="$ac_save_CPPFLAGS"
      AC_MSG_RESULT(not ok)
     ])
   ]
 )
])

dnl @synopsis AC_PROTOTYPE_GETSOCKNAME
dnl
dnl Requires the AC_PROTOTYPE macro.
dnl
dnl Find the type of argument two and three of getsockname. User
dnl must include the following in acconfig.h:
dnl
dnl /* Type of second argument of getsockname */
dnl #undef GETSOCKNAME_ARG2
dnl
dnl /* Type of third argument of getsockname */
dnl #undef GETSOCKNAME_ARG3
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([AC_PROTOTYPE_GETSOCKNAME],[
AC_PROTOTYPE(getsockname,
 [
  #include <sys/types.h>
  #include <sys/socket.h>
 ],
 [
  int a = 0;
  ARG2 * b = 0;
  ARG3 * c = 0;
  getsockname(a, b, c);
 ],
 ARG2, [struct sockaddr, void],
 ARG3, [socklen_t, size_t, int, unsigned int, long unsigned int])
])

dnl @synopsis AC_PROTOTYPE_SETSOCKOPT
dnl
dnl Requires the AC_PROTOTYPE macro.
dnl
dnl Find the type of argument three of setsockopt. User
dnl must include the following in acconfig.h:
dnl
dnl /* Type of third argument of setsockopt */
dnl #undef SETSOCKOPT_ARG3
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([AC_PROTOTYPE_SETSOCKOPT],[
AC_PROTOTYPE(setsockopt,
 [
  #include <sys/types.h>
  #include <sys/socket.h>
 ],
 [
  int a = 0;
  ARG3 b = 0;
  setsockopt(a, SOL_SOCKET, SO_REUSEADDR, b, sizeof(a));
 ],
 ARG3, [const void*, const char*, void*, char*])
])

dnl @synopsis AC_PROTOTYPE_ACCEPT
dnl
dnl Requires the AC_PROTOTYPE macro.
dnl
dnl Find the type of argument two and three of accept. User
dnl must include the following in acconfig.h:
dnl
dnl /* Type of second argument of accept */
dnl #undef ACCEPT_ARG2
dnl
dnl /* Type of third argument of accept */
dnl #undef ACCEPT_ARG3
dnl
dnl @version $Id: acinclude.m4,v 1.35 2001/09/10 09:56:45 loic Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([AC_PROTOTYPE_ACCEPT],[
AC_PROTOTYPE(accept,
 [
  #include <sys/types.h>
  #include <sys/socket.h>
 ],
 [
  int a = 0;
  ARG2 * b = 0;
  ARG3 * c = 0;
  accept(a, b, c);
 ],
 ARG2, [struct sockaddr, void],
 ARG3, [socklen_t, size_t, int, unsigned int, long unsigned int])
])


dnl Check type of signal routines (posix, 4.2bsd, 4.1bsd or v7)
AC_DEFUN(SIGNAL_CHECK,
[AC_REQUIRE([AC_TYPE_SIGNAL])
AC_MSG_CHECKING(for type of signal functions)
AC_CACHE_VAL(webbase_cv_signal_vintage,
[
  AC_TRY_LINK([#include <signal.h>],[
    sigset_t ss;
    struct sigaction sa;
    sigemptyset(&ss); sigsuspend(&ss);
    sigaction(SIGINT, &sa, (struct sigaction *) 0);
    sigprocmask(SIG_BLOCK, &ss, (sigset_t *) 0);
  ], webbase_cv_signal_vintage=posix,
  [
    AC_TRY_LINK([#include <signal.h>], [
	int mask = sigmask(SIGINT);
	sigsetmask(mask); sigblock(mask); sigpause(mask);
    ], webbase_cv_signal_vintage=4.2bsd,
    [
      AC_TRY_LINK([
	#include <signal.h>
	RETSIGTYPE foo() { }], [
		int mask = sigmask(SIGINT);
		sigset(SIGINT, foo); sigrelse(SIGINT);
		sighold(SIGINT); sigpause(SIGINT);
        ], webbase_cv_signal_vintage=svr3, webbase_cv_signal_vintage=v7
    )]
  )]
)
])
AC_MSG_RESULT($webbase_cv_signal_vintage)
if test "$webbase_cv_signal_vintage" = posix; then
AC_DEFINE(HAVE_POSIX_SIGNALS)
elif test "$webbase_cv_signal_vintage" = "4.2bsd"; then
AC_DEFINE(HAVE_BSD_SIGNALS)
elif test "$webbase_cv_signal_vintage" = svr3; then
AC_DEFINE(HAVE_USG_SIGHOLD)
fi
])

AC_DEFUN(TYPE_SIGHANDLER,
[AC_MSG_CHECKING([whether signal handlers are of type void])
AC_MSG_RESULT($ac_cv_type_signal)
if test $ac_cv_type_signal = "void"; then
AC_DEFINE(VOID_SIGHANDLER)
fi
])

