/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _crawl_private_h
#define _crawl_private_h

struct crawl_params;

#include <webbase.h>
#include <webbase_url.h>

#define CRAWL_OPTIONS		0x0001000

typedef struct crawl_context {
  struct crawl_params* params;
  webbase_url_start_t* start;
  webbase_t* base;
  webbase_url_t webbase_url;
  int root_url;
  char* home;
  int home_length;
  char* dirsel_key;
  int level;
  char* url;
  int empty;
  int walk_end;
  int no_crawl;
  int timeouts;
  int location_no_loop;
  int redirections;
  int touch;
  int collected;
} crawl_context_t;

#define CRAWL_MAX_TIMEOUTS	5
#define CRAWL_MAX_REDIRECTIONS	10

#define CRAWL_USER_AGENT "webbase/"WEBBASE_VERSION

int mirror_collect(char* contextp, webbase_url_t* base_url, char* url, int flag);
webbase_url_t* mirror(crawl_context_t* context, char* url);

#endif /* _crawl_private_h */
