/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif /* HAVE_MALLOC_H */
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#include <stdio.h>
#include <string.h>

#include <WebbaseGetopt.h>

static int verbose = 0;

//
// hash helper : free a node whose data is malloc'd
//
static void hnode_free(hnode_t *node, void *)
{
  free(node->data);
  free(node);
}

WebbaseGetopt::WebbaseGetopt()
{
  options = hash_create(33, 0, 0);
  hash_set_allocator(options, 0, hnode_free, 0);
}

WebbaseGetopt::~WebbaseGetopt()
{
  hash_free(options);
}

void WebbaseGetopt::Parse(int argc, char** argv)
{
  struct option* options = Options();

  opterr = 0;
  optind = 0;
  while(1) {
    /* `getopt_long' stores the option index here. */
    int option_index = 0;
    int c;
    int found = 0;

    //
    // The "-" means RETURN_IN_ORDER and prevents permutation of arguments
    // as they are processed.
    //
    c = getopt_long_only(argc, argv, "-", options, &option_index);

    /* Detect the end of the options. */
    if (c == -1)
      break;
     
    switch (c)
      {
      case 0:
	/* If this option set a flag, do nothing else now. */
	
	if (options[option_index].flag != 0)
	  break;
	found = HandleOption(&options[option_index]);
	break;
      }
    if(found) {
      hash_alloc_insert(WebbaseGetopt::options, (char*)options[option_index].name, strdup(optarg ? optarg : " "));
    }
  }
}

void WebbaseGetopt::Merge(struct option to[], struct option from[])
{
  int from_i;
  int to_i;
  int flags;
  int max;
  for(to_i = 0; to[to_i].name; to_i++)
    ;
  flags = to[to_i].val;
  max = to[to_i].has_arg;
  if(verbose) fprintf(stderr, "getopt_merge: flags = 0x%x, max = %d\n", flags, max);

  if(to_i >= max) {
    fprintf(stderr, "getopt_merge: too many options in to (> %d)\n", max);
    exit(1);
  }
  for(from_i = 0; from[from_i].name; from_i++)
    ;
  if(verbose) fprintf(stderr, "getopt_merge: val = 0x%x\n", from[from_i].val);
  if((from[from_i].val & flags) == 0) {
    if(verbose) fprintf(stderr, "getopt_merge: accept\n");
    flags |= from[from_i].val;
    for(from_i = 0; to_i < max && from[from_i].name;)
      to[to_i++] = from[from_i++];
    if(to_i >= max) {
      fprintf(stderr, "getopt_merge: too many options in to (> %d)\n", max);
      exit(1);
    }
  }
  memset((char*)&to[to_i], '\0', sizeof(struct option));
  to[to_i].val = flags;  
  if(verbose) fprintf(stderr, "getopt_merge: %s %d\n", from[0].name, max);
  to[to_i].has_arg = max;
}

void WebbaseGetopt::Dump(struct option options[])
{
  int i;
  for(i = 0; options[i].name; i++)
    printf("option: %s\n", options[i].name);
}
