/*
 * Copyright (C) 1999, 2000  Lorenzo Bettini, lorenzo.bettini@penteres.it
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// decorators for html

#ifndef _DECORATOR_H
#define _DECORATOR_H

#include "textgen.h"

class CharTranslator;

class TagDecorator : public TextDecorator
{
 protected:
  char *tag ;
  char *attr ;
  char *val ;

 public:
  TagDecorator( TextGenerator *t, CharTranslator *, 
                char *ta, char *a = 0, char *v = 0 );
  virtual ~TagDecorator() {}
  
  virtual void startDecorate();
  virtual void endDecorate();

 protected:
  void startTAG( char *tag, char *attr, char *val ) const;
  void endTAG( char *tag ) const;
  virtual void generateAttrVal() const;
} ;

class XhtmlTagDecorator : public TagDecorator
{
 public:
  XhtmlTagDecorator( TextGenerator *t, CharTranslator *, 
                     char *ta, char *a, char *v );

 protected:
  virtual void generateAttrVal() const;
};

class ColorDecorator : public TagDecorator
{
 public:
  ColorDecorator( TextGenerator *t, CharTranslator *, char *color );
} ;

class XhtmlColorDecorator : public XhtmlTagDecorator
{
 public:
  XhtmlColorDecorator( TextGenerator *t, CharTranslator *, char *color );
};

class SpanDecorator : public TextDecorator
{
 protected:
  char *span ;

 public:
  SpanDecorator( TextGenerator *t, CharTranslator *, char *ta);

  virtual void startDecorate();
  virtual void endDecorate();

 protected:
  void startTAG( char *span ) const;
  void endTAG( ) const;
} ;

#endif
