/*
* (C) 2000, 2001 David O'Toole $Date: 2001/04/07 23:27:08 $
* 
* OCTAL's various utility functions. 
*
* $Revision: 1.1 $
*
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include "octal.h"

#define FREQ_OF_A4 440
#define DATA_OF_A4 57

freq freq_table[NOTE_RANGE];     
char note_names[NOTE_RANGE][10]; // text equivalents of all the notes. 3 characters long each. 

// don't touch this.
const char* note_prefixes[12]= {"c-", "c#", "d-", "d#", "e-", 
						"f-", "f#", "g-", "g#", "a-", 
						"a#", "b-"}; 



// these init_* functions must be called by octal before any machines can do work. 
// conveniently, init_sound can probably do this, or at least at the same time.   

void init_note_names(void) {
	int i;

	for (i=0; i<NOTE_RANGE; i++) { 
		sprintf(note_names[i], "%s%d", note_prefixes[i%12], i/12);
		note_names[i][3] = '\0'; // add null terminator on 4th char 
		}
	}

void init_freq_table(void) {
	int i;
	long double f=0;
	long double factor;
	long double t;
	
	t=(double)1.0/(double)12.0;
	factor=pow(2,t);
	
	/* first walk up from A4, which is the A above middle C in OCTAL. 440HZ */
	for (i = DATA_OF_A4, f = FREQ_OF_A4; i<NOTE_RANGE; i++) {
		freq_table[i] = f;
		f *= factor;      /* mult to next note */
		}
	
	/* now walk down from A4 to C0 */
	for (i = DATA_OF_A4, f = FREQ_OF_A4; i >= 0; i--) {
		freq_table[i] = f;
		f /= factor;      /* div to next note */
		}
		
	}


/* Package functions. These utilities are installed in the global
 *  oxapi package, accessible as "pkg" from inside machines. 
 */

freq p_note2freq(param n) {
	return freq_table[(int)n];
	}


const char* p_note2text(param n) 
{
	return note_names[(int)n];
}


/* returns middle A if it cannot parse the note. 
   returning -1 would be a bad idea, as it would
   break anything which uses the return value as 
   a subscript 
*/ 
   
param p_text2note(const char* name) 
{
	int i;           
	char mycopy[64]; 
	
	strcpy(mycopy, name);
	mycopy[0] = tolower(mycopy[0]);
	mycopy[3] = '\0';
	
	for (i=0; i<NOTE_RANGE; i++) 
		if (strcmp(mycopy, note_names[i]) == 0)	
			return i;
	       
	/* that really should have been a binary search, not linear. 
	   but this isn't going to get used much. 
	*/

	return DATA_OF_A4;
		
}

freq p_text2freq(const char* name) 
{
	int test=p_text2note(name);

	if (test>=0) return (p_note2freq(test));    /* convenient, eh? */
	else return 440.0;	
}

int p_get_sr(void)
{
	return 44100;	// should this use the actual rate from OSS? 
					// for recording that wouldn't be good
}



