/* 
* (C) 2000, 2001 David O'Toole $Date: 2001/03/07 03:18:12 $
* 
* MAIN.C
* 
*
* $Revision: 1.1.1.1 $ 
*
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
*
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <pthread.h>
#include <unistd.h>
#include <string.h>

#include "gui/engine_view.h"
#include "gui/control_box.h"
#include "engine.h"
#include "core.h"

static const char rcsid[]="$Id: main.c,v 1.1.1.1 2001/03/07 03:18:12 dto Exp $";

// 
// STRINGS
// 

static const char banner[] = "\nGNU OCTAL --- pre-beta release\n-----------------\n";
static const char starting_core[] = "Initializing core...\n";
static const char starting_gtk[] = "Starting up GTK+...\n";
static const char complete_core[] = "Core has finished initialization.\n";

// 
// MAIN THREAD
//

int main(int argc, char *argv[]) 
{
	pthread_t pt; 
	engine_view *ev;

  	puts(banner); 
	
	puts(starting_core);

	pthread_mutex_init(&core_mutex, NULL);
	pthread_cond_init(&core_cond, NULL);
	
	pthread_mutex_lock(&core_mutex);
		pthread_create(&pt, NULL, ox_core, NULL);		// now core thread cannot signal 
		pthread_cond_wait(&core_cond, &core_mutex);		// now it can
	pthread_mutex_unlock(&core_mutex);

	// At this point the core has signaled full initialization is complete.
	// We shall consider this to mean:
	//
	// 1. The machine type registry is immutable and shall not hereafter need locking
	// 2. Some audio device is available to accept output
	// 3. All global objects are in a consistent state. (see share.c if it exists.) 

	puts(starting_gtk);
  	gtk_init(&argc, &argv);    

	printf("Creating engine_view, observing subject = %p \n", global_engine);	
	ev = ev_create(global_engine);
	 
	gtk_main();    

  	return(0);
}
