/*
* (C) 2000, 2001 David O'Toole $Date: 2001/03/07 03:18:12 $
* 
* engine_view.h 
* this is the header for the gtk+ engine viewer. 
*
*/

#ifndef _engine_view_h_
#define _engine_view_h_

#include "engine.h" 
#include "control_box.h"
#include <gtk/gtk.h>

typedef struct _engine_view {

	engine *subject;				// the engine that we are the interface to 

	GdkPixmap *pixmap; 				// backing store

	GtkWidget *window, *drawing;	// main widgets
	GtkWidget *cbarbox;				// side box full of control_boxes
	GtkWidget *menu, *mc_menu;		// context menus
	GtkWidget *entry, *label;		// status bar etc
	float x, y;	

	// places for control_boxes to stay
	control_box *cb_homes[max_machines];

	// some flags and such, for storing state of user interaction
	int dragging, drag_id;	
	int connecting;

	int mc_menu_id;

} engine_view;

//
// CLIENT-CALLABLE FUNCTIONS
//

engine_view *ev_create(engine *subject);
void ev_destroy(engine_view *self);

//
// GEOMETRY
//

extern const GdkPoint triangle[];
void poly_rotate(GdkPoint *p, int num_points, double theta); 

//
// GTK+ CALLBACKS :: MAIN WINDOW
//

gint delete_event_cb (GtkWidget* w, GdkEventAny* e, gpointer data); 
gboolean expose_event_cb (GtkWidget *widget, GdkEventExpose *event, gpointer data); 
gint button_press_event_cb (GtkWidget* w, GdkEventButton* event, gpointer data); 
gint button_release_event_cb (GtkWidget* w, GdkEventButton* event, gpointer data);
gint configure_event_cb (GtkWidget *widget, GdkEventConfigure *event, gpointer data);

//
// GTK+ CALLBACKS :: MENUS/DIALOGS
//

void rename_cb (GtkMenuItem *menuitem, gpointer self);
void control_box_cb (GtkMenuItem *menuitem, gpointer self);
void remove_cb (GtkMenuItem *menuitem, gpointer self);
void new_machine_menu_cb (GtkMenuItem *menuitem, gpointer data);

#endif

