/*
* (C) 2000 David O'Toole $Date: 2001/04/11 03:57:03 $
*
* CORE.C
*
* $Revision: 1.5 $
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
*
*/
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <math.h>
#include "octal.h"    // typedefs, error handling            
#include "package.h"  // musical utility                 
#include "machine.h"  // machine loading / type system  
#include "engine.h"   // signal network  
#include "output.h"   // device support    
#include "pattern.h"  // pattern system                 

//
// GLOBAL SYNCHRONIZATION VARS
//

engine *global_engine; 
cond_t core_cond; 	// view thread will initialize this
mutex_t core_mutex;


void* ox_core(void* unused) 
{
	engine *e; 
	machine *s1, *d;
	int a,c;
	mx_action *action;

	// initialize audio hardware and load up the machines  

	set_block_size(1024); 
	init_sound(OX_SAMPLING_RATE);
	init_freq_table();
	init_note_names();
	mc_make_registry(".");  
	
	e = en_create();
	global_engine = e;

	// some testing code
	s1 = mc_create(mc_get_type("dtosquare"));
	d = mc_create(mc_get_type("mdelay"));

	a = en_add(e, s1);
	c = en_add(e, d);

	en_connect(e, en_normal, a, c);
	en_connect(e, en_normal, c, 0);

	// SIGNAL GUI THREAD THAT WE ARE DONE INITIALIZATION
	
	pthread_mutex_lock(&core_mutex);
		pthread_cond_broadcast(&core_cond);
	pthread_mutex_unlock(&core_mutex);


	//
	// MAIN LOOP
	//	

	e->block_size = 512; 

	while (1) {
		pthread_mutex_lock(&e->mutex);
	
		// compile digraph if needed	
		if (!e->program) en_reset_program(e);

		// do that thing
		action = e->program;
		while (action) {
			mx_do_action(e, action);
			action = action->next;
			}

		pthread_mutex_unlock(&e->mutex);

		output_block(e->lmix, e->rmix, e->block_size);
	}
	
	return 0;
}


















