%{
/*
 * Copyright (C) 1999, 2000 Lorenzo Bettini, lorenzo.bettini@penteres.it
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */                         

int lineno = 1 ; /* numero di linee scandite */
char linebuf[1024] ; /* linea di codice attuale */
int tokenpos = 0 ; /* posizione del token corrente nella linea corrente */

#include "tags.h"
#include "tokens.h"
#include "colors.h"

#include "java2html.h"

%}

ws [ ]+
tabs [\t]+

nl \n
cr \r
IDE [a-zA-Z_]([a-zA-Z0-9_])*

STRING \"[^\"\n]*\"

not_alpha [^a-zA-Z0-9]

%s COMMENT_STATE
%s SINGLELINE_COMMENT
%s STRING_STATE
%s CHAR_STATE

%%



\r {}

"/*" { BEGIN COMMENT_STATE ;
       startComment( yytext ) ;      
     }
"/*".*"*/" { generateComment( yytext ) ;  }



<COMMENT_STATE>"*/" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of the comment */ }

<INITIAL>"//" { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>"//" { generate( yytext ) ; }
<SINGLELINE_COMMENT>\n { 
   BEGIN INITIAL ; 
   endComment( yytext ) ; 
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }

"<" { generate( LESS_THAN ) ; }

">" { generate( GREATER_THAN ) ; }

"&" { generate( AMPERSAND ) ; }

<INITIAL>\" { BEGIN STRING_STATE ; startString( yytext );  }
<STRING_STATE>\\\\ {  generate( yytext ) ; }
<STRING_STATE>"\\\"" {  generate( yytext ) ; }
<STRING_STATE>\" { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\' { BEGIN CHAR_STATE ; startString( yytext );  }
<CHAR_STATE>\\\\ {  generate( yytext ) ; }
<CHAR_STATE>"\\\'" {  generate( yytext ) ; }
<CHAR_STATE>\' { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>abstract |
<INITIAL>break |
<INITIAL>case |
<INITIAL>catch |
<INITIAL>class |
<INITIAL>const |
<INITIAL>continue |
<INITIAL>default |
<INITIAL>do |
<INITIAL>else |
<INITIAL>extends |
<INITIAL>final |
<INITIAL>finally |
<INITIAL>for |
<INITIAL>goto |
<INITIAL>if |
<INITIAL>import |
<INITIAL>implements |
<INITIAL>instanceof |
<INITIAL>interface |
<INITIAL>native |
<INITIAL>new |
<INITIAL>null |
<INITIAL>package |
<INITIAL>private |
<INITIAL>protected |
<INITIAL>public |
<INITIAL>return |
<INITIAL>static |
<INITIAL>super |
<INITIAL>switch |
<INITIAL>synchronized |
<INITIAL>throw |
<INITIAL>throws |
<INITIAL>this |
<INITIAL>transient |
<INITIAL>try |
<INITIAL>volatile |
<INITIAL>while  { generateKeyWord( yytext ) ; }


<INITIAL>int |
<INITIAL>byte |
<INITIAL>boolean |
<INITIAL>char |
<INITIAL>long |
<INITIAL>float |
<INITIAL>double |
<INITIAL>short |
<INITIAL>void { generateBaseType( yytext ) ; }

<INITIAL>[0-9]* { generateNumber( yytext ) ; }

[a-zA-Z_]([a-zA-Z0-9_])* { generate( yytext ) ; }

\t {
        generateTab() ;
}

. { generate( yytext ) ; /* anything else */ }

\n { 
       ++lineno;
       generateNewLine() ;
}

%%

void yyerror( char *s ) ;

void yyerror( char *s )
{  
  fprintf( stderr, "%d: %s: %s\n%s\n", lineno, s, yytext, linebuf ) ;
  fprintf( stderr, "%*s\n", tokenpos, "^" ) ;
}






