/* Generated By: Java; tab-width&JavaCC: Do not edit this line. EC.java */
package gnu.jel.generated;

import gnu.jel.*;
import gnu.jel.reflect.Member;
import java.io.StringReader;
import gnu.jel.debug.Debug;
import java.util.Stack;

public class EC implements ECConstants { /* EC stands for ExpressionCompiler */
  TypesStack typesStk=null;
  TypesStack xchgTS=null; // temporary types stack

  Stack paramOPs=null;
  Stack xchgOP=null; // temporary paramops stack
  OPlist list=null;
  Token errToken=null;
  Library lib=null;
  StringBuffer accDV=null; // null means DVs are disabled

  public OPlist parse(Class resType, Library lib)
    throws CompilationException {

    // checks of the assumptions made later
    if (Debug.enabled)
      Debug.assert(((MINUS-PLUS)==1) && ((NE-EQ)==1) && ((GE-LT)==1) &&
                   ((GT-GE)==1) && ((LE-GT)==1) && ((RS-LS)==1) &&
                   ((RUS-RS)==1) && ((DIVIDE-MULTIPLY)==1) &&
                   ((REMAINDER-DIVIDE)==1) && ((LOGCOMPL-BWCOMPL)==1));

    this.lib=lib;
    typesStk=new TypesStack();
    xchgTS=new TypesStack();
    paramOPs=new Stack();
    xchgOP=new Stack();
    list=new OPlist();

    // initialize DV names accumulator
    if (lib.resolver!=null) accDV=new StringBuffer();

    try {
      expression(resType);
    } catch (CompilationException exc) {
      if (Debug.enabled)
        Debug.assert(errToken!=null,"Error token is not set.");
      exc.setColumn(errToken.beginColumn);
      throw exc;
    } catch (ParseException pe) {
      throw new CompilationException(pe.currentToken.next.beginColumn,
                                     pe.currentToken.next.kind==0?1:2,
                                     pe.currentToken.next);
    } catch (TokenMgrError tme) {
      throw new CompilationException(tme.col,tme.isEOF?1:3,
                                     new Character(tme.encountered));
    };
    return list;
  }


  private final void notePar() {
    if (list.size()>0)
      paramOPs.push(list.getLast());
    else
      paramOPs.push(null);
  }

  private final boolean isDV() {
    return lib.resolver.getTypeName(accDV.toString())!=null;
  }

  private final void genDVCall()
    throws CompilationException {
    if ((accDV==null) || (accDV.length()==0)) return;
    String varName=accDV.toString();

    String typeName=lib.resolver.getTypeName(varName);

    notePar(); // placeholder for "this" reference
    int paramsStart=typesStk.size();

    list.addLast(new OPload(typesStk,varName));

    notePar();
    functionCall(null,"get"+typeName+"Property",paramsStart);
    accDV.setLength(0);
  }


  private final void functionCall(Class resolveInClass,String name,
                                  int paramsStart) throws CompilationException{
    // collect params
    int np=typesStk.size()-paramsStart;
    Class[] params=new Class[np];

    for(int i=np-1;i>=0;i--) {
      xchgTS.pushID(typesStk.peekID(),params[i]=typesStk.pop());
      xchgOP.push(paramOPs.pop());
    };

    // find method
    Member m=null;
    if (resolveInClass!=null) {
      m=lib.getMember(resolveInClass,name,params);
    } else
      m=lib.getMember(name,params);


    // put "this" pointer in place
    if (resolveInClass==null) {
      OP thisOP=(OP)paramOPs.pop();
      if ((m.getModifiers() & 0x0008)==0) {
        // insert loading of "this" pointer
        OP op=new OPcall(typesStk,1,(new Object[0]).getClass());
        list.addAfter(thisOP,op); paramOPs.push(thisOP=op);
        int classID=lib.getDynamicMethodClassID(m);
        op=new OPload(typesStk,Integer.TYPE,new Integer(classID));
        list.addAfter(thisOP,op); paramOPs.push(thisOP=op);
        op=new OPbinary(typesStk,paramOPs,19,list);
        list.addAfter(thisOP,op); paramOPs.push(thisOP=op);
      };
    };

    // restore params & param ops
    for(int i=0;i<np;i++) {
      typesStk.pushID(xchgTS.peekID(),xchgTS.pop());
      paramOPs.push(xchgOP.pop());
    };
    list.addLast(new OPcall(typesStk,paramOPs,m,list,
                            lib.isStateless(m)));
  }

  private final boolean isCast() {
    if (getToken(1).kind != LPAREN) return false;
    if (getToken(2).kind != ID) return false;
    if (getToken(3).kind != RPAREN) return false;
    switch (getToken(4).kind) {
      case BWCOMPL:
      case LOGCOMPL:
      case LPAREN:
      case ID:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case TRUE:
      case FALSE:
        //      case NULL:
        return true;
      }
    return false;
  }

  private final void binOP(int code,Token errToken)
    throws CompilationException {
    this.errToken=errToken;
    notePar();
    list.addLast(new OPbinary(typesStk,paramOPs,code,list));
  }

  final public void expression(Class resultType) throws ParseException, CompilationException {
 Token x;
    conditional();
    x = jj_consume_token(0);
      errToken=x;
      // remove TSB at return if present
      if (typesStk.peekID()==10)
        list.addLast(new OPunary(typesStk,11,null,false));

      if (resultType!=null)
        list.addLast(new OPunary(typesStk,TypesStack.typeID(resultType),
                                 resultType,false));

      list.addLast(new OPunary(typesStk,3)); // add the "return" instr.

      if (Debug.enabled)
        Debug.assert(typesStk.size()==0,
                     "Words left in stack while parsing.");
  }

  final public void conditional() throws ParseException, CompilationException {
  OPlist oldList=null;
  OPlist trueList=null;
  int stackSizeBeforeBranch=0;
  int stackSizeAfterFirstBranch=0;
  Token x;
    lor();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 41:
      x = jj_consume_token(41);
    stackSizeBeforeBranch=typesStk.size();
    oldList=list;
    list=new OPlist();
      conditional();
      jj_consume_token(42);
    stackSizeAfterFirstBranch=typesStk.size();
    trueList=list;
    list=new OPlist();
      conditional();
    errToken=x;
    if (Debug.enabled)
      Debug.assert((typesStk.size()==stackSizeAfterFirstBranch+1) &&
                   (stackSizeAfterFirstBranch==stackSizeBeforeBranch+1),
                   "Stack in conditional branches is not balanced.");
    OP opcond=new OPcondtnl(typesStk,oldList,trueList,list);
    list=oldList;
    list.addLast(opcond);
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
  }

  final public void lor() throws ParseException, CompilationException {
 Token x;
    land();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOR:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      x = jj_consume_token(LOR);
                    notePar();
      land();
    binOP(18,x);
    }
  }

  final public void land() throws ParseException, CompilationException {
 Token x;
    bor();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LAND:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      x = jj_consume_token(LAND);
                    notePar();
      bor();
         binOP(17,x);
    }
  }

  final public void bor() throws ParseException, CompilationException {
 Token x;
    bxor();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_3;
      }
      x = jj_consume_token(OR);
                   notePar();
      bxor();
          binOP(6,x);
    }
  }

  final public void bxor() throws ParseException, CompilationException {
 Token x;
    band();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XOR:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_4;
      }
      x = jj_consume_token(XOR);
                    notePar();
      band();
          binOP(7,x);
    }
  }

  final public void band() throws ParseException, CompilationException {
 Token x;
    equality();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_5;
      }
      x = jj_consume_token(AND);
                        notePar();
      equality();
              binOP(5,x);
    }
  }

  final public void equality() throws ParseException, CompilationException {
 Token x;
    relation();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case NE:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        x = jj_consume_token(EQ);
        break;
      case NE:
        x = jj_consume_token(NE);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                notePar();
      relation();
              binOP(8+x.kind-EQ,x);
    }
  }

  final public void relation() throws ParseException, CompilationException {
 Token x;
    shift();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
      case GE:
      case GT:
      case LE:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        x = jj_consume_token(LT);
        break;
      case GE:
        x = jj_consume_token(GE);
        break;
      case GT:
        x = jj_consume_token(GT);
        break;
      case LE:
        x = jj_consume_token(LE);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                      notePar();
      shift();
           binOP(10+x.kind-LT,x);
    }
  }

  final public void shift() throws ParseException, CompilationException {
 Token x;
    sum();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LS:
      case RS:
      case RUS:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LS:
        x = jj_consume_token(LS);
        break;
      case RS:
        x = jj_consume_token(RS);
        break;
      case RUS:
        x = jj_consume_token(RUS);
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                    notePar();
      sum();
         binOP(14+x.kind-LS,x);
    }
  }

  final public void sum() throws ParseException, CompilationException {
 Token x;
    term();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        x = jj_consume_token(PLUS);
        break;
      case MINUS:
        x = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            notePar();
      term();
          binOP(x.kind-PLUS,x);
    }
  }

  final public void term() throws ParseException, CompilationException {
 Token x;
    unary();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case REMAINDER:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        x = jj_consume_token(MULTIPLY);
        break;
      case DIVIDE:
        x = jj_consume_token(DIVIDE);
        break;
      case REMAINDER:
        x = jj_consume_token(REMAINDER);
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            notePar();
      unary();
           binOP(2+x.kind-MULTIPLY,x);
    }
  }

  final public void unary() throws ParseException, CompilationException {
  Token x;
  Token type_to;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case BWCOMPL:
    case LOGCOMPL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BWCOMPL:
        x = jj_consume_token(BWCOMPL);
        break;
      case LOGCOMPL:
        x = jj_consume_token(LOGCOMPL);
        break;
      case MINUS:
        x = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      unary();
    errToken=x;
    list.addLast(new OPunary(typesStk,x.kind-MINUS));
      break;
    default:
      jj_la1[17] = jj_gen;
      if (isCast()) {
        jj_consume_token(LPAREN);
        type_to = jj_consume_token(ID);
        jj_consume_token(RPAREN);
        element();
    errToken=type_to;
    int typeID=0;
    while ((typeID<8) &&
           !type_to.image.equals(TypesStack.specialTypes[typeID].toString()))
      typeID++;

    if (typeID>=8) // The type name is unknown.
      {if (true) throw new CompilationException(-1,4,type_to.image);}

    list.addLast(new OPunary(typesStk,typeID,null,true));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
        case FALSE:
        case TRUE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case ID:
          element();
          break;
        default:
          jj_la1[18] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void element() throws ParseException, CompilationException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             list.addLast(new OPload(typesStk,Boolean.TRUE));
      break;
    case FALSE:
      jj_consume_token(FALSE);
             list.addLast(new OPload(typesStk,Boolean.FALSE));
      break;
    case LPAREN:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case ID:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
        literal();
        break;
      case LPAREN:
        jj_consume_token(LPAREN);
        conditional();
        jj_consume_token(RPAREN);
        break;
      case ID:
        invocation(false);
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOT:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_11;
        }
        jj_consume_token(DOT);
        invocation(true);
      }
   genDVCall(); // finish prepared DV call

      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void invocation(boolean afterDot) throws ParseException, CompilationException {
  int paramsStart=0;
  Class resolveIn=null;
  Token x,id;
  boolean inDVmatch=false;
    id = jj_consume_token(ID);
    if (accDV!=null) {
      int oldLen=accDV.length();
      if (afterDot) accDV.append('.');
      accDV.append(id.image);
      if (!(inDVmatch=isDV())) {
        accDV.setLength(oldLen); // back up
        errToken=id;
        genDVCall(); // finish prepared DV call
      };
    }; // end if accDV!=null

    if (!inDVmatch) {
      if (afterDot) resolveIn=typesStk.peek();
      // start prepating a call to an object's method x.image
      notePar(); // placeholder for "this" reference
      paramsStart=typesStk.size();
    };
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      x = jj_consume_token(LPAREN);
        if (inDVmatch) {
          // error variable must have no parameters
          errToken=x;
          {if (true) throw new CompilationException(-1,26,null);}

          // this is the place to hack in the abort of match and check
          // if the last matched name can be called as a method
        };
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case BWCOMPL:
      case LOGCOMPL:
      case LPAREN:
      case FALSE:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case ID:
        conditional();
                     notePar();
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case 43:
            ;
            break;
          default:
            jj_la1[22] = jj_gen;
            break label_12;
          }
          jj_consume_token(43);
          conditional();
                                                      notePar();
        }
        break;
      default:
        jj_la1[23] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
        if (!inDVmatch) {
          // generate the method invocation
          errToken=id;
          functionCall(resolveIn,id.image,paramsStart);
        };
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 44:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_13;
      }
      x = jj_consume_token(44);
        genDVCall(); // finish prepared DV call
        notePar();
      conditional();
      x = jj_consume_token(45);
            binOP(19,x);
    }
  }

  final public void literal() throws ParseException, CompilationException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
                     {
    errToken=token;
    String svalue=token.image.toUpperCase();
    long value=0;
    boolean makelong=svalue.endsWith("L");
    if (makelong) svalue=svalue.substring(0,svalue.length()-1);

    try {
      if ( svalue.startsWith("0x") || svalue.startsWith("0X") ) {
        // Hexadecimal number
        svalue=svalue.substring(2);
        value=Long.parseLong(svalue,16);
      } else if (token.image.startsWith("0")) {
        // Octal number
        value=Long.parseLong(svalue,8);
      } else {
        // Decimal number
        value=Long.parseLong(svalue,10);
      };
    } catch (NumberFormatException e) {
      {if (true) throw new CompilationException(-1,13,token.image);} // Overflow ?
    };

    Object val=null;
    if (!makelong) { // Check ranges
      if (value<=127) val=new Byte((byte)value);
      else if (value<=32767) val=new Short((short)value);
      else if (value<=2147483647) val=new Integer((int)value);
      else {if (true) throw new CompilationException(-1,14,token.image);}
    } else {
      val=new Long(value);
    };

    list.addLast(new OPload(typesStk,val));
  }
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
                            {
  errToken=token;
  char lc=Character.toUpperCase(token.image.charAt(token.image.length()-1));
  boolean makeFloat = (lc=='F');
  String svalue=token.image;
  if ((lc=='D') || (lc=='F')) {
    svalue=svalue.substring(0,svalue.length()-1);
  };
  Double value=null;
  try {
    value=new Double(svalue);
  } catch (NumberFormatException e) {
    // Overflow ? Will produce infinity.
  };
  if (makeFloat)
    list.addLast(new OPload(typesStk,new Float(value.floatValue())));
  else
    list.addLast(new OPload(typesStk,value));
  }
      break;
    case CHARACTER_LITERAL:
      jj_consume_token(CHARACTER_LITERAL);
                       {
  errToken=token;
  String sval=token.image.substring(1,token.image.length()-1);
  if (sval.length()==1)
    list.addLast(new OPload(typesStk,new Character(sval.charAt(0))));
  else { // escape or number
    char ec=sval.charAt(1);
    try {
      switch (ec) {
      case 'n': ec='\n'; break;
      case 't': ec='\t'; break;
      case 'b': ec='\b'; break;
      case 'r': ec='\r'; break;
      case 'f': ec='\f'; break;
      case '\\': ec='\\'; break;
      case '\'': ec='\''; break;
      case '\"': ec='"'; break;
      default:
        ec=(char) Integer.parseInt(sval.substring(1),8);
      };
    } catch (NumberFormatException e) {/* Can't be */};
    list.addLast(new OPload(typesStk,new Character(ec)));
  };
  }
      break;
    case STRING_LITERAL:
      jj_consume_token(STRING_LITERAL);
                    {
  String sval=token.image.substring(1,token.image.length()-1);
  StringBuffer unescaped=new StringBuffer(sval.length());
  for(int i=0;i<sval.length();i++) {
    char ec=sval.charAt(i);
    if (ec=='\\') { // escape
      ec=sval.charAt(++i);
      switch (ec) {
      case 'n': ec='\n'; break;
      case 't': ec='\t'; break;
      case 'b': ec='\b'; break;
      case 'r': ec='\r'; break;
      case 'f': ec='\f'; break;
      case '\\': ec='\\'; break;
      case '\'': ec='\''; break;
      case '\"': ec='"'; break;
      default:
        int nval=0;
        while ((i<sval.length()) && ((ec=sval.charAt(i))>='0') && (ec<='7')) {
          nval=nval<<3+(ec-'0');
          i++;
        };
        i--;
        ec=(char)nval;
      };
    };
    unescaped.append(ec);
  };
  list.addLast(new OPload(typesStk,unescaped.toString()));
  }
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  public ECTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[27];
  final private int[] jj_la1_0 = {0x0,0x8000,0x2000,0x4000,0x10000,0x1000,0x60000,0x60000,0x780000,0x780000,0x3800000,0x3800000,0x30,0x30,0xe00,0xe00,0xe0,0xe0,0x74000000,0x44000000,0x100,0x74000000,0x0,0x740000e0,0x4000000,0x0,0x40000000,};
  final private int[] jj_la1_1 = {0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x74,0x74,0x0,0x74,0x800,0x74,0x0,0x1000,0x34,};

  public EC(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ECTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  public EC(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ECTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  public EC(ECTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  public void ReInit(ECTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[46];
    for (int i = 0; i < 46; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 27; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 46; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

};
