# This package is not relocatable
%define ver	0.6.5
%define date	20000217
%define prefix 	/usr
%define gsr 	%{prefix}/GNUstep
%define libcombo gnu-gnu-gnu-xgps
Name: 		gnustep-xgps
Version: 	%{ver}
Release: 	1
Source: 	ftp://ftp.gnustep.org/pub/gnustep/core/gstep-xgps-%{ver}.tar.gz
#Source: 	/cvs/gnustep-xgps-%{ver}-%{date}.tar.gz
Copyright: 	GPL
Group: 		System Environment/Libraries
Summary: 	GNUstep GUI X/GPS backend library package
Packager:	Christopher Seawood <cls@seawood.org>
Distribution:	Seawood's Random RPMS (%{_buildsym})
Vendor:		The Seawood Project
URL:		http://www.gnustep.org/
BuildRoot: 	/var/tmp/build-%{name}
Conflicts:	gnustep-core
Requires:	gnustep-gui, gnustep-base

%description
   The GNUstep GUI Library is designed in two parts.  The first part is
the front-end component which is independent of platform and display
system.  This front-end is combined with a back-end component which
handles all of the display system dependent such as specific calls to
X/Windows.  This design allows the GNUstep applications to have the
"look and feel" of the underlying display system without any changes to
the application, and the library can be easily ported to other display
systems.

Library combo is %{libcombo}.
%{_buildblurb}

%package devel
Summary: GNUstep GUI X/GPS headers and libs.
Group: Development/Libraries
Requires: %{name} = %{version}, gnustep-gui-devel, gnustep-base-devel
Conflicts: gnustep-core

%description devel
Header files required to build applications against the 
GNUstep GUI X/GPS library.
Library combo is %{libcombo}.
%{_buildblurb}

%prep
%setup -q -n gstep-%{ver}/xgps

%build
if [ -z "$GNUSTEP_SYSTEM_ROOT" ]; then
   . %{gsr}/Makefiles/GNUstep.sh 
fi
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{gsr} --with-library-combo=%{libcombo}
make

%install
rm -rf $RPM_BUILD_ROOT
if [ -z "$GNUSTEP_SYSTEM_ROOT" ]; then
   . %{gsr}/Makefiles/GNUstep.sh 
fi
make install GNUSTEP_INSTALLATION_DIR=${RPM_BUILD_ROOT}%{gsr}

cat > filelist.rpm.in << EOF
%defattr (-, bin, bin)
%doc COPYING* ChangeLog

%{gsr}/Libraries/GSARCH/GSOS/%{libcombo}/lib*.so.*
%{gsr}/Libraries/Resources/GNUstepSystemXFontList
%{gsr}/Tools/gpbs
%{gsr}/Tools/GSARCH/GSOS/%{libcombo}/gpbs

EOF

cat > filelist-devel.rpm.in  << EOF
%defattr(-, bin, bin)

%{gsr}/Headers/gnustep/xgps
%{gsr}/Libraries/GSARCH/GSOS/%{libcombo}/lib*.so

EOF

sed -e "s|GSARCH|${GNUSTEP_HOST_CPU}|" -e "s|GSOS|${GNUSTEP_HOST_OS}|" < filelist.rpm.in > filelist.rpm
sed -e "s|GSARCH|${GNUSTEP_HOST_CPU}|" -e "s|GSOS|${GNUSTEP_HOST_OS}|" < filelist-devel.rpm.in > filelist-devel.rpm

# Don't worry about ld.so.conf on linux as gnustep-base should take care of it.

%ifos Linux
%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files -f filelist.rpm
%files -f filelist-devel.rpm devel

%changelog
* Sat Sep 18 1999 Christopher Seawood <cls@seawood.org>
- Version 0.6.0

* Sat Aug 07 1999 Christopher Seawood <cls@seawood.org>
- Updated to cvs dawn_6 branch

* Sat Jun 26 1999 Christopher Seawood <cls@seawood.org>
- Initial rpm
- Build from cvs snapshot
- Split into main & -devel packages

