/* 
   textfield.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Ovidiu Predescu <ovidiu@net-community.com>
   Date: January 1997
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#import <Foundation/NSAutoreleasePool.h>
#import <AppKit/NSApplication.h>
#import <AppKit/NSButton.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSWindow.h>

@interface MyObject : NSObject
{
  id textfield;
}
@end

@implementation MyObject
- (void)buttonPressed:sender
{
  NSLog (@"textfield value = %@", [textfield stringValue]);
  [textfield setStringValue: @"Hello"];
}

- (void)setTextField:object
{
  textfield = object;
}

@end

int
main(int argc, char **argv, char** env)
{
    NSApplication *theApp;
    NSRect winRect = { {100, 100}, {300, 200} };
    NSRect textRect = { {50, 50}, {100, 20} };
    NSRect buttonRect = { { 51, 150 }, { 53, 20 } };
    NSTextField* textfield;
    NSWindow* mainWindow;
    id object;
    id button;
    id pool;

#if LIB_FOUNDATION_LIBRARY
  [NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif

  pool = [NSAutoreleasePool new];

#ifndef NX_CURRENT_COMPILER_RELEASE
    initialize_gnustep_backend();
#endif

    theApp = [NSApplication sharedApplication];

#if 0
    mainWindow = [[NSWindow alloc]
		    initWithContentRect:winRect
		    styleMask:NSTitledWindowMask
		    backing:NSBackingStoreNonretained
		    defer:NO];
#else
    mainWindow = [[NSWindow alloc] init];
#endif

    textfield = [[NSTextField alloc] initWithFrame:textRect];
    [textfield setStringValue:@"abcdefghijklmnopqrstuvwxyz"];
    [textfield setAlignment:NSCenterTextAlignment];
    [[mainWindow contentView] addSubview:textfield];

    object = [[MyObject new] autorelease];
    [object setTextField:textfield];

    button = [[NSButton alloc] initWithFrame:buttonRect];
    [button setButtonType:NSMomentaryPushButton];
    [[mainWindow contentView] addSubview:button];
    [button setTarget:object];
    [button setAction:@selector(buttonPressed:)];

    [mainWindow setFrame:winRect display: YES];
    [mainWindow makeKeyAndOrderFront:nil];
    [mainWindow display];

    [theApp run];

    [pool release];
    return 0;
}
