/* 
   testApp.m

   Simple test application

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: March 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#import <Foundation/NSAutoreleasePool.h>
#import <AppKit/AppKit.h>
#include "TestView.h"

int
main(int argc, char **argv, char** env)
{
    NSWindow *win;
    NSRect wf0 = {{0, 0}, {300, 500}};
    NSView *v;
    NSApplication *theApp;
    TestView *new_view;
    NSRect bf = {{100, 100}, {100, 100}};
    NSButton *b0;
    NSRect mf0 = {{25, 50}, {200, 500}};
    NSMatrix *mt0;
    NSTextField *t0, *t1, *t2, *t3;
    NSRect tf0 = {{25, 25}, {200, 50}};
    NSRect tf1 = {{25, 100}, {200, 50}};
    NSRect tf2 = {{25, 175}, {200, 50}};
    NSRect tf3 = {{25, 250}, {200, 50}};
    NSSliderCell *s0;
    NSRect sf0 = {{25, 325}, {100, 50}};
    id pool;

#if LIB_FOUNDATION_LIBRARY
  [NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif

  pool = [NSAutoreleasePool new];

#ifndef NX_CURRENT_COMPILER_RELEASE
    initialize_gnustep_backend();
#endif

    theApp = [NSApplication sharedApplication];

    NSLog(@"Create a window\n");
    win = [[NSWindow alloc] init];
    v = [win contentView];

    //    new_view = [[TestView alloc] init];
    //    [win setContentView: new_view];

    //    b0 = [[NSButton alloc] initWithFrame: bf];
    //    [[win contentView] addSubview: b0];

    //    [b0 setTitle: @"Hello"];

    t0 = [[NSTextField alloc] initWithFrame: tf0];
    t1 = [[NSTextField alloc] initWithFrame: tf1];
    [t1 setAlignment: NSRightTextAlignment];
    t2 = [[NSTextField alloc] initWithFrame: tf2];
    [t2 setAlignment: NSCenterTextAlignment];
    t3 = [[NSTextField alloc] initWithFrame: tf3];
    [t3 setBordered: NO];
    [t3 setTextColor: [NSColor redColor]];
    [t0 setNextText: t1];
    [t1 setNextText: t2];
    [t2 setNextText: t3];
    [t3 setNextText: t0];
    [v addSubview: t0];
    [v addSubview: t1];
    [v addSubview: t2];
    [v addSubview: t3];
    [win makeFirstResponder: t0];

    s0 = [[NSSlider alloc] initWithFrame: sf0];
    [v addSubview: s0];

    /*
    mt0 = [[NSMatrix alloc] initWithFrame: mf0 mode: NSHighlightModeMatrix
    			    cellClass: [NSButtonCell class]
    		    numberOfRows: 10 numberOfColumns: 3];
    mt0 = [[NSMatrix alloc] init];
    [[win contentView] addSubview: mt0];
    */

    [win setTitle:@"GNUstep GUI X/DPS Test Application"];
    [win setFrame: wf0 display: YES];
    [win orderFront:nil];

    NSLog(@"Run application\n");
    [theApp run];

    [pool release];

    return 0;
}
