/* 
   PXKColor.m

   NSColor for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Date: January 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <config.h>
#include <stdlib.h>

#include <gnustep/xdps/PXKColor.h>
#include <gnustep/xdps/PXKDPSContext.h>
#include <gnustep/xdps/PXKScreen.h>

//
// Backend structure for PXKColor
//
typedef struct _PXKColor_struct
{
  XColor color;
  BOOL is_alloced;
} PXKColor_struct;

#define PXKCOLOR (((PXKColor_struct *)be_color_reserved)->color)
#define PXKALLOC (((PXKColor_struct *)be_color_reserved)->is_alloced)

@implementation PXKColor (GNUstepXDPS)

- (XColor)xColor
{
  // If we haven't allocated it yet
  if (!PXKALLOC)
    {
      Display *xdis = [(PXKDPSContext *)[NSDPSContext currentContext] 
					xDisplay];
      int xscreen = [(PXKScreen *)[NSScreen mainScreen] xScreen];
      Status ret;

      // Copy values from the NSColor instance variables
      PXKCOLOR.red = (unsigned short)(65535 * RGB_component.red);
      PXKCOLOR.green = (unsigned short)(65535 * RGB_component.green);
      PXKCOLOR.blue = (unsigned short)(65535 * RGB_component.blue);

      // Allocate the color
      ret = XAllocColor(xdis, XDefaultColormap(xdis, xscreen), &PXKCOLOR);
      if (!ret)
	NSLog(@"Failed to allocate color\n");

      // Copy the actual values back to the NSColor variables
      RGB_component.red = ((float)PXKCOLOR.red) / 65535;
      RGB_component.green = ((float)PXKCOLOR.green) / 65535;
      RGB_component.blue = ((float)PXKCOLOR.blue) / 65535;

      PXKALLOC = YES;
    }

  return PXKCOLOR;
}

- (void)setXColor:(XColor)xcolor
{
  PXKCOLOR = xcolor;
}

@end

@implementation PXKColor

- init
{
  // Allocate backend structure
  be_color_reserved = malloc(sizeof(PXKColor_struct));
  PXKALLOC = NO;

  [super init];

  return self;
}

- (void)dealloc
{
  // Release backend structure
  free(be_color_reserved);

  [super dealloc];
}

- (void)set
{
  switch (active_component)
    {
    case GNUSTEP_GUI_RGB_ACTIVE:
      NSDebugLog(@"RGB %f %f %f\n", RGB_component.red,
		 RGB_component.green, RGB_component.blue);
      PSsetrgbcolor(RGB_component.red, RGB_component.green, 
		    RGB_component.blue);
      break;

    case GNUSTEP_GUI_CMYK_ACTIVE:
      NSDebugLog(@"CMYK %f %f %f %f\n", CMYK_component.cyan, 
		 CMYK_component.magenta,
		 CMYK_component.yellow, CMYK_component.black);
      PSsetcmykcolor(CMYK_component.cyan, CMYK_component.magenta,
		     CMYK_component.yellow, CMYK_component.black);
      break;

    case GNUSTEP_GUI_HSB_ACTIVE:
      NSDebugLog(@"HSB %f %f %f\n", HSB_component.hue,
		 HSB_component.saturation, HSB_component.brightness);
      PSsethsbcolor(HSB_component.hue, HSB_component.saturation,
		    HSB_component.brightness);
      break;

    case GNUSTEP_GUI_WHITE_ACTIVE:
      NSDebugLog(@"Gray %f\n", white_component);
      PSsetgray(white_component);
    }
}

- (Class) classForCoder: aCoder
{
  if ([self class] == [PXKColor class])
    return [super class];
  return [self class];
}

@end
