/* 
   PXKit.h

   High level include file for the GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: April 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_PXKit
#define _GNUstep_H_PXKit

/* Define this to avoid including redefinitions of ps functions introduced
   by GPSDrawContext (and gpsdefs.h) */
#define _gpsdefs_h_INCLUDE

#include <gnustep/xdps/stdpxk.h>
#include <AppKit/AppKit.h>

// Classes
@class PXKApplication;
@class PXKBitmapImageRep;
@class PXKBox;
@class PXKBrowser;
@class PXKBrowserCell;
@class PXKButton;
@class PXKButtonCell;
@class PXKCachedImageRep;
@class PXKCell;
@class PXKClipView;
@class PXKColor;
@class PXKColorList;
@class PXKColorPanel;
@class PXKColorPicker;
@class PXKColorWell;
@class PXKControl;
@class PXKCursor;
@class PXKCustomImageRep;
@class PXKDataLink;
@class PXKDataLinkManager;
@class PXKDataLinkPanel;
@class PXKDPSContext;
@class PXKEPSImageRep;
@class PXKFont;
@class PXKFontManager;
@class PXKFontPanel;
@class PXKForm;
@class PXKFormCell;
@class PXKHelpPanel;
@class PXKImage;
@class PXKImageRep;
@class PXKMenu;
@class PXKMenuItem;
@class PXKOpenPanel;
@class PXKPageLayout;
@class PXKPanel;
@class PXKPasteboard;
@class PXKPopUpButton;
@class PXKPrinter;
@class PXKPrintInfo;
@class PXKPrintOperation;
@class PXKPrintPanel;
@class PXKResponder;
@class PXKSavePanel;
@class PXKScreen;
@class PXKScroller;
@class PXKScrollView;
@class PXKSelection;
@class PXKSlider;
@class PXKSliderCell;
@class PXKSpellChecker;
@class PXKSpellServer;
@class PXKSplitView;
@class PXKText;
@class PXKTextField;
@class PXKTextFieldCell;
@class PXKView;
@class PXKWindow;
@class PXKWindowView;
@class PXKWorkspace;

// Class interfaces
#include <gnustep/xdps/PXKApplication.h>
#include <gnustep/xdps/PXKBitmapImageRep.h>
#include <gnustep/xdps/PXKBox.h>
#include <gnustep/xdps/PXKBrowser.h>
#include <gnustep/xdps/PXKBrowserCell.h>
#include <gnustep/xdps/PXKButton.h>
#include <gnustep/xdps/PXKButtonCell.h>
#include <gnustep/xdps/PXKCachedImageRep.h>
#include <gnustep/xdps/PXKCell.h>
#include <gnustep/xdps/PXKClipView.h>
#include <gnustep/xdps/PXKColor.h>
#include <gnustep/xdps/PXKColorList.h>
#include <gnustep/xdps/PXKColorPanel.h>
#include <gnustep/xdps/PXKColorPicker.h>
#include <gnustep/xdps/PXKColorWell.h>
#include <gnustep/xdps/PXKControl.h>
#include <gnustep/xdps/PXKCursor.h>
#include <gnustep/xdps/PXKCustomImageRep.h>
#include <gnustep/xdps/PXKDataLink.h>
#include <gnustep/xdps/PXKDataLinkManager.h>
#include <gnustep/xdps/PXKDataLinkPanel.h>
#include <gnustep/xdps/PXKDPSContext.h>
#include <gnustep/xdps/PXKEPSImageRep.h>
#include <gnustep/xdps/PXKFont.h>
#include <gnustep/xdps/PXKFontManager.h>
#include <gnustep/xdps/PXKFontPanel.h>
#include <gnustep/xdps/PXKForm.h>
#include <gnustep/xdps/PXKFormCell.h>
#include <gnustep/xdps/PXKHelpPanel.h>
#include <gnustep/xdps/PXKImage.h>
#include <gnustep/xdps/PXKImageRep.h>
#include <gnustep/xdps/PXKMenu.h>
#include <gnustep/xdps/PXKMenuItem.h>
#include <gnustep/xdps/PXKOpenPanel.h>
#include <gnustep/xdps/PXKPageLayout.h>
#include <gnustep/xdps/PXKPanel.h>
#include <gnustep/xdps/PXKPopUpButton.h>
#include <gnustep/xdps/PXKPrinter.h>
#include <gnustep/xdps/PXKPrintInfo.h>
#include <gnustep/xdps/PXKPrintOperation.h>
#include <gnustep/xdps/PXKPrintPanel.h>
#include <gnustep/xdps/PXKResponder.h>
#include <gnustep/xdps/PXKSavePanel.h>
#include <gnustep/xdps/PXKScreen.h>
#include <gnustep/xdps/PXKScroller.h>
#include <gnustep/xdps/PXKScrollView.h>
#include <gnustep/xdps/PXKSelection.h>
#include <gnustep/xdps/PXKSliderCell.h>
#include <gnustep/xdps/PXKSpellChecker.h>
#include <gnustep/xdps/PXKSpellServer.h>
#include <gnustep/xdps/PXKSplitView.h>
#include <gnustep/xdps/PXKText.h>
#include <gnustep/xdps/PXKTextField.h>
#include <gnustep/xdps/PXKTextFieldCell.h>
#include <gnustep/xdps/PXKView.h>
#include <gnustep/xdps/PXKWindow.h>
#include <gnustep/xdps/PXKWindowView.h>
#include <gnustep/xdps/PXKWorkspace.h>

#endif /* _GNUstep_H_PXKit */
