/*-------------------------------------------------------------------------*/
/* GNU Prolog                                                              */
/*                                                                         */
/* Part  : Prolog engine                                                   */
/* File  : machine.h                                                       */
/* Descr.: machine Dependent Features - Header file                        */
/* Author: Daniel Diaz                                                     */
/*                                                                         */
/* Copyright (C) 1999 Daniel Diaz                                          */
/*                                                                         */
/* GNU Prolog is free software; you can redistribute it and/or modify it   */
/* under the terms of the GNU General Public License as published by the   */
/* Free Software Foundation; either version 2, or any later version.       */
/*                                                                         */
/* GNU Prolog is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc.  */
/* 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     */
/*-------------------------------------------------------------------------*/

/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

#define M_SECURITY_MARGIN          128                      /* in WamWords */
#define M_MAGIC                    0x12345678




/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/

void      Init_Machine          (void);

void      M_Allocate_Stacks     (void);

char     *M_Sys_Err_String      (int err_no);

int       M_Shell               (char *cmd);

int       M_Spawn               (char *cmd,char *arg[]);

long      M_User_Time           (void);
long      M_System_Time         (void);
long      M_Real_Time           (void);

void      M_Randomize           (void);
void      M_Set_Seed            (int n);
int       M_Get_Seed            (void);
int       M_Random_Integer      (int n);
double    M_Random_Float        (double n);


char     *M_Host_Name_From_Name (char *host_name);
char     *M_Host_Name_From_Adr  (char *host_address);

char     *M_Get_Working_Dir     (void);
Bool      M_Set_Working_Dir     (char *path);

char     *M_Absolute_Path_Name  (char *src);



#ifdef M_USE_MALLOC

#define M_USE_MAGIC_NB_TO_DETECT_STACK_NAME
void      M_Check_Magic_Words   (void);

#endif
