// This is -*- C++ -*-
// $Id: parametric_estimation.h,v 1.4 1999/05/26 20:38:05 trow Exp $

/* 
 * parametric_estimation.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

/*

  Goose offers access to these functions for convenience, since it is
  sometimes convenient to be able to access this information directly,
  rather than having to build up some sort of RealSet object.  (Of course,
  the RealSet versions of these functions just call these guys, plugging
  in the appropriate values calculated from the data they contain.)

*/

#ifndef _INC_PARAMETRIC_ESTIMATION_H
#define _INC_PARAMETRIC_ESTIMATION_H

#include <ConfInt.h>
#include <RealSet.h>

/*
  Approximations for normally-distributed data.
*/

ConfInt pest_normal_mean(double mean, double sdev, size_t samples,
			       double conf);
ConfInt pest_normal_difference_of_means_equal_sdev(double mean1, double mean2,
						   double sdev,
						   size_t N1, size_t N2,
						   double conf);
ConfInt pest_normal_variance(double var, size_t samples, double conf);

ConfInt pest_normal_correlation(double r, size_t samples, double conf);


/*
  Different ways of estimating the probability of success from a sequence
  of trials.
*/

ConfInt pest_binomial_p_normal_approx(size_t sucesses, size_t trials,
				      double conf);
ConfInt pest_binomial_p_normal_approx_alt(size_t sucesses, size_t trials,
					  double conf);
ConfInt pest_binomial_p_arcsin_method(size_t sucesses, size_t trials,
				      double conf);

ConfInt pest_binomial_difference_of_p_normal_approx(size_t suc1, size_t suc2,
						    size_t tri1, size_t tri2,
						    double conf);


#endif // _INC_PARAMETRIC_ESTIMATION_H

// $Id: parametric_estimation.h,v 1.4 1999/05/26 20:38:05 trow Exp $
