// This is -*- C++ -*-
// $Id: StringSet.h,v 1.6 1999/05/26 20:56:39 hp Exp $

/* 
 * StringSet.h
 *
 * Copyright (C) 1998 Asger Alstrup Nielsen
 *
 * Developed by Asger Alstrup Nielsen <alstrup@diku.dk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _INC_STRINGSET_H
#define _INC_STRINGSET_H

#include <vector>
#include "DataSet.h"

/*
 * StringSet correctly derives from DataSet, not from DataSet_Typed<string>,
 * since it doesn't need a string->type translation layer.
 */

class StringSet : public DataSet {
public:
  static const DataSet::type_t typecode;

  StringSet() : DataSet(typecode) { }
  StringSet(const StringSet& s) : DataSet(typecode) { 
    data_ = s.data_; set_label(s.label());
  }
  ~StringSet() { }
  StringSet& operator=(const StringSet& s) {
    if (&s != this) 
      data_ = s.data_;
    return *this;
  }

  DataSet * clone() const {
    return new StringSet(*this);
  }

  bool support_missing() const { return true; }

  size_t size() const { return data_.size(); }
  void reserve(size_t N) { data_.reserve(N); } 
  void resize(size_t N);

  void add_string(const string& s) { data_.push_back(s); }
  void add_string_at(size_t i, const string& s) { data_.insert(data_.begin()+i, s); }
  void set_string(size_t i, const string& s) { data_[i] = s; }
  string as_string(size_t i) const { return data_[i]; }
  const string& get_string(size_t i) const { return data_[i]; }

  void remove(size_t i) { data_.erase(data_.begin() + i); }
  void remove(size_t b, size_t e) {
    data_.erase(data_.begin() + b, data_.begin() + e);
  }
  void clear() { data_.clear(); }

  void permute(const Permutation&);
  void scramble_explicit(Random&);
  void reverse();

  // Length of the longest string
  size_t max_length() const;

private:
  vector<string> data_;
};

#endif
