// This is -*- C++ -*-
// $Id: CategoricalSet.h,v 1.3 1999/04/09 19:42:43 trow Exp $

/* 
 * CategoricalSet.h
 *
 * Copyright (C) 1998 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef _INC_CATEGORICALSET_H
#define _INC_CATEGORICALSET_H

#include <RCArray.h>
#include <Permutation.h>
#include <Exception.h>
#include "DataSet.h"
#include "Category.h"

class CategoricalSet : public DataSet_Typed<catcode_t> {
public:
  CategoricalSet(const Category&);
  CategoricalSet(const CategoricalSet&);
  virtual ~CategoricalSet();

  CategoricalSet& operator=(const CategoricalSet&);

  const Category& category() const { return cat_; }

  size_t size() const { return data_.size(); }
  void reserve(size_t R);
  void resize(size_t N);

  void add(catcode_t);
  void add_at(size_t, catcode_t);
  void set(size_t, catcode_t);
  catcode_t data(size_t) const;

  void remove(size_t);
  void remove(size_t b, size_t e);
  void clear();
    
  void sort(int dir = 1);
  Permutation sorting_permutation(int dir = 1) const;
  void permute(const Permutation&);
  void scramble_explicit(Random&);
  void reverse();

  
  size_t frequency(catcode_t c) const { return freq_[c]; }
  double proportion(catcode_t c) const { return freq_[c]/(double)size(); }

  size_t string_frequency(const string& s) const {
    return frequency(from_string(s));
  }
  double string_proportion(const string& s) const {
    return proportion(from_string(s));
  }
  
protected:
  string to_string(catcode_t c) const { return cat_.convert(c); }
  catcode_t from_string(const string& s) const { return cat_.convert(s); }

private:
  Category cat_;
  RCArray<catcode_t> data_;
  vector<size_t> freq_;
};

#endif // _INC_CATEGORICALSET_H

// $Id: CategoricalSet.h,v 1.3 1999/04/09 19:42:43 trow Exp $
