// This is -*- C++ -*-
// $Id: shapiro_wilks.cpp,v 1.1 1999/03/31 21:20:42 trow Exp $

#include <iostream>
#include <Random.h>
#include <normality_testing.h>

// This is a test dataset from Madansky
double data[50] = {
  6.48875,
  7.70804,
  8.46150,
  12.75674,
  13.08055,
  13.43281,
  13.93881,
  15.03517,
  15.44101,
  15.75355,
  15.78501,
  16.65918,
  16.71427,
  17.42898,
  19.62610,
  19.78951,
  19.96001,
  20.04533,
  20.14921,
  20.62760,
  20.99996,
  21.00931,
  22.33860,
  22.87242,
  22.94075,
  23.23921,
  23.81423,
  24.15124,
  24.25881,
  25.24047,
  25.37080,
  26.48096,
  26.99283,
  28.29106,
  29.20037,
  29.56230,
  30.30640,
  30.57425,
  31.85266,
  32.70566,
  33.31204,
  33.35007,
  33.43215,
  34.05206,
  40.46576,
  45.79899,
  46.53636,
  47.08834,
  52.63478,
  52.84011 };

main()
{
  Random rng;
  RealSet rs;
  for(int i=0; i<50; ++i) {
    rs.add(data[i]);
  }

  cout << shapiro_wilks_royden_approx(rs) << endl;
}



// $Id: shapiro_wilks.cpp,v 1.1 1999/03/31 21:20:42 trow Exp $
