/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 */
#define FOUR  1
#define EIGHT 0
#define SYNC_VERSION        1
#define PULSE_VERSION       0

#include "VrFileSource.h"
#include "VrSigSource.h"
#include "VrDigMod.h"
#include "VrSyncFilter.h"
#include "VrPointSink.h"
#include "VrUDPSource.h"
#include "VrFileSink.h"
#include "VrAWGN.h"
#include "VrMultiTask.h"
#include "VrGUI.h"

#define DEFAULT_TPD	2600.0
int process_one = 1;
int persistent = 0;

VrSyncFilter<char>* filter;
VrAWGN<char>* noise;
int center_freq_mult = 4; //jca 4;
int out_rate = 400000; //400000;
int in_rate = 2000; //2000; 

void set_freq_offset(double f) {
  filter->setCenter_Freq(((center_freq_mult) * in_rate) - f);
}
void set_filter_taps(double t) {
  filter->setNumber_Taps((int)t);
}
void set_noise(double f) {
  noise->setSNR((int)f);
}

int main(int argc,char** argv)
{
  VrGUI *guimain = new VrGUI(argc, argv);
  float dummy;
  int dec = out_rate / in_rate;

  VrUDPSource<char>* source = new VrUDPSource<char>(out_rate, 5001);
  filter = new VrSyncFilter<char>(dec/2,50,
              (float)((center_freq_mult) * in_rate)-0.0,1.0/800.0);
  noise = new VrAWGN<char>();

  (void) VrGUISpace(guimain->top, 10);

  (void) VrGUILabel(guimain->top, "Signal constellation", 0, 30);
  VrPointSink* sink      = new VrPointSink(guimain->top, -2, 2, 100 ,1);
#if 0
  (void) new VrGUISlider(guimain->top, set_freq_offset, "Frequency error", -100.0, 100.0);
  (void) new VrGUISlider(guimain->top, set_filter_taps, "Filter Taps", 10.0, 200.0);
  (void) new VrGUISlider(guimain->top, set_noise, "SNR (dB)", 5.0, 72.0);
#endif
      
  NWO_CONNECT (source, noise);
  NWO_CONNECT (noise,  filter);
  NWO_CONNECT (filter, sink);

  VrMultiTask *m = new VrMultiTask();
  m->add(sink);  
  m->start(); 
  guimain->start();

  dummy = filter -> getSymbol_Period();
  cout << "Original period: " << dummy << endl;

  if(argc==2) filter -> setSymbol_Period(atof(argv[1]));
  if(argc==3) {
    filter -> setSymbol_Period(atof(argv[1]));
    filter -> setSymbol_Timing(atof(argv[2]));
  }

  while(1) {
 	guimain->processEvents(10 /*ms*/);
	if (1 || process_one) {
	  process_one = 0;
	  m->process();  
	}
  } /* while(1) */
}
