/* -*- Mode: c++ -*-
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRGUPPIBUFFER_H_
#define _VRGUPPIBUFFER_H_

#include <VrSigProc.h>
#include <VrConnect.h>
#include <VrBuffer.h>
#include <VrMUX.h>

template<class T> class VrGuppiBuffer : public VrBuffer {
private:
  int guppi_fd;
  //called from a downstream VrSigProc, via VrConnect
  virtual T *getReadPointer(VrSampleRange r);
public:
  VrGuppiBuffer(VrSigProc *m) : VrBuffer(m) { }
};

template<class T> T *
VrGuppiBuffer<T>::getReadPointer(VrSampleRange r); {
  int input = ((VrMUX<T> *) upstream)->inputSelected;
  VrBuffer<T> *b = upstream->outBuffer[input];
  return b->getReadPointer(r);
}
#endif
