/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#include <VrGuppiSource.h>
#include <VrFileSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>

int main(int argc, char **argv)
{
  int gupRate;
  int cTaps;
  
  int count=0;

  // VrGUI *guimain = new VrGUI(argc, argv);


  cTaps = 200;
  gupRate = 33000000;                        
 
  VrGuppiSource<char>* source = new VrGuppiSource<char>(gupRate);
  VrFileSink<char>* sink = new VrFileSink<char>("tmp.dat"); 

  NWO_CONNECT(source, sink);

  VrMultiTask *m = new VrMultiTask ();
  m->add (sink);
  m->start(); 
  // guimain->start(); 

printf ("start\n");

  while (count < 700) {
    // guimain->processEvents(10 /*ms*/);
    m->process();  
    count += 1;
  }  
  cout << "\nFinish taking " << count << " set of samples.\n";

}
