#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from GnuRadioPython import *


# Kludge to keep any flow graphs from ever being garbage collected.
# Can you say memory leak?  I knew you could ;-)
#
# There are currently unresolved storage management issues having to
# do with who owns an instance of a subclass of VrSigProc and how we
# tear down all the buffering, etc.  As long as a flow graph doesn't
# go away, neither do the sigprocs to which they're holding
# references.  

_all_flow_graphs = []


# Hand built wrapper for gr_FlowGraph that keeps around python references
# to all connected VrSigProcs.  Keeps us from having our modules reclaimed
# from under us

class gr_FlowGraph:
    def __init__(self):
        global _all_flow_graphs
        self.fg = gr_FlowGraph_real.make ()
        self.sigprocs = []
        _all_flow_graphs.append (self)
                                        
    def start(self):
        return self.fg.start ()
    def stop(self):
        return self.fg.stop ()
    def isRunning(self):
        return self.fg.isRunning ()
    def wait (self):
        return self.fg.wait ()
    def connect(self,src,dst):
        r = self.fg.connect (src, dst)
        self.__remember (src)
        self.__remember (dst)
        return r
    def connectn(self, src, src_port, dst):
        r = self.fg.connectn (src, src_port, dst)
        self.__remember (src)
        self.__remember (dst)
        return r
    def __remember (self, s):
        if s not in self.sigprocs:
            self.sigprocs.append (s)
